/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.transform;

import java.util.function.Consumer;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.LocalArgumentsVariable;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class BlockTransformation extends Transformation {
  /**
   * Name for capturing local-arguments-environment in distinct variable on entering a block.
   */
  public static final String $CAPTURE_ARGS = "$capturedArgs";
  
  @Override
  public void assertPreConditions() {
  }
  
  @Override
  public void assertPostConditions() {
  }
  
  @Override
  public void analyze() {
  }
  
  @Override
  public void transform() {
    final Consumer<FunctionOrFieldAccessor> _function = (FunctionOrFieldAccessor it) -> {
      this.transformArguments(it);
    };
    IterableExtensions.<FunctionOrFieldAccessor>toList(this.<FunctionOrFieldAccessor>collectNodes(this.getState().im, FunctionOrFieldAccessor.class, true)).forEach(_function);
  }
  
  /**
   * capture arguments-variable to be accessible in re-written arrow-functions
   */
  private void transformArguments(final FunctionOrFieldAccessor funcOrAccess) {
    final LocalArgumentsVariable loc_Arg = funcOrAccess.get_lok();
    if ((loc_Arg == null)) {
      return;
    }
    final String newName = BlockTransformation.$CAPTURE_ARGS;
    final SymbolTableEntry arguments_STE = this.findSymbolTableEntryForElement(loc_Arg, false);
    if (((arguments_STE == null) || arguments_STE.getReferencingElements().isEmpty())) {
      return;
    }
    this.rename(arguments_STE, newName);
    if ((funcOrAccess instanceof ArrowFunction)) {
      return;
    }
    boolean _isEmpty = funcOrAccess.getBody().getStatements().isEmpty();
    if (_isEmpty) {
      return;
    }
    final Statement bodyFirstStatement = funcOrAccess.getBody().getStatements().get(0);
    final SymbolTableEntryInternal argumentsSTE = this.steFor_arguments();
    this.insertBefore(bodyFirstStatement, 
      TranspilerBuilderBlocks._VariableStatement(TranspilerBuilderBlocks._VariableDeclaration(newName, TranspilerBuilderBlocks._IdentRef(argumentsSTE))));
  }
}
