/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.contentassist.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import org.antlr.runtime.RecognitionException;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ui.contentassist.antlr.internal.InternalN4JSParser;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.AbstractContentAssistParser;
import org.eclipse.xtext.ide.editor.contentassist.antlr.FollowElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;

public class N4JSParser extends AbstractContentAssistParser {

	@Singleton
	public static final class NameMappings {
		
		private final Map<AbstractElement, String> mappings;
		
		@Inject
		public NameMappings(N4JSGrammarAccess grammarAccess) {
			ImmutableMap.Builder<AbstractElement, String> builder = ImmutableMap.builder();
			init(builder, grammarAccess);
			this.mappings = builder.build();
		}
		
		public String getRuleName(AbstractElement element) {
			return mappings.get(element);
		}
		
		private static void init(ImmutableMap.Builder<AbstractElement, String> builder, N4JSGrammarAccess grammarAccess) {
			builder.put(grammarAccess.getScriptAccess().getAlternatives_1(), "rule__Script__Alternatives_1");
			builder.put(grammarAccess.getScriptElementAccess().getAlternatives(), "rule__ScriptElement__Alternatives");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getAlternatives_1(), "rule__AnnotatedScriptElement__Alternatives_1");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getAlternatives_1_3_0(), "rule__AnnotatedScriptElement__Alternatives_1_3_0");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getAlternatives_1(), "rule__ExportDeclarationImpl__Alternatives_1");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getAlternatives_1_3_1(), "rule__ExportDeclarationImpl__Alternatives_1_3_1");
			builder.put(grammarAccess.getExportableElementAccess().getAlternatives(), "rule__ExportableElement__Alternatives");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getAlternatives_1(), "rule__AnnotatedExportableElement__Alternatives_1");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getAlternatives_1_2_0(), "rule__AnnotatedExportableElement__Alternatives_1_2_0");
			builder.put(grammarAccess.getImportClauseAccess().getAlternatives(), "rule__ImportClause__Alternatives");
			builder.put(grammarAccess.getImportSpecifiersExceptDefaultAccess().getAlternatives(), "rule__ImportSpecifiersExceptDefault__Alternatives");
			builder.put(grammarAccess.getNamedImportSpecifierAccess().getAlternatives(), "rule__NamedImportSpecifier__Alternatives");
			builder.put(grammarAccess.getFunctionImplAccess().getAlternatives_1(), "rule__FunctionImpl__Alternatives_1");
			builder.put(grammarAccess.getArrowExpressionAccess().getAlternatives_0_0_0(), "rule__ArrowExpression__Alternatives_0_0_0");
			builder.put(grammarAccess.getArrowExpressionAccess().getAlternatives_1(), "rule__ArrowExpression__Alternatives_1");
			builder.put(grammarAccess.getAnnotatedExpressionAccess().getAlternatives_1(), "rule__AnnotatedExpression__Alternatives_1");
			builder.put(grammarAccess.getTypeVariableAccess().getAlternatives_0(), "rule__TypeVariable__Alternatives_0");
			builder.put(grammarAccess.getBindingElementFragmentAccess().getAlternatives_0(), "rule__BindingElementFragment__Alternatives_0");
			builder.put(grammarAccess.getRootStatementAccess().getAlternatives(), "rule__RootStatement__Alternatives");
			builder.put(grammarAccess.getStatementAccess().getAlternatives(), "rule__Statement__Alternatives");
			builder.put(grammarAccess.getVariableDeclarationOrBindingAccess().getAlternatives(), "rule__VariableDeclarationOrBinding__Alternatives");
			builder.put(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getAlternatives(), "rule__ExportedVariableDeclarationOrBinding__Alternatives");
			builder.put(grammarAccess.getIterationStatementAccess().getAlternatives(), "rule__IterationStatement__Alternatives");
			builder.put(grammarAccess.getForStatementAccess().getAlternatives_3(), "rule__ForStatement__Alternatives_3");
			builder.put(grammarAccess.getForStatementAccess().getAlternatives_3_1_0(), "rule__ForStatement__Alternatives_3_1_0");
			builder.put(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1(), "rule__ForStatement__Alternatives_3_1_0_0_1");
			builder.put(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1_0_0_1(), "rule__ForStatement__Alternatives_3_1_0_0_1_0_0_1");
			builder.put(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_0_1_1_1(), "rule__ForStatement__Alternatives_3_1_0_0_1_1_1");
			builder.put(grammarAccess.getForStatementAccess().getAlternatives_3_1_0_1_1(), "rule__ForStatement__Alternatives_3_1_0_1_1");
			builder.put(grammarAccess.getTryStatementAccess().getAlternatives_2(), "rule__TryStatement__Alternatives_2");
			builder.put(grammarAccess.getCatchVariableAccess().getAlternatives(), "rule__CatchVariable__Alternatives");
			builder.put(grammarAccess.getPrimaryExpressionAccess().getAlternatives(), "rule__PrimaryExpression__Alternatives");
			builder.put(grammarAccess.getIdentifierRefAccess().getAlternatives(), "rule__IdentifierRef__Alternatives");
			builder.put(grammarAccess.getPropertyAssignmentAccess().getAlternatives(), "rule__PropertyAssignment__Alternatives");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getAlternatives_1(), "rule__AnnotatedPropertyAssignment__Alternatives_1");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getAlternatives_1_3_0_0_3(), "rule__AnnotatedPropertyAssignment__Alternatives_1_3_0_0_3");
			builder.put(grammarAccess.getPropertyMethodDeclarationAccess().getAlternatives_0_0_3(), "rule__PropertyMethodDeclaration__Alternatives_0_0_3");
			builder.put(grammarAccess.getLeftHandSideExpressionAccess().getAlternatives_1_2(), "rule__LeftHandSideExpression__Alternatives_1_2");
			builder.put(grammarAccess.getMemberExpressionAccess().getAlternatives(), "rule__MemberExpression__Alternatives");
			builder.put(grammarAccess.getMemberExpressionAccess().getAlternatives_1_3_3(), "rule__MemberExpression__Alternatives_1_3_3");
			builder.put(grammarAccess.getMemberExpressionAccess().getAlternatives_2_1(), "rule__MemberExpression__Alternatives_2_1");
			builder.put(grammarAccess.getUnaryExpressionAccess().getAlternatives(), "rule__UnaryExpression__Alternatives");
			builder.put(grammarAccess.getShiftOperatorAccess().getAlternatives(), "rule__ShiftOperator__Alternatives");
			builder.put(grammarAccess.getRelationalOperatorAccess().getAlternatives(), "rule__RelationalOperator__Alternatives");
			builder.put(grammarAccess.getAssignmentExpressionAccess().getAlternatives(), "rule__AssignmentExpression__Alternatives");
			builder.put(grammarAccess.getAssignmentOperatorAccess().getAlternatives(), "rule__AssignmentOperator__Alternatives");
			builder.put(grammarAccess.getTemplateLiteralAccess().getAlternatives_1(), "rule__TemplateLiteral__Alternatives_1");
			builder.put(grammarAccess.getLiteralAccess().getAlternatives(), "rule__Literal__Alternatives");
			builder.put(grammarAccess.getBooleanLiteralAccess().getAlternatives_1(), "rule__BooleanLiteral__Alternatives_1");
			builder.put(grammarAccess.getNumericLiteralAccess().getAlternatives(), "rule__NumericLiteral__Alternatives");
			builder.put(grammarAccess.getNumericLiteralAsStringAccess().getAlternatives(), "rule__NumericLiteralAsString__Alternatives");
			builder.put(grammarAccess.getIdentifierOrThisAccess().getAlternatives(), "rule__IdentifierOrThis__Alternatives");
			builder.put(grammarAccess.getAnnotationNameAccess().getAlternatives(), "rule__AnnotationName__Alternatives");
			builder.put(grammarAccess.getREGEX_LITERALAccess().getAlternatives_0(), "rule__REGEX_LITERAL__Alternatives_0");
			builder.put(grammarAccess.getAnnotationArgumentAccess().getAlternatives(), "rule__AnnotationArgument__Alternatives");
			builder.put(grammarAccess.getTypeRefForCastAccess().getAlternatives(), "rule__TypeRefForCast__Alternatives");
			builder.put(grammarAccess.getTypeReferenceNameAccess().getAlternatives(), "rule__TypeReferenceName__Alternatives");
			builder.put(grammarAccess.getClassExtendsImplementsAccess().getAlternatives(), "rule__ClassExtendsImplements__Alternatives");
			builder.put(grammarAccess.getClassExtendsClauseAccess().getAlternatives_1(), "rule__ClassExtendsClause__Alternatives_1");
			builder.put(grammarAccess.getInterfaceExtendsListAccess().getAlternatives_0(), "rule__InterfaceExtendsList__Alternatives_0");
			builder.put(grammarAccess.getN4MemberDeclarationAccess().getAlternatives(), "rule__N4MemberDeclaration__Alternatives");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getAlternatives_1(), "rule__AnnotatedN4MemberDeclaration__Alternatives_1");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getAlternatives_1_2_0_0_4(), "rule__AnnotatedN4MemberDeclaration__Alternatives_1_2_0_0_4");
			builder.put(grammarAccess.getN4MethodDeclarationAccess().getAlternatives_0_0_4(), "rule__N4MethodDeclaration__Alternatives_0_0_4");
			builder.put(grammarAccess.getBindingPatternAccess().getAlternatives(), "rule__BindingPattern__Alternatives");
			builder.put(grammarAccess.getBindingPropertyAccess().getAlternatives(), "rule__BindingProperty__Alternatives");
			builder.put(grammarAccess.getBindingElementImplAccess().getAlternatives(), "rule__BindingElementImpl__Alternatives");
			builder.put(grammarAccess.getLiteralOrComputedPropertyNameAccess().getAlternatives(), "rule__LiteralOrComputedPropertyName__Alternatives");
			builder.put(grammarAccess.getJSXElementAccess().getAlternatives_3(), "rule__JSXElement__Alternatives_3");
			builder.put(grammarAccess.getJSXFragmentAccess().getAlternatives(), "rule__JSXFragment__Alternatives");
			builder.put(grammarAccess.getJSXChildAccess().getAlternatives(), "rule__JSXChild__Alternatives");
			builder.put(grammarAccess.getJSXAttributeAccess().getAlternatives(), "rule__JSXAttribute__Alternatives");
			builder.put(grammarAccess.getJSXPropertyAttributeAccess().getAlternatives_1_1(), "rule__JSXPropertyAttribute__Alternatives_1_1");
			builder.put(grammarAccess.getPrimaryTypeExpressionAccess().getAlternatives(), "rule__PrimaryTypeExpression__Alternatives");
			builder.put(grammarAccess.getTypeRefWithoutModifiersAccess().getAlternatives(), "rule__TypeRefWithoutModifiers__Alternatives");
			builder.put(grammarAccess.getTypeRefWithoutModifiersAccess().getAlternatives_0_0(), "rule__TypeRefWithoutModifiers__Alternatives_0_0");
			builder.put(grammarAccess.getTypeRefFunctionTypeExpressionAccess().getAlternatives(), "rule__TypeRefFunctionTypeExpression__Alternatives");
			builder.put(grammarAccess.getTypeArgInTypeTypeRefAccess().getAlternatives(), "rule__TypeArgInTypeTypeRef__Alternatives");
			builder.put(grammarAccess.getThisTypeRefAccess().getAlternatives(), "rule__ThisTypeRef__Alternatives");
			builder.put(grammarAccess.getTAnonymousFormalParameterAccess().getAlternatives_1(), "rule__TAnonymousFormalParameter__Alternatives_1");
			builder.put(grammarAccess.getParameterizedTypeRefAccess().getAlternatives(), "rule__ParameterizedTypeRef__Alternatives");
			builder.put(grammarAccess.getParameterizedTypeRefNominalAccess().getAlternatives_0(), "rule__ParameterizedTypeRefNominal__Alternatives_0");
			builder.put(grammarAccess.getParameterizedTypeRefStructuralAccess().getAlternatives_0(), "rule__ParameterizedTypeRefStructural__Alternatives_0");
			builder.put(grammarAccess.getTStructMemberListAccess().getAlternatives_1_1(), "rule__TStructMemberList__Alternatives_1_1");
			builder.put(grammarAccess.getTStructMemberAccess().getAlternatives(), "rule__TStructMember__Alternatives");
			builder.put(grammarAccess.getTypingStrategyUseSiteOperatorAccess().getAlternatives_1(), "rule__TypingStrategyUseSiteOperator__Alternatives_1");
			builder.put(grammarAccess.getTypeTypeRefAccess().getAlternatives_1(), "rule__TypeTypeRef__Alternatives_1");
			builder.put(grammarAccess.getTypeArgumentAccess().getAlternatives(), "rule__TypeArgument__Alternatives");
			builder.put(grammarAccess.getWildcardAccess().getAlternatives_1(), "rule__Wildcard__Alternatives_1");
			builder.put(grammarAccess.getWildcardNewNotationAccess().getAlternatives(), "rule__WildcardNewNotation__Alternatives");
			builder.put(grammarAccess.getBindingIdentifierAccess().getAlternatives(), "rule__BindingIdentifier__Alternatives");
			builder.put(grammarAccess.getIdentifierNameAccess().getAlternatives(), "rule__IdentifierName__Alternatives");
			builder.put(grammarAccess.getReservedWordAccess().getAlternatives(), "rule__ReservedWord__Alternatives");
			builder.put(grammarAccess.getN4KeywordAccess().getAlternatives(), "rule__N4Keyword__Alternatives");
			builder.put(grammarAccess.getVariableStatementKeywordAccess().getAlternatives(), "rule__VariableStatementKeyword__Alternatives");
			builder.put(grammarAccess.getPostfixOperatorAccess().getAlternatives(), "rule__PostfixOperator__Alternatives");
			builder.put(grammarAccess.getUnaryOperatorAccess().getAlternatives(), "rule__UnaryOperator__Alternatives");
			builder.put(grammarAccess.getMultiplicativeOperatorAccess().getAlternatives(), "rule__MultiplicativeOperator__Alternatives");
			builder.put(grammarAccess.getAdditiveOperatorAccess().getAlternatives(), "rule__AdditiveOperator__Alternatives");
			builder.put(grammarAccess.getEqualityOperatorAccess().getAlternatives(), "rule__EqualityOperator__Alternatives");
			builder.put(grammarAccess.getN4ModifierAccess().getAlternatives(), "rule__N4Modifier__Alternatives");
			builder.put(grammarAccess.getScriptAccess().getGroup(), "rule__Script__Group__0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getGroup(), "rule__AnnotatedScriptElement__Group__0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_0(), "rule__AnnotatedScriptElement__Group_1_0__0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_1(), "rule__AnnotatedScriptElement__Group_1_1__0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_2(), "rule__AnnotatedScriptElement__Group_1_2__0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_2_1(), "rule__AnnotatedScriptElement__Group_1_2_1__0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_2_1_0(), "rule__AnnotatedScriptElement__Group_1_2_1_0__0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3(), "rule__AnnotatedScriptElement__Group_1_3__0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3_0_0(), "rule__AnnotatedScriptElement__Group_1_3_0_0__0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_3_0_1(), "rule__AnnotatedScriptElement__Group_1_3_0_1__0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_4(), "rule__AnnotatedScriptElement__Group_1_4__0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getGroup_1_4_7(), "rule__AnnotatedScriptElement__Group_1_4_7__0");
			builder.put(grammarAccess.getExportDeclarationAccess().getGroup(), "rule__ExportDeclaration__Group__0");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getGroup(), "rule__ExportDeclarationImpl__Group__0");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getGroup_1_0(), "rule__ExportDeclarationImpl__Group_1_0__0");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getGroup_1_1(), "rule__ExportDeclarationImpl__Group_1_1__0");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getGroup_1_3(), "rule__ExportDeclarationImpl__Group_1_3__0");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getGroup_1_3_1_1(), "rule__ExportDeclarationImpl__Group_1_3_1_1__0");
			builder.put(grammarAccess.getExportFromClauseAccess().getGroup(), "rule__ExportFromClause__Group__0");
			builder.put(grammarAccess.getExportClauseAccess().getGroup(), "rule__ExportClause__Group__0");
			builder.put(grammarAccess.getExportClauseAccess().getGroup_1(), "rule__ExportClause__Group_1__0");
			builder.put(grammarAccess.getExportClauseAccess().getGroup_1_1(), "rule__ExportClause__Group_1_1__0");
			builder.put(grammarAccess.getExportSpecifierAccess().getGroup(), "rule__ExportSpecifier__Group__0");
			builder.put(grammarAccess.getExportSpecifierAccess().getGroup_1(), "rule__ExportSpecifier__Group_1__0");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getGroup(), "rule__AnnotatedExportableElement__Group__0");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_0(), "rule__AnnotatedExportableElement__Group_1_0__0");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_1(), "rule__AnnotatedExportableElement__Group_1_1__0");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_1_4(), "rule__AnnotatedExportableElement__Group_1_1_4__0");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2(), "rule__AnnotatedExportableElement__Group_1_2__0");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2_0_0(), "rule__AnnotatedExportableElement__Group_1_2_0_0__0");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_2_0_1(), "rule__AnnotatedExportableElement__Group_1_2_0_1__0");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_3(), "rule__AnnotatedExportableElement__Group_1_3__0");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getGroup_1_3_6(), "rule__AnnotatedExportableElement__Group_1_3_6__0");
			builder.put(grammarAccess.getImportDeclarationAccess().getGroup(), "rule__ImportDeclaration__Group__0");
			builder.put(grammarAccess.getImportDeclarationImplAccess().getGroup(), "rule__ImportDeclarationImpl__Group__0");
			builder.put(grammarAccess.getImportDeclarationImplAccess().getGroup_1(), "rule__ImportDeclarationImpl__Group_1__0");
			builder.put(grammarAccess.getImportClauseAccess().getGroup_0(), "rule__ImportClause__Group_0__0");
			builder.put(grammarAccess.getImportClauseAccess().getGroup_0_1(), "rule__ImportClause__Group_0_1__0");
			builder.put(grammarAccess.getImportSpecifiersExceptDefaultAccess().getGroup_1(), "rule__ImportSpecifiersExceptDefault__Group_1__0");
			builder.put(grammarAccess.getImportSpecifiersExceptDefaultAccess().getGroup_1_1(), "rule__ImportSpecifiersExceptDefault__Group_1_1__0");
			builder.put(grammarAccess.getImportSpecifiersExceptDefaultAccess().getGroup_1_1_1(), "rule__ImportSpecifiersExceptDefault__Group_1_1_1__0");
			builder.put(grammarAccess.getNamedImportSpecifierAccess().getGroup_1(), "rule__NamedImportSpecifier__Group_1__0");
			builder.put(grammarAccess.getNamespaceImportSpecifierAccess().getGroup(), "rule__NamespaceImportSpecifier__Group__0");
			builder.put(grammarAccess.getFunctionDeclarationAccess().getGroup(), "rule__FunctionDeclaration__Group__0");
			builder.put(grammarAccess.getFunctionDeclarationAccess().getGroup_0(), "rule__FunctionDeclaration__Group_0__0");
			builder.put(grammarAccess.getFunctionDeclarationAccess().getGroup_0_0(), "rule__FunctionDeclaration__Group_0_0__0");
			builder.put(grammarAccess.getAsyncNoTrailingLineBreakAccess().getGroup(), "rule__AsyncNoTrailingLineBreak__Group__0");
			builder.put(grammarAccess.getFunctionImplAccess().getGroup(), "rule__FunctionImpl__Group__0");
			builder.put(grammarAccess.getFunctionImplAccess().getGroup_1_0(), "rule__FunctionImpl__Group_1_0__0");
			builder.put(grammarAccess.getFunctionImplAccess().getGroup_1_1(), "rule__FunctionImpl__Group_1_1__0");
			builder.put(grammarAccess.getFunctionHeaderAccess().getGroup(), "rule__FunctionHeader__Group__0");
			builder.put(grammarAccess.getAnnotatedFunctionDeclarationAccess().getGroup(), "rule__AnnotatedFunctionDeclaration__Group__0");
			builder.put(grammarAccess.getFunctionExpressionAccess().getGroup(), "rule__FunctionExpression__Group__0");
			builder.put(grammarAccess.getAsyncFunctionExpressionAccess().getGroup(), "rule__AsyncFunctionExpression__Group__0");
			builder.put(grammarAccess.getAsyncFunctionExpressionAccess().getGroup_0(), "rule__AsyncFunctionExpression__Group_0__0");
			builder.put(grammarAccess.getAsyncFunctionExpressionAccess().getGroup_0_0(), "rule__AsyncFunctionExpression__Group_0_0__0");
			builder.put(grammarAccess.getArrowExpressionAccess().getGroup(), "rule__ArrowExpression__Group__0");
			builder.put(grammarAccess.getArrowExpressionAccess().getGroup_0(), "rule__ArrowExpression__Group_0__0");
			builder.put(grammarAccess.getArrowExpressionAccess().getGroup_0_0(), "rule__ArrowExpression__Group_0_0__0");
			builder.put(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_0(), "rule__ArrowExpression__Group_0_0_0_0__0");
			builder.put(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1(), "rule__ArrowExpression__Group_0_0_0_1__0");
			builder.put(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0(), "rule__ArrowExpression__Group_0_0_0_1_0__0");
			builder.put(grammarAccess.getArrowExpressionAccess().getGroup_0_0_0_1_0_0(), "rule__ArrowExpression__Group_0_0_0_1_0_0__0");
			builder.put(grammarAccess.getArrowExpressionAccess().getGroup_1_0(), "rule__ArrowExpression__Group_1_0__0");
			builder.put(grammarAccess.getStrictFormalParametersAccess().getGroup(), "rule__StrictFormalParameters__Group__0");
			builder.put(grammarAccess.getStrictFormalParametersAccess().getGroup_1(), "rule__StrictFormalParameters__Group_1__0");
			builder.put(grammarAccess.getStrictFormalParametersAccess().getGroup_1_1(), "rule__StrictFormalParameters__Group_1_1__0");
			builder.put(grammarAccess.getBlockMinusBracesAccess().getGroup(), "rule__BlockMinusBraces__Group__0");
			builder.put(grammarAccess.getExpressionDisguisedAsBlockAccess().getGroup(), "rule__ExpressionDisguisedAsBlock__Group__0");
			builder.put(grammarAccess.getAnnotatedExpressionAccess().getGroup(), "rule__AnnotatedExpression__Group__0");
			builder.put(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_0(), "rule__AnnotatedExpression__Group_1_0__0");
			builder.put(grammarAccess.getAnnotatedExpressionAccess().getGroup_1_1(), "rule__AnnotatedExpression__Group_1_1__0");
			builder.put(grammarAccess.getTypeVariableAccess().getGroup(), "rule__TypeVariable__Group__0");
			builder.put(grammarAccess.getTypeVariableAccess().getGroup_2(), "rule__TypeVariable__Group_2__0");
			builder.put(grammarAccess.getFormalParameterAccess().getGroup(), "rule__FormalParameter__Group__0");
			builder.put(grammarAccess.getBindingElementFragmentAccess().getGroup(), "rule__BindingElementFragment__Group__0");
			builder.put(grammarAccess.getBindingElementFragmentAccess().getGroup_0_1(), "rule__BindingElementFragment__Group_0_1__0");
			builder.put(grammarAccess.getBindingElementFragmentAccess().getGroup_1(), "rule__BindingElementFragment__Group_1__0");
			builder.put(grammarAccess.getBlockAccess().getGroup(), "rule__Block__Group__0");
			builder.put(grammarAccess.getBlockAccess().getGroup_0(), "rule__Block__Group_0__0");
			builder.put(grammarAccess.getBlockAccess().getGroup_0_0(), "rule__Block__Group_0_0__0");
			builder.put(grammarAccess.getVariableStatementAccess().getGroup(), "rule__VariableStatement__Group__0");
			builder.put(grammarAccess.getVariableStatementAccess().getGroup_0(), "rule__VariableStatement__Group_0__0");
			builder.put(grammarAccess.getVariableStatementAccess().getGroup_0_0(), "rule__VariableStatement__Group_0_0__0");
			builder.put(grammarAccess.getVariableStatementAccess().getGroup_2(), "rule__VariableStatement__Group_2__0");
			builder.put(grammarAccess.getExportedVariableStatementAccess().getGroup(), "rule__ExportedVariableStatement__Group__0");
			builder.put(grammarAccess.getExportedVariableStatementAccess().getGroup_4(), "rule__ExportedVariableStatement__Group_4__0");
			builder.put(grammarAccess.getVariableBindingAccess().getGroup(), "rule__VariableBinding__Group__0");
			builder.put(grammarAccess.getVariableBindingAccess().getGroup_1_1(), "rule__VariableBinding__Group_1_1__0");
			builder.put(grammarAccess.getVariableBindingAccess().getGroup_1_0_0(), "rule__VariableBinding__Group_1_0_0__0");
			builder.put(grammarAccess.getVariableDeclarationAccess().getGroup(), "rule__VariableDeclaration__Group__0");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getGroup(), "rule__VariableDeclarationImpl__Group__0");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1(), "rule__VariableDeclarationImpl__Group_1_1__0");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_0(), "rule__VariableDeclarationImpl__Group_1_1_0__0");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_1_1(), "rule__VariableDeclarationImpl__Group_1_1_1__0");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0(), "rule__VariableDeclarationImpl__Group_1_0__0");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0(), "rule__VariableDeclarationImpl__Group_1_0_0__0");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_0_0(), "rule__VariableDeclarationImpl__Group_1_0_0_0__0");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getGroup_1_0_1(), "rule__VariableDeclarationImpl__Group_1_0_1__0");
			builder.put(grammarAccess.getExportedVariableBindingAccess().getGroup(), "rule__ExportedVariableBinding__Group__0");
			builder.put(grammarAccess.getExportedVariableDeclarationAccess().getGroup(), "rule__ExportedVariableDeclaration__Group__0");
			builder.put(grammarAccess.getEmptyStatementAccess().getGroup(), "rule__EmptyStatement__Group__0");
			builder.put(grammarAccess.getExpressionStatementAccess().getGroup(), "rule__ExpressionStatement__Group__0");
			builder.put(grammarAccess.getIfStatementAccess().getGroup(), "rule__IfStatement__Group__0");
			builder.put(grammarAccess.getIfStatementAccess().getGroup_5(), "rule__IfStatement__Group_5__0");
			builder.put(grammarAccess.getDoStatementAccess().getGroup(), "rule__DoStatement__Group__0");
			builder.put(grammarAccess.getWhileStatementAccess().getGroup(), "rule__WhileStatement__Group__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup(), "rule__ForStatement__Group__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_0(), "rule__ForStatement__Group_3_0__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_0_0(), "rule__ForStatement__Group_3_0_0__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1(), "rule__ForStatement__Group_3_1__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_0(), "rule__ForStatement__Group_3_1_0_0__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0(), "rule__ForStatement__Group_3_1_0_0_1_0__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_0_0(), "rule__ForStatement__Group_3_1_0_0_1_0_0__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1(), "rule__ForStatement__Group_3_1_0_0_1_1__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0(), "rule__ForStatement__Group_3_1_0_0_1_1_1_0__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_0_0(), "rule__ForStatement__Group_3_1_0_0_1_1_1_0_0__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_1(), "rule__ForStatement__Group_3_1_0_0_1_1_1_1__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_0_1_1_1_2(), "rule__ForStatement__Group_3_1_0_0_1_1_1_2__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_1(), "rule__ForStatement__Group_3_1_0_1__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_0(), "rule__ForStatement__Group_3_1_0_1_1_0__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_1(), "rule__ForStatement__Group_3_1_0_1_1_1__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_1_1_2(), "rule__ForStatement__Group_3_1_0_1_1_2__0");
			builder.put(grammarAccess.getForStatementAccess().getGroup_3_1_0_2(), "rule__ForStatement__Group_3_1_0_2__0");
			builder.put(grammarAccess.getContinueStatementAccess().getGroup(), "rule__ContinueStatement__Group__0");
			builder.put(grammarAccess.getBreakStatementAccess().getGroup(), "rule__BreakStatement__Group__0");
			builder.put(grammarAccess.getReturnStatementAccess().getGroup(), "rule__ReturnStatement__Group__0");
			builder.put(grammarAccess.getWithStatementAccess().getGroup(), "rule__WithStatement__Group__0");
			builder.put(grammarAccess.getSwitchStatementAccess().getGroup(), "rule__SwitchStatement__Group__0");
			builder.put(grammarAccess.getSwitchStatementAccess().getGroup_6(), "rule__SwitchStatement__Group_6__0");
			builder.put(grammarAccess.getCaseClauseAccess().getGroup(), "rule__CaseClause__Group__0");
			builder.put(grammarAccess.getDefaultClauseAccess().getGroup(), "rule__DefaultClause__Group__0");
			builder.put(grammarAccess.getLabelledStatementAccess().getGroup(), "rule__LabelledStatement__Group__0");
			builder.put(grammarAccess.getLabelledStatementAccess().getGroup_0(), "rule__LabelledStatement__Group_0__0");
			builder.put(grammarAccess.getLabelledStatementAccess().getGroup_0_0(), "rule__LabelledStatement__Group_0_0__0");
			builder.put(grammarAccess.getThrowStatementAccess().getGroup(), "rule__ThrowStatement__Group__0");
			builder.put(grammarAccess.getTryStatementAccess().getGroup(), "rule__TryStatement__Group__0");
			builder.put(grammarAccess.getTryStatementAccess().getGroup_2_0(), "rule__TryStatement__Group_2_0__0");
			builder.put(grammarAccess.getCatchBlockAccess().getGroup(), "rule__CatchBlock__Group__0");
			builder.put(grammarAccess.getCatchVariableAccess().getGroup_1(), "rule__CatchVariable__Group_1__0");
			builder.put(grammarAccess.getCatchVariableAccess().getGroup_1_0(), "rule__CatchVariable__Group_1_0__0");
			builder.put(grammarAccess.getCatchVariableAccess().getGroup_2(), "rule__CatchVariable__Group_2__0");
			builder.put(grammarAccess.getFinallyBlockAccess().getGroup(), "rule__FinallyBlock__Group__0");
			builder.put(grammarAccess.getDebuggerStatementAccess().getGroup(), "rule__DebuggerStatement__Group__0");
			builder.put(grammarAccess.getParenExpressionAccess().getGroup(), "rule__ParenExpression__Group__0");
			builder.put(grammarAccess.getIdentifierRefAccess().getGroup_1(), "rule__IdentifierRef__Group_1__0");
			builder.put(grammarAccess.getSuperLiteralAccess().getGroup(), "rule__SuperLiteral__Group__0");
			builder.put(grammarAccess.getThisLiteralAccess().getGroup(), "rule__ThisLiteral__Group__0");
			builder.put(grammarAccess.getArrayLiteralAccess().getGroup(), "rule__ArrayLiteral__Group__0");
			builder.put(grammarAccess.getArrayLiteralAccess().getGroup_3(), "rule__ArrayLiteral__Group_3__0");
			builder.put(grammarAccess.getArrayLiteralAccess().getGroup_3_1(), "rule__ArrayLiteral__Group_3_1__0");
			builder.put(grammarAccess.getArrayLiteralAccess().getGroup_3_2(), "rule__ArrayLiteral__Group_3_2__0");
			builder.put(grammarAccess.getArrayPaddingAccess().getGroup(), "rule__ArrayPadding__Group__0");
			builder.put(grammarAccess.getArrayElementAccess().getGroup(), "rule__ArrayElement__Group__0");
			builder.put(grammarAccess.getObjectLiteralAccess().getGroup(), "rule__ObjectLiteral__Group__0");
			builder.put(grammarAccess.getObjectLiteralAccess().getGroup_2(), "rule__ObjectLiteral__Group_2__0");
			builder.put(grammarAccess.getObjectLiteralAccess().getGroup_2_1(), "rule__ObjectLiteral__Group_2_1__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup(), "rule__AnnotatedPropertyAssignment__Group__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0(), "rule__AnnotatedPropertyAssignment__Group_1_0__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0_0(), "rule__AnnotatedPropertyAssignment__Group_1_0_0__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_0_0_0(), "rule__AnnotatedPropertyAssignment__Group_1_0_0_0__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1(), "rule__AnnotatedPropertyAssignment__Group_1_1__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1_0(), "rule__AnnotatedPropertyAssignment__Group_1_1_0__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_1_0_0(), "rule__AnnotatedPropertyAssignment__Group_1_1_0_0__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2(), "rule__AnnotatedPropertyAssignment__Group_1_2__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2_0(), "rule__AnnotatedPropertyAssignment__Group_1_2_0__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_2_0_0(), "rule__AnnotatedPropertyAssignment__Group_1_2_0_0__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3(), "rule__AnnotatedPropertyAssignment__Group_1_3__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0(), "rule__AnnotatedPropertyAssignment__Group_1_3_0__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0(), "rule__AnnotatedPropertyAssignment__Group_1_3_0_0__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_0(), "rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_0__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_3_0_0_3_1(), "rule__AnnotatedPropertyAssignment__Group_1_3_0_0_3_1__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4(), "rule__AnnotatedPropertyAssignment__Group_1_4__0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGroup_1_4_3(), "rule__AnnotatedPropertyAssignment__Group_1_4_3__0");
			builder.put(grammarAccess.getPropertyMethodDeclarationAccess().getGroup(), "rule__PropertyMethodDeclaration__Group__0");
			builder.put(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0(), "rule__PropertyMethodDeclaration__Group_0__0");
			builder.put(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0(), "rule__PropertyMethodDeclaration__Group_0_0__0");
			builder.put(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_0(), "rule__PropertyMethodDeclaration__Group_0_0_3_0__0");
			builder.put(grammarAccess.getPropertyMethodDeclarationAccess().getGroup_0_0_3_1(), "rule__PropertyMethodDeclaration__Group_0_0_3_1__0");
			builder.put(grammarAccess.getPropertyNameValuePairAccess().getGroup(), "rule__PropertyNameValuePair__Group__0");
			builder.put(grammarAccess.getPropertyNameValuePairAccess().getGroup_0(), "rule__PropertyNameValuePair__Group_0__0");
			builder.put(grammarAccess.getPropertyNameValuePairAccess().getGroup_0_0(), "rule__PropertyNameValuePair__Group_0_0__0");
			builder.put(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup(), "rule__PropertyNameValuePairSingleName__Group__0");
			builder.put(grammarAccess.getPropertyNameValuePairSingleNameAccess().getGroup_2(), "rule__PropertyNameValuePairSingleName__Group_2__0");
			builder.put(grammarAccess.getPropertyGetterDeclarationAccess().getGroup(), "rule__PropertyGetterDeclaration__Group__0");
			builder.put(grammarAccess.getPropertyGetterDeclarationAccess().getGroup_0(), "rule__PropertyGetterDeclaration__Group_0__0");
			builder.put(grammarAccess.getPropertyGetterDeclarationAccess().getGroup_0_0(), "rule__PropertyGetterDeclaration__Group_0_0__0");
			builder.put(grammarAccess.getPropertySetterDeclarationAccess().getGroup(), "rule__PropertySetterDeclaration__Group__0");
			builder.put(grammarAccess.getPropertySetterDeclarationAccess().getGroup_0(), "rule__PropertySetterDeclaration__Group_0__0");
			builder.put(grammarAccess.getPropertySetterDeclarationAccess().getGroup_0_0(), "rule__PropertySetterDeclaration__Group_0_0__0");
			builder.put(grammarAccess.getParameterizedCallExpressionAccess().getGroup(), "rule__ParameterizedCallExpression__Group__0");
			builder.put(grammarAccess.getConcreteTypeArgumentsAccess().getGroup(), "rule__ConcreteTypeArguments__Group__0");
			builder.put(grammarAccess.getConcreteTypeArgumentsAccess().getGroup_2(), "rule__ConcreteTypeArguments__Group_2__0");
			builder.put(grammarAccess.getImportCallExpressionAccess().getGroup(), "rule__ImportCallExpression__Group__0");
			builder.put(grammarAccess.getLeftHandSideExpressionAccess().getGroup(), "rule__LeftHandSideExpression__Group__0");
			builder.put(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1(), "rule__LeftHandSideExpression__Group_1__0");
			builder.put(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_0(), "rule__LeftHandSideExpression__Group_1_2_0__0");
			builder.put(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_1(), "rule__LeftHandSideExpression__Group_1_2_1__0");
			builder.put(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_2(), "rule__LeftHandSideExpression__Group_1_2_2__0");
			builder.put(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3(), "rule__LeftHandSideExpression__Group_1_2_3__0");
			builder.put(grammarAccess.getLeftHandSideExpressionAccess().getGroup_1_2_3_0(), "rule__LeftHandSideExpression__Group_1_2_3_0__0");
			builder.put(grammarAccess.getArgumentsWithParenthesesAccess().getGroup(), "rule__ArgumentsWithParentheses__Group__0");
			builder.put(grammarAccess.getArgumentsAccess().getGroup(), "rule__Arguments__Group__0");
			builder.put(grammarAccess.getArgumentsAccess().getGroup_1(), "rule__Arguments__Group_1__0");
			builder.put(grammarAccess.getArgumentAccess().getGroup(), "rule__Argument__Group__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_0(), "rule__MemberExpression__Group_0__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_0_0(), "rule__MemberExpression__Group_0_0__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_0_0_0(), "rule__MemberExpression__Group_0_0_0__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_1(), "rule__MemberExpression__Group_1__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_1_0(), "rule__MemberExpression__Group_1_0__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_1_0_0(), "rule__MemberExpression__Group_1_0_0__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_1_3(), "rule__MemberExpression__Group_1_3__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_0(), "rule__MemberExpression__Group_1_3_3_0__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_1(), "rule__MemberExpression__Group_1_3_3_1__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_1_3_3_2(), "rule__MemberExpression__Group_1_3_3_2__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_2(), "rule__MemberExpression__Group_2__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_2_1_0(), "rule__MemberExpression__Group_2_1_0__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_2_1_1(), "rule__MemberExpression__Group_2_1_1__0");
			builder.put(grammarAccess.getMemberExpressionAccess().getGroup_2_1_2(), "rule__MemberExpression__Group_2_1_2__0");
			builder.put(grammarAccess.getIndexedAccessExpressionTailAccess().getGroup(), "rule__IndexedAccessExpressionTail__Group__0");
			builder.put(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getGroup(), "rule__ParameterizedPropertyAccessExpressionTail__Group__0");
			builder.put(grammarAccess.getPostfixExpressionAccess().getGroup(), "rule__PostfixExpression__Group__0");
			builder.put(grammarAccess.getPostfixExpressionAccess().getGroup_1(), "rule__PostfixExpression__Group_1__0");
			builder.put(grammarAccess.getPostfixExpressionAccess().getGroup_1_0(), "rule__PostfixExpression__Group_1_0__0");
			builder.put(grammarAccess.getCastExpressionAccess().getGroup(), "rule__CastExpression__Group__0");
			builder.put(grammarAccess.getCastExpressionAccess().getGroup_1(), "rule__CastExpression__Group_1__0");
			builder.put(grammarAccess.getCastExpressionAccess().getGroup_1_0(), "rule__CastExpression__Group_1_0__0");
			builder.put(grammarAccess.getCastExpressionAccess().getGroup_1_0_0(), "rule__CastExpression__Group_1_0_0__0");
			builder.put(grammarAccess.getUnaryExpressionAccess().getGroup_1(), "rule__UnaryExpression__Group_1__0");
			builder.put(grammarAccess.getMultiplicativeExpressionAccess().getGroup(), "rule__MultiplicativeExpression__Group__0");
			builder.put(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1(), "rule__MultiplicativeExpression__Group_1__0");
			builder.put(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0(), "rule__MultiplicativeExpression__Group_1_0__0");
			builder.put(grammarAccess.getMultiplicativeExpressionAccess().getGroup_1_0_0(), "rule__MultiplicativeExpression__Group_1_0_0__0");
			builder.put(grammarAccess.getAdditiveExpressionAccess().getGroup(), "rule__AdditiveExpression__Group__0");
			builder.put(grammarAccess.getAdditiveExpressionAccess().getGroup_1(), "rule__AdditiveExpression__Group_1__0");
			builder.put(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0(), "rule__AdditiveExpression__Group_1_0__0");
			builder.put(grammarAccess.getAdditiveExpressionAccess().getGroup_1_0_0(), "rule__AdditiveExpression__Group_1_0_0__0");
			builder.put(grammarAccess.getShiftExpressionAccess().getGroup(), "rule__ShiftExpression__Group__0");
			builder.put(grammarAccess.getShiftExpressionAccess().getGroup_1(), "rule__ShiftExpression__Group_1__0");
			builder.put(grammarAccess.getShiftExpressionAccess().getGroup_1_0(), "rule__ShiftExpression__Group_1_0__0");
			builder.put(grammarAccess.getShiftOperatorAccess().getGroup_0(), "rule__ShiftOperator__Group_0__0");
			builder.put(grammarAccess.getRelationalExpressionAccess().getGroup(), "rule__RelationalExpression__Group__0");
			builder.put(grammarAccess.getRelationalExpressionAccess().getGroup_1(), "rule__RelationalExpression__Group_1__0");
			builder.put(grammarAccess.getRelationalExpressionAccess().getGroup_1_0(), "rule__RelationalExpression__Group_1_0__0");
			builder.put(grammarAccess.getRelationalOperatorAccess().getGroup_1(), "rule__RelationalOperator__Group_1__0");
			builder.put(grammarAccess.getEqualityExpressionAccess().getGroup(), "rule__EqualityExpression__Group__0");
			builder.put(grammarAccess.getEqualityExpressionAccess().getGroup_1(), "rule__EqualityExpression__Group_1__0");
			builder.put(grammarAccess.getEqualityExpressionAccess().getGroup_1_0(), "rule__EqualityExpression__Group_1_0__0");
			builder.put(grammarAccess.getEqualityExpressionAccess().getGroup_1_0_0(), "rule__EqualityExpression__Group_1_0_0__0");
			builder.put(grammarAccess.getBitwiseANDExpressionAccess().getGroup(), "rule__BitwiseANDExpression__Group__0");
			builder.put(grammarAccess.getBitwiseANDExpressionAccess().getGroup_1(), "rule__BitwiseANDExpression__Group_1__0");
			builder.put(grammarAccess.getBitwiseANDExpressionAccess().getGroup_1_0(), "rule__BitwiseANDExpression__Group_1_0__0");
			builder.put(grammarAccess.getBitwiseANDExpressionAccess().getGroup_1_0_0(), "rule__BitwiseANDExpression__Group_1_0_0__0");
			builder.put(grammarAccess.getBitwiseXORExpressionAccess().getGroup(), "rule__BitwiseXORExpression__Group__0");
			builder.put(grammarAccess.getBitwiseXORExpressionAccess().getGroup_1(), "rule__BitwiseXORExpression__Group_1__0");
			builder.put(grammarAccess.getBitwiseXORExpressionAccess().getGroup_1_0(), "rule__BitwiseXORExpression__Group_1_0__0");
			builder.put(grammarAccess.getBitwiseXORExpressionAccess().getGroup_1_0_0(), "rule__BitwiseXORExpression__Group_1_0_0__0");
			builder.put(grammarAccess.getBitwiseORExpressionAccess().getGroup(), "rule__BitwiseORExpression__Group__0");
			builder.put(grammarAccess.getBitwiseORExpressionAccess().getGroup_1(), "rule__BitwiseORExpression__Group_1__0");
			builder.put(grammarAccess.getBitwiseORExpressionAccess().getGroup_1_0(), "rule__BitwiseORExpression__Group_1_0__0");
			builder.put(grammarAccess.getBitwiseORExpressionAccess().getGroup_1_0_0(), "rule__BitwiseORExpression__Group_1_0_0__0");
			builder.put(grammarAccess.getLogicalANDExpressionAccess().getGroup(), "rule__LogicalANDExpression__Group__0");
			builder.put(grammarAccess.getLogicalANDExpressionAccess().getGroup_1(), "rule__LogicalANDExpression__Group_1__0");
			builder.put(grammarAccess.getLogicalANDExpressionAccess().getGroup_1_0(), "rule__LogicalANDExpression__Group_1_0__0");
			builder.put(grammarAccess.getLogicalANDExpressionAccess().getGroup_1_0_0(), "rule__LogicalANDExpression__Group_1_0_0__0");
			builder.put(grammarAccess.getLogicalORExpressionAccess().getGroup(), "rule__LogicalORExpression__Group__0");
			builder.put(grammarAccess.getLogicalORExpressionAccess().getGroup_1(), "rule__LogicalORExpression__Group_1__0");
			builder.put(grammarAccess.getLogicalORExpressionAccess().getGroup_1_0(), "rule__LogicalORExpression__Group_1_0__0");
			builder.put(grammarAccess.getLogicalORExpressionAccess().getGroup_1_0_0(), "rule__LogicalORExpression__Group_1_0_0__0");
			builder.put(grammarAccess.getConditionalExpressionAccess().getGroup(), "rule__ConditionalExpression__Group__0");
			builder.put(grammarAccess.getConditionalExpressionAccess().getGroup_1(), "rule__ConditionalExpression__Group_1__0");
			builder.put(grammarAccess.getConditionalExpressionAccess().getGroup_1_0(), "rule__ConditionalExpression__Group_1_0__0");
			builder.put(grammarAccess.getConditionalExpressionAccess().getGroup_1_0_0(), "rule__ConditionalExpression__Group_1_0_0__0");
			builder.put(grammarAccess.getAssignmentExpressionAccess().getGroup_4(), "rule__AssignmentExpression__Group_4__0");
			builder.put(grammarAccess.getAssignmentExpressionAccess().getGroup_4_1(), "rule__AssignmentExpression__Group_4_1__0");
			builder.put(grammarAccess.getAssignmentExpressionAccess().getGroup_4_1_0(), "rule__AssignmentExpression__Group_4_1_0__0");
			builder.put(grammarAccess.getAssignmentExpressionAccess().getGroup_4_1_0_0(), "rule__AssignmentExpression__Group_4_1_0_0__0");
			builder.put(grammarAccess.getYieldExpressionAccess().getGroup(), "rule__YieldExpression__Group__0");
			builder.put(grammarAccess.getAssignmentOperatorAccess().getGroup_7(), "rule__AssignmentOperator__Group_7__0");
			builder.put(grammarAccess.getAwaitExpressionAccess().getGroup(), "rule__AwaitExpression__Group__0");
			builder.put(grammarAccess.getAwaitExpressionAccess().getGroup_0(), "rule__AwaitExpression__Group_0__0");
			builder.put(grammarAccess.getAwaitExpressionAccess().getGroup_0_0(), "rule__AwaitExpression__Group_0_0__0");
			builder.put(grammarAccess.getPromisifyExpressionAccess().getGroup(), "rule__PromisifyExpression__Group__0");
			builder.put(grammarAccess.getPromisifyExpressionAccess().getGroup_0(), "rule__PromisifyExpression__Group_0__0");
			builder.put(grammarAccess.getPromisifyExpressionAccess().getGroup_0_0(), "rule__PromisifyExpression__Group_0_0__0");
			builder.put(grammarAccess.getExpressionAccess().getGroup(), "rule__Expression__Group__0");
			builder.put(grammarAccess.getExpressionAccess().getGroup_1(), "rule__Expression__Group_1__0");
			builder.put(grammarAccess.getExpressionAccess().getGroup_1_3(), "rule__Expression__Group_1_3__0");
			builder.put(grammarAccess.getTemplateLiteralAccess().getGroup(), "rule__TemplateLiteral__Group__0");
			builder.put(grammarAccess.getTemplateLiteralAccess().getGroup_1_1(), "rule__TemplateLiteral__Group_1_1__0");
			builder.put(grammarAccess.getTemplateLiteralAccess().getGroup_1_1_3(), "rule__TemplateLiteral__Group_1_1_3__0");
			builder.put(grammarAccess.getNoSubstitutionTemplateAccess().getGroup(), "rule__NoSubstitutionTemplate__Group__0");
			builder.put(grammarAccess.getTemplateHeadAccess().getGroup(), "rule__TemplateHead__Group__0");
			builder.put(grammarAccess.getTemplateTailAccess().getGroup(), "rule__TemplateTail__Group__0");
			builder.put(grammarAccess.getTemplateMiddleAccess().getGroup(), "rule__TemplateMiddle__Group__0");
			builder.put(grammarAccess.getNullLiteralAccess().getGroup(), "rule__NullLiteral__Group__0");
			builder.put(grammarAccess.getBooleanLiteralAccess().getGroup(), "rule__BooleanLiteral__Group__0");
			builder.put(grammarAccess.getREGEX_LITERALAccess().getGroup(), "rule__REGEX_LITERAL__Group__0");
			builder.put(grammarAccess.getAnnotationAccess().getGroup(), "rule__Annotation__Group__0");
			builder.put(grammarAccess.getScriptAnnotationAccess().getGroup(), "rule__ScriptAnnotation__Group__0");
			builder.put(grammarAccess.getAnnotationNoAtSignAccess().getGroup(), "rule__AnnotationNoAtSign__Group__0");
			builder.put(grammarAccess.getAnnotationNoAtSignAccess().getGroup_1(), "rule__AnnotationNoAtSign__Group_1__0");
			builder.put(grammarAccess.getAnnotationNoAtSignAccess().getGroup_1_1(), "rule__AnnotationNoAtSign__Group_1_1__0");
			builder.put(grammarAccess.getAnnotationNoAtSignAccess().getGroup_1_1_1(), "rule__AnnotationNoAtSign__Group_1_1_1__0");
			builder.put(grammarAccess.getAnnotationListAccess().getGroup(), "rule__AnnotationList__Group__0");
			builder.put(grammarAccess.getAnnotationListAccess().getGroup_0(), "rule__AnnotationList__Group_0__0");
			builder.put(grammarAccess.getAnnotationListAccess().getGroup_0_0(), "rule__AnnotationList__Group_0_0__0");
			builder.put(grammarAccess.getExpressionAnnotationListAccess().getGroup(), "rule__ExpressionAnnotationList__Group__0");
			builder.put(grammarAccess.getPropertyAssignmentAnnotationListAccess().getGroup(), "rule__PropertyAssignmentAnnotationList__Group__0");
			builder.put(grammarAccess.getN4MemberAnnotationListAccess().getGroup(), "rule__N4MemberAnnotationList__Group__0");
			builder.put(grammarAccess.getTypeReferenceAccess().getGroup(), "rule__TypeReference__Group__0");
			builder.put(grammarAccess.getTypeReferenceAccess().getGroup_0(), "rule__TypeReference__Group_0__0");
			builder.put(grammarAccess.getN4ClassDeclarationAccess().getGroup(), "rule__N4ClassDeclaration__Group__0");
			builder.put(grammarAccess.getN4ClassDeclarationAccess().getGroup_0(), "rule__N4ClassDeclaration__Group_0__0");
			builder.put(grammarAccess.getN4ClassDeclarationAccess().getGroup_0_0(), "rule__N4ClassDeclaration__Group_0_0__0");
			builder.put(grammarAccess.getMembersAccess().getGroup(), "rule__Members__Group__0");
			builder.put(grammarAccess.getClassExtendsImplementsAccess().getGroup_0(), "rule__ClassExtendsImplements__Group_0__0");
			builder.put(grammarAccess.getClassExtendsImplementsAccess().getGroup_1(), "rule__ClassExtendsImplements__Group_1__0");
			builder.put(grammarAccess.getClassExtendsClauseAccess().getGroup(), "rule__ClassExtendsClause__Group__0");
			builder.put(grammarAccess.getClassImplementsListAccess().getGroup(), "rule__ClassImplementsList__Group__0");
			builder.put(grammarAccess.getClassImplementsListAccess().getGroup_2(), "rule__ClassImplementsList__Group_2__0");
			builder.put(grammarAccess.getN4ClassExpressionAccess().getGroup(), "rule__N4ClassExpression__Group__0");
			builder.put(grammarAccess.getN4InterfaceDeclarationAccess().getGroup(), "rule__N4InterfaceDeclaration__Group__0");
			builder.put(grammarAccess.getN4InterfaceDeclarationAccess().getGroup_0(), "rule__N4InterfaceDeclaration__Group_0__0");
			builder.put(grammarAccess.getN4InterfaceDeclarationAccess().getGroup_0_0(), "rule__N4InterfaceDeclaration__Group_0_0__0");
			builder.put(grammarAccess.getInterfaceExtendsListAccess().getGroup(), "rule__InterfaceExtendsList__Group__0");
			builder.put(grammarAccess.getInterfaceExtendsListAccess().getGroup_2(), "rule__InterfaceExtendsList__Group_2__0");
			builder.put(grammarAccess.getN4EnumDeclarationAccess().getGroup(), "rule__N4EnumDeclaration__Group__0");
			builder.put(grammarAccess.getN4EnumDeclarationAccess().getGroup_0(), "rule__N4EnumDeclaration__Group_0__0");
			builder.put(grammarAccess.getN4EnumDeclarationAccess().getGroup_0_0(), "rule__N4EnumDeclaration__Group_0_0__0");
			builder.put(grammarAccess.getN4EnumDeclarationAccess().getGroup_2(), "rule__N4EnumDeclaration__Group_2__0");
			builder.put(grammarAccess.getN4EnumDeclarationAccess().getGroup_2_1(), "rule__N4EnumDeclaration__Group_2_1__0");
			builder.put(grammarAccess.getN4EnumLiteralAccess().getGroup(), "rule__N4EnumLiteral__Group__0");
			builder.put(grammarAccess.getN4EnumLiteralAccess().getGroup_1(), "rule__N4EnumLiteral__Group_1__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup(), "rule__AnnotatedN4MemberDeclaration__Group__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_0(), "rule__AnnotatedN4MemberDeclaration__Group_1_0__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_0_0(), "rule__AnnotatedN4MemberDeclaration__Group_1_0_0__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_0_0_0(), "rule__AnnotatedN4MemberDeclaration__Group_1_0_0_0__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_1(), "rule__AnnotatedN4MemberDeclaration__Group_1_1__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_1_0(), "rule__AnnotatedN4MemberDeclaration__Group_1_1_0__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_1_0_0(), "rule__AnnotatedN4MemberDeclaration__Group_1_1_0_0__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2(), "rule__AnnotatedN4MemberDeclaration__Group_1_2__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0(), "rule__AnnotatedN4MemberDeclaration__Group_1_2_0__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0(), "rule__AnnotatedN4MemberDeclaration__Group_1_2_0_0__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_0(), "rule__AnnotatedN4MemberDeclaration__Group_1_2_0_0_4_0__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_2_0_0_4_1(), "rule__AnnotatedN4MemberDeclaration__Group_1_2_0_0_4_1__0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGroup_1_3(), "rule__AnnotatedN4MemberDeclaration__Group_1_3__0");
			builder.put(grammarAccess.getFieldDeclarationImplAccess().getGroup(), "rule__FieldDeclarationImpl__Group__0");
			builder.put(grammarAccess.getFieldDeclarationImplAccess().getGroup_5(), "rule__FieldDeclarationImpl__Group_5__0");
			builder.put(grammarAccess.getN4FieldDeclarationAccess().getGroup(), "rule__N4FieldDeclaration__Group__0");
			builder.put(grammarAccess.getN4MethodDeclarationAccess().getGroup(), "rule__N4MethodDeclaration__Group__0");
			builder.put(grammarAccess.getN4MethodDeclarationAccess().getGroup_0(), "rule__N4MethodDeclaration__Group_0__0");
			builder.put(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0(), "rule__N4MethodDeclaration__Group_0_0__0");
			builder.put(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_0(), "rule__N4MethodDeclaration__Group_0_0_4_0__0");
			builder.put(grammarAccess.getN4MethodDeclarationAccess().getGroup_0_0_4_1(), "rule__N4MethodDeclaration__Group_0_0_4_1__0");
			builder.put(grammarAccess.getN4CallableConstructorDeclarationAccess().getGroup(), "rule__N4CallableConstructorDeclaration__Group__0");
			builder.put(grammarAccess.getMethodParamsAndBodyAccess().getGroup(), "rule__MethodParamsAndBody__Group__0");
			builder.put(grammarAccess.getMethodParamsReturnAndBodyAccess().getGroup(), "rule__MethodParamsReturnAndBody__Group__0");
			builder.put(grammarAccess.getN4GetterDeclarationAccess().getGroup(), "rule__N4GetterDeclaration__Group__0");
			builder.put(grammarAccess.getN4GetterDeclarationAccess().getGroup_0(), "rule__N4GetterDeclaration__Group_0__0");
			builder.put(grammarAccess.getN4GetterDeclarationAccess().getGroup_0_0(), "rule__N4GetterDeclaration__Group_0_0__0");
			builder.put(grammarAccess.getGetterHeaderAccess().getGroup(), "rule__GetterHeader__Group__0");
			builder.put(grammarAccess.getN4SetterDeclarationAccess().getGroup(), "rule__N4SetterDeclaration__Group__0");
			builder.put(grammarAccess.getN4SetterDeclarationAccess().getGroup_0(), "rule__N4SetterDeclaration__Group_0__0");
			builder.put(grammarAccess.getN4SetterDeclarationAccess().getGroup_0_0(), "rule__N4SetterDeclaration__Group_0_0__0");
			builder.put(grammarAccess.getObjectBindingPatternAccess().getGroup(), "rule__ObjectBindingPattern__Group__0");
			builder.put(grammarAccess.getObjectBindingPatternAccess().getGroup_2(), "rule__ObjectBindingPattern__Group_2__0");
			builder.put(grammarAccess.getObjectBindingPatternAccess().getGroup_2_1(), "rule__ObjectBindingPattern__Group_2_1__0");
			builder.put(grammarAccess.getArrayBindingPatternAccess().getGroup(), "rule__ArrayBindingPattern__Group__0");
			builder.put(grammarAccess.getArrayBindingPatternAccess().getGroup_3(), "rule__ArrayBindingPattern__Group_3__0");
			builder.put(grammarAccess.getArrayBindingPatternAccess().getGroup_3_1(), "rule__ArrayBindingPattern__Group_3_1__0");
			builder.put(grammarAccess.getArrayBindingPatternAccess().getGroup_3_2(), "rule__ArrayBindingPattern__Group_3_2__0");
			builder.put(grammarAccess.getBindingPropertyAccess().getGroup_0(), "rule__BindingProperty__Group_0__0");
			builder.put(grammarAccess.getBindingPropertyAccess().getGroup_0_0(), "rule__BindingProperty__Group_0_0__0");
			builder.put(grammarAccess.getBindingPropertyAccess().getGroup_0_0_0(), "rule__BindingProperty__Group_0_0_0__0");
			builder.put(grammarAccess.getBindingRestElementAccess().getGroup(), "rule__BindingRestElement__Group__0");
			builder.put(grammarAccess.getBindingElementImplAccess().getGroup_0(), "rule__BindingElementImpl__Group_0__0");
			builder.put(grammarAccess.getBindingElementImplAccess().getGroup_0_0(), "rule__BindingElementImpl__Group_0_0__0");
			builder.put(grammarAccess.getBindingElementImplAccess().getGroup_0_1(), "rule__BindingElementImpl__Group_0_1__0");
			builder.put(grammarAccess.getElisionAccess().getGroup(), "rule__Elision__Group__0");
			builder.put(grammarAccess.getLiteralOrComputedPropertyNameAccess().getGroup_3(), "rule__LiteralOrComputedPropertyName__Group_3__0");
			builder.put(grammarAccess.getJSXElementAccess().getGroup(), "rule__JSXElement__Group__0");
			builder.put(grammarAccess.getJSXElementAccess().getGroup_3_0(), "rule__JSXElement__Group_3_0__0");
			builder.put(grammarAccess.getJSXElementAccess().getGroup_3_1(), "rule__JSXElement__Group_3_1__0");
			builder.put(grammarAccess.getJSXFragmentAccess().getGroup_0(), "rule__JSXFragment__Group_0__0");
			builder.put(grammarAccess.getJSXFragmentAccess().getGroup_0_1(), "rule__JSXFragment__Group_0_1__0");
			builder.put(grammarAccess.getJSXFragmentAccess().getGroup_1(), "rule__JSXFragment__Group_1__0");
			builder.put(grammarAccess.getJSXFragmentAccess().getGroup_1_1(), "rule__JSXFragment__Group_1_1__0");
			builder.put(grammarAccess.getJSXClosingElementAccess().getGroup(), "rule__JSXClosingElement__Group__0");
			builder.put(grammarAccess.getJSXExpressionAccess().getGroup(), "rule__JSXExpression__Group__0");
			builder.put(grammarAccess.getJSXElementNameExpressionAccess().getGroup(), "rule__JSXElementNameExpression__Group__0");
			builder.put(grammarAccess.getJSXElementNameExpressionAccess().getGroup_1(), "rule__JSXElementNameExpression__Group_1__0");
			builder.put(grammarAccess.getJSXSpreadAttributeAccess().getGroup(), "rule__JSXSpreadAttribute__Group__0");
			builder.put(grammarAccess.getJSXPropertyAttributeAccess().getGroup(), "rule__JSXPropertyAttribute__Group__0");
			builder.put(grammarAccess.getJSXPropertyAttributeAccess().getGroup_1(), "rule__JSXPropertyAttribute__Group_1__0");
			builder.put(grammarAccess.getJSXPropertyAttributeAccess().getGroup_1_1_1(), "rule__JSXPropertyAttribute__Group_1_1_1__0");
			builder.put(grammarAccess.getTypeRefAccess().getGroup(), "rule__TypeRef__Group__0");
			builder.put(grammarAccess.getTypeRefAccess().getGroup_1(), "rule__TypeRef__Group_1__0");
			builder.put(grammarAccess.getTypeRefAccess().getGroup_1_1(), "rule__TypeRef__Group_1_1__0");
			builder.put(grammarAccess.getIntersectionTypeExpressionAccess().getGroup(), "rule__IntersectionTypeExpression__Group__0");
			builder.put(grammarAccess.getIntersectionTypeExpressionAccess().getGroup_1(), "rule__IntersectionTypeExpression__Group_1__0");
			builder.put(grammarAccess.getIntersectionTypeExpressionAccess().getGroup_1_1(), "rule__IntersectionTypeExpression__Group_1_1__0");
			builder.put(grammarAccess.getPrimaryTypeExpressionAccess().getGroup_3(), "rule__PrimaryTypeExpression__Group_3__0");
			builder.put(grammarAccess.getTypeRefWithModifiersAccess().getGroup(), "rule__TypeRefWithModifiers__Group__0");
			builder.put(grammarAccess.getTypeRefWithoutModifiersAccess().getGroup_0(), "rule__TypeRefWithoutModifiers__Group_0__0");
			builder.put(grammarAccess.getThisTypeRefNominalAccess().getGroup(), "rule__ThisTypeRefNominal__Group__0");
			builder.put(grammarAccess.getThisTypeRefStructuralAccess().getGroup(), "rule__ThisTypeRefStructural__Group__0");
			builder.put(grammarAccess.getThisTypeRefStructuralAccess().getGroup_2(), "rule__ThisTypeRefStructural__Group_2__0");
			builder.put(grammarAccess.getFunctionTypeExpressionOLDAccess().getGroup(), "rule__FunctionTypeExpressionOLD__Group__0");
			builder.put(grammarAccess.getFunctionTypeExpressionOLDAccess().getGroup_2(), "rule__FunctionTypeExpressionOLD__Group_2__0");
			builder.put(grammarAccess.getFunctionTypeExpressionOLDAccess().getGroup_4(), "rule__FunctionTypeExpressionOLD__Group_4__0");
			builder.put(grammarAccess.getFunctionTypeExpressionOLDAccess().getGroup_4_2(), "rule__FunctionTypeExpressionOLD__Group_4_2__0");
			builder.put(grammarAccess.getArrowFunctionTypeExpressionAccess().getGroup(), "rule__ArrowFunctionTypeExpression__Group__0");
			builder.put(grammarAccess.getArrowFunctionTypeExpressionAccess().getGroup_0(), "rule__ArrowFunctionTypeExpression__Group_0__0");
			builder.put(grammarAccess.getArrowFunctionTypeExpressionAccess().getGroup_0_0(), "rule__ArrowFunctionTypeExpression__Group_0_0__0");
			builder.put(grammarAccess.getTAnonymousFormalParameterListAccess().getGroup(), "rule__TAnonymousFormalParameterList__Group__0");
			builder.put(grammarAccess.getTAnonymousFormalParameterListAccess().getGroup_1(), "rule__TAnonymousFormalParameterList__Group_1__0");
			builder.put(grammarAccess.getTAnonymousFormalParameterAccess().getGroup(), "rule__TAnonymousFormalParameter__Group__0");
			builder.put(grammarAccess.getTAnonymousFormalParameterAccess().getGroup_1_0(), "rule__TAnonymousFormalParameter__Group_1_0__0");
			builder.put(grammarAccess.getTAnonymousFormalParameterAccess().getGroup_1_0_0(), "rule__TAnonymousFormalParameter__Group_1_0_0__0");
			builder.put(grammarAccess.getTFormalParameterAccess().getGroup(), "rule__TFormalParameter__Group__0");
			builder.put(grammarAccess.getDefaultFormalParameterAccess().getGroup(), "rule__DefaultFormalParameter__Group__0");
			builder.put(grammarAccess.getUnionTypeExpressionOLDAccess().getGroup(), "rule__UnionTypeExpressionOLD__Group__0");
			builder.put(grammarAccess.getUnionTypeExpressionOLDAccess().getGroup_4(), "rule__UnionTypeExpressionOLD__Group_4__0");
			builder.put(grammarAccess.getIntersectionTypeExpressionOLDAccess().getGroup(), "rule__IntersectionTypeExpressionOLD__Group__0");
			builder.put(grammarAccess.getIntersectionTypeExpressionOLDAccess().getGroup_4(), "rule__IntersectionTypeExpressionOLD__Group_4__0");
			builder.put(grammarAccess.getParameterizedTypeRefNominalAccess().getGroup(), "rule__ParameterizedTypeRefNominal__Group__0");
			builder.put(grammarAccess.getParameterizedTypeRefNominalAccess().getGroup_0_1(), "rule__ParameterizedTypeRefNominal__Group_0_1__0");
			builder.put(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup(), "rule__ParameterizedTypeRefStructural__Group__0");
			builder.put(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup_0_0(), "rule__ParameterizedTypeRefStructural__Group_0_0__0");
			builder.put(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup_0_1(), "rule__ParameterizedTypeRefStructural__Group_0_1__0");
			builder.put(grammarAccess.getParameterizedTypeRefStructuralAccess().getGroup_2(), "rule__ParameterizedTypeRefStructural__Group_2__0");
			builder.put(grammarAccess.getArrayTypeRefAccess().getGroup(), "rule__ArrayTypeRef__Group__0");
			builder.put(grammarAccess.getTypeArgumentsAccess().getGroup(), "rule__TypeArguments__Group__0");
			builder.put(grammarAccess.getTypeArgumentsAccess().getGroup_2(), "rule__TypeArguments__Group_2__0");
			builder.put(grammarAccess.getTStructMemberListAccess().getGroup(), "rule__TStructMemberList__Group__0");
			builder.put(grammarAccess.getTStructMemberListAccess().getGroup_1(), "rule__TStructMemberList__Group_1__0");
			builder.put(grammarAccess.getTStructMethodAccess().getGroup(), "rule__TStructMethod__Group__0");
			builder.put(grammarAccess.getTStructMethodAccess().getGroup_0(), "rule__TStructMethod__Group_0__0");
			builder.put(grammarAccess.getTStructMethodAccess().getGroup_0_0(), "rule__TStructMethod__Group_0_0__0");
			builder.put(grammarAccess.getTypeVariablesAccess().getGroup(), "rule__TypeVariables__Group__0");
			builder.put(grammarAccess.getTypeVariablesAccess().getGroup_2(), "rule__TypeVariables__Group_2__0");
			builder.put(grammarAccess.getColonSepDeclaredTypeRefAccess().getGroup(), "rule__ColonSepDeclaredTypeRef__Group__0");
			builder.put(grammarAccess.getColonSepTypeRefAccess().getGroup(), "rule__ColonSepTypeRef__Group__0");
			builder.put(grammarAccess.getColonSepReturnTypeRefAccess().getGroup(), "rule__ColonSepReturnTypeRef__Group__0");
			builder.put(grammarAccess.getTStructFieldAccess().getGroup(), "rule__TStructField__Group__0");
			builder.put(grammarAccess.getTStructGetterAccess().getGroup(), "rule__TStructGetter__Group__0");
			builder.put(grammarAccess.getTStructGetterAccess().getGroup_0(), "rule__TStructGetter__Group_0__0");
			builder.put(grammarAccess.getTStructGetterAccess().getGroup_0_0(), "rule__TStructGetter__Group_0_0__0");
			builder.put(grammarAccess.getTStructSetterAccess().getGroup(), "rule__TStructSetter__Group__0");
			builder.put(grammarAccess.getTStructSetterAccess().getGroup_0(), "rule__TStructSetter__Group_0__0");
			builder.put(grammarAccess.getTStructSetterAccess().getGroup_0_0(), "rule__TStructSetter__Group_0_0__0");
			builder.put(grammarAccess.getTypingStrategyUseSiteOperatorAccess().getGroup(), "rule__TypingStrategyUseSiteOperator__Group__0");
			builder.put(grammarAccess.getTypeTypeRefAccess().getGroup(), "rule__TypeTypeRef__Group__0");
			builder.put(grammarAccess.getWildcardAccess().getGroup(), "rule__Wildcard__Group__0");
			builder.put(grammarAccess.getWildcardAccess().getGroup_0(), "rule__Wildcard__Group_0__0");
			builder.put(grammarAccess.getWildcardAccess().getGroup_0_0(), "rule__Wildcard__Group_0_0__0");
			builder.put(grammarAccess.getWildcardAccess().getGroup_1_0(), "rule__Wildcard__Group_1_0__0");
			builder.put(grammarAccess.getWildcardAccess().getGroup_1_1(), "rule__Wildcard__Group_1_1__0");
			builder.put(grammarAccess.getWildcardNewNotationAccess().getGroup_0(), "rule__WildcardNewNotation__Group_0__0");
			builder.put(grammarAccess.getWildcardNewNotationAccess().getGroup_1(), "rule__WildcardNewNotation__Group_1__0");
			builder.put(grammarAccess.getScriptAccess().getAnnotationsAssignment_1_0(), "rule__Script__AnnotationsAssignment_1_0");
			builder.put(grammarAccess.getScriptAccess().getScriptElementsAssignment_1_1(), "rule__Script__ScriptElementsAssignment_1_1");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_2_1_0_0(), "rule__AnnotatedScriptElement__DeclaredModifiersAssignment_1_2_1_0_0");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_3_0_0_1(), "rule__AnnotatedScriptElement__DeclaredModifiersAssignment_1_3_0_0_1");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getTypingStrategyAssignment_1_3_0_0_3(), "rule__AnnotatedScriptElement__TypingStrategyAssignment_1_3_0_0_3");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_3_0_0_4(), "rule__AnnotatedScriptElement__NameAssignment_1_3_0_0_4");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_3_0_1_1(), "rule__AnnotatedScriptElement__DeclaredModifiersAssignment_1_3_0_1_1");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getTypingStrategyAssignment_1_3_0_1_3(), "rule__AnnotatedScriptElement__TypingStrategyAssignment_1_3_0_1_3");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_3_0_1_4(), "rule__AnnotatedScriptElement__NameAssignment_1_3_0_1_4");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersAssignment_1_4_1(), "rule__AnnotatedScriptElement__DeclaredModifiersAssignment_1_4_1");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_4_3(), "rule__AnnotatedScriptElement__NameAssignment_1_4_3");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getLiteralsAssignment_1_4_6(), "rule__AnnotatedScriptElement__LiteralsAssignment_1_4_6");
			builder.put(grammarAccess.getAnnotatedScriptElementAccess().getLiteralsAssignment_1_4_7_1(), "rule__AnnotatedScriptElement__LiteralsAssignment_1_4_7_1");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getWildcardExportAssignment_1_0_0(), "rule__ExportDeclarationImpl__WildcardExportAssignment_1_0_0");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_2(), "rule__ExportDeclarationImpl__ExportedElementAssignment_1_2");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getDefaultExportAssignment_1_3_0(), "rule__ExportDeclarationImpl__DefaultExportAssignment_1_3_0");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_3_1_0(), "rule__ExportDeclarationImpl__ExportedElementAssignment_1_3_1_0");
			builder.put(grammarAccess.getExportDeclarationImplAccess().getDefaultExportedExpressionAssignment_1_3_1_1_0(), "rule__ExportDeclarationImpl__DefaultExportedExpressionAssignment_1_3_1_1_0");
			builder.put(grammarAccess.getExportFromClauseAccess().getReexportedFromAssignment_1(), "rule__ExportFromClause__ReexportedFromAssignment_1");
			builder.put(grammarAccess.getExportClauseAccess().getNamedExportsAssignment_1_0(), "rule__ExportClause__NamedExportsAssignment_1_0");
			builder.put(grammarAccess.getExportClauseAccess().getNamedExportsAssignment_1_1_1(), "rule__ExportClause__NamedExportsAssignment_1_1_1");
			builder.put(grammarAccess.getExportSpecifierAccess().getElementAssignment_0(), "rule__ExportSpecifier__ElementAssignment_0");
			builder.put(grammarAccess.getExportSpecifierAccess().getAliasAssignment_1_1(), "rule__ExportSpecifier__AliasAssignment_1_1");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_0_1(), "rule__AnnotatedExportableElement__DeclaredModifiersAssignment_1_0_1");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_1_1(), "rule__AnnotatedExportableElement__DeclaredModifiersAssignment_1_1_1");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getVarStmtKeywordAssignment_1_1_2(), "rule__AnnotatedExportableElement__VarStmtKeywordAssignment_1_1_2");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getVarDeclsOrBindingsAssignment_1_1_3(), "rule__AnnotatedExportableElement__VarDeclsOrBindingsAssignment_1_1_3");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getVarDeclsOrBindingsAssignment_1_1_4_1(), "rule__AnnotatedExportableElement__VarDeclsOrBindingsAssignment_1_1_4_1");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_2_0_0_1(), "rule__AnnotatedExportableElement__DeclaredModifiersAssignment_1_2_0_0_1");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getTypingStrategyAssignment_1_2_0_0_3(), "rule__AnnotatedExportableElement__TypingStrategyAssignment_1_2_0_0_3");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_2_0_0_4(), "rule__AnnotatedExportableElement__NameAssignment_1_2_0_0_4");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_2_0_1_1(), "rule__AnnotatedExportableElement__DeclaredModifiersAssignment_1_2_0_1_1");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getTypingStrategyAssignment_1_2_0_1_3(), "rule__AnnotatedExportableElement__TypingStrategyAssignment_1_2_0_1_3");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_2_0_1_4(), "rule__AnnotatedExportableElement__NameAssignment_1_2_0_1_4");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersAssignment_1_3_1(), "rule__AnnotatedExportableElement__DeclaredModifiersAssignment_1_3_1");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_3_3(), "rule__AnnotatedExportableElement__NameAssignment_1_3_3");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getLiteralsAssignment_1_3_5(), "rule__AnnotatedExportableElement__LiteralsAssignment_1_3_5");
			builder.put(grammarAccess.getAnnotatedExportableElementAccess().getLiteralsAssignment_1_3_6_1(), "rule__AnnotatedExportableElement__LiteralsAssignment_1_3_6_1");
			builder.put(grammarAccess.getImportDeclarationImplAccess().getImportFromAssignment_1_1(), "rule__ImportDeclarationImpl__ImportFromAssignment_1_1");
			builder.put(grammarAccess.getImportDeclarationImplAccess().getModuleAssignment_2(), "rule__ImportDeclarationImpl__ModuleAssignment_2");
			builder.put(grammarAccess.getImportClauseAccess().getImportSpecifiersAssignment_0_0(), "rule__ImportClause__ImportSpecifiersAssignment_0_0");
			builder.put(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_0(), "rule__ImportSpecifiersExceptDefault__ImportSpecifiersAssignment_0");
			builder.put(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_1_1_0(), "rule__ImportSpecifiersExceptDefault__ImportSpecifiersAssignment_1_1_0");
			builder.put(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_1_1_1_1(), "rule__ImportSpecifiersExceptDefault__ImportSpecifiersAssignment_1_1_1_1");
			builder.put(grammarAccess.getNamedImportSpecifierAccess().getImportedElementAssignment_0(), "rule__NamedImportSpecifier__ImportedElementAssignment_0");
			builder.put(grammarAccess.getNamedImportSpecifierAccess().getImportedElementAssignment_1_0(), "rule__NamedImportSpecifier__ImportedElementAssignment_1_0");
			builder.put(grammarAccess.getNamedImportSpecifierAccess().getAliasAssignment_1_2(), "rule__NamedImportSpecifier__AliasAssignment_1_2");
			builder.put(grammarAccess.getDefaultImportSpecifierAccess().getImportedElementAssignment(), "rule__DefaultImportSpecifier__ImportedElementAssignment");
			builder.put(grammarAccess.getNamespaceImportSpecifierAccess().getAliasAssignment_3(), "rule__NamespaceImportSpecifier__AliasAssignment_3");
			builder.put(grammarAccess.getNamespaceImportSpecifierAccess().getDeclaredDynamicAssignment_4(), "rule__NamespaceImportSpecifier__DeclaredDynamicAssignment_4");
			builder.put(grammarAccess.getFunctionDeclarationAccess().getDeclaredModifiersAssignment_0_0_1(), "rule__FunctionDeclaration__DeclaredModifiersAssignment_0_0_1");
			builder.put(grammarAccess.getAsyncNoTrailingLineBreakAccess().getDeclaredAsyncAssignment_0(), "rule__AsyncNoTrailingLineBreak__DeclaredAsyncAssignment_0");
			builder.put(grammarAccess.getFunctionImplAccess().getGeneratorAssignment_1_0_0(), "rule__FunctionImpl__GeneratorAssignment_1_0_0");
			builder.put(grammarAccess.getFunctionHeaderAccess().getNameAssignment_1(), "rule__FunctionHeader__NameAssignment_1");
			builder.put(grammarAccess.getFunctionBodyAccess().getBodyAssignment_1_0(), "rule__FunctionBody__BodyAssignment_1_0");
			builder.put(grammarAccess.getFunctionBodyAccess().getBodyAssignment_0_0(), "rule__FunctionBody__BodyAssignment_0_0");
			builder.put(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAnnotationListAssignment_0(), "rule__AnnotatedFunctionDeclaration__AnnotationListAssignment_0");
			builder.put(grammarAccess.getAnnotatedFunctionDeclarationAccess().getDeclaredModifiersAssignment_1(), "rule__AnnotatedFunctionDeclaration__DeclaredModifiersAssignment_1");
			builder.put(grammarAccess.getAsyncFunctionExpressionAccess().getDeclaredAsyncAssignment_0_0_0(), "rule__AsyncFunctionExpression__DeclaredAsyncAssignment_0_0_0");
			builder.put(grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAssignment_0_0_0_1_0_0_0(), "rule__ArrowExpression__DeclaredAsyncAssignment_0_0_0_1_0_0_0");
			builder.put(grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2(), "rule__ArrowExpression__FparsAssignment_0_0_0_2");
			builder.put(grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyAssignment_1_0_0(), "rule__ArrowExpression__HasBracesAroundBodyAssignment_1_0_0");
			builder.put(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1(), "rule__ArrowExpression__BodyAssignment_1_0_1");
			builder.put(grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1(), "rule__ArrowExpression__BodyAssignment_1_1");
			builder.put(grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_0(), "rule__StrictFormalParameters__FparsAssignment_1_0");
			builder.put(grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_1_1(), "rule__StrictFormalParameters__FparsAssignment_1_1_1");
			builder.put(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameAssignment(), "rule__BindingIdentifierAsFormalParameter__NameAssignment");
			builder.put(grammarAccess.getBlockMinusBracesAccess().getStatementsAssignment_1(), "rule__BlockMinusBraces__StatementsAssignment_1");
			builder.put(grammarAccess.getExpressionDisguisedAsBlockAccess().getStatementsAssignment_1(), "rule__ExpressionDisguisedAsBlock__StatementsAssignment_1");
			builder.put(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignment(), "rule__AssignmentExpressionStatement__ExpressionAssignment");
			builder.put(grammarAccess.getAnnotatedExpressionAccess().getNameAssignment_1_0_2(), "rule__AnnotatedExpression__NameAssignment_1_0_2");
			builder.put(grammarAccess.getTypeVariableAccess().getDeclaredCovariantAssignment_0_0(), "rule__TypeVariable__DeclaredCovariantAssignment_0_0");
			builder.put(grammarAccess.getTypeVariableAccess().getDeclaredContravariantAssignment_0_1(), "rule__TypeVariable__DeclaredContravariantAssignment_0_1");
			builder.put(grammarAccess.getTypeVariableAccess().getNameAssignment_1(), "rule__TypeVariable__NameAssignment_1");
			builder.put(grammarAccess.getTypeVariableAccess().getDeclaredUpperBoundAssignment_2_1(), "rule__TypeVariable__DeclaredUpperBoundAssignment_2_1");
			builder.put(grammarAccess.getBindingElementFragmentAccess().getBindingPatternAssignment_0_0(), "rule__BindingElementFragment__BindingPatternAssignment_0_0");
			builder.put(grammarAccess.getBindingElementFragmentAccess().getAnnotationsAssignment_0_1_0(), "rule__BindingElementFragment__AnnotationsAssignment_0_1_0");
			builder.put(grammarAccess.getBindingElementFragmentAccess().getVariadicAssignment_0_1_2(), "rule__BindingElementFragment__VariadicAssignment_0_1_2");
			builder.put(grammarAccess.getBindingElementFragmentAccess().getNameAssignment_0_1_3(), "rule__BindingElementFragment__NameAssignment_0_1_3");
			builder.put(grammarAccess.getBindingElementFragmentAccess().getHasInitializerAssignmentAssignment_1_0(), "rule__BindingElementFragment__HasInitializerAssignmentAssignment_1_0");
			builder.put(grammarAccess.getBindingElementFragmentAccess().getInitializerAssignment_1_1(), "rule__BindingElementFragment__InitializerAssignment_1_1");
			builder.put(grammarAccess.getBogusTypeRefFragmentAccess().getBogusTypeRefAssignment(), "rule__BogusTypeRefFragment__BogusTypeRefAssignment");
			builder.put(grammarAccess.getBlockAccess().getStatementsAssignment_1(), "rule__Block__StatementsAssignment_1");
			builder.put(grammarAccess.getVariableStatementAccess().getVarStmtKeywordAssignment_0_0_1(), "rule__VariableStatement__VarStmtKeywordAssignment_0_0_1");
			builder.put(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_1(), "rule__VariableStatement__VarDeclsOrBindingsAssignment_1");
			builder.put(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_2_1(), "rule__VariableStatement__VarDeclsOrBindingsAssignment_2_1");
			builder.put(grammarAccess.getExportedVariableStatementAccess().getDeclaredModifiersAssignment_1(), "rule__ExportedVariableStatement__DeclaredModifiersAssignment_1");
			builder.put(grammarAccess.getExportedVariableStatementAccess().getVarStmtKeywordAssignment_2(), "rule__ExportedVariableStatement__VarStmtKeywordAssignment_2");
			builder.put(grammarAccess.getExportedVariableStatementAccess().getVarDeclsOrBindingsAssignment_3(), "rule__ExportedVariableStatement__VarDeclsOrBindingsAssignment_3");
			builder.put(grammarAccess.getExportedVariableStatementAccess().getVarDeclsOrBindingsAssignment_4_1(), "rule__ExportedVariableStatement__VarDeclsOrBindingsAssignment_4_1");
			builder.put(grammarAccess.getVariableBindingAccess().getPatternAssignment_0(), "rule__VariableBinding__PatternAssignment_0");
			builder.put(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1(), "rule__VariableBinding__ExpressionAssignment_1_1_1");
			builder.put(grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1(), "rule__VariableBinding__ExpressionAssignment_1_0_0_1");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0(), "rule__VariableDeclarationImpl__AnnotationsAssignment_0");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0(), "rule__VariableDeclarationImpl__NameAssignment_1_1_0_0");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1(), "rule__VariableDeclarationImpl__ExpressionAssignment_1_1_1_1");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0(), "rule__VariableDeclarationImpl__NameAssignment_1_0_0_0_0");
			builder.put(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1(), "rule__VariableDeclarationImpl__ExpressionAssignment_1_0_1_1");
			builder.put(grammarAccess.getExportedVariableBindingAccess().getPatternAssignment_0(), "rule__ExportedVariableBinding__PatternAssignment_0");
			builder.put(grammarAccess.getExportedVariableBindingAccess().getExpressionAssignment_2(), "rule__ExportedVariableBinding__ExpressionAssignment_2");
			builder.put(grammarAccess.getExpressionStatementAccess().getExpressionAssignment_0(), "rule__ExpressionStatement__ExpressionAssignment_0");
			builder.put(grammarAccess.getIfStatementAccess().getExpressionAssignment_2(), "rule__IfStatement__ExpressionAssignment_2");
			builder.put(grammarAccess.getIfStatementAccess().getIfStmtAssignment_4(), "rule__IfStatement__IfStmtAssignment_4");
			builder.put(grammarAccess.getIfStatementAccess().getElseStmtAssignment_5_1(), "rule__IfStatement__ElseStmtAssignment_5_1");
			builder.put(grammarAccess.getDoStatementAccess().getStatementAssignment_1(), "rule__DoStatement__StatementAssignment_1");
			builder.put(grammarAccess.getDoStatementAccess().getExpressionAssignment_4(), "rule__DoStatement__ExpressionAssignment_4");
			builder.put(grammarAccess.getWhileStatementAccess().getExpressionAssignment_2(), "rule__WhileStatement__ExpressionAssignment_2");
			builder.put(grammarAccess.getWhileStatementAccess().getStatementAssignment_4(), "rule__WhileStatement__StatementAssignment_4");
			builder.put(grammarAccess.getForStatementAccess().getInitExprAssignment_3_0_0_0(), "rule__ForStatement__InitExprAssignment_3_0_0_0");
			builder.put(grammarAccess.getForStatementAccess().getForInAssignment_3_0_0_1(), "rule__ForStatement__ForInAssignment_3_0_0_1");
			builder.put(grammarAccess.getForStatementAccess().getExpressionAssignment_3_0_0_2(), "rule__ForStatement__ExpressionAssignment_3_0_0_2");
			builder.put(grammarAccess.getForStatementAccess().getVarStmtKeywordAssignment_3_1_0_0_0(), "rule__ForStatement__VarStmtKeywordAssignment_3_1_0_0_0");
			builder.put(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_0_0_0(), "rule__ForStatement__VarDeclsOrBindingsAssignment_3_1_0_0_1_0_0_0");
			builder.put(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_0_0_1_0(), "rule__ForStatement__ForInAssignment_3_1_0_0_1_0_0_1_0");
			builder.put(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_0_0_1_1(), "rule__ForStatement__ForOfAssignment_3_1_0_0_1_0_0_1_1");
			builder.put(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_0_0_2(), "rule__ForStatement__ExpressionAssignment_3_1_0_0_1_0_0_2");
			builder.put(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_0(), "rule__ForStatement__VarDeclsOrBindingsAssignment_3_1_0_0_1_1_0");
			builder.put(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_1_0_0_1(), "rule__ForStatement__VarDeclsOrBindingsAssignment_3_1_0_0_1_1_1_0_0_1");
			builder.put(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_0_2(), "rule__ForStatement__ExpressionAssignment_3_1_0_0_1_1_1_0_2");
			builder.put(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_0_1_1_1_0_4(), "rule__ForStatement__UpdateExprAssignment_3_1_0_0_1_1_1_0_4");
			builder.put(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_0_1_1_1_1_0(), "rule__ForStatement__ForInAssignment_3_1_0_0_1_1_1_1_0");
			builder.put(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_1_1(), "rule__ForStatement__ExpressionAssignment_3_1_0_0_1_1_1_1_1");
			builder.put(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_0_1_1_1_2_0(), "rule__ForStatement__ForOfAssignment_3_1_0_0_1_1_1_2_0");
			builder.put(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_2_1(), "rule__ForStatement__ExpressionAssignment_3_1_0_0_1_1_1_2_1");
			builder.put(grammarAccess.getForStatementAccess().getInitExprAssignment_3_1_0_1_0(), "rule__ForStatement__InitExprAssignment_3_1_0_1_0");
			builder.put(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_0_1(), "rule__ForStatement__ExpressionAssignment_3_1_0_1_1_0_1");
			builder.put(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_1_1_0_3(), "rule__ForStatement__UpdateExprAssignment_3_1_0_1_1_0_3");
			builder.put(grammarAccess.getForStatementAccess().getForInAssignment_3_1_0_1_1_1_0(), "rule__ForStatement__ForInAssignment_3_1_0_1_1_1_0");
			builder.put(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_1_1(), "rule__ForStatement__ExpressionAssignment_3_1_0_1_1_1_1");
			builder.put(grammarAccess.getForStatementAccess().getForOfAssignment_3_1_0_1_1_2_0(), "rule__ForStatement__ForOfAssignment_3_1_0_1_1_2_0");
			builder.put(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_2_1(), "rule__ForStatement__ExpressionAssignment_3_1_0_1_1_2_1");
			builder.put(grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_2_1(), "rule__ForStatement__ExpressionAssignment_3_1_0_2_1");
			builder.put(grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_2_3(), "rule__ForStatement__UpdateExprAssignment_3_1_0_2_3");
			builder.put(grammarAccess.getForStatementAccess().getStatementAssignment_4(), "rule__ForStatement__StatementAssignment_4");
			builder.put(grammarAccess.getLetIdentifierRefAccess().getIdAssignment(), "rule__LetIdentifierRef__IdAssignment");
			builder.put(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameAssignment(), "rule__BindingIdentifierAsVariableDeclaration__NameAssignment");
			builder.put(grammarAccess.getContinueStatementAccess().getLabelAssignment_2(), "rule__ContinueStatement__LabelAssignment_2");
			builder.put(grammarAccess.getBreakStatementAccess().getLabelAssignment_2(), "rule__BreakStatement__LabelAssignment_2");
			builder.put(grammarAccess.getReturnStatementAccess().getExpressionAssignment_2(), "rule__ReturnStatement__ExpressionAssignment_2");
			builder.put(grammarAccess.getWithStatementAccess().getExpressionAssignment_2(), "rule__WithStatement__ExpressionAssignment_2");
			builder.put(grammarAccess.getWithStatementAccess().getStatementAssignment_4(), "rule__WithStatement__StatementAssignment_4");
			builder.put(grammarAccess.getSwitchStatementAccess().getExpressionAssignment_2(), "rule__SwitchStatement__ExpressionAssignment_2");
			builder.put(grammarAccess.getSwitchStatementAccess().getCasesAssignment_5(), "rule__SwitchStatement__CasesAssignment_5");
			builder.put(grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_0(), "rule__SwitchStatement__CasesAssignment_6_0");
			builder.put(grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_1(), "rule__SwitchStatement__CasesAssignment_6_1");
			builder.put(grammarAccess.getCaseClauseAccess().getExpressionAssignment_1(), "rule__CaseClause__ExpressionAssignment_1");
			builder.put(grammarAccess.getCaseClauseAccess().getStatementsAssignment_3(), "rule__CaseClause__StatementsAssignment_3");
			builder.put(grammarAccess.getDefaultClauseAccess().getStatementsAssignment_3(), "rule__DefaultClause__StatementsAssignment_3");
			builder.put(grammarAccess.getLabelledStatementAccess().getNameAssignment_0_0_0(), "rule__LabelledStatement__NameAssignment_0_0_0");
			builder.put(grammarAccess.getLabelledStatementAccess().getStatementAssignment_1(), "rule__LabelledStatement__StatementAssignment_1");
			builder.put(grammarAccess.getThrowStatementAccess().getExpressionAssignment_1(), "rule__ThrowStatement__ExpressionAssignment_1");
			builder.put(grammarAccess.getTryStatementAccess().getBlockAssignment_1(), "rule__TryStatement__BlockAssignment_1");
			builder.put(grammarAccess.getTryStatementAccess().getCatchAssignment_2_0_0(), "rule__TryStatement__CatchAssignment_2_0_0");
			builder.put(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_0_1(), "rule__TryStatement__FinallyAssignment_2_0_1");
			builder.put(grammarAccess.getTryStatementAccess().getFinallyAssignment_2_1(), "rule__TryStatement__FinallyAssignment_2_1");
			builder.put(grammarAccess.getCatchBlockAccess().getCatchVariableAssignment_3(), "rule__CatchBlock__CatchVariableAssignment_3");
			builder.put(grammarAccess.getCatchBlockAccess().getBlockAssignment_5(), "rule__CatchBlock__BlockAssignment_5");
			builder.put(grammarAccess.getCatchVariableAccess().getBindingPatternAssignment_0(), "rule__CatchVariable__BindingPatternAssignment_0");
			builder.put(grammarAccess.getCatchVariableAccess().getNameAssignment_1_0_0(), "rule__CatchVariable__NameAssignment_1_0_0");
			builder.put(grammarAccess.getCatchVariableAccess().getNameAssignment_2_1(), "rule__CatchVariable__NameAssignment_2_1");
			builder.put(grammarAccess.getFinallyBlockAccess().getBlockAssignment_2(), "rule__FinallyBlock__BlockAssignment_2");
			builder.put(grammarAccess.getParenExpressionAccess().getExpressionAssignment_1(), "rule__ParenExpression__ExpressionAssignment_1");
			builder.put(grammarAccess.getIdentifierRefAccess().getIdAssignment_0(), "rule__IdentifierRef__IdAssignment_0");
			builder.put(grammarAccess.getIdentifierRefAccess().getIdAssignment_1_1(), "rule__IdentifierRef__IdAssignment_1_1");
			builder.put(grammarAccess.getArrayLiteralAccess().getElementsAssignment_2(), "rule__ArrayLiteral__ElementsAssignment_2");
			builder.put(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_0(), "rule__ArrayLiteral__ElementsAssignment_3_0");
			builder.put(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_1(), "rule__ArrayLiteral__ElementsAssignment_3_1_1");
			builder.put(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_2(), "rule__ArrayLiteral__ElementsAssignment_3_1_2");
			builder.put(grammarAccess.getArrayLiteralAccess().getTrailingCommaAssignment_3_2_0(), "rule__ArrayLiteral__TrailingCommaAssignment_3_2_0");
			builder.put(grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_2_1(), "rule__ArrayLiteral__ElementsAssignment_3_2_1");
			builder.put(grammarAccess.getArrayElementAccess().getSpreadAssignment_1(), "rule__ArrayElement__SpreadAssignment_1");
			builder.put(grammarAccess.getArrayElementAccess().getExpressionAssignment_2(), "rule__ArrayElement__ExpressionAssignment_2");
			builder.put(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_0(), "rule__ObjectLiteral__PropertyAssignmentsAssignment_2_0");
			builder.put(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_1_1(), "rule__ObjectLiteral__PropertyAssignmentsAssignment_2_1_1");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_0_0_0_1(), "rule__AnnotatedPropertyAssignment__DeclaredTypeRefAssignment_1_0_0_0_1");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_0_0_0_2(), "rule__AnnotatedPropertyAssignment__DeclaredNameAssignment_1_0_0_0_2");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_0_1(), "rule__AnnotatedPropertyAssignment__ExpressionAssignment_1_0_1");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_1_1(), "rule__AnnotatedPropertyAssignment__BodyAssignment_1_1_1");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_2_0_0_2(), "rule__AnnotatedPropertyAssignment__DeclaredNameAssignment_1_2_0_0_2");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredOptionalAssignment_1_2_1(), "rule__AnnotatedPropertyAssignment__DeclaredOptionalAssignment_1_2_1");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getFparAssignment_1_2_3(), "rule__AnnotatedPropertyAssignment__FparAssignment_1_2_3");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_2_5(), "rule__AnnotatedPropertyAssignment__BodyAssignment_1_2_5");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getReturnTypeRefAssignment_1_3_0_0_2(), "rule__AnnotatedPropertyAssignment__ReturnTypeRefAssignment_1_3_0_0_2");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getGeneratorAssignment_1_3_0_0_3_0_0(), "rule__AnnotatedPropertyAssignment__GeneratorAssignment_1_3_0_0_3_0_0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_0_1(), "rule__AnnotatedPropertyAssignment__DeclaredNameAssignment_1_3_0_0_3_0_1");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_1_0(), "rule__AnnotatedPropertyAssignment__DeclaredNameAssignment_1_3_0_0_3_1_0");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_4_1(), "rule__AnnotatedPropertyAssignment__DeclaredTypeRefAssignment_1_4_1");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getIdentifierRefAssignment_1_4_2(), "rule__AnnotatedPropertyAssignment__IdentifierRefAssignment_1_4_2");
			builder.put(grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_4_3_1(), "rule__AnnotatedPropertyAssignment__ExpressionAssignment_1_4_3_1");
			builder.put(grammarAccess.getPropertyMethodDeclarationAccess().getReturnTypeRefAssignment_0_0_2(), "rule__PropertyMethodDeclaration__ReturnTypeRefAssignment_0_0_2");
			builder.put(grammarAccess.getPropertyMethodDeclarationAccess().getGeneratorAssignment_0_0_3_0_0(), "rule__PropertyMethodDeclaration__GeneratorAssignment_0_0_3_0_0");
			builder.put(grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_0_1(), "rule__PropertyMethodDeclaration__DeclaredNameAssignment_0_0_3_0_1");
			builder.put(grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_1_0(), "rule__PropertyMethodDeclaration__DeclaredNameAssignment_0_0_3_1_0");
			builder.put(grammarAccess.getPropertyNameValuePairAccess().getDeclaredTypeRefAssignment_0_0_1(), "rule__PropertyNameValuePair__DeclaredTypeRefAssignment_0_0_1");
			builder.put(grammarAccess.getPropertyNameValuePairAccess().getDeclaredNameAssignment_0_0_2(), "rule__PropertyNameValuePair__DeclaredNameAssignment_0_0_2");
			builder.put(grammarAccess.getPropertyNameValuePairAccess().getDeclaredOptionalAssignment_0_0_3(), "rule__PropertyNameValuePair__DeclaredOptionalAssignment_0_0_3");
			builder.put(grammarAccess.getPropertyNameValuePairAccess().getExpressionAssignment_1(), "rule__PropertyNameValuePair__ExpressionAssignment_1");
			builder.put(grammarAccess.getPropertyNameValuePairSingleNameAccess().getDeclaredTypeRefAssignment_0(), "rule__PropertyNameValuePairSingleName__DeclaredTypeRefAssignment_0");
			builder.put(grammarAccess.getPropertyNameValuePairSingleNameAccess().getIdentifierRefAssignment_1(), "rule__PropertyNameValuePairSingleName__IdentifierRefAssignment_1");
			builder.put(grammarAccess.getPropertyNameValuePairSingleNameAccess().getExpressionAssignment_2_1(), "rule__PropertyNameValuePairSingleName__ExpressionAssignment_2_1");
			builder.put(grammarAccess.getPropertyGetterDeclarationAccess().getBodyAssignment_1(), "rule__PropertyGetterDeclaration__BodyAssignment_1");
			builder.put(grammarAccess.getPropertySetterDeclarationAccess().getDeclaredNameAssignment_0_0_2(), "rule__PropertySetterDeclaration__DeclaredNameAssignment_0_0_2");
			builder.put(grammarAccess.getPropertySetterDeclarationAccess().getDeclaredOptionalAssignment_1(), "rule__PropertySetterDeclaration__DeclaredOptionalAssignment_1");
			builder.put(grammarAccess.getPropertySetterDeclarationAccess().getFparAssignment_3(), "rule__PropertySetterDeclaration__FparAssignment_3");
			builder.put(grammarAccess.getPropertySetterDeclarationAccess().getBodyAssignment_5(), "rule__PropertySetterDeclaration__BodyAssignment_5");
			builder.put(grammarAccess.getParameterizedCallExpressionAccess().getTargetAssignment_1(), "rule__ParameterizedCallExpression__TargetAssignment_1");
			builder.put(grammarAccess.getConcreteTypeArgumentsAccess().getTypeArgsAssignment_1(), "rule__ConcreteTypeArguments__TypeArgsAssignment_1");
			builder.put(grammarAccess.getConcreteTypeArgumentsAccess().getTypeArgsAssignment_2_1(), "rule__ConcreteTypeArguments__TypeArgsAssignment_2_1");
			builder.put(grammarAccess.getLeftHandSideExpressionAccess().getTemplateAssignment_1_2_3_0_1(), "rule__LeftHandSideExpression__TemplateAssignment_1_2_3_0_1");
			builder.put(grammarAccess.getArgumentsAccess().getArgumentsAssignment_0(), "rule__Arguments__ArgumentsAssignment_0");
			builder.put(grammarAccess.getArgumentsAccess().getArgumentsAssignment_1_1(), "rule__Arguments__ArgumentsAssignment_1_1");
			builder.put(grammarAccess.getArgumentAccess().getSpreadAssignment_0(), "rule__Argument__SpreadAssignment_0");
			builder.put(grammarAccess.getArgumentAccess().getExpressionAssignment_1(), "rule__Argument__ExpressionAssignment_1");
			builder.put(grammarAccess.getMemberExpressionAccess().getCalleeAssignment_1_1(), "rule__MemberExpression__CalleeAssignment_1_1");
			builder.put(grammarAccess.getMemberExpressionAccess().getWithArgsAssignment_1_3_0(), "rule__MemberExpression__WithArgsAssignment_1_3_0");
			builder.put(grammarAccess.getMemberExpressionAccess().getTemplateAssignment_1_3_3_2_1(), "rule__MemberExpression__TemplateAssignment_1_3_3_2_1");
			builder.put(grammarAccess.getMemberExpressionAccess().getTemplateAssignment_2_1_2_1(), "rule__MemberExpression__TemplateAssignment_2_1_2_1");
			builder.put(grammarAccess.getIndexedAccessExpressionTailAccess().getIndexAssignment_1(), "rule__IndexedAccessExpressionTail__IndexAssignment_1");
			builder.put(grammarAccess.getParameterizedPropertyAccessExpressionTailAccess().getPropertyAssignment_2(), "rule__ParameterizedPropertyAccessExpressionTail__PropertyAssignment_2");
			builder.put(grammarAccess.getPostfixExpressionAccess().getOpAssignment_1_0_1(), "rule__PostfixExpression__OpAssignment_1_0_1");
			builder.put(grammarAccess.getCastExpressionAccess().getTargetTypeRefAssignment_1_1(), "rule__CastExpression__TargetTypeRefAssignment_1_1");
			builder.put(grammarAccess.getUnaryExpressionAccess().getOpAssignment_1_1(), "rule__UnaryExpression__OpAssignment_1_1");
			builder.put(grammarAccess.getUnaryExpressionAccess().getExpressionAssignment_1_2(), "rule__UnaryExpression__ExpressionAssignment_1_2");
			builder.put(grammarAccess.getMultiplicativeExpressionAccess().getOpAssignment_1_0_0_1(), "rule__MultiplicativeExpression__OpAssignment_1_0_0_1");
			builder.put(grammarAccess.getMultiplicativeExpressionAccess().getRhsAssignment_1_1(), "rule__MultiplicativeExpression__RhsAssignment_1_1");
			builder.put(grammarAccess.getAdditiveExpressionAccess().getOpAssignment_1_0_0_1(), "rule__AdditiveExpression__OpAssignment_1_0_0_1");
			builder.put(grammarAccess.getAdditiveExpressionAccess().getRhsAssignment_1_1(), "rule__AdditiveExpression__RhsAssignment_1_1");
			builder.put(grammarAccess.getShiftExpressionAccess().getOpAssignment_1_0_1(), "rule__ShiftExpression__OpAssignment_1_0_1");
			builder.put(grammarAccess.getShiftExpressionAccess().getRhsAssignment_1_0_2(), "rule__ShiftExpression__RhsAssignment_1_0_2");
			builder.put(grammarAccess.getRelationalExpressionAccess().getOpAssignment_1_0_1(), "rule__RelationalExpression__OpAssignment_1_0_1");
			builder.put(grammarAccess.getRelationalExpressionAccess().getRhsAssignment_1_0_2(), "rule__RelationalExpression__RhsAssignment_1_0_2");
			builder.put(grammarAccess.getEqualityExpressionAccess().getOpAssignment_1_0_0_1(), "rule__EqualityExpression__OpAssignment_1_0_0_1");
			builder.put(grammarAccess.getEqualityExpressionAccess().getRhsAssignment_1_1(), "rule__EqualityExpression__RhsAssignment_1_1");
			builder.put(grammarAccess.getBitwiseANDExpressionAccess().getOpAssignment_1_0_0_1(), "rule__BitwiseANDExpression__OpAssignment_1_0_0_1");
			builder.put(grammarAccess.getBitwiseANDExpressionAccess().getRhsAssignment_1_1(), "rule__BitwiseANDExpression__RhsAssignment_1_1");
			builder.put(grammarAccess.getBitwiseXORExpressionAccess().getOpAssignment_1_0_0_1(), "rule__BitwiseXORExpression__OpAssignment_1_0_0_1");
			builder.put(grammarAccess.getBitwiseXORExpressionAccess().getRhsAssignment_1_1(), "rule__BitwiseXORExpression__RhsAssignment_1_1");
			builder.put(grammarAccess.getBitwiseORExpressionAccess().getOpAssignment_1_0_0_1(), "rule__BitwiseORExpression__OpAssignment_1_0_0_1");
			builder.put(grammarAccess.getBitwiseORExpressionAccess().getRhsAssignment_1_1(), "rule__BitwiseORExpression__RhsAssignment_1_1");
			builder.put(grammarAccess.getLogicalANDExpressionAccess().getOpAssignment_1_0_0_1(), "rule__LogicalANDExpression__OpAssignment_1_0_0_1");
			builder.put(grammarAccess.getLogicalANDExpressionAccess().getRhsAssignment_1_1(), "rule__LogicalANDExpression__RhsAssignment_1_1");
			builder.put(grammarAccess.getLogicalORExpressionAccess().getOpAssignment_1_0_0_1(), "rule__LogicalORExpression__OpAssignment_1_0_0_1");
			builder.put(grammarAccess.getLogicalORExpressionAccess().getRhsAssignment_1_1(), "rule__LogicalORExpression__RhsAssignment_1_1");
			builder.put(grammarAccess.getConditionalExpressionAccess().getTrueExpressionAssignment_1_1(), "rule__ConditionalExpression__TrueExpressionAssignment_1_1");
			builder.put(grammarAccess.getConditionalExpressionAccess().getFalseExpressionAssignment_1_3(), "rule__ConditionalExpression__FalseExpressionAssignment_1_3");
			builder.put(grammarAccess.getAssignmentExpressionAccess().getOpAssignment_4_1_0_0_1(), "rule__AssignmentExpression__OpAssignment_4_1_0_0_1");
			builder.put(grammarAccess.getAssignmentExpressionAccess().getRhsAssignment_4_1_1(), "rule__AssignmentExpression__RhsAssignment_4_1_1");
			builder.put(grammarAccess.getYieldExpressionAccess().getManyAssignment_2(), "rule__YieldExpression__ManyAssignment_2");
			builder.put(grammarAccess.getYieldExpressionAccess().getExpressionAssignment_3(), "rule__YieldExpression__ExpressionAssignment_3");
			builder.put(grammarAccess.getAwaitExpressionAccess().getExpressionAssignment_1(), "rule__AwaitExpression__ExpressionAssignment_1");
			builder.put(grammarAccess.getPromisifyExpressionAccess().getExpressionAssignment_1(), "rule__PromisifyExpression__ExpressionAssignment_1");
			builder.put(grammarAccess.getExpressionAccess().getExprsAssignment_1_2(), "rule__Expression__ExprsAssignment_1_2");
			builder.put(grammarAccess.getExpressionAccess().getExprsAssignment_1_3_1(), "rule__Expression__ExprsAssignment_1_3_1");
			builder.put(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_0(), "rule__TemplateLiteral__SegmentsAssignment_1_0");
			builder.put(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_1_0(), "rule__TemplateLiteral__SegmentsAssignment_1_1_0");
			builder.put(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_1_1(), "rule__TemplateLiteral__SegmentsAssignment_1_1_1");
			builder.put(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_1_3_0(), "rule__TemplateLiteral__SegmentsAssignment_1_1_3_0");
			builder.put(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_1_3_1(), "rule__TemplateLiteral__SegmentsAssignment_1_1_3_1");
			builder.put(grammarAccess.getTemplateLiteralAccess().getSegmentsAssignment_1_1_4(), "rule__TemplateLiteral__SegmentsAssignment_1_1_4");
			builder.put(grammarAccess.getNoSubstitutionTemplateAccess().getValueAssignment_1(), "rule__NoSubstitutionTemplate__ValueAssignment_1");
			builder.put(grammarAccess.getTemplateHeadAccess().getValueAssignment_1(), "rule__TemplateHead__ValueAssignment_1");
			builder.put(grammarAccess.getTemplateTailAccess().getValueAssignment_1(), "rule__TemplateTail__ValueAssignment_1");
			builder.put(grammarAccess.getTemplateMiddleAccess().getValueAssignment_1(), "rule__TemplateMiddle__ValueAssignment_1");
			builder.put(grammarAccess.getBooleanLiteralAccess().getTrueAssignment_1_0(), "rule__BooleanLiteral__TrueAssignment_1_0");
			builder.put(grammarAccess.getStringLiteralAccess().getValueAssignment(), "rule__StringLiteral__ValueAssignment");
			builder.put(grammarAccess.getDoubleLiteralAccess().getValueAssignment(), "rule__DoubleLiteral__ValueAssignment");
			builder.put(grammarAccess.getIntLiteralAccess().getValueAssignment(), "rule__IntLiteral__ValueAssignment");
			builder.put(grammarAccess.getOctalIntLiteralAccess().getValueAssignment(), "rule__OctalIntLiteral__ValueAssignment");
			builder.put(grammarAccess.getLegacyOctalIntLiteralAccess().getValueAssignment(), "rule__LegacyOctalIntLiteral__ValueAssignment");
			builder.put(grammarAccess.getHexIntLiteralAccess().getValueAssignment(), "rule__HexIntLiteral__ValueAssignment");
			builder.put(grammarAccess.getBinaryIntLiteralAccess().getValueAssignment(), "rule__BinaryIntLiteral__ValueAssignment");
			builder.put(grammarAccess.getScientificIntLiteralAccess().getValueAssignment(), "rule__ScientificIntLiteral__ValueAssignment");
			builder.put(grammarAccess.getRegularExpressionLiteralAccess().getValueAssignment(), "rule__RegularExpressionLiteral__ValueAssignment");
			builder.put(grammarAccess.getAnnotationNoAtSignAccess().getNameAssignment_0(), "rule__AnnotationNoAtSign__NameAssignment_0");
			builder.put(grammarAccess.getAnnotationNoAtSignAccess().getArgsAssignment_1_1_0(), "rule__AnnotationNoAtSign__ArgsAssignment_1_1_0");
			builder.put(grammarAccess.getAnnotationNoAtSignAccess().getArgsAssignment_1_1_1_1(), "rule__AnnotationNoAtSign__ArgsAssignment_1_1_1_1");
			builder.put(grammarAccess.getLiteralAnnotationArgumentAccess().getLiteralAssignment(), "rule__LiteralAnnotationArgument__LiteralAssignment");
			builder.put(grammarAccess.getTypeRefAnnotationArgumentAccess().getTypeRefAssignment(), "rule__TypeRefAnnotationArgument__TypeRefAssignment");
			builder.put(grammarAccess.getAnnotationListAccess().getAnnotationsAssignment_0_0_2(), "rule__AnnotationList__AnnotationsAssignment_0_0_2");
			builder.put(grammarAccess.getAnnotationListAccess().getAnnotationsAssignment_1(), "rule__AnnotationList__AnnotationsAssignment_1");
			builder.put(grammarAccess.getExpressionAnnotationListAccess().getAnnotationsAssignment_1(), "rule__ExpressionAnnotationList__AnnotationsAssignment_1");
			builder.put(grammarAccess.getPropertyAssignmentAnnotationListAccess().getAnnotationsAssignment_1(), "rule__PropertyAssignmentAnnotationList__AnnotationsAssignment_1");
			builder.put(grammarAccess.getN4MemberAnnotationListAccess().getAnnotationsAssignment_1(), "rule__N4MemberAnnotationList__AnnotationsAssignment_1");
			builder.put(grammarAccess.getTypeReferenceAccess().getAstNamespaceAssignment_0_0(), "rule__TypeReference__AstNamespaceAssignment_0_0");
			builder.put(grammarAccess.getTypeReferenceAccess().getDeclaredTypeAssignment_1(), "rule__TypeReference__DeclaredTypeAssignment_1");
			builder.put(grammarAccess.getN4ClassDeclarationAccess().getDeclaredModifiersAssignment_0_0_0(), "rule__N4ClassDeclaration__DeclaredModifiersAssignment_0_0_0");
			builder.put(grammarAccess.getN4ClassDeclarationAccess().getTypingStrategyAssignment_0_0_2(), "rule__N4ClassDeclaration__TypingStrategyAssignment_0_0_2");
			builder.put(grammarAccess.getN4ClassDeclarationAccess().getNameAssignment_0_0_3(), "rule__N4ClassDeclaration__NameAssignment_0_0_3");
			builder.put(grammarAccess.getMembersAccess().getOwnedMembersRawAssignment_1(), "rule__Members__OwnedMembersRawAssignment_1");
			builder.put(grammarAccess.getClassExtendsClauseAccess().getSuperClassRefAssignment_1_0(), "rule__ClassExtendsClause__SuperClassRefAssignment_1_0");
			builder.put(grammarAccess.getClassExtendsClauseAccess().getSuperClassExpressionAssignment_1_1(), "rule__ClassExtendsClause__SuperClassExpressionAssignment_1_1");
			builder.put(grammarAccess.getClassImplementsListAccess().getImplementedInterfaceRefsAssignment_1(), "rule__ClassImplementsList__ImplementedInterfaceRefsAssignment_1");
			builder.put(grammarAccess.getClassImplementsListAccess().getImplementedInterfaceRefsAssignment_2_1(), "rule__ClassImplementsList__ImplementedInterfaceRefsAssignment_2_1");
			builder.put(grammarAccess.getN4ClassExpressionAccess().getNameAssignment_2(), "rule__N4ClassExpression__NameAssignment_2");
			builder.put(grammarAccess.getN4InterfaceDeclarationAccess().getDeclaredModifiersAssignment_0_0_0(), "rule__N4InterfaceDeclaration__DeclaredModifiersAssignment_0_0_0");
			builder.put(grammarAccess.getN4InterfaceDeclarationAccess().getTypingStrategyAssignment_0_0_2(), "rule__N4InterfaceDeclaration__TypingStrategyAssignment_0_0_2");
			builder.put(grammarAccess.getN4InterfaceDeclarationAccess().getNameAssignment_0_0_3(), "rule__N4InterfaceDeclaration__NameAssignment_0_0_3");
			builder.put(grammarAccess.getInterfaceExtendsListAccess().getSuperInterfaceRefsAssignment_1(), "rule__InterfaceExtendsList__SuperInterfaceRefsAssignment_1");
			builder.put(grammarAccess.getInterfaceExtendsListAccess().getSuperInterfaceRefsAssignment_2_1(), "rule__InterfaceExtendsList__SuperInterfaceRefsAssignment_2_1");
			builder.put(grammarAccess.getN4EnumDeclarationAccess().getDeclaredModifiersAssignment_0_0_1(), "rule__N4EnumDeclaration__DeclaredModifiersAssignment_0_0_1");
			builder.put(grammarAccess.getN4EnumDeclarationAccess().getNameAssignment_0_0_3(), "rule__N4EnumDeclaration__NameAssignment_0_0_3");
			builder.put(grammarAccess.getN4EnumDeclarationAccess().getLiteralsAssignment_2_0(), "rule__N4EnumDeclaration__LiteralsAssignment_2_0");
			builder.put(grammarAccess.getN4EnumDeclarationAccess().getLiteralsAssignment_2_1_1(), "rule__N4EnumDeclaration__LiteralsAssignment_2_1_1");
			builder.put(grammarAccess.getN4EnumLiteralAccess().getNameAssignment_0(), "rule__N4EnumLiteral__NameAssignment_0");
			builder.put(grammarAccess.getN4EnumLiteralAccess().getValueAssignment_1_1(), "rule__N4EnumLiteral__ValueAssignment_1_1");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getDeclaredModifiersAssignment_1_0_0_0_1(), "rule__AnnotatedN4MemberDeclaration__DeclaredModifiersAssignment_1_0_0_0_1");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getBodyAssignment_1_0_1(), "rule__AnnotatedN4MemberDeclaration__BodyAssignment_1_0_1");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getDeclaredModifiersAssignment_1_1_0_0_1(), "rule__AnnotatedN4MemberDeclaration__DeclaredModifiersAssignment_1_1_0_0_1");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getDeclaredNameAssignment_1_1_0_0_3(), "rule__AnnotatedN4MemberDeclaration__DeclaredNameAssignment_1_1_0_0_3");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getDeclaredOptionalAssignment_1_1_1(), "rule__AnnotatedN4MemberDeclaration__DeclaredOptionalAssignment_1_1_1");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getFparAssignment_1_1_3(), "rule__AnnotatedN4MemberDeclaration__FparAssignment_1_1_3");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getBodyAssignment_1_1_5(), "rule__AnnotatedN4MemberDeclaration__BodyAssignment_1_1_5");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getDeclaredModifiersAssignment_1_2_0_0_1(), "rule__AnnotatedN4MemberDeclaration__DeclaredModifiersAssignment_1_2_0_0_1");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getGeneratorAssignment_1_2_0_0_4_0_0(), "rule__AnnotatedN4MemberDeclaration__GeneratorAssignment_1_2_0_0_4_0_0");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getDeclaredNameAssignment_1_2_0_0_4_0_1(), "rule__AnnotatedN4MemberDeclaration__DeclaredNameAssignment_1_2_0_0_4_0_1");
			builder.put(grammarAccess.getAnnotatedN4MemberDeclarationAccess().getDeclaredNameAssignment_1_2_0_0_4_1_1(), "rule__AnnotatedN4MemberDeclaration__DeclaredNameAssignment_1_2_0_0_4_1_1");
			builder.put(grammarAccess.getFieldDeclarationImplAccess().getDeclaredModifiersAssignment_0(), "rule__FieldDeclarationImpl__DeclaredModifiersAssignment_0");
			builder.put(grammarAccess.getFieldDeclarationImplAccess().getDeclaredNameAssignment_2(), "rule__FieldDeclarationImpl__DeclaredNameAssignment_2");
			builder.put(grammarAccess.getFieldDeclarationImplAccess().getDeclaredOptionalAssignment_3(), "rule__FieldDeclarationImpl__DeclaredOptionalAssignment_3");
			builder.put(grammarAccess.getFieldDeclarationImplAccess().getExpressionAssignment_5_1(), "rule__FieldDeclarationImpl__ExpressionAssignment_5_1");
			builder.put(grammarAccess.getN4MethodDeclarationAccess().getDeclaredModifiersAssignment_0_0_1(), "rule__N4MethodDeclaration__DeclaredModifiersAssignment_0_0_1");
			builder.put(grammarAccess.getN4MethodDeclarationAccess().getGeneratorAssignment_0_0_4_0_0(), "rule__N4MethodDeclaration__GeneratorAssignment_0_0_4_0_0");
			builder.put(grammarAccess.getN4MethodDeclarationAccess().getDeclaredNameAssignment_0_0_4_0_1(), "rule__N4MethodDeclaration__DeclaredNameAssignment_0_0_4_0_1");
			builder.put(grammarAccess.getN4MethodDeclarationAccess().getDeclaredNameAssignment_0_0_4_1_1(), "rule__N4MethodDeclaration__DeclaredNameAssignment_0_0_4_1_1");
			builder.put(grammarAccess.getMethodParamsAndBodyAccess().getBodyAssignment_1(), "rule__MethodParamsAndBody__BodyAssignment_1");
			builder.put(grammarAccess.getMethodParamsReturnAndBodyAccess().getBodyAssignment_2(), "rule__MethodParamsReturnAndBody__BodyAssignment_2");
			builder.put(grammarAccess.getN4GetterDeclarationAccess().getDeclaredModifiersAssignment_0_0_1(), "rule__N4GetterDeclaration__DeclaredModifiersAssignment_0_0_1");
			builder.put(grammarAccess.getN4GetterDeclarationAccess().getBodyAssignment_1(), "rule__N4GetterDeclaration__BodyAssignment_1");
			builder.put(grammarAccess.getGetterHeaderAccess().getDeclaredNameAssignment_2(), "rule__GetterHeader__DeclaredNameAssignment_2");
			builder.put(grammarAccess.getGetterHeaderAccess().getDeclaredOptionalAssignment_3(), "rule__GetterHeader__DeclaredOptionalAssignment_3");
			builder.put(grammarAccess.getN4SetterDeclarationAccess().getDeclaredModifiersAssignment_0_0_1(), "rule__N4SetterDeclaration__DeclaredModifiersAssignment_0_0_1");
			builder.put(grammarAccess.getN4SetterDeclarationAccess().getDeclaredNameAssignment_0_0_3(), "rule__N4SetterDeclaration__DeclaredNameAssignment_0_0_3");
			builder.put(grammarAccess.getN4SetterDeclarationAccess().getDeclaredOptionalAssignment_1(), "rule__N4SetterDeclaration__DeclaredOptionalAssignment_1");
			builder.put(grammarAccess.getN4SetterDeclarationAccess().getFparAssignment_3(), "rule__N4SetterDeclaration__FparAssignment_3");
			builder.put(grammarAccess.getN4SetterDeclarationAccess().getBodyAssignment_5(), "rule__N4SetterDeclaration__BodyAssignment_5");
			builder.put(grammarAccess.getObjectBindingPatternAccess().getPropertiesAssignment_2_0(), "rule__ObjectBindingPattern__PropertiesAssignment_2_0");
			builder.put(grammarAccess.getObjectBindingPatternAccess().getPropertiesAssignment_2_1_1(), "rule__ObjectBindingPattern__PropertiesAssignment_2_1_1");
			builder.put(grammarAccess.getArrayBindingPatternAccess().getElementsAssignment_2(), "rule__ArrayBindingPattern__ElementsAssignment_2");
			builder.put(grammarAccess.getArrayBindingPatternAccess().getElementsAssignment_3_0(), "rule__ArrayBindingPattern__ElementsAssignment_3_0");
			builder.put(grammarAccess.getArrayBindingPatternAccess().getElementsAssignment_3_1_1(), "rule__ArrayBindingPattern__ElementsAssignment_3_1_1");
			builder.put(grammarAccess.getArrayBindingPatternAccess().getElementsAssignment_3_1_2(), "rule__ArrayBindingPattern__ElementsAssignment_3_1_2");
			builder.put(grammarAccess.getArrayBindingPatternAccess().getElementsAssignment_3_2_1(), "rule__ArrayBindingPattern__ElementsAssignment_3_2_1");
			builder.put(grammarAccess.getBindingPropertyAccess().getDeclaredNameAssignment_0_0_0_0(), "rule__BindingProperty__DeclaredNameAssignment_0_0_0_0");
			builder.put(grammarAccess.getBindingPropertyAccess().getValueAssignment_0_1(), "rule__BindingProperty__ValueAssignment_0_1");
			builder.put(grammarAccess.getBindingPropertyAccess().getValueAssignment_1(), "rule__BindingProperty__ValueAssignment_1");
			builder.put(grammarAccess.getSingleNameBindingAccess().getVarDeclAssignment(), "rule__SingleNameBinding__VarDeclAssignment");
			builder.put(grammarAccess.getBindingRestElementAccess().getRestAssignment_0(), "rule__BindingRestElement__RestAssignment_0");
			builder.put(grammarAccess.getBindingElementImplAccess().getNestedPatternAssignment_0_0_0(), "rule__BindingElementImpl__NestedPatternAssignment_0_0_0");
			builder.put(grammarAccess.getBindingElementImplAccess().getExpressionAssignment_0_1_1(), "rule__BindingElementImpl__ExpressionAssignment_0_1_1");
			builder.put(grammarAccess.getBindingElementImplAccess().getVarDeclAssignment_1(), "rule__BindingElementImpl__VarDeclAssignment_1");
			builder.put(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_0(), "rule__LiteralOrComputedPropertyName__LiteralNameAssignment_0");
			builder.put(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_1(), "rule__LiteralOrComputedPropertyName__LiteralNameAssignment_1");
			builder.put(grammarAccess.getLiteralOrComputedPropertyNameAccess().getLiteralNameAssignment_2(), "rule__LiteralOrComputedPropertyName__LiteralNameAssignment_2");
			builder.put(grammarAccess.getLiteralOrComputedPropertyNameAccess().getExpressionAssignment_3_1(), "rule__LiteralOrComputedPropertyName__ExpressionAssignment_3_1");
			builder.put(grammarAccess.getJSXElementAccess().getJsxElementNameAssignment_1(), "rule__JSXElement__JsxElementNameAssignment_1");
			builder.put(grammarAccess.getJSXElementAccess().getJsxChildrenAssignment_3_0_1(), "rule__JSXElement__JsxChildrenAssignment_3_0_1");
			builder.put(grammarAccess.getJSXFragmentAccess().getJsxChildrenAssignment_0_1_2(), "rule__JSXFragment__JsxChildrenAssignment_0_1_2");
			builder.put(grammarAccess.getJSXClosingElementAccess().getJsxClosingNameAssignment_2(), "rule__JSXClosingElement__JsxClosingNameAssignment_2");
			builder.put(grammarAccess.getJSXExpressionAccess().getExpressionAssignment_1(), "rule__JSXExpression__ExpressionAssignment_1");
			builder.put(grammarAccess.getJSXElementNameAccess().getExpressionAssignment(), "rule__JSXElementName__ExpressionAssignment");
			builder.put(grammarAccess.getJSXAttributesAccess().getJsxAttributesAssignment(), "rule__JSXAttributes__JsxAttributesAssignment");
			builder.put(grammarAccess.getJSXSpreadAttributeAccess().getExpressionAssignment_2(), "rule__JSXSpreadAttribute__ExpressionAssignment_2");
			builder.put(grammarAccess.getJSXPropertyAttributeAccess().getPropertyAssignment_0(), "rule__JSXPropertyAttribute__PropertyAssignment_0");
			builder.put(grammarAccess.getJSXPropertyAttributeAccess().getJsxAttributeValueAssignment_1_1_0(), "rule__JSXPropertyAttribute__JsxAttributeValueAssignment_1_1_0");
			builder.put(grammarAccess.getJSXPropertyAttributeAccess().getJsxAttributeValueAssignment_1_1_1_1(), "rule__JSXPropertyAttribute__JsxAttributeValueAssignment_1_1_1_1");
			builder.put(grammarAccess.getVersionDeclarationAccess().getDeclaredVersionAssignment(), "rule__VersionDeclaration__DeclaredVersionAssignment");
			builder.put(grammarAccess.getTypeRefAccess().getTypeRefsAssignment_1_1_1(), "rule__TypeRef__TypeRefsAssignment_1_1_1");
			builder.put(grammarAccess.getIntersectionTypeExpressionAccess().getTypeRefsAssignment_1_1_1(), "rule__IntersectionTypeExpression__TypeRefsAssignment_1_1_1");
			builder.put(grammarAccess.getTypeRefWithModifiersAccess().getFollowedByQuestionMarkAssignment_1(), "rule__TypeRefWithModifiers__FollowedByQuestionMarkAssignment_1");
			builder.put(grammarAccess.getTypeRefWithoutModifiersAccess().getDynamicAssignment_0_1(), "rule__TypeRefWithoutModifiers__DynamicAssignment_0_1");
			builder.put(grammarAccess.getThisTypeRefStructuralAccess().getDefinedTypingStrategyAssignment_0(), "rule__ThisTypeRefStructural__DefinedTypingStrategyAssignment_0");
			builder.put(grammarAccess.getFunctionTypeExpressionOLDAccess().getDeclaredThisTypeAssignment_2_3(), "rule__FunctionTypeExpressionOLD__DeclaredThisTypeAssignment_2_3");
			builder.put(grammarAccess.getFunctionTypeExpressionOLDAccess().getOwnedTypeVarsAssignment_4_1(), "rule__FunctionTypeExpressionOLD__OwnedTypeVarsAssignment_4_1");
			builder.put(grammarAccess.getFunctionTypeExpressionOLDAccess().getOwnedTypeVarsAssignment_4_2_1(), "rule__FunctionTypeExpressionOLD__OwnedTypeVarsAssignment_4_2_1");
			builder.put(grammarAccess.getArrowFunctionTypeExpressionAccess().getReturnTypeRefAssignment_1(), "rule__ArrowFunctionTypeExpression__ReturnTypeRefAssignment_1");
			builder.put(grammarAccess.getTAnonymousFormalParameterListAccess().getFparsAssignment_0(), "rule__TAnonymousFormalParameterList__FparsAssignment_0");
			builder.put(grammarAccess.getTAnonymousFormalParameterListAccess().getFparsAssignment_1_1(), "rule__TAnonymousFormalParameterList__FparsAssignment_1_1");
			builder.put(grammarAccess.getTAnonymousFormalParameterAccess().getVariadicAssignment_0(), "rule__TAnonymousFormalParameter__VariadicAssignment_0");
			builder.put(grammarAccess.getTAnonymousFormalParameterAccess().getNameAssignment_1_0_0_0(), "rule__TAnonymousFormalParameter__NameAssignment_1_0_0_0");
			builder.put(grammarAccess.getTAnonymousFormalParameterAccess().getTypeRefAssignment_1_1(), "rule__TAnonymousFormalParameter__TypeRefAssignment_1_1");
			builder.put(grammarAccess.getTFormalParameterAccess().getVariadicAssignment_0(), "rule__TFormalParameter__VariadicAssignment_0");
			builder.put(grammarAccess.getTFormalParameterAccess().getNameAssignment_1(), "rule__TFormalParameter__NameAssignment_1");
			builder.put(grammarAccess.getDefaultFormalParameterAccess().getHasInitializerAssignmentAssignment_0(), "rule__DefaultFormalParameter__HasInitializerAssignmentAssignment_0");
			builder.put(grammarAccess.getDefaultFormalParameterAccess().getAstInitializerAssignment_1(), "rule__DefaultFormalParameter__AstInitializerAssignment_1");
			builder.put(grammarAccess.getUnionTypeExpressionOLDAccess().getTypeRefsAssignment_3(), "rule__UnionTypeExpressionOLD__TypeRefsAssignment_3");
			builder.put(grammarAccess.getUnionTypeExpressionOLDAccess().getTypeRefsAssignment_4_1(), "rule__UnionTypeExpressionOLD__TypeRefsAssignment_4_1");
			builder.put(grammarAccess.getIntersectionTypeExpressionOLDAccess().getTypeRefsAssignment_3(), "rule__IntersectionTypeExpressionOLD__TypeRefsAssignment_3");
			builder.put(grammarAccess.getIntersectionTypeExpressionOLDAccess().getTypeRefsAssignment_4_1(), "rule__IntersectionTypeExpressionOLD__TypeRefsAssignment_4_1");
			builder.put(grammarAccess.getParameterizedTypeRefStructuralAccess().getDefinedTypingStrategyAssignment_0_0_0(), "rule__ParameterizedTypeRefStructural__DefinedTypingStrategyAssignment_0_0_0");
			builder.put(grammarAccess.getParameterizedTypeRefStructuralAccess().getDefinedTypingStrategyAssignment_0_1_1(), "rule__ParameterizedTypeRefStructural__DefinedTypingStrategyAssignment_0_1_1");
			builder.put(grammarAccess.getArrayTypeRefAccess().getArrayTypeLiteralAssignment_0(), "rule__ArrayTypeRef__ArrayTypeLiteralAssignment_0");
			builder.put(grammarAccess.getArrayTypeRefAccess().getTypeArgsAssignment_1(), "rule__ArrayTypeRef__TypeArgsAssignment_1");
			builder.put(grammarAccess.getVersionRequestAccess().getRequestedVersionAssignment(), "rule__VersionRequest__RequestedVersionAssignment");
			builder.put(grammarAccess.getTypeArgumentsAccess().getTypeArgsAssignment_1(), "rule__TypeArguments__TypeArgsAssignment_1");
			builder.put(grammarAccess.getTypeArgumentsAccess().getTypeArgsAssignment_2_1(), "rule__TypeArguments__TypeArgsAssignment_2_1");
			builder.put(grammarAccess.getTStructMemberListAccess().getAstStructuralMembersAssignment_1_0(), "rule__TStructMemberList__AstStructuralMembersAssignment_1_0");
			builder.put(grammarAccess.getTStructMethodAccess().getNameAssignment_0_0_2(), "rule__TStructMethod__NameAssignment_0_0_2");
			builder.put(grammarAccess.getTypeVariablesAccess().getTypeVarsAssignment_1(), "rule__TypeVariables__TypeVarsAssignment_1");
			builder.put(grammarAccess.getTypeVariablesAccess().getTypeVarsAssignment_2_1(), "rule__TypeVariables__TypeVarsAssignment_2_1");
			builder.put(grammarAccess.getColonSepDeclaredTypeRefAccess().getDeclaredTypeRefAssignment_1(), "rule__ColonSepDeclaredTypeRef__DeclaredTypeRefAssignment_1");
			builder.put(grammarAccess.getColonSepTypeRefAccess().getTypeRefAssignment_1(), "rule__ColonSepTypeRef__TypeRefAssignment_1");
			builder.put(grammarAccess.getColonSepReturnTypeRefAccess().getReturnTypeRefAssignment_1(), "rule__ColonSepReturnTypeRef__ReturnTypeRefAssignment_1");
			builder.put(grammarAccess.getTStructFieldAccess().getNameAssignment_0(), "rule__TStructField__NameAssignment_0");
			builder.put(grammarAccess.getTStructFieldAccess().getOptionalAssignment_1(), "rule__TStructField__OptionalAssignment_1");
			builder.put(grammarAccess.getTStructGetterAccess().getNameAssignment_0_0_2(), "rule__TStructGetter__NameAssignment_0_0_2");
			builder.put(grammarAccess.getTStructGetterAccess().getOptionalAssignment_1(), "rule__TStructGetter__OptionalAssignment_1");
			builder.put(grammarAccess.getTStructSetterAccess().getNameAssignment_0_0_2(), "rule__TStructSetter__NameAssignment_0_0_2");
			builder.put(grammarAccess.getTStructSetterAccess().getOptionalAssignment_1(), "rule__TStructSetter__OptionalAssignment_1");
			builder.put(grammarAccess.getTStructSetterAccess().getFparAssignment_3(), "rule__TStructSetter__FparAssignment_3");
			builder.put(grammarAccess.getTypeTypeRefAccess().getConstructorRefAssignment_1_1(), "rule__TypeTypeRef__ConstructorRefAssignment_1_1");
			builder.put(grammarAccess.getTypeTypeRefAccess().getTypeArgAssignment_3(), "rule__TypeTypeRef__TypeArgAssignment_3");
			builder.put(grammarAccess.getWildcardAccess().getDeclaredUpperBoundAssignment_1_0_1(), "rule__Wildcard__DeclaredUpperBoundAssignment_1_0_1");
			builder.put(grammarAccess.getWildcardAccess().getDeclaredLowerBoundAssignment_1_1_1(), "rule__Wildcard__DeclaredLowerBoundAssignment_1_1_1");
			builder.put(grammarAccess.getWildcardNewNotationAccess().getUsingInOutNotationAssignment_0_0(), "rule__WildcardNewNotation__UsingInOutNotationAssignment_0_0");
			builder.put(grammarAccess.getWildcardNewNotationAccess().getDeclaredUpperBoundAssignment_0_1(), "rule__WildcardNewNotation__DeclaredUpperBoundAssignment_0_1");
			builder.put(grammarAccess.getWildcardNewNotationAccess().getUsingInOutNotationAssignment_1_0(), "rule__WildcardNewNotation__UsingInOutNotationAssignment_1_0");
			builder.put(grammarAccess.getWildcardNewNotationAccess().getDeclaredLowerBoundAssignment_1_1(), "rule__WildcardNewNotation__DeclaredLowerBoundAssignment_1_1");
		}
	}
	
	@Inject
	private NameMappings nameMappings;

	@Inject
	private N4JSGrammarAccess grammarAccess;

	@Override
	protected InternalN4JSParser createParser() {
		InternalN4JSParser result = new InternalN4JSParser(null);
		result.setGrammarAccess(grammarAccess);
		return result;
	}

	@Override
	protected String getRuleName(AbstractElement element) {
		return nameMappings.getRuleName(element);
	}

	@Override
	protected Collection<FollowElement> getFollowElements(AbstractInternalContentAssistParser parser) {
		try {
			InternalN4JSParser typedParser = (InternalN4JSParser) parser;
			typedParser.entryRuleScript();
			return typedParser.getFollowElements();
		} catch(RecognitionException ex) {
			throw new RuntimeException(ex);
		}
	}

	@Override
	protected String[] getInitialHiddenTokens() {
		return new String[] { "RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT", "RULE_EOL" };
	}

	public N4JSGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(N4JSGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}

	public NameMappings getNameMappings() {
		return nameMappings;
	}

	public void setNameMappings(NameMappings nameMappings) {
		this.nameMappings = nameMappings;
	}
}
