package org.eclipse.n4js.ui.editor.syntaxcoloring;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ui.editor.syntaxcoloring.AbstractInternalHighlightingAntlrParser;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
@SuppressWarnings("all")
public class InternalN4JSParser extends AbstractInternalHighlightingAntlrParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "Intersection", "Constructor", "Implements", "Instanceof", "Promisify", "Interface", "Protected", "Abstract", "Continue", "Debugger", "External", "Function", "Default", "Extends", "Finally", "Private", "Project", "Delete", "Export", "Import", "Public", "Return", "Static", "Switch", "Target", "Typeof", "Async", "Await", "Break", "Catch", "Class", "Const", "False", "Super", "Throw", "Union", "While", "Yield", "This", "Case", "Else", "Enum", "From", "Null", "This_1", "True", "Type", "Void", "With", "ExclamationMarkEqualsSignEqualsSign", "FullStopFullStopFullStop", "LessThanSignLessThanSignEqualsSign", "EqualsSignEqualsSignEqualsSign", "For", "Get", "Let", "New", "Out", "Set", "Try", "Var", "ExclamationMarkEqualsSign", "PercentSignEqualsSign", "AmpersandAmpersand", "AmpersandEqualsSign", "AsteriskEqualsSign", "PlusSignPlusSign", "PlusSignEqualsSign", "HyphenMinusHyphenMinus", "HyphenMinusEqualsSign", "SolidusEqualsSign", "LessThanSignLessThanSign", "LessThanSignEqualsSign", "EqualsSignEqualsSign", "EqualsSignGreaterThanSign", "CommercialAtCommercialAt", "CircumflexAccentEqualsSign", "As", "Do", "If", "In", "Of", "VerticalLineEqualsSign", "VerticalLineVerticalLine", "ExclamationMark", "PercentSign", "Ampersand", "LeftParenthesis", "RightParenthesis", "Asterisk", "PlusSign", "Comma", "HyphenMinus", "FullStop", "Solidus", "Colon", "Semicolon", "LessThanSign", "EqualsSign", "GreaterThanSign", "QuestionMark", "CommercialAt", "LeftSquareBracket", "RightSquareBracket", "CircumflexAccent", "LeftCurlyBracket", "VerticalLine", "RightCurlyBracket", "Tilde", "RULE_DECIMAL_DIGIT_FRAGMENT", "RULE_EXPONENT_PART", "RULE_DECIMAL_INTEGER_LITERAL_FRAGMENT", "RULE_DOUBLE", "RULE_INT_SUFFIX", "RULE_HEX_INT", "RULE_BINARY_INT", "RULE_OCTAL_INT", "RULE_LEGACY_OCTAL_INT", "RULE_IDENTIFIER_PART", "RULE_SCIENTIFIC_INT", "RULE_SIGNED_INT", "RULE_IDENTIFIER", "RULE_DOUBLE_STRING_CHAR", "RULE_SINGLE_STRING_CHAR", "RULE_STRING", "RULE_LINE_TERMINATOR_FRAGMENT", "RULE_LINE_TERMINATOR_SEQUENCE_FRAGMENT", "RULE_BACKSLASH_SEQUENCE", "RULE_REGEX_CHAR_OR_BRACKET", "RULE_REGEX_CHAR", "RULE_ACTUAL_REGEX_TAIL", "RULE_REGEX_START", "RULE_REGEX_TAIL", "RULE_TEMPLATE_LITERAL_CHAR", "RULE_TEMPLATE_HEAD", "RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL", "RULE_ACTUAL_TEMPLATE_END", "RULE_TEMPLATE_MIDDLE", "RULE_TEMPLATE_END", "RULE_TEMPLATE_CONTINUATION", "RULE_NO_LINE_TERMINATOR", "RULE_INCOMPLETE_ASYNC_ARROW", "RULE_STRUCTMODSUFFIX", "RULE_IDENTIFIER_START", "RULE_INT", "RULE_ML_COMMENT_FRAGMENT", "RULE_ML_COMMENT", "RULE_SL_COMMENT", "RULE_EOL", "RULE_WHITESPACE_FRAGMENT", "RULE_WS", "RULE_HEX_DIGIT", "RULE_UNICODE_ESCAPE_FRAGMENT", "RULE_UNICODE_LETTER_FRAGMENT", "RULE_UNICODE_COMBINING_MARK_FRAGMENT", "RULE_UNICODE_DIGIT_FRAGMENT", "RULE_UNICODE_CONNECTOR_PUNCTUATION_FRAGMENT", "RULE_ZWNJ", "RULE_ZWJ", "RULE_DOT_DOT", "RULE_VERSION", "RULE_BOM", "RULE_UNICODE_SPACE_SEPARATOR_FRAGMENT", "RULE_SL_COMMENT_FRAGMENT", "RULE_ANY_OTHER"
    };
    public static final int Delete=21;
    public static final int Enum=45;
    public static final int RULE_REGEX_CHAR=133;
    public static final int Import=23;
    public static final int EqualsSignGreaterThanSign=78;
    public static final int Var=64;
    public static final int RULE_ACTUAL_TEMPLATE_END=140;
    public static final int Break=32;
    public static final int False=36;
    public static final int LessThanSign=101;
    public static final int LeftParenthesis=91;
    public static final int RULE_VERSION=164;
    public static final int RULE_TEMPLATE_LITERAL_CHAR=137;
    public static final int Throw=38;
    public static final int Private=19;
    public static final int Extends=17;
    public static final int RULE_REGEX_TAIL=136;
    public static final int ExclamationMark=88;
    public static final int ExclamationMarkEqualsSignEqualsSign=53;
    public static final int GreaterThanSign=103;
    public static final int RULE_LINE_TERMINATOR_SEQUENCE_FRAGMENT=130;
    public static final int RULE_TEMPLATE_HEAD=138;
    public static final int RULE_EOL=152;
    public static final int RULE_STRUCTMODSUFFIX=146;
    public static final int RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL=139;
    public static final int Out=61;
    public static final int RULE_ZWNJ=161;
    public static final int EqualsSignEqualsSign=77;
    public static final int Project=20;
    public static final int RULE_OCTAL_INT=120;
    public static final int Switch=27;
    public static final int VerticalLine=110;
    public static final int PlusSign=94;
    public static final int RULE_INT=148;
    public static final int Get=58;
    public static final int RULE_ML_COMMENT=150;
    public static final int LeftSquareBracket=106;
    public static final int If=83;
    public static final int LessThanSignLessThanSign=75;
    public static final int RULE_REGEX_START=135;
    public static final int Finally=18;
    public static final int Intersection=4;
    public static final int Set=62;
    public static final int RULE_UNICODE_ESCAPE_FRAGMENT=156;
    public static final int In=84;
    public static final int Catch=33;
    public static final int VerticalLineVerticalLine=87;
    public static final int RULE_SCIENTIFIC_INT=123;
    public static final int RULE_TEMPLATE_MIDDLE=141;
    public static final int RULE_INCOMPLETE_ASYNC_ARROW=145;
    public static final int RULE_EXPONENT_PART=114;
    public static final int Union=39;
    public static final int Case=43;
    public static final int RULE_REGEX_CHAR_OR_BRACKET=132;
    public static final int Comma=95;
    public static final int RULE_SL_COMMENT_FRAGMENT=167;
    public static final int As=81;
    public static final int HyphenMinus=96;
    public static final int Target=28;
    public static final int RULE_IDENTIFIER_PART=122;
    public static final int RULE_UNICODE_SPACE_SEPARATOR_FRAGMENT=166;
    public static final int Export=22;
    public static final int CommercialAtCommercialAt=79;
    public static final int LessThanSignEqualsSign=76;
    public static final int RightCurlyBracket=111;
    public static final int Solidus=98;
    public static final int PercentSignEqualsSign=66;
    public static final int RULE_HEX_INT=118;
    public static final int FullStop=97;
    public static final int Abstract=11;
    public static final int Constructor=5;
    public static final int Promisify=8;
    public static final int RULE_SIGNED_INT=124;
    public static final int Default=16;
    public static final int CommercialAt=105;
    public static final int RULE_LINE_TERMINATOR_FRAGMENT=129;
    public static final int Semicolon=100;
    public static final int Type=50;
    public static final int PlusSignPlusSign=70;
    public static final int QuestionMark=104;
    public static final int Else=44;
    public static final int RULE_HEX_DIGIT=155;
    public static final int RULE_UNICODE_CONNECTOR_PUNCTUATION_FRAGMENT=160;
    public static final int Yield=41;
    public static final int ExclamationMarkEqualsSign=65;
    public static final int Interface=9;
    public static final int RULE_TEMPLATE_CONTINUATION=143;
    public static final int HyphenMinusHyphenMinus=72;
    public static final int New=60;
    public static final int Null=47;
    public static final int AmpersandEqualsSign=68;
    public static final int Typeof=29;
    public static final int SolidusEqualsSign=74;
    public static final int True=49;
    public static final int FullStopFullStopFullStop=54;
    public static final int PercentSign=89;
    public static final int RULE_IDENTIFIER_START=147;
    public static final int Implements=6;
    public static final int RULE_WHITESPACE_FRAGMENT=153;
    public static final int Super=37;
    public static final int Async=30;
    public static final int This=42;
    public static final int Ampersand=90;
    public static final int Try=63;
    public static final int AsteriskEqualsSign=69;
    public static final int VerticalLineEqualsSign=86;
    public static final int Void=51;
    public static final int RightSquareBracket=107;
    public static final int RULE_BINARY_INT=119;
    public static final int Protected=10;
    public static final int Const=35;
    public static final int RULE_ACTUAL_REGEX_TAIL=134;
    public static final int For=57;
    public static final int RightParenthesis=92;
    public static final int RULE_UNICODE_COMBINING_MARK_FRAGMENT=158;
    public static final int Do=82;
    public static final int Public=24;
    public static final int RULE_DOUBLE_STRING_CHAR=126;
    public static final int RULE_LEGACY_OCTAL_INT=121;
    public static final int EqualsSignEqualsSignEqualsSign=56;
    public static final int RULE_TEMPLATE_END=142;
    public static final int This_1=48;
    public static final int RULE_DOT_DOT=163;
    public static final int RULE_NO_LINE_TERMINATOR=144;
    public static final int External=14;
    public static final int CircumflexAccentEqualsSign=80;
    public static final int Class=34;
    public static final int Static=26;
    public static final int Debugger=13;
    public static final int RULE_SINGLE_STRING_CHAR=127;
    public static final int LessThanSignLessThanSignEqualsSign=55;
    public static final int RULE_INT_SUFFIX=117;
    public static final int RULE_IDENTIFIER=125;
    public static final int RULE_ML_COMMENT_FRAGMENT=149;
    public static final int RULE_STRING=128;
    public static final int Continue=12;
    public static final int RULE_SL_COMMENT=151;
    public static final int With=52;
    public static final int EqualsSign=102;
    public static final int Function=15;
    public static final int RULE_ZWJ=162;
    public static final int RULE_UNICODE_DIGIT_FRAGMENT=159;
    public static final int AmpersandAmpersand=67;
    public static final int RULE_DOUBLE=116;
    public static final int Instanceof=7;
    public static final int Colon=99;
    public static final int HyphenMinusEqualsSign=73;
    public static final int RULE_BACKSLASH_SEQUENCE=131;
    public static final int EOF=-1;
    public static final int Asterisk=93;
    public static final int PlusSignEqualsSign=71;
    public static final int Return=25;
    public static final int RULE_WS=154;
    public static final int RULE_BOM=165;
    public static final int LeftCurlyBracket=109;
    public static final int Tilde=112;
    public static final int From=46;
    public static final int RULE_ANY_OTHER=168;
    public static final int While=40;
    public static final int CircumflexAccent=108;
    public static final int RULE_UNICODE_LETTER_FRAGMENT=157;
    public static final int RULE_DECIMAL_DIGIT_FRAGMENT=113;
    public static final int Of=85;
    public static final int RULE_DECIMAL_INTEGER_LITERAL_FRAGMENT=115;
    public static final int Let=59;
    public static final int Await=31;


        public InternalN4JSParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalN4JSParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalN4JSParser.tokenNames; }
    public String getGrammarFileName() { return "InternalN4JSParser.g"; }



     	private N4JSGrammarAccess grammarAccess;

        public InternalN4JSParser(TokenStream input, N4JSGrammarAccess grammarAccess) {
            this(input);
            this.grammarAccess = grammarAccess;
        }

    	protected boolean forcedRewind(int marker) { return true; } // overridden in subtype
    	protected void promoteEOL() {} // overridden in subtype
    	protected boolean hasDisallowedEOL() { return false; } // overridden in subtype
    	protected boolean isTypeRefNoTrailingLineBreak() { return true; } // overridden in subtype
    	protected void setInRegularExpression() {} // overridden in subtype
    	protected void setInTemplateSegment() {} // overridden in subtype
    	protected void announce(Token token, AbstractElement element) {} // overridden in subtype
    	protected void announce(Token start, Token stop, AbstractElement element) {} // overridden in subtype
    public final void entryRuleScript() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleScript();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }
    public final void ruleScript() throws RecognitionException {
        InternalN4JSParser.ruleScriptAnnotation_return AnnotationsScriptAnnotationParserRuleCall_1_0_0 = null;

        InternalN4JSParser.ruleScriptElement_return ScriptElementsScriptElementParserRuleCall_1_1_0 = null;




        try {
            {
            {
            loop1:
            do {
                int alt1=3;
                int LA1_0 = input.LA(1);

                if ( (LA1_0==CommercialAtCommercialAt) ) {
                    alt1=1;
                }
                else if ( ((LA1_0>=Intersection && LA1_0<=Implements)||(LA1_0>=Promisify && LA1_0<=Function)||(LA1_0>=Private && LA1_0<=Break)||(LA1_0>=Class && LA1_0<=This)||(LA1_0>=Enum && LA1_0<=With)||(LA1_0>=For && LA1_0<=Var)||LA1_0==PlusSignPlusSign||LA1_0==HyphenMinusHyphenMinus||LA1_0==SolidusEqualsSign||(LA1_0>=As && LA1_0<=If)||LA1_0==Of||LA1_0==ExclamationMark||LA1_0==LeftParenthesis||LA1_0==PlusSign||LA1_0==HyphenMinus||LA1_0==Solidus||(LA1_0>=Semicolon && LA1_0<=LessThanSign)||(LA1_0>=CommercialAt && LA1_0<=LeftSquareBracket)||LA1_0==LeftCurlyBracket||LA1_0==Tilde||LA1_0==RULE_DOUBLE||(LA1_0>=RULE_HEX_INT && LA1_0<=RULE_LEGACY_OCTAL_INT)||LA1_0==RULE_SCIENTIFIC_INT||LA1_0==RULE_IDENTIFIER||LA1_0==RULE_STRING||(LA1_0>=RULE_TEMPLATE_HEAD && LA1_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA1_0==RULE_INT) ) {
                    alt1=2;
                }


                switch (alt1) {
            	case 1 :
            	    {
            	    {
            	    {
            	    pushFollow(FOLLOW_3);
            	    AnnotationsScriptAnnotationParserRuleCall_1_0_0=ruleScriptAnnotation();

            	    state._fsp--;
            	    if (state.failed) return ;
            	    if ( state.backtracking==0 ) {

            	      					announce((AnnotationsScriptAnnotationParserRuleCall_1_0_0!=null?((Token)AnnotationsScriptAnnotationParserRuleCall_1_0_0.start):null), (AnnotationsScriptAnnotationParserRuleCall_1_0_0!=null?((Token)AnnotationsScriptAnnotationParserRuleCall_1_0_0.stop):null), grammarAccess.getScriptAccess().getAnnotationsAssignment_1_0());
            	      				
            	    }

            	    }


            	    }


            	    }
            	    break;
            	case 2 :
            	    {
            	    {
            	    {
            	    pushFollow(FOLLOW_3);
            	    ScriptElementsScriptElementParserRuleCall_1_1_0=ruleScriptElement();

            	    state._fsp--;
            	    if (state.failed) return ;
            	    if ( state.backtracking==0 ) {

            	      					announce((ScriptElementsScriptElementParserRuleCall_1_1_0!=null?((Token)ScriptElementsScriptElementParserRuleCall_1_1_0.start):null), (ScriptElementsScriptElementParserRuleCall_1_1_0!=null?((Token)ScriptElementsScriptElementParserRuleCall_1_1_0.stop):null), grammarAccess.getScriptAccess().getScriptElementsAssignment_1_1());
            	      				
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);


            }


            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }
    public final void entryRuleScriptElement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleScriptElement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleScriptElement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleScriptElement_return ruleScriptElement() throws RecognitionException {
        InternalN4JSParser.ruleScriptElement_return retval = new InternalN4JSParser.ruleScriptElement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleAnnotatedScriptElement_return AnnotatedScriptElementParserRuleCall_0 = null;

        InternalN4JSParser.ruleN4ClassDeclaration_return N4ClassDeclarationParserRuleCall_1 = null;

        InternalN4JSParser.ruleN4InterfaceDeclaration_return N4InterfaceDeclarationParserRuleCall_2 = null;

        InternalN4JSParser.ruleN4EnumDeclaration_return N4EnumDeclarationParserRuleCall_3 = null;

        InternalN4JSParser.ruleImportDeclaration_return ImportDeclarationParserRuleCall_4 = null;

        InternalN4JSParser.ruleExportDeclaration_return ExportDeclarationParserRuleCall_5 = null;

        InternalN4JSParser.ruleRootStatement_return RootStatementParserRuleCall_6 = null;




        try {
            {
            int alt2=7;
            alt2 = dfa2.predict(input);
            switch (alt2) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    AnnotatedScriptElementParserRuleCall_0=ruleAnnotatedScriptElement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AnnotatedScriptElementParserRuleCall_0!=null?((Token)AnnotatedScriptElementParserRuleCall_0.start):null), (AnnotatedScriptElementParserRuleCall_0!=null?((Token)AnnotatedScriptElementParserRuleCall_0.stop):null), grammarAccess.getScriptElementAccess().getAnnotatedScriptElementParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    N4ClassDeclarationParserRuleCall_1=ruleN4ClassDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((N4ClassDeclarationParserRuleCall_1!=null?((Token)N4ClassDeclarationParserRuleCall_1.start):null), (N4ClassDeclarationParserRuleCall_1!=null?((Token)N4ClassDeclarationParserRuleCall_1.stop):null), grammarAccess.getScriptElementAccess().getN4ClassDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    N4InterfaceDeclarationParserRuleCall_2=ruleN4InterfaceDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((N4InterfaceDeclarationParserRuleCall_2!=null?((Token)N4InterfaceDeclarationParserRuleCall_2.start):null), (N4InterfaceDeclarationParserRuleCall_2!=null?((Token)N4InterfaceDeclarationParserRuleCall_2.stop):null), grammarAccess.getScriptElementAccess().getN4InterfaceDeclarationParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    N4EnumDeclarationParserRuleCall_3=ruleN4EnumDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((N4EnumDeclarationParserRuleCall_3!=null?((Token)N4EnumDeclarationParserRuleCall_3.start):null), (N4EnumDeclarationParserRuleCall_3!=null?((Token)N4EnumDeclarationParserRuleCall_3.stop):null), grammarAccess.getScriptElementAccess().getN4EnumDeclarationParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ImportDeclarationParserRuleCall_4=ruleImportDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ImportDeclarationParserRuleCall_4!=null?((Token)ImportDeclarationParserRuleCall_4.start):null), (ImportDeclarationParserRuleCall_4!=null?((Token)ImportDeclarationParserRuleCall_4.stop):null), grammarAccess.getScriptElementAccess().getImportDeclarationParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    pushFollow(FOLLOW_2);
                    ExportDeclarationParserRuleCall_5=ruleExportDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ExportDeclarationParserRuleCall_5!=null?((Token)ExportDeclarationParserRuleCall_5.start):null), (ExportDeclarationParserRuleCall_5!=null?((Token)ExportDeclarationParserRuleCall_5.stop):null), grammarAccess.getScriptElementAccess().getExportDeclarationParserRuleCall_5()); 
                    }

                    }
                    break;
                case 7 :
                    {
                    pushFollow(FOLLOW_2);
                    RootStatementParserRuleCall_6=ruleRootStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((RootStatementParserRuleCall_6!=null?((Token)RootStatementParserRuleCall_6.start):null), (RootStatementParserRuleCall_6!=null?((Token)RootStatementParserRuleCall_6.stop):null), grammarAccess.getScriptElementAccess().getRootStatementParserRuleCall_6()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleAnnotatedScriptElement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleAnnotatedScriptElement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleAnnotatedScriptElement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleAnnotatedScriptElement_return ruleAnnotatedScriptElement() throws RecognitionException {
        InternalN4JSParser.ruleAnnotatedScriptElement_return retval = new InternalN4JSParser.ruleAnnotatedScriptElement_return();
        retval.start = input.LT(1);

        Token ClassKeyword_1_3_0_0_2=null;
        Token InterfaceKeyword_1_3_0_1_2=null;
        Token EnumKeyword_1_4_2=null;
        Token LeftCurlyBracketKeyword_1_4_5=null;
        Token CommaKeyword_1_4_7_0=null;
        Token RightCurlyBracketKeyword_1_4_8=null;
        InternalN4JSParser.ruleAnnotationList_return AnnotationListParserRuleCall_0 = null;

        InternalN4JSParser.ruleExportDeclarationImpl_return ExportDeclarationImplParserRuleCall_1_0_1 = null;

        InternalN4JSParser.ruleImportDeclarationImpl_return ImportDeclarationImplParserRuleCall_1_1_1 = null;

        InternalN4JSParser.ruleAsyncNoTrailingLineBreak_return AsyncNoTrailingLineBreakParserRuleCall_1_2_1_0_1 = null;

        InternalN4JSParser.ruleFunctionImpl_return FunctionImplParserRuleCall_1_2_1_0_2 = null;

        InternalN4JSParser.ruleTypingStrategyDefSiteOperator_return TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_0_3_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_3_0_0_4_0 = null;

        InternalN4JSParser.ruleVersionDeclaration_return VersionDeclarationParserRuleCall_1_3_0_0_5 = null;

        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_1_3_0_0_6 = null;

        InternalN4JSParser.ruleClassExtendsImplements_return ClassExtendsImplementsParserRuleCall_1_3_0_0_7 = null;

        InternalN4JSParser.ruleTypingStrategyDefSiteOperator_return TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_1_3_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_3_0_1_4_0 = null;

        InternalN4JSParser.ruleVersionDeclaration_return VersionDeclarationParserRuleCall_1_3_0_1_5 = null;

        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_1_3_0_1_6 = null;

        InternalN4JSParser.ruleInterfaceExtendsList_return InterfaceExtendsListParserRuleCall_1_3_0_1_7 = null;

        InternalN4JSParser.ruleMembers_return MembersParserRuleCall_1_3_1 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_4_3_0 = null;

        InternalN4JSParser.ruleVersionDeclaration_return VersionDeclarationParserRuleCall_1_4_4 = null;

        InternalN4JSParser.ruleN4EnumLiteral_return LiteralsN4EnumLiteralParserRuleCall_1_4_6_0 = null;

        InternalN4JSParser.ruleN4EnumLiteral_return LiteralsN4EnumLiteralParserRuleCall_1_4_7_1_0 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_4);
            AnnotationListParserRuleCall_0=ruleAnnotationList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((AnnotationListParserRuleCall_0!=null?((Token)AnnotationListParserRuleCall_0.start):null), (AnnotationListParserRuleCall_0!=null?((Token)AnnotationListParserRuleCall_0.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getAnnotationListParserRuleCall_0()); 
            }

            }
            int alt18=5;
            alt18 = dfa18.predict(input);
            switch (alt18) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExportDeclarationImplParserRuleCall_1_0_1=ruleExportDeclarationImpl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ExportDeclarationImplParserRuleCall_1_0_1!=null?((Token)ExportDeclarationImplParserRuleCall_1_0_1.start):null), (ExportDeclarationImplParserRuleCall_1_0_1!=null?((Token)ExportDeclarationImplParserRuleCall_1_0_1.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getExportDeclarationImplParserRuleCall_1_0_1()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ImportDeclarationImplParserRuleCall_1_1_1=ruleImportDeclarationImpl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ImportDeclarationImplParserRuleCall_1_1_1!=null?((Token)ImportDeclarationImplParserRuleCall_1_1_1.start):null), (ImportDeclarationImplParserRuleCall_1_1_1!=null?((Token)ImportDeclarationImplParserRuleCall_1_1_1.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getImportDeclarationImplParserRuleCall_1_1_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    {
                    loop3:
                    do {
                        int alt3=2;
                        int LA3_0 = input.LA(1);

                        if ( ((LA3_0>=Protected && LA3_0<=Abstract)||LA3_0==External||(LA3_0>=Private && LA3_0<=Project)||LA3_0==Public||LA3_0==Static||LA3_0==Const) ) {
                            alt3=1;
                        }


                        switch (alt3) {
                    	case 1 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_5);
                    	    ruleN4Modifier();

                    	    state._fsp--;
                    	    if (state.failed) return retval;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop3;
                        }
                    } while (true);

                    pushFollow(FOLLOW_5);
                    AsyncNoTrailingLineBreakParserRuleCall_1_2_1_0_1=ruleAsyncNoTrailingLineBreak();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AsyncNoTrailingLineBreakParserRuleCall_1_2_1_0_1!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_1_2_1_0_1.start):null), (AsyncNoTrailingLineBreakParserRuleCall_1_2_1_0_1!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_1_2_1_0_1.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_2_1_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_2);
                    FunctionImplParserRuleCall_1_2_1_0_2=ruleFunctionImpl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionImplParserRuleCall_1_2_1_0_2!=null?((Token)FunctionImplParserRuleCall_1_2_1_0_2.start):null), (FunctionImplParserRuleCall_1_2_1_0_2!=null?((Token)FunctionImplParserRuleCall_1_2_1_0_2.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getFunctionImplParserRuleCall_1_2_1_0_2()); 
                    }

                    }


                    }


                    }


                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    int alt14=2;
                    alt14 = dfa14.predict(input);
                    switch (alt14) {
                        case 1 :
                            {
                            {
                            loop4:
                            do {
                                int alt4=2;
                                int LA4_0 = input.LA(1);

                                if ( ((LA4_0>=Protected && LA4_0<=Abstract)||LA4_0==External||(LA4_0>=Private && LA4_0<=Project)||LA4_0==Public||LA4_0==Static||LA4_0==Const) ) {
                                    alt4=1;
                                }


                                switch (alt4) {
                            	case 1 :
                            	    {
                            	    {
                            	    pushFollow(FOLLOW_6);
                            	    ruleN4Modifier();

                            	    state._fsp--;
                            	    if (state.failed) return retval;

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop4;
                                }
                            } while (true);

                            ClassKeyword_1_3_0_0_2=(Token)match(input,Class,FOLLOW_7); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(ClassKeyword_1_3_0_0_2, grammarAccess.getAnnotatedScriptElementAccess().getClassKeyword_1_3_0_0_2());
                              					
                            }
                            int alt5=2;
                            int LA5_0 = input.LA(1);

                            if ( (LA5_0==Tilde) ) {
                                alt5=1;
                            }
                            switch (alt5) {
                                case 1 :
                                    {
                                    {
                                    pushFollow(FOLLOW_8);
                                    TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_0_3_0=ruleTypingStrategyDefSiteOperator();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce((TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_0_3_0!=null?((Token)TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_0_3_0.start):null), (TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_0_3_0!=null?((Token)TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_0_3_0.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getTypingStrategyAssignment_1_3_0_0_3());
                                      							
                                    }

                                    }


                                    }
                                    break;

                            }
                            {
                            {
                            pushFollow(FOLLOW_9);
                            NameBindingIdentifierParserRuleCall_1_3_0_0_4_0=ruleBindingIdentifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              								announce((NameBindingIdentifierParserRuleCall_1_3_0_0_4_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_3_0_0_4_0.start):null), (NameBindingIdentifierParserRuleCall_1_3_0_0_4_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_3_0_0_4_0.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_3_0_0_4());
                              							
                            }

                            }


                            }
                            int alt6=2;
                            int LA6_0 = input.LA(1);

                            if ( (LA6_0==RULE_VERSION) ) {
                                alt6=1;
                            }
                            switch (alt6) {
                                case 1 :
                                    {
                                    pushFollow(FOLLOW_9);
                                    VersionDeclarationParserRuleCall_1_3_0_0_5=ruleVersionDeclaration();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {
                                       announce((VersionDeclarationParserRuleCall_1_3_0_0_5!=null?((Token)VersionDeclarationParserRuleCall_1_3_0_0_5.start):null), (VersionDeclarationParserRuleCall_1_3_0_0_5!=null?((Token)VersionDeclarationParserRuleCall_1_3_0_0_5.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_3_0_0_5()); 
                                    }

                                    }
                                    break;

                            }
                            int alt7=2;
                            int LA7_0 = input.LA(1);

                            if ( (LA7_0==LessThanSign) ) {
                                alt7=1;
                            }
                            switch (alt7) {
                                case 1 :
                                    {
                                    pushFollow(FOLLOW_9);
                                    TypeVariablesParserRuleCall_1_3_0_0_6=ruleTypeVariables();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {
                                       announce((TypeVariablesParserRuleCall_1_3_0_0_6!=null?((Token)TypeVariablesParserRuleCall_1_3_0_0_6.start):null), (TypeVariablesParserRuleCall_1_3_0_0_6!=null?((Token)TypeVariablesParserRuleCall_1_3_0_0_6.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getTypeVariablesParserRuleCall_1_3_0_0_6()); 
                                    }

                                    }
                                    break;

                            }
                            int alt8=2;
                            int LA8_0 = input.LA(1);

                            if ( (LA8_0==Implements||LA8_0==Extends) ) {
                                alt8=1;
                            }
                            switch (alt8) {
                                case 1 :
                                    {
                                    pushFollow(FOLLOW_9);
                                    ClassExtendsImplementsParserRuleCall_1_3_0_0_7=ruleClassExtendsImplements();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {
                                       announce((ClassExtendsImplementsParserRuleCall_1_3_0_0_7!=null?((Token)ClassExtendsImplementsParserRuleCall_1_3_0_0_7.start):null), (ClassExtendsImplementsParserRuleCall_1_3_0_0_7!=null?((Token)ClassExtendsImplementsParserRuleCall_1_3_0_0_7.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getClassExtendsImplementsParserRuleCall_1_3_0_0_7()); 
                                    }

                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            loop9:
                            do {
                                int alt9=2;
                                int LA9_0 = input.LA(1);

                                if ( ((LA9_0>=Protected && LA9_0<=Abstract)||LA9_0==External||(LA9_0>=Private && LA9_0<=Project)||LA9_0==Public||LA9_0==Static||LA9_0==Const) ) {
                                    alt9=1;
                                }


                                switch (alt9) {
                            	case 1 :
                            	    {
                            	    {
                            	    pushFollow(FOLLOW_10);
                            	    ruleN4Modifier();

                            	    state._fsp--;
                            	    if (state.failed) return retval;

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop9;
                                }
                            } while (true);

                            InterfaceKeyword_1_3_0_1_2=(Token)match(input,Interface,FOLLOW_7); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(InterfaceKeyword_1_3_0_1_2, grammarAccess.getAnnotatedScriptElementAccess().getInterfaceKeyword_1_3_0_1_2());
                              					
                            }
                            int alt10=2;
                            int LA10_0 = input.LA(1);

                            if ( (LA10_0==Tilde) ) {
                                alt10=1;
                            }
                            switch (alt10) {
                                case 1 :
                                    {
                                    {
                                    pushFollow(FOLLOW_8);
                                    TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_1_3_0=ruleTypingStrategyDefSiteOperator();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce((TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_1_3_0!=null?((Token)TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_1_3_0.start):null), (TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_1_3_0!=null?((Token)TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_1_3_0.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getTypingStrategyAssignment_1_3_0_1_3());
                                      							
                                    }

                                    }


                                    }
                                    break;

                            }
                            {
                            {
                            pushFollow(FOLLOW_9);
                            NameBindingIdentifierParserRuleCall_1_3_0_1_4_0=ruleBindingIdentifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              								announce((NameBindingIdentifierParserRuleCall_1_3_0_1_4_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_3_0_1_4_0.start):null), (NameBindingIdentifierParserRuleCall_1_3_0_1_4_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_3_0_1_4_0.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_3_0_1_4());
                              							
                            }

                            }


                            }
                            int alt11=2;
                            int LA11_0 = input.LA(1);

                            if ( (LA11_0==RULE_VERSION) ) {
                                alt11=1;
                            }
                            switch (alt11) {
                                case 1 :
                                    {
                                    pushFollow(FOLLOW_9);
                                    VersionDeclarationParserRuleCall_1_3_0_1_5=ruleVersionDeclaration();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {
                                       announce((VersionDeclarationParserRuleCall_1_3_0_1_5!=null?((Token)VersionDeclarationParserRuleCall_1_3_0_1_5.start):null), (VersionDeclarationParserRuleCall_1_3_0_1_5!=null?((Token)VersionDeclarationParserRuleCall_1_3_0_1_5.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_3_0_1_5()); 
                                    }

                                    }
                                    break;

                            }
                            int alt12=2;
                            int LA12_0 = input.LA(1);

                            if ( (LA12_0==LessThanSign) ) {
                                alt12=1;
                            }
                            switch (alt12) {
                                case 1 :
                                    {
                                    pushFollow(FOLLOW_9);
                                    TypeVariablesParserRuleCall_1_3_0_1_6=ruleTypeVariables();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {
                                       announce((TypeVariablesParserRuleCall_1_3_0_1_6!=null?((Token)TypeVariablesParserRuleCall_1_3_0_1_6.start):null), (TypeVariablesParserRuleCall_1_3_0_1_6!=null?((Token)TypeVariablesParserRuleCall_1_3_0_1_6.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getTypeVariablesParserRuleCall_1_3_0_1_6()); 
                                    }

                                    }
                                    break;

                            }
                            int alt13=2;
                            int LA13_0 = input.LA(1);

                            if ( (LA13_0==Implements||LA13_0==Extends) ) {
                                alt13=1;
                            }
                            switch (alt13) {
                                case 1 :
                                    {
                                    pushFollow(FOLLOW_9);
                                    InterfaceExtendsListParserRuleCall_1_3_0_1_7=ruleInterfaceExtendsList();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {
                                       announce((InterfaceExtendsListParserRuleCall_1_3_0_1_7!=null?((Token)InterfaceExtendsListParserRuleCall_1_3_0_1_7.start):null), (InterfaceExtendsListParserRuleCall_1_3_0_1_7!=null?((Token)InterfaceExtendsListParserRuleCall_1_3_0_1_7.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getInterfaceExtendsListParserRuleCall_1_3_0_1_7()); 
                                    }

                                    }
                                    break;

                            }


                            }


                            }
                            break;

                    }

                    pushFollow(FOLLOW_2);
                    MembersParserRuleCall_1_3_1=ruleMembers();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((MembersParserRuleCall_1_3_1!=null?((Token)MembersParserRuleCall_1_3_1.start):null), (MembersParserRuleCall_1_3_1!=null?((Token)MembersParserRuleCall_1_3_1.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getMembersParserRuleCall_1_3_1()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    loop15:
                    do {
                        int alt15=2;
                        int LA15_0 = input.LA(1);

                        if ( ((LA15_0>=Protected && LA15_0<=Abstract)||LA15_0==External||(LA15_0>=Private && LA15_0<=Project)||LA15_0==Public||LA15_0==Static||LA15_0==Const) ) {
                            alt15=1;
                        }


                        switch (alt15) {
                    	case 1 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_11);
                    	    ruleN4Modifier();

                    	    state._fsp--;
                    	    if (state.failed) return retval;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop15;
                        }
                    } while (true);

                    EnumKeyword_1_4_2=(Token)match(input,Enum,FOLLOW_8); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(EnumKeyword_1_4_2, grammarAccess.getAnnotatedScriptElementAccess().getEnumKeyword_1_4_2());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_12);
                    NameBindingIdentifierParserRuleCall_1_4_3_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((NameBindingIdentifierParserRuleCall_1_4_3_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_4_3_0.start):null), (NameBindingIdentifierParserRuleCall_1_4_3_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_4_3_0.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getNameAssignment_1_4_3());
                      					
                    }

                    }


                    }
                    int alt16=2;
                    int LA16_0 = input.LA(1);

                    if ( (LA16_0==RULE_VERSION) ) {
                        alt16=1;
                    }
                    switch (alt16) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_13);
                            VersionDeclarationParserRuleCall_1_4_4=ruleVersionDeclaration();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((VersionDeclarationParserRuleCall_1_4_4!=null?((Token)VersionDeclarationParserRuleCall_1_4_4.start):null), (VersionDeclarationParserRuleCall_1_4_4!=null?((Token)VersionDeclarationParserRuleCall_1_4_4.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_4_4()); 
                            }

                            }
                            break;

                    }

                    LeftCurlyBracketKeyword_1_4_5=(Token)match(input,LeftCurlyBracket,FOLLOW_14); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(LeftCurlyBracketKeyword_1_4_5, grammarAccess.getAnnotatedScriptElementAccess().getLeftCurlyBracketKeyword_1_4_5());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_15);
                    LiteralsN4EnumLiteralParserRuleCall_1_4_6_0=ruleN4EnumLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((LiteralsN4EnumLiteralParserRuleCall_1_4_6_0!=null?((Token)LiteralsN4EnumLiteralParserRuleCall_1_4_6_0.start):null), (LiteralsN4EnumLiteralParserRuleCall_1_4_6_0!=null?((Token)LiteralsN4EnumLiteralParserRuleCall_1_4_6_0.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getLiteralsAssignment_1_4_6());
                      					
                    }

                    }


                    }
                    loop17:
                    do {
                        int alt17=2;
                        int LA17_0 = input.LA(1);

                        if ( (LA17_0==Comma) ) {
                            alt17=1;
                        }


                        switch (alt17) {
                    	case 1 :
                    	    {
                    	    CommaKeyword_1_4_7_0=(Token)match(input,Comma,FOLLOW_14); if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      					announce(CommaKeyword_1_4_7_0, grammarAccess.getAnnotatedScriptElementAccess().getCommaKeyword_1_4_7_0());
                    	      				
                    	    }
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_15);
                    	    LiteralsN4EnumLiteralParserRuleCall_1_4_7_1_0=ruleN4EnumLiteral();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      							announce((LiteralsN4EnumLiteralParserRuleCall_1_4_7_1_0!=null?((Token)LiteralsN4EnumLiteralParserRuleCall_1_4_7_1_0.start):null), (LiteralsN4EnumLiteralParserRuleCall_1_4_7_1_0!=null?((Token)LiteralsN4EnumLiteralParserRuleCall_1_4_7_1_0.stop):null), grammarAccess.getAnnotatedScriptElementAccess().getLiteralsAssignment_1_4_7_1());
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop17;
                        }
                    } while (true);

                    RightCurlyBracketKeyword_1_4_8=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(RightCurlyBracketKeyword_1_4_8, grammarAccess.getAnnotatedScriptElementAccess().getRightCurlyBracketKeyword_1_4_8());
                      			
                    }

                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleExportDeclaration() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleExportDeclaration();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleExportDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExportDeclaration_return ruleExportDeclaration() throws RecognitionException {
        InternalN4JSParser.ruleExportDeclaration_return retval = new InternalN4JSParser.ruleExportDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleExportDeclarationImpl_return ExportDeclarationImplParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            ExportDeclarationImplParserRuleCall_1=ruleExportDeclarationImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((ExportDeclarationImplParserRuleCall_1!=null?((Token)ExportDeclarationImplParserRuleCall_1.start):null), (ExportDeclarationImplParserRuleCall_1!=null?((Token)ExportDeclarationImplParserRuleCall_1.stop):null), grammarAccess.getExportDeclarationAccess().getExportDeclarationImplParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleExportDeclarationImpl_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExportDeclarationImpl_return ruleExportDeclarationImpl() throws RecognitionException {
        InternalN4JSParser.ruleExportDeclarationImpl_return retval = new InternalN4JSParser.ruleExportDeclarationImpl_return();
        retval.start = input.LT(1);

        Token ExportKeyword_0=null;
        Token WildcardExportAsteriskKeyword_1_0_0_0=null;
        Token DefaultExportDefaultKeyword_1_3_0_0=null;
        InternalN4JSParser.ruleExportFromClause_return ExportFromClauseParserRuleCall_1_0_1 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_1_0_2 = null;

        InternalN4JSParser.ruleExportClause_return ExportClauseParserRuleCall_1_1_0 = null;

        InternalN4JSParser.ruleExportFromClause_return ExportFromClauseParserRuleCall_1_1_1 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_1_1_2 = null;

        InternalN4JSParser.ruleExportableElement_return ExportedElementExportableElementParserRuleCall_1_2_0 = null;

        InternalN4JSParser.ruleExportableElement_return ExportedElementExportableElementParserRuleCall_1_3_1_0_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return DefaultExportedExpressionAssignmentExpressionParserRuleCall_1_3_1_1_0_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_1_3_1_1_1 = null;




        try {
            {
            {
            ExportKeyword_0=(Token)match(input,Export,FOLLOW_16); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(ExportKeyword_0, grammarAccess.getExportDeclarationImplAccess().getExportKeyword_0());
              	
            }
            int alt21=4;
            switch ( input.LA(1) ) {
            case Asterisk:
                {
                alt21=1;
                }
                break;
            case LeftCurlyBracket:
                {
                alt21=2;
                }
                break;
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Function:
            case Private:
            case Project:
            case Public:
            case Static:
            case Async:
            case Class:
            case Const:
            case Enum:
            case Let:
            case Var:
            case CommercialAt:
                {
                alt21=3;
                }
                break;
            case Default:
                {
                alt21=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 21, 0, input);

                throw nvae;
            }

            switch (alt21) {
                case 1 :
                    {
                    {
                    {
                    {
                    WildcardExportAsteriskKeyword_1_0_0_0=(Token)match(input,Asterisk,FOLLOW_17); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(WildcardExportAsteriskKeyword_1_0_0_0, grammarAccess.getExportDeclarationImplAccess().getWildcardExportAsteriskKeyword_1_0_0_0());
                      					
                    }

                    }


                    }

                    pushFollow(FOLLOW_18);
                    ExportFromClauseParserRuleCall_1_0_1=ruleExportFromClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ExportFromClauseParserRuleCall_1_0_1!=null?((Token)ExportFromClauseParserRuleCall_1_0_1.start):null), (ExportFromClauseParserRuleCall_1_0_1!=null?((Token)ExportFromClauseParserRuleCall_1_0_1.stop):null), grammarAccess.getExportDeclarationImplAccess().getExportFromClauseParserRuleCall_1_0_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    SemiParserRuleCall_1_0_2=ruleSemi();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((SemiParserRuleCall_1_0_2!=null?((Token)SemiParserRuleCall_1_0_2.start):null), (SemiParserRuleCall_1_0_2!=null?((Token)SemiParserRuleCall_1_0_2.stop):null), grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_0_2()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_19);
                    ExportClauseParserRuleCall_1_1_0=ruleExportClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ExportClauseParserRuleCall_1_1_0!=null?((Token)ExportClauseParserRuleCall_1_1_0.start):null), (ExportClauseParserRuleCall_1_1_0!=null?((Token)ExportClauseParserRuleCall_1_1_0.stop):null), grammarAccess.getExportDeclarationImplAccess().getExportClauseParserRuleCall_1_1_0()); 
                    }
                    int alt19=2;
                    int LA19_0 = input.LA(1);

                    if ( (LA19_0==From) && (synpred9_InternalN4JSParser())) {
                        alt19=1;
                    }
                    switch (alt19) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_18);
                            ExportFromClauseParserRuleCall_1_1_1=ruleExportFromClause();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ExportFromClauseParserRuleCall_1_1_1!=null?((Token)ExportFromClauseParserRuleCall_1_1_1.start):null), (ExportFromClauseParserRuleCall_1_1_1!=null?((Token)ExportFromClauseParserRuleCall_1_1_1.stop):null), grammarAccess.getExportDeclarationImplAccess().getExportFromClauseParserRuleCall_1_1_1()); 
                            }

                            }
                            break;

                    }

                    pushFollow(FOLLOW_2);
                    SemiParserRuleCall_1_1_2=ruleSemi();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((SemiParserRuleCall_1_1_2!=null?((Token)SemiParserRuleCall_1_1_2.start):null), (SemiParserRuleCall_1_1_2!=null?((Token)SemiParserRuleCall_1_1_2.stop):null), grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_1_2()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExportedElementExportableElementParserRuleCall_1_2_0=ruleExportableElement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((ExportedElementExportableElementParserRuleCall_1_2_0!=null?((Token)ExportedElementExportableElementParserRuleCall_1_2_0.start):null), (ExportedElementExportableElementParserRuleCall_1_2_0!=null?((Token)ExportedElementExportableElementParserRuleCall_1_2_0.stop):null), grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_2());
                      				
                    }

                    }


                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    {
                    {
                    DefaultExportDefaultKeyword_1_3_0_0=(Token)match(input,Default,FOLLOW_20); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(DefaultExportDefaultKeyword_1_3_0_0, grammarAccess.getExportDeclarationImplAccess().getDefaultExportDefaultKeyword_1_3_0_0());
                      					
                    }

                    }


                    }
                    int alt20=2;
                    alt20 = dfa20.predict(input);
                    switch (alt20) {
                        case 1 :
                            {
                            {
                            {
                            pushFollow(FOLLOW_2);
                            ExportedElementExportableElementParserRuleCall_1_3_1_0_0=ruleExportableElement();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              							announce((ExportedElementExportableElementParserRuleCall_1_3_1_0_0!=null?((Token)ExportedElementExportableElementParserRuleCall_1_3_1_0_0.start):null), (ExportedElementExportableElementParserRuleCall_1_3_1_0_0!=null?((Token)ExportedElementExportableElementParserRuleCall_1_3_1_0_0.stop):null), grammarAccess.getExportDeclarationImplAccess().getExportedElementAssignment_1_3_1_0());
                              						
                            }

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            {
                            {
                            pushFollow(FOLLOW_18);
                            DefaultExportedExpressionAssignmentExpressionParserRuleCall_1_3_1_1_0_0=norm1_AssignmentExpression();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              								announce((DefaultExportedExpressionAssignmentExpressionParserRuleCall_1_3_1_1_0_0!=null?((Token)DefaultExportedExpressionAssignmentExpressionParserRuleCall_1_3_1_1_0_0.start):null), (DefaultExportedExpressionAssignmentExpressionParserRuleCall_1_3_1_1_0_0!=null?((Token)DefaultExportedExpressionAssignmentExpressionParserRuleCall_1_3_1_1_0_0.stop):null), grammarAccess.getExportDeclarationImplAccess().getDefaultExportedExpressionAssignment_1_3_1_1_0());
                              							
                            }

                            }


                            }

                            pushFollow(FOLLOW_2);
                            SemiParserRuleCall_1_3_1_1_1=ruleSemi();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((SemiParserRuleCall_1_3_1_1_1!=null?((Token)SemiParserRuleCall_1_3_1_1_1.start):null), (SemiParserRuleCall_1_3_1_1_1!=null?((Token)SemiParserRuleCall_1_3_1_1_1.stop):null), grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_3_1_1_1()); 
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleExportFromClause_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExportFromClause_return ruleExportFromClause() throws RecognitionException {
        InternalN4JSParser.ruleExportFromClause_return retval = new InternalN4JSParser.ruleExportFromClause_return();
        retval.start = input.LT(1);

        Token FromKeyword_0=null;
        InternalN4JSParser.ruleModuleSpecifier_return ReexportedFromTModuleModuleSpecifierParserRuleCall_1_0_1 = null;




        try {
            {
            {
            FromKeyword_0=(Token)match(input,From,FOLLOW_21); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(FromKeyword_0, grammarAccess.getExportFromClauseAccess().getFromKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            ReexportedFromTModuleModuleSpecifierParserRuleCall_1_0_1=ruleModuleSpecifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ReexportedFromTModuleModuleSpecifierParserRuleCall_1_0_1!=null?((Token)ReexportedFromTModuleModuleSpecifierParserRuleCall_1_0_1.start):null), (ReexportedFromTModuleModuleSpecifierParserRuleCall_1_0_1!=null?((Token)ReexportedFromTModuleModuleSpecifierParserRuleCall_1_0_1.stop):null), grammarAccess.getExportFromClauseAccess().getReexportedFromAssignment_1());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleExportClause_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExportClause_return ruleExportClause() throws RecognitionException {
        InternalN4JSParser.ruleExportClause_return retval = new InternalN4JSParser.ruleExportClause_return();
        retval.start = input.LT(1);

        Token LeftCurlyBracketKeyword_0=null;
        Token CommaKeyword_1_1_0=null;
        Token CommaKeyword_1_2=null;
        Token RightCurlyBracketKeyword_2=null;
        InternalN4JSParser.ruleExportSpecifier_return NamedExportsExportSpecifierParserRuleCall_1_0_0 = null;

        InternalN4JSParser.ruleExportSpecifier_return NamedExportsExportSpecifierParserRuleCall_1_1_1_0 = null;




        try {
            {
            {
            LeftCurlyBracketKeyword_0=(Token)match(input,LeftCurlyBracket,FOLLOW_22); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftCurlyBracketKeyword_0, grammarAccess.getExportClauseAccess().getLeftCurlyBracketKeyword_0());
              	
            }
            int alt24=2;
            int LA24_0 = input.LA(1);

            if ( ((LA24_0>=Intersection && LA24_0<=Implements)||(LA24_0>=Promisify && LA24_0<=Abstract)||LA24_0==External||(LA24_0>=Private && LA24_0<=Project)||LA24_0==Public||LA24_0==Static||LA24_0==Target||(LA24_0>=Async && LA24_0<=Await)||LA24_0==Union||(LA24_0>=Yield && LA24_0<=This)||LA24_0==From||LA24_0==Type||(LA24_0>=Get && LA24_0<=Let)||(LA24_0>=Out && LA24_0<=Set)||LA24_0==As||LA24_0==Of||LA24_0==RULE_IDENTIFIER) ) {
                alt24=1;
            }
            switch (alt24) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_15);
                    NamedExportsExportSpecifierParserRuleCall_1_0_0=ruleExportSpecifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((NamedExportsExportSpecifierParserRuleCall_1_0_0!=null?((Token)NamedExportsExportSpecifierParserRuleCall_1_0_0.start):null), (NamedExportsExportSpecifierParserRuleCall_1_0_0!=null?((Token)NamedExportsExportSpecifierParserRuleCall_1_0_0.stop):null), grammarAccess.getExportClauseAccess().getNamedExportsAssignment_1_0());
                      				
                    }

                    }


                    }
                    loop22:
                    do {
                        int alt22=2;
                        int LA22_0 = input.LA(1);

                        if ( (LA22_0==Comma) ) {
                            int LA22_1 = input.LA(2);

                            if ( ((LA22_1>=Intersection && LA22_1<=Implements)||(LA22_1>=Promisify && LA22_1<=Abstract)||LA22_1==External||(LA22_1>=Private && LA22_1<=Project)||LA22_1==Public||LA22_1==Static||LA22_1==Target||(LA22_1>=Async && LA22_1<=Await)||LA22_1==Union||(LA22_1>=Yield && LA22_1<=This)||LA22_1==From||LA22_1==Type||(LA22_1>=Get && LA22_1<=Let)||(LA22_1>=Out && LA22_1<=Set)||LA22_1==As||LA22_1==Of||LA22_1==RULE_IDENTIFIER) ) {
                                alt22=1;
                            }


                        }


                        switch (alt22) {
                    	case 1 :
                    	    {
                    	    CommaKeyword_1_1_0=(Token)match(input,Comma,FOLLOW_8); if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      				announce(CommaKeyword_1_1_0, grammarAccess.getExportClauseAccess().getCommaKeyword_1_1_0());
                    	      			
                    	    }
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_15);
                    	    NamedExportsExportSpecifierParserRuleCall_1_1_1_0=ruleExportSpecifier();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      						announce((NamedExportsExportSpecifierParserRuleCall_1_1_1_0!=null?((Token)NamedExportsExportSpecifierParserRuleCall_1_1_1_0.start):null), (NamedExportsExportSpecifierParserRuleCall_1_1_1_0!=null?((Token)NamedExportsExportSpecifierParserRuleCall_1_1_1_0.stop):null), grammarAccess.getExportClauseAccess().getNamedExportsAssignment_1_1_1());
                    	      					
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop22;
                        }
                    } while (true);
                    int alt23=2;
                    int LA23_0 = input.LA(1);

                    if ( (LA23_0==Comma) ) {
                        alt23=1;
                    }
                    switch (alt23) {
                        case 1 :
                            {
                            CommaKeyword_1_2=(Token)match(input,Comma,FOLLOW_23); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              				announce(CommaKeyword_1_2, grammarAccess.getExportClauseAccess().getCommaKeyword_1_2());
                              			
                            }

                            }
                            break;

                    }


                    }
                    break;

            }

            RightCurlyBracketKeyword_2=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightCurlyBracketKeyword_2, grammarAccess.getExportClauseAccess().getRightCurlyBracketKeyword_2());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleExportSpecifier() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleExportSpecifier();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleExportSpecifier_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExportSpecifier_return ruleExportSpecifier() throws RecognitionException {
        InternalN4JSParser.ruleExportSpecifier_return retval = new InternalN4JSParser.ruleExportSpecifier_return();
        retval.start = input.LT(1);

        Token AsKeyword_1_0=null;
        InternalN4JSParser.ruleIdentifierRef_return ElementIdentifierRefParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleIdentifierName_return AliasIdentifierNameParserRuleCall_1_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_24);
            ElementIdentifierRefParserRuleCall_0_0=ruleIdentifierRef();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ElementIdentifierRefParserRuleCall_0_0!=null?((Token)ElementIdentifierRefParserRuleCall_0_0.start):null), (ElementIdentifierRefParserRuleCall_0_0!=null?((Token)ElementIdentifierRefParserRuleCall_0_0.stop):null), grammarAccess.getExportSpecifierAccess().getElementAssignment_0());
              			
            }

            }


            }
            int alt25=2;
            int LA25_0 = input.LA(1);

            if ( (LA25_0==As) ) {
                alt25=1;
            }
            switch (alt25) {
                case 1 :
                    {
                    AsKeyword_1_0=(Token)match(input,As,FOLLOW_14); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce(AsKeyword_1_0, grammarAccess.getExportSpecifierAccess().getAsKeyword_1_0());
                      		
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    AliasIdentifierNameParserRuleCall_1_1_0=ruleIdentifierName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((AliasIdentifierNameParserRuleCall_1_1_0!=null?((Token)AliasIdentifierNameParserRuleCall_1_1_0.start):null), (AliasIdentifierNameParserRuleCall_1_1_0!=null?((Token)AliasIdentifierNameParserRuleCall_1_1_0.stop):null), grammarAccess.getExportSpecifierAccess().getAliasAssignment_1_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleExportableElement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleExportableElement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleExportableElement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExportableElement_return ruleExportableElement() throws RecognitionException {
        InternalN4JSParser.ruleExportableElement_return retval = new InternalN4JSParser.ruleExportableElement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleAnnotatedExportableElement_return AnnotatedExportableElementParserRuleCall_0 = null;

        InternalN4JSParser.ruleN4ClassDeclaration_return N4ClassDeclarationParserRuleCall_1 = null;

        InternalN4JSParser.ruleN4InterfaceDeclaration_return N4InterfaceDeclarationParserRuleCall_2 = null;

        InternalN4JSParser.ruleN4EnumDeclaration_return N4EnumDeclarationParserRuleCall_3 = null;

        InternalN4JSParser.ruleFunctionDeclaration_return FunctionDeclarationParserRuleCall_4 = null;

        InternalN4JSParser.ruleExportedVariableStatement_return ExportedVariableStatementParserRuleCall_5 = null;




        try {
            {
            int alt26=6;
            alt26 = dfa26.predict(input);
            switch (alt26) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    AnnotatedExportableElementParserRuleCall_0=ruleAnnotatedExportableElement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AnnotatedExportableElementParserRuleCall_0!=null?((Token)AnnotatedExportableElementParserRuleCall_0.start):null), (AnnotatedExportableElementParserRuleCall_0!=null?((Token)AnnotatedExportableElementParserRuleCall_0.stop):null), grammarAccess.getExportableElementAccess().getAnnotatedExportableElementParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    N4ClassDeclarationParserRuleCall_1=ruleN4ClassDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((N4ClassDeclarationParserRuleCall_1!=null?((Token)N4ClassDeclarationParserRuleCall_1.start):null), (N4ClassDeclarationParserRuleCall_1!=null?((Token)N4ClassDeclarationParserRuleCall_1.stop):null), grammarAccess.getExportableElementAccess().getN4ClassDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    N4InterfaceDeclarationParserRuleCall_2=ruleN4InterfaceDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((N4InterfaceDeclarationParserRuleCall_2!=null?((Token)N4InterfaceDeclarationParserRuleCall_2.start):null), (N4InterfaceDeclarationParserRuleCall_2!=null?((Token)N4InterfaceDeclarationParserRuleCall_2.stop):null), grammarAccess.getExportableElementAccess().getN4InterfaceDeclarationParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    N4EnumDeclarationParserRuleCall_3=ruleN4EnumDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((N4EnumDeclarationParserRuleCall_3!=null?((Token)N4EnumDeclarationParserRuleCall_3.start):null), (N4EnumDeclarationParserRuleCall_3!=null?((Token)N4EnumDeclarationParserRuleCall_3.stop):null), grammarAccess.getExportableElementAccess().getN4EnumDeclarationParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    FunctionDeclarationParserRuleCall_4=ruleFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionDeclarationParserRuleCall_4!=null?((Token)FunctionDeclarationParserRuleCall_4.start):null), (FunctionDeclarationParserRuleCall_4!=null?((Token)FunctionDeclarationParserRuleCall_4.stop):null), grammarAccess.getExportableElementAccess().getFunctionDeclarationParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    pushFollow(FOLLOW_2);
                    ExportedVariableStatementParserRuleCall_5=ruleExportedVariableStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ExportedVariableStatementParserRuleCall_5!=null?((Token)ExportedVariableStatementParserRuleCall_5.start):null), (ExportedVariableStatementParserRuleCall_5!=null?((Token)ExportedVariableStatementParserRuleCall_5.stop):null), grammarAccess.getExportableElementAccess().getExportedVariableStatementParserRuleCall_5()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleAnnotatedExportableElement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleAnnotatedExportableElement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleAnnotatedExportableElement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleAnnotatedExportableElement_return ruleAnnotatedExportableElement() throws RecognitionException {
        InternalN4JSParser.ruleAnnotatedExportableElement_return retval = new InternalN4JSParser.ruleAnnotatedExportableElement_return();
        retval.start = input.LT(1);

        Token CommaKeyword_1_1_4_0=null;
        Token ClassKeyword_1_2_0_0_2=null;
        Token InterfaceKeyword_1_2_0_1_2=null;
        Token EnumKeyword_1_3_2=null;
        Token LeftCurlyBracketKeyword_1_3_4=null;
        Token CommaKeyword_1_3_6_0=null;
        Token RightCurlyBracketKeyword_1_3_7=null;
        InternalN4JSParser.ruleAnnotationList_return AnnotationListParserRuleCall_0 = null;

        InternalN4JSParser.ruleAsyncNoTrailingLineBreak_return AsyncNoTrailingLineBreakParserRuleCall_1_0_2 = null;

        InternalN4JSParser.ruleFunctionImpl_return FunctionImplParserRuleCall_1_0_3 = null;

        InternalN4JSParser.ruleExportedVariableDeclarationOrBinding_return VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_3_0 = null;

        InternalN4JSParser.ruleExportedVariableDeclarationOrBinding_return VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_4_1_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_1_1_5 = null;

        InternalN4JSParser.ruleTypingStrategyDefSiteOperator_return TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_0_3_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_2_0_0_4_0 = null;

        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_1_2_0_0_5 = null;

        InternalN4JSParser.ruleClassExtendsImplements_return ClassExtendsImplementsParserRuleCall_1_2_0_0_6 = null;

        InternalN4JSParser.ruleTypingStrategyDefSiteOperator_return TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_1_3_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_2_0_1_4_0 = null;

        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_1_2_0_1_5 = null;

        InternalN4JSParser.ruleInterfaceExtendsList_return InterfaceExtendsListParserRuleCall_1_2_0_1_6 = null;

        InternalN4JSParser.ruleMembers_return MembersParserRuleCall_1_2_1 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_3_3_0 = null;

        InternalN4JSParser.ruleN4EnumLiteral_return LiteralsN4EnumLiteralParserRuleCall_1_3_5_0 = null;

        InternalN4JSParser.ruleN4EnumLiteral_return LiteralsN4EnumLiteralParserRuleCall_1_3_6_1_0 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_25);
            AnnotationListParserRuleCall_0=ruleAnnotationList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((AnnotationListParserRuleCall_0!=null?((Token)AnnotationListParserRuleCall_0.start):null), (AnnotationListParserRuleCall_0!=null?((Token)AnnotationListParserRuleCall_0.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getAnnotationListParserRuleCall_0()); 
            }

            }
            int alt41=4;
            alt41 = dfa41.predict(input);
            switch (alt41) {
                case 1 :
                    {
                    {
                    loop27:
                    do {
                        int alt27=2;
                        int LA27_0 = input.LA(1);

                        if ( ((LA27_0>=Protected && LA27_0<=Abstract)||LA27_0==External||(LA27_0>=Private && LA27_0<=Project)||LA27_0==Public||LA27_0==Static||LA27_0==Const) ) {
                            alt27=1;
                        }


                        switch (alt27) {
                    	case 1 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_5);
                    	    ruleN4Modifier();

                    	    state._fsp--;
                    	    if (state.failed) return retval;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop27;
                        }
                    } while (true);

                    pushFollow(FOLLOW_5);
                    AsyncNoTrailingLineBreakParserRuleCall_1_0_2=ruleAsyncNoTrailingLineBreak();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AsyncNoTrailingLineBreakParserRuleCall_1_0_2!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_1_0_2.start):null), (AsyncNoTrailingLineBreakParserRuleCall_1_0_2!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_1_0_2.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_0_2()); 
                    }
                    pushFollow(FOLLOW_2);
                    FunctionImplParserRuleCall_1_0_3=ruleFunctionImpl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionImplParserRuleCall_1_0_3!=null?((Token)FunctionImplParserRuleCall_1_0_3.start):null), (FunctionImplParserRuleCall_1_0_3!=null?((Token)FunctionImplParserRuleCall_1_0_3.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getFunctionImplParserRuleCall_1_0_3()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    loop28:
                    do {
                        int alt28=2;
                        alt28 = dfa28.predict(input);
                        switch (alt28) {
                    	case 1 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_26);
                    	    ruleN4Modifier();

                    	    state._fsp--;
                    	    if (state.failed) return retval;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop28;
                        }
                    } while (true);
                    {
                    {
                    pushFollow(FOLLOW_27);
                    ruleVariableStatementKeyword();

                    state._fsp--;
                    if (state.failed) return retval;

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_28);
                    VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_3_0=ruleExportedVariableDeclarationOrBinding();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_3_0!=null?((Token)VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_3_0.start):null), (VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_3_0!=null?((Token)VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_3_0.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getVarDeclsOrBindingsAssignment_1_1_3());
                      					
                    }

                    }


                    }
                    loop29:
                    do {
                        int alt29=2;
                        int LA29_0 = input.LA(1);

                        if ( (LA29_0==Comma) ) {
                            alt29=1;
                        }


                        switch (alt29) {
                    	case 1 :
                    	    {
                    	    CommaKeyword_1_1_4_0=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      					announce(CommaKeyword_1_1_4_0, grammarAccess.getAnnotatedExportableElementAccess().getCommaKeyword_1_1_4_0());
                    	      				
                    	    }
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_28);
                    	    VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_4_1_0=ruleExportedVariableDeclarationOrBinding();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      							announce((VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_4_1_0!=null?((Token)VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_4_1_0.start):null), (VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_4_1_0!=null?((Token)VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_4_1_0.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getVarDeclsOrBindingsAssignment_1_1_4_1());
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop29;
                        }
                    } while (true);

                    pushFollow(FOLLOW_2);
                    SemiParserRuleCall_1_1_5=ruleSemi();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((SemiParserRuleCall_1_1_5!=null?((Token)SemiParserRuleCall_1_1_5.start):null), (SemiParserRuleCall_1_1_5!=null?((Token)SemiParserRuleCall_1_1_5.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getSemiParserRuleCall_1_1_5()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    int alt38=2;
                    alt38 = dfa38.predict(input);
                    switch (alt38) {
                        case 1 :
                            {
                            {
                            loop30:
                            do {
                                int alt30=2;
                                int LA30_0 = input.LA(1);

                                if ( ((LA30_0>=Protected && LA30_0<=Abstract)||LA30_0==External||(LA30_0>=Private && LA30_0<=Project)||LA30_0==Public||LA30_0==Static||LA30_0==Const) ) {
                                    alt30=1;
                                }


                                switch (alt30) {
                            	case 1 :
                            	    {
                            	    {
                            	    pushFollow(FOLLOW_6);
                            	    ruleN4Modifier();

                            	    state._fsp--;
                            	    if (state.failed) return retval;

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop30;
                                }
                            } while (true);

                            ClassKeyword_1_2_0_0_2=(Token)match(input,Class,FOLLOW_7); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(ClassKeyword_1_2_0_0_2, grammarAccess.getAnnotatedExportableElementAccess().getClassKeyword_1_2_0_0_2());
                              					
                            }
                            int alt31=2;
                            int LA31_0 = input.LA(1);

                            if ( (LA31_0==Tilde) ) {
                                alt31=1;
                            }
                            switch (alt31) {
                                case 1 :
                                    {
                                    {
                                    pushFollow(FOLLOW_8);
                                    TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_0_3_0=ruleTypingStrategyDefSiteOperator();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce((TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_0_3_0!=null?((Token)TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_0_3_0.start):null), (TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_0_3_0!=null?((Token)TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_0_3_0.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getTypingStrategyAssignment_1_2_0_0_3());
                                      							
                                    }

                                    }


                                    }
                                    break;

                            }
                            {
                            {
                            pushFollow(FOLLOW_9);
                            NameBindingIdentifierParserRuleCall_1_2_0_0_4_0=ruleBindingIdentifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              								announce((NameBindingIdentifierParserRuleCall_1_2_0_0_4_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_2_0_0_4_0.start):null), (NameBindingIdentifierParserRuleCall_1_2_0_0_4_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_2_0_0_4_0.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_2_0_0_4());
                              							
                            }

                            }


                            }
                            int alt32=2;
                            int LA32_0 = input.LA(1);

                            if ( (LA32_0==LessThanSign) ) {
                                alt32=1;
                            }
                            switch (alt32) {
                                case 1 :
                                    {
                                    pushFollow(FOLLOW_9);
                                    TypeVariablesParserRuleCall_1_2_0_0_5=ruleTypeVariables();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {
                                       announce((TypeVariablesParserRuleCall_1_2_0_0_5!=null?((Token)TypeVariablesParserRuleCall_1_2_0_0_5.start):null), (TypeVariablesParserRuleCall_1_2_0_0_5!=null?((Token)TypeVariablesParserRuleCall_1_2_0_0_5.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getTypeVariablesParserRuleCall_1_2_0_0_5()); 
                                    }

                                    }
                                    break;

                            }
                            int alt33=2;
                            int LA33_0 = input.LA(1);

                            if ( (LA33_0==Implements||LA33_0==Extends) ) {
                                alt33=1;
                            }
                            switch (alt33) {
                                case 1 :
                                    {
                                    pushFollow(FOLLOW_9);
                                    ClassExtendsImplementsParserRuleCall_1_2_0_0_6=ruleClassExtendsImplements();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {
                                       announce((ClassExtendsImplementsParserRuleCall_1_2_0_0_6!=null?((Token)ClassExtendsImplementsParserRuleCall_1_2_0_0_6.start):null), (ClassExtendsImplementsParserRuleCall_1_2_0_0_6!=null?((Token)ClassExtendsImplementsParserRuleCall_1_2_0_0_6.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getClassExtendsImplementsParserRuleCall_1_2_0_0_6()); 
                                    }

                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            loop34:
                            do {
                                int alt34=2;
                                int LA34_0 = input.LA(1);

                                if ( ((LA34_0>=Protected && LA34_0<=Abstract)||LA34_0==External||(LA34_0>=Private && LA34_0<=Project)||LA34_0==Public||LA34_0==Static||LA34_0==Const) ) {
                                    alt34=1;
                                }


                                switch (alt34) {
                            	case 1 :
                            	    {
                            	    {
                            	    pushFollow(FOLLOW_10);
                            	    ruleN4Modifier();

                            	    state._fsp--;
                            	    if (state.failed) return retval;

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop34;
                                }
                            } while (true);

                            InterfaceKeyword_1_2_0_1_2=(Token)match(input,Interface,FOLLOW_7); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(InterfaceKeyword_1_2_0_1_2, grammarAccess.getAnnotatedExportableElementAccess().getInterfaceKeyword_1_2_0_1_2());
                              					
                            }
                            int alt35=2;
                            int LA35_0 = input.LA(1);

                            if ( (LA35_0==Tilde) ) {
                                alt35=1;
                            }
                            switch (alt35) {
                                case 1 :
                                    {
                                    {
                                    pushFollow(FOLLOW_8);
                                    TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_1_3_0=ruleTypingStrategyDefSiteOperator();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce((TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_1_3_0!=null?((Token)TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_1_3_0.start):null), (TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_1_3_0!=null?((Token)TypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_1_3_0.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getTypingStrategyAssignment_1_2_0_1_3());
                                      							
                                    }

                                    }


                                    }
                                    break;

                            }
                            {
                            {
                            pushFollow(FOLLOW_9);
                            NameBindingIdentifierParserRuleCall_1_2_0_1_4_0=ruleBindingIdentifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              								announce((NameBindingIdentifierParserRuleCall_1_2_0_1_4_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_2_0_1_4_0.start):null), (NameBindingIdentifierParserRuleCall_1_2_0_1_4_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_2_0_1_4_0.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_2_0_1_4());
                              							
                            }

                            }


                            }
                            int alt36=2;
                            int LA36_0 = input.LA(1);

                            if ( (LA36_0==LessThanSign) ) {
                                alt36=1;
                            }
                            switch (alt36) {
                                case 1 :
                                    {
                                    pushFollow(FOLLOW_9);
                                    TypeVariablesParserRuleCall_1_2_0_1_5=ruleTypeVariables();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {
                                       announce((TypeVariablesParserRuleCall_1_2_0_1_5!=null?((Token)TypeVariablesParserRuleCall_1_2_0_1_5.start):null), (TypeVariablesParserRuleCall_1_2_0_1_5!=null?((Token)TypeVariablesParserRuleCall_1_2_0_1_5.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getTypeVariablesParserRuleCall_1_2_0_1_5()); 
                                    }

                                    }
                                    break;

                            }
                            int alt37=2;
                            int LA37_0 = input.LA(1);

                            if ( (LA37_0==Implements||LA37_0==Extends) ) {
                                alt37=1;
                            }
                            switch (alt37) {
                                case 1 :
                                    {
                                    pushFollow(FOLLOW_9);
                                    InterfaceExtendsListParserRuleCall_1_2_0_1_6=ruleInterfaceExtendsList();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {
                                       announce((InterfaceExtendsListParserRuleCall_1_2_0_1_6!=null?((Token)InterfaceExtendsListParserRuleCall_1_2_0_1_6.start):null), (InterfaceExtendsListParserRuleCall_1_2_0_1_6!=null?((Token)InterfaceExtendsListParserRuleCall_1_2_0_1_6.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getInterfaceExtendsListParserRuleCall_1_2_0_1_6()); 
                                    }

                                    }
                                    break;

                            }


                            }


                            }
                            break;

                    }

                    pushFollow(FOLLOW_2);
                    MembersParserRuleCall_1_2_1=ruleMembers();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((MembersParserRuleCall_1_2_1!=null?((Token)MembersParserRuleCall_1_2_1.start):null), (MembersParserRuleCall_1_2_1!=null?((Token)MembersParserRuleCall_1_2_1.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getMembersParserRuleCall_1_2_1()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    loop39:
                    do {
                        int alt39=2;
                        int LA39_0 = input.LA(1);

                        if ( ((LA39_0>=Protected && LA39_0<=Abstract)||LA39_0==External||(LA39_0>=Private && LA39_0<=Project)||LA39_0==Public||LA39_0==Static||LA39_0==Const) ) {
                            alt39=1;
                        }


                        switch (alt39) {
                    	case 1 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_11);
                    	    ruleN4Modifier();

                    	    state._fsp--;
                    	    if (state.failed) return retval;

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop39;
                        }
                    } while (true);

                    EnumKeyword_1_3_2=(Token)match(input,Enum,FOLLOW_8); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(EnumKeyword_1_3_2, grammarAccess.getAnnotatedExportableElementAccess().getEnumKeyword_1_3_2());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_13);
                    NameBindingIdentifierParserRuleCall_1_3_3_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((NameBindingIdentifierParserRuleCall_1_3_3_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_3_3_0.start):null), (NameBindingIdentifierParserRuleCall_1_3_3_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_3_3_0.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getNameAssignment_1_3_3());
                      					
                    }

                    }


                    }

                    LeftCurlyBracketKeyword_1_3_4=(Token)match(input,LeftCurlyBracket,FOLLOW_14); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(LeftCurlyBracketKeyword_1_3_4, grammarAccess.getAnnotatedExportableElementAccess().getLeftCurlyBracketKeyword_1_3_4());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_15);
                    LiteralsN4EnumLiteralParserRuleCall_1_3_5_0=ruleN4EnumLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((LiteralsN4EnumLiteralParserRuleCall_1_3_5_0!=null?((Token)LiteralsN4EnumLiteralParserRuleCall_1_3_5_0.start):null), (LiteralsN4EnumLiteralParserRuleCall_1_3_5_0!=null?((Token)LiteralsN4EnumLiteralParserRuleCall_1_3_5_0.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getLiteralsAssignment_1_3_5());
                      					
                    }

                    }


                    }
                    loop40:
                    do {
                        int alt40=2;
                        int LA40_0 = input.LA(1);

                        if ( (LA40_0==Comma) ) {
                            alt40=1;
                        }


                        switch (alt40) {
                    	case 1 :
                    	    {
                    	    CommaKeyword_1_3_6_0=(Token)match(input,Comma,FOLLOW_14); if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      					announce(CommaKeyword_1_3_6_0, grammarAccess.getAnnotatedExportableElementAccess().getCommaKeyword_1_3_6_0());
                    	      				
                    	    }
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_15);
                    	    LiteralsN4EnumLiteralParserRuleCall_1_3_6_1_0=ruleN4EnumLiteral();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      							announce((LiteralsN4EnumLiteralParserRuleCall_1_3_6_1_0!=null?((Token)LiteralsN4EnumLiteralParserRuleCall_1_3_6_1_0.start):null), (LiteralsN4EnumLiteralParserRuleCall_1_3_6_1_0!=null?((Token)LiteralsN4EnumLiteralParserRuleCall_1_3_6_1_0.stop):null), grammarAccess.getAnnotatedExportableElementAccess().getLiteralsAssignment_1_3_6_1());
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop40;
                        }
                    } while (true);

                    RightCurlyBracketKeyword_1_3_7=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(RightCurlyBracketKeyword_1_3_7, grammarAccess.getAnnotatedExportableElementAccess().getRightCurlyBracketKeyword_1_3_7());
                      			
                    }

                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleImportDeclaration() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleImportDeclaration();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleImportDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleImportDeclaration_return ruleImportDeclaration() throws RecognitionException {
        InternalN4JSParser.ruleImportDeclaration_return retval = new InternalN4JSParser.ruleImportDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleImportDeclarationImpl_return ImportDeclarationImplParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            ImportDeclarationImplParserRuleCall_1=ruleImportDeclarationImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((ImportDeclarationImplParserRuleCall_1!=null?((Token)ImportDeclarationImplParserRuleCall_1.start):null), (ImportDeclarationImplParserRuleCall_1!=null?((Token)ImportDeclarationImplParserRuleCall_1.stop):null), grammarAccess.getImportDeclarationAccess().getImportDeclarationImplParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleImportDeclarationImpl_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleImportDeclarationImpl_return ruleImportDeclarationImpl() throws RecognitionException {
        InternalN4JSParser.ruleImportDeclarationImpl_return retval = new InternalN4JSParser.ruleImportDeclarationImpl_return();
        retval.start = input.LT(1);

        Token ImportKeyword_0=null;
        Token ImportFromFromKeyword_1_1_0=null;
        InternalN4JSParser.ruleImportClause_return ImportClauseParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleModuleSpecifier_return ModuleTModuleModuleSpecifierParserRuleCall_2_0_1 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_3 = null;




        try {
            {
            {
            ImportKeyword_0=(Token)match(input,Import,FOLLOW_29); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(ImportKeyword_0, grammarAccess.getImportDeclarationImplAccess().getImportKeyword_0());
              	
            }
            int alt42=2;
            int LA42_0 = input.LA(1);

            if ( ((LA42_0>=Intersection && LA42_0<=Implements)||(LA42_0>=Promisify && LA42_0<=Abstract)||LA42_0==External||(LA42_0>=Private && LA42_0<=Project)||LA42_0==Public||LA42_0==Static||LA42_0==Target||(LA42_0>=Async && LA42_0<=Await)||LA42_0==Union||(LA42_0>=Yield && LA42_0<=This)||LA42_0==From||LA42_0==Type||(LA42_0>=Get && LA42_0<=Let)||(LA42_0>=Out && LA42_0<=Set)||LA42_0==As||LA42_0==Of||LA42_0==Asterisk||LA42_0==LeftCurlyBracket||LA42_0==RULE_IDENTIFIER) ) {
                alt42=1;
            }
            switch (alt42) {
                case 1 :
                    {
                    pushFollow(FOLLOW_17);
                    ImportClauseParserRuleCall_1_0=ruleImportClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ImportClauseParserRuleCall_1_0!=null?((Token)ImportClauseParserRuleCall_1_0.start):null), (ImportClauseParserRuleCall_1_0!=null?((Token)ImportClauseParserRuleCall_1_0.stop):null), grammarAccess.getImportDeclarationImplAccess().getImportClauseParserRuleCall_1_0()); 
                    }
                    {
                    {
                    ImportFromFromKeyword_1_1_0=(Token)match(input,From,FOLLOW_21); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce(ImportFromFromKeyword_1_1_0, grammarAccess.getImportDeclarationImplAccess().getImportFromFromKeyword_1_1_0());
                      				
                    }

                    }


                    }


                    }
                    break;

            }
            {
            {
            pushFollow(FOLLOW_18);
            ModuleTModuleModuleSpecifierParserRuleCall_2_0_1=ruleModuleSpecifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ModuleTModuleModuleSpecifierParserRuleCall_2_0_1!=null?((Token)ModuleTModuleModuleSpecifierParserRuleCall_2_0_1.start):null), (ModuleTModuleModuleSpecifierParserRuleCall_2_0_1!=null?((Token)ModuleTModuleModuleSpecifierParserRuleCall_2_0_1.stop):null), grammarAccess.getImportDeclarationImplAccess().getModuleAssignment_2());
              			
            }

            }


            }

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_3=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.start):null), (SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.stop):null), grammarAccess.getImportDeclarationImplAccess().getSemiParserRuleCall_3()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleImportClause_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleImportClause_return ruleImportClause() throws RecognitionException {
        InternalN4JSParser.ruleImportClause_return retval = new InternalN4JSParser.ruleImportClause_return();
        retval.start = input.LT(1);

        Token CommaKeyword_0_1_0=null;
        InternalN4JSParser.ruleDefaultImportSpecifier_return ImportSpecifiersDefaultImportSpecifierParserRuleCall_0_0_0 = null;

        InternalN4JSParser.ruleImportSpecifiersExceptDefault_return ImportSpecifiersExceptDefaultParserRuleCall_0_1_1 = null;

        InternalN4JSParser.ruleImportSpecifiersExceptDefault_return ImportSpecifiersExceptDefaultParserRuleCall_1 = null;




        try {
            {
            int alt44=2;
            int LA44_0 = input.LA(1);

            if ( ((LA44_0>=Intersection && LA44_0<=Implements)||(LA44_0>=Promisify && LA44_0<=Abstract)||LA44_0==External||(LA44_0>=Private && LA44_0<=Project)||LA44_0==Public||LA44_0==Static||LA44_0==Target||(LA44_0>=Async && LA44_0<=Await)||LA44_0==Union||(LA44_0>=Yield && LA44_0<=This)||LA44_0==From||LA44_0==Type||(LA44_0>=Get && LA44_0<=Let)||(LA44_0>=Out && LA44_0<=Set)||LA44_0==As||LA44_0==Of||LA44_0==RULE_IDENTIFIER) ) {
                alt44=1;
            }
            else if ( (LA44_0==Asterisk||LA44_0==LeftCurlyBracket) ) {
                alt44=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 44, 0, input);

                throw nvae;
            }
            switch (alt44) {
                case 1 :
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_30);
                    ImportSpecifiersDefaultImportSpecifierParserRuleCall_0_0_0=ruleDefaultImportSpecifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((ImportSpecifiersDefaultImportSpecifierParserRuleCall_0_0_0!=null?((Token)ImportSpecifiersDefaultImportSpecifierParserRuleCall_0_0_0.start):null), (ImportSpecifiersDefaultImportSpecifierParserRuleCall_0_0_0!=null?((Token)ImportSpecifiersDefaultImportSpecifierParserRuleCall_0_0_0.stop):null), grammarAccess.getImportClauseAccess().getImportSpecifiersAssignment_0_0());
                      				
                    }

                    }


                    }
                    int alt43=2;
                    int LA43_0 = input.LA(1);

                    if ( (LA43_0==Comma) ) {
                        alt43=1;
                    }
                    switch (alt43) {
                        case 1 :
                            {
                            CommaKeyword_0_1_0=(Token)match(input,Comma,FOLLOW_31); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              				announce(CommaKeyword_0_1_0, grammarAccess.getImportClauseAccess().getCommaKeyword_0_1_0());
                              			
                            }
                            pushFollow(FOLLOW_2);
                            ImportSpecifiersExceptDefaultParserRuleCall_0_1_1=ruleImportSpecifiersExceptDefault();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ImportSpecifiersExceptDefaultParserRuleCall_0_1_1!=null?((Token)ImportSpecifiersExceptDefaultParserRuleCall_0_1_1.start):null), (ImportSpecifiersExceptDefaultParserRuleCall_0_1_1!=null?((Token)ImportSpecifiersExceptDefaultParserRuleCall_0_1_1.stop):null), grammarAccess.getImportClauseAccess().getImportSpecifiersExceptDefaultParserRuleCall_0_1_1()); 
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    ImportSpecifiersExceptDefaultParserRuleCall_1=ruleImportSpecifiersExceptDefault();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ImportSpecifiersExceptDefaultParserRuleCall_1!=null?((Token)ImportSpecifiersExceptDefaultParserRuleCall_1.start):null), (ImportSpecifiersExceptDefaultParserRuleCall_1!=null?((Token)ImportSpecifiersExceptDefaultParserRuleCall_1.stop):null), grammarAccess.getImportClauseAccess().getImportSpecifiersExceptDefaultParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleImportSpecifiersExceptDefault_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleImportSpecifiersExceptDefault_return ruleImportSpecifiersExceptDefault() throws RecognitionException {
        InternalN4JSParser.ruleImportSpecifiersExceptDefault_return retval = new InternalN4JSParser.ruleImportSpecifiersExceptDefault_return();
        retval.start = input.LT(1);

        Token LeftCurlyBracketKeyword_1_0=null;
        Token CommaKeyword_1_1_1_0=null;
        Token CommaKeyword_1_1_2=null;
        Token RightCurlyBracketKeyword_1_2=null;
        InternalN4JSParser.ruleNamespaceImportSpecifier_return ImportSpecifiersNamespaceImportSpecifierParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleNamedImportSpecifier_return ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_0_0 = null;

        InternalN4JSParser.ruleNamedImportSpecifier_return ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_1_1_0 = null;




        try {
            {
            int alt48=2;
            int LA48_0 = input.LA(1);

            if ( (LA48_0==Asterisk) ) {
                alt48=1;
            }
            else if ( (LA48_0==LeftCurlyBracket) ) {
                alt48=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 48, 0, input);

                throw nvae;
            }
            switch (alt48) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ImportSpecifiersNamespaceImportSpecifierParserRuleCall_0_0=ruleNamespaceImportSpecifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((ImportSpecifiersNamespaceImportSpecifierParserRuleCall_0_0!=null?((Token)ImportSpecifiersNamespaceImportSpecifierParserRuleCall_0_0.start):null), (ImportSpecifiersNamespaceImportSpecifierParserRuleCall_0_0!=null?((Token)ImportSpecifiersNamespaceImportSpecifierParserRuleCall_0_0.stop):null), grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_0());
                      			
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    LeftCurlyBracketKeyword_1_0=(Token)match(input,LeftCurlyBracket,FOLLOW_32); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce(LeftCurlyBracketKeyword_1_0, grammarAccess.getImportSpecifiersExceptDefaultAccess().getLeftCurlyBracketKeyword_1_0());
                      		
                    }
                    int alt47=2;
                    int LA47_0 = input.LA(1);

                    if ( ((LA47_0>=Intersection && LA47_0<=With)||(LA47_0>=For && LA47_0<=Var)||(LA47_0>=As && LA47_0<=Of)||LA47_0==RULE_IDENTIFIER) ) {
                        alt47=1;
                    }
                    switch (alt47) {
                        case 1 :
                            {
                            {
                            {
                            pushFollow(FOLLOW_15);
                            ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_0_0=ruleNamedImportSpecifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce((ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_0_0!=null?((Token)ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_0_0.start):null), (ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_0_0!=null?((Token)ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_0_0.stop):null), grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_1_1_0());
                              					
                            }

                            }


                            }
                            loop45:
                            do {
                                int alt45=2;
                                int LA45_0 = input.LA(1);

                                if ( (LA45_0==Comma) ) {
                                    int LA45_1 = input.LA(2);

                                    if ( ((LA45_1>=Intersection && LA45_1<=With)||(LA45_1>=For && LA45_1<=Var)||(LA45_1>=As && LA45_1<=Of)||LA45_1==RULE_IDENTIFIER) ) {
                                        alt45=1;
                                    }


                                }


                                switch (alt45) {
                            	case 1 :
                            	    {
                            	    CommaKeyword_1_1_1_0=(Token)match(input,Comma,FOLLOW_14); if (state.failed) return retval;
                            	    if ( state.backtracking==0 ) {

                            	      					announce(CommaKeyword_1_1_1_0, grammarAccess.getImportSpecifiersExceptDefaultAccess().getCommaKeyword_1_1_1_0());
                            	      				
                            	    }
                            	    {
                            	    {
                            	    pushFollow(FOLLOW_15);
                            	    ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_1_1_0=ruleNamedImportSpecifier();

                            	    state._fsp--;
                            	    if (state.failed) return retval;
                            	    if ( state.backtracking==0 ) {

                            	      							announce((ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_1_1_0!=null?((Token)ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_1_1_0.start):null), (ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_1_1_0!=null?((Token)ImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_1_1_0.stop):null), grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersAssignment_1_1_1_1());
                            	      						
                            	    }

                            	    }


                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop45;
                                }
                            } while (true);
                            int alt46=2;
                            int LA46_0 = input.LA(1);

                            if ( (LA46_0==Comma) ) {
                                alt46=1;
                            }
                            switch (alt46) {
                                case 1 :
                                    {
                                    CommaKeyword_1_1_2=(Token)match(input,Comma,FOLLOW_23); if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      					announce(CommaKeyword_1_1_2, grammarAccess.getImportSpecifiersExceptDefaultAccess().getCommaKeyword_1_1_2());
                                      				
                                    }

                                    }
                                    break;

                            }


                            }
                            break;

                    }

                    RightCurlyBracketKeyword_1_2=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce(RightCurlyBracketKeyword_1_2, grammarAccess.getImportSpecifiersExceptDefaultAccess().getRightCurlyBracketKeyword_1_2());
                      		
                    }

                    }


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleNamedImportSpecifier() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleNamedImportSpecifier();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleNamedImportSpecifier_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleNamedImportSpecifier_return ruleNamedImportSpecifier() throws RecognitionException {
        InternalN4JSParser.ruleNamedImportSpecifier_return retval = new InternalN4JSParser.ruleNamedImportSpecifier_return();
        retval.start = input.LT(1);

        Token AsKeyword_1_1=null;
        InternalN4JSParser.ruleBindingIdentifier_return ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_0_1 = null;

        InternalN4JSParser.ruleIdentifierName_return ImportedElementTExportableElementIdentifierNameParserRuleCall_1_0_0_1 = null;

        InternalN4JSParser.ruleBindingIdentifier_return AliasBindingIdentifierParserRuleCall_1_2_0 = null;




        try {
            {
            int alt49=2;
            alt49 = dfa49.predict(input);
            switch (alt49) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_0_1=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_0_1!=null?((Token)ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_0_1.start):null), (ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_0_1!=null?((Token)ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_0_1.stop):null), grammarAccess.getNamedImportSpecifierAccess().getImportedElementAssignment_0());
                      			
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_33);
                    ImportedElementTExportableElementIdentifierNameParserRuleCall_1_0_0_1=ruleIdentifierName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((ImportedElementTExportableElementIdentifierNameParserRuleCall_1_0_0_1!=null?((Token)ImportedElementTExportableElementIdentifierNameParserRuleCall_1_0_0_1.start):null), (ImportedElementTExportableElementIdentifierNameParserRuleCall_1_0_0_1!=null?((Token)ImportedElementTExportableElementIdentifierNameParserRuleCall_1_0_0_1.stop):null), grammarAccess.getNamedImportSpecifierAccess().getImportedElementAssignment_1_0());
                      				
                    }

                    }


                    }

                    AsKeyword_1_1=(Token)match(input,As,FOLLOW_8); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce(AsKeyword_1_1, grammarAccess.getNamedImportSpecifierAccess().getAsKeyword_1_1());
                      		
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    AliasBindingIdentifierParserRuleCall_1_2_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((AliasBindingIdentifierParserRuleCall_1_2_0!=null?((Token)AliasBindingIdentifierParserRuleCall_1_2_0.start):null), (AliasBindingIdentifierParserRuleCall_1_2_0!=null?((Token)AliasBindingIdentifierParserRuleCall_1_2_0.stop):null), grammarAccess.getNamedImportSpecifierAccess().getAliasAssignment_1_2());
                      				
                    }

                    }


                    }


                    }


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleDefaultImportSpecifier() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleDefaultImportSpecifier();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleDefaultImportSpecifier_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleDefaultImportSpecifier_return ruleDefaultImportSpecifier() throws RecognitionException {
        InternalN4JSParser.ruleDefaultImportSpecifier_return retval = new InternalN4JSParser.ruleDefaultImportSpecifier_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleBindingIdentifier_return ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_1 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_2);
            ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_1=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce((ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_1!=null?((Token)ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_1.start):null), (ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_1!=null?((Token)ImportedElementTExportableElementBindingIdentifierParserRuleCall_0_1.stop):null), grammarAccess.getDefaultImportSpecifierAccess().getImportedElementAssignment());
              		
            }

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleNamespaceImportSpecifier() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleNamespaceImportSpecifier();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleNamespaceImportSpecifier_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleNamespaceImportSpecifier_return ruleNamespaceImportSpecifier() throws RecognitionException {
        InternalN4JSParser.ruleNamespaceImportSpecifier_return retval = new InternalN4JSParser.ruleNamespaceImportSpecifier_return();
        retval.start = input.LT(1);

        Token AsteriskKeyword_1=null;
        Token AsKeyword_2=null;
        Token DeclaredDynamicPlusSignKeyword_4_0=null;
        InternalN4JSParser.ruleBindingIdentifier_return AliasBindingIdentifierParserRuleCall_3_0 = null;




        try {
            {
            {
            AsteriskKeyword_1=(Token)match(input,Asterisk,FOLLOW_33); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(AsteriskKeyword_1, grammarAccess.getNamespaceImportSpecifierAccess().getAsteriskKeyword_1());
              	
            }
            AsKeyword_2=(Token)match(input,As,FOLLOW_8); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(AsKeyword_2, grammarAccess.getNamespaceImportSpecifierAccess().getAsKeyword_2());
              	
            }
            {
            {
            pushFollow(FOLLOW_34);
            AliasBindingIdentifierParserRuleCall_3_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((AliasBindingIdentifierParserRuleCall_3_0!=null?((Token)AliasBindingIdentifierParserRuleCall_3_0.start):null), (AliasBindingIdentifierParserRuleCall_3_0!=null?((Token)AliasBindingIdentifierParserRuleCall_3_0.stop):null), grammarAccess.getNamespaceImportSpecifierAccess().getAliasAssignment_3());
              			
            }

            }


            }
            int alt50=2;
            int LA50_0 = input.LA(1);

            if ( (LA50_0==PlusSign) ) {
                alt50=1;
            }
            switch (alt50) {
                case 1 :
                    {
                    {
                    DeclaredDynamicPlusSignKeyword_4_0=(Token)match(input,PlusSign,FOLLOW_2); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(DeclaredDynamicPlusSignKeyword_4_0, grammarAccess.getNamespaceImportSpecifierAccess().getDeclaredDynamicPlusSignKeyword_4_0());
                      			
                    }

                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleModuleSpecifier() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleModuleSpecifier();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleModuleSpecifier_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleModuleSpecifier_return ruleModuleSpecifier() throws RecognitionException {
        InternalN4JSParser.ruleModuleSpecifier_return retval = new InternalN4JSParser.ruleModuleSpecifier_return();
        retval.start = input.LT(1);



        try {
            {
            match(input,RULE_STRING,FOLLOW_2); if (state.failed) return retval;

            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleFunctionDeclaration() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleFunctionDeclaration();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleFunctionDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleFunctionDeclaration_return ruleFunctionDeclaration() throws RecognitionException {
        InternalN4JSParser.ruleFunctionDeclaration_return retval = new InternalN4JSParser.ruleFunctionDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleAsyncNoTrailingLineBreak_return AsyncNoTrailingLineBreakParserRuleCall_0_0_2 = null;

        InternalN4JSParser.ruleFunctionImpl_return FunctionImplParserRuleCall_0_0_3 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_1 = null;




        try {
            {
            {
            {
            {
            loop51:
            do {
                int alt51=2;
                int LA51_0 = input.LA(1);

                if ( ((LA51_0>=Protected && LA51_0<=Abstract)||LA51_0==External||(LA51_0>=Private && LA51_0<=Project)||LA51_0==Public||LA51_0==Static||LA51_0==Const) ) {
                    alt51=1;
                }


                switch (alt51) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_5);
            	    ruleN4Modifier();

            	    state._fsp--;
            	    if (state.failed) return retval;

            	    }


            	    }
            	    break;

            	default :
            	    break loop51;
                }
            } while (true);

            pushFollow(FOLLOW_5);
            AsyncNoTrailingLineBreakParserRuleCall_0_0_2=ruleAsyncNoTrailingLineBreak();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((AsyncNoTrailingLineBreakParserRuleCall_0_0_2!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_0_0_2.start):null), (AsyncNoTrailingLineBreakParserRuleCall_0_0_2!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_0_0_2.stop):null), grammarAccess.getFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_0_0_2()); 
            }
            {
            pushFollow(FOLLOW_35);
            FunctionImplParserRuleCall_0_0_3=ruleFunctionImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((FunctionImplParserRuleCall_0_0_3!=null?((Token)FunctionImplParserRuleCall_0_0_3.start):null), (FunctionImplParserRuleCall_0_0_3!=null?((Token)FunctionImplParserRuleCall_0_0_3.stop):null), grammarAccess.getFunctionDeclarationAccess().getFunctionImplParserRuleCall_0_0_3()); 
            }

            }


            }


            }
            int alt52=2;
            alt52 = dfa52.predict(input);
            switch (alt52) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    SemiParserRuleCall_1=ruleSemi();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((SemiParserRuleCall_1!=null?((Token)SemiParserRuleCall_1.start):null), (SemiParserRuleCall_1!=null?((Token)SemiParserRuleCall_1.stop):null), grammarAccess.getFunctionDeclarationAccess().getSemiParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_FunctionDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_FunctionDeclaration_return norm1_FunctionDeclaration() throws RecognitionException {
        InternalN4JSParser.norm1_FunctionDeclaration_return retval = new InternalN4JSParser.norm1_FunctionDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleAsyncNoTrailingLineBreak_return AsyncNoTrailingLineBreakParserRuleCall_0_0_2 = null;

        InternalN4JSParser.norm3_FunctionImpl_return FunctionImplParserRuleCall_0_0_3 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_1 = null;




        try {
            {
            {
            {
            {
            loop53:
            do {
                int alt53=2;
                int LA53_0 = input.LA(1);

                if ( ((LA53_0>=Protected && LA53_0<=Abstract)||LA53_0==External||(LA53_0>=Private && LA53_0<=Project)||LA53_0==Public||LA53_0==Static||LA53_0==Const) ) {
                    alt53=1;
                }


                switch (alt53) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_5);
            	    ruleN4Modifier();

            	    state._fsp--;
            	    if (state.failed) return retval;

            	    }


            	    }
            	    break;

            	default :
            	    break loop53;
                }
            } while (true);

            pushFollow(FOLLOW_36);
            AsyncNoTrailingLineBreakParserRuleCall_0_0_2=ruleAsyncNoTrailingLineBreak();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((AsyncNoTrailingLineBreakParserRuleCall_0_0_2!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_0_0_2.start):null), (AsyncNoTrailingLineBreakParserRuleCall_0_0_2!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_0_0_2.stop):null), grammarAccess.getFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_0_0_2()); 
            }
            {
            pushFollow(FOLLOW_35);
            FunctionImplParserRuleCall_0_0_3=norm3_FunctionImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((FunctionImplParserRuleCall_0_0_3!=null?((Token)FunctionImplParserRuleCall_0_0_3.start):null), (FunctionImplParserRuleCall_0_0_3!=null?((Token)FunctionImplParserRuleCall_0_0_3.stop):null), grammarAccess.getFunctionDeclarationAccess().getFunctionImplParserRuleCall_0_0_3()); 
            }

            }


            }


            }
            int alt54=2;
            int LA54_0 = input.LA(1);

            if ( (LA54_0==Semicolon) ) {
                int LA54_1 = input.LA(2);

                if ( (synpred22_InternalN4JSParser()) ) {
                    alt54=1;
                }
            }
            else if ( (LA54_0==EOF) && (synpred22_InternalN4JSParser())) {
                alt54=1;
            }
            else if ( (LA54_0==RULE_EOL) && (synpred22_InternalN4JSParser())) {
                alt54=1;
            }
            else if ( (LA54_0==RULE_ML_COMMENT) && (synpred22_InternalN4JSParser())) {
                alt54=1;
            }
            else if ( (LA54_0==RightCurlyBracket) ) {
                int LA54_5 = input.LA(2);

                if ( (synpred22_InternalN4JSParser()) ) {
                    alt54=1;
                }
            }
            switch (alt54) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    SemiParserRuleCall_1=ruleSemi();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((SemiParserRuleCall_1!=null?((Token)SemiParserRuleCall_1.start):null), (SemiParserRuleCall_1!=null?((Token)SemiParserRuleCall_1.stop):null), grammarAccess.getFunctionDeclarationAccess().getSemiParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleAsyncNoTrailingLineBreak_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleAsyncNoTrailingLineBreak_return ruleAsyncNoTrailingLineBreak() throws RecognitionException {
        InternalN4JSParser.ruleAsyncNoTrailingLineBreak_return retval = new InternalN4JSParser.ruleAsyncNoTrailingLineBreak_return();
        retval.start = input.LT(1);

        Token DeclaredAsyncAsyncKeyword_0_0=null;
        InternalN4JSParser.ruleNoLineTerminator_return NoLineTerminatorParserRuleCall_1 = null;




        try {
            {
            int alt55=2;
            int LA55_0 = input.LA(1);

            if ( (LA55_0==Async) ) {
                int LA55_1 = input.LA(2);

                if ( ((LA55_1>=Intersection && LA55_1<=With)||(LA55_1>=For && LA55_1<=Var)||(LA55_1>=As && LA55_1<=Of)||LA55_1==LeftSquareBracket||LA55_1==RULE_DOUBLE||LA55_1==RULE_HEX_INT||LA55_1==RULE_OCTAL_INT||LA55_1==RULE_SCIENTIFIC_INT||LA55_1==RULE_IDENTIFIER||LA55_1==RULE_STRING||LA55_1==RULE_NO_LINE_TERMINATOR||LA55_1==RULE_INT) ) {
                    alt55=1;
                }
            }
            switch (alt55) {
                case 1 :
                    {
                    {
                    {
                    DeclaredAsyncAsyncKeyword_0_0=(Token)match(input,Async,FOLLOW_37); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(DeclaredAsyncAsyncKeyword_0_0, grammarAccess.getAsyncNoTrailingLineBreakAccess().getDeclaredAsyncAsyncKeyword_0_0());
                      			
                    }

                    }


                    }

                    pushFollow(FOLLOW_2);
                    NoLineTerminatorParserRuleCall_1=ruleNoLineTerminator();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((NoLineTerminatorParserRuleCall_1!=null?((Token)NoLineTerminatorParserRuleCall_1.start):null), (NoLineTerminatorParserRuleCall_1!=null?((Token)NoLineTerminatorParserRuleCall_1.stop):null), grammarAccess.getAsyncNoTrailingLineBreakAccess().getNoLineTerminatorParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleFunctionImpl_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleFunctionImpl_return ruleFunctionImpl() throws RecognitionException {
        InternalN4JSParser.ruleFunctionImpl_return retval = new InternalN4JSParser.ruleFunctionImpl_return();
        retval.start = input.LT(1);

        Token FunctionKeyword_0=null;
        Token GeneratorAsteriskKeyword_1_0_0_0=null;
        InternalN4JSParser.norm2_FunctionHeader_return FunctionHeaderParserRuleCall_1_0_1 = null;

        InternalN4JSParser.norm1_FunctionBody_return FunctionBodyParserRuleCall_1_0_2 = null;

        InternalN4JSParser.ruleFunctionHeader_return FunctionHeaderParserRuleCall_1_1_0 = null;

        InternalN4JSParser.ruleFunctionBody_return FunctionBodyParserRuleCall_1_1_1 = null;




        try {
            {
            {
            FunctionKeyword_0=(Token)match(input,Function,FOLLOW_38); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(FunctionKeyword_0, grammarAccess.getFunctionImplAccess().getFunctionKeyword_0());
              	
            }
            int alt56=2;
            int LA56_0 = input.LA(1);

            if ( (LA56_0==Asterisk) ) {
                alt56=1;
            }
            else if ( ((LA56_0>=Intersection && LA56_0<=Implements)||(LA56_0>=Promisify && LA56_0<=Abstract)||LA56_0==External||(LA56_0>=Private && LA56_0<=Project)||LA56_0==Public||LA56_0==Static||LA56_0==Target||(LA56_0>=Async && LA56_0<=Await)||LA56_0==Union||(LA56_0>=Yield && LA56_0<=This)||LA56_0==From||LA56_0==Type||(LA56_0>=Get && LA56_0<=Let)||(LA56_0>=Out && LA56_0<=Set)||LA56_0==As||LA56_0==Of||LA56_0==LeftParenthesis||LA56_0==LessThanSign||LA56_0==RULE_IDENTIFIER||LA56_0==RULE_VERSION) ) {
                alt56=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 56, 0, input);

                throw nvae;
            }
            switch (alt56) {
                case 1 :
                    {
                    {
                    {
                    {
                    GeneratorAsteriskKeyword_1_0_0_0=(Token)match(input,Asterisk,FOLLOW_39); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(GeneratorAsteriskKeyword_1_0_0_0, grammarAccess.getFunctionImplAccess().getGeneratorAsteriskKeyword_1_0_0_0());
                      					
                    }

                    }


                    }

                    pushFollow(FOLLOW_13);
                    FunctionHeaderParserRuleCall_1_0_1=norm2_FunctionHeader();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionHeaderParserRuleCall_1_0_1!=null?((Token)FunctionHeaderParserRuleCall_1_0_1.start):null), (FunctionHeaderParserRuleCall_1_0_1!=null?((Token)FunctionHeaderParserRuleCall_1_0_1.stop):null), grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    FunctionBodyParserRuleCall_1_0_2=norm1_FunctionBody();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionBodyParserRuleCall_1_0_2!=null?((Token)FunctionBodyParserRuleCall_1_0_2.start):null), (FunctionBodyParserRuleCall_1_0_2!=null?((Token)FunctionBodyParserRuleCall_1_0_2.stop):null), grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_13);
                    FunctionHeaderParserRuleCall_1_1_0=ruleFunctionHeader();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionHeaderParserRuleCall_1_1_0!=null?((Token)FunctionHeaderParserRuleCall_1_1_0.start):null), (FunctionHeaderParserRuleCall_1_1_0!=null?((Token)FunctionHeaderParserRuleCall_1_1_0.stop):null), grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    FunctionBodyParserRuleCall_1_1_1=ruleFunctionBody();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionBodyParserRuleCall_1_1_1!=null?((Token)FunctionBodyParserRuleCall_1_1_1.start):null), (FunctionBodyParserRuleCall_1_1_1!=null?((Token)FunctionBodyParserRuleCall_1_1_1.stop):null), grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1()); 
                    }

                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm3_FunctionImpl_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm3_FunctionImpl_return norm3_FunctionImpl() throws RecognitionException {
        InternalN4JSParser.norm3_FunctionImpl_return retval = new InternalN4JSParser.norm3_FunctionImpl_return();
        retval.start = input.LT(1);

        Token FunctionKeyword_0=null;
        Token GeneratorAsteriskKeyword_1_0_0_0=null;
        InternalN4JSParser.norm3_FunctionHeader_return FunctionHeaderParserRuleCall_1_0_1 = null;

        InternalN4JSParser.norm1_FunctionBody_return FunctionBodyParserRuleCall_1_0_2 = null;

        InternalN4JSParser.norm1_FunctionHeader_return FunctionHeaderParserRuleCall_1_1_0 = null;

        InternalN4JSParser.ruleFunctionBody_return FunctionBodyParserRuleCall_1_1_1 = null;




        try {
            {
            {
            FunctionKeyword_0=(Token)match(input,Function,FOLLOW_38); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(FunctionKeyword_0, grammarAccess.getFunctionImplAccess().getFunctionKeyword_0());
              	
            }
            int alt57=2;
            int LA57_0 = input.LA(1);

            if ( (LA57_0==Asterisk) ) {
                alt57=1;
            }
            else if ( ((LA57_0>=Intersection && LA57_0<=Implements)||(LA57_0>=Promisify && LA57_0<=Abstract)||LA57_0==External||(LA57_0>=Private && LA57_0<=Project)||LA57_0==Public||LA57_0==Static||LA57_0==Target||(LA57_0>=Async && LA57_0<=Await)||LA57_0==Union||LA57_0==This||LA57_0==From||LA57_0==Type||(LA57_0>=Get && LA57_0<=Let)||(LA57_0>=Out && LA57_0<=Set)||LA57_0==As||LA57_0==Of||LA57_0==LeftParenthesis||LA57_0==LessThanSign||LA57_0==RULE_IDENTIFIER||LA57_0==RULE_VERSION) ) {
                alt57=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 57, 0, input);

                throw nvae;
            }
            switch (alt57) {
                case 1 :
                    {
                    {
                    {
                    {
                    GeneratorAsteriskKeyword_1_0_0_0=(Token)match(input,Asterisk,FOLLOW_39); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(GeneratorAsteriskKeyword_1_0_0_0, grammarAccess.getFunctionImplAccess().getGeneratorAsteriskKeyword_1_0_0_0());
                      					
                    }

                    }


                    }

                    pushFollow(FOLLOW_13);
                    FunctionHeaderParserRuleCall_1_0_1=norm3_FunctionHeader();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionHeaderParserRuleCall_1_0_1!=null?((Token)FunctionHeaderParserRuleCall_1_0_1.start):null), (FunctionHeaderParserRuleCall_1_0_1!=null?((Token)FunctionHeaderParserRuleCall_1_0_1.stop):null), grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    FunctionBodyParserRuleCall_1_0_2=norm1_FunctionBody();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionBodyParserRuleCall_1_0_2!=null?((Token)FunctionBodyParserRuleCall_1_0_2.start):null), (FunctionBodyParserRuleCall_1_0_2!=null?((Token)FunctionBodyParserRuleCall_1_0_2.stop):null), grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_13);
                    FunctionHeaderParserRuleCall_1_1_0=norm1_FunctionHeader();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionHeaderParserRuleCall_1_1_0!=null?((Token)FunctionHeaderParserRuleCall_1_1_0.start):null), (FunctionHeaderParserRuleCall_1_1_0!=null?((Token)FunctionHeaderParserRuleCall_1_1_0.stop):null), grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    FunctionBodyParserRuleCall_1_1_1=ruleFunctionBody();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionBodyParserRuleCall_1_1_1!=null?((Token)FunctionBodyParserRuleCall_1_1_1.start):null), (FunctionBodyParserRuleCall_1_1_1!=null?((Token)FunctionBodyParserRuleCall_1_1_1.stop):null), grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1()); 
                    }

                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm6_FunctionImpl_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm6_FunctionImpl_return norm6_FunctionImpl() throws RecognitionException {
        InternalN4JSParser.norm6_FunctionImpl_return retval = new InternalN4JSParser.norm6_FunctionImpl_return();
        retval.start = input.LT(1);

        Token FunctionKeyword_0=null;
        Token GeneratorAsteriskKeyword_1_0_0_0=null;
        InternalN4JSParser.norm3_FunctionHeader_return FunctionHeaderParserRuleCall_1_0_1 = null;

        InternalN4JSParser.norm3_FunctionBody_return FunctionBodyParserRuleCall_1_0_2 = null;

        InternalN4JSParser.ruleFunctionHeader_return FunctionHeaderParserRuleCall_1_1_0 = null;

        InternalN4JSParser.norm2_FunctionBody_return FunctionBodyParserRuleCall_1_1_1 = null;




        try {
            {
            {
            FunctionKeyword_0=(Token)match(input,Function,FOLLOW_38); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(FunctionKeyword_0, grammarAccess.getFunctionImplAccess().getFunctionKeyword_0());
              	
            }
            int alt58=2;
            int LA58_0 = input.LA(1);

            if ( (LA58_0==Asterisk) ) {
                alt58=1;
            }
            else if ( ((LA58_0>=Intersection && LA58_0<=Implements)||(LA58_0>=Promisify && LA58_0<=Abstract)||LA58_0==External||(LA58_0>=Private && LA58_0<=Project)||LA58_0==Public||LA58_0==Static||LA58_0==Target||(LA58_0>=Async && LA58_0<=Await)||LA58_0==Union||(LA58_0>=Yield && LA58_0<=This)||LA58_0==From||LA58_0==Type||(LA58_0>=Get && LA58_0<=Let)||(LA58_0>=Out && LA58_0<=Set)||LA58_0==As||LA58_0==Of||LA58_0==LeftParenthesis||LA58_0==LessThanSign||LA58_0==RULE_IDENTIFIER||LA58_0==RULE_VERSION) ) {
                alt58=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 58, 0, input);

                throw nvae;
            }
            switch (alt58) {
                case 1 :
                    {
                    {
                    {
                    {
                    GeneratorAsteriskKeyword_1_0_0_0=(Token)match(input,Asterisk,FOLLOW_39); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(GeneratorAsteriskKeyword_1_0_0_0, grammarAccess.getFunctionImplAccess().getGeneratorAsteriskKeyword_1_0_0_0());
                      					
                    }

                    }


                    }

                    pushFollow(FOLLOW_13);
                    FunctionHeaderParserRuleCall_1_0_1=norm3_FunctionHeader();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionHeaderParserRuleCall_1_0_1!=null?((Token)FunctionHeaderParserRuleCall_1_0_1.start):null), (FunctionHeaderParserRuleCall_1_0_1!=null?((Token)FunctionHeaderParserRuleCall_1_0_1.stop):null), grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    FunctionBodyParserRuleCall_1_0_2=norm3_FunctionBody();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionBodyParserRuleCall_1_0_2!=null?((Token)FunctionBodyParserRuleCall_1_0_2.start):null), (FunctionBodyParserRuleCall_1_0_2!=null?((Token)FunctionBodyParserRuleCall_1_0_2.stop):null), grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_13);
                    FunctionHeaderParserRuleCall_1_1_0=ruleFunctionHeader();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionHeaderParserRuleCall_1_1_0!=null?((Token)FunctionHeaderParserRuleCall_1_1_0.start):null), (FunctionHeaderParserRuleCall_1_1_0!=null?((Token)FunctionHeaderParserRuleCall_1_1_0.stop):null), grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0()); 
                    }
                    pushFollow(FOLLOW_2);
                    FunctionBodyParserRuleCall_1_1_1=norm2_FunctionBody();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionBodyParserRuleCall_1_1_1!=null?((Token)FunctionBodyParserRuleCall_1_1_1.start):null), (FunctionBodyParserRuleCall_1_1_1!=null?((Token)FunctionBodyParserRuleCall_1_1_1.stop):null), grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1()); 
                    }

                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleFunctionHeader_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleFunctionHeader_return ruleFunctionHeader() throws RecognitionException {
        InternalN4JSParser.ruleFunctionHeader_return retval = new InternalN4JSParser.ruleFunctionHeader_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleVersionDeclaration_return VersionDeclarationParserRuleCall_2 = null;

        InternalN4JSParser.ruleStrictFormalParameters_return StrictFormalParametersParserRuleCall_3 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_4 = null;




        try {
            {
            {
            int alt59=2;
            int LA59_0 = input.LA(1);

            if ( (LA59_0==LessThanSign) ) {
                alt59=1;
            }
            switch (alt59) {
                case 1 :
                    {
                    pushFollow(FOLLOW_40);
                    TypeVariablesParserRuleCall_0=ruleTypeVariables();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((TypeVariablesParserRuleCall_0!=null?((Token)TypeVariablesParserRuleCall_0.start):null), (TypeVariablesParserRuleCall_0!=null?((Token)TypeVariablesParserRuleCall_0.stop):null), grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); 
                    }

                    }
                    break;

            }
            int alt60=2;
            int LA60_0 = input.LA(1);

            if ( ((LA60_0>=Intersection && LA60_0<=Implements)||(LA60_0>=Promisify && LA60_0<=Abstract)||LA60_0==External||(LA60_0>=Private && LA60_0<=Project)||LA60_0==Public||LA60_0==Static||LA60_0==Target||(LA60_0>=Async && LA60_0<=Await)||LA60_0==Union||(LA60_0>=Yield && LA60_0<=This)||LA60_0==From||LA60_0==Type||(LA60_0>=Get && LA60_0<=Let)||(LA60_0>=Out && LA60_0<=Set)||LA60_0==As||LA60_0==Of||LA60_0==RULE_IDENTIFIER) ) {
                alt60=1;
            }
            switch (alt60) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_41);
                    NameBindingIdentifierParserRuleCall_1_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((NameBindingIdentifierParserRuleCall_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0.start):null), (NameBindingIdentifierParserRuleCall_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0.stop):null), grammarAccess.getFunctionHeaderAccess().getNameAssignment_1());
                      			
                    }

                    }


                    }
                    break;

            }
            int alt61=2;
            int LA61_0 = input.LA(1);

            if ( (LA61_0==RULE_VERSION) ) {
                alt61=1;
            }
            switch (alt61) {
                case 1 :
                    {
                    pushFollow(FOLLOW_42);
                    VersionDeclarationParserRuleCall_2=ruleVersionDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VersionDeclarationParserRuleCall_2!=null?((Token)VersionDeclarationParserRuleCall_2.start):null), (VersionDeclarationParserRuleCall_2!=null?((Token)VersionDeclarationParserRuleCall_2.stop):null), grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); 
                    }

                    }
                    break;

            }

            pushFollow(FOLLOW_43);
            StrictFormalParametersParserRuleCall_3=ruleStrictFormalParameters();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((StrictFormalParametersParserRuleCall_3!=null?((Token)StrictFormalParametersParserRuleCall_3.start):null), (StrictFormalParametersParserRuleCall_3!=null?((Token)StrictFormalParametersParserRuleCall_3.stop):null), grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); 
            }
            int alt62=2;
            int LA62_0 = input.LA(1);

            if ( (LA62_0==Colon) && (synpred23_InternalN4JSParser())) {
                alt62=1;
            }
            switch (alt62) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    ColonSepReturnTypeRefParserRuleCall_4=ruleColonSepReturnTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ColonSepReturnTypeRefParserRuleCall_4!=null?((Token)ColonSepReturnTypeRefParserRuleCall_4.start):null), (ColonSepReturnTypeRefParserRuleCall_4!=null?((Token)ColonSepReturnTypeRefParserRuleCall_4.stop):null), grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); 
                    }

                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_FunctionHeader_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_FunctionHeader_return norm1_FunctionHeader() throws RecognitionException {
        InternalN4JSParser.norm1_FunctionHeader_return retval = new InternalN4JSParser.norm1_FunctionHeader_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_0 = null;

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleVersionDeclaration_return VersionDeclarationParserRuleCall_2 = null;

        InternalN4JSParser.ruleStrictFormalParameters_return StrictFormalParametersParserRuleCall_3 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_4 = null;




        try {
            {
            {
            int alt63=2;
            int LA63_0 = input.LA(1);

            if ( (LA63_0==LessThanSign) ) {
                alt63=1;
            }
            switch (alt63) {
                case 1 :
                    {
                    pushFollow(FOLLOW_40);
                    TypeVariablesParserRuleCall_0=ruleTypeVariables();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((TypeVariablesParserRuleCall_0!=null?((Token)TypeVariablesParserRuleCall_0.start):null), (TypeVariablesParserRuleCall_0!=null?((Token)TypeVariablesParserRuleCall_0.stop):null), grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); 
                    }

                    }
                    break;

            }
            int alt64=2;
            int LA64_0 = input.LA(1);

            if ( ((LA64_0>=Intersection && LA64_0<=Implements)||(LA64_0>=Promisify && LA64_0<=Abstract)||LA64_0==External||(LA64_0>=Private && LA64_0<=Project)||LA64_0==Public||LA64_0==Static||LA64_0==Target||(LA64_0>=Async && LA64_0<=Await)||LA64_0==Union||LA64_0==This||LA64_0==From||LA64_0==Type||(LA64_0>=Get && LA64_0<=Let)||(LA64_0>=Out && LA64_0<=Set)||LA64_0==As||LA64_0==Of||LA64_0==RULE_IDENTIFIER) ) {
                alt64=1;
            }
            switch (alt64) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_41);
                    NameBindingIdentifierParserRuleCall_1_0=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((NameBindingIdentifierParserRuleCall_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0.start):null), (NameBindingIdentifierParserRuleCall_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0.stop):null), grammarAccess.getFunctionHeaderAccess().getNameAssignment_1());
                      			
                    }

                    }


                    }
                    break;

            }
            int alt65=2;
            int LA65_0 = input.LA(1);

            if ( (LA65_0==RULE_VERSION) ) {
                alt65=1;
            }
            switch (alt65) {
                case 1 :
                    {
                    pushFollow(FOLLOW_42);
                    VersionDeclarationParserRuleCall_2=ruleVersionDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VersionDeclarationParserRuleCall_2!=null?((Token)VersionDeclarationParserRuleCall_2.start):null), (VersionDeclarationParserRuleCall_2!=null?((Token)VersionDeclarationParserRuleCall_2.stop):null), grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); 
                    }

                    }
                    break;

            }

            pushFollow(FOLLOW_43);
            StrictFormalParametersParserRuleCall_3=ruleStrictFormalParameters();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((StrictFormalParametersParserRuleCall_3!=null?((Token)StrictFormalParametersParserRuleCall_3.start):null), (StrictFormalParametersParserRuleCall_3!=null?((Token)StrictFormalParametersParserRuleCall_3.stop):null), grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); 
            }
            int alt66=2;
            int LA66_0 = input.LA(1);

            if ( (LA66_0==Colon) && (synpred24_InternalN4JSParser())) {
                alt66=1;
            }
            switch (alt66) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    ColonSepReturnTypeRefParserRuleCall_4=ruleColonSepReturnTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ColonSepReturnTypeRefParserRuleCall_4!=null?((Token)ColonSepReturnTypeRefParserRuleCall_4.start):null), (ColonSepReturnTypeRefParserRuleCall_4!=null?((Token)ColonSepReturnTypeRefParserRuleCall_4.stop):null), grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); 
                    }

                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm2_FunctionHeader_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm2_FunctionHeader_return norm2_FunctionHeader() throws RecognitionException {
        InternalN4JSParser.norm2_FunctionHeader_return retval = new InternalN4JSParser.norm2_FunctionHeader_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleVersionDeclaration_return VersionDeclarationParserRuleCall_2 = null;

        InternalN4JSParser.norm1_StrictFormalParameters_return StrictFormalParametersParserRuleCall_3 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_4 = null;




        try {
            {
            {
            int alt67=2;
            int LA67_0 = input.LA(1);

            if ( (LA67_0==LessThanSign) ) {
                alt67=1;
            }
            switch (alt67) {
                case 1 :
                    {
                    pushFollow(FOLLOW_39);
                    TypeVariablesParserRuleCall_0=ruleTypeVariables();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((TypeVariablesParserRuleCall_0!=null?((Token)TypeVariablesParserRuleCall_0.start):null), (TypeVariablesParserRuleCall_0!=null?((Token)TypeVariablesParserRuleCall_0.stop):null), grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); 
                    }

                    }
                    break;

            }
            int alt68=2;
            int LA68_0 = input.LA(1);

            if ( ((LA68_0>=Intersection && LA68_0<=Implements)||(LA68_0>=Promisify && LA68_0<=Abstract)||LA68_0==External||(LA68_0>=Private && LA68_0<=Project)||LA68_0==Public||LA68_0==Static||LA68_0==Target||(LA68_0>=Async && LA68_0<=Await)||LA68_0==Union||(LA68_0>=Yield && LA68_0<=This)||LA68_0==From||LA68_0==Type||(LA68_0>=Get && LA68_0<=Let)||(LA68_0>=Out && LA68_0<=Set)||LA68_0==As||LA68_0==Of||LA68_0==RULE_IDENTIFIER) ) {
                alt68=1;
            }
            switch (alt68) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_39);
                    NameBindingIdentifierParserRuleCall_1_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((NameBindingIdentifierParserRuleCall_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0.start):null), (NameBindingIdentifierParserRuleCall_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0.stop):null), grammarAccess.getFunctionHeaderAccess().getNameAssignment_1());
                      			
                    }

                    }


                    }
                    break;

            }
            int alt69=2;
            int LA69_0 = input.LA(1);

            if ( (LA69_0==RULE_VERSION) ) {
                alt69=1;
            }
            switch (alt69) {
                case 1 :
                    {
                    pushFollow(FOLLOW_39);
                    VersionDeclarationParserRuleCall_2=ruleVersionDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VersionDeclarationParserRuleCall_2!=null?((Token)VersionDeclarationParserRuleCall_2.start):null), (VersionDeclarationParserRuleCall_2!=null?((Token)VersionDeclarationParserRuleCall_2.stop):null), grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); 
                    }

                    }
                    break;

            }

            pushFollow(FOLLOW_43);
            StrictFormalParametersParserRuleCall_3=norm1_StrictFormalParameters();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((StrictFormalParametersParserRuleCall_3!=null?((Token)StrictFormalParametersParserRuleCall_3.start):null), (StrictFormalParametersParserRuleCall_3!=null?((Token)StrictFormalParametersParserRuleCall_3.stop):null), grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); 
            }
            int alt70=2;
            int LA70_0 = input.LA(1);

            if ( (LA70_0==Colon) && (synpred25_InternalN4JSParser())) {
                alt70=1;
            }
            switch (alt70) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    ColonSepReturnTypeRefParserRuleCall_4=ruleColonSepReturnTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ColonSepReturnTypeRefParserRuleCall_4!=null?((Token)ColonSepReturnTypeRefParserRuleCall_4.start):null), (ColonSepReturnTypeRefParserRuleCall_4!=null?((Token)ColonSepReturnTypeRefParserRuleCall_4.stop):null), grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); 
                    }

                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm3_FunctionHeader_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm3_FunctionHeader_return norm3_FunctionHeader() throws RecognitionException {
        InternalN4JSParser.norm3_FunctionHeader_return retval = new InternalN4JSParser.norm3_FunctionHeader_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_0 = null;

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleVersionDeclaration_return VersionDeclarationParserRuleCall_2 = null;

        InternalN4JSParser.norm1_StrictFormalParameters_return StrictFormalParametersParserRuleCall_3 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_4 = null;




        try {
            {
            {
            int alt71=2;
            int LA71_0 = input.LA(1);

            if ( (LA71_0==LessThanSign) ) {
                alt71=1;
            }
            switch (alt71) {
                case 1 :
                    {
                    pushFollow(FOLLOW_39);
                    TypeVariablesParserRuleCall_0=ruleTypeVariables();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((TypeVariablesParserRuleCall_0!=null?((Token)TypeVariablesParserRuleCall_0.start):null), (TypeVariablesParserRuleCall_0!=null?((Token)TypeVariablesParserRuleCall_0.stop):null), grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0()); 
                    }

                    }
                    break;

            }
            int alt72=2;
            int LA72_0 = input.LA(1);

            if ( ((LA72_0>=Intersection && LA72_0<=Implements)||(LA72_0>=Promisify && LA72_0<=Abstract)||LA72_0==External||(LA72_0>=Private && LA72_0<=Project)||LA72_0==Public||LA72_0==Static||LA72_0==Target||(LA72_0>=Async && LA72_0<=Await)||LA72_0==Union||LA72_0==This||LA72_0==From||LA72_0==Type||(LA72_0>=Get && LA72_0<=Let)||(LA72_0>=Out && LA72_0<=Set)||LA72_0==As||LA72_0==Of||LA72_0==RULE_IDENTIFIER) ) {
                alt72=1;
            }
            switch (alt72) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_39);
                    NameBindingIdentifierParserRuleCall_1_0=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((NameBindingIdentifierParserRuleCall_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0.start):null), (NameBindingIdentifierParserRuleCall_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0.stop):null), grammarAccess.getFunctionHeaderAccess().getNameAssignment_1());
                      			
                    }

                    }


                    }
                    break;

            }
            int alt73=2;
            int LA73_0 = input.LA(1);

            if ( (LA73_0==RULE_VERSION) ) {
                alt73=1;
            }
            switch (alt73) {
                case 1 :
                    {
                    pushFollow(FOLLOW_39);
                    VersionDeclarationParserRuleCall_2=ruleVersionDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VersionDeclarationParserRuleCall_2!=null?((Token)VersionDeclarationParserRuleCall_2.start):null), (VersionDeclarationParserRuleCall_2!=null?((Token)VersionDeclarationParserRuleCall_2.stop):null), grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2()); 
                    }

                    }
                    break;

            }

            pushFollow(FOLLOW_43);
            StrictFormalParametersParserRuleCall_3=norm1_StrictFormalParameters();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((StrictFormalParametersParserRuleCall_3!=null?((Token)StrictFormalParametersParserRuleCall_3.start):null), (StrictFormalParametersParserRuleCall_3!=null?((Token)StrictFormalParametersParserRuleCall_3.stop):null), grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3()); 
            }
            int alt74=2;
            int LA74_0 = input.LA(1);

            if ( (LA74_0==Colon) && (synpred26_InternalN4JSParser())) {
                alt74=1;
            }
            switch (alt74) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    ColonSepReturnTypeRefParserRuleCall_4=ruleColonSepReturnTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ColonSepReturnTypeRefParserRuleCall_4!=null?((Token)ColonSepReturnTypeRefParserRuleCall_4.start):null), (ColonSepReturnTypeRefParserRuleCall_4!=null?((Token)ColonSepReturnTypeRefParserRuleCall_4.stop):null), grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4()); 
                    }

                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleFunctionBody_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleFunctionBody_return ruleFunctionBody() throws RecognitionException {
        InternalN4JSParser.ruleFunctionBody_return retval = new InternalN4JSParser.ruleFunctionBody_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleBlock_return BodyBlockParserRuleCall_1_0_0 = null;




        try {
            {
            int alt75=2;
            alt75 = dfa75.predict(input);
            switch (alt75) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BodyBlockParserRuleCall_1_0_0=ruleBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce((BodyBlockParserRuleCall_1_0_0!=null?((Token)BodyBlockParserRuleCall_1_0_0.start):null), (BodyBlockParserRuleCall_1_0_0!=null?((Token)BodyBlockParserRuleCall_1_0_0.stop):null), grammarAccess.getFunctionBodyAccess().getBodyAssignment_1_0());
                      		
                    }

                    }


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_FunctionBody_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_FunctionBody_return norm1_FunctionBody() throws RecognitionException {
        InternalN4JSParser.norm1_FunctionBody_return retval = new InternalN4JSParser.norm1_FunctionBody_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_Block_return BodyBlockParserRuleCall_1_0_0 = null;




        try {
            {
            int alt76=2;
            alt76 = dfa76.predict(input);
            switch (alt76) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BodyBlockParserRuleCall_1_0_0=norm1_Block();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce((BodyBlockParserRuleCall_1_0_0!=null?((Token)BodyBlockParserRuleCall_1_0_0.start):null), (BodyBlockParserRuleCall_1_0_0!=null?((Token)BodyBlockParserRuleCall_1_0_0.stop):null), grammarAccess.getFunctionBodyAccess().getBodyAssignment_1_0());
                      		
                    }

                    }


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm2_FunctionBody_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm2_FunctionBody_return norm2_FunctionBody() throws RecognitionException {
        InternalN4JSParser.norm2_FunctionBody_return retval = new InternalN4JSParser.norm2_FunctionBody_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleBlock_return BodyBlockParserRuleCall_0_0_0 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_2);
            BodyBlockParserRuleCall_0_0_0=ruleBlock();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce((BodyBlockParserRuleCall_0_0_0!=null?((Token)BodyBlockParserRuleCall_0_0_0.start):null), (BodyBlockParserRuleCall_0_0_0!=null?((Token)BodyBlockParserRuleCall_0_0_0.stop):null), grammarAccess.getFunctionBodyAccess().getBodyAssignment_0_0());
              		
            }

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm3_FunctionBody_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm3_FunctionBody_return norm3_FunctionBody() throws RecognitionException {
        InternalN4JSParser.norm3_FunctionBody_return retval = new InternalN4JSParser.norm3_FunctionBody_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_Block_return BodyBlockParserRuleCall_0_0_0 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_2);
            BodyBlockParserRuleCall_0_0_0=norm1_Block();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce((BodyBlockParserRuleCall_0_0_0!=null?((Token)BodyBlockParserRuleCall_0_0_0.start):null), (BodyBlockParserRuleCall_0_0_0!=null?((Token)BodyBlockParserRuleCall_0_0_0.stop):null), grammarAccess.getFunctionBodyAccess().getBodyAssignment_0_0());
              		
            }

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleAnnotatedFunctionDeclaration() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleAnnotatedFunctionDeclaration();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleAnnotatedFunctionDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleAnnotatedFunctionDeclaration_return ruleAnnotatedFunctionDeclaration() throws RecognitionException {
        InternalN4JSParser.ruleAnnotatedFunctionDeclaration_return retval = new InternalN4JSParser.ruleAnnotatedFunctionDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleAnnotationList_return AnnotationListAnnotationListParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleAsyncNoTrailingLineBreak_return AsyncNoTrailingLineBreakParserRuleCall_2 = null;

        InternalN4JSParser.ruleFunctionImpl_return FunctionImplParserRuleCall_3 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_5);
            AnnotationListAnnotationListParserRuleCall_0_0=ruleAnnotationList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((AnnotationListAnnotationListParserRuleCall_0_0!=null?((Token)AnnotationListAnnotationListParserRuleCall_0_0.start):null), (AnnotationListAnnotationListParserRuleCall_0_0!=null?((Token)AnnotationListAnnotationListParserRuleCall_0_0.stop):null), grammarAccess.getAnnotatedFunctionDeclarationAccess().getAnnotationListAssignment_0());
              			
            }

            }


            }
            loop77:
            do {
                int alt77=2;
                int LA77_0 = input.LA(1);

                if ( ((LA77_0>=Protected && LA77_0<=Abstract)||LA77_0==External||(LA77_0>=Private && LA77_0<=Project)||LA77_0==Public||LA77_0==Static||LA77_0==Const) ) {
                    alt77=1;
                }


                switch (alt77) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_5);
            	    ruleN4Modifier();

            	    state._fsp--;
            	    if (state.failed) return retval;

            	    }


            	    }
            	    break;

            	default :
            	    break loop77;
                }
            } while (true);

            pushFollow(FOLLOW_5);
            AsyncNoTrailingLineBreakParserRuleCall_2=ruleAsyncNoTrailingLineBreak();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((AsyncNoTrailingLineBreakParserRuleCall_2!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_2.start):null), (AsyncNoTrailingLineBreakParserRuleCall_2!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_2.stop):null), grammarAccess.getAnnotatedFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_2()); 
            }
            pushFollow(FOLLOW_2);
            FunctionImplParserRuleCall_3=ruleFunctionImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((FunctionImplParserRuleCall_3!=null?((Token)FunctionImplParserRuleCall_3.start):null), (FunctionImplParserRuleCall_3!=null?((Token)FunctionImplParserRuleCall_3.stop):null), grammarAccess.getAnnotatedFunctionDeclarationAccess().getFunctionImplParserRuleCall_3()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_AnnotatedFunctionDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_AnnotatedFunctionDeclaration_return norm1_AnnotatedFunctionDeclaration() throws RecognitionException {
        InternalN4JSParser.norm1_AnnotatedFunctionDeclaration_return retval = new InternalN4JSParser.norm1_AnnotatedFunctionDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleAnnotationList_return AnnotationListAnnotationListParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleAsyncNoTrailingLineBreak_return AsyncNoTrailingLineBreakParserRuleCall_2 = null;

        InternalN4JSParser.norm3_FunctionImpl_return FunctionImplParserRuleCall_3 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_5);
            AnnotationListAnnotationListParserRuleCall_0_0=ruleAnnotationList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((AnnotationListAnnotationListParserRuleCall_0_0!=null?((Token)AnnotationListAnnotationListParserRuleCall_0_0.start):null), (AnnotationListAnnotationListParserRuleCall_0_0!=null?((Token)AnnotationListAnnotationListParserRuleCall_0_0.stop):null), grammarAccess.getAnnotatedFunctionDeclarationAccess().getAnnotationListAssignment_0());
              			
            }

            }


            }
            loop78:
            do {
                int alt78=2;
                int LA78_0 = input.LA(1);

                if ( ((LA78_0>=Protected && LA78_0<=Abstract)||LA78_0==External||(LA78_0>=Private && LA78_0<=Project)||LA78_0==Public||LA78_0==Static||LA78_0==Const) ) {
                    alt78=1;
                }


                switch (alt78) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_5);
            	    ruleN4Modifier();

            	    state._fsp--;
            	    if (state.failed) return retval;

            	    }


            	    }
            	    break;

            	default :
            	    break loop78;
                }
            } while (true);

            pushFollow(FOLLOW_36);
            AsyncNoTrailingLineBreakParserRuleCall_2=ruleAsyncNoTrailingLineBreak();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((AsyncNoTrailingLineBreakParserRuleCall_2!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_2.start):null), (AsyncNoTrailingLineBreakParserRuleCall_2!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_2.stop):null), grammarAccess.getAnnotatedFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_2()); 
            }
            pushFollow(FOLLOW_2);
            FunctionImplParserRuleCall_3=norm3_FunctionImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((FunctionImplParserRuleCall_3!=null?((Token)FunctionImplParserRuleCall_3.start):null), (FunctionImplParserRuleCall_3!=null?((Token)FunctionImplParserRuleCall_3.stop):null), grammarAccess.getAnnotatedFunctionDeclarationAccess().getFunctionImplParserRuleCall_3()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleFunctionExpression() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleFunctionExpression();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleFunctionExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleFunctionExpression_return ruleFunctionExpression() throws RecognitionException {
        InternalN4JSParser.ruleFunctionExpression_return retval = new InternalN4JSParser.ruleFunctionExpression_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm6_FunctionImpl_return FunctionImplParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            FunctionImplParserRuleCall_1=norm6_FunctionImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((FunctionImplParserRuleCall_1!=null?((Token)FunctionImplParserRuleCall_1.start):null), (FunctionImplParserRuleCall_1!=null?((Token)FunctionImplParserRuleCall_1.stop):null), grammarAccess.getFunctionExpressionAccess().getFunctionImplParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleAsyncFunctionExpression() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleAsyncFunctionExpression();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleAsyncFunctionExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleAsyncFunctionExpression_return ruleAsyncFunctionExpression() throws RecognitionException {
        InternalN4JSParser.ruleAsyncFunctionExpression_return retval = new InternalN4JSParser.ruleAsyncFunctionExpression_return();
        retval.start = input.LT(1);

        Token DeclaredAsyncAsyncKeyword_0_0_0_0=null;
        Token FunctionKeyword_0_0_2=null;
        InternalN4JSParser.ruleNoLineTerminator_return NoLineTerminatorParserRuleCall_0_0_1 = null;

        InternalN4JSParser.ruleFunctionHeader_return FunctionHeaderParserRuleCall_1 = null;

        InternalN4JSParser.norm2_FunctionBody_return FunctionBodyParserRuleCall_2 = null;




        try {
            {
            {
            {
            {
            {
            {
            DeclaredAsyncAsyncKeyword_0_0_0_0=(Token)match(input,Async,FOLLOW_44); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              						announce(DeclaredAsyncAsyncKeyword_0_0_0_0, grammarAccess.getAsyncFunctionExpressionAccess().getDeclaredAsyncAsyncKeyword_0_0_0_0());
              					
            }

            }


            }

            pushFollow(FOLLOW_45);
            NoLineTerminatorParserRuleCall_0_0_1=ruleNoLineTerminator();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((NoLineTerminatorParserRuleCall_0_0_1!=null?((Token)NoLineTerminatorParserRuleCall_0_0_1.start):null), (NoLineTerminatorParserRuleCall_0_0_1!=null?((Token)NoLineTerminatorParserRuleCall_0_0_1.stop):null), grammarAccess.getAsyncFunctionExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_1()); 
            }
            FunctionKeyword_0_0_2=(Token)match(input,Function,FOLLOW_38); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(FunctionKeyword_0_0_2, grammarAccess.getAsyncFunctionExpressionAccess().getFunctionKeyword_0_0_2());
              			
            }

            }


            }

            pushFollow(FOLLOW_13);
            FunctionHeaderParserRuleCall_1=ruleFunctionHeader();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((FunctionHeaderParserRuleCall_1!=null?((Token)FunctionHeaderParserRuleCall_1.start):null), (FunctionHeaderParserRuleCall_1!=null?((Token)FunctionHeaderParserRuleCall_1.stop):null), grammarAccess.getAsyncFunctionExpressionAccess().getFunctionHeaderParserRuleCall_1()); 
            }
            pushFollow(FOLLOW_2);
            FunctionBodyParserRuleCall_2=norm2_FunctionBody();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((FunctionBodyParserRuleCall_2!=null?((Token)FunctionBodyParserRuleCall_2.start):null), (FunctionBodyParserRuleCall_2!=null?((Token)FunctionBodyParserRuleCall_2.stop):null), grammarAccess.getAsyncFunctionExpressionAccess().getFunctionBodyParserRuleCall_2()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleArrowExpression() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleArrowExpression();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleArrowExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleArrowExpression_return ruleArrowExpression() throws RecognitionException {
        InternalN4JSParser.ruleArrowExpression_return retval = new InternalN4JSParser.ruleArrowExpression_return();
        retval.start = input.LT(1);

        Token DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0=null;
        Token EqualsSignGreaterThanSignKeyword_0_0_1=null;
        Token HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0=null;
        Token RightCurlyBracketKeyword_1_0_2=null;
        InternalN4JSParser.ruleStrictFormalParameters_return StrictFormalParametersParserRuleCall_0_0_0_0_0 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1 = null;

        InternalN4JSParser.ruleNoLineTerminator_return NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1 = null;

        InternalN4JSParser.ruleStrictFormalParameters_return StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1 = null;

        InternalN4JSParser.ruleBindingIdentifierAsFormalParameter_return FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0 = null;

        InternalN4JSParser.ruleBlockMinusBraces_return BodyBlockMinusBracesParserRuleCall_1_0_1_0 = null;

        InternalN4JSParser.ruleExpressionDisguisedAsBlock_return BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0 = null;




        try {
            {
            {
            {
            {
            int alt81=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt81=1;
                }
                break;
            case Async:
                {
                int LA81_2 = input.LA(2);

                if ( (LA81_2==EqualsSignGreaterThanSign) ) {
                    alt81=3;
                }
                else if ( (LA81_2==RULE_NO_LINE_TERMINATOR) && (synpred37_InternalN4JSParser())) {
                    alt81=2;
                }
                else if ( (LA81_2==LeftParenthesis) && (synpred37_InternalN4JSParser())) {
                    alt81=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 81, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case Yield:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt81=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 81, 0, input);

                throw nvae;
            }

            switch (alt81) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_46);
                    StrictFormalParametersParserRuleCall_0_0_0_0_0=ruleStrictFormalParameters();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((StrictFormalParametersParserRuleCall_0_0_0_0_0!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_0_0.start):null), (StrictFormalParametersParserRuleCall_0_0_0_0_0!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_0_0.stop):null), grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); 
                    }
                    int alt79=2;
                    int LA79_0 = input.LA(1);

                    if ( (LA79_0==Colon) ) {
                        alt79=1;
                    }
                    switch (alt79) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_47);
                            ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1=ruleColonSepReturnTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1.start):null), (ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1.stop):null), grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); 
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    {
                    DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0=(Token)match(input,Async,FOLLOW_48); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      										announce(DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0, grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0());
                      									
                    }

                    }


                    }

                    pushFollow(FOLLOW_42);
                    NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1=ruleNoLineTerminator();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1!=null?((Token)NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1.start):null), (NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1!=null?((Token)NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1.stop):null), grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_46);
                    StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2=ruleStrictFormalParameters();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2.start):null), (StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2.stop):null), grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); 
                    }

                    }


                    }


                    }
                    int alt80=2;
                    int LA80_0 = input.LA(1);

                    if ( (LA80_0==Colon) ) {
                        alt80=1;
                    }
                    switch (alt80) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_47);
                            ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1=ruleColonSepReturnTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1.start):null), (ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1.stop):null), grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); 
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_47);
                    FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0=ruleBindingIdentifierAsFormalParameter();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      							announce((FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0!=null?((Token)FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0.start):null), (FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0!=null?((Token)FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0.stop):null), grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2());
                      						
                    }

                    }


                    }


                    }
                    break;

            }

            EqualsSignGreaterThanSignKeyword_0_0_1=(Token)match(input,EqualsSignGreaterThanSign,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(EqualsSignGreaterThanSignKeyword_0_0_1, grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1());
              			
            }

            }


            }
            int alt82=2;
            alt82 = dfa82.predict(input);
            switch (alt82) {
                case 1 :
                    {
                    {
                    {
                    {
                    HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0=(Token)match(input,LeftCurlyBracket,FOLLOW_50); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0, grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0());
                      					
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_23);
                    BodyBlockMinusBracesParserRuleCall_1_0_1_0=ruleBlockMinusBraces();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((BodyBlockMinusBracesParserRuleCall_1_0_1_0!=null?((Token)BodyBlockMinusBracesParserRuleCall_1_0_1_0.start):null), (BodyBlockMinusBracesParserRuleCall_1_0_1_0!=null?((Token)BodyBlockMinusBracesParserRuleCall_1_0_1_0.stop):null), grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1());
                      					
                    }

                    }


                    }

                    RightCurlyBracketKeyword_1_0_2=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(RightCurlyBracketKeyword_1_0_2, grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2());
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0=ruleExpressionDisguisedAsBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0!=null?((Token)BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0.start):null), (BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0!=null?((Token)BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0.stop):null), grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ArrowExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ArrowExpression_return norm1_ArrowExpression() throws RecognitionException {
        InternalN4JSParser.norm1_ArrowExpression_return retval = new InternalN4JSParser.norm1_ArrowExpression_return();
        retval.start = input.LT(1);

        Token DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0=null;
        Token EqualsSignGreaterThanSignKeyword_0_0_1=null;
        Token HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0=null;
        Token RightCurlyBracketKeyword_1_0_2=null;
        InternalN4JSParser.ruleStrictFormalParameters_return StrictFormalParametersParserRuleCall_0_0_0_0_0 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1 = null;

        InternalN4JSParser.ruleNoLineTerminator_return NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1 = null;

        InternalN4JSParser.ruleStrictFormalParameters_return StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1 = null;

        InternalN4JSParser.ruleBindingIdentifierAsFormalParameter_return FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0 = null;

        InternalN4JSParser.ruleBlockMinusBraces_return BodyBlockMinusBracesParserRuleCall_1_0_1_0 = null;

        InternalN4JSParser.norm1_ExpressionDisguisedAsBlock_return BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0 = null;




        try {
            {
            {
            {
            {
            int alt85=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt85=1;
                }
                break;
            case Async:
                {
                int LA85_2 = input.LA(2);

                if ( (LA85_2==EqualsSignGreaterThanSign) ) {
                    alt85=3;
                }
                else if ( (LA85_2==RULE_NO_LINE_TERMINATOR) && (synpred43_InternalN4JSParser())) {
                    alt85=2;
                }
                else if ( (LA85_2==LeftParenthesis) && (synpred43_InternalN4JSParser())) {
                    alt85=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 85, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case Yield:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt85=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 85, 0, input);

                throw nvae;
            }

            switch (alt85) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_46);
                    StrictFormalParametersParserRuleCall_0_0_0_0_0=ruleStrictFormalParameters();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((StrictFormalParametersParserRuleCall_0_0_0_0_0!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_0_0.start):null), (StrictFormalParametersParserRuleCall_0_0_0_0_0!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_0_0.stop):null), grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); 
                    }
                    int alt83=2;
                    int LA83_0 = input.LA(1);

                    if ( (LA83_0==Colon) ) {
                        alt83=1;
                    }
                    switch (alt83) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_47);
                            ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1=ruleColonSepReturnTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1.start):null), (ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1.stop):null), grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); 
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    {
                    DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0=(Token)match(input,Async,FOLLOW_48); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      										announce(DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0, grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0());
                      									
                    }

                    }


                    }

                    pushFollow(FOLLOW_42);
                    NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1=ruleNoLineTerminator();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1!=null?((Token)NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1.start):null), (NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1!=null?((Token)NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1.stop):null), grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_46);
                    StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2=ruleStrictFormalParameters();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2.start):null), (StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2.stop):null), grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); 
                    }

                    }


                    }


                    }
                    int alt84=2;
                    int LA84_0 = input.LA(1);

                    if ( (LA84_0==Colon) ) {
                        alt84=1;
                    }
                    switch (alt84) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_47);
                            ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1=ruleColonSepReturnTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1.start):null), (ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1.stop):null), grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); 
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_47);
                    FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0=ruleBindingIdentifierAsFormalParameter();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      							announce((FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0!=null?((Token)FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0.start):null), (FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0!=null?((Token)FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0.stop):null), grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2());
                      						
                    }

                    }


                    }


                    }
                    break;

            }

            EqualsSignGreaterThanSignKeyword_0_0_1=(Token)match(input,EqualsSignGreaterThanSign,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(EqualsSignGreaterThanSignKeyword_0_0_1, grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1());
              			
            }

            }


            }
            int alt86=2;
            alt86 = dfa86.predict(input);
            switch (alt86) {
                case 1 :
                    {
                    {
                    {
                    {
                    HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0=(Token)match(input,LeftCurlyBracket,FOLLOW_50); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0, grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0());
                      					
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_23);
                    BodyBlockMinusBracesParserRuleCall_1_0_1_0=ruleBlockMinusBraces();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((BodyBlockMinusBracesParserRuleCall_1_0_1_0!=null?((Token)BodyBlockMinusBracesParserRuleCall_1_0_1_0.start):null), (BodyBlockMinusBracesParserRuleCall_1_0_1_0!=null?((Token)BodyBlockMinusBracesParserRuleCall_1_0_1_0.stop):null), grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1());
                      					
                    }

                    }


                    }

                    RightCurlyBracketKeyword_1_0_2=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(RightCurlyBracketKeyword_1_0_2, grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2());
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0=norm1_ExpressionDisguisedAsBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0!=null?((Token)BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0.start):null), (BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0!=null?((Token)BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0.stop):null), grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm2_ArrowExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm2_ArrowExpression_return norm2_ArrowExpression() throws RecognitionException {
        InternalN4JSParser.norm2_ArrowExpression_return retval = new InternalN4JSParser.norm2_ArrowExpression_return();
        retval.start = input.LT(1);

        Token DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0=null;
        Token EqualsSignGreaterThanSignKeyword_0_0_1=null;
        Token HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0=null;
        Token RightCurlyBracketKeyword_1_0_2=null;
        InternalN4JSParser.norm1_StrictFormalParameters_return StrictFormalParametersParserRuleCall_0_0_0_0_0 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1 = null;

        InternalN4JSParser.ruleNoLineTerminator_return NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1 = null;

        InternalN4JSParser.norm1_StrictFormalParameters_return StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1 = null;

        InternalN4JSParser.norm1_BindingIdentifierAsFormalParameter_return FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0 = null;

        InternalN4JSParser.norm1_BlockMinusBraces_return BodyBlockMinusBracesParserRuleCall_1_0_1_0 = null;

        InternalN4JSParser.ruleExpressionDisguisedAsBlock_return BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0 = null;




        try {
            {
            {
            {
            {
            int alt89=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt89=1;
                }
                break;
            case Async:
                {
                int LA89_2 = input.LA(2);

                if ( (LA89_2==EqualsSignGreaterThanSign) ) {
                    alt89=3;
                }
                else if ( (LA89_2==RULE_NO_LINE_TERMINATOR) && (synpred49_InternalN4JSParser())) {
                    alt89=2;
                }
                else if ( (LA89_2==LeftParenthesis) && (synpred49_InternalN4JSParser())) {
                    alt89=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 89, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt89=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 89, 0, input);

                throw nvae;
            }

            switch (alt89) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_46);
                    StrictFormalParametersParserRuleCall_0_0_0_0_0=norm1_StrictFormalParameters();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((StrictFormalParametersParserRuleCall_0_0_0_0_0!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_0_0.start):null), (StrictFormalParametersParserRuleCall_0_0_0_0_0!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_0_0.stop):null), grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); 
                    }
                    int alt87=2;
                    int LA87_0 = input.LA(1);

                    if ( (LA87_0==Colon) ) {
                        alt87=1;
                    }
                    switch (alt87) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_47);
                            ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1=ruleColonSepReturnTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1.start):null), (ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1.stop):null), grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); 
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    {
                    DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0=(Token)match(input,Async,FOLLOW_51); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      										announce(DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0, grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0());
                      									
                    }

                    }


                    }

                    pushFollow(FOLLOW_39);
                    NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1=ruleNoLineTerminator();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1!=null?((Token)NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1.start):null), (NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1!=null?((Token)NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1.stop):null), grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_46);
                    StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2=norm1_StrictFormalParameters();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2.start):null), (StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2.stop):null), grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); 
                    }

                    }


                    }


                    }
                    int alt88=2;
                    int LA88_0 = input.LA(1);

                    if ( (LA88_0==Colon) ) {
                        alt88=1;
                    }
                    switch (alt88) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_47);
                            ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1=ruleColonSepReturnTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1.start):null), (ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1.stop):null), grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); 
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_47);
                    FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0=norm1_BindingIdentifierAsFormalParameter();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      							announce((FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0!=null?((Token)FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0.start):null), (FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0!=null?((Token)FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0.stop):null), grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2());
                      						
                    }

                    }


                    }


                    }
                    break;

            }

            EqualsSignGreaterThanSignKeyword_0_0_1=(Token)match(input,EqualsSignGreaterThanSign,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(EqualsSignGreaterThanSignKeyword_0_0_1, grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1());
              			
            }

            }


            }
            int alt90=2;
            alt90 = dfa90.predict(input);
            switch (alt90) {
                case 1 :
                    {
                    {
                    {
                    {
                    HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0=(Token)match(input,LeftCurlyBracket,FOLLOW_52); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0, grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0());
                      					
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_23);
                    BodyBlockMinusBracesParserRuleCall_1_0_1_0=norm1_BlockMinusBraces();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((BodyBlockMinusBracesParserRuleCall_1_0_1_0!=null?((Token)BodyBlockMinusBracesParserRuleCall_1_0_1_0.start):null), (BodyBlockMinusBracesParserRuleCall_1_0_1_0!=null?((Token)BodyBlockMinusBracesParserRuleCall_1_0_1_0.stop):null), grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1());
                      					
                    }

                    }


                    }

                    RightCurlyBracketKeyword_1_0_2=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(RightCurlyBracketKeyword_1_0_2, grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2());
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0=ruleExpressionDisguisedAsBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0!=null?((Token)BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0.start):null), (BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0!=null?((Token)BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0.stop):null), grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm3_ArrowExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm3_ArrowExpression_return norm3_ArrowExpression() throws RecognitionException {
        InternalN4JSParser.norm3_ArrowExpression_return retval = new InternalN4JSParser.norm3_ArrowExpression_return();
        retval.start = input.LT(1);

        Token DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0=null;
        Token EqualsSignGreaterThanSignKeyword_0_0_1=null;
        Token HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0=null;
        Token RightCurlyBracketKeyword_1_0_2=null;
        InternalN4JSParser.norm1_StrictFormalParameters_return StrictFormalParametersParserRuleCall_0_0_0_0_0 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1 = null;

        InternalN4JSParser.ruleNoLineTerminator_return NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1 = null;

        InternalN4JSParser.norm1_StrictFormalParameters_return StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2 = null;

        InternalN4JSParser.ruleColonSepReturnTypeRef_return ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1 = null;

        InternalN4JSParser.norm1_BindingIdentifierAsFormalParameter_return FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0 = null;

        InternalN4JSParser.norm1_BlockMinusBraces_return BodyBlockMinusBracesParserRuleCall_1_0_1_0 = null;

        InternalN4JSParser.norm1_ExpressionDisguisedAsBlock_return BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0 = null;




        try {
            {
            {
            {
            {
            int alt93=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt93=1;
                }
                break;
            case Async:
                {
                int LA93_2 = input.LA(2);

                if ( (LA93_2==EqualsSignGreaterThanSign) ) {
                    alt93=3;
                }
                else if ( (LA93_2==RULE_NO_LINE_TERMINATOR) && (synpred55_InternalN4JSParser())) {
                    alt93=2;
                }
                else if ( (LA93_2==LeftParenthesis) && (synpred55_InternalN4JSParser())) {
                    alt93=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return retval;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 93, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt93=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 93, 0, input);

                throw nvae;
            }

            switch (alt93) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_46);
                    StrictFormalParametersParserRuleCall_0_0_0_0_0=norm1_StrictFormalParameters();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((StrictFormalParametersParserRuleCall_0_0_0_0_0!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_0_0.start):null), (StrictFormalParametersParserRuleCall_0_0_0_0_0!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_0_0.stop):null), grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0()); 
                    }
                    int alt91=2;
                    int LA91_0 = input.LA(1);

                    if ( (LA91_0==Colon) ) {
                        alt91=1;
                    }
                    switch (alt91) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_47);
                            ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1=ruleColonSepReturnTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1.start):null), (ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_0_1.stop):null), grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1()); 
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    {
                    DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0=(Token)match(input,Async,FOLLOW_51); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      										announce(DeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0, grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0());
                      									
                    }

                    }


                    }

                    pushFollow(FOLLOW_39);
                    NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1=ruleNoLineTerminator();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1!=null?((Token)NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1.start):null), (NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1!=null?((Token)NoLineTerminatorParserRuleCall_0_0_0_1_0_0_1.stop):null), grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1()); 
                    }
                    {
                    pushFollow(FOLLOW_46);
                    StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2=norm1_StrictFormalParameters();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2.start):null), (StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2!=null?((Token)StrictFormalParametersParserRuleCall_0_0_0_1_0_0_2.stop):null), grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2()); 
                    }

                    }


                    }


                    }
                    int alt92=2;
                    int LA92_0 = input.LA(1);

                    if ( (LA92_0==Colon) ) {
                        alt92=1;
                    }
                    switch (alt92) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_47);
                            ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1=ruleColonSepReturnTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1.start):null), (ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1!=null?((Token)ColonSepReturnTypeRefParserRuleCall_0_0_0_1_1.stop):null), grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1()); 
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_47);
                    FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0=norm1_BindingIdentifierAsFormalParameter();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      							announce((FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0!=null?((Token)FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0.start):null), (FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0!=null?((Token)FparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0.stop):null), grammarAccess.getArrowExpressionAccess().getFparsAssignment_0_0_0_2());
                      						
                    }

                    }


                    }


                    }
                    break;

            }

            EqualsSignGreaterThanSignKeyword_0_0_1=(Token)match(input,EqualsSignGreaterThanSign,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(EqualsSignGreaterThanSignKeyword_0_0_1, grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1());
              			
            }

            }


            }
            int alt94=2;
            alt94 = dfa94.predict(input);
            switch (alt94) {
                case 1 :
                    {
                    {
                    {
                    {
                    HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0=(Token)match(input,LeftCurlyBracket,FOLLOW_52); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(HasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0, grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0());
                      					
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_23);
                    BodyBlockMinusBracesParserRuleCall_1_0_1_0=norm1_BlockMinusBraces();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((BodyBlockMinusBracesParserRuleCall_1_0_1_0!=null?((Token)BodyBlockMinusBracesParserRuleCall_1_0_1_0.start):null), (BodyBlockMinusBracesParserRuleCall_1_0_1_0!=null?((Token)BodyBlockMinusBracesParserRuleCall_1_0_1_0.stop):null), grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_0_1());
                      					
                    }

                    }


                    }

                    RightCurlyBracketKeyword_1_0_2=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(RightCurlyBracketKeyword_1_0_2, grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2());
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0=norm1_ExpressionDisguisedAsBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0!=null?((Token)BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0.start):null), (BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0!=null?((Token)BodyExpressionDisguisedAsBlockParserRuleCall_1_1_0.stop):null), grammarAccess.getArrowExpressionAccess().getBodyAssignment_1_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleStrictFormalParameters_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleStrictFormalParameters_return ruleStrictFormalParameters() throws RecognitionException {
        InternalN4JSParser.ruleStrictFormalParameters_return retval = new InternalN4JSParser.ruleStrictFormalParameters_return();
        retval.start = input.LT(1);

        Token LeftParenthesisKeyword_0=null;
        Token CommaKeyword_1_1_0=null;
        Token RightParenthesisKeyword_2=null;
        InternalN4JSParser.ruleFormalParameter_return FparsFormalParameterParserRuleCall_1_0_0 = null;

        InternalN4JSParser.ruleFormalParameter_return FparsFormalParameterParserRuleCall_1_1_1_0 = null;




        try {
            {
            {
            LeftParenthesisKeyword_0=(Token)match(input,LeftParenthesis,FOLLOW_53); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_0, grammarAccess.getStrictFormalParametersAccess().getLeftParenthesisKeyword_0());
              	
            }
            int alt96=2;
            int LA96_0 = input.LA(1);

            if ( ((LA96_0>=Intersection && LA96_0<=Implements)||(LA96_0>=Promisify && LA96_0<=Abstract)||LA96_0==External||LA96_0==Default||(LA96_0>=Private && LA96_0<=Project)||LA96_0==Public||LA96_0==Static||LA96_0==Target||(LA96_0>=Async && LA96_0<=Await)||LA96_0==Union||(LA96_0>=Yield && LA96_0<=This)||LA96_0==From||LA96_0==This_1||(LA96_0>=Type && LA96_0<=Void)||LA96_0==FullStopFullStopFullStop||(LA96_0>=Get && LA96_0<=Let)||(LA96_0>=Out && LA96_0<=Set)||LA96_0==As||LA96_0==Of||(LA96_0>=CommercialAt && LA96_0<=LeftSquareBracket)||LA96_0==LeftCurlyBracket||LA96_0==Tilde||LA96_0==RULE_IDENTIFIER) ) {
                alt96=1;
            }
            switch (alt96) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_54);
                    FparsFormalParameterParserRuleCall_1_0_0=ruleFormalParameter();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((FparsFormalParameterParserRuleCall_1_0_0!=null?((Token)FparsFormalParameterParserRuleCall_1_0_0.start):null), (FparsFormalParameterParserRuleCall_1_0_0!=null?((Token)FparsFormalParameterParserRuleCall_1_0_0.stop):null), grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_0());
                      				
                    }

                    }


                    }
                    loop95:
                    do {
                        int alt95=2;
                        int LA95_0 = input.LA(1);

                        if ( (LA95_0==Comma) ) {
                            alt95=1;
                        }


                        switch (alt95) {
                    	case 1 :
                    	    {
                    	    CommaKeyword_1_1_0=(Token)match(input,Comma,FOLLOW_55); if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      				announce(CommaKeyword_1_1_0, grammarAccess.getStrictFormalParametersAccess().getCommaKeyword_1_1_0());
                    	      			
                    	    }
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_54);
                    	    FparsFormalParameterParserRuleCall_1_1_1_0=ruleFormalParameter();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      						announce((FparsFormalParameterParserRuleCall_1_1_1_0!=null?((Token)FparsFormalParameterParserRuleCall_1_1_1_0.start):null), (FparsFormalParameterParserRuleCall_1_1_1_0!=null?((Token)FparsFormalParameterParserRuleCall_1_1_1_0.stop):null), grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_1_1());
                    	      					
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop95;
                        }
                    } while (true);


                    }
                    break;

            }

            RightParenthesisKeyword_2=(Token)match(input,RightParenthesis,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_2, grammarAccess.getStrictFormalParametersAccess().getRightParenthesisKeyword_2());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_StrictFormalParameters_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_StrictFormalParameters_return norm1_StrictFormalParameters() throws RecognitionException {
        InternalN4JSParser.norm1_StrictFormalParameters_return retval = new InternalN4JSParser.norm1_StrictFormalParameters_return();
        retval.start = input.LT(1);

        Token LeftParenthesisKeyword_0=null;
        Token CommaKeyword_1_1_0=null;
        Token RightParenthesisKeyword_2=null;
        InternalN4JSParser.norm1_FormalParameter_return FparsFormalParameterParserRuleCall_1_0_0 = null;

        InternalN4JSParser.norm1_FormalParameter_return FparsFormalParameterParserRuleCall_1_1_1_0 = null;




        try {
            {
            {
            LeftParenthesisKeyword_0=(Token)match(input,LeftParenthesis,FOLLOW_53); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_0, grammarAccess.getStrictFormalParametersAccess().getLeftParenthesisKeyword_0());
              	
            }
            int alt98=2;
            int LA98_0 = input.LA(1);

            if ( ((LA98_0>=Intersection && LA98_0<=Implements)||(LA98_0>=Promisify && LA98_0<=Abstract)||LA98_0==External||LA98_0==Default||(LA98_0>=Private && LA98_0<=Project)||LA98_0==Public||LA98_0==Static||LA98_0==Target||(LA98_0>=Async && LA98_0<=Await)||LA98_0==Union||LA98_0==This||LA98_0==From||LA98_0==This_1||(LA98_0>=Type && LA98_0<=Void)||LA98_0==FullStopFullStopFullStop||(LA98_0>=Get && LA98_0<=Let)||(LA98_0>=Out && LA98_0<=Set)||LA98_0==As||LA98_0==Of||(LA98_0>=CommercialAt && LA98_0<=LeftSquareBracket)||LA98_0==LeftCurlyBracket||LA98_0==Tilde||LA98_0==RULE_IDENTIFIER) ) {
                alt98=1;
            }
            switch (alt98) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_54);
                    FparsFormalParameterParserRuleCall_1_0_0=norm1_FormalParameter();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((FparsFormalParameterParserRuleCall_1_0_0!=null?((Token)FparsFormalParameterParserRuleCall_1_0_0.start):null), (FparsFormalParameterParserRuleCall_1_0_0!=null?((Token)FparsFormalParameterParserRuleCall_1_0_0.stop):null), grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_0());
                      				
                    }

                    }


                    }
                    loop97:
                    do {
                        int alt97=2;
                        int LA97_0 = input.LA(1);

                        if ( (LA97_0==Comma) ) {
                            alt97=1;
                        }


                        switch (alt97) {
                    	case 1 :
                    	    {
                    	    CommaKeyword_1_1_0=(Token)match(input,Comma,FOLLOW_55); if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      				announce(CommaKeyword_1_1_0, grammarAccess.getStrictFormalParametersAccess().getCommaKeyword_1_1_0());
                    	      			
                    	    }
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_54);
                    	    FparsFormalParameterParserRuleCall_1_1_1_0=norm1_FormalParameter();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      						announce((FparsFormalParameterParserRuleCall_1_1_1_0!=null?((Token)FparsFormalParameterParserRuleCall_1_1_1_0.start):null), (FparsFormalParameterParserRuleCall_1_1_1_0!=null?((Token)FparsFormalParameterParserRuleCall_1_1_1_0.stop):null), grammarAccess.getStrictFormalParametersAccess().getFparsAssignment_1_1_1());
                    	      					
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop97;
                        }
                    } while (true);


                    }
                    break;

            }

            RightParenthesisKeyword_2=(Token)match(input,RightParenthesis,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_2, grammarAccess.getStrictFormalParametersAccess().getRightParenthesisKeyword_2());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleBindingIdentifierAsFormalParameter() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleBindingIdentifierAsFormalParameter();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleBindingIdentifierAsFormalParameter_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleBindingIdentifierAsFormalParameter_return ruleBindingIdentifierAsFormalParameter() throws RecognitionException {
        InternalN4JSParser.ruleBindingIdentifierAsFormalParameter_return retval = new InternalN4JSParser.ruleBindingIdentifierAsFormalParameter_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_0 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_2);
            NameBindingIdentifierParserRuleCall_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce((NameBindingIdentifierParserRuleCall_0!=null?((Token)NameBindingIdentifierParserRuleCall_0.start):null), (NameBindingIdentifierParserRuleCall_0!=null?((Token)NameBindingIdentifierParserRuleCall_0.stop):null), grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameAssignment());
              		
            }

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_BindingIdentifierAsFormalParameter_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_BindingIdentifierAsFormalParameter_return norm1_BindingIdentifierAsFormalParameter() throws RecognitionException {
        InternalN4JSParser.norm1_BindingIdentifierAsFormalParameter_return retval = new InternalN4JSParser.norm1_BindingIdentifierAsFormalParameter_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_0 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_2);
            NameBindingIdentifierParserRuleCall_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce((NameBindingIdentifierParserRuleCall_0!=null?((Token)NameBindingIdentifierParserRuleCall_0.start):null), (NameBindingIdentifierParserRuleCall_0!=null?((Token)NameBindingIdentifierParserRuleCall_0.stop):null), grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameAssignment());
              		
            }

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleBlockMinusBraces() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleBlockMinusBraces();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleBlockMinusBraces_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleBlockMinusBraces_return ruleBlockMinusBraces() throws RecognitionException {
        InternalN4JSParser.ruleBlockMinusBraces_return retval = new InternalN4JSParser.ruleBlockMinusBraces_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleStatement_return StatementsStatementParserRuleCall_1_0 = null;




        try {
            {
            {
            loop99:
            do {
                int alt99=2;
                int LA99_0 = input.LA(1);

                if ( ((LA99_0>=Intersection && LA99_0<=Implements)||(LA99_0>=Promisify && LA99_0<=Function)||(LA99_0>=Private && LA99_0<=Delete)||(LA99_0>=Import && LA99_0<=Break)||(LA99_0>=Class && LA99_0<=This)||(LA99_0>=From && LA99_0<=With)||(LA99_0>=For && LA99_0<=Var)||LA99_0==PlusSignPlusSign||LA99_0==HyphenMinusHyphenMinus||LA99_0==SolidusEqualsSign||(LA99_0>=As && LA99_0<=If)||LA99_0==Of||LA99_0==ExclamationMark||LA99_0==LeftParenthesis||LA99_0==PlusSign||LA99_0==HyphenMinus||LA99_0==Solidus||(LA99_0>=Semicolon && LA99_0<=LessThanSign)||(LA99_0>=CommercialAt && LA99_0<=LeftSquareBracket)||LA99_0==LeftCurlyBracket||LA99_0==Tilde||LA99_0==RULE_DOUBLE||(LA99_0>=RULE_HEX_INT && LA99_0<=RULE_LEGACY_OCTAL_INT)||LA99_0==RULE_SCIENTIFIC_INT||LA99_0==RULE_IDENTIFIER||LA99_0==RULE_STRING||(LA99_0>=RULE_TEMPLATE_HEAD && LA99_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA99_0==RULE_INT) ) {
                    alt99=1;
                }


                switch (alt99) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_3);
            	    StatementsStatementParserRuleCall_1_0=ruleStatement();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((StatementsStatementParserRuleCall_1_0!=null?((Token)StatementsStatementParserRuleCall_1_0.start):null), (StatementsStatementParserRuleCall_1_0!=null?((Token)StatementsStatementParserRuleCall_1_0.stop):null), grammarAccess.getBlockMinusBracesAccess().getStatementsAssignment_1());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop99;
                }
            } while (true);


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_BlockMinusBraces_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_BlockMinusBraces_return norm1_BlockMinusBraces() throws RecognitionException {
        InternalN4JSParser.norm1_BlockMinusBraces_return retval = new InternalN4JSParser.norm1_BlockMinusBraces_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_Statement_return StatementsStatementParserRuleCall_1_0 = null;




        try {
            {
            {
            loop100:
            do {
                int alt100=2;
                int LA100_0 = input.LA(1);

                if ( ((LA100_0>=Intersection && LA100_0<=Implements)||(LA100_0>=Promisify && LA100_0<=Function)||(LA100_0>=Private && LA100_0<=Delete)||(LA100_0>=Import && LA100_0<=Break)||(LA100_0>=Class && LA100_0<=This)||(LA100_0>=From && LA100_0<=With)||(LA100_0>=For && LA100_0<=Var)||LA100_0==PlusSignPlusSign||LA100_0==HyphenMinusHyphenMinus||LA100_0==SolidusEqualsSign||(LA100_0>=As && LA100_0<=If)||LA100_0==Of||LA100_0==ExclamationMark||LA100_0==LeftParenthesis||LA100_0==PlusSign||LA100_0==HyphenMinus||LA100_0==Solidus||(LA100_0>=Semicolon && LA100_0<=LessThanSign)||(LA100_0>=CommercialAt && LA100_0<=LeftSquareBracket)||LA100_0==LeftCurlyBracket||LA100_0==Tilde||LA100_0==RULE_DOUBLE||(LA100_0>=RULE_HEX_INT && LA100_0<=RULE_LEGACY_OCTAL_INT)||LA100_0==RULE_SCIENTIFIC_INT||LA100_0==RULE_IDENTIFIER||LA100_0==RULE_STRING||(LA100_0>=RULE_TEMPLATE_HEAD && LA100_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA100_0==RULE_INT) ) {
                    alt100=1;
                }


                switch (alt100) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_56);
            	    StatementsStatementParserRuleCall_1_0=norm1_Statement();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((StatementsStatementParserRuleCall_1_0!=null?((Token)StatementsStatementParserRuleCall_1_0.start):null), (StatementsStatementParserRuleCall_1_0!=null?((Token)StatementsStatementParserRuleCall_1_0.stop):null), grammarAccess.getBlockMinusBracesAccess().getStatementsAssignment_1());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop100;
                }
            } while (true);


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleExpressionDisguisedAsBlock() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleExpressionDisguisedAsBlock();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleExpressionDisguisedAsBlock_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExpressionDisguisedAsBlock_return ruleExpressionDisguisedAsBlock() throws RecognitionException {
        InternalN4JSParser.ruleExpressionDisguisedAsBlock_return retval = new InternalN4JSParser.ruleExpressionDisguisedAsBlock_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleAssignmentExpressionStatement_return StatementsAssignmentExpressionStatementParserRuleCall_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_2);
            StatementsAssignmentExpressionStatementParserRuleCall_1_0=ruleAssignmentExpressionStatement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementsAssignmentExpressionStatementParserRuleCall_1_0!=null?((Token)StatementsAssignmentExpressionStatementParserRuleCall_1_0.start):null), (StatementsAssignmentExpressionStatementParserRuleCall_1_0!=null?((Token)StatementsAssignmentExpressionStatementParserRuleCall_1_0.stop):null), grammarAccess.getExpressionDisguisedAsBlockAccess().getStatementsAssignment_1());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ExpressionDisguisedAsBlock_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ExpressionDisguisedAsBlock_return norm1_ExpressionDisguisedAsBlock() throws RecognitionException {
        InternalN4JSParser.norm1_ExpressionDisguisedAsBlock_return retval = new InternalN4JSParser.norm1_ExpressionDisguisedAsBlock_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_AssignmentExpressionStatement_return StatementsAssignmentExpressionStatementParserRuleCall_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_2);
            StatementsAssignmentExpressionStatementParserRuleCall_1_0=norm1_AssignmentExpressionStatement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementsAssignmentExpressionStatementParserRuleCall_1_0!=null?((Token)StatementsAssignmentExpressionStatementParserRuleCall_1_0.start):null), (StatementsAssignmentExpressionStatementParserRuleCall_1_0!=null?((Token)StatementsAssignmentExpressionStatementParserRuleCall_1_0.stop):null), grammarAccess.getExpressionDisguisedAsBlockAccess().getStatementsAssignment_1());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleAssignmentExpressionStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleAssignmentExpressionStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleAssignmentExpressionStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleAssignmentExpressionStatement_return ruleAssignmentExpressionStatement() throws RecognitionException {
        InternalN4JSParser.ruleAssignmentExpressionStatement_return retval = new InternalN4JSParser.ruleAssignmentExpressionStatement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleAssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_0 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_0=ruleAssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce((ExpressionAssignmentExpressionParserRuleCall_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_0.stop):null), grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignment());
              		
            }

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_AssignmentExpressionStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_AssignmentExpressionStatement_return norm1_AssignmentExpressionStatement() throws RecognitionException {
        InternalN4JSParser.norm1_AssignmentExpressionStatement_return retval = new InternalN4JSParser.norm1_AssignmentExpressionStatement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_0 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_0=norm1_AssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce((ExpressionAssignmentExpressionParserRuleCall_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_0.stop):null), grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignment());
              		
            }

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleAnnotatedExpression() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleAnnotatedExpression();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleAnnotatedExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleAnnotatedExpression_return ruleAnnotatedExpression() throws RecognitionException {
        InternalN4JSParser.ruleAnnotatedExpression_return retval = new InternalN4JSParser.ruleAnnotatedExpression_return();
        retval.start = input.LT(1);

        Token ClassKeyword_1_0_1=null;
        InternalN4JSParser.ruleExpressionAnnotationList_return ExpressionAnnotationListParserRuleCall_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0_2_0 = null;

        InternalN4JSParser.ruleClassExtendsImplements_return ClassExtendsImplementsParserRuleCall_1_0_3 = null;

        InternalN4JSParser.ruleMembers_return MembersParserRuleCall_1_0_4 = null;

        InternalN4JSParser.ruleAsyncNoTrailingLineBreak_return AsyncNoTrailingLineBreakParserRuleCall_1_1_1 = null;

        InternalN4JSParser.norm6_FunctionImpl_return FunctionImplParserRuleCall_1_1_2 = null;




        try {
            {
            {
            pushFollow(FOLLOW_57);
            ExpressionAnnotationListParserRuleCall_0=ruleExpressionAnnotationList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((ExpressionAnnotationListParserRuleCall_0!=null?((Token)ExpressionAnnotationListParserRuleCall_0.start):null), (ExpressionAnnotationListParserRuleCall_0!=null?((Token)ExpressionAnnotationListParserRuleCall_0.stop):null), grammarAccess.getAnnotatedExpressionAccess().getExpressionAnnotationListParserRuleCall_0()); 
            }
            int alt103=2;
            int LA103_0 = input.LA(1);

            if ( (LA103_0==Class) ) {
                alt103=1;
            }
            else if ( (LA103_0==Function||LA103_0==Async) ) {
                alt103=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 103, 0, input);

                throw nvae;
            }
            switch (alt103) {
                case 1 :
                    {
                    {
                    ClassKeyword_1_0_1=(Token)match(input,Class,FOLLOW_58); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(ClassKeyword_1_0_1, grammarAccess.getAnnotatedExpressionAccess().getClassKeyword_1_0_1());
                      			
                    }
                    int alt101=2;
                    int LA101_0 = input.LA(1);

                    if ( ((LA101_0>=Intersection && LA101_0<=Constructor)||(LA101_0>=Promisify && LA101_0<=Abstract)||LA101_0==External||(LA101_0>=Private && LA101_0<=Project)||LA101_0==Public||LA101_0==Static||LA101_0==Target||(LA101_0>=Async && LA101_0<=Await)||LA101_0==Union||(LA101_0>=Yield && LA101_0<=This)||LA101_0==From||LA101_0==Type||(LA101_0>=Get && LA101_0<=Let)||(LA101_0>=Out && LA101_0<=Set)||LA101_0==As||LA101_0==Of||LA101_0==RULE_IDENTIFIER) ) {
                        alt101=1;
                    }
                    else if ( (LA101_0==Implements) ) {
                        int LA101_2 = input.LA(2);

                        if ( (LA101_2==Implements||LA101_2==Extends||LA101_2==LeftCurlyBracket) ) {
                            alt101=1;
                        }
                    }
                    switch (alt101) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_9);
                            NameBindingIdentifierParserRuleCall_1_0_2_0=ruleBindingIdentifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce((NameBindingIdentifierParserRuleCall_1_0_2_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_2_0.start):null), (NameBindingIdentifierParserRuleCall_1_0_2_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_2_0.stop):null), grammarAccess.getAnnotatedExpressionAccess().getNameAssignment_1_0_2());
                              					
                            }

                            }


                            }
                            break;

                    }
                    int alt102=2;
                    int LA102_0 = input.LA(1);

                    if ( (LA102_0==Implements||LA102_0==Extends) ) {
                        alt102=1;
                    }
                    switch (alt102) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_9);
                            ClassExtendsImplementsParserRuleCall_1_0_3=ruleClassExtendsImplements();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ClassExtendsImplementsParserRuleCall_1_0_3!=null?((Token)ClassExtendsImplementsParserRuleCall_1_0_3.start):null), (ClassExtendsImplementsParserRuleCall_1_0_3!=null?((Token)ClassExtendsImplementsParserRuleCall_1_0_3.stop):null), grammarAccess.getAnnotatedExpressionAccess().getClassExtendsImplementsParserRuleCall_1_0_3()); 
                            }

                            }
                            break;

                    }

                    pushFollow(FOLLOW_2);
                    MembersParserRuleCall_1_0_4=ruleMembers();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((MembersParserRuleCall_1_0_4!=null?((Token)MembersParserRuleCall_1_0_4.start):null), (MembersParserRuleCall_1_0_4!=null?((Token)MembersParserRuleCall_1_0_4.stop):null), grammarAccess.getAnnotatedExpressionAccess().getMembersParserRuleCall_1_0_4()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_45);
                    AsyncNoTrailingLineBreakParserRuleCall_1_1_1=ruleAsyncNoTrailingLineBreak();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AsyncNoTrailingLineBreakParserRuleCall_1_1_1!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_1_1_1.start):null), (AsyncNoTrailingLineBreakParserRuleCall_1_1_1!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_1_1_1.stop):null), grammarAccess.getAnnotatedExpressionAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_1_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    FunctionImplParserRuleCall_1_1_2=norm6_FunctionImpl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionImplParserRuleCall_1_1_2!=null?((Token)FunctionImplParserRuleCall_1_1_2.start):null), (FunctionImplParserRuleCall_1_1_2!=null?((Token)FunctionImplParserRuleCall_1_1_2.stop):null), grammarAccess.getAnnotatedExpressionAccess().getFunctionImplParserRuleCall_1_1_2()); 
                    }

                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_AnnotatedExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_AnnotatedExpression_return norm1_AnnotatedExpression() throws RecognitionException {
        InternalN4JSParser.norm1_AnnotatedExpression_return retval = new InternalN4JSParser.norm1_AnnotatedExpression_return();
        retval.start = input.LT(1);

        Token ClassKeyword_1_0_1=null;
        InternalN4JSParser.ruleExpressionAnnotationList_return ExpressionAnnotationListParserRuleCall_0 = null;

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0_2_0 = null;

        InternalN4JSParser.norm1_ClassExtendsImplements_return ClassExtendsImplementsParserRuleCall_1_0_3 = null;

        InternalN4JSParser.norm1_Members_return MembersParserRuleCall_1_0_4 = null;

        InternalN4JSParser.ruleAsyncNoTrailingLineBreak_return AsyncNoTrailingLineBreakParserRuleCall_1_1_1 = null;

        InternalN4JSParser.norm6_FunctionImpl_return FunctionImplParserRuleCall_1_1_2 = null;




        try {
            {
            {
            pushFollow(FOLLOW_57);
            ExpressionAnnotationListParserRuleCall_0=ruleExpressionAnnotationList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((ExpressionAnnotationListParserRuleCall_0!=null?((Token)ExpressionAnnotationListParserRuleCall_0.start):null), (ExpressionAnnotationListParserRuleCall_0!=null?((Token)ExpressionAnnotationListParserRuleCall_0.stop):null), grammarAccess.getAnnotatedExpressionAccess().getExpressionAnnotationListParserRuleCall_0()); 
            }
            int alt106=2;
            int LA106_0 = input.LA(1);

            if ( (LA106_0==Class) ) {
                alt106=1;
            }
            else if ( (LA106_0==Function||LA106_0==Async) ) {
                alt106=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 106, 0, input);

                throw nvae;
            }
            switch (alt106) {
                case 1 :
                    {
                    {
                    ClassKeyword_1_0_1=(Token)match(input,Class,FOLLOW_59); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(ClassKeyword_1_0_1, grammarAccess.getAnnotatedExpressionAccess().getClassKeyword_1_0_1());
                      			
                    }
                    int alt104=2;
                    int LA104_0 = input.LA(1);

                    if ( ((LA104_0>=Intersection && LA104_0<=Constructor)||(LA104_0>=Promisify && LA104_0<=Abstract)||LA104_0==External||(LA104_0>=Private && LA104_0<=Project)||LA104_0==Public||LA104_0==Static||LA104_0==Target||(LA104_0>=Async && LA104_0<=Await)||LA104_0==Union||LA104_0==This||LA104_0==From||LA104_0==Type||(LA104_0>=Get && LA104_0<=Let)||(LA104_0>=Out && LA104_0<=Set)||LA104_0==As||LA104_0==Of||LA104_0==RULE_IDENTIFIER) ) {
                        alt104=1;
                    }
                    else if ( (LA104_0==Implements) ) {
                        int LA104_2 = input.LA(2);

                        if ( (LA104_2==Implements||LA104_2==Extends||LA104_2==LeftCurlyBracket) ) {
                            alt104=1;
                        }
                    }
                    switch (alt104) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_59);
                            NameBindingIdentifierParserRuleCall_1_0_2_0=norm1_BindingIdentifier();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce((NameBindingIdentifierParserRuleCall_1_0_2_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_2_0.start):null), (NameBindingIdentifierParserRuleCall_1_0_2_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_2_0.stop):null), grammarAccess.getAnnotatedExpressionAccess().getNameAssignment_1_0_2());
                              					
                            }

                            }


                            }
                            break;

                    }
                    int alt105=2;
                    int LA105_0 = input.LA(1);

                    if ( (LA105_0==Implements||LA105_0==Extends) ) {
                        alt105=1;
                    }
                    switch (alt105) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_59);
                            ClassExtendsImplementsParserRuleCall_1_0_3=norm1_ClassExtendsImplements();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ClassExtendsImplementsParserRuleCall_1_0_3!=null?((Token)ClassExtendsImplementsParserRuleCall_1_0_3.start):null), (ClassExtendsImplementsParserRuleCall_1_0_3!=null?((Token)ClassExtendsImplementsParserRuleCall_1_0_3.stop):null), grammarAccess.getAnnotatedExpressionAccess().getClassExtendsImplementsParserRuleCall_1_0_3()); 
                            }

                            }
                            break;

                    }

                    pushFollow(FOLLOW_2);
                    MembersParserRuleCall_1_0_4=norm1_Members();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((MembersParserRuleCall_1_0_4!=null?((Token)MembersParserRuleCall_1_0_4.start):null), (MembersParserRuleCall_1_0_4!=null?((Token)MembersParserRuleCall_1_0_4.stop):null), grammarAccess.getAnnotatedExpressionAccess().getMembersParserRuleCall_1_0_4()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_45);
                    AsyncNoTrailingLineBreakParserRuleCall_1_1_1=ruleAsyncNoTrailingLineBreak();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AsyncNoTrailingLineBreakParserRuleCall_1_1_1!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_1_1_1.start):null), (AsyncNoTrailingLineBreakParserRuleCall_1_1_1!=null?((Token)AsyncNoTrailingLineBreakParserRuleCall_1_1_1.stop):null), grammarAccess.getAnnotatedExpressionAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_1_1()); 
                    }
                    pushFollow(FOLLOW_2);
                    FunctionImplParserRuleCall_1_1_2=norm6_FunctionImpl();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionImplParserRuleCall_1_1_2!=null?((Token)FunctionImplParserRuleCall_1_1_2.start):null), (FunctionImplParserRuleCall_1_1_2!=null?((Token)FunctionImplParserRuleCall_1_1_2.stop):null), grammarAccess.getAnnotatedExpressionAccess().getFunctionImplParserRuleCall_1_1_2()); 
                    }

                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleTypeVariable() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleTypeVariable();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleTypeVariable_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleTypeVariable_return ruleTypeVariable() throws RecognitionException {
        InternalN4JSParser.ruleTypeVariable_return retval = new InternalN4JSParser.ruleTypeVariable_return();
        retval.start = input.LT(1);

        Token DeclaredCovariantOutKeyword_0_0_0=null;
        Token DeclaredContravariantInKeyword_0_1_0=null;
        Token ExtendsKeyword_2_0=null;
        InternalN4JSParser.ruleIdentifierOrThis_return NameIdentifierOrThisParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleTypeRef_return DeclaredUpperBoundTypeRefParserRuleCall_2_1_0 = null;




        try {
            {
            {
            int alt107=3;
            int LA107_0 = input.LA(1);

            if ( (LA107_0==Out) ) {
                alt107=1;
            }
            else if ( (LA107_0==In) ) {
                alt107=2;
            }
            switch (alt107) {
                case 1 :
                    {
                    {
                    {
                    DeclaredCovariantOutKeyword_0_0_0=(Token)match(input,Out,FOLLOW_60); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce(DeclaredCovariantOutKeyword_0_0_0, grammarAccess.getTypeVariableAccess().getDeclaredCovariantOutKeyword_0_0_0());
                      				
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    DeclaredContravariantInKeyword_0_1_0=(Token)match(input,In,FOLLOW_60); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce(DeclaredContravariantInKeyword_0_1_0, grammarAccess.getTypeVariableAccess().getDeclaredContravariantInKeyword_0_1_0());
                      				
                    }

                    }


                    }


                    }
                    break;

            }
            {
            {
            pushFollow(FOLLOW_61);
            NameIdentifierOrThisParserRuleCall_1_0=ruleIdentifierOrThis();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((NameIdentifierOrThisParserRuleCall_1_0!=null?((Token)NameIdentifierOrThisParserRuleCall_1_0.start):null), (NameIdentifierOrThisParserRuleCall_1_0!=null?((Token)NameIdentifierOrThisParserRuleCall_1_0.stop):null), grammarAccess.getTypeVariableAccess().getNameAssignment_1());
              			
            }

            }


            }
            int alt108=2;
            int LA108_0 = input.LA(1);

            if ( (LA108_0==Extends) ) {
                alt108=1;
            }
            switch (alt108) {
                case 1 :
                    {
                    ExtendsKeyword_2_0=(Token)match(input,Extends,FOLLOW_62); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce(ExtendsKeyword_2_0, grammarAccess.getTypeVariableAccess().getExtendsKeyword_2_0());
                      		
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    DeclaredUpperBoundTypeRefParserRuleCall_2_1_0=ruleTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((DeclaredUpperBoundTypeRefParserRuleCall_2_1_0!=null?((Token)DeclaredUpperBoundTypeRefParserRuleCall_2_1_0.start):null), (DeclaredUpperBoundTypeRefParserRuleCall_2_1_0!=null?((Token)DeclaredUpperBoundTypeRefParserRuleCall_2_1_0.stop):null), grammarAccess.getTypeVariableAccess().getDeclaredUpperBoundAssignment_2_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleFormalParameter() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleFormalParameter();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleFormalParameter_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleFormalParameter_return ruleFormalParameter() throws RecognitionException {
        InternalN4JSParser.ruleFormalParameter_return retval = new InternalN4JSParser.ruleFormalParameter_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleBindingElementFragment_return BindingElementFragmentParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            BindingElementFragmentParserRuleCall_1=ruleBindingElementFragment();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((BindingElementFragmentParserRuleCall_1!=null?((Token)BindingElementFragmentParserRuleCall_1.start):null), (BindingElementFragmentParserRuleCall_1!=null?((Token)BindingElementFragmentParserRuleCall_1.stop):null), grammarAccess.getFormalParameterAccess().getBindingElementFragmentParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_FormalParameter_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_FormalParameter_return norm1_FormalParameter() throws RecognitionException {
        InternalN4JSParser.norm1_FormalParameter_return retval = new InternalN4JSParser.norm1_FormalParameter_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_BindingElementFragment_return BindingElementFragmentParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            BindingElementFragmentParserRuleCall_1=norm1_BindingElementFragment();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((BindingElementFragmentParserRuleCall_1!=null?((Token)BindingElementFragmentParserRuleCall_1.start):null), (BindingElementFragmentParserRuleCall_1!=null?((Token)BindingElementFragmentParserRuleCall_1.stop):null), grammarAccess.getFormalParameterAccess().getBindingElementFragmentParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleBindingElementFragment_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleBindingElementFragment_return ruleBindingElementFragment() throws RecognitionException {
        InternalN4JSParser.ruleBindingElementFragment_return retval = new InternalN4JSParser.ruleBindingElementFragment_return();
        retval.start = input.LT(1);

        Token VariadicFullStopFullStopFullStopKeyword_0_1_2_0=null;
        Token HasInitializerAssignmentEqualsSignKeyword_1_0_0=null;
        InternalN4JSParser.ruleBindingPattern_return BindingPatternBindingPatternParserRuleCall_0_0_0 = null;

        InternalN4JSParser.ruleAnnotation_return AnnotationsAnnotationParserRuleCall_0_1_0_0 = null;

        InternalN4JSParser.ruleBogusTypeRefFragment_return BogusTypeRefFragmentParserRuleCall_0_1_1 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_0_1_3_0 = null;

        InternalN4JSParser.ruleColonSepDeclaredTypeRef_return ColonSepDeclaredTypeRefParserRuleCall_0_1_4 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return InitializerAssignmentExpressionParserRuleCall_1_1_0 = null;




        try {
            {
            {
            int alt113=2;
            alt113 = dfa113.predict(input);
            switch (alt113) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_63);
                    BindingPatternBindingPatternParserRuleCall_0_0_0=ruleBindingPattern();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((BindingPatternBindingPatternParserRuleCall_0_0_0!=null?((Token)BindingPatternBindingPatternParserRuleCall_0_0_0.start):null), (BindingPatternBindingPatternParserRuleCall_0_0_0!=null?((Token)BindingPatternBindingPatternParserRuleCall_0_0_0.stop):null), grammarAccess.getBindingElementFragmentAccess().getBindingPatternAssignment_0_0());
                      				
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    loop109:
                    do {
                        int alt109=2;
                        int LA109_0 = input.LA(1);

                        if ( (LA109_0==CommercialAt) ) {
                            alt109=1;
                        }


                        switch (alt109) {
                    	case 1 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_64);
                    	    AnnotationsAnnotationParserRuleCall_0_1_0_0=ruleAnnotation();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      						announce((AnnotationsAnnotationParserRuleCall_0_1_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_1_0_0.start):null), (AnnotationsAnnotationParserRuleCall_0_1_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_1_0_0.stop):null), grammarAccess.getBindingElementFragmentAccess().getAnnotationsAssignment_0_1_0());
                    	      					
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop109;
                        }
                    } while (true);
                    int alt110=2;
                    alt110 = dfa110.predict(input);
                    switch (alt110) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_65);
                            BogusTypeRefFragmentParserRuleCall_0_1_1=ruleBogusTypeRefFragment();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((BogusTypeRefFragmentParserRuleCall_0_1_1!=null?((Token)BogusTypeRefFragmentParserRuleCall_0_1_1.start):null), (BogusTypeRefFragmentParserRuleCall_0_1_1!=null?((Token)BogusTypeRefFragmentParserRuleCall_0_1_1.stop):null), grammarAccess.getBindingElementFragmentAccess().getBogusTypeRefFragmentParserRuleCall_0_1_1()); 
                            }

                            }
                            break;

                    }
                    int alt111=2;
                    int LA111_0 = input.LA(1);

                    if ( (LA111_0==FullStopFullStopFullStop) ) {
                        alt111=1;
                    }
                    switch (alt111) {
                        case 1 :
                            {
                            {
                            VariadicFullStopFullStopFullStopKeyword_0_1_2_0=(Token)match(input,FullStopFullStopFullStop,FOLLOW_8); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(VariadicFullStopFullStopFullStopKeyword_0_1_2_0, grammarAccess.getBindingElementFragmentAccess().getVariadicFullStopFullStopFullStopKeyword_0_1_2_0());
                              					
                            }

                            }


                            }
                            break;

                    }
                    {
                    {
                    pushFollow(FOLLOW_66);
                    NameBindingIdentifierParserRuleCall_0_1_3_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((NameBindingIdentifierParserRuleCall_0_1_3_0!=null?((Token)NameBindingIdentifierParserRuleCall_0_1_3_0.start):null), (NameBindingIdentifierParserRuleCall_0_1_3_0!=null?((Token)NameBindingIdentifierParserRuleCall_0_1_3_0.stop):null), grammarAccess.getBindingElementFragmentAccess().getNameAssignment_0_1_3());
                      					
                    }

                    }


                    }
                    int alt112=2;
                    int LA112_0 = input.LA(1);

                    if ( (LA112_0==Colon) ) {
                        alt112=1;
                    }
                    switch (alt112) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_63);
                            ColonSepDeclaredTypeRefParserRuleCall_0_1_4=ruleColonSepDeclaredTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ColonSepDeclaredTypeRefParserRuleCall_0_1_4!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_0_1_4.start):null), (ColonSepDeclaredTypeRefParserRuleCall_0_1_4!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_0_1_4.stop):null), grammarAccess.getBindingElementFragmentAccess().getColonSepDeclaredTypeRefParserRuleCall_0_1_4()); 
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;

            }
            int alt115=2;
            int LA115_0 = input.LA(1);

            if ( (LA115_0==EqualsSign) ) {
                alt115=1;
            }
            switch (alt115) {
                case 1 :
                    {
                    {
                    {
                    HasInitializerAssignmentEqualsSignKeyword_1_0_0=(Token)match(input,EqualsSign,FOLLOW_67); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce(HasInitializerAssignmentEqualsSignKeyword_1_0_0, grammarAccess.getBindingElementFragmentAccess().getHasInitializerAssignmentEqualsSignKeyword_1_0_0());
                      				
                    }

                    }


                    }
                    int alt114=2;
                    int LA114_0 = input.LA(1);

                    if ( ((LA114_0>=Intersection && LA114_0<=Implements)||(LA114_0>=Promisify && LA114_0<=Abstract)||(LA114_0>=External && LA114_0<=Function)||(LA114_0>=Private && LA114_0<=Delete)||(LA114_0>=Import && LA114_0<=Public)||LA114_0==Static||(LA114_0>=Target && LA114_0<=Await)||LA114_0==Class||(LA114_0>=False && LA114_0<=Super)||LA114_0==Union||(LA114_0>=Yield && LA114_0<=This)||(LA114_0>=From && LA114_0<=Void)||(LA114_0>=Get && LA114_0<=Set)||LA114_0==PlusSignPlusSign||LA114_0==HyphenMinusHyphenMinus||LA114_0==SolidusEqualsSign||LA114_0==As||LA114_0==Of||LA114_0==ExclamationMark||LA114_0==LeftParenthesis||LA114_0==PlusSign||LA114_0==HyphenMinus||LA114_0==Solidus||LA114_0==LessThanSign||(LA114_0>=CommercialAt && LA114_0<=LeftSquareBracket)||LA114_0==LeftCurlyBracket||LA114_0==Tilde||LA114_0==RULE_DOUBLE||(LA114_0>=RULE_HEX_INT && LA114_0<=RULE_LEGACY_OCTAL_INT)||LA114_0==RULE_SCIENTIFIC_INT||LA114_0==RULE_IDENTIFIER||LA114_0==RULE_STRING||(LA114_0>=RULE_TEMPLATE_HEAD && LA114_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA114_0==RULE_INT) ) {
                        alt114=1;
                    }
                    switch (alt114) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_2);
                            InitializerAssignmentExpressionParserRuleCall_1_1_0=norm1_AssignmentExpression();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              					announce((InitializerAssignmentExpressionParserRuleCall_1_1_0!=null?((Token)InitializerAssignmentExpressionParserRuleCall_1_1_0.start):null), (InitializerAssignmentExpressionParserRuleCall_1_1_0!=null?((Token)InitializerAssignmentExpressionParserRuleCall_1_1_0.stop):null), grammarAccess.getBindingElementFragmentAccess().getInitializerAssignment_1_1());
                              				
                            }

                            }


                            }
                            break;

                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_BindingElementFragment_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_BindingElementFragment_return norm1_BindingElementFragment() throws RecognitionException {
        InternalN4JSParser.norm1_BindingElementFragment_return retval = new InternalN4JSParser.norm1_BindingElementFragment_return();
        retval.start = input.LT(1);

        Token VariadicFullStopFullStopFullStopKeyword_0_1_2_0=null;
        Token HasInitializerAssignmentEqualsSignKeyword_1_0_0=null;
        InternalN4JSParser.norm1_BindingPattern_return BindingPatternBindingPatternParserRuleCall_0_0_0 = null;

        InternalN4JSParser.ruleAnnotation_return AnnotationsAnnotationParserRuleCall_0_1_0_0 = null;

        InternalN4JSParser.ruleBogusTypeRefFragment_return BogusTypeRefFragmentParserRuleCall_0_1_1 = null;

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_0_1_3_0 = null;

        InternalN4JSParser.ruleColonSepDeclaredTypeRef_return ColonSepDeclaredTypeRefParserRuleCall_0_1_4 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return InitializerAssignmentExpressionParserRuleCall_1_1_0 = null;




        try {
            {
            {
            int alt120=2;
            alt120 = dfa120.predict(input);
            switch (alt120) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_63);
                    BindingPatternBindingPatternParserRuleCall_0_0_0=norm1_BindingPattern();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((BindingPatternBindingPatternParserRuleCall_0_0_0!=null?((Token)BindingPatternBindingPatternParserRuleCall_0_0_0.start):null), (BindingPatternBindingPatternParserRuleCall_0_0_0!=null?((Token)BindingPatternBindingPatternParserRuleCall_0_0_0.stop):null), grammarAccess.getBindingElementFragmentAccess().getBindingPatternAssignment_0_0());
                      				
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    loop116:
                    do {
                        int alt116=2;
                        int LA116_0 = input.LA(1);

                        if ( (LA116_0==CommercialAt) ) {
                            alt116=1;
                        }


                        switch (alt116) {
                    	case 1 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_64);
                    	    AnnotationsAnnotationParserRuleCall_0_1_0_0=ruleAnnotation();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      						announce((AnnotationsAnnotationParserRuleCall_0_1_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_1_0_0.start):null), (AnnotationsAnnotationParserRuleCall_0_1_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_1_0_0.stop):null), grammarAccess.getBindingElementFragmentAccess().getAnnotationsAssignment_0_1_0());
                    	      					
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop116;
                        }
                    } while (true);
                    int alt117=2;
                    alt117 = dfa117.predict(input);
                    switch (alt117) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_65);
                            BogusTypeRefFragmentParserRuleCall_0_1_1=ruleBogusTypeRefFragment();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((BogusTypeRefFragmentParserRuleCall_0_1_1!=null?((Token)BogusTypeRefFragmentParserRuleCall_0_1_1.start):null), (BogusTypeRefFragmentParserRuleCall_0_1_1!=null?((Token)BogusTypeRefFragmentParserRuleCall_0_1_1.stop):null), grammarAccess.getBindingElementFragmentAccess().getBogusTypeRefFragmentParserRuleCall_0_1_1()); 
                            }

                            }
                            break;

                    }
                    int alt118=2;
                    int LA118_0 = input.LA(1);

                    if ( (LA118_0==FullStopFullStopFullStop) ) {
                        alt118=1;
                    }
                    switch (alt118) {
                        case 1 :
                            {
                            {
                            VariadicFullStopFullStopFullStopKeyword_0_1_2_0=(Token)match(input,FullStopFullStopFullStop,FOLLOW_8); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(VariadicFullStopFullStopFullStopKeyword_0_1_2_0, grammarAccess.getBindingElementFragmentAccess().getVariadicFullStopFullStopFullStopKeyword_0_1_2_0());
                              					
                            }

                            }


                            }
                            break;

                    }
                    {
                    {
                    pushFollow(FOLLOW_66);
                    NameBindingIdentifierParserRuleCall_0_1_3_0=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((NameBindingIdentifierParserRuleCall_0_1_3_0!=null?((Token)NameBindingIdentifierParserRuleCall_0_1_3_0.start):null), (NameBindingIdentifierParserRuleCall_0_1_3_0!=null?((Token)NameBindingIdentifierParserRuleCall_0_1_3_0.stop):null), grammarAccess.getBindingElementFragmentAccess().getNameAssignment_0_1_3());
                      					
                    }

                    }


                    }
                    int alt119=2;
                    int LA119_0 = input.LA(1);

                    if ( (LA119_0==Colon) ) {
                        alt119=1;
                    }
                    switch (alt119) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_63);
                            ColonSepDeclaredTypeRefParserRuleCall_0_1_4=ruleColonSepDeclaredTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((ColonSepDeclaredTypeRefParserRuleCall_0_1_4!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_0_1_4.start):null), (ColonSepDeclaredTypeRefParserRuleCall_0_1_4!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_0_1_4.stop):null), grammarAccess.getBindingElementFragmentAccess().getColonSepDeclaredTypeRefParserRuleCall_0_1_4()); 
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;

            }
            int alt122=2;
            int LA122_0 = input.LA(1);

            if ( (LA122_0==EqualsSign) ) {
                alt122=1;
            }
            switch (alt122) {
                case 1 :
                    {
                    {
                    {
                    HasInitializerAssignmentEqualsSignKeyword_1_0_0=(Token)match(input,EqualsSign,FOLLOW_68); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce(HasInitializerAssignmentEqualsSignKeyword_1_0_0, grammarAccess.getBindingElementFragmentAccess().getHasInitializerAssignmentEqualsSignKeyword_1_0_0());
                      				
                    }

                    }


                    }
                    int alt121=2;
                    int LA121_0 = input.LA(1);

                    if ( ((LA121_0>=Intersection && LA121_0<=Implements)||(LA121_0>=Promisify && LA121_0<=Abstract)||(LA121_0>=External && LA121_0<=Function)||(LA121_0>=Private && LA121_0<=Delete)||(LA121_0>=Import && LA121_0<=Public)||LA121_0==Static||(LA121_0>=Target && LA121_0<=Await)||LA121_0==Class||(LA121_0>=False && LA121_0<=Super)||LA121_0==Union||(LA121_0>=Yield && LA121_0<=This)||(LA121_0>=From && LA121_0<=Void)||(LA121_0>=Get && LA121_0<=Set)||LA121_0==PlusSignPlusSign||LA121_0==HyphenMinusHyphenMinus||LA121_0==SolidusEqualsSign||LA121_0==As||LA121_0==Of||LA121_0==ExclamationMark||LA121_0==LeftParenthesis||LA121_0==PlusSign||LA121_0==HyphenMinus||LA121_0==Solidus||LA121_0==LessThanSign||(LA121_0>=CommercialAt && LA121_0<=LeftSquareBracket)||LA121_0==LeftCurlyBracket||LA121_0==Tilde||LA121_0==RULE_DOUBLE||(LA121_0>=RULE_HEX_INT && LA121_0<=RULE_LEGACY_OCTAL_INT)||LA121_0==RULE_SCIENTIFIC_INT||LA121_0==RULE_IDENTIFIER||LA121_0==RULE_STRING||(LA121_0>=RULE_TEMPLATE_HEAD && LA121_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA121_0==RULE_INT) ) {
                        alt121=1;
                    }
                    switch (alt121) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_2);
                            InitializerAssignmentExpressionParserRuleCall_1_1_0=norm3_AssignmentExpression();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              					announce((InitializerAssignmentExpressionParserRuleCall_1_1_0!=null?((Token)InitializerAssignmentExpressionParserRuleCall_1_1_0.start):null), (InitializerAssignmentExpressionParserRuleCall_1_1_0!=null?((Token)InitializerAssignmentExpressionParserRuleCall_1_1_0.stop):null), grammarAccess.getBindingElementFragmentAccess().getInitializerAssignment_1_1());
                              				
                            }

                            }


                            }
                            break;

                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleBogusTypeRefFragment_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleBogusTypeRefFragment_return ruleBogusTypeRefFragment() throws RecognitionException {
        InternalN4JSParser.ruleBogusTypeRefFragment_return retval = new InternalN4JSParser.ruleBogusTypeRefFragment_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleTypeRefWithModifiers_return BogusTypeRefTypeRefWithModifiersParserRuleCall_0 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_2);
            BogusTypeRefTypeRefWithModifiersParserRuleCall_0=ruleTypeRefWithModifiers();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce((BogusTypeRefTypeRefWithModifiersParserRuleCall_0!=null?((Token)BogusTypeRefTypeRefWithModifiersParserRuleCall_0.start):null), (BogusTypeRefTypeRefWithModifiersParserRuleCall_0!=null?((Token)BogusTypeRefTypeRefWithModifiersParserRuleCall_0.stop):null), grammarAccess.getBogusTypeRefFragmentAccess().getBogusTypeRefAssignment());
              		
            }

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleBlock() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleBlock();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleBlock_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleBlock_return ruleBlock() throws RecognitionException {
        InternalN4JSParser.ruleBlock_return retval = new InternalN4JSParser.ruleBlock_return();
        retval.start = input.LT(1);

        Token LeftCurlyBracketKeyword_0_0_1=null;
        Token RightCurlyBracketKeyword_2=null;
        InternalN4JSParser.ruleStatement_return StatementsStatementParserRuleCall_1_0 = null;




        try {
            {
            {
            {
            {
            LeftCurlyBracketKeyword_0_0_1=(Token)match(input,LeftCurlyBracket,FOLLOW_50); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(LeftCurlyBracketKeyword_0_0_1, grammarAccess.getBlockAccess().getLeftCurlyBracketKeyword_0_0_1());
              			
            }

            }


            }
            loop123:
            do {
                int alt123=2;
                int LA123_0 = input.LA(1);

                if ( ((LA123_0>=Intersection && LA123_0<=Implements)||(LA123_0>=Promisify && LA123_0<=Function)||(LA123_0>=Private && LA123_0<=Delete)||(LA123_0>=Import && LA123_0<=Break)||(LA123_0>=Class && LA123_0<=This)||(LA123_0>=From && LA123_0<=With)||(LA123_0>=For && LA123_0<=Var)||LA123_0==PlusSignPlusSign||LA123_0==HyphenMinusHyphenMinus||LA123_0==SolidusEqualsSign||(LA123_0>=As && LA123_0<=If)||LA123_0==Of||LA123_0==ExclamationMark||LA123_0==LeftParenthesis||LA123_0==PlusSign||LA123_0==HyphenMinus||LA123_0==Solidus||(LA123_0>=Semicolon && LA123_0<=LessThanSign)||(LA123_0>=CommercialAt && LA123_0<=LeftSquareBracket)||LA123_0==LeftCurlyBracket||LA123_0==Tilde||LA123_0==RULE_DOUBLE||(LA123_0>=RULE_HEX_INT && LA123_0<=RULE_LEGACY_OCTAL_INT)||LA123_0==RULE_SCIENTIFIC_INT||LA123_0==RULE_IDENTIFIER||LA123_0==RULE_STRING||(LA123_0>=RULE_TEMPLATE_HEAD && LA123_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA123_0==RULE_INT) ) {
                    alt123=1;
                }


                switch (alt123) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_50);
            	    StatementsStatementParserRuleCall_1_0=ruleStatement();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((StatementsStatementParserRuleCall_1_0!=null?((Token)StatementsStatementParserRuleCall_1_0.start):null), (StatementsStatementParserRuleCall_1_0!=null?((Token)StatementsStatementParserRuleCall_1_0.stop):null), grammarAccess.getBlockAccess().getStatementsAssignment_1());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop123;
                }
            } while (true);

            RightCurlyBracketKeyword_2=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightCurlyBracketKeyword_2, grammarAccess.getBlockAccess().getRightCurlyBracketKeyword_2());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_Block_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_Block_return norm1_Block() throws RecognitionException {
        InternalN4JSParser.norm1_Block_return retval = new InternalN4JSParser.norm1_Block_return();
        retval.start = input.LT(1);

        Token LeftCurlyBracketKeyword_0_0_1=null;
        Token RightCurlyBracketKeyword_2=null;
        InternalN4JSParser.norm1_Statement_return StatementsStatementParserRuleCall_1_0 = null;




        try {
            {
            {
            {
            {
            LeftCurlyBracketKeyword_0_0_1=(Token)match(input,LeftCurlyBracket,FOLLOW_52); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(LeftCurlyBracketKeyword_0_0_1, grammarAccess.getBlockAccess().getLeftCurlyBracketKeyword_0_0_1());
              			
            }

            }


            }
            loop124:
            do {
                int alt124=2;
                int LA124_0 = input.LA(1);

                if ( ((LA124_0>=Intersection && LA124_0<=Implements)||(LA124_0>=Promisify && LA124_0<=Function)||(LA124_0>=Private && LA124_0<=Delete)||(LA124_0>=Import && LA124_0<=Break)||(LA124_0>=Class && LA124_0<=This)||(LA124_0>=From && LA124_0<=With)||(LA124_0>=For && LA124_0<=Var)||LA124_0==PlusSignPlusSign||LA124_0==HyphenMinusHyphenMinus||LA124_0==SolidusEqualsSign||(LA124_0>=As && LA124_0<=If)||LA124_0==Of||LA124_0==ExclamationMark||LA124_0==LeftParenthesis||LA124_0==PlusSign||LA124_0==HyphenMinus||LA124_0==Solidus||(LA124_0>=Semicolon && LA124_0<=LessThanSign)||(LA124_0>=CommercialAt && LA124_0<=LeftSquareBracket)||LA124_0==LeftCurlyBracket||LA124_0==Tilde||LA124_0==RULE_DOUBLE||(LA124_0>=RULE_HEX_INT && LA124_0<=RULE_LEGACY_OCTAL_INT)||LA124_0==RULE_SCIENTIFIC_INT||LA124_0==RULE_IDENTIFIER||LA124_0==RULE_STRING||(LA124_0>=RULE_TEMPLATE_HEAD && LA124_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA124_0==RULE_INT) ) {
                    alt124=1;
                }


                switch (alt124) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_52);
            	    StatementsStatementParserRuleCall_1_0=norm1_Statement();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((StatementsStatementParserRuleCall_1_0!=null?((Token)StatementsStatementParserRuleCall_1_0.start):null), (StatementsStatementParserRuleCall_1_0!=null?((Token)StatementsStatementParserRuleCall_1_0.stop):null), grammarAccess.getBlockAccess().getStatementsAssignment_1());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop124;
                }
            } while (true);

            RightCurlyBracketKeyword_2=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightCurlyBracketKeyword_2, grammarAccess.getBlockAccess().getRightCurlyBracketKeyword_2());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleRootStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleRootStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleRootStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleRootStatement_return ruleRootStatement() throws RecognitionException {
        InternalN4JSParser.ruleRootStatement_return retval = new InternalN4JSParser.ruleRootStatement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleBlock_return BlockParserRuleCall_0 = null;

        InternalN4JSParser.ruleFunctionDeclaration_return FunctionDeclarationParserRuleCall_1 = null;

        InternalN4JSParser.norm1_VariableStatement_return VariableStatementParserRuleCall_2 = null;

        InternalN4JSParser.ruleEmptyStatement_return EmptyStatementParserRuleCall_3 = null;

        InternalN4JSParser.ruleLabelledStatement_return LabelledStatementParserRuleCall_4 = null;

        InternalN4JSParser.ruleExpressionStatement_return ExpressionStatementParserRuleCall_5 = null;

        InternalN4JSParser.ruleIfStatement_return IfStatementParserRuleCall_6 = null;

        InternalN4JSParser.ruleIterationStatement_return IterationStatementParserRuleCall_7 = null;

        InternalN4JSParser.ruleContinueStatement_return ContinueStatementParserRuleCall_8 = null;

        InternalN4JSParser.ruleBreakStatement_return BreakStatementParserRuleCall_9 = null;

        InternalN4JSParser.ruleReturnStatement_return ReturnStatementParserRuleCall_10 = null;

        InternalN4JSParser.ruleWithStatement_return WithStatementParserRuleCall_11 = null;

        InternalN4JSParser.ruleSwitchStatement_return SwitchStatementParserRuleCall_12 = null;

        InternalN4JSParser.ruleThrowStatement_return ThrowStatementParserRuleCall_13 = null;

        InternalN4JSParser.ruleTryStatement_return TryStatementParserRuleCall_14 = null;

        InternalN4JSParser.ruleDebuggerStatement_return DebuggerStatementParserRuleCall_15 = null;




        try {
            {
            int alt125=16;
            alt125 = dfa125.predict(input);
            switch (alt125) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BlockParserRuleCall_0=ruleBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((BlockParserRuleCall_0!=null?((Token)BlockParserRuleCall_0.start):null), (BlockParserRuleCall_0!=null?((Token)BlockParserRuleCall_0.stop):null), grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    FunctionDeclarationParserRuleCall_1=ruleFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionDeclarationParserRuleCall_1!=null?((Token)FunctionDeclarationParserRuleCall_1.start):null), (FunctionDeclarationParserRuleCall_1!=null?((Token)FunctionDeclarationParserRuleCall_1.stop):null), grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    VariableStatementParserRuleCall_2=norm1_VariableStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableStatementParserRuleCall_2!=null?((Token)VariableStatementParserRuleCall_2.start):null), (VariableStatementParserRuleCall_2!=null?((Token)VariableStatementParserRuleCall_2.stop):null), grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    pushFollow(FOLLOW_2);
                    EmptyStatementParserRuleCall_3=ruleEmptyStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((EmptyStatementParserRuleCall_3!=null?((Token)EmptyStatementParserRuleCall_3.start):null), (EmptyStatementParserRuleCall_3!=null?((Token)EmptyStatementParserRuleCall_3.stop):null), grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3()); 
                    }

                    }
                    break;
                case 5 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    LabelledStatementParserRuleCall_4=ruleLabelledStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((LabelledStatementParserRuleCall_4!=null?((Token)LabelledStatementParserRuleCall_4.start):null), (LabelledStatementParserRuleCall_4!=null?((Token)LabelledStatementParserRuleCall_4.stop):null), grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionStatementParserRuleCall_5=ruleExpressionStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ExpressionStatementParserRuleCall_5!=null?((Token)ExpressionStatementParserRuleCall_5.start):null), (ExpressionStatementParserRuleCall_5!=null?((Token)ExpressionStatementParserRuleCall_5.stop):null), grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5()); 
                    }

                    }
                    break;
                case 7 :
                    {
                    pushFollow(FOLLOW_2);
                    IfStatementParserRuleCall_6=ruleIfStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((IfStatementParserRuleCall_6!=null?((Token)IfStatementParserRuleCall_6.start):null), (IfStatementParserRuleCall_6!=null?((Token)IfStatementParserRuleCall_6.stop):null), grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6()); 
                    }

                    }
                    break;
                case 8 :
                    {
                    pushFollow(FOLLOW_2);
                    IterationStatementParserRuleCall_7=ruleIterationStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((IterationStatementParserRuleCall_7!=null?((Token)IterationStatementParserRuleCall_7.start):null), (IterationStatementParserRuleCall_7!=null?((Token)IterationStatementParserRuleCall_7.stop):null), grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7()); 
                    }

                    }
                    break;
                case 9 :
                    {
                    pushFollow(FOLLOW_2);
                    ContinueStatementParserRuleCall_8=ruleContinueStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ContinueStatementParserRuleCall_8!=null?((Token)ContinueStatementParserRuleCall_8.start):null), (ContinueStatementParserRuleCall_8!=null?((Token)ContinueStatementParserRuleCall_8.stop):null), grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8()); 
                    }

                    }
                    break;
                case 10 :
                    {
                    pushFollow(FOLLOW_2);
                    BreakStatementParserRuleCall_9=ruleBreakStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((BreakStatementParserRuleCall_9!=null?((Token)BreakStatementParserRuleCall_9.start):null), (BreakStatementParserRuleCall_9!=null?((Token)BreakStatementParserRuleCall_9.stop):null), grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9()); 
                    }

                    }
                    break;
                case 11 :
                    {
                    pushFollow(FOLLOW_2);
                    ReturnStatementParserRuleCall_10=ruleReturnStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ReturnStatementParserRuleCall_10!=null?((Token)ReturnStatementParserRuleCall_10.start):null), (ReturnStatementParserRuleCall_10!=null?((Token)ReturnStatementParserRuleCall_10.stop):null), grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10()); 
                    }

                    }
                    break;
                case 12 :
                    {
                    pushFollow(FOLLOW_2);
                    WithStatementParserRuleCall_11=ruleWithStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((WithStatementParserRuleCall_11!=null?((Token)WithStatementParserRuleCall_11.start):null), (WithStatementParserRuleCall_11!=null?((Token)WithStatementParserRuleCall_11.stop):null), grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11()); 
                    }

                    }
                    break;
                case 13 :
                    {
                    pushFollow(FOLLOW_2);
                    SwitchStatementParserRuleCall_12=ruleSwitchStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((SwitchStatementParserRuleCall_12!=null?((Token)SwitchStatementParserRuleCall_12.start):null), (SwitchStatementParserRuleCall_12!=null?((Token)SwitchStatementParserRuleCall_12.stop):null), grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12()); 
                    }

                    }
                    break;
                case 14 :
                    {
                    pushFollow(FOLLOW_2);
                    ThrowStatementParserRuleCall_13=ruleThrowStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ThrowStatementParserRuleCall_13!=null?((Token)ThrowStatementParserRuleCall_13.start):null), (ThrowStatementParserRuleCall_13!=null?((Token)ThrowStatementParserRuleCall_13.stop):null), grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13()); 
                    }

                    }
                    break;
                case 15 :
                    {
                    pushFollow(FOLLOW_2);
                    TryStatementParserRuleCall_14=ruleTryStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((TryStatementParserRuleCall_14!=null?((Token)TryStatementParserRuleCall_14.start):null), (TryStatementParserRuleCall_14!=null?((Token)TryStatementParserRuleCall_14.stop):null), grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14()); 
                    }

                    }
                    break;
                case 16 :
                    {
                    pushFollow(FOLLOW_2);
                    DebuggerStatementParserRuleCall_15=ruleDebuggerStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((DebuggerStatementParserRuleCall_15!=null?((Token)DebuggerStatementParserRuleCall_15.start):null), (DebuggerStatementParserRuleCall_15!=null?((Token)DebuggerStatementParserRuleCall_15.stop):null), grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_RootStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_RootStatement_return norm1_RootStatement() throws RecognitionException {
        InternalN4JSParser.norm1_RootStatement_return retval = new InternalN4JSParser.norm1_RootStatement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_Block_return BlockParserRuleCall_0 = null;

        InternalN4JSParser.norm1_FunctionDeclaration_return FunctionDeclarationParserRuleCall_1 = null;

        InternalN4JSParser.norm3_VariableStatement_return VariableStatementParserRuleCall_2 = null;

        InternalN4JSParser.ruleEmptyStatement_return EmptyStatementParserRuleCall_3 = null;

        InternalN4JSParser.norm1_LabelledStatement_return LabelledStatementParserRuleCall_4 = null;

        InternalN4JSParser.norm1_ExpressionStatement_return ExpressionStatementParserRuleCall_5 = null;

        InternalN4JSParser.norm1_IfStatement_return IfStatementParserRuleCall_6 = null;

        InternalN4JSParser.norm1_IterationStatement_return IterationStatementParserRuleCall_7 = null;

        InternalN4JSParser.norm1_ContinueStatement_return ContinueStatementParserRuleCall_8 = null;

        InternalN4JSParser.norm1_BreakStatement_return BreakStatementParserRuleCall_9 = null;

        InternalN4JSParser.norm1_ReturnStatement_return ReturnStatementParserRuleCall_10 = null;

        InternalN4JSParser.norm1_WithStatement_return WithStatementParserRuleCall_11 = null;

        InternalN4JSParser.norm1_SwitchStatement_return SwitchStatementParserRuleCall_12 = null;

        InternalN4JSParser.norm1_ThrowStatement_return ThrowStatementParserRuleCall_13 = null;

        InternalN4JSParser.norm1_TryStatement_return TryStatementParserRuleCall_14 = null;

        InternalN4JSParser.ruleDebuggerStatement_return DebuggerStatementParserRuleCall_15 = null;




        try {
            {
            int alt126=16;
            alt126 = dfa126.predict(input);
            switch (alt126) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BlockParserRuleCall_0=norm1_Block();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((BlockParserRuleCall_0!=null?((Token)BlockParserRuleCall_0.start):null), (BlockParserRuleCall_0!=null?((Token)BlockParserRuleCall_0.stop):null), grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    FunctionDeclarationParserRuleCall_1=norm1_FunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionDeclarationParserRuleCall_1!=null?((Token)FunctionDeclarationParserRuleCall_1.start):null), (FunctionDeclarationParserRuleCall_1!=null?((Token)FunctionDeclarationParserRuleCall_1.stop):null), grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    VariableStatementParserRuleCall_2=norm3_VariableStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableStatementParserRuleCall_2!=null?((Token)VariableStatementParserRuleCall_2.start):null), (VariableStatementParserRuleCall_2!=null?((Token)VariableStatementParserRuleCall_2.stop):null), grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    pushFollow(FOLLOW_2);
                    EmptyStatementParserRuleCall_3=ruleEmptyStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((EmptyStatementParserRuleCall_3!=null?((Token)EmptyStatementParserRuleCall_3.start):null), (EmptyStatementParserRuleCall_3!=null?((Token)EmptyStatementParserRuleCall_3.stop):null), grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3()); 
                    }

                    }
                    break;
                case 5 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    LabelledStatementParserRuleCall_4=norm1_LabelledStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((LabelledStatementParserRuleCall_4!=null?((Token)LabelledStatementParserRuleCall_4.start):null), (LabelledStatementParserRuleCall_4!=null?((Token)LabelledStatementParserRuleCall_4.stop):null), grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionStatementParserRuleCall_5=norm1_ExpressionStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ExpressionStatementParserRuleCall_5!=null?((Token)ExpressionStatementParserRuleCall_5.start):null), (ExpressionStatementParserRuleCall_5!=null?((Token)ExpressionStatementParserRuleCall_5.stop):null), grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5()); 
                    }

                    }
                    break;
                case 7 :
                    {
                    pushFollow(FOLLOW_2);
                    IfStatementParserRuleCall_6=norm1_IfStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((IfStatementParserRuleCall_6!=null?((Token)IfStatementParserRuleCall_6.start):null), (IfStatementParserRuleCall_6!=null?((Token)IfStatementParserRuleCall_6.stop):null), grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6()); 
                    }

                    }
                    break;
                case 8 :
                    {
                    pushFollow(FOLLOW_2);
                    IterationStatementParserRuleCall_7=norm1_IterationStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((IterationStatementParserRuleCall_7!=null?((Token)IterationStatementParserRuleCall_7.start):null), (IterationStatementParserRuleCall_7!=null?((Token)IterationStatementParserRuleCall_7.stop):null), grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7()); 
                    }

                    }
                    break;
                case 9 :
                    {
                    pushFollow(FOLLOW_2);
                    ContinueStatementParserRuleCall_8=norm1_ContinueStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ContinueStatementParserRuleCall_8!=null?((Token)ContinueStatementParserRuleCall_8.start):null), (ContinueStatementParserRuleCall_8!=null?((Token)ContinueStatementParserRuleCall_8.stop):null), grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8()); 
                    }

                    }
                    break;
                case 10 :
                    {
                    pushFollow(FOLLOW_2);
                    BreakStatementParserRuleCall_9=norm1_BreakStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((BreakStatementParserRuleCall_9!=null?((Token)BreakStatementParserRuleCall_9.start):null), (BreakStatementParserRuleCall_9!=null?((Token)BreakStatementParserRuleCall_9.stop):null), grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9()); 
                    }

                    }
                    break;
                case 11 :
                    {
                    pushFollow(FOLLOW_2);
                    ReturnStatementParserRuleCall_10=norm1_ReturnStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ReturnStatementParserRuleCall_10!=null?((Token)ReturnStatementParserRuleCall_10.start):null), (ReturnStatementParserRuleCall_10!=null?((Token)ReturnStatementParserRuleCall_10.stop):null), grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10()); 
                    }

                    }
                    break;
                case 12 :
                    {
                    pushFollow(FOLLOW_2);
                    WithStatementParserRuleCall_11=norm1_WithStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((WithStatementParserRuleCall_11!=null?((Token)WithStatementParserRuleCall_11.start):null), (WithStatementParserRuleCall_11!=null?((Token)WithStatementParserRuleCall_11.stop):null), grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11()); 
                    }

                    }
                    break;
                case 13 :
                    {
                    pushFollow(FOLLOW_2);
                    SwitchStatementParserRuleCall_12=norm1_SwitchStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((SwitchStatementParserRuleCall_12!=null?((Token)SwitchStatementParserRuleCall_12.start):null), (SwitchStatementParserRuleCall_12!=null?((Token)SwitchStatementParserRuleCall_12.stop):null), grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12()); 
                    }

                    }
                    break;
                case 14 :
                    {
                    pushFollow(FOLLOW_2);
                    ThrowStatementParserRuleCall_13=norm1_ThrowStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ThrowStatementParserRuleCall_13!=null?((Token)ThrowStatementParserRuleCall_13.start):null), (ThrowStatementParserRuleCall_13!=null?((Token)ThrowStatementParserRuleCall_13.stop):null), grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13()); 
                    }

                    }
                    break;
                case 15 :
                    {
                    pushFollow(FOLLOW_2);
                    TryStatementParserRuleCall_14=norm1_TryStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((TryStatementParserRuleCall_14!=null?((Token)TryStatementParserRuleCall_14.start):null), (TryStatementParserRuleCall_14!=null?((Token)TryStatementParserRuleCall_14.stop):null), grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14()); 
                    }

                    }
                    break;
                case 16 :
                    {
                    pushFollow(FOLLOW_2);
                    DebuggerStatementParserRuleCall_15=ruleDebuggerStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((DebuggerStatementParserRuleCall_15!=null?((Token)DebuggerStatementParserRuleCall_15.start):null), (DebuggerStatementParserRuleCall_15!=null?((Token)DebuggerStatementParserRuleCall_15.stop):null), grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleStatement_return ruleStatement() throws RecognitionException {
        InternalN4JSParser.ruleStatement_return retval = new InternalN4JSParser.ruleStatement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleAnnotatedFunctionDeclaration_return AnnotatedFunctionDeclarationParserRuleCall_0 = null;

        InternalN4JSParser.ruleRootStatement_return RootStatementParserRuleCall_1 = null;




        try {
            {
            int alt127=2;
            alt127 = dfa127.predict(input);
            switch (alt127) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    AnnotatedFunctionDeclarationParserRuleCall_0=ruleAnnotatedFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AnnotatedFunctionDeclarationParserRuleCall_0!=null?((Token)AnnotatedFunctionDeclarationParserRuleCall_0.start):null), (AnnotatedFunctionDeclarationParserRuleCall_0!=null?((Token)AnnotatedFunctionDeclarationParserRuleCall_0.stop):null), grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    RootStatementParserRuleCall_1=ruleRootStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((RootStatementParserRuleCall_1!=null?((Token)RootStatementParserRuleCall_1.start):null), (RootStatementParserRuleCall_1!=null?((Token)RootStatementParserRuleCall_1.stop):null), grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_Statement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_Statement_return norm1_Statement() throws RecognitionException {
        InternalN4JSParser.norm1_Statement_return retval = new InternalN4JSParser.norm1_Statement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_AnnotatedFunctionDeclaration_return AnnotatedFunctionDeclarationParserRuleCall_0 = null;

        InternalN4JSParser.norm1_RootStatement_return RootStatementParserRuleCall_1 = null;




        try {
            {
            int alt128=2;
            alt128 = dfa128.predict(input);
            switch (alt128) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    AnnotatedFunctionDeclarationParserRuleCall_0=norm1_AnnotatedFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AnnotatedFunctionDeclarationParserRuleCall_0!=null?((Token)AnnotatedFunctionDeclarationParserRuleCall_0.start):null), (AnnotatedFunctionDeclarationParserRuleCall_0!=null?((Token)AnnotatedFunctionDeclarationParserRuleCall_0.stop):null), grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    RootStatementParserRuleCall_1=norm1_RootStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((RootStatementParserRuleCall_1!=null?((Token)RootStatementParserRuleCall_1.start):null), (RootStatementParserRuleCall_1!=null?((Token)RootStatementParserRuleCall_1.stop):null), grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_VariableStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_VariableStatement_return norm1_VariableStatement() throws RecognitionException {
        InternalN4JSParser.norm1_VariableStatement_return retval = new InternalN4JSParser.norm1_VariableStatement_return();
        retval.start = input.LT(1);

        Token CommaKeyword_2_0=null;
        InternalN4JSParser.norm1_VariableDeclarationOrBinding_return VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0 = null;

        InternalN4JSParser.norm1_VariableDeclarationOrBinding_return VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_3 = null;




        try {
            {
            {
            {
            {
            {
            {
            pushFollow(FOLLOW_27);
            ruleVariableStatementKeyword();

            state._fsp--;
            if (state.failed) return retval;

            }


            }


            }


            }
            {
            {
            pushFollow(FOLLOW_28);
            VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0=norm1_VariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0.start):null), (VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0.stop):null), grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_1());
              			
            }

            }


            }
            loop129:
            do {
                int alt129=2;
                int LA129_0 = input.LA(1);

                if ( (LA129_0==Comma) ) {
                    alt129=1;
                }


                switch (alt129) {
            	case 1 :
            	    {
            	    CommaKeyword_2_0=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      			announce(CommaKeyword_2_0, grammarAccess.getVariableStatementAccess().getCommaKeyword_2_0());
            	      		
            	    }
            	    {
            	    {
            	    pushFollow(FOLLOW_28);
            	    VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0=norm1_VariableDeclarationOrBinding();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      					announce((VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0.start):null), (VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0.stop):null), grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_2_1());
            	      				
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop129;
                }
            } while (true);

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_3=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.start):null), (SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.stop):null), grammarAccess.getVariableStatementAccess().getSemiParserRuleCall_3()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm3_VariableStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm3_VariableStatement_return norm3_VariableStatement() throws RecognitionException {
        InternalN4JSParser.norm3_VariableStatement_return retval = new InternalN4JSParser.norm3_VariableStatement_return();
        retval.start = input.LT(1);

        Token CommaKeyword_2_0=null;
        InternalN4JSParser.norm3_VariableDeclarationOrBinding_return VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0 = null;

        InternalN4JSParser.norm3_VariableDeclarationOrBinding_return VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_3 = null;




        try {
            {
            {
            {
            {
            {
            {
            pushFollow(FOLLOW_27);
            ruleVariableStatementKeyword();

            state._fsp--;
            if (state.failed) return retval;

            }


            }


            }


            }
            {
            {
            pushFollow(FOLLOW_28);
            VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0=norm3_VariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0.start):null), (VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0.stop):null), grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_1());
              			
            }

            }


            }
            loop130:
            do {
                int alt130=2;
                int LA130_0 = input.LA(1);

                if ( (LA130_0==Comma) ) {
                    alt130=1;
                }


                switch (alt130) {
            	case 1 :
            	    {
            	    CommaKeyword_2_0=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      			announce(CommaKeyword_2_0, grammarAccess.getVariableStatementAccess().getCommaKeyword_2_0());
            	      		
            	    }
            	    {
            	    {
            	    pushFollow(FOLLOW_28);
            	    VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0=norm3_VariableDeclarationOrBinding();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      					announce((VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0.start):null), (VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0.stop):null), grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsAssignment_2_1());
            	      				
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop130;
                }
            } while (true);

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_3=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.start):null), (SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.stop):null), grammarAccess.getVariableStatementAccess().getSemiParserRuleCall_3()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleExportedVariableStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleExportedVariableStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleExportedVariableStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExportedVariableStatement_return ruleExportedVariableStatement() throws RecognitionException {
        InternalN4JSParser.ruleExportedVariableStatement_return retval = new InternalN4JSParser.ruleExportedVariableStatement_return();
        retval.start = input.LT(1);

        Token CommaKeyword_4_0=null;
        InternalN4JSParser.ruleExportedVariableDeclarationOrBinding_return VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_3_0 = null;

        InternalN4JSParser.ruleExportedVariableDeclarationOrBinding_return VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_4_1_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_5 = null;




        try {
            {
            {
            loop131:
            do {
                int alt131=2;
                alt131 = dfa131.predict(input);
                switch (alt131) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_26);
            	    ruleN4Modifier();

            	    state._fsp--;
            	    if (state.failed) return retval;

            	    }


            	    }
            	    break;

            	default :
            	    break loop131;
                }
            } while (true);
            {
            {
            pushFollow(FOLLOW_27);
            ruleVariableStatementKeyword();

            state._fsp--;
            if (state.failed) return retval;

            }


            }
            {
            {
            pushFollow(FOLLOW_28);
            VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_3_0=ruleExportedVariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_3_0!=null?((Token)VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_3_0.start):null), (VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_3_0!=null?((Token)VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_3_0.stop):null), grammarAccess.getExportedVariableStatementAccess().getVarDeclsOrBindingsAssignment_3());
              			
            }

            }


            }
            loop132:
            do {
                int alt132=2;
                int LA132_0 = input.LA(1);

                if ( (LA132_0==Comma) ) {
                    alt132=1;
                }


                switch (alt132) {
            	case 1 :
            	    {
            	    CommaKeyword_4_0=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      			announce(CommaKeyword_4_0, grammarAccess.getExportedVariableStatementAccess().getCommaKeyword_4_0());
            	      		
            	    }
            	    {
            	    {
            	    pushFollow(FOLLOW_28);
            	    VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_4_1_0=ruleExportedVariableDeclarationOrBinding();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      					announce((VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_4_1_0!=null?((Token)VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_4_1_0.start):null), (VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_4_1_0!=null?((Token)VarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_4_1_0.stop):null), grammarAccess.getExportedVariableStatementAccess().getVarDeclsOrBindingsAssignment_4_1());
            	      				
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop132;
                }
            } while (true);

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_5=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_5!=null?((Token)SemiParserRuleCall_5.start):null), (SemiParserRuleCall_5!=null?((Token)SemiParserRuleCall_5.stop):null), grammarAccess.getExportedVariableStatementAccess().getSemiParserRuleCall_5()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleVariableDeclarationOrBinding() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleVariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleVariableDeclarationOrBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleVariableDeclarationOrBinding_return ruleVariableDeclarationOrBinding() throws RecognitionException {
        InternalN4JSParser.ruleVariableDeclarationOrBinding_return retval = new InternalN4JSParser.ruleVariableDeclarationOrBinding_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleVariableBinding_return VariableBindingParserRuleCall_0 = null;

        InternalN4JSParser.norm4_VariableDeclaration_return VariableDeclarationParserRuleCall_1 = null;




        try {
            {
            int alt133=2;
            int LA133_0 = input.LA(1);

            if ( (LA133_0==LeftCurlyBracket) && (synpred74_InternalN4JSParser())) {
                alt133=1;
            }
            else if ( (LA133_0==LeftSquareBracket) && (synpred74_InternalN4JSParser())) {
                alt133=1;
            }
            else if ( ((LA133_0>=Intersection && LA133_0<=Implements)||(LA133_0>=Promisify && LA133_0<=Abstract)||LA133_0==External||(LA133_0>=Private && LA133_0<=Project)||LA133_0==Public||LA133_0==Static||LA133_0==Target||(LA133_0>=Async && LA133_0<=Await)||LA133_0==Union||(LA133_0>=Yield && LA133_0<=This)||LA133_0==From||LA133_0==Type||(LA133_0>=Get && LA133_0<=Let)||(LA133_0>=Out && LA133_0<=Set)||LA133_0==As||LA133_0==Of||LA133_0==CommercialAt||LA133_0==RULE_IDENTIFIER) ) {
                alt133=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 133, 0, input);

                throw nvae;
            }
            switch (alt133) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    VariableBindingParserRuleCall_0=ruleVariableBinding();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.start):null), (VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    VariableDeclarationParserRuleCall_1=norm4_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.start):null), (VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_VariableDeclarationOrBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_VariableDeclarationOrBinding_return norm1_VariableDeclarationOrBinding() throws RecognitionException {
        InternalN4JSParser.norm1_VariableDeclarationOrBinding_return retval = new InternalN4JSParser.norm1_VariableDeclarationOrBinding_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_VariableBinding_return VariableBindingParserRuleCall_0 = null;

        InternalN4JSParser.norm5_VariableDeclaration_return VariableDeclarationParserRuleCall_1 = null;




        try {
            {
            int alt134=2;
            int LA134_0 = input.LA(1);

            if ( (LA134_0==LeftCurlyBracket) && (synpred75_InternalN4JSParser())) {
                alt134=1;
            }
            else if ( (LA134_0==LeftSquareBracket) && (synpred75_InternalN4JSParser())) {
                alt134=1;
            }
            else if ( ((LA134_0>=Intersection && LA134_0<=Implements)||(LA134_0>=Promisify && LA134_0<=Abstract)||LA134_0==External||(LA134_0>=Private && LA134_0<=Project)||LA134_0==Public||LA134_0==Static||LA134_0==Target||(LA134_0>=Async && LA134_0<=Await)||LA134_0==Union||(LA134_0>=Yield && LA134_0<=This)||LA134_0==From||LA134_0==Type||(LA134_0>=Get && LA134_0<=Let)||(LA134_0>=Out && LA134_0<=Set)||LA134_0==As||LA134_0==Of||LA134_0==CommercialAt||LA134_0==RULE_IDENTIFIER) ) {
                alt134=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 134, 0, input);

                throw nvae;
            }
            switch (alt134) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    VariableBindingParserRuleCall_0=norm1_VariableBinding();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.start):null), (VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    VariableDeclarationParserRuleCall_1=norm5_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.start):null), (VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm2_VariableDeclarationOrBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm2_VariableDeclarationOrBinding_return norm2_VariableDeclarationOrBinding() throws RecognitionException {
        InternalN4JSParser.norm2_VariableDeclarationOrBinding_return retval = new InternalN4JSParser.norm2_VariableDeclarationOrBinding_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm2_VariableBinding_return VariableBindingParserRuleCall_0 = null;

        InternalN4JSParser.norm6_VariableDeclaration_return VariableDeclarationParserRuleCall_1 = null;




        try {
            {
            int alt135=2;
            int LA135_0 = input.LA(1);

            if ( (LA135_0==LeftCurlyBracket) && (synpred76_InternalN4JSParser())) {
                alt135=1;
            }
            else if ( (LA135_0==LeftSquareBracket) && (synpred76_InternalN4JSParser())) {
                alt135=1;
            }
            else if ( ((LA135_0>=Intersection && LA135_0<=Implements)||(LA135_0>=Promisify && LA135_0<=Abstract)||LA135_0==External||(LA135_0>=Private && LA135_0<=Project)||LA135_0==Public||LA135_0==Static||LA135_0==Target||(LA135_0>=Async && LA135_0<=Await)||LA135_0==Union||LA135_0==This||LA135_0==From||LA135_0==Type||(LA135_0>=Get && LA135_0<=Let)||(LA135_0>=Out && LA135_0<=Set)||LA135_0==As||LA135_0==Of||LA135_0==CommercialAt||LA135_0==RULE_IDENTIFIER) ) {
                alt135=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 135, 0, input);

                throw nvae;
            }
            switch (alt135) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    VariableBindingParserRuleCall_0=norm2_VariableBinding();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.start):null), (VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    VariableDeclarationParserRuleCall_1=norm6_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.start):null), (VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm3_VariableDeclarationOrBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm3_VariableDeclarationOrBinding_return norm3_VariableDeclarationOrBinding() throws RecognitionException {
        InternalN4JSParser.norm3_VariableDeclarationOrBinding_return retval = new InternalN4JSParser.norm3_VariableDeclarationOrBinding_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm3_VariableBinding_return VariableBindingParserRuleCall_0 = null;

        InternalN4JSParser.norm7_VariableDeclaration_return VariableDeclarationParserRuleCall_1 = null;




        try {
            {
            int alt136=2;
            int LA136_0 = input.LA(1);

            if ( (LA136_0==LeftCurlyBracket) && (synpred77_InternalN4JSParser())) {
                alt136=1;
            }
            else if ( (LA136_0==LeftSquareBracket) && (synpred77_InternalN4JSParser())) {
                alt136=1;
            }
            else if ( ((LA136_0>=Intersection && LA136_0<=Implements)||(LA136_0>=Promisify && LA136_0<=Abstract)||LA136_0==External||(LA136_0>=Private && LA136_0<=Project)||LA136_0==Public||LA136_0==Static||LA136_0==Target||(LA136_0>=Async && LA136_0<=Await)||LA136_0==Union||LA136_0==This||LA136_0==From||LA136_0==Type||(LA136_0>=Get && LA136_0<=Let)||(LA136_0>=Out && LA136_0<=Set)||LA136_0==As||LA136_0==Of||LA136_0==CommercialAt||LA136_0==RULE_IDENTIFIER) ) {
                alt136=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 136, 0, input);

                throw nvae;
            }
            switch (alt136) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    VariableBindingParserRuleCall_0=norm3_VariableBinding();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.start):null), (VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    VariableDeclarationParserRuleCall_1=norm7_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.start):null), (VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm4_VariableDeclarationOrBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm4_VariableDeclarationOrBinding_return norm4_VariableDeclarationOrBinding() throws RecognitionException {
        InternalN4JSParser.norm4_VariableDeclarationOrBinding_return retval = new InternalN4JSParser.norm4_VariableDeclarationOrBinding_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm4_VariableBinding_return VariableBindingParserRuleCall_0 = null;

        InternalN4JSParser.norm4_VariableDeclaration_return VariableDeclarationParserRuleCall_1 = null;




        try {
            {
            int alt137=2;
            int LA137_0 = input.LA(1);

            if ( (LA137_0==LeftCurlyBracket) && (synpred78_InternalN4JSParser())) {
                alt137=1;
            }
            else if ( (LA137_0==LeftSquareBracket) && (synpred78_InternalN4JSParser())) {
                alt137=1;
            }
            else if ( ((LA137_0>=Intersection && LA137_0<=Implements)||(LA137_0>=Promisify && LA137_0<=Abstract)||LA137_0==External||(LA137_0>=Private && LA137_0<=Project)||LA137_0==Public||LA137_0==Static||LA137_0==Target||(LA137_0>=Async && LA137_0<=Await)||LA137_0==Union||(LA137_0>=Yield && LA137_0<=This)||LA137_0==From||LA137_0==Type||(LA137_0>=Get && LA137_0<=Let)||(LA137_0>=Out && LA137_0<=Set)||LA137_0==As||LA137_0==Of||LA137_0==CommercialAt||LA137_0==RULE_IDENTIFIER) ) {
                alt137=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 137, 0, input);

                throw nvae;
            }
            switch (alt137) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    VariableBindingParserRuleCall_0=norm4_VariableBinding();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.start):null), (VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    VariableDeclarationParserRuleCall_1=norm4_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.start):null), (VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm6_VariableDeclarationOrBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm6_VariableDeclarationOrBinding_return norm6_VariableDeclarationOrBinding() throws RecognitionException {
        InternalN4JSParser.norm6_VariableDeclarationOrBinding_return retval = new InternalN4JSParser.norm6_VariableDeclarationOrBinding_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm6_VariableBinding_return VariableBindingParserRuleCall_0 = null;

        InternalN4JSParser.norm6_VariableDeclaration_return VariableDeclarationParserRuleCall_1 = null;




        try {
            {
            int alt138=2;
            int LA138_0 = input.LA(1);

            if ( (LA138_0==LeftCurlyBracket) && (synpred79_InternalN4JSParser())) {
                alt138=1;
            }
            else if ( (LA138_0==LeftSquareBracket) && (synpred79_InternalN4JSParser())) {
                alt138=1;
            }
            else if ( ((LA138_0>=Intersection && LA138_0<=Implements)||(LA138_0>=Promisify && LA138_0<=Abstract)||LA138_0==External||(LA138_0>=Private && LA138_0<=Project)||LA138_0==Public||LA138_0==Static||LA138_0==Target||(LA138_0>=Async && LA138_0<=Await)||LA138_0==Union||LA138_0==This||LA138_0==From||LA138_0==Type||(LA138_0>=Get && LA138_0<=Let)||(LA138_0>=Out && LA138_0<=Set)||LA138_0==As||LA138_0==Of||LA138_0==CommercialAt||LA138_0==RULE_IDENTIFIER) ) {
                alt138=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 138, 0, input);

                throw nvae;
            }
            switch (alt138) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    VariableBindingParserRuleCall_0=norm6_VariableBinding();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.start):null), (VariableBindingParserRuleCall_0!=null?((Token)VariableBindingParserRuleCall_0.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    VariableDeclarationParserRuleCall_1=norm6_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.start):null), (VariableDeclarationParserRuleCall_1!=null?((Token)VariableDeclarationParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleVariableBinding() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleVariableBinding();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleVariableBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleVariableBinding_return ruleVariableBinding() throws RecognitionException {
        InternalN4JSParser.ruleVariableBinding_return retval = new InternalN4JSParser.ruleVariableBinding_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_1_0=null;
        InternalN4JSParser.ruleBindingPattern_return PatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleAssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_1_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_69);
            PatternBindingPatternParserRuleCall_0_0=ruleBindingPattern();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.start):null), (PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getVariableBindingAccess().getPatternAssignment_0());
              			
            }

            }


            }
            {
            EqualsSignKeyword_1_1_0=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce(EqualsSignKeyword_1_1_0, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0());
              		
            }
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_1_1_1_0=ruleAssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              					announce((ExpressionAssignmentExpressionParserRuleCall_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_0.stop):null), grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1());
              				
            }

            }


            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_VariableBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_VariableBinding_return norm1_VariableBinding() throws RecognitionException {
        InternalN4JSParser.norm1_VariableBinding_return retval = new InternalN4JSParser.norm1_VariableBinding_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_1_0=null;
        InternalN4JSParser.ruleBindingPattern_return PatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_1_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_69);
            PatternBindingPatternParserRuleCall_0_0=ruleBindingPattern();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.start):null), (PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getVariableBindingAccess().getPatternAssignment_0());
              			
            }

            }


            }
            {
            EqualsSignKeyword_1_1_0=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce(EqualsSignKeyword_1_1_0, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0());
              		
            }
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_1_1_1_0=norm1_AssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              					announce((ExpressionAssignmentExpressionParserRuleCall_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_0.stop):null), grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1());
              				
            }

            }


            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm2_VariableBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm2_VariableBinding_return norm2_VariableBinding() throws RecognitionException {
        InternalN4JSParser.norm2_VariableBinding_return retval = new InternalN4JSParser.norm2_VariableBinding_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_1_0=null;
        InternalN4JSParser.norm1_BindingPattern_return PatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.norm2_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_1_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_69);
            PatternBindingPatternParserRuleCall_0_0=norm1_BindingPattern();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.start):null), (PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getVariableBindingAccess().getPatternAssignment_0());
              			
            }

            }


            }
            {
            EqualsSignKeyword_1_1_0=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce(EqualsSignKeyword_1_1_0, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0());
              		
            }
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_1_1_1_0=norm2_AssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              					announce((ExpressionAssignmentExpressionParserRuleCall_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_0.stop):null), grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1());
              				
            }

            }


            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm3_VariableBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm3_VariableBinding_return norm3_VariableBinding() throws RecognitionException {
        InternalN4JSParser.norm3_VariableBinding_return retval = new InternalN4JSParser.norm3_VariableBinding_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_1_0=null;
        InternalN4JSParser.norm1_BindingPattern_return PatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_1_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_69);
            PatternBindingPatternParserRuleCall_0_0=norm1_BindingPattern();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.start):null), (PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getVariableBindingAccess().getPatternAssignment_0());
              			
            }

            }


            }
            {
            EqualsSignKeyword_1_1_0=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce(EqualsSignKeyword_1_1_0, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0());
              		
            }
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_1_1_1_0=norm3_AssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              					announce((ExpressionAssignmentExpressionParserRuleCall_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_0.stop):null), grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_1_1());
              				
            }

            }


            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm4_VariableBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm4_VariableBinding_return norm4_VariableBinding() throws RecognitionException {
        InternalN4JSParser.norm4_VariableBinding_return retval = new InternalN4JSParser.norm4_VariableBinding_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_0_0_0=null;
        InternalN4JSParser.ruleBindingPattern_return PatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleAssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_63);
            PatternBindingPatternParserRuleCall_0_0=ruleBindingPattern();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.start):null), (PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getVariableBindingAccess().getPatternAssignment_0());
              			
            }

            }


            }
            int alt139=2;
            int LA139_0 = input.LA(1);

            if ( (LA139_0==EqualsSign) ) {
                alt139=1;
            }
            switch (alt139) {
                case 1 :
                    {
                    EqualsSignKeyword_1_0_0_0=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce(EqualsSignKeyword_1_0_0_0, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0());
                      		
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0=ruleAssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0.stop):null), grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void norm5_VariableBinding() throws RecognitionException {
        Token EqualsSignKeyword_1_0_0_0=null;
        InternalN4JSParser.ruleBindingPattern_return PatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_63);
            PatternBindingPatternParserRuleCall_0_0=ruleBindingPattern();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {

              				announce((PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.start):null), (PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getVariableBindingAccess().getPatternAssignment_0());
              			
            }

            }


            }
            int alt140=2;
            int LA140_0 = input.LA(1);

            if ( (LA140_0==EqualsSign) ) {
                alt140=1;
            }
            switch (alt140) {
                case 1 :
                    {
                    EqualsSignKeyword_1_0_0_0=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return ;
                    if ( state.backtracking==0 ) {

                      			announce(EqualsSignKeyword_1_0_0_0, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0());
                      		
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0=norm1_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {

                      					announce((ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0.stop):null), grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class norm6_VariableBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm6_VariableBinding_return norm6_VariableBinding() throws RecognitionException {
        InternalN4JSParser.norm6_VariableBinding_return retval = new InternalN4JSParser.norm6_VariableBinding_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_0_0_0=null;
        InternalN4JSParser.norm1_BindingPattern_return PatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.norm2_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_63);
            PatternBindingPatternParserRuleCall_0_0=norm1_BindingPattern();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.start):null), (PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getVariableBindingAccess().getPatternAssignment_0());
              			
            }

            }


            }
            int alt141=2;
            int LA141_0 = input.LA(1);

            if ( (LA141_0==EqualsSign) ) {
                alt141=1;
            }
            switch (alt141) {
                case 1 :
                    {
                    EqualsSignKeyword_1_0_0_0=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce(EqualsSignKeyword_1_0_0_0, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0());
                      		
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0=norm2_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0.stop):null), grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void norm7_VariableBinding() throws RecognitionException {
        Token EqualsSignKeyword_1_0_0_0=null;
        InternalN4JSParser.norm1_BindingPattern_return PatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_63);
            PatternBindingPatternParserRuleCall_0_0=norm1_BindingPattern();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {

              				announce((PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.start):null), (PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getVariableBindingAccess().getPatternAssignment_0());
              			
            }

            }


            }
            int alt142=2;
            int LA142_0 = input.LA(1);

            if ( (LA142_0==EqualsSign) ) {
                alt142=1;
            }
            switch (alt142) {
                case 1 :
                    {
                    EqualsSignKeyword_1_0_0_0=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return ;
                    if ( state.backtracking==0 ) {

                      			announce(EqualsSignKeyword_1_0_0_0, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0());
                      		
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0=norm3_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {

                      					announce((ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0.stop):null), grammarAccess.getVariableBindingAccess().getExpressionAssignment_1_0_0_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class norm1_VariableDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_VariableDeclaration_return norm1_VariableDeclaration() throws RecognitionException {
        InternalN4JSParser.norm1_VariableDeclaration_return retval = new InternalN4JSParser.norm1_VariableDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_VariableDeclarationImpl_return VariableDeclarationImplParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            VariableDeclarationImplParserRuleCall_1=norm1_VariableDeclarationImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.start):null), (VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm3_VariableDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm3_VariableDeclaration_return norm3_VariableDeclaration() throws RecognitionException {
        InternalN4JSParser.norm3_VariableDeclaration_return retval = new InternalN4JSParser.norm3_VariableDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm3_VariableDeclarationImpl_return VariableDeclarationImplParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            VariableDeclarationImplParserRuleCall_1=norm3_VariableDeclarationImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.start):null), (VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm4_VariableDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm4_VariableDeclaration_return norm4_VariableDeclaration() throws RecognitionException {
        InternalN4JSParser.norm4_VariableDeclaration_return retval = new InternalN4JSParser.norm4_VariableDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm4_VariableDeclarationImpl_return VariableDeclarationImplParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            VariableDeclarationImplParserRuleCall_1=norm4_VariableDeclarationImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.start):null), (VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm5_VariableDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm5_VariableDeclaration_return norm5_VariableDeclaration() throws RecognitionException {
        InternalN4JSParser.norm5_VariableDeclaration_return retval = new InternalN4JSParser.norm5_VariableDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm5_VariableDeclarationImpl_return VariableDeclarationImplParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            VariableDeclarationImplParserRuleCall_1=norm5_VariableDeclarationImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.start):null), (VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm6_VariableDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm6_VariableDeclaration_return norm6_VariableDeclaration() throws RecognitionException {
        InternalN4JSParser.norm6_VariableDeclaration_return retval = new InternalN4JSParser.norm6_VariableDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm6_VariableDeclarationImpl_return VariableDeclarationImplParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            VariableDeclarationImplParserRuleCall_1=norm6_VariableDeclarationImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.start):null), (VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm7_VariableDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm7_VariableDeclaration_return norm7_VariableDeclaration() throws RecognitionException {
        InternalN4JSParser.norm7_VariableDeclaration_return retval = new InternalN4JSParser.norm7_VariableDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm7_VariableDeclarationImpl_return VariableDeclarationImplParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            VariableDeclarationImplParserRuleCall_1=norm7_VariableDeclarationImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.start):null), (VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.stop):null), grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void ruleVariableDeclarationImpl() throws RecognitionException {
        Token EqualsSignKeyword_1_1_1_0=null;
        InternalN4JSParser.ruleAnnotation_return AnnotationsAnnotationParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_1_0_0_0 = null;

        InternalN4JSParser.ruleAssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0 = null;




        try {
            {
            {
            loop143:
            do {
                int alt143=2;
                alt143 = dfa143.predict(input);
                switch (alt143) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_71);
            	    AnnotationsAnnotationParserRuleCall_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return ;
            	    if ( state.backtracking==0 ) {

            	      				announce((AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.start):null), (AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop143;
                }
            } while (true);
            {
            {
            {
            {
            pushFollow(FOLLOW_63);
            NameBindingIdentifierParserRuleCall_1_1_0_0_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {

              						announce((NameBindingIdentifierParserRuleCall_1_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_1_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_1_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_1_0_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0());
              					
            }

            }


            }


            }
            int alt144=2;
            int LA144_0 = input.LA(1);

            if ( (LA144_0==EqualsSign) ) {
                alt144=1;
            }
            switch (alt144) {
                case 1 :
                    {
                    EqualsSignKeyword_1_1_1_0=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return ;
                    if ( state.backtracking==0 ) {

                      				announce(EqualsSignKeyword_1_1_1_0, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0=ruleAssignmentExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {

                      						announce((ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1());
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class norm1_VariableDeclarationImpl_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_VariableDeclarationImpl_return norm1_VariableDeclarationImpl() throws RecognitionException {
        InternalN4JSParser.norm1_VariableDeclarationImpl_return retval = new InternalN4JSParser.norm1_VariableDeclarationImpl_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_1_1_0=null;
        InternalN4JSParser.ruleAnnotation_return AnnotationsAnnotationParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_1_0_0_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0 = null;




        try {
            {
            {
            loop145:
            do {
                int alt145=2;
                alt145 = dfa145.predict(input);
                switch (alt145) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_71);
            	    AnnotationsAnnotationParserRuleCall_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.start):null), (AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop145;
                }
            } while (true);
            {
            {
            {
            {
            pushFollow(FOLLOW_63);
            NameBindingIdentifierParserRuleCall_1_1_0_0_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              						announce((NameBindingIdentifierParserRuleCall_1_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_1_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_1_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_1_0_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0());
              					
            }

            }


            }


            }
            int alt146=2;
            int LA146_0 = input.LA(1);

            if ( (LA146_0==EqualsSign) ) {
                alt146=1;
            }
            switch (alt146) {
                case 1 :
                    {
                    EqualsSignKeyword_1_1_1_0=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(EqualsSignKeyword_1_1_1_0, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0=norm1_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1());
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void norm2_VariableDeclarationImpl() throws RecognitionException {
        Token EqualsSignKeyword_1_1_1_0=null;
        InternalN4JSParser.ruleAnnotation_return AnnotationsAnnotationParserRuleCall_0_0 = null;

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_1_1_0_0_0 = null;

        InternalN4JSParser.norm2_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0 = null;




        try {
            {
            {
            loop147:
            do {
                int alt147=2;
                alt147 = dfa147.predict(input);
                switch (alt147) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_71);
            	    AnnotationsAnnotationParserRuleCall_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return ;
            	    if ( state.backtracking==0 ) {

            	      				announce((AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.start):null), (AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop147;
                }
            } while (true);
            {
            {
            {
            {
            pushFollow(FOLLOW_63);
            NameBindingIdentifierParserRuleCall_1_1_0_0_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return ;
            if ( state.backtracking==0 ) {

              						announce((NameBindingIdentifierParserRuleCall_1_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_1_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_1_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_1_0_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0());
              					
            }

            }


            }


            }
            int alt148=2;
            int LA148_0 = input.LA(1);

            if ( (LA148_0==EqualsSign) ) {
                alt148=1;
            }
            switch (alt148) {
                case 1 :
                    {
                    EqualsSignKeyword_1_1_1_0=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return ;
                    if ( state.backtracking==0 ) {

                      				announce(EqualsSignKeyword_1_1_1_0, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0=norm2_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {

                      						announce((ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1());
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class norm3_VariableDeclarationImpl_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm3_VariableDeclarationImpl_return norm3_VariableDeclarationImpl() throws RecognitionException {
        InternalN4JSParser.norm3_VariableDeclarationImpl_return retval = new InternalN4JSParser.norm3_VariableDeclarationImpl_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_1_1_0=null;
        InternalN4JSParser.ruleAnnotation_return AnnotationsAnnotationParserRuleCall_0_0 = null;

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_1_1_0_0_0 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0 = null;




        try {
            {
            {
            loop149:
            do {
                int alt149=2;
                alt149 = dfa149.predict(input);
                switch (alt149) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_71);
            	    AnnotationsAnnotationParserRuleCall_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.start):null), (AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop149;
                }
            } while (true);
            {
            {
            {
            {
            pushFollow(FOLLOW_63);
            NameBindingIdentifierParserRuleCall_1_1_0_0_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              						announce((NameBindingIdentifierParserRuleCall_1_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_1_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_1_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_1_0_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_1_0_0());
              					
            }

            }


            }


            }
            int alt150=2;
            int LA150_0 = input.LA(1);

            if ( (LA150_0==EqualsSign) ) {
                alt150=1;
            }
            switch (alt150) {
                case 1 :
                    {
                    EqualsSignKeyword_1_1_1_0=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(EqualsSignKeyword_1_1_1_0, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0=norm3_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_1_1_1());
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm4_VariableDeclarationImpl_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm4_VariableDeclarationImpl_return norm4_VariableDeclarationImpl() throws RecognitionException {
        InternalN4JSParser.norm4_VariableDeclarationImpl_return retval = new InternalN4JSParser.norm4_VariableDeclarationImpl_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_0_1_0=null;
        InternalN4JSParser.ruleAnnotation_return AnnotationsAnnotationParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0_0_0_0_0 = null;

        InternalN4JSParser.ruleColonSepDeclaredTypeRef_return ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1 = null;

        InternalN4JSParser.ruleAssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0 = null;




        try {
            {
            {
            loop151:
            do {
                int alt151=2;
                alt151 = dfa151.predict(input);
                switch (alt151) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_71);
            	    AnnotationsAnnotationParserRuleCall_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.start):null), (AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop151;
                }
            } while (true);
            {
            {
            {
            {
            {
            pushFollow(FOLLOW_66);
            NameBindingIdentifierParserRuleCall_1_0_0_0_0_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              							announce((NameBindingIdentifierParserRuleCall_1_0_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_1_0_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0());
              						
            }

            }


            }
            int alt152=2;
            int LA152_0 = input.LA(1);

            if ( (LA152_0==Colon) ) {
                alt152=1;
            }
            switch (alt152) {
                case 1 :
                    {
                    pushFollow(FOLLOW_63);
                    ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1=ruleColonSepDeclaredTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1.start):null), (ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1.stop):null), grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); 
                    }

                    }
                    break;

            }


            }


            }
            int alt153=2;
            int LA153_0 = input.LA(1);

            if ( (LA153_0==EqualsSign) ) {
                alt153=1;
            }
            switch (alt153) {
                case 1 :
                    {
                    EqualsSignKeyword_1_0_1_0=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(EqualsSignKeyword_1_0_1_0, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0=ruleAssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1());
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm5_VariableDeclarationImpl_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm5_VariableDeclarationImpl_return norm5_VariableDeclarationImpl() throws RecognitionException {
        InternalN4JSParser.norm5_VariableDeclarationImpl_return retval = new InternalN4JSParser.norm5_VariableDeclarationImpl_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_0_1_0=null;
        InternalN4JSParser.ruleAnnotation_return AnnotationsAnnotationParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0_0_0_0_0 = null;

        InternalN4JSParser.ruleColonSepDeclaredTypeRef_return ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0 = null;




        try {
            {
            {
            loop154:
            do {
                int alt154=2;
                alt154 = dfa154.predict(input);
                switch (alt154) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_71);
            	    AnnotationsAnnotationParserRuleCall_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.start):null), (AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop154;
                }
            } while (true);
            {
            {
            {
            {
            {
            pushFollow(FOLLOW_66);
            NameBindingIdentifierParserRuleCall_1_0_0_0_0_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              							announce((NameBindingIdentifierParserRuleCall_1_0_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_1_0_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0());
              						
            }

            }


            }
            int alt155=2;
            int LA155_0 = input.LA(1);

            if ( (LA155_0==Colon) ) {
                alt155=1;
            }
            switch (alt155) {
                case 1 :
                    {
                    pushFollow(FOLLOW_63);
                    ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1=ruleColonSepDeclaredTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1.start):null), (ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1.stop):null), grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); 
                    }

                    }
                    break;

            }


            }


            }
            int alt156=2;
            int LA156_0 = input.LA(1);

            if ( (LA156_0==EqualsSign) ) {
                alt156=1;
            }
            switch (alt156) {
                case 1 :
                    {
                    EqualsSignKeyword_1_0_1_0=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(EqualsSignKeyword_1_0_1_0, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0=norm1_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1());
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm6_VariableDeclarationImpl_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm6_VariableDeclarationImpl_return norm6_VariableDeclarationImpl() throws RecognitionException {
        InternalN4JSParser.norm6_VariableDeclarationImpl_return retval = new InternalN4JSParser.norm6_VariableDeclarationImpl_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_0_1_0=null;
        InternalN4JSParser.ruleAnnotation_return AnnotationsAnnotationParserRuleCall_0_0 = null;

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0_0_0_0_0 = null;

        InternalN4JSParser.ruleColonSepDeclaredTypeRef_return ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1 = null;

        InternalN4JSParser.norm2_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0 = null;




        try {
            {
            {
            loop157:
            do {
                int alt157=2;
                alt157 = dfa157.predict(input);
                switch (alt157) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_71);
            	    AnnotationsAnnotationParserRuleCall_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.start):null), (AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop157;
                }
            } while (true);
            {
            {
            {
            {
            {
            pushFollow(FOLLOW_66);
            NameBindingIdentifierParserRuleCall_1_0_0_0_0_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              							announce((NameBindingIdentifierParserRuleCall_1_0_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_1_0_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0());
              						
            }

            }


            }
            int alt158=2;
            int LA158_0 = input.LA(1);

            if ( (LA158_0==Colon) ) {
                alt158=1;
            }
            switch (alt158) {
                case 1 :
                    {
                    pushFollow(FOLLOW_63);
                    ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1=ruleColonSepDeclaredTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1.start):null), (ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1.stop):null), grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); 
                    }

                    }
                    break;

            }


            }


            }
            int alt159=2;
            int LA159_0 = input.LA(1);

            if ( (LA159_0==EqualsSign) ) {
                alt159=1;
            }
            switch (alt159) {
                case 1 :
                    {
                    EqualsSignKeyword_1_0_1_0=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(EqualsSignKeyword_1_0_1_0, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0=norm2_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1());
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm7_VariableDeclarationImpl_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm7_VariableDeclarationImpl_return norm7_VariableDeclarationImpl() throws RecognitionException {
        InternalN4JSParser.norm7_VariableDeclarationImpl_return retval = new InternalN4JSParser.norm7_VariableDeclarationImpl_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1_0_1_0=null;
        InternalN4JSParser.ruleAnnotation_return AnnotationsAnnotationParserRuleCall_0_0 = null;

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0_0_0_0_0 = null;

        InternalN4JSParser.ruleColonSepDeclaredTypeRef_return ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0 = null;




        try {
            {
            {
            loop160:
            do {
                int alt160=2;
                alt160 = dfa160.predict(input);
                switch (alt160) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_71);
            	    AnnotationsAnnotationParserRuleCall_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.start):null), (AnnotationsAnnotationParserRuleCall_0_0!=null?((Token)AnnotationsAnnotationParserRuleCall_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAssignment_0());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop160;
                }
            } while (true);
            {
            {
            {
            {
            {
            pushFollow(FOLLOW_66);
            NameBindingIdentifierParserRuleCall_1_0_0_0_0_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              							announce((NameBindingIdentifierParserRuleCall_1_0_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_1_0_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0_0_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getNameAssignment_1_0_0_0_0());
              						
            }

            }


            }
            int alt161=2;
            int LA161_0 = input.LA(1);

            if ( (LA161_0==Colon) ) {
                alt161=1;
            }
            switch (alt161) {
                case 1 :
                    {
                    pushFollow(FOLLOW_63);
                    ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1=ruleColonSepDeclaredTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1.start):null), (ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1.stop):null), grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1()); 
                    }

                    }
                    break;

            }


            }


            }
            int alt162=2;
            int LA162_0 = input.LA(1);

            if ( (LA162_0==EqualsSign) ) {
                alt162=1;
            }
            switch (alt162) {
                case 1 :
                    {
                    EqualsSignKeyword_1_0_1_0=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(EqualsSignKeyword_1_0_1_0, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0=norm3_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0.stop):null), grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignment_1_0_1_1());
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleExportedVariableDeclarationOrBinding() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleExportedVariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleExportedVariableDeclarationOrBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExportedVariableDeclarationOrBinding_return ruleExportedVariableDeclarationOrBinding() throws RecognitionException {
        InternalN4JSParser.ruleExportedVariableDeclarationOrBinding_return retval = new InternalN4JSParser.ruleExportedVariableDeclarationOrBinding_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleExportedVariableBinding_return ExportedVariableBindingParserRuleCall_0 = null;

        InternalN4JSParser.ruleExportedVariableDeclaration_return ExportedVariableDeclarationParserRuleCall_1 = null;




        try {
            {
            int alt163=2;
            int LA163_0 = input.LA(1);

            if ( (LA163_0==LeftCurlyBracket) && (synpred96_InternalN4JSParser())) {
                alt163=1;
            }
            else if ( (LA163_0==LeftSquareBracket) && (synpred96_InternalN4JSParser())) {
                alt163=1;
            }
            else if ( ((LA163_0>=Intersection && LA163_0<=Implements)||(LA163_0>=Promisify && LA163_0<=Abstract)||LA163_0==External||(LA163_0>=Private && LA163_0<=Project)||LA163_0==Public||LA163_0==Static||LA163_0==Target||(LA163_0>=Async && LA163_0<=Await)||LA163_0==Union||(LA163_0>=Yield && LA163_0<=This)||LA163_0==From||LA163_0==Type||(LA163_0>=Get && LA163_0<=Let)||(LA163_0>=Out && LA163_0<=Set)||LA163_0==As||LA163_0==Of||LA163_0==CommercialAt||LA163_0==RULE_IDENTIFIER) ) {
                alt163=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 163, 0, input);

                throw nvae;
            }
            switch (alt163) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExportedVariableBindingParserRuleCall_0=ruleExportedVariableBinding();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ExportedVariableBindingParserRuleCall_0!=null?((Token)ExportedVariableBindingParserRuleCall_0.start):null), (ExportedVariableBindingParserRuleCall_0!=null?((Token)ExportedVariableBindingParserRuleCall_0.stop):null), grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    ExportedVariableDeclarationParserRuleCall_1=ruleExportedVariableDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ExportedVariableDeclarationParserRuleCall_1!=null?((Token)ExportedVariableDeclarationParserRuleCall_1.start):null), (ExportedVariableDeclarationParserRuleCall_1!=null?((Token)ExportedVariableDeclarationParserRuleCall_1.stop):null), grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void norm1_ExportedVariableDeclarationOrBinding() throws RecognitionException {
        InternalN4JSParser.norm1_ExportedVariableBinding_return ExportedVariableBindingParserRuleCall_0 = null;

        InternalN4JSParser.norm1_ExportedVariableDeclaration_return ExportedVariableDeclarationParserRuleCall_1 = null;




        try {
            {
            int alt164=2;
            int LA164_0 = input.LA(1);

            if ( (LA164_0==LeftCurlyBracket) && (synpred97_InternalN4JSParser())) {
                alt164=1;
            }
            else if ( (LA164_0==LeftSquareBracket) && (synpred97_InternalN4JSParser())) {
                alt164=1;
            }
            else if ( ((LA164_0>=Intersection && LA164_0<=Implements)||(LA164_0>=Promisify && LA164_0<=Abstract)||LA164_0==External||(LA164_0>=Private && LA164_0<=Project)||LA164_0==Public||LA164_0==Static||LA164_0==Target||(LA164_0>=Async && LA164_0<=Await)||LA164_0==Union||LA164_0==This||LA164_0==From||LA164_0==Type||(LA164_0>=Get && LA164_0<=Let)||(LA164_0>=Out && LA164_0<=Set)||LA164_0==As||LA164_0==Of||LA164_0==CommercialAt||LA164_0==RULE_IDENTIFIER) ) {
                alt164=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 164, 0, input);

                throw nvae;
            }
            switch (alt164) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExportedVariableBindingParserRuleCall_0=norm1_ExportedVariableBinding();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       announce((ExportedVariableBindingParserRuleCall_0!=null?((Token)ExportedVariableBindingParserRuleCall_0.start):null), (ExportedVariableBindingParserRuleCall_0!=null?((Token)ExportedVariableBindingParserRuleCall_0.stop):null), grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0()); 
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    ExportedVariableDeclarationParserRuleCall_1=norm1_ExportedVariableDeclaration();

                    state._fsp--;
                    if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                       announce((ExportedVariableDeclarationParserRuleCall_1!=null?((Token)ExportedVariableDeclarationParserRuleCall_1.start):null), (ExportedVariableDeclarationParserRuleCall_1!=null?((Token)ExportedVariableDeclarationParserRuleCall_1.stop):null), grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1()); 
                    }

                    }
                    break;

            }


            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }
    public final void entryRuleExportedVariableBinding() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleExportedVariableBinding();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleExportedVariableBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExportedVariableBinding_return ruleExportedVariableBinding() throws RecognitionException {
        InternalN4JSParser.ruleExportedVariableBinding_return retval = new InternalN4JSParser.ruleExportedVariableBinding_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1=null;
        InternalN4JSParser.ruleBindingPattern_return PatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_2_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_69);
            PatternBindingPatternParserRuleCall_0_0=ruleBindingPattern();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.start):null), (PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getExportedVariableBindingAccess().getPatternAssignment_0());
              			
            }

            }


            }

            EqualsSignKeyword_1=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(EqualsSignKeyword_1, grammarAccess.getExportedVariableBindingAccess().getEqualsSignKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_2_0=norm1_AssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionAssignmentExpressionParserRuleCall_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_0.stop):null), grammarAccess.getExportedVariableBindingAccess().getExpressionAssignment_2());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ExportedVariableBinding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ExportedVariableBinding_return norm1_ExportedVariableBinding() throws RecognitionException {
        InternalN4JSParser.norm1_ExportedVariableBinding_return retval = new InternalN4JSParser.norm1_ExportedVariableBinding_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_1=null;
        InternalN4JSParser.norm1_BindingPattern_return PatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_2_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_69);
            PatternBindingPatternParserRuleCall_0_0=norm1_BindingPattern();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.start):null), (PatternBindingPatternParserRuleCall_0_0!=null?((Token)PatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getExportedVariableBindingAccess().getPatternAssignment_0());
              			
            }

            }


            }

            EqualsSignKeyword_1=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(EqualsSignKeyword_1, grammarAccess.getExportedVariableBindingAccess().getEqualsSignKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_2_0=norm3_AssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionAssignmentExpressionParserRuleCall_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_0.stop):null), grammarAccess.getExportedVariableBindingAccess().getExpressionAssignment_2());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleExportedVariableDeclaration() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleExportedVariableDeclaration();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleExportedVariableDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExportedVariableDeclaration_return ruleExportedVariableDeclaration() throws RecognitionException {
        InternalN4JSParser.ruleExportedVariableDeclaration_return retval = new InternalN4JSParser.ruleExportedVariableDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm5_VariableDeclarationImpl_return VariableDeclarationImplParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            VariableDeclarationImplParserRuleCall_1=norm5_VariableDeclarationImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.start):null), (VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.stop):null), grammarAccess.getExportedVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ExportedVariableDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ExportedVariableDeclaration_return norm1_ExportedVariableDeclaration() throws RecognitionException {
        InternalN4JSParser.norm1_ExportedVariableDeclaration_return retval = new InternalN4JSParser.norm1_ExportedVariableDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm7_VariableDeclarationImpl_return VariableDeclarationImplParserRuleCall_1 = null;




        try {
            {
            {
            pushFollow(FOLLOW_2);
            VariableDeclarationImplParserRuleCall_1=norm7_VariableDeclarationImpl();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.start):null), (VariableDeclarationImplParserRuleCall_1!=null?((Token)VariableDeclarationImplParserRuleCall_1.stop):null), grammarAccess.getExportedVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleEmptyStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleEmptyStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleEmptyStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleEmptyStatement_return ruleEmptyStatement() throws RecognitionException {
        InternalN4JSParser.ruleEmptyStatement_return retval = new InternalN4JSParser.ruleEmptyStatement_return();
        retval.start = input.LT(1);

        Token SemicolonKeyword_1=null;



        try {
            {
            {
            SemicolonKeyword_1=(Token)match(input,Semicolon,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(SemicolonKeyword_1, grammarAccess.getEmptyStatementAccess().getSemicolonKeyword_1());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleExpressionStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleExpressionStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleExpressionStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleExpressionStatement_return ruleExpressionStatement() throws RecognitionException {
        InternalN4JSParser.ruleExpressionStatement_return retval = new InternalN4JSParser.ruleExpressionStatement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_1 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_18);
            ExpressionExpressionParserRuleCall_0_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_0_0!=null?((Token)ExpressionExpressionParserRuleCall_0_0.start):null), (ExpressionExpressionParserRuleCall_0_0!=null?((Token)ExpressionExpressionParserRuleCall_0_0.stop):null), grammarAccess.getExpressionStatementAccess().getExpressionAssignment_0());
              			
            }

            }


            }

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_1=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_1!=null?((Token)SemiParserRuleCall_1.start):null), (SemiParserRuleCall_1!=null?((Token)SemiParserRuleCall_1.stop):null), grammarAccess.getExpressionStatementAccess().getSemiParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ExpressionStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ExpressionStatement_return norm1_ExpressionStatement() throws RecognitionException {
        InternalN4JSParser.norm1_ExpressionStatement_return retval = new InternalN4JSParser.norm1_ExpressionStatement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_1 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_18);
            ExpressionExpressionParserRuleCall_0_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_0_0!=null?((Token)ExpressionExpressionParserRuleCall_0_0.start):null), (ExpressionExpressionParserRuleCall_0_0!=null?((Token)ExpressionExpressionParserRuleCall_0_0.stop):null), grammarAccess.getExpressionStatementAccess().getExpressionAssignment_0());
              			
            }

            }


            }

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_1=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_1!=null?((Token)SemiParserRuleCall_1.start):null), (SemiParserRuleCall_1!=null?((Token)SemiParserRuleCall_1.stop):null), grammarAccess.getExpressionStatementAccess().getSemiParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleIfStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleIfStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleIfStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleIfStatement_return ruleIfStatement() throws RecognitionException {
        InternalN4JSParser.ruleIfStatement_return retval = new InternalN4JSParser.ruleIfStatement_return();
        retval.start = input.LT(1);

        Token IfKeyword_0=null;
        Token LeftParenthesisKeyword_1=null;
        Token RightParenthesisKeyword_3=null;
        Token ElseKeyword_5_0=null;
        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_2_0 = null;

        InternalN4JSParser.ruleStatement_return IfStmtStatementParserRuleCall_4_0 = null;

        InternalN4JSParser.ruleStatement_return ElseStmtStatementParserRuleCall_5_1_0 = null;




        try {
            {
            {
            IfKeyword_0=(Token)match(input,If,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(IfKeyword_0, grammarAccess.getIfStatementAccess().getIfKeyword_0());
              	
            }
            LeftParenthesisKeyword_1=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_1, grammarAccess.getIfStatementAccess().getLeftParenthesisKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_2_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.start):null), (ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.stop):null), grammarAccess.getIfStatementAccess().getExpressionAssignment_2());
              			
            }

            }


            }

            RightParenthesisKeyword_3=(Token)match(input,RightParenthesis,FOLLOW_73); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_3, grammarAccess.getIfStatementAccess().getRightParenthesisKeyword_3());
              	
            }
            {
            {
            pushFollow(FOLLOW_74);
            IfStmtStatementParserRuleCall_4_0=ruleStatement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((IfStmtStatementParserRuleCall_4_0!=null?((Token)IfStmtStatementParserRuleCall_4_0.start):null), (IfStmtStatementParserRuleCall_4_0!=null?((Token)IfStmtStatementParserRuleCall_4_0.stop):null), grammarAccess.getIfStatementAccess().getIfStmtAssignment_4());
              			
            }

            }


            }
            int alt165=2;
            int LA165_0 = input.LA(1);

            if ( (LA165_0==Else) ) {
                int LA165_1 = input.LA(2);

                if ( (synpred100_InternalN4JSParser()) ) {
                    alt165=1;
                }
            }
            switch (alt165) {
                case 1 :
                    {
                    {
                    ElseKeyword_5_0=(Token)match(input,Else,FOLLOW_73); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(ElseKeyword_5_0, grammarAccess.getIfStatementAccess().getElseKeyword_5_0());
                      			
                    }

                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ElseStmtStatementParserRuleCall_5_1_0=ruleStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((ElseStmtStatementParserRuleCall_5_1_0!=null?((Token)ElseStmtStatementParserRuleCall_5_1_0.start):null), (ElseStmtStatementParserRuleCall_5_1_0!=null?((Token)ElseStmtStatementParserRuleCall_5_1_0.stop):null), grammarAccess.getIfStatementAccess().getElseStmtAssignment_5_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_IfStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_IfStatement_return norm1_IfStatement() throws RecognitionException {
        InternalN4JSParser.norm1_IfStatement_return retval = new InternalN4JSParser.norm1_IfStatement_return();
        retval.start = input.LT(1);

        Token IfKeyword_0=null;
        Token LeftParenthesisKeyword_1=null;
        Token RightParenthesisKeyword_3=null;
        Token ElseKeyword_5_0=null;
        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_2_0 = null;

        InternalN4JSParser.norm1_Statement_return IfStmtStatementParserRuleCall_4_0 = null;

        InternalN4JSParser.norm1_Statement_return ElseStmtStatementParserRuleCall_5_1_0 = null;




        try {
            {
            {
            IfKeyword_0=(Token)match(input,If,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(IfKeyword_0, grammarAccess.getIfStatementAccess().getIfKeyword_0());
              	
            }
            LeftParenthesisKeyword_1=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_1, grammarAccess.getIfStatementAccess().getLeftParenthesisKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_2_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.start):null), (ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.stop):null), grammarAccess.getIfStatementAccess().getExpressionAssignment_2());
              			
            }

            }


            }

            RightParenthesisKeyword_3=(Token)match(input,RightParenthesis,FOLLOW_75); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_3, grammarAccess.getIfStatementAccess().getRightParenthesisKeyword_3());
              	
            }
            {
            {
            pushFollow(FOLLOW_74);
            IfStmtStatementParserRuleCall_4_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((IfStmtStatementParserRuleCall_4_0!=null?((Token)IfStmtStatementParserRuleCall_4_0.start):null), (IfStmtStatementParserRuleCall_4_0!=null?((Token)IfStmtStatementParserRuleCall_4_0.stop):null), grammarAccess.getIfStatementAccess().getIfStmtAssignment_4());
              			
            }

            }


            }
            int alt166=2;
            int LA166_0 = input.LA(1);

            if ( (LA166_0==Else) ) {
                int LA166_1 = input.LA(2);

                if ( (synpred101_InternalN4JSParser()) ) {
                    alt166=1;
                }
            }
            switch (alt166) {
                case 1 :
                    {
                    {
                    ElseKeyword_5_0=(Token)match(input,Else,FOLLOW_75); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(ElseKeyword_5_0, grammarAccess.getIfStatementAccess().getElseKeyword_5_0());
                      			
                    }

                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ElseStmtStatementParserRuleCall_5_1_0=norm1_Statement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((ElseStmtStatementParserRuleCall_5_1_0!=null?((Token)ElseStmtStatementParserRuleCall_5_1_0.start):null), (ElseStmtStatementParserRuleCall_5_1_0!=null?((Token)ElseStmtStatementParserRuleCall_5_1_0.stop):null), grammarAccess.getIfStatementAccess().getElseStmtAssignment_5_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleIterationStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleIterationStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleIterationStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleIterationStatement_return ruleIterationStatement() throws RecognitionException {
        InternalN4JSParser.ruleIterationStatement_return retval = new InternalN4JSParser.ruleIterationStatement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleDoStatement_return DoStatementParserRuleCall_0 = null;

        InternalN4JSParser.ruleWhileStatement_return WhileStatementParserRuleCall_1 = null;

        InternalN4JSParser.ruleForStatement_return ForStatementParserRuleCall_2 = null;




        try {
            {
            int alt167=3;
            switch ( input.LA(1) ) {
            case Do:
                {
                alt167=1;
                }
                break;
            case While:
                {
                alt167=2;
                }
                break;
            case For:
                {
                alt167=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 167, 0, input);

                throw nvae;
            }

            switch (alt167) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    DoStatementParserRuleCall_0=ruleDoStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((DoStatementParserRuleCall_0!=null?((Token)DoStatementParserRuleCall_0.start):null), (DoStatementParserRuleCall_0!=null?((Token)DoStatementParserRuleCall_0.stop):null), grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0()); 
                    }

                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    WhileStatementParserRuleCall_1=ruleWhileStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((WhileStatementParserRuleCall_1!=null?((Token)WhileStatementParserRuleCall_1.start):null), (WhileStatementParserRuleCall_1!=null?((Token)WhileStatementParserRuleCall_1.stop):null), grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1()); 
                    }

                    }
                    break;
                case 3 :
                    {
                    pushFollow(FOLLOW_2);
                    ForStatementParserRuleCall_2=ruleForStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ForStatementParserRuleCall_2!=null?((Token)ForStatementParserRuleCall_2.start):null), (ForStatementParserRuleCall_2!=null?((Token)ForStatementParserRuleCall_2.stop):null), grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_IterationStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_IterationStatement_return norm1_IterationStatement() throws RecognitionException {
        InternalN4JSParser.norm1_IterationStatement_return retval = new InternalN4JSParser.norm1_IterationStatement_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_DoStatement_return DoStatementParserRuleCall_0 = null;

        InternalN4JSParser.norm1_WhileStatement_return WhileStatementParserRuleCall_1 = null;

        InternalN4JSParser.norm1_ForStatement_return ForStatementParserRuleCall_2 = null;




        try {
            {
            int alt168=3;
            switch ( input.LA(1) ) {
            case Do:
                {
                alt168=1;
                }
                break;
            case While:
                {
                alt168=2;
                }
                break;
            case For:
                {
                alt168=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 168, 0, input);

                throw nvae;
            }

            switch (alt168) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    DoStatementParserRuleCall_0=norm1_DoStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((DoStatementParserRuleCall_0!=null?((Token)DoStatementParserRuleCall_0.start):null), (DoStatementParserRuleCall_0!=null?((Token)DoStatementParserRuleCall_0.stop):null), grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0()); 
                    }

                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    WhileStatementParserRuleCall_1=norm1_WhileStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((WhileStatementParserRuleCall_1!=null?((Token)WhileStatementParserRuleCall_1.start):null), (WhileStatementParserRuleCall_1!=null?((Token)WhileStatementParserRuleCall_1.stop):null), grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1()); 
                    }

                    }
                    break;
                case 3 :
                    {
                    pushFollow(FOLLOW_2);
                    ForStatementParserRuleCall_2=norm1_ForStatement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ForStatementParserRuleCall_2!=null?((Token)ForStatementParserRuleCall_2.start):null), (ForStatementParserRuleCall_2!=null?((Token)ForStatementParserRuleCall_2.stop):null), grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleDoStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleDoStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleDoStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleDoStatement_return ruleDoStatement() throws RecognitionException {
        InternalN4JSParser.ruleDoStatement_return retval = new InternalN4JSParser.ruleDoStatement_return();
        retval.start = input.LT(1);

        Token DoKeyword_0=null;
        Token WhileKeyword_2=null;
        Token LeftParenthesisKeyword_3=null;
        Token RightParenthesisKeyword_5=null;
        InternalN4JSParser.ruleStatement_return StatementStatementParserRuleCall_1_0 = null;

        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_4_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_6 = null;




        try {
            {
            {
            DoKeyword_0=(Token)match(input,Do,FOLLOW_73); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(DoKeyword_0, grammarAccess.getDoStatementAccess().getDoKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_76);
            StatementStatementParserRuleCall_1_0=ruleStatement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementStatementParserRuleCall_1_0!=null?((Token)StatementStatementParserRuleCall_1_0.start):null), (StatementStatementParserRuleCall_1_0!=null?((Token)StatementStatementParserRuleCall_1_0.stop):null), grammarAccess.getDoStatementAccess().getStatementAssignment_1());
              			
            }

            }


            }

            WhileKeyword_2=(Token)match(input,While,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(WhileKeyword_2, grammarAccess.getDoStatementAccess().getWhileKeyword_2());
              	
            }
            LeftParenthesisKeyword_3=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_3, grammarAccess.getDoStatementAccess().getLeftParenthesisKeyword_3());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_4_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_4_0!=null?((Token)ExpressionExpressionParserRuleCall_4_0.start):null), (ExpressionExpressionParserRuleCall_4_0!=null?((Token)ExpressionExpressionParserRuleCall_4_0.stop):null), grammarAccess.getDoStatementAccess().getExpressionAssignment_4());
              			
            }

            }


            }

            RightParenthesisKeyword_5=(Token)match(input,RightParenthesis,FOLLOW_35); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_5, grammarAccess.getDoStatementAccess().getRightParenthesisKeyword_5());
              	
            }
            int alt169=2;
            alt169 = dfa169.predict(input);
            switch (alt169) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    SemiParserRuleCall_6=ruleSemi();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((SemiParserRuleCall_6!=null?((Token)SemiParserRuleCall_6.start):null), (SemiParserRuleCall_6!=null?((Token)SemiParserRuleCall_6.stop):null), grammarAccess.getDoStatementAccess().getSemiParserRuleCall_6()); 
                    }

                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_DoStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_DoStatement_return norm1_DoStatement() throws RecognitionException {
        InternalN4JSParser.norm1_DoStatement_return retval = new InternalN4JSParser.norm1_DoStatement_return();
        retval.start = input.LT(1);

        Token DoKeyword_0=null;
        Token WhileKeyword_2=null;
        Token LeftParenthesisKeyword_3=null;
        Token RightParenthesisKeyword_5=null;
        InternalN4JSParser.norm1_Statement_return StatementStatementParserRuleCall_1_0 = null;

        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_4_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_6 = null;




        try {
            {
            {
            DoKeyword_0=(Token)match(input,Do,FOLLOW_75); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(DoKeyword_0, grammarAccess.getDoStatementAccess().getDoKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_76);
            StatementStatementParserRuleCall_1_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementStatementParserRuleCall_1_0!=null?((Token)StatementStatementParserRuleCall_1_0.start):null), (StatementStatementParserRuleCall_1_0!=null?((Token)StatementStatementParserRuleCall_1_0.stop):null), grammarAccess.getDoStatementAccess().getStatementAssignment_1());
              			
            }

            }


            }

            WhileKeyword_2=(Token)match(input,While,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(WhileKeyword_2, grammarAccess.getDoStatementAccess().getWhileKeyword_2());
              	
            }
            LeftParenthesisKeyword_3=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_3, grammarAccess.getDoStatementAccess().getLeftParenthesisKeyword_3());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_4_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_4_0!=null?((Token)ExpressionExpressionParserRuleCall_4_0.start):null), (ExpressionExpressionParserRuleCall_4_0!=null?((Token)ExpressionExpressionParserRuleCall_4_0.stop):null), grammarAccess.getDoStatementAccess().getExpressionAssignment_4());
              			
            }

            }


            }

            RightParenthesisKeyword_5=(Token)match(input,RightParenthesis,FOLLOW_35); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_5, grammarAccess.getDoStatementAccess().getRightParenthesisKeyword_5());
              	
            }
            int alt170=2;
            int LA170_0 = input.LA(1);

            if ( (LA170_0==Semicolon) ) {
                int LA170_1 = input.LA(2);

                if ( (synpred103_InternalN4JSParser()) ) {
                    alt170=1;
                }
            }
            else if ( (LA170_0==EOF) && (synpred103_InternalN4JSParser())) {
                alt170=1;
            }
            else if ( (LA170_0==RULE_EOL) && (synpred103_InternalN4JSParser())) {
                alt170=1;
            }
            else if ( (LA170_0==RULE_ML_COMMENT) && (synpred103_InternalN4JSParser())) {
                alt170=1;
            }
            else if ( (LA170_0==RightCurlyBracket) ) {
                int LA170_5 = input.LA(2);

                if ( (synpred103_InternalN4JSParser()) ) {
                    alt170=1;
                }
            }
            switch (alt170) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    SemiParserRuleCall_6=ruleSemi();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((SemiParserRuleCall_6!=null?((Token)SemiParserRuleCall_6.start):null), (SemiParserRuleCall_6!=null?((Token)SemiParserRuleCall_6.stop):null), grammarAccess.getDoStatementAccess().getSemiParserRuleCall_6()); 
                    }

                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleWhileStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleWhileStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleWhileStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleWhileStatement_return ruleWhileStatement() throws RecognitionException {
        InternalN4JSParser.ruleWhileStatement_return retval = new InternalN4JSParser.ruleWhileStatement_return();
        retval.start = input.LT(1);

        Token WhileKeyword_0=null;
        Token LeftParenthesisKeyword_1=null;
        Token RightParenthesisKeyword_3=null;
        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_2_0 = null;

        InternalN4JSParser.ruleStatement_return StatementStatementParserRuleCall_4_0 = null;




        try {
            {
            {
            WhileKeyword_0=(Token)match(input,While,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(WhileKeyword_0, grammarAccess.getWhileStatementAccess().getWhileKeyword_0());
              	
            }
            LeftParenthesisKeyword_1=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_1, grammarAccess.getWhileStatementAccess().getLeftParenthesisKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_2_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.start):null), (ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.stop):null), grammarAccess.getWhileStatementAccess().getExpressionAssignment_2());
              			
            }

            }


            }

            RightParenthesisKeyword_3=(Token)match(input,RightParenthesis,FOLLOW_73); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_3, grammarAccess.getWhileStatementAccess().getRightParenthesisKeyword_3());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            StatementStatementParserRuleCall_4_0=ruleStatement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.start):null), (StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.stop):null), grammarAccess.getWhileStatementAccess().getStatementAssignment_4());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_WhileStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_WhileStatement_return norm1_WhileStatement() throws RecognitionException {
        InternalN4JSParser.norm1_WhileStatement_return retval = new InternalN4JSParser.norm1_WhileStatement_return();
        retval.start = input.LT(1);

        Token WhileKeyword_0=null;
        Token LeftParenthesisKeyword_1=null;
        Token RightParenthesisKeyword_3=null;
        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_2_0 = null;

        InternalN4JSParser.norm1_Statement_return StatementStatementParserRuleCall_4_0 = null;




        try {
            {
            {
            WhileKeyword_0=(Token)match(input,While,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(WhileKeyword_0, grammarAccess.getWhileStatementAccess().getWhileKeyword_0());
              	
            }
            LeftParenthesisKeyword_1=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_1, grammarAccess.getWhileStatementAccess().getLeftParenthesisKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_2_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.start):null), (ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.stop):null), grammarAccess.getWhileStatementAccess().getExpressionAssignment_2());
              			
            }

            }


            }

            RightParenthesisKeyword_3=(Token)match(input,RightParenthesis,FOLLOW_75); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_3, grammarAccess.getWhileStatementAccess().getRightParenthesisKeyword_3());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            StatementStatementParserRuleCall_4_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.start):null), (StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.stop):null), grammarAccess.getWhileStatementAccess().getStatementAssignment_4());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleForStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleForStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleForStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleForStatement_return ruleForStatement() throws RecognitionException {
        InternalN4JSParser.ruleForStatement_return retval = new InternalN4JSParser.ruleForStatement_return();
        retval.start = input.LT(1);

        Token ForKeyword_1=null;
        Token LeftParenthesisKeyword_2=null;
        Token ForInInKeyword_3_0_0_1_0=null;
        Token RightParenthesisKeyword_3_0_0_3=null;
        Token ForInInKeyword_3_1_0_0_1_0_0_1_0_0=null;
        Token ForOfOfKeyword_3_1_0_0_1_0_0_1_1_0=null;
        Token CommaKeyword_3_1_0_0_1_1_1_0_0_0=null;
        Token SemicolonKeyword_3_1_0_0_1_1_1_0_1=null;
        Token SemicolonKeyword_3_1_0_0_1_1_1_0_3=null;
        Token ForInInKeyword_3_1_0_0_1_1_1_1_0_0=null;
        Token ForOfOfKeyword_3_1_0_0_1_1_1_2_0_0=null;
        Token SemicolonKeyword_3_1_0_1_1_0_0=null;
        Token SemicolonKeyword_3_1_0_1_1_0_2=null;
        Token ForInInKeyword_3_1_0_1_1_1_0_0=null;
        Token ForOfOfKeyword_3_1_0_1_1_2_0_0=null;
        Token SemicolonKeyword_3_1_0_2_0=null;
        Token SemicolonKeyword_3_1_0_2_2=null;
        Token RightParenthesisKeyword_3_1_1=null;
        InternalN4JSParser.ruleLetIdentifierRef_return InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0 = null;

        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_3_0_0_2_0 = null;

        InternalN4JSParser.ruleBindingIdentifierAsVariableDeclaration_return VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0 = null;

        InternalN4JSParser.norm4_VariableDeclarationOrBinding_return VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0 = null;

        InternalN4JSParser.ruleVariableDeclarationOrBinding_return VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0 = null;

        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0 = null;

        InternalN4JSParser.norm1_Expression_return UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0 = null;

        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0 = null;

        InternalN4JSParser.ruleExpression_return InitExprExpressionParserRuleCall_3_1_0_1_0_0 = null;

        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0 = null;

        InternalN4JSParser.norm1_Expression_return UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0 = null;

        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0 = null;

        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_3_1_0_2_1_0 = null;

        InternalN4JSParser.norm1_Expression_return UpdateExprExpressionParserRuleCall_3_1_0_2_3_0 = null;

        InternalN4JSParser.ruleStatement_return StatementStatementParserRuleCall_4_0 = null;




        try {
            {
            {
            ForKeyword_1=(Token)match(input,For,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(ForKeyword_1, grammarAccess.getForStatementAccess().getForKeyword_1());
              	
            }
            LeftParenthesisKeyword_2=(Token)match(input,LeftParenthesis,FOLLOW_77); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_2, grammarAccess.getForStatementAccess().getLeftParenthesisKeyword_2());
              	
            }
            int alt188=2;
            alt188 = dfa188.predict(input);
            switch (alt188) {
                case 1 :
                    {
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_78);
                    InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0=ruleLetIdentifierRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      							announce((InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0!=null?((Token)InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0.start):null), (InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0!=null?((Token)InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0.stop):null), grammarAccess.getForStatementAccess().getInitExprAssignment_3_0_0_0());
                      						
                    }

                    }


                    }
                    {
                    {
                    ForInInKeyword_3_0_0_1_0=(Token)match(input,In,FOLLOW_49); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      							announce(ForInInKeyword_3_0_0_1_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_0_0_1_0());
                      						
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_72);
                    ExpressionExpressionParserRuleCall_3_0_0_2_0=norm1_Expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      							announce((ExpressionExpressionParserRuleCall_3_0_0_2_0!=null?((Token)ExpressionExpressionParserRuleCall_3_0_0_2_0.start):null), (ExpressionExpressionParserRuleCall_3_0_0_2_0!=null?((Token)ExpressionExpressionParserRuleCall_3_0_0_2_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_0_0_2());
                      						
                    }

                    }


                    }

                    RightParenthesisKeyword_3_0_0_3=(Token)match(input,RightParenthesis,FOLLOW_73); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce(RightParenthesisKeyword_3_0_0_3, grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_0_0_3());
                      				
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    int alt187=3;
                    alt187 = dfa187.predict(input);
                    switch (alt187) {
                        case 1 :
                            {
                            {
                            {
                            {
                            pushFollow(FOLLOW_27);
                            ruleVariableStatementKeyword();

                            state._fsp--;
                            if (state.failed) return retval;

                            }


                            }
                            int alt179=2;
                            alt179 = dfa179.predict(input);
                            switch (alt179) {
                                case 1 :
                                    {
                                    {
                                    {
                                    {
                                    {
                                    pushFollow(FOLLOW_79);
                                    VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0=ruleBindingIdentifierAsVariableDeclaration();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      											announce((VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0!=null?((Token)VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0.start):null), (VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0!=null?((Token)VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0.stop):null), grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_0_0_0());
                                      										
                                    }

                                    }


                                    }
                                    int alt171=2;
                                    int LA171_0 = input.LA(1);

                                    if ( (LA171_0==In) ) {
                                        alt171=1;
                                    }
                                    else if ( (LA171_0==Of) ) {
                                        alt171=2;
                                    }
                                    else {
                                        if (state.backtracking>0) {state.failed=true; return retval;}
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 171, 0, input);

                                        throw nvae;
                                    }
                                    switch (alt171) {
                                        case 1 :
                                            {
                                            {
                                            {
                                            ForInInKeyword_3_1_0_0_1_0_0_1_0_0=(Token)match(input,In,FOLLOW_80); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              												announce(ForInInKeyword_3_1_0_0_1_0_0_1_0_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_0_1_0_0_1_0_0());
                                              											
                                            }

                                            }


                                            }


                                            }
                                            break;
                                        case 2 :
                                            {
                                            {
                                            {
                                            ForOfOfKeyword_3_1_0_0_1_0_0_1_1_0=(Token)match(input,Of,FOLLOW_80); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              												announce(ForOfOfKeyword_3_1_0_0_1_0_0_1_1_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_0_1_0_0_1_1_0());
                                              											
                                            }

                                            }


                                            }


                                            }
                                            break;

                                    }
                                    int alt172=2;
                                    alt172 = dfa172.predict(input);
                                    switch (alt172) {
                                        case 1 :
                                            {
                                            {
                                            pushFollow(FOLLOW_72);
                                            ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0=norm1_AssignmentExpression();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              											announce((ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_0_0_2());
                                              										
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }


                                    }
                                    break;
                                case 2 :
                                    {
                                    {
                                    {
                                    {
                                    pushFollow(FOLLOW_81);
                                    VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0=norm4_VariableDeclarationOrBinding();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      										announce((VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0.start):null), (VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0.stop):null), grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_0());
                                      									
                                    }

                                    }


                                    }
                                    int alt178=3;
                                    switch ( input.LA(1) ) {
                                    case Comma:
                                    case Semicolon:
                                        {
                                        alt178=1;
                                        }
                                        break;
                                    case In:
                                        {
                                        alt178=2;
                                        }
                                        break;
                                    case Of:
                                        {
                                        alt178=3;
                                        }
                                        break;
                                    default:
                                        if (state.backtracking>0) {state.failed=true; return retval;}
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 178, 0, input);

                                        throw nvae;
                                    }

                                    switch (alt178) {
                                        case 1 :
                                            {
                                            {
                                            loop173:
                                            do {
                                                int alt173=2;
                                                int LA173_0 = input.LA(1);

                                                if ( (LA173_0==Comma) ) {
                                                    alt173=1;
                                                }


                                                switch (alt173) {
                                            	case 1 :
                                            	    {
                                            	    CommaKeyword_3_1_0_0_1_1_1_0_0_0=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return retval;
                                            	    if ( state.backtracking==0 ) {

                                            	      											announce(CommaKeyword_3_1_0_0_1_1_1_0_0_0, grammarAccess.getForStatementAccess().getCommaKeyword_3_1_0_0_1_1_1_0_0_0());
                                            	      										
                                            	    }
                                            	    {
                                            	    {
                                            	    pushFollow(FOLLOW_82);
                                            	    VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0=ruleVariableDeclarationOrBinding();

                                            	    state._fsp--;
                                            	    if (state.failed) return retval;
                                            	    if ( state.backtracking==0 ) {

                                            	      													announce((VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0.start):null), (VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0.stop):null), grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_1_0_0_1());
                                            	      												
                                            	    }

                                            	    }


                                            	    }


                                            	    }
                                            	    break;

                                            	default :
                                            	    break loop173;
                                                }
                                            } while (true);

                                            SemicolonKeyword_3_1_0_0_1_1_1_0_1=(Token)match(input,Semicolon,FOLLOW_83); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce(SemicolonKeyword_3_1_0_0_1_1_1_0_1, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_1());
                                              									
                                            }
                                            int alt174=2;
                                            int LA174_0 = input.LA(1);

                                            if ( ((LA174_0>=Intersection && LA174_0<=Implements)||(LA174_0>=Promisify && LA174_0<=Abstract)||(LA174_0>=External && LA174_0<=Function)||(LA174_0>=Private && LA174_0<=Delete)||(LA174_0>=Import && LA174_0<=Public)||LA174_0==Static||(LA174_0>=Target && LA174_0<=Await)||LA174_0==Class||(LA174_0>=False && LA174_0<=Super)||LA174_0==Union||(LA174_0>=Yield && LA174_0<=This)||(LA174_0>=From && LA174_0<=Void)||(LA174_0>=Get && LA174_0<=Set)||LA174_0==PlusSignPlusSign||LA174_0==HyphenMinusHyphenMinus||LA174_0==SolidusEqualsSign||LA174_0==As||LA174_0==Of||LA174_0==ExclamationMark||LA174_0==LeftParenthesis||LA174_0==PlusSign||LA174_0==HyphenMinus||LA174_0==Solidus||LA174_0==LessThanSign||(LA174_0>=CommercialAt && LA174_0<=LeftSquareBracket)||LA174_0==LeftCurlyBracket||LA174_0==Tilde||LA174_0==RULE_DOUBLE||(LA174_0>=RULE_HEX_INT && LA174_0<=RULE_LEGACY_OCTAL_INT)||LA174_0==RULE_SCIENTIFIC_INT||LA174_0==RULE_IDENTIFIER||LA174_0==RULE_STRING||(LA174_0>=RULE_TEMPLATE_HEAD && LA174_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA174_0==RULE_INT) ) {
                                                alt174=1;
                                            }
                                            switch (alt174) {
                                                case 1 :
                                                    {
                                                    {
                                                    pushFollow(FOLLOW_84);
                                                    ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0=norm1_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return retval;
                                                    if ( state.backtracking==0 ) {

                                                      												announce((ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0.start):null), (ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_0_2());
                                                      											
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }

                                            SemicolonKeyword_3_1_0_0_1_1_1_0_3=(Token)match(input,Semicolon,FOLLOW_80); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce(SemicolonKeyword_3_1_0_0_1_1_1_0_3, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_3());
                                              									
                                            }
                                            int alt175=2;
                                            int LA175_0 = input.LA(1);

                                            if ( ((LA175_0>=Intersection && LA175_0<=Implements)||(LA175_0>=Promisify && LA175_0<=Abstract)||(LA175_0>=External && LA175_0<=Function)||(LA175_0>=Private && LA175_0<=Delete)||(LA175_0>=Import && LA175_0<=Public)||LA175_0==Static||(LA175_0>=Target && LA175_0<=Await)||LA175_0==Class||(LA175_0>=False && LA175_0<=Super)||LA175_0==Union||(LA175_0>=Yield && LA175_0<=This)||(LA175_0>=From && LA175_0<=Void)||(LA175_0>=Get && LA175_0<=Set)||LA175_0==PlusSignPlusSign||LA175_0==HyphenMinusHyphenMinus||LA175_0==SolidusEqualsSign||LA175_0==As||LA175_0==Of||LA175_0==ExclamationMark||LA175_0==LeftParenthesis||LA175_0==PlusSign||LA175_0==HyphenMinus||LA175_0==Solidus||LA175_0==LessThanSign||(LA175_0>=CommercialAt && LA175_0<=LeftSquareBracket)||LA175_0==LeftCurlyBracket||LA175_0==Tilde||LA175_0==RULE_DOUBLE||(LA175_0>=RULE_HEX_INT && LA175_0<=RULE_LEGACY_OCTAL_INT)||LA175_0==RULE_SCIENTIFIC_INT||LA175_0==RULE_IDENTIFIER||LA175_0==RULE_STRING||(LA175_0>=RULE_TEMPLATE_HEAD && LA175_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA175_0==RULE_INT) ) {
                                                alt175=1;
                                            }
                                            switch (alt175) {
                                                case 1 :
                                                    {
                                                    {
                                                    pushFollow(FOLLOW_72);
                                                    UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0=norm1_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return retval;
                                                    if ( state.backtracking==0 ) {

                                                      												announce((UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0.start):null), (UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0.stop):null), grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_0_1_1_1_0_4());
                                                      											
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;
                                        case 2 :
                                            {
                                            {
                                            {
                                            {
                                            ForInInKeyword_3_1_0_0_1_1_1_1_0_0=(Token)match(input,In,FOLLOW_80); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              												announce(ForInInKeyword_3_1_0_0_1_1_1_1_0_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_0_1_1_1_1_0_0());
                                              											
                                            }

                                            }


                                            }
                                            int alt176=2;
                                            int LA176_0 = input.LA(1);

                                            if ( ((LA176_0>=Intersection && LA176_0<=Implements)||(LA176_0>=Promisify && LA176_0<=Abstract)||(LA176_0>=External && LA176_0<=Function)||(LA176_0>=Private && LA176_0<=Delete)||(LA176_0>=Import && LA176_0<=Public)||LA176_0==Static||(LA176_0>=Target && LA176_0<=Await)||LA176_0==Class||(LA176_0>=False && LA176_0<=Super)||LA176_0==Union||(LA176_0>=Yield && LA176_0<=This)||(LA176_0>=From && LA176_0<=Void)||(LA176_0>=Get && LA176_0<=Set)||LA176_0==PlusSignPlusSign||LA176_0==HyphenMinusHyphenMinus||LA176_0==SolidusEqualsSign||LA176_0==As||LA176_0==Of||LA176_0==ExclamationMark||LA176_0==LeftParenthesis||LA176_0==PlusSign||LA176_0==HyphenMinus||LA176_0==Solidus||LA176_0==LessThanSign||(LA176_0>=CommercialAt && LA176_0<=LeftSquareBracket)||LA176_0==LeftCurlyBracket||LA176_0==Tilde||LA176_0==RULE_DOUBLE||(LA176_0>=RULE_HEX_INT && LA176_0<=RULE_LEGACY_OCTAL_INT)||LA176_0==RULE_SCIENTIFIC_INT||LA176_0==RULE_IDENTIFIER||LA176_0==RULE_STRING||(LA176_0>=RULE_TEMPLATE_HEAD && LA176_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA176_0==RULE_INT) ) {
                                                alt176=1;
                                            }
                                            switch (alt176) {
                                                case 1 :
                                                    {
                                                    {
                                                    pushFollow(FOLLOW_72);
                                                    ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0=norm1_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return retval;
                                                    if ( state.backtracking==0 ) {

                                                      												announce((ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0.start):null), (ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_1_1());
                                                      											
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;
                                        case 3 :
                                            {
                                            {
                                            {
                                            {
                                            ForOfOfKeyword_3_1_0_0_1_1_1_2_0_0=(Token)match(input,Of,FOLLOW_80); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              												announce(ForOfOfKeyword_3_1_0_0_1_1_1_2_0_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_0_1_1_1_2_0_0());
                                              											
                                            }

                                            }


                                            }
                                            int alt177=2;
                                            int LA177_0 = input.LA(1);

                                            if ( ((LA177_0>=Intersection && LA177_0<=Implements)||(LA177_0>=Promisify && LA177_0<=Abstract)||(LA177_0>=External && LA177_0<=Function)||(LA177_0>=Private && LA177_0<=Delete)||(LA177_0>=Import && LA177_0<=Public)||LA177_0==Static||(LA177_0>=Target && LA177_0<=Await)||LA177_0==Class||(LA177_0>=False && LA177_0<=Super)||LA177_0==Union||(LA177_0>=Yield && LA177_0<=This)||(LA177_0>=From && LA177_0<=Void)||(LA177_0>=Get && LA177_0<=Set)||LA177_0==PlusSignPlusSign||LA177_0==HyphenMinusHyphenMinus||LA177_0==SolidusEqualsSign||LA177_0==As||LA177_0==Of||LA177_0==ExclamationMark||LA177_0==LeftParenthesis||LA177_0==PlusSign||LA177_0==HyphenMinus||LA177_0==Solidus||LA177_0==LessThanSign||(LA177_0>=CommercialAt && LA177_0<=LeftSquareBracket)||LA177_0==LeftCurlyBracket||LA177_0==Tilde||LA177_0==RULE_DOUBLE||(LA177_0>=RULE_HEX_INT && LA177_0<=RULE_LEGACY_OCTAL_INT)||LA177_0==RULE_SCIENTIFIC_INT||LA177_0==RULE_IDENTIFIER||LA177_0==RULE_STRING||(LA177_0>=RULE_TEMPLATE_HEAD && LA177_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA177_0==RULE_INT) ) {
                                                alt177=1;
                                            }
                                            switch (alt177) {
                                                case 1 :
                                                    {
                                                    {
                                                    pushFollow(FOLLOW_72);
                                                    ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0=norm1_AssignmentExpression();

                                                    state._fsp--;
                                                    if (state.failed) return retval;
                                                    if ( state.backtracking==0 ) {

                                                      												announce((ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_2_1());
                                                      											
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            {
                            {
                            pushFollow(FOLLOW_85);
                            InitExprExpressionParserRuleCall_3_1_0_1_0_0=ruleExpression();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              								announce((InitExprExpressionParserRuleCall_3_1_0_1_0_0!=null?((Token)InitExprExpressionParserRuleCall_3_1_0_1_0_0.start):null), (InitExprExpressionParserRuleCall_3_1_0_1_0_0!=null?((Token)InitExprExpressionParserRuleCall_3_1_0_1_0_0.stop):null), grammarAccess.getForStatementAccess().getInitExprAssignment_3_1_0_1_0());
                              							
                            }

                            }


                            }
                            int alt184=3;
                            switch ( input.LA(1) ) {
                            case Semicolon:
                                {
                                alt184=1;
                                }
                                break;
                            case In:
                                {
                                alt184=2;
                                }
                                break;
                            case Of:
                                {
                                alt184=3;
                                }
                                break;
                            default:
                                if (state.backtracking>0) {state.failed=true; return retval;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 184, 0, input);

                                throw nvae;
                            }

                            switch (alt184) {
                                case 1 :
                                    {
                                    {
                                    SemicolonKeyword_3_1_0_1_1_0_0=(Token)match(input,Semicolon,FOLLOW_83); if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce(SemicolonKeyword_3_1_0_1_1_0_0, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_0());
                                      							
                                    }
                                    int alt180=2;
                                    int LA180_0 = input.LA(1);

                                    if ( ((LA180_0>=Intersection && LA180_0<=Implements)||(LA180_0>=Promisify && LA180_0<=Abstract)||(LA180_0>=External && LA180_0<=Function)||(LA180_0>=Private && LA180_0<=Delete)||(LA180_0>=Import && LA180_0<=Public)||LA180_0==Static||(LA180_0>=Target && LA180_0<=Await)||LA180_0==Class||(LA180_0>=False && LA180_0<=Super)||LA180_0==Union||(LA180_0>=Yield && LA180_0<=This)||(LA180_0>=From && LA180_0<=Void)||(LA180_0>=Get && LA180_0<=Set)||LA180_0==PlusSignPlusSign||LA180_0==HyphenMinusHyphenMinus||LA180_0==SolidusEqualsSign||LA180_0==As||LA180_0==Of||LA180_0==ExclamationMark||LA180_0==LeftParenthesis||LA180_0==PlusSign||LA180_0==HyphenMinus||LA180_0==Solidus||LA180_0==LessThanSign||(LA180_0>=CommercialAt && LA180_0<=LeftSquareBracket)||LA180_0==LeftCurlyBracket||LA180_0==Tilde||LA180_0==RULE_DOUBLE||(LA180_0>=RULE_HEX_INT && LA180_0<=RULE_LEGACY_OCTAL_INT)||LA180_0==RULE_SCIENTIFIC_INT||LA180_0==RULE_IDENTIFIER||LA180_0==RULE_STRING||(LA180_0>=RULE_TEMPLATE_HEAD && LA180_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA180_0==RULE_INT) ) {
                                        alt180=1;
                                    }
                                    switch (alt180) {
                                        case 1 :
                                            {
                                            {
                                            pushFollow(FOLLOW_84);
                                            ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0=norm1_Expression();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce((ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0.start):null), (ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_0_1());
                                              									
                                            }

                                            }


                                            }
                                            break;

                                    }

                                    SemicolonKeyword_3_1_0_1_1_0_2=(Token)match(input,Semicolon,FOLLOW_80); if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce(SemicolonKeyword_3_1_0_1_1_0_2, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_2());
                                      							
                                    }
                                    int alt181=2;
                                    int LA181_0 = input.LA(1);

                                    if ( ((LA181_0>=Intersection && LA181_0<=Implements)||(LA181_0>=Promisify && LA181_0<=Abstract)||(LA181_0>=External && LA181_0<=Function)||(LA181_0>=Private && LA181_0<=Delete)||(LA181_0>=Import && LA181_0<=Public)||LA181_0==Static||(LA181_0>=Target && LA181_0<=Await)||LA181_0==Class||(LA181_0>=False && LA181_0<=Super)||LA181_0==Union||(LA181_0>=Yield && LA181_0<=This)||(LA181_0>=From && LA181_0<=Void)||(LA181_0>=Get && LA181_0<=Set)||LA181_0==PlusSignPlusSign||LA181_0==HyphenMinusHyphenMinus||LA181_0==SolidusEqualsSign||LA181_0==As||LA181_0==Of||LA181_0==ExclamationMark||LA181_0==LeftParenthesis||LA181_0==PlusSign||LA181_0==HyphenMinus||LA181_0==Solidus||LA181_0==LessThanSign||(LA181_0>=CommercialAt && LA181_0<=LeftSquareBracket)||LA181_0==LeftCurlyBracket||LA181_0==Tilde||LA181_0==RULE_DOUBLE||(LA181_0>=RULE_HEX_INT && LA181_0<=RULE_LEGACY_OCTAL_INT)||LA181_0==RULE_SCIENTIFIC_INT||LA181_0==RULE_IDENTIFIER||LA181_0==RULE_STRING||(LA181_0>=RULE_TEMPLATE_HEAD && LA181_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA181_0==RULE_INT) ) {
                                        alt181=1;
                                    }
                                    switch (alt181) {
                                        case 1 :
                                            {
                                            {
                                            pushFollow(FOLLOW_72);
                                            UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0=norm1_Expression();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce((UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0.start):null), (UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0.stop):null), grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_1_1_0_3());
                                              									
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;
                                case 2 :
                                    {
                                    {
                                    {
                                    {
                                    ForInInKeyword_3_1_0_1_1_1_0_0=(Token)match(input,In,FOLLOW_80); if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      										announce(ForInInKeyword_3_1_0_1_1_1_0_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_1_1_1_0_0());
                                      									
                                    }

                                    }


                                    }
                                    int alt182=2;
                                    int LA182_0 = input.LA(1);

                                    if ( ((LA182_0>=Intersection && LA182_0<=Implements)||(LA182_0>=Promisify && LA182_0<=Abstract)||(LA182_0>=External && LA182_0<=Function)||(LA182_0>=Private && LA182_0<=Delete)||(LA182_0>=Import && LA182_0<=Public)||LA182_0==Static||(LA182_0>=Target && LA182_0<=Await)||LA182_0==Class||(LA182_0>=False && LA182_0<=Super)||LA182_0==Union||(LA182_0>=Yield && LA182_0<=This)||(LA182_0>=From && LA182_0<=Void)||(LA182_0>=Get && LA182_0<=Set)||LA182_0==PlusSignPlusSign||LA182_0==HyphenMinusHyphenMinus||LA182_0==SolidusEqualsSign||LA182_0==As||LA182_0==Of||LA182_0==ExclamationMark||LA182_0==LeftParenthesis||LA182_0==PlusSign||LA182_0==HyphenMinus||LA182_0==Solidus||LA182_0==LessThanSign||(LA182_0>=CommercialAt && LA182_0<=LeftSquareBracket)||LA182_0==LeftCurlyBracket||LA182_0==Tilde||LA182_0==RULE_DOUBLE||(LA182_0>=RULE_HEX_INT && LA182_0<=RULE_LEGACY_OCTAL_INT)||LA182_0==RULE_SCIENTIFIC_INT||LA182_0==RULE_IDENTIFIER||LA182_0==RULE_STRING||(LA182_0>=RULE_TEMPLATE_HEAD && LA182_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA182_0==RULE_INT) ) {
                                        alt182=1;
                                    }
                                    switch (alt182) {
                                        case 1 :
                                            {
                                            {
                                            pushFollow(FOLLOW_72);
                                            ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0=norm1_Expression();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce((ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0.start):null), (ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_1_1());
                                              									
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;
                                case 3 :
                                    {
                                    {
                                    {
                                    {
                                    ForOfOfKeyword_3_1_0_1_1_2_0_0=(Token)match(input,Of,FOLLOW_80); if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      										announce(ForOfOfKeyword_3_1_0_1_1_2_0_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_1_1_2_0_0());
                                      									
                                    }

                                    }


                                    }
                                    int alt183=2;
                                    int LA183_0 = input.LA(1);

                                    if ( ((LA183_0>=Intersection && LA183_0<=Implements)||(LA183_0>=Promisify && LA183_0<=Abstract)||(LA183_0>=External && LA183_0<=Function)||(LA183_0>=Private && LA183_0<=Delete)||(LA183_0>=Import && LA183_0<=Public)||LA183_0==Static||(LA183_0>=Target && LA183_0<=Await)||LA183_0==Class||(LA183_0>=False && LA183_0<=Super)||LA183_0==Union||(LA183_0>=Yield && LA183_0<=This)||(LA183_0>=From && LA183_0<=Void)||(LA183_0>=Get && LA183_0<=Set)||LA183_0==PlusSignPlusSign||LA183_0==HyphenMinusHyphenMinus||LA183_0==SolidusEqualsSign||LA183_0==As||LA183_0==Of||LA183_0==ExclamationMark||LA183_0==LeftParenthesis||LA183_0==PlusSign||LA183_0==HyphenMinus||LA183_0==Solidus||LA183_0==LessThanSign||(LA183_0>=CommercialAt && LA183_0<=LeftSquareBracket)||LA183_0==LeftCurlyBracket||LA183_0==Tilde||LA183_0==RULE_DOUBLE||(LA183_0>=RULE_HEX_INT && LA183_0<=RULE_LEGACY_OCTAL_INT)||LA183_0==RULE_SCIENTIFIC_INT||LA183_0==RULE_IDENTIFIER||LA183_0==RULE_STRING||(LA183_0>=RULE_TEMPLATE_HEAD && LA183_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA183_0==RULE_INT) ) {
                                        alt183=1;
                                    }
                                    switch (alt183) {
                                        case 1 :
                                            {
                                            {
                                            pushFollow(FOLLOW_72);
                                            ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0=norm1_AssignmentExpression();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce((ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_2_1());
                                              									
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 3 :
                            {
                            {
                            SemicolonKeyword_3_1_0_2_0=(Token)match(input,Semicolon,FOLLOW_83); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(SemicolonKeyword_3_1_0_2_0, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_0());
                              					
                            }
                            int alt185=2;
                            int LA185_0 = input.LA(1);

                            if ( ((LA185_0>=Intersection && LA185_0<=Implements)||(LA185_0>=Promisify && LA185_0<=Abstract)||(LA185_0>=External && LA185_0<=Function)||(LA185_0>=Private && LA185_0<=Delete)||(LA185_0>=Import && LA185_0<=Public)||LA185_0==Static||(LA185_0>=Target && LA185_0<=Await)||LA185_0==Class||(LA185_0>=False && LA185_0<=Super)||LA185_0==Union||(LA185_0>=Yield && LA185_0<=This)||(LA185_0>=From && LA185_0<=Void)||(LA185_0>=Get && LA185_0<=Set)||LA185_0==PlusSignPlusSign||LA185_0==HyphenMinusHyphenMinus||LA185_0==SolidusEqualsSign||LA185_0==As||LA185_0==Of||LA185_0==ExclamationMark||LA185_0==LeftParenthesis||LA185_0==PlusSign||LA185_0==HyphenMinus||LA185_0==Solidus||LA185_0==LessThanSign||(LA185_0>=CommercialAt && LA185_0<=LeftSquareBracket)||LA185_0==LeftCurlyBracket||LA185_0==Tilde||LA185_0==RULE_DOUBLE||(LA185_0>=RULE_HEX_INT && LA185_0<=RULE_LEGACY_OCTAL_INT)||LA185_0==RULE_SCIENTIFIC_INT||LA185_0==RULE_IDENTIFIER||LA185_0==RULE_STRING||(LA185_0>=RULE_TEMPLATE_HEAD && LA185_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA185_0==RULE_INT) ) {
                                alt185=1;
                            }
                            switch (alt185) {
                                case 1 :
                                    {
                                    {
                                    pushFollow(FOLLOW_84);
                                    ExpressionExpressionParserRuleCall_3_1_0_2_1_0=norm1_Expression();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce((ExpressionExpressionParserRuleCall_3_1_0_2_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_2_1_0.start):null), (ExpressionExpressionParserRuleCall_3_1_0_2_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_2_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_2_1());
                                      							
                                    }

                                    }


                                    }
                                    break;

                            }

                            SemicolonKeyword_3_1_0_2_2=(Token)match(input,Semicolon,FOLLOW_80); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(SemicolonKeyword_3_1_0_2_2, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_2());
                              					
                            }
                            int alt186=2;
                            int LA186_0 = input.LA(1);

                            if ( ((LA186_0>=Intersection && LA186_0<=Implements)||(LA186_0>=Promisify && LA186_0<=Abstract)||(LA186_0>=External && LA186_0<=Function)||(LA186_0>=Private && LA186_0<=Delete)||(LA186_0>=Import && LA186_0<=Public)||LA186_0==Static||(LA186_0>=Target && LA186_0<=Await)||LA186_0==Class||(LA186_0>=False && LA186_0<=Super)||LA186_0==Union||(LA186_0>=Yield && LA186_0<=This)||(LA186_0>=From && LA186_0<=Void)||(LA186_0>=Get && LA186_0<=Set)||LA186_0==PlusSignPlusSign||LA186_0==HyphenMinusHyphenMinus||LA186_0==SolidusEqualsSign||LA186_0==As||LA186_0==Of||LA186_0==ExclamationMark||LA186_0==LeftParenthesis||LA186_0==PlusSign||LA186_0==HyphenMinus||LA186_0==Solidus||LA186_0==LessThanSign||(LA186_0>=CommercialAt && LA186_0<=LeftSquareBracket)||LA186_0==LeftCurlyBracket||LA186_0==Tilde||LA186_0==RULE_DOUBLE||(LA186_0>=RULE_HEX_INT && LA186_0<=RULE_LEGACY_OCTAL_INT)||LA186_0==RULE_SCIENTIFIC_INT||LA186_0==RULE_IDENTIFIER||LA186_0==RULE_STRING||(LA186_0>=RULE_TEMPLATE_HEAD && LA186_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA186_0==RULE_INT) ) {
                                alt186=1;
                            }
                            switch (alt186) {
                                case 1 :
                                    {
                                    {
                                    pushFollow(FOLLOW_72);
                                    UpdateExprExpressionParserRuleCall_3_1_0_2_3_0=norm1_Expression();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce((UpdateExprExpressionParserRuleCall_3_1_0_2_3_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_2_3_0.start):null), (UpdateExprExpressionParserRuleCall_3_1_0_2_3_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_2_3_0.stop):null), grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_2_3());
                                      							
                                    }

                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;

                    }

                    RightParenthesisKeyword_3_1_1=(Token)match(input,RightParenthesis,FOLLOW_73); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(RightParenthesisKeyword_3_1_1, grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_1_1());
                      			
                    }

                    }


                    }
                    break;

            }
            {
            {
            pushFollow(FOLLOW_2);
            StatementStatementParserRuleCall_4_0=ruleStatement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.start):null), (StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.stop):null), grammarAccess.getForStatementAccess().getStatementAssignment_4());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ForStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ForStatement_return norm1_ForStatement() throws RecognitionException {
        InternalN4JSParser.norm1_ForStatement_return retval = new InternalN4JSParser.norm1_ForStatement_return();
        retval.start = input.LT(1);

        Token ForKeyword_1=null;
        Token LeftParenthesisKeyword_2=null;
        Token ForInInKeyword_3_0_0_1_0=null;
        Token RightParenthesisKeyword_3_0_0_3=null;
        Token ForInInKeyword_3_1_0_0_1_0_0_1_0_0=null;
        Token ForOfOfKeyword_3_1_0_0_1_0_0_1_1_0=null;
        Token CommaKeyword_3_1_0_0_1_1_1_0_0_0=null;
        Token SemicolonKeyword_3_1_0_0_1_1_1_0_1=null;
        Token SemicolonKeyword_3_1_0_0_1_1_1_0_3=null;
        Token ForInInKeyword_3_1_0_0_1_1_1_1_0_0=null;
        Token ForOfOfKeyword_3_1_0_0_1_1_1_2_0_0=null;
        Token SemicolonKeyword_3_1_0_1_1_0_0=null;
        Token SemicolonKeyword_3_1_0_1_1_0_2=null;
        Token ForInInKeyword_3_1_0_1_1_1_0_0=null;
        Token ForOfOfKeyword_3_1_0_1_1_2_0_0=null;
        Token SemicolonKeyword_3_1_0_2_0=null;
        Token SemicolonKeyword_3_1_0_2_2=null;
        Token RightParenthesisKeyword_3_1_1=null;
        InternalN4JSParser.ruleLetIdentifierRef_return InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0 = null;

        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_3_0_0_2_0 = null;

        InternalN4JSParser.norm2_BindingIdentifierAsVariableDeclaration_return VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0 = null;

        InternalN4JSParser.norm6_VariableDeclarationOrBinding_return VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0 = null;

        InternalN4JSParser.norm2_VariableDeclarationOrBinding_return VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0 = null;

        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0 = null;

        InternalN4JSParser.norm3_Expression_return UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0 = null;

        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0 = null;

        InternalN4JSParser.norm2_Expression_return InitExprExpressionParserRuleCall_3_1_0_1_0_0 = null;

        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0 = null;

        InternalN4JSParser.norm3_Expression_return UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0 = null;

        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0 = null;

        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_3_1_0_2_1_0 = null;

        InternalN4JSParser.norm3_Expression_return UpdateExprExpressionParserRuleCall_3_1_0_2_3_0 = null;

        InternalN4JSParser.norm1_Statement_return StatementStatementParserRuleCall_4_0 = null;




        try {
            {
            {
            ForKeyword_1=(Token)match(input,For,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(ForKeyword_1, grammarAccess.getForStatementAccess().getForKeyword_1());
              	
            }
            LeftParenthesisKeyword_2=(Token)match(input,LeftParenthesis,FOLLOW_86); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_2, grammarAccess.getForStatementAccess().getLeftParenthesisKeyword_2());
              	
            }
            int alt206=2;
            alt206 = dfa206.predict(input);
            switch (alt206) {
                case 1 :
                    {
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_78);
                    InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0=ruleLetIdentifierRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      							announce((InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0!=null?((Token)InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0.start):null), (InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0!=null?((Token)InitExprLetIdentifierRefParserRuleCall_3_0_0_0_0.stop):null), grammarAccess.getForStatementAccess().getInitExprAssignment_3_0_0_0());
                      						
                    }

                    }


                    }
                    {
                    {
                    ForInInKeyword_3_0_0_1_0=(Token)match(input,In,FOLLOW_70); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      							announce(ForInInKeyword_3_0_0_1_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_0_0_1_0());
                      						
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_72);
                    ExpressionExpressionParserRuleCall_3_0_0_2_0=norm3_Expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      							announce((ExpressionExpressionParserRuleCall_3_0_0_2_0!=null?((Token)ExpressionExpressionParserRuleCall_3_0_0_2_0.start):null), (ExpressionExpressionParserRuleCall_3_0_0_2_0!=null?((Token)ExpressionExpressionParserRuleCall_3_0_0_2_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_0_0_2());
                      						
                    }

                    }


                    }

                    RightParenthesisKeyword_3_0_0_3=(Token)match(input,RightParenthesis,FOLLOW_75); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce(RightParenthesisKeyword_3_0_0_3, grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_0_0_3());
                      				
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    int alt205=3;
                    alt205 = dfa205.predict(input);
                    switch (alt205) {
                        case 1 :
                            {
                            {
                            {
                            {
                            pushFollow(FOLLOW_27);
                            ruleVariableStatementKeyword();

                            state._fsp--;
                            if (state.failed) return retval;

                            }


                            }
                            int alt197=2;
                            alt197 = dfa197.predict(input);
                            switch (alt197) {
                                case 1 :
                                    {
                                    {
                                    {
                                    {
                                    {
                                    pushFollow(FOLLOW_79);
                                    VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0=norm2_BindingIdentifierAsVariableDeclaration();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      											announce((VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0!=null?((Token)VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0.start):null), (VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0!=null?((Token)VarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0.stop):null), grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_0_0_0());
                                      										
                                    }

                                    }


                                    }
                                    int alt189=2;
                                    int LA189_0 = input.LA(1);

                                    if ( (LA189_0==In) ) {
                                        alt189=1;
                                    }
                                    else if ( (LA189_0==Of) ) {
                                        alt189=2;
                                    }
                                    else {
                                        if (state.backtracking>0) {state.failed=true; return retval;}
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 189, 0, input);

                                        throw nvae;
                                    }
                                    switch (alt189) {
                                        case 1 :
                                            {
                                            {
                                            {
                                            ForInInKeyword_3_1_0_0_1_0_0_1_0_0=(Token)match(input,In,FOLLOW_87); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              												announce(ForInInKeyword_3_1_0_0_1_0_0_1_0_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_0_1_0_0_1_0_0());
                                              											
                                            }

                                            }


                                            }


                                            }
                                            break;
                                        case 2 :
                                            {
                                            {
                                            {
                                            ForOfOfKeyword_3_1_0_0_1_0_0_1_1_0=(Token)match(input,Of,FOLLOW_87); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              												announce(ForOfOfKeyword_3_1_0_0_1_0_0_1_1_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_0_1_0_0_1_1_0());
                                              											
                                            }

                                            }


                                            }


                                            }
                                            break;

                                    }
                                    int alt190=2;
                                    alt190 = dfa190.predict(input);
                                    switch (alt190) {
                                        case 1 :
                                            {
                                            {
                                            pushFollow(FOLLOW_72);
                                            ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0=norm3_AssignmentExpression();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              											announce((ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_0_0_2());
                                              										
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }


                                    }
                                    break;
                                case 2 :
                                    {
                                    {
                                    {
                                    {
                                    pushFollow(FOLLOW_81);
                                    VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0=norm6_VariableDeclarationOrBinding();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      										announce((VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0.start):null), (VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0.stop):null), grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_0());
                                      									
                                    }

                                    }


                                    }
                                    int alt196=3;
                                    switch ( input.LA(1) ) {
                                    case Comma:
                                    case Semicolon:
                                        {
                                        alt196=1;
                                        }
                                        break;
                                    case In:
                                        {
                                        alt196=2;
                                        }
                                        break;
                                    case Of:
                                        {
                                        alt196=3;
                                        }
                                        break;
                                    default:
                                        if (state.backtracking>0) {state.failed=true; return retval;}
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 196, 0, input);

                                        throw nvae;
                                    }

                                    switch (alt196) {
                                        case 1 :
                                            {
                                            {
                                            loop191:
                                            do {
                                                int alt191=2;
                                                int LA191_0 = input.LA(1);

                                                if ( (LA191_0==Comma) ) {
                                                    alt191=1;
                                                }


                                                switch (alt191) {
                                            	case 1 :
                                            	    {
                                            	    CommaKeyword_3_1_0_0_1_1_1_0_0_0=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return retval;
                                            	    if ( state.backtracking==0 ) {

                                            	      											announce(CommaKeyword_3_1_0_0_1_1_1_0_0_0, grammarAccess.getForStatementAccess().getCommaKeyword_3_1_0_0_1_1_1_0_0_0());
                                            	      										
                                            	    }
                                            	    {
                                            	    {
                                            	    pushFollow(FOLLOW_82);
                                            	    VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0=norm2_VariableDeclarationOrBinding();

                                            	    state._fsp--;
                                            	    if (state.failed) return retval;
                                            	    if ( state.backtracking==0 ) {

                                            	      													announce((VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0.start):null), (VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0!=null?((Token)VarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0.stop):null), grammarAccess.getForStatementAccess().getVarDeclsOrBindingsAssignment_3_1_0_0_1_1_1_0_0_1());
                                            	      												
                                            	    }

                                            	    }


                                            	    }


                                            	    }
                                            	    break;

                                            	default :
                                            	    break loop191;
                                                }
                                            } while (true);

                                            SemicolonKeyword_3_1_0_0_1_1_1_0_1=(Token)match(input,Semicolon,FOLLOW_88); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce(SemicolonKeyword_3_1_0_0_1_1_1_0_1, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_1());
                                              									
                                            }
                                            int alt192=2;
                                            int LA192_0 = input.LA(1);

                                            if ( ((LA192_0>=Intersection && LA192_0<=Implements)||(LA192_0>=Promisify && LA192_0<=Abstract)||(LA192_0>=External && LA192_0<=Function)||(LA192_0>=Private && LA192_0<=Delete)||(LA192_0>=Import && LA192_0<=Public)||LA192_0==Static||(LA192_0>=Target && LA192_0<=Await)||LA192_0==Class||(LA192_0>=False && LA192_0<=Super)||LA192_0==Union||(LA192_0>=Yield && LA192_0<=This)||(LA192_0>=From && LA192_0<=Void)||(LA192_0>=Get && LA192_0<=Set)||LA192_0==PlusSignPlusSign||LA192_0==HyphenMinusHyphenMinus||LA192_0==SolidusEqualsSign||LA192_0==As||LA192_0==Of||LA192_0==ExclamationMark||LA192_0==LeftParenthesis||LA192_0==PlusSign||LA192_0==HyphenMinus||LA192_0==Solidus||LA192_0==LessThanSign||(LA192_0>=CommercialAt && LA192_0<=LeftSquareBracket)||LA192_0==LeftCurlyBracket||LA192_0==Tilde||LA192_0==RULE_DOUBLE||(LA192_0>=RULE_HEX_INT && LA192_0<=RULE_LEGACY_OCTAL_INT)||LA192_0==RULE_SCIENTIFIC_INT||LA192_0==RULE_IDENTIFIER||LA192_0==RULE_STRING||(LA192_0>=RULE_TEMPLATE_HEAD && LA192_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA192_0==RULE_INT) ) {
                                                alt192=1;
                                            }
                                            switch (alt192) {
                                                case 1 :
                                                    {
                                                    {
                                                    pushFollow(FOLLOW_84);
                                                    ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0=norm3_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return retval;
                                                    if ( state.backtracking==0 ) {

                                                      												announce((ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0.start):null), (ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_0_2());
                                                      											
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }

                                            SemicolonKeyword_3_1_0_0_1_1_1_0_3=(Token)match(input,Semicolon,FOLLOW_87); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce(SemicolonKeyword_3_1_0_0_1_1_1_0_3, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_3());
                                              									
                                            }
                                            int alt193=2;
                                            int LA193_0 = input.LA(1);

                                            if ( ((LA193_0>=Intersection && LA193_0<=Implements)||(LA193_0>=Promisify && LA193_0<=Abstract)||(LA193_0>=External && LA193_0<=Function)||(LA193_0>=Private && LA193_0<=Delete)||(LA193_0>=Import && LA193_0<=Public)||LA193_0==Static||(LA193_0>=Target && LA193_0<=Await)||LA193_0==Class||(LA193_0>=False && LA193_0<=Super)||LA193_0==Union||(LA193_0>=Yield && LA193_0<=This)||(LA193_0>=From && LA193_0<=Void)||(LA193_0>=Get && LA193_0<=Set)||LA193_0==PlusSignPlusSign||LA193_0==HyphenMinusHyphenMinus||LA193_0==SolidusEqualsSign||LA193_0==As||LA193_0==Of||LA193_0==ExclamationMark||LA193_0==LeftParenthesis||LA193_0==PlusSign||LA193_0==HyphenMinus||LA193_0==Solidus||LA193_0==LessThanSign||(LA193_0>=CommercialAt && LA193_0<=LeftSquareBracket)||LA193_0==LeftCurlyBracket||LA193_0==Tilde||LA193_0==RULE_DOUBLE||(LA193_0>=RULE_HEX_INT && LA193_0<=RULE_LEGACY_OCTAL_INT)||LA193_0==RULE_SCIENTIFIC_INT||LA193_0==RULE_IDENTIFIER||LA193_0==RULE_STRING||(LA193_0>=RULE_TEMPLATE_HEAD && LA193_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA193_0==RULE_INT) ) {
                                                alt193=1;
                                            }
                                            switch (alt193) {
                                                case 1 :
                                                    {
                                                    {
                                                    pushFollow(FOLLOW_72);
                                                    UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0=norm3_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return retval;
                                                    if ( state.backtracking==0 ) {

                                                      												announce((UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0.start):null), (UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0.stop):null), grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_0_1_1_1_0_4());
                                                      											
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;
                                        case 2 :
                                            {
                                            {
                                            {
                                            {
                                            ForInInKeyword_3_1_0_0_1_1_1_1_0_0=(Token)match(input,In,FOLLOW_87); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              												announce(ForInInKeyword_3_1_0_0_1_1_1_1_0_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_0_1_1_1_1_0_0());
                                              											
                                            }

                                            }


                                            }
                                            int alt194=2;
                                            int LA194_0 = input.LA(1);

                                            if ( ((LA194_0>=Intersection && LA194_0<=Implements)||(LA194_0>=Promisify && LA194_0<=Abstract)||(LA194_0>=External && LA194_0<=Function)||(LA194_0>=Private && LA194_0<=Delete)||(LA194_0>=Import && LA194_0<=Public)||LA194_0==Static||(LA194_0>=Target && LA194_0<=Await)||LA194_0==Class||(LA194_0>=False && LA194_0<=Super)||LA194_0==Union||(LA194_0>=Yield && LA194_0<=This)||(LA194_0>=From && LA194_0<=Void)||(LA194_0>=Get && LA194_0<=Set)||LA194_0==PlusSignPlusSign||LA194_0==HyphenMinusHyphenMinus||LA194_0==SolidusEqualsSign||LA194_0==As||LA194_0==Of||LA194_0==ExclamationMark||LA194_0==LeftParenthesis||LA194_0==PlusSign||LA194_0==HyphenMinus||LA194_0==Solidus||LA194_0==LessThanSign||(LA194_0>=CommercialAt && LA194_0<=LeftSquareBracket)||LA194_0==LeftCurlyBracket||LA194_0==Tilde||LA194_0==RULE_DOUBLE||(LA194_0>=RULE_HEX_INT && LA194_0<=RULE_LEGACY_OCTAL_INT)||LA194_0==RULE_SCIENTIFIC_INT||LA194_0==RULE_IDENTIFIER||LA194_0==RULE_STRING||(LA194_0>=RULE_TEMPLATE_HEAD && LA194_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA194_0==RULE_INT) ) {
                                                alt194=1;
                                            }
                                            switch (alt194) {
                                                case 1 :
                                                    {
                                                    {
                                                    pushFollow(FOLLOW_72);
                                                    ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0=norm3_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return retval;
                                                    if ( state.backtracking==0 ) {

                                                      												announce((ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0.start):null), (ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_1_1());
                                                      											
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;
                                        case 3 :
                                            {
                                            {
                                            {
                                            {
                                            ForOfOfKeyword_3_1_0_0_1_1_1_2_0_0=(Token)match(input,Of,FOLLOW_87); if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              												announce(ForOfOfKeyword_3_1_0_0_1_1_1_2_0_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_0_1_1_1_2_0_0());
                                              											
                                            }

                                            }


                                            }
                                            int alt195=2;
                                            int LA195_0 = input.LA(1);

                                            if ( ((LA195_0>=Intersection && LA195_0<=Implements)||(LA195_0>=Promisify && LA195_0<=Abstract)||(LA195_0>=External && LA195_0<=Function)||(LA195_0>=Private && LA195_0<=Delete)||(LA195_0>=Import && LA195_0<=Public)||LA195_0==Static||(LA195_0>=Target && LA195_0<=Await)||LA195_0==Class||(LA195_0>=False && LA195_0<=Super)||LA195_0==Union||(LA195_0>=Yield && LA195_0<=This)||(LA195_0>=From && LA195_0<=Void)||(LA195_0>=Get && LA195_0<=Set)||LA195_0==PlusSignPlusSign||LA195_0==HyphenMinusHyphenMinus||LA195_0==SolidusEqualsSign||LA195_0==As||LA195_0==Of||LA195_0==ExclamationMark||LA195_0==LeftParenthesis||LA195_0==PlusSign||LA195_0==HyphenMinus||LA195_0==Solidus||LA195_0==LessThanSign||(LA195_0>=CommercialAt && LA195_0<=LeftSquareBracket)||LA195_0==LeftCurlyBracket||LA195_0==Tilde||LA195_0==RULE_DOUBLE||(LA195_0>=RULE_HEX_INT && LA195_0<=RULE_LEGACY_OCTAL_INT)||LA195_0==RULE_SCIENTIFIC_INT||LA195_0==RULE_IDENTIFIER||LA195_0==RULE_STRING||(LA195_0>=RULE_TEMPLATE_HEAD && LA195_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA195_0==RULE_INT) ) {
                                                alt195=1;
                                            }
                                            switch (alt195) {
                                                case 1 :
                                                    {
                                                    {
                                                    pushFollow(FOLLOW_72);
                                                    ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0=norm3_AssignmentExpression();

                                                    state._fsp--;
                                                    if (state.failed) return retval;
                                                    if ( state.backtracking==0 ) {

                                                      												announce((ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_0_1_1_1_2_1());
                                                      											
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            {
                            {
                            pushFollow(FOLLOW_85);
                            InitExprExpressionParserRuleCall_3_1_0_1_0_0=norm2_Expression();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              								announce((InitExprExpressionParserRuleCall_3_1_0_1_0_0!=null?((Token)InitExprExpressionParserRuleCall_3_1_0_1_0_0.start):null), (InitExprExpressionParserRuleCall_3_1_0_1_0_0!=null?((Token)InitExprExpressionParserRuleCall_3_1_0_1_0_0.stop):null), grammarAccess.getForStatementAccess().getInitExprAssignment_3_1_0_1_0());
                              							
                            }

                            }


                            }
                            int alt202=3;
                            switch ( input.LA(1) ) {
                            case Semicolon:
                                {
                                alt202=1;
                                }
                                break;
                            case In:
                                {
                                alt202=2;
                                }
                                break;
                            case Of:
                                {
                                alt202=3;
                                }
                                break;
                            default:
                                if (state.backtracking>0) {state.failed=true; return retval;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 202, 0, input);

                                throw nvae;
                            }

                            switch (alt202) {
                                case 1 :
                                    {
                                    {
                                    SemicolonKeyword_3_1_0_1_1_0_0=(Token)match(input,Semicolon,FOLLOW_88); if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce(SemicolonKeyword_3_1_0_1_1_0_0, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_0());
                                      							
                                    }
                                    int alt198=2;
                                    int LA198_0 = input.LA(1);

                                    if ( ((LA198_0>=Intersection && LA198_0<=Implements)||(LA198_0>=Promisify && LA198_0<=Abstract)||(LA198_0>=External && LA198_0<=Function)||(LA198_0>=Private && LA198_0<=Delete)||(LA198_0>=Import && LA198_0<=Public)||LA198_0==Static||(LA198_0>=Target && LA198_0<=Await)||LA198_0==Class||(LA198_0>=False && LA198_0<=Super)||LA198_0==Union||(LA198_0>=Yield && LA198_0<=This)||(LA198_0>=From && LA198_0<=Void)||(LA198_0>=Get && LA198_0<=Set)||LA198_0==PlusSignPlusSign||LA198_0==HyphenMinusHyphenMinus||LA198_0==SolidusEqualsSign||LA198_0==As||LA198_0==Of||LA198_0==ExclamationMark||LA198_0==LeftParenthesis||LA198_0==PlusSign||LA198_0==HyphenMinus||LA198_0==Solidus||LA198_0==LessThanSign||(LA198_0>=CommercialAt && LA198_0<=LeftSquareBracket)||LA198_0==LeftCurlyBracket||LA198_0==Tilde||LA198_0==RULE_DOUBLE||(LA198_0>=RULE_HEX_INT && LA198_0<=RULE_LEGACY_OCTAL_INT)||LA198_0==RULE_SCIENTIFIC_INT||LA198_0==RULE_IDENTIFIER||LA198_0==RULE_STRING||(LA198_0>=RULE_TEMPLATE_HEAD && LA198_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA198_0==RULE_INT) ) {
                                        alt198=1;
                                    }
                                    switch (alt198) {
                                        case 1 :
                                            {
                                            {
                                            pushFollow(FOLLOW_84);
                                            ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0=norm3_Expression();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce((ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0.start):null), (ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_0_1());
                                              									
                                            }

                                            }


                                            }
                                            break;

                                    }

                                    SemicolonKeyword_3_1_0_1_1_0_2=(Token)match(input,Semicolon,FOLLOW_87); if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce(SemicolonKeyword_3_1_0_1_1_0_2, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_2());
                                      							
                                    }
                                    int alt199=2;
                                    int LA199_0 = input.LA(1);

                                    if ( ((LA199_0>=Intersection && LA199_0<=Implements)||(LA199_0>=Promisify && LA199_0<=Abstract)||(LA199_0>=External && LA199_0<=Function)||(LA199_0>=Private && LA199_0<=Delete)||(LA199_0>=Import && LA199_0<=Public)||LA199_0==Static||(LA199_0>=Target && LA199_0<=Await)||LA199_0==Class||(LA199_0>=False && LA199_0<=Super)||LA199_0==Union||(LA199_0>=Yield && LA199_0<=This)||(LA199_0>=From && LA199_0<=Void)||(LA199_0>=Get && LA199_0<=Set)||LA199_0==PlusSignPlusSign||LA199_0==HyphenMinusHyphenMinus||LA199_0==SolidusEqualsSign||LA199_0==As||LA199_0==Of||LA199_0==ExclamationMark||LA199_0==LeftParenthesis||LA199_0==PlusSign||LA199_0==HyphenMinus||LA199_0==Solidus||LA199_0==LessThanSign||(LA199_0>=CommercialAt && LA199_0<=LeftSquareBracket)||LA199_0==LeftCurlyBracket||LA199_0==Tilde||LA199_0==RULE_DOUBLE||(LA199_0>=RULE_HEX_INT && LA199_0<=RULE_LEGACY_OCTAL_INT)||LA199_0==RULE_SCIENTIFIC_INT||LA199_0==RULE_IDENTIFIER||LA199_0==RULE_STRING||(LA199_0>=RULE_TEMPLATE_HEAD && LA199_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA199_0==RULE_INT) ) {
                                        alt199=1;
                                    }
                                    switch (alt199) {
                                        case 1 :
                                            {
                                            {
                                            pushFollow(FOLLOW_72);
                                            UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0=norm3_Expression();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce((UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0.start):null), (UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0.stop):null), grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_1_1_0_3());
                                              									
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;
                                case 2 :
                                    {
                                    {
                                    {
                                    {
                                    ForInInKeyword_3_1_0_1_1_1_0_0=(Token)match(input,In,FOLLOW_87); if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      										announce(ForInInKeyword_3_1_0_1_1_1_0_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_1_1_1_0_0());
                                      									
                                    }

                                    }


                                    }
                                    int alt200=2;
                                    int LA200_0 = input.LA(1);

                                    if ( ((LA200_0>=Intersection && LA200_0<=Implements)||(LA200_0>=Promisify && LA200_0<=Abstract)||(LA200_0>=External && LA200_0<=Function)||(LA200_0>=Private && LA200_0<=Delete)||(LA200_0>=Import && LA200_0<=Public)||LA200_0==Static||(LA200_0>=Target && LA200_0<=Await)||LA200_0==Class||(LA200_0>=False && LA200_0<=Super)||LA200_0==Union||(LA200_0>=Yield && LA200_0<=This)||(LA200_0>=From && LA200_0<=Void)||(LA200_0>=Get && LA200_0<=Set)||LA200_0==PlusSignPlusSign||LA200_0==HyphenMinusHyphenMinus||LA200_0==SolidusEqualsSign||LA200_0==As||LA200_0==Of||LA200_0==ExclamationMark||LA200_0==LeftParenthesis||LA200_0==PlusSign||LA200_0==HyphenMinus||LA200_0==Solidus||LA200_0==LessThanSign||(LA200_0>=CommercialAt && LA200_0<=LeftSquareBracket)||LA200_0==LeftCurlyBracket||LA200_0==Tilde||LA200_0==RULE_DOUBLE||(LA200_0>=RULE_HEX_INT && LA200_0<=RULE_LEGACY_OCTAL_INT)||LA200_0==RULE_SCIENTIFIC_INT||LA200_0==RULE_IDENTIFIER||LA200_0==RULE_STRING||(LA200_0>=RULE_TEMPLATE_HEAD && LA200_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA200_0==RULE_INT) ) {
                                        alt200=1;
                                    }
                                    switch (alt200) {
                                        case 1 :
                                            {
                                            {
                                            pushFollow(FOLLOW_72);
                                            ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0=norm3_Expression();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce((ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0.start):null), (ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_1_1());
                                              									
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;
                                case 3 :
                                    {
                                    {
                                    {
                                    {
                                    ForOfOfKeyword_3_1_0_1_1_2_0_0=(Token)match(input,Of,FOLLOW_87); if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      										announce(ForOfOfKeyword_3_1_0_1_1_2_0_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_1_1_2_0_0());
                                      									
                                    }

                                    }


                                    }
                                    int alt201=2;
                                    int LA201_0 = input.LA(1);

                                    if ( ((LA201_0>=Intersection && LA201_0<=Implements)||(LA201_0>=Promisify && LA201_0<=Abstract)||(LA201_0>=External && LA201_0<=Function)||(LA201_0>=Private && LA201_0<=Delete)||(LA201_0>=Import && LA201_0<=Public)||LA201_0==Static||(LA201_0>=Target && LA201_0<=Await)||LA201_0==Class||(LA201_0>=False && LA201_0<=Super)||LA201_0==Union||(LA201_0>=Yield && LA201_0<=This)||(LA201_0>=From && LA201_0<=Void)||(LA201_0>=Get && LA201_0<=Set)||LA201_0==PlusSignPlusSign||LA201_0==HyphenMinusHyphenMinus||LA201_0==SolidusEqualsSign||LA201_0==As||LA201_0==Of||LA201_0==ExclamationMark||LA201_0==LeftParenthesis||LA201_0==PlusSign||LA201_0==HyphenMinus||LA201_0==Solidus||LA201_0==LessThanSign||(LA201_0>=CommercialAt && LA201_0<=LeftSquareBracket)||LA201_0==LeftCurlyBracket||LA201_0==Tilde||LA201_0==RULE_DOUBLE||(LA201_0>=RULE_HEX_INT && LA201_0<=RULE_LEGACY_OCTAL_INT)||LA201_0==RULE_SCIENTIFIC_INT||LA201_0==RULE_IDENTIFIER||LA201_0==RULE_STRING||(LA201_0>=RULE_TEMPLATE_HEAD && LA201_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA201_0==RULE_INT) ) {
                                        alt201=1;
                                    }
                                    switch (alt201) {
                                        case 1 :
                                            {
                                            {
                                            pushFollow(FOLLOW_72);
                                            ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0=norm3_AssignmentExpression();

                                            state._fsp--;
                                            if (state.failed) return retval;
                                            if ( state.backtracking==0 ) {

                                              										announce((ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_1_1_2_1());
                                              									
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 3 :
                            {
                            {
                            SemicolonKeyword_3_1_0_2_0=(Token)match(input,Semicolon,FOLLOW_88); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(SemicolonKeyword_3_1_0_2_0, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_0());
                              					
                            }
                            int alt203=2;
                            int LA203_0 = input.LA(1);

                            if ( ((LA203_0>=Intersection && LA203_0<=Implements)||(LA203_0>=Promisify && LA203_0<=Abstract)||(LA203_0>=External && LA203_0<=Function)||(LA203_0>=Private && LA203_0<=Delete)||(LA203_0>=Import && LA203_0<=Public)||LA203_0==Static||(LA203_0>=Target && LA203_0<=Await)||LA203_0==Class||(LA203_0>=False && LA203_0<=Super)||LA203_0==Union||(LA203_0>=Yield && LA203_0<=This)||(LA203_0>=From && LA203_0<=Void)||(LA203_0>=Get && LA203_0<=Set)||LA203_0==PlusSignPlusSign||LA203_0==HyphenMinusHyphenMinus||LA203_0==SolidusEqualsSign||LA203_0==As||LA203_0==Of||LA203_0==ExclamationMark||LA203_0==LeftParenthesis||LA203_0==PlusSign||LA203_0==HyphenMinus||LA203_0==Solidus||LA203_0==LessThanSign||(LA203_0>=CommercialAt && LA203_0<=LeftSquareBracket)||LA203_0==LeftCurlyBracket||LA203_0==Tilde||LA203_0==RULE_DOUBLE||(LA203_0>=RULE_HEX_INT && LA203_0<=RULE_LEGACY_OCTAL_INT)||LA203_0==RULE_SCIENTIFIC_INT||LA203_0==RULE_IDENTIFIER||LA203_0==RULE_STRING||(LA203_0>=RULE_TEMPLATE_HEAD && LA203_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA203_0==RULE_INT) ) {
                                alt203=1;
                            }
                            switch (alt203) {
                                case 1 :
                                    {
                                    {
                                    pushFollow(FOLLOW_84);
                                    ExpressionExpressionParserRuleCall_3_1_0_2_1_0=norm3_Expression();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce((ExpressionExpressionParserRuleCall_3_1_0_2_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_2_1_0.start):null), (ExpressionExpressionParserRuleCall_3_1_0_2_1_0!=null?((Token)ExpressionExpressionParserRuleCall_3_1_0_2_1_0.stop):null), grammarAccess.getForStatementAccess().getExpressionAssignment_3_1_0_2_1());
                                      							
                                    }

                                    }


                                    }
                                    break;

                            }

                            SemicolonKeyword_3_1_0_2_2=(Token)match(input,Semicolon,FOLLOW_87); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(SemicolonKeyword_3_1_0_2_2, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_2());
                              					
                            }
                            int alt204=2;
                            int LA204_0 = input.LA(1);

                            if ( ((LA204_0>=Intersection && LA204_0<=Implements)||(LA204_0>=Promisify && LA204_0<=Abstract)||(LA204_0>=External && LA204_0<=Function)||(LA204_0>=Private && LA204_0<=Delete)||(LA204_0>=Import && LA204_0<=Public)||LA204_0==Static||(LA204_0>=Target && LA204_0<=Await)||LA204_0==Class||(LA204_0>=False && LA204_0<=Super)||LA204_0==Union||(LA204_0>=Yield && LA204_0<=This)||(LA204_0>=From && LA204_0<=Void)||(LA204_0>=Get && LA204_0<=Set)||LA204_0==PlusSignPlusSign||LA204_0==HyphenMinusHyphenMinus||LA204_0==SolidusEqualsSign||LA204_0==As||LA204_0==Of||LA204_0==ExclamationMark||LA204_0==LeftParenthesis||LA204_0==PlusSign||LA204_0==HyphenMinus||LA204_0==Solidus||LA204_0==LessThanSign||(LA204_0>=CommercialAt && LA204_0<=LeftSquareBracket)||LA204_0==LeftCurlyBracket||LA204_0==Tilde||LA204_0==RULE_DOUBLE||(LA204_0>=RULE_HEX_INT && LA204_0<=RULE_LEGACY_OCTAL_INT)||LA204_0==RULE_SCIENTIFIC_INT||LA204_0==RULE_IDENTIFIER||LA204_0==RULE_STRING||(LA204_0>=RULE_TEMPLATE_HEAD && LA204_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA204_0==RULE_INT) ) {
                                alt204=1;
                            }
                            switch (alt204) {
                                case 1 :
                                    {
                                    {
                                    pushFollow(FOLLOW_72);
                                    UpdateExprExpressionParserRuleCall_3_1_0_2_3_0=norm3_Expression();

                                    state._fsp--;
                                    if (state.failed) return retval;
                                    if ( state.backtracking==0 ) {

                                      								announce((UpdateExprExpressionParserRuleCall_3_1_0_2_3_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_2_3_0.start):null), (UpdateExprExpressionParserRuleCall_3_1_0_2_3_0!=null?((Token)UpdateExprExpressionParserRuleCall_3_1_0_2_3_0.stop):null), grammarAccess.getForStatementAccess().getUpdateExprAssignment_3_1_0_2_3());
                                      							
                                    }

                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;

                    }

                    RightParenthesisKeyword_3_1_1=(Token)match(input,RightParenthesis,FOLLOW_75); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(RightParenthesisKeyword_3_1_1, grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_1_1());
                      			
                    }

                    }


                    }
                    break;

            }
            {
            {
            pushFollow(FOLLOW_2);
            StatementStatementParserRuleCall_4_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.start):null), (StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.stop):null), grammarAccess.getForStatementAccess().getStatementAssignment_4());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleLetIdentifierRef() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleLetIdentifierRef();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleLetIdentifierRef_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleLetIdentifierRef_return ruleLetIdentifierRef() throws RecognitionException {
        InternalN4JSParser.ruleLetIdentifierRef_return retval = new InternalN4JSParser.ruleLetIdentifierRef_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleLetAsIdentifier_return IdIdentifiableElementLetAsIdentifierParserRuleCall_0_1 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_2);
            IdIdentifiableElementLetAsIdentifierParserRuleCall_0_1=ruleLetAsIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce((IdIdentifiableElementLetAsIdentifierParserRuleCall_0_1!=null?((Token)IdIdentifiableElementLetAsIdentifierParserRuleCall_0_1.start):null), (IdIdentifiableElementLetAsIdentifierParserRuleCall_0_1!=null?((Token)IdIdentifiableElementLetAsIdentifierParserRuleCall_0_1.stop):null), grammarAccess.getLetIdentifierRefAccess().getIdAssignment());
              		
            }

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleLetAsIdentifier() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleLetAsIdentifier();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleLetAsIdentifier_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleLetAsIdentifier_return ruleLetAsIdentifier() throws RecognitionException {
        InternalN4JSParser.ruleLetAsIdentifier_return retval = new InternalN4JSParser.ruleLetAsIdentifier_return();
        retval.start = input.LT(1);

        Token LetKeyword=null;



        try {
            {
            LetKeyword=(Token)match(input,Let,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              	announce(LetKeyword, grammarAccess.getLetAsIdentifierAccess().getLetKeyword());

            }

            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleBindingIdentifierAsVariableDeclaration() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleBindingIdentifierAsVariableDeclaration();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleBindingIdentifierAsVariableDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleBindingIdentifierAsVariableDeclaration_return ruleBindingIdentifierAsVariableDeclaration() throws RecognitionException {
        InternalN4JSParser.ruleBindingIdentifierAsVariableDeclaration_return retval = new InternalN4JSParser.ruleBindingIdentifierAsVariableDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_0 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_2);
            NameBindingIdentifierParserRuleCall_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce((NameBindingIdentifierParserRuleCall_0!=null?((Token)NameBindingIdentifierParserRuleCall_0.start):null), (NameBindingIdentifierParserRuleCall_0!=null?((Token)NameBindingIdentifierParserRuleCall_0.stop):null), grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameAssignment());
              		
            }

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm2_BindingIdentifierAsVariableDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm2_BindingIdentifierAsVariableDeclaration_return norm2_BindingIdentifierAsVariableDeclaration() throws RecognitionException {
        InternalN4JSParser.norm2_BindingIdentifierAsVariableDeclaration_return retval = new InternalN4JSParser.norm2_BindingIdentifierAsVariableDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_0 = null;




        try {
            {
            {
            {
            pushFollow(FOLLOW_2);
            NameBindingIdentifierParserRuleCall_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              			announce((NameBindingIdentifierParserRuleCall_0!=null?((Token)NameBindingIdentifierParserRuleCall_0.start):null), (NameBindingIdentifierParserRuleCall_0!=null?((Token)NameBindingIdentifierParserRuleCall_0.stop):null), grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameAssignment());
              		
            }

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleContinueStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleContinueStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleContinueStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleContinueStatement_return ruleContinueStatement() throws RecognitionException {
        InternalN4JSParser.ruleContinueStatement_return retval = new InternalN4JSParser.ruleContinueStatement_return();
        retval.start = input.LT(1);

        Token ContinueKeyword_1=null;
        InternalN4JSParser.ruleBindingIdentifier_return LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_3 = null;




        try {
            {
            {
            ContinueKeyword_1=(Token)match(input,Continue,FOLLOW_89); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		promoteEOL();
              		announce(ContinueKeyword_1, grammarAccess.getContinueStatementAccess().getContinueKeyword_1());
              	
            }
            int alt207=2;
            int LA207_0 = input.LA(1);

            if ( ((LA207_0>=Intersection && LA207_0<=Implements)||(LA207_0>=Promisify && LA207_0<=Abstract)||LA207_0==External||(LA207_0>=Private && LA207_0<=Project)||LA207_0==Public||LA207_0==Static||LA207_0==Target||(LA207_0>=Async && LA207_0<=Await)||LA207_0==Union||(LA207_0>=Yield && LA207_0<=This)||LA207_0==From||LA207_0==Type||(LA207_0>=Get && LA207_0<=Let)||(LA207_0>=Out && LA207_0<=Set)||LA207_0==As||LA207_0==Of||LA207_0==RULE_IDENTIFIER) ) {
                alt207=1;
            }
            switch (alt207) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_18);
                    LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1!=null?((Token)LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1.start):null), (LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1!=null?((Token)LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1.stop):null), grammarAccess.getContinueStatementAccess().getLabelAssignment_2());
                      			
                    }

                    }


                    }
                    break;

            }

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_3=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.start):null), (SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.stop):null), grammarAccess.getContinueStatementAccess().getSemiParserRuleCall_3()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ContinueStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ContinueStatement_return norm1_ContinueStatement() throws RecognitionException {
        InternalN4JSParser.norm1_ContinueStatement_return retval = new InternalN4JSParser.norm1_ContinueStatement_return();
        retval.start = input.LT(1);

        Token ContinueKeyword_1=null;
        InternalN4JSParser.norm1_BindingIdentifier_return LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_3 = null;




        try {
            {
            {
            ContinueKeyword_1=(Token)match(input,Continue,FOLLOW_89); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		promoteEOL();
              		announce(ContinueKeyword_1, grammarAccess.getContinueStatementAccess().getContinueKeyword_1());
              	
            }
            int alt208=2;
            int LA208_0 = input.LA(1);

            if ( ((LA208_0>=Intersection && LA208_0<=Implements)||(LA208_0>=Promisify && LA208_0<=Abstract)||LA208_0==External||(LA208_0>=Private && LA208_0<=Project)||LA208_0==Public||LA208_0==Static||LA208_0==Target||(LA208_0>=Async && LA208_0<=Await)||LA208_0==Union||LA208_0==This||LA208_0==From||LA208_0==Type||(LA208_0>=Get && LA208_0<=Let)||(LA208_0>=Out && LA208_0<=Set)||LA208_0==As||LA208_0==Of||LA208_0==RULE_IDENTIFIER) ) {
                alt208=1;
            }
            switch (alt208) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_18);
                    LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1!=null?((Token)LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1.start):null), (LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1!=null?((Token)LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1.stop):null), grammarAccess.getContinueStatementAccess().getLabelAssignment_2());
                      			
                    }

                    }


                    }
                    break;

            }

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_3=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.start):null), (SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.stop):null), grammarAccess.getContinueStatementAccess().getSemiParserRuleCall_3()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleBreakStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleBreakStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleBreakStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleBreakStatement_return ruleBreakStatement() throws RecognitionException {
        InternalN4JSParser.ruleBreakStatement_return retval = new InternalN4JSParser.ruleBreakStatement_return();
        retval.start = input.LT(1);

        Token BreakKeyword_1=null;
        InternalN4JSParser.ruleBindingIdentifier_return LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_3 = null;




        try {
            {
            {
            BreakKeyword_1=(Token)match(input,Break,FOLLOW_89); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		promoteEOL();
              		announce(BreakKeyword_1, grammarAccess.getBreakStatementAccess().getBreakKeyword_1());
              	
            }
            int alt209=2;
            int LA209_0 = input.LA(1);

            if ( ((LA209_0>=Intersection && LA209_0<=Implements)||(LA209_0>=Promisify && LA209_0<=Abstract)||LA209_0==External||(LA209_0>=Private && LA209_0<=Project)||LA209_0==Public||LA209_0==Static||LA209_0==Target||(LA209_0>=Async && LA209_0<=Await)||LA209_0==Union||(LA209_0>=Yield && LA209_0<=This)||LA209_0==From||LA209_0==Type||(LA209_0>=Get && LA209_0<=Let)||(LA209_0>=Out && LA209_0<=Set)||LA209_0==As||LA209_0==Of||LA209_0==RULE_IDENTIFIER) ) {
                alt209=1;
            }
            switch (alt209) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_18);
                    LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1!=null?((Token)LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1.start):null), (LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1!=null?((Token)LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1.stop):null), grammarAccess.getBreakStatementAccess().getLabelAssignment_2());
                      			
                    }

                    }


                    }
                    break;

            }

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_3=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.start):null), (SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.stop):null), grammarAccess.getBreakStatementAccess().getSemiParserRuleCall_3()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_BreakStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_BreakStatement_return norm1_BreakStatement() throws RecognitionException {
        InternalN4JSParser.norm1_BreakStatement_return retval = new InternalN4JSParser.norm1_BreakStatement_return();
        retval.start = input.LT(1);

        Token BreakKeyword_1=null;
        InternalN4JSParser.norm1_BindingIdentifier_return LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_3 = null;




        try {
            {
            {
            BreakKeyword_1=(Token)match(input,Break,FOLLOW_89); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		promoteEOL();
              		announce(BreakKeyword_1, grammarAccess.getBreakStatementAccess().getBreakKeyword_1());
              	
            }
            int alt210=2;
            int LA210_0 = input.LA(1);

            if ( ((LA210_0>=Intersection && LA210_0<=Implements)||(LA210_0>=Promisify && LA210_0<=Abstract)||LA210_0==External||(LA210_0>=Private && LA210_0<=Project)||LA210_0==Public||LA210_0==Static||LA210_0==Target||(LA210_0>=Async && LA210_0<=Await)||LA210_0==Union||LA210_0==This||LA210_0==From||LA210_0==Type||(LA210_0>=Get && LA210_0<=Let)||(LA210_0>=Out && LA210_0<=Set)||LA210_0==As||LA210_0==Of||LA210_0==RULE_IDENTIFIER) ) {
                alt210=1;
            }
            switch (alt210) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_18);
                    LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1!=null?((Token)LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1.start):null), (LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1!=null?((Token)LabelLabelledStatementBindingIdentifierParserRuleCall_2_0_1.stop):null), grammarAccess.getBreakStatementAccess().getLabelAssignment_2());
                      			
                    }

                    }


                    }
                    break;

            }

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_3=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.start):null), (SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.stop):null), grammarAccess.getBreakStatementAccess().getSemiParserRuleCall_3()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleReturnStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleReturnStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleReturnStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleReturnStatement_return ruleReturnStatement() throws RecognitionException {
        InternalN4JSParser.ruleReturnStatement_return retval = new InternalN4JSParser.ruleReturnStatement_return();
        retval.start = input.LT(1);

        Token ReturnKeyword_1=null;
        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_2_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_3 = null;




        try {
            {
            {
            ReturnKeyword_1=(Token)match(input,Return,FOLLOW_90); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		promoteEOL();
              		announce(ReturnKeyword_1, grammarAccess.getReturnStatementAccess().getReturnKeyword_1());
              	
            }
            int alt211=2;
            int LA211_0 = input.LA(1);

            if ( ((LA211_0>=Intersection && LA211_0<=Implements)||(LA211_0>=Promisify && LA211_0<=Abstract)||(LA211_0>=External && LA211_0<=Function)||(LA211_0>=Private && LA211_0<=Delete)||(LA211_0>=Import && LA211_0<=Public)||LA211_0==Static||(LA211_0>=Target && LA211_0<=Await)||LA211_0==Class||(LA211_0>=False && LA211_0<=Super)||LA211_0==Union||(LA211_0>=Yield && LA211_0<=This)||(LA211_0>=From && LA211_0<=Void)||(LA211_0>=Get && LA211_0<=Set)||LA211_0==PlusSignPlusSign||LA211_0==HyphenMinusHyphenMinus||LA211_0==SolidusEqualsSign||LA211_0==As||LA211_0==Of||LA211_0==ExclamationMark||LA211_0==LeftParenthesis||LA211_0==PlusSign||LA211_0==HyphenMinus||LA211_0==Solidus||LA211_0==LessThanSign||(LA211_0>=CommercialAt && LA211_0<=LeftSquareBracket)||LA211_0==LeftCurlyBracket||LA211_0==Tilde||LA211_0==RULE_DOUBLE||(LA211_0>=RULE_HEX_INT && LA211_0<=RULE_LEGACY_OCTAL_INT)||LA211_0==RULE_SCIENTIFIC_INT||LA211_0==RULE_IDENTIFIER||LA211_0==RULE_STRING||(LA211_0>=RULE_TEMPLATE_HEAD && LA211_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA211_0==RULE_INT) ) {
                alt211=1;
            }
            switch (alt211) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_18);
                    ExpressionExpressionParserRuleCall_2_0=norm1_Expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.start):null), (ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.stop):null), grammarAccess.getReturnStatementAccess().getExpressionAssignment_2());
                      			
                    }

                    }


                    }
                    break;

            }

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_3=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.start):null), (SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.stop):null), grammarAccess.getReturnStatementAccess().getSemiParserRuleCall_3()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ReturnStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ReturnStatement_return norm1_ReturnStatement() throws RecognitionException {
        InternalN4JSParser.norm1_ReturnStatement_return retval = new InternalN4JSParser.norm1_ReturnStatement_return();
        retval.start = input.LT(1);

        Token ReturnKeyword_1=null;
        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_2_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_3 = null;




        try {
            {
            {
            ReturnKeyword_1=(Token)match(input,Return,FOLLOW_91); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		promoteEOL();
              		announce(ReturnKeyword_1, grammarAccess.getReturnStatementAccess().getReturnKeyword_1());
              	
            }
            int alt212=2;
            int LA212_0 = input.LA(1);

            if ( ((LA212_0>=Intersection && LA212_0<=Implements)||(LA212_0>=Promisify && LA212_0<=Abstract)||(LA212_0>=External && LA212_0<=Function)||(LA212_0>=Private && LA212_0<=Delete)||(LA212_0>=Import && LA212_0<=Public)||LA212_0==Static||(LA212_0>=Target && LA212_0<=Await)||LA212_0==Class||(LA212_0>=False && LA212_0<=Super)||LA212_0==Union||(LA212_0>=Yield && LA212_0<=This)||(LA212_0>=From && LA212_0<=Void)||(LA212_0>=Get && LA212_0<=Set)||LA212_0==PlusSignPlusSign||LA212_0==HyphenMinusHyphenMinus||LA212_0==SolidusEqualsSign||LA212_0==As||LA212_0==Of||LA212_0==ExclamationMark||LA212_0==LeftParenthesis||LA212_0==PlusSign||LA212_0==HyphenMinus||LA212_0==Solidus||LA212_0==LessThanSign||(LA212_0>=CommercialAt && LA212_0<=LeftSquareBracket)||LA212_0==LeftCurlyBracket||LA212_0==Tilde||LA212_0==RULE_DOUBLE||(LA212_0>=RULE_HEX_INT && LA212_0<=RULE_LEGACY_OCTAL_INT)||LA212_0==RULE_SCIENTIFIC_INT||LA212_0==RULE_IDENTIFIER||LA212_0==RULE_STRING||(LA212_0>=RULE_TEMPLATE_HEAD && LA212_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA212_0==RULE_INT) ) {
                alt212=1;
            }
            switch (alt212) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_18);
                    ExpressionExpressionParserRuleCall_2_0=norm3_Expression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.start):null), (ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.stop):null), grammarAccess.getReturnStatementAccess().getExpressionAssignment_2());
                      			
                    }

                    }


                    }
                    break;

            }

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_3=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.start):null), (SemiParserRuleCall_3!=null?((Token)SemiParserRuleCall_3.stop):null), grammarAccess.getReturnStatementAccess().getSemiParserRuleCall_3()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleWithStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleWithStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleWithStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleWithStatement_return ruleWithStatement() throws RecognitionException {
        InternalN4JSParser.ruleWithStatement_return retval = new InternalN4JSParser.ruleWithStatement_return();
        retval.start = input.LT(1);

        Token WithKeyword_0=null;
        Token LeftParenthesisKeyword_1=null;
        Token RightParenthesisKeyword_3=null;
        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_2_0 = null;

        InternalN4JSParser.ruleStatement_return StatementStatementParserRuleCall_4_0 = null;




        try {
            {
            {
            WithKeyword_0=(Token)match(input,With,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(WithKeyword_0, grammarAccess.getWithStatementAccess().getWithKeyword_0());
              	
            }
            LeftParenthesisKeyword_1=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_1, grammarAccess.getWithStatementAccess().getLeftParenthesisKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_2_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.start):null), (ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.stop):null), grammarAccess.getWithStatementAccess().getExpressionAssignment_2());
              			
            }

            }


            }

            RightParenthesisKeyword_3=(Token)match(input,RightParenthesis,FOLLOW_73); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_3, grammarAccess.getWithStatementAccess().getRightParenthesisKeyword_3());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            StatementStatementParserRuleCall_4_0=ruleStatement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.start):null), (StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.stop):null), grammarAccess.getWithStatementAccess().getStatementAssignment_4());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_WithStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_WithStatement_return norm1_WithStatement() throws RecognitionException {
        InternalN4JSParser.norm1_WithStatement_return retval = new InternalN4JSParser.norm1_WithStatement_return();
        retval.start = input.LT(1);

        Token WithKeyword_0=null;
        Token LeftParenthesisKeyword_1=null;
        Token RightParenthesisKeyword_3=null;
        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_2_0 = null;

        InternalN4JSParser.norm1_Statement_return StatementStatementParserRuleCall_4_0 = null;




        try {
            {
            {
            WithKeyword_0=(Token)match(input,With,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(WithKeyword_0, grammarAccess.getWithStatementAccess().getWithKeyword_0());
              	
            }
            LeftParenthesisKeyword_1=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_1, grammarAccess.getWithStatementAccess().getLeftParenthesisKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_2_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.start):null), (ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.stop):null), grammarAccess.getWithStatementAccess().getExpressionAssignment_2());
              			
            }

            }


            }

            RightParenthesisKeyword_3=(Token)match(input,RightParenthesis,FOLLOW_75); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_3, grammarAccess.getWithStatementAccess().getRightParenthesisKeyword_3());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            StatementStatementParserRuleCall_4_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.start):null), (StatementStatementParserRuleCall_4_0!=null?((Token)StatementStatementParserRuleCall_4_0.stop):null), grammarAccess.getWithStatementAccess().getStatementAssignment_4());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleSwitchStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleSwitchStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleSwitchStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleSwitchStatement_return ruleSwitchStatement() throws RecognitionException {
        InternalN4JSParser.ruleSwitchStatement_return retval = new InternalN4JSParser.ruleSwitchStatement_return();
        retval.start = input.LT(1);

        Token SwitchKeyword_0=null;
        Token LeftParenthesisKeyword_1=null;
        Token RightParenthesisKeyword_3=null;
        Token LeftCurlyBracketKeyword_4=null;
        Token RightCurlyBracketKeyword_7=null;
        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_2_0 = null;

        InternalN4JSParser.ruleCaseClause_return CasesCaseClauseParserRuleCall_5_0 = null;

        InternalN4JSParser.ruleDefaultClause_return CasesDefaultClauseParserRuleCall_6_0_0 = null;

        InternalN4JSParser.ruleCaseClause_return CasesCaseClauseParserRuleCall_6_1_0 = null;




        try {
            {
            {
            SwitchKeyword_0=(Token)match(input,Switch,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(SwitchKeyword_0, grammarAccess.getSwitchStatementAccess().getSwitchKeyword_0());
              	
            }
            LeftParenthesisKeyword_1=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_1, grammarAccess.getSwitchStatementAccess().getLeftParenthesisKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_2_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.start):null), (ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.stop):null), grammarAccess.getSwitchStatementAccess().getExpressionAssignment_2());
              			
            }

            }


            }

            RightParenthesisKeyword_3=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_3, grammarAccess.getSwitchStatementAccess().getRightParenthesisKeyword_3());
              	
            }
            LeftCurlyBracketKeyword_4=(Token)match(input,LeftCurlyBracket,FOLLOW_92); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftCurlyBracketKeyword_4, grammarAccess.getSwitchStatementAccess().getLeftCurlyBracketKeyword_4());
              	
            }
            loop213:
            do {
                int alt213=2;
                int LA213_0 = input.LA(1);

                if ( (LA213_0==Case) ) {
                    alt213=1;
                }


                switch (alt213) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_92);
            	    CasesCaseClauseParserRuleCall_5_0=ruleCaseClause();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((CasesCaseClauseParserRuleCall_5_0!=null?((Token)CasesCaseClauseParserRuleCall_5_0.start):null), (CasesCaseClauseParserRuleCall_5_0!=null?((Token)CasesCaseClauseParserRuleCall_5_0.stop):null), grammarAccess.getSwitchStatementAccess().getCasesAssignment_5());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop213;
                }
            } while (true);
            int alt215=2;
            int LA215_0 = input.LA(1);

            if ( (LA215_0==Default) ) {
                alt215=1;
            }
            switch (alt215) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_93);
                    CasesDefaultClauseParserRuleCall_6_0_0=ruleDefaultClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((CasesDefaultClauseParserRuleCall_6_0_0!=null?((Token)CasesDefaultClauseParserRuleCall_6_0_0.start):null), (CasesDefaultClauseParserRuleCall_6_0_0!=null?((Token)CasesDefaultClauseParserRuleCall_6_0_0.stop):null), grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_0());
                      				
                    }

                    }


                    }
                    loop214:
                    do {
                        int alt214=2;
                        int LA214_0 = input.LA(1);

                        if ( (LA214_0==Case) ) {
                            alt214=1;
                        }


                        switch (alt214) {
                    	case 1 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_93);
                    	    CasesCaseClauseParserRuleCall_6_1_0=ruleCaseClause();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      					announce((CasesCaseClauseParserRuleCall_6_1_0!=null?((Token)CasesCaseClauseParserRuleCall_6_1_0.start):null), (CasesCaseClauseParserRuleCall_6_1_0!=null?((Token)CasesCaseClauseParserRuleCall_6_1_0.stop):null), grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_1());
                    	      				
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop214;
                        }
                    } while (true);


                    }
                    break;

            }

            RightCurlyBracketKeyword_7=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightCurlyBracketKeyword_7, grammarAccess.getSwitchStatementAccess().getRightCurlyBracketKeyword_7());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_SwitchStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_SwitchStatement_return norm1_SwitchStatement() throws RecognitionException {
        InternalN4JSParser.norm1_SwitchStatement_return retval = new InternalN4JSParser.norm1_SwitchStatement_return();
        retval.start = input.LT(1);

        Token SwitchKeyword_0=null;
        Token LeftParenthesisKeyword_1=null;
        Token RightParenthesisKeyword_3=null;
        Token LeftCurlyBracketKeyword_4=null;
        Token RightCurlyBracketKeyword_7=null;
        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_2_0 = null;

        InternalN4JSParser.norm1_CaseClause_return CasesCaseClauseParserRuleCall_5_0 = null;

        InternalN4JSParser.norm1_DefaultClause_return CasesDefaultClauseParserRuleCall_6_0_0 = null;

        InternalN4JSParser.norm1_CaseClause_return CasesCaseClauseParserRuleCall_6_1_0 = null;




        try {
            {
            {
            SwitchKeyword_0=(Token)match(input,Switch,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(SwitchKeyword_0, grammarAccess.getSwitchStatementAccess().getSwitchKeyword_0());
              	
            }
            LeftParenthesisKeyword_1=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_1, grammarAccess.getSwitchStatementAccess().getLeftParenthesisKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_2_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.start):null), (ExpressionExpressionParserRuleCall_2_0!=null?((Token)ExpressionExpressionParserRuleCall_2_0.stop):null), grammarAccess.getSwitchStatementAccess().getExpressionAssignment_2());
              			
            }

            }


            }

            RightParenthesisKeyword_3=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_3, grammarAccess.getSwitchStatementAccess().getRightParenthesisKeyword_3());
              	
            }
            LeftCurlyBracketKeyword_4=(Token)match(input,LeftCurlyBracket,FOLLOW_92); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftCurlyBracketKeyword_4, grammarAccess.getSwitchStatementAccess().getLeftCurlyBracketKeyword_4());
              	
            }
            loop216:
            do {
                int alt216=2;
                int LA216_0 = input.LA(1);

                if ( (LA216_0==Case) ) {
                    alt216=1;
                }


                switch (alt216) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_92);
            	    CasesCaseClauseParserRuleCall_5_0=norm1_CaseClause();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((CasesCaseClauseParserRuleCall_5_0!=null?((Token)CasesCaseClauseParserRuleCall_5_0.start):null), (CasesCaseClauseParserRuleCall_5_0!=null?((Token)CasesCaseClauseParserRuleCall_5_0.stop):null), grammarAccess.getSwitchStatementAccess().getCasesAssignment_5());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop216;
                }
            } while (true);
            int alt218=2;
            int LA218_0 = input.LA(1);

            if ( (LA218_0==Default) ) {
                alt218=1;
            }
            switch (alt218) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_93);
                    CasesDefaultClauseParserRuleCall_6_0_0=norm1_DefaultClause();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((CasesDefaultClauseParserRuleCall_6_0_0!=null?((Token)CasesDefaultClauseParserRuleCall_6_0_0.start):null), (CasesDefaultClauseParserRuleCall_6_0_0!=null?((Token)CasesDefaultClauseParserRuleCall_6_0_0.stop):null), grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_0());
                      				
                    }

                    }


                    }
                    loop217:
                    do {
                        int alt217=2;
                        int LA217_0 = input.LA(1);

                        if ( (LA217_0==Case) ) {
                            alt217=1;
                        }


                        switch (alt217) {
                    	case 1 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_93);
                    	    CasesCaseClauseParserRuleCall_6_1_0=norm1_CaseClause();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      					announce((CasesCaseClauseParserRuleCall_6_1_0!=null?((Token)CasesCaseClauseParserRuleCall_6_1_0.start):null), (CasesCaseClauseParserRuleCall_6_1_0!=null?((Token)CasesCaseClauseParserRuleCall_6_1_0.stop):null), grammarAccess.getSwitchStatementAccess().getCasesAssignment_6_1());
                    	      				
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop217;
                        }
                    } while (true);


                    }
                    break;

            }

            RightCurlyBracketKeyword_7=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightCurlyBracketKeyword_7, grammarAccess.getSwitchStatementAccess().getRightCurlyBracketKeyword_7());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleCaseClause() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleCaseClause();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleCaseClause_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleCaseClause_return ruleCaseClause() throws RecognitionException {
        InternalN4JSParser.ruleCaseClause_return retval = new InternalN4JSParser.ruleCaseClause_return();
        retval.start = input.LT(1);

        Token CaseKeyword_0=null;
        Token ColonKeyword_2=null;
        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleStatement_return StatementsStatementParserRuleCall_3_0 = null;




        try {
            {
            {
            CaseKeyword_0=(Token)match(input,Case,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(CaseKeyword_0, grammarAccess.getCaseClauseAccess().getCaseKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_94);
            ExpressionExpressionParserRuleCall_1_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.start):null), (ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.stop):null), grammarAccess.getCaseClauseAccess().getExpressionAssignment_1());
              			
            }

            }


            }

            ColonKeyword_2=(Token)match(input,Colon,FOLLOW_3); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(ColonKeyword_2, grammarAccess.getCaseClauseAccess().getColonKeyword_2());
              	
            }
            loop219:
            do {
                int alt219=2;
                int LA219_0 = input.LA(1);

                if ( ((LA219_0>=Intersection && LA219_0<=Implements)||(LA219_0>=Promisify && LA219_0<=Function)||(LA219_0>=Private && LA219_0<=Delete)||(LA219_0>=Import && LA219_0<=Break)||(LA219_0>=Class && LA219_0<=This)||(LA219_0>=From && LA219_0<=With)||(LA219_0>=For && LA219_0<=Var)||LA219_0==PlusSignPlusSign||LA219_0==HyphenMinusHyphenMinus||LA219_0==SolidusEqualsSign||(LA219_0>=As && LA219_0<=If)||LA219_0==Of||LA219_0==ExclamationMark||LA219_0==LeftParenthesis||LA219_0==PlusSign||LA219_0==HyphenMinus||LA219_0==Solidus||(LA219_0>=Semicolon && LA219_0<=LessThanSign)||(LA219_0>=CommercialAt && LA219_0<=LeftSquareBracket)||LA219_0==LeftCurlyBracket||LA219_0==Tilde||LA219_0==RULE_DOUBLE||(LA219_0>=RULE_HEX_INT && LA219_0<=RULE_LEGACY_OCTAL_INT)||LA219_0==RULE_SCIENTIFIC_INT||LA219_0==RULE_IDENTIFIER||LA219_0==RULE_STRING||(LA219_0>=RULE_TEMPLATE_HEAD && LA219_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA219_0==RULE_INT) ) {
                    alt219=1;
                }


                switch (alt219) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_3);
            	    StatementsStatementParserRuleCall_3_0=ruleStatement();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((StatementsStatementParserRuleCall_3_0!=null?((Token)StatementsStatementParserRuleCall_3_0.start):null), (StatementsStatementParserRuleCall_3_0!=null?((Token)StatementsStatementParserRuleCall_3_0.stop):null), grammarAccess.getCaseClauseAccess().getStatementsAssignment_3());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop219;
                }
            } while (true);


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_CaseClause_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_CaseClause_return norm1_CaseClause() throws RecognitionException {
        InternalN4JSParser.norm1_CaseClause_return retval = new InternalN4JSParser.norm1_CaseClause_return();
        retval.start = input.LT(1);

        Token CaseKeyword_0=null;
        Token ColonKeyword_2=null;
        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_1_0 = null;

        InternalN4JSParser.norm1_Statement_return StatementsStatementParserRuleCall_3_0 = null;




        try {
            {
            {
            CaseKeyword_0=(Token)match(input,Case,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(CaseKeyword_0, grammarAccess.getCaseClauseAccess().getCaseKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_94);
            ExpressionExpressionParserRuleCall_1_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.start):null), (ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.stop):null), grammarAccess.getCaseClauseAccess().getExpressionAssignment_1());
              			
            }

            }


            }

            ColonKeyword_2=(Token)match(input,Colon,FOLLOW_56); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(ColonKeyword_2, grammarAccess.getCaseClauseAccess().getColonKeyword_2());
              	
            }
            loop220:
            do {
                int alt220=2;
                int LA220_0 = input.LA(1);

                if ( ((LA220_0>=Intersection && LA220_0<=Implements)||(LA220_0>=Promisify && LA220_0<=Function)||(LA220_0>=Private && LA220_0<=Delete)||(LA220_0>=Import && LA220_0<=Break)||(LA220_0>=Class && LA220_0<=This)||(LA220_0>=From && LA220_0<=With)||(LA220_0>=For && LA220_0<=Var)||LA220_0==PlusSignPlusSign||LA220_0==HyphenMinusHyphenMinus||LA220_0==SolidusEqualsSign||(LA220_0>=As && LA220_0<=If)||LA220_0==Of||LA220_0==ExclamationMark||LA220_0==LeftParenthesis||LA220_0==PlusSign||LA220_0==HyphenMinus||LA220_0==Solidus||(LA220_0>=Semicolon && LA220_0<=LessThanSign)||(LA220_0>=CommercialAt && LA220_0<=LeftSquareBracket)||LA220_0==LeftCurlyBracket||LA220_0==Tilde||LA220_0==RULE_DOUBLE||(LA220_0>=RULE_HEX_INT && LA220_0<=RULE_LEGACY_OCTAL_INT)||LA220_0==RULE_SCIENTIFIC_INT||LA220_0==RULE_IDENTIFIER||LA220_0==RULE_STRING||(LA220_0>=RULE_TEMPLATE_HEAD && LA220_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA220_0==RULE_INT) ) {
                    alt220=1;
                }


                switch (alt220) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_56);
            	    StatementsStatementParserRuleCall_3_0=norm1_Statement();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((StatementsStatementParserRuleCall_3_0!=null?((Token)StatementsStatementParserRuleCall_3_0.start):null), (StatementsStatementParserRuleCall_3_0!=null?((Token)StatementsStatementParserRuleCall_3_0.stop):null), grammarAccess.getCaseClauseAccess().getStatementsAssignment_3());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop220;
                }
            } while (true);


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleDefaultClause() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleDefaultClause();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleDefaultClause_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleDefaultClause_return ruleDefaultClause() throws RecognitionException {
        InternalN4JSParser.ruleDefaultClause_return retval = new InternalN4JSParser.ruleDefaultClause_return();
        retval.start = input.LT(1);

        Token DefaultKeyword_1=null;
        Token ColonKeyword_2=null;
        InternalN4JSParser.ruleStatement_return StatementsStatementParserRuleCall_3_0 = null;




        try {
            {
            {
            DefaultKeyword_1=(Token)match(input,Default,FOLLOW_94); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(DefaultKeyword_1, grammarAccess.getDefaultClauseAccess().getDefaultKeyword_1());
              	
            }
            ColonKeyword_2=(Token)match(input,Colon,FOLLOW_3); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(ColonKeyword_2, grammarAccess.getDefaultClauseAccess().getColonKeyword_2());
              	
            }
            loop221:
            do {
                int alt221=2;
                int LA221_0 = input.LA(1);

                if ( ((LA221_0>=Intersection && LA221_0<=Implements)||(LA221_0>=Promisify && LA221_0<=Function)||(LA221_0>=Private && LA221_0<=Delete)||(LA221_0>=Import && LA221_0<=Break)||(LA221_0>=Class && LA221_0<=This)||(LA221_0>=From && LA221_0<=With)||(LA221_0>=For && LA221_0<=Var)||LA221_0==PlusSignPlusSign||LA221_0==HyphenMinusHyphenMinus||LA221_0==SolidusEqualsSign||(LA221_0>=As && LA221_0<=If)||LA221_0==Of||LA221_0==ExclamationMark||LA221_0==LeftParenthesis||LA221_0==PlusSign||LA221_0==HyphenMinus||LA221_0==Solidus||(LA221_0>=Semicolon && LA221_0<=LessThanSign)||(LA221_0>=CommercialAt && LA221_0<=LeftSquareBracket)||LA221_0==LeftCurlyBracket||LA221_0==Tilde||LA221_0==RULE_DOUBLE||(LA221_0>=RULE_HEX_INT && LA221_0<=RULE_LEGACY_OCTAL_INT)||LA221_0==RULE_SCIENTIFIC_INT||LA221_0==RULE_IDENTIFIER||LA221_0==RULE_STRING||(LA221_0>=RULE_TEMPLATE_HEAD && LA221_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA221_0==RULE_INT) ) {
                    alt221=1;
                }


                switch (alt221) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_3);
            	    StatementsStatementParserRuleCall_3_0=ruleStatement();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((StatementsStatementParserRuleCall_3_0!=null?((Token)StatementsStatementParserRuleCall_3_0.start):null), (StatementsStatementParserRuleCall_3_0!=null?((Token)StatementsStatementParserRuleCall_3_0.stop):null), grammarAccess.getDefaultClauseAccess().getStatementsAssignment_3());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop221;
                }
            } while (true);


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_DefaultClause_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_DefaultClause_return norm1_DefaultClause() throws RecognitionException {
        InternalN4JSParser.norm1_DefaultClause_return retval = new InternalN4JSParser.norm1_DefaultClause_return();
        retval.start = input.LT(1);

        Token DefaultKeyword_1=null;
        Token ColonKeyword_2=null;
        InternalN4JSParser.norm1_Statement_return StatementsStatementParserRuleCall_3_0 = null;




        try {
            {
            {
            DefaultKeyword_1=(Token)match(input,Default,FOLLOW_94); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(DefaultKeyword_1, grammarAccess.getDefaultClauseAccess().getDefaultKeyword_1());
              	
            }
            ColonKeyword_2=(Token)match(input,Colon,FOLLOW_56); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(ColonKeyword_2, grammarAccess.getDefaultClauseAccess().getColonKeyword_2());
              	
            }
            loop222:
            do {
                int alt222=2;
                int LA222_0 = input.LA(1);

                if ( ((LA222_0>=Intersection && LA222_0<=Implements)||(LA222_0>=Promisify && LA222_0<=Function)||(LA222_0>=Private && LA222_0<=Delete)||(LA222_0>=Import && LA222_0<=Break)||(LA222_0>=Class && LA222_0<=This)||(LA222_0>=From && LA222_0<=With)||(LA222_0>=For && LA222_0<=Var)||LA222_0==PlusSignPlusSign||LA222_0==HyphenMinusHyphenMinus||LA222_0==SolidusEqualsSign||(LA222_0>=As && LA222_0<=If)||LA222_0==Of||LA222_0==ExclamationMark||LA222_0==LeftParenthesis||LA222_0==PlusSign||LA222_0==HyphenMinus||LA222_0==Solidus||(LA222_0>=Semicolon && LA222_0<=LessThanSign)||(LA222_0>=CommercialAt && LA222_0<=LeftSquareBracket)||LA222_0==LeftCurlyBracket||LA222_0==Tilde||LA222_0==RULE_DOUBLE||(LA222_0>=RULE_HEX_INT && LA222_0<=RULE_LEGACY_OCTAL_INT)||LA222_0==RULE_SCIENTIFIC_INT||LA222_0==RULE_IDENTIFIER||LA222_0==RULE_STRING||(LA222_0>=RULE_TEMPLATE_HEAD && LA222_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA222_0==RULE_INT) ) {
                    alt222=1;
                }


                switch (alt222) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_56);
            	    StatementsStatementParserRuleCall_3_0=norm1_Statement();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((StatementsStatementParserRuleCall_3_0!=null?((Token)StatementsStatementParserRuleCall_3_0.start):null), (StatementsStatementParserRuleCall_3_0!=null?((Token)StatementsStatementParserRuleCall_3_0.stop):null), grammarAccess.getDefaultClauseAccess().getStatementsAssignment_3());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop222;
                }
            } while (true);


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleLabelledStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleLabelledStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleLabelledStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleLabelledStatement_return ruleLabelledStatement() throws RecognitionException {
        InternalN4JSParser.ruleLabelledStatement_return retval = new InternalN4JSParser.ruleLabelledStatement_return();
        retval.start = input.LT(1);

        Token ColonKeyword_0_0_1=null;
        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_0_0_0_0 = null;

        InternalN4JSParser.ruleStatement_return StatementStatementParserRuleCall_1_0 = null;




        try {
            {
            {
            {
            {
            {
            {
            pushFollow(FOLLOW_94);
            NameBindingIdentifierParserRuleCall_0_0_0_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              						announce((NameBindingIdentifierParserRuleCall_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_0_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_0_0_0_0.stop):null), grammarAccess.getLabelledStatementAccess().getNameAssignment_0_0_0());
              					
            }

            }


            }

            ColonKeyword_0_0_1=(Token)match(input,Colon,FOLLOW_73); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(ColonKeyword_0_0_1, grammarAccess.getLabelledStatementAccess().getColonKeyword_0_0_1());
              			
            }

            }


            }
            {
            {
            pushFollow(FOLLOW_2);
            StatementStatementParserRuleCall_1_0=ruleStatement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementStatementParserRuleCall_1_0!=null?((Token)StatementStatementParserRuleCall_1_0.start):null), (StatementStatementParserRuleCall_1_0!=null?((Token)StatementStatementParserRuleCall_1_0.stop):null), grammarAccess.getLabelledStatementAccess().getStatementAssignment_1());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_LabelledStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_LabelledStatement_return norm1_LabelledStatement() throws RecognitionException {
        InternalN4JSParser.norm1_LabelledStatement_return retval = new InternalN4JSParser.norm1_LabelledStatement_return();
        retval.start = input.LT(1);

        Token ColonKeyword_0_0_1=null;
        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_0_0_0_0 = null;

        InternalN4JSParser.norm1_Statement_return StatementStatementParserRuleCall_1_0 = null;




        try {
            {
            {
            {
            {
            {
            {
            pushFollow(FOLLOW_94);
            NameBindingIdentifierParserRuleCall_0_0_0_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              						announce((NameBindingIdentifierParserRuleCall_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_0_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_0_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_0_0_0_0.stop):null), grammarAccess.getLabelledStatementAccess().getNameAssignment_0_0_0());
              					
            }

            }


            }

            ColonKeyword_0_0_1=(Token)match(input,Colon,FOLLOW_75); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(ColonKeyword_0_0_1, grammarAccess.getLabelledStatementAccess().getColonKeyword_0_0_1());
              			
            }

            }


            }
            {
            {
            pushFollow(FOLLOW_2);
            StatementStatementParserRuleCall_1_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((StatementStatementParserRuleCall_1_0!=null?((Token)StatementStatementParserRuleCall_1_0.start):null), (StatementStatementParserRuleCall_1_0!=null?((Token)StatementStatementParserRuleCall_1_0.stop):null), grammarAccess.getLabelledStatementAccess().getStatementAssignment_1());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleThrowStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleThrowStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleThrowStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleThrowStatement_return ruleThrowStatement() throws RecognitionException {
        InternalN4JSParser.ruleThrowStatement_return retval = new InternalN4JSParser.ruleThrowStatement_return();
        retval.start = input.LT(1);

        Token ThrowKeyword_0=null;
        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_2 = null;




        try {
            {
            {
            ThrowKeyword_0=(Token)match(input,Throw,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		promoteEOL();
              		announce(ThrowKeyword_0, grammarAccess.getThrowStatementAccess().getThrowKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_18);
            ExpressionExpressionParserRuleCall_1_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.start):null), (ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.stop):null), grammarAccess.getThrowStatementAccess().getExpressionAssignment_1());
              			
            }

            }


            }

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_2=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_2!=null?((Token)SemiParserRuleCall_2.start):null), (SemiParserRuleCall_2!=null?((Token)SemiParserRuleCall_2.stop):null), grammarAccess.getThrowStatementAccess().getSemiParserRuleCall_2()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ThrowStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ThrowStatement_return norm1_ThrowStatement() throws RecognitionException {
        InternalN4JSParser.norm1_ThrowStatement_return retval = new InternalN4JSParser.norm1_ThrowStatement_return();
        retval.start = input.LT(1);

        Token ThrowKeyword_0=null;
        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_2 = null;




        try {
            {
            {
            ThrowKeyword_0=(Token)match(input,Throw,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		promoteEOL();
              		announce(ThrowKeyword_0, grammarAccess.getThrowStatementAccess().getThrowKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_18);
            ExpressionExpressionParserRuleCall_1_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.start):null), (ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.stop):null), grammarAccess.getThrowStatementAccess().getExpressionAssignment_1());
              			
            }

            }


            }

            pushFollow(FOLLOW_2);
            SemiParserRuleCall_2=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_2!=null?((Token)SemiParserRuleCall_2.start):null), (SemiParserRuleCall_2!=null?((Token)SemiParserRuleCall_2.stop):null), grammarAccess.getThrowStatementAccess().getSemiParserRuleCall_2()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleTryStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleTryStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleTryStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleTryStatement_return ruleTryStatement() throws RecognitionException {
        InternalN4JSParser.ruleTryStatement_return retval = new InternalN4JSParser.ruleTryStatement_return();
        retval.start = input.LT(1);

        Token TryKeyword_0=null;
        InternalN4JSParser.ruleBlock_return BlockBlockParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleCatchBlock_return CatchCatchBlockParserRuleCall_2_0_0_0 = null;

        InternalN4JSParser.ruleFinallyBlock_return FinallyFinallyBlockParserRuleCall_2_0_1_0 = null;

        InternalN4JSParser.ruleFinallyBlock_return FinallyFinallyBlockParserRuleCall_2_1_0 = null;




        try {
            {
            {
            TryKeyword_0=(Token)match(input,Try,FOLLOW_13); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(TryKeyword_0, grammarAccess.getTryStatementAccess().getTryKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_95);
            BlockBlockParserRuleCall_1_0=ruleBlock();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((BlockBlockParserRuleCall_1_0!=null?((Token)BlockBlockParserRuleCall_1_0.start):null), (BlockBlockParserRuleCall_1_0!=null?((Token)BlockBlockParserRuleCall_1_0.stop):null), grammarAccess.getTryStatementAccess().getBlockAssignment_1());
              			
            }

            }


            }
            int alt224=2;
            int LA224_0 = input.LA(1);

            if ( (LA224_0==Catch) ) {
                alt224=1;
            }
            else if ( (LA224_0==Finally) ) {
                alt224=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 224, 0, input);

                throw nvae;
            }
            switch (alt224) {
                case 1 :
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_96);
                    CatchCatchBlockParserRuleCall_2_0_0_0=ruleCatchBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((CatchCatchBlockParserRuleCall_2_0_0_0!=null?((Token)CatchCatchBlockParserRuleCall_2_0_0_0.start):null), (CatchCatchBlockParserRuleCall_2_0_0_0!=null?((Token)CatchCatchBlockParserRuleCall_2_0_0_0.stop):null), grammarAccess.getTryStatementAccess().getCatchAssignment_2_0_0());
                      					
                    }

                    }


                    }
                    int alt223=2;
                    int LA223_0 = input.LA(1);

                    if ( (LA223_0==Finally) ) {
                        alt223=1;
                    }
                    switch (alt223) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_2);
                            FinallyFinallyBlockParserRuleCall_2_0_1_0=ruleFinallyBlock();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce((FinallyFinallyBlockParserRuleCall_2_0_1_0!=null?((Token)FinallyFinallyBlockParserRuleCall_2_0_1_0.start):null), (FinallyFinallyBlockParserRuleCall_2_0_1_0!=null?((Token)FinallyFinallyBlockParserRuleCall_2_0_1_0.stop):null), grammarAccess.getTryStatementAccess().getFinallyAssignment_2_0_1());
                              					
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    FinallyFinallyBlockParserRuleCall_2_1_0=ruleFinallyBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((FinallyFinallyBlockParserRuleCall_2_1_0!=null?((Token)FinallyFinallyBlockParserRuleCall_2_1_0.start):null), (FinallyFinallyBlockParserRuleCall_2_1_0!=null?((Token)FinallyFinallyBlockParserRuleCall_2_1_0.stop):null), grammarAccess.getTryStatementAccess().getFinallyAssignment_2_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_TryStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_TryStatement_return norm1_TryStatement() throws RecognitionException {
        InternalN4JSParser.norm1_TryStatement_return retval = new InternalN4JSParser.norm1_TryStatement_return();
        retval.start = input.LT(1);

        Token TryKeyword_0=null;
        InternalN4JSParser.norm1_Block_return BlockBlockParserRuleCall_1_0 = null;

        InternalN4JSParser.norm1_CatchBlock_return CatchCatchBlockParserRuleCall_2_0_0_0 = null;

        InternalN4JSParser.norm1_FinallyBlock_return FinallyFinallyBlockParserRuleCall_2_0_1_0 = null;

        InternalN4JSParser.norm1_FinallyBlock_return FinallyFinallyBlockParserRuleCall_2_1_0 = null;




        try {
            {
            {
            TryKeyword_0=(Token)match(input,Try,FOLLOW_13); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(TryKeyword_0, grammarAccess.getTryStatementAccess().getTryKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_95);
            BlockBlockParserRuleCall_1_0=norm1_Block();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((BlockBlockParserRuleCall_1_0!=null?((Token)BlockBlockParserRuleCall_1_0.start):null), (BlockBlockParserRuleCall_1_0!=null?((Token)BlockBlockParserRuleCall_1_0.stop):null), grammarAccess.getTryStatementAccess().getBlockAssignment_1());
              			
            }

            }


            }
            int alt226=2;
            int LA226_0 = input.LA(1);

            if ( (LA226_0==Catch) ) {
                alt226=1;
            }
            else if ( (LA226_0==Finally) ) {
                alt226=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 226, 0, input);

                throw nvae;
            }
            switch (alt226) {
                case 1 :
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_96);
                    CatchCatchBlockParserRuleCall_2_0_0_0=norm1_CatchBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((CatchCatchBlockParserRuleCall_2_0_0_0!=null?((Token)CatchCatchBlockParserRuleCall_2_0_0_0.start):null), (CatchCatchBlockParserRuleCall_2_0_0_0!=null?((Token)CatchCatchBlockParserRuleCall_2_0_0_0.stop):null), grammarAccess.getTryStatementAccess().getCatchAssignment_2_0_0());
                      					
                    }

                    }


                    }
                    int alt225=2;
                    int LA225_0 = input.LA(1);

                    if ( (LA225_0==Finally) ) {
                        alt225=1;
                    }
                    switch (alt225) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_2);
                            FinallyFinallyBlockParserRuleCall_2_0_1_0=norm1_FinallyBlock();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce((FinallyFinallyBlockParserRuleCall_2_0_1_0!=null?((Token)FinallyFinallyBlockParserRuleCall_2_0_1_0.start):null), (FinallyFinallyBlockParserRuleCall_2_0_1_0!=null?((Token)FinallyFinallyBlockParserRuleCall_2_0_1_0.stop):null), grammarAccess.getTryStatementAccess().getFinallyAssignment_2_0_1());
                              					
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    FinallyFinallyBlockParserRuleCall_2_1_0=norm1_FinallyBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((FinallyFinallyBlockParserRuleCall_2_1_0!=null?((Token)FinallyFinallyBlockParserRuleCall_2_1_0.start):null), (FinallyFinallyBlockParserRuleCall_2_1_0!=null?((Token)FinallyFinallyBlockParserRuleCall_2_1_0.stop):null), grammarAccess.getTryStatementAccess().getFinallyAssignment_2_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleCatchBlock() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleCatchBlock();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleCatchBlock_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleCatchBlock_return ruleCatchBlock() throws RecognitionException {
        InternalN4JSParser.ruleCatchBlock_return retval = new InternalN4JSParser.ruleCatchBlock_return();
        retval.start = input.LT(1);

        Token CatchKeyword_1=null;
        Token LeftParenthesisKeyword_2=null;
        Token RightParenthesisKeyword_4=null;
        InternalN4JSParser.ruleCatchVariable_return CatchVariableCatchVariableParserRuleCall_3_0 = null;

        InternalN4JSParser.ruleBlock_return BlockBlockParserRuleCall_5_0 = null;




        try {
            {
            {
            CatchKeyword_1=(Token)match(input,Catch,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(CatchKeyword_1, grammarAccess.getCatchBlockAccess().getCatchKeyword_1());
              	
            }
            LeftParenthesisKeyword_2=(Token)match(input,LeftParenthesis,FOLLOW_97); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_2, grammarAccess.getCatchBlockAccess().getLeftParenthesisKeyword_2());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            CatchVariableCatchVariableParserRuleCall_3_0=ruleCatchVariable();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((CatchVariableCatchVariableParserRuleCall_3_0!=null?((Token)CatchVariableCatchVariableParserRuleCall_3_0.start):null), (CatchVariableCatchVariableParserRuleCall_3_0!=null?((Token)CatchVariableCatchVariableParserRuleCall_3_0.stop):null), grammarAccess.getCatchBlockAccess().getCatchVariableAssignment_3());
              			
            }

            }


            }

            RightParenthesisKeyword_4=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_4, grammarAccess.getCatchBlockAccess().getRightParenthesisKeyword_4());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            BlockBlockParserRuleCall_5_0=ruleBlock();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((BlockBlockParserRuleCall_5_0!=null?((Token)BlockBlockParserRuleCall_5_0.start):null), (BlockBlockParserRuleCall_5_0!=null?((Token)BlockBlockParserRuleCall_5_0.stop):null), grammarAccess.getCatchBlockAccess().getBlockAssignment_5());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_CatchBlock_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_CatchBlock_return norm1_CatchBlock() throws RecognitionException {
        InternalN4JSParser.norm1_CatchBlock_return retval = new InternalN4JSParser.norm1_CatchBlock_return();
        retval.start = input.LT(1);

        Token CatchKeyword_1=null;
        Token LeftParenthesisKeyword_2=null;
        Token RightParenthesisKeyword_4=null;
        InternalN4JSParser.norm1_CatchVariable_return CatchVariableCatchVariableParserRuleCall_3_0 = null;

        InternalN4JSParser.norm1_Block_return BlockBlockParserRuleCall_5_0 = null;




        try {
            {
            {
            CatchKeyword_1=(Token)match(input,Catch,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(CatchKeyword_1, grammarAccess.getCatchBlockAccess().getCatchKeyword_1());
              	
            }
            LeftParenthesisKeyword_2=(Token)match(input,LeftParenthesis,FOLLOW_97); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_2, grammarAccess.getCatchBlockAccess().getLeftParenthesisKeyword_2());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            CatchVariableCatchVariableParserRuleCall_3_0=norm1_CatchVariable();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((CatchVariableCatchVariableParserRuleCall_3_0!=null?((Token)CatchVariableCatchVariableParserRuleCall_3_0.start):null), (CatchVariableCatchVariableParserRuleCall_3_0!=null?((Token)CatchVariableCatchVariableParserRuleCall_3_0.stop):null), grammarAccess.getCatchBlockAccess().getCatchVariableAssignment_3());
              			
            }

            }


            }

            RightParenthesisKeyword_4=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_4, grammarAccess.getCatchBlockAccess().getRightParenthesisKeyword_4());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            BlockBlockParserRuleCall_5_0=norm1_Block();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((BlockBlockParserRuleCall_5_0!=null?((Token)BlockBlockParserRuleCall_5_0.start):null), (BlockBlockParserRuleCall_5_0!=null?((Token)BlockBlockParserRuleCall_5_0.stop):null), grammarAccess.getCatchBlockAccess().getBlockAssignment_5());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleCatchVariable() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleCatchVariable();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleCatchVariable_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleCatchVariable_return ruleCatchVariable() throws RecognitionException {
        InternalN4JSParser.ruleCatchVariable_return retval = new InternalN4JSParser.ruleCatchVariable_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleBindingPattern_return BindingPatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0_0_0 = null;

        InternalN4JSParser.ruleColonSepDeclaredTypeRef_return ColonSepDeclaredTypeRefParserRuleCall_1_0_1 = null;

        InternalN4JSParser.ruleBogusTypeRefFragment_return BogusTypeRefFragmentParserRuleCall_2_0 = null;

        InternalN4JSParser.ruleBindingIdentifier_return NameBindingIdentifierParserRuleCall_2_1_0 = null;




        try {
            {
            int alt228=3;
            alt228 = dfa228.predict(input);
            switch (alt228) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BindingPatternBindingPatternParserRuleCall_0_0=ruleBindingPattern();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((BindingPatternBindingPatternParserRuleCall_0_0!=null?((Token)BindingPatternBindingPatternParserRuleCall_0_0.start):null), (BindingPatternBindingPatternParserRuleCall_0_0!=null?((Token)BindingPatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getCatchVariableAccess().getBindingPatternAssignment_0());
                      			
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_94);
                    NameBindingIdentifierParserRuleCall_1_0_0_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((NameBindingIdentifierParserRuleCall_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0.stop):null), grammarAccess.getCatchVariableAccess().getNameAssignment_1_0_0());
                      					
                    }

                    }


                    }
                    {
                    pushFollow(FOLLOW_2);
                    ColonSepDeclaredTypeRefParserRuleCall_1_0_1=ruleColonSepDeclaredTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ColonSepDeclaredTypeRefParserRuleCall_1_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_1.start):null), (ColonSepDeclaredTypeRefParserRuleCall_1_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_1.stop):null), grammarAccess.getCatchVariableAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_1()); 
                    }

                    }


                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    int alt227=2;
                    alt227 = dfa227.predict(input);
                    switch (alt227) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_8);
                            BogusTypeRefFragmentParserRuleCall_2_0=ruleBogusTypeRefFragment();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((BogusTypeRefFragmentParserRuleCall_2_0!=null?((Token)BogusTypeRefFragmentParserRuleCall_2_0.start):null), (BogusTypeRefFragmentParserRuleCall_2_0!=null?((Token)BogusTypeRefFragmentParserRuleCall_2_0.stop):null), grammarAccess.getCatchVariableAccess().getBogusTypeRefFragmentParserRuleCall_2_0()); 
                            }

                            }
                            break;

                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    NameBindingIdentifierParserRuleCall_2_1_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((NameBindingIdentifierParserRuleCall_2_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_2_1_0.start):null), (NameBindingIdentifierParserRuleCall_2_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_2_1_0.stop):null), grammarAccess.getCatchVariableAccess().getNameAssignment_2_1());
                      				
                    }

                    }


                    }


                    }


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_CatchVariable_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_CatchVariable_return norm1_CatchVariable() throws RecognitionException {
        InternalN4JSParser.norm1_CatchVariable_return retval = new InternalN4JSParser.norm1_CatchVariable_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_BindingPattern_return BindingPatternBindingPatternParserRuleCall_0_0 = null;

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_1_0_0_0 = null;

        InternalN4JSParser.ruleColonSepDeclaredTypeRef_return ColonSepDeclaredTypeRefParserRuleCall_1_0_1 = null;

        InternalN4JSParser.ruleBogusTypeRefFragment_return BogusTypeRefFragmentParserRuleCall_2_0 = null;

        InternalN4JSParser.norm1_BindingIdentifier_return NameBindingIdentifierParserRuleCall_2_1_0 = null;




        try {
            {
            int alt230=3;
            alt230 = dfa230.predict(input);
            switch (alt230) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BindingPatternBindingPatternParserRuleCall_0_0=norm1_BindingPattern();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((BindingPatternBindingPatternParserRuleCall_0_0!=null?((Token)BindingPatternBindingPatternParserRuleCall_0_0.start):null), (BindingPatternBindingPatternParserRuleCall_0_0!=null?((Token)BindingPatternBindingPatternParserRuleCall_0_0.stop):null), grammarAccess.getCatchVariableAccess().getBindingPatternAssignment_0());
                      			
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_94);
                    NameBindingIdentifierParserRuleCall_1_0_0_0=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((NameBindingIdentifierParserRuleCall_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0.start):null), (NameBindingIdentifierParserRuleCall_1_0_0_0!=null?((Token)NameBindingIdentifierParserRuleCall_1_0_0_0.stop):null), grammarAccess.getCatchVariableAccess().getNameAssignment_1_0_0());
                      					
                    }

                    }


                    }
                    {
                    pushFollow(FOLLOW_2);
                    ColonSepDeclaredTypeRefParserRuleCall_1_0_1=ruleColonSepDeclaredTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ColonSepDeclaredTypeRefParserRuleCall_1_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_1.start):null), (ColonSepDeclaredTypeRefParserRuleCall_1_0_1!=null?((Token)ColonSepDeclaredTypeRefParserRuleCall_1_0_1.stop):null), grammarAccess.getCatchVariableAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_1()); 
                    }

                    }


                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    int alt229=2;
                    alt229 = dfa229.predict(input);
                    switch (alt229) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_8);
                            BogusTypeRefFragmentParserRuleCall_2_0=ruleBogusTypeRefFragment();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((BogusTypeRefFragmentParserRuleCall_2_0!=null?((Token)BogusTypeRefFragmentParserRuleCall_2_0.start):null), (BogusTypeRefFragmentParserRuleCall_2_0!=null?((Token)BogusTypeRefFragmentParserRuleCall_2_0.stop):null), grammarAccess.getCatchVariableAccess().getBogusTypeRefFragmentParserRuleCall_2_0()); 
                            }

                            }
                            break;

                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    NameBindingIdentifierParserRuleCall_2_1_0=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((NameBindingIdentifierParserRuleCall_2_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_2_1_0.start):null), (NameBindingIdentifierParserRuleCall_2_1_0!=null?((Token)NameBindingIdentifierParserRuleCall_2_1_0.stop):null), grammarAccess.getCatchVariableAccess().getNameAssignment_2_1());
                      				
                    }

                    }


                    }


                    }


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleFinallyBlock() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleFinallyBlock();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleFinallyBlock_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleFinallyBlock_return ruleFinallyBlock() throws RecognitionException {
        InternalN4JSParser.ruleFinallyBlock_return retval = new InternalN4JSParser.ruleFinallyBlock_return();
        retval.start = input.LT(1);

        Token FinallyKeyword_1=null;
        InternalN4JSParser.ruleBlock_return BlockBlockParserRuleCall_2_0 = null;




        try {
            {
            {
            FinallyKeyword_1=(Token)match(input,Finally,FOLLOW_13); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(FinallyKeyword_1, grammarAccess.getFinallyBlockAccess().getFinallyKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            BlockBlockParserRuleCall_2_0=ruleBlock();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((BlockBlockParserRuleCall_2_0!=null?((Token)BlockBlockParserRuleCall_2_0.start):null), (BlockBlockParserRuleCall_2_0!=null?((Token)BlockBlockParserRuleCall_2_0.stop):null), grammarAccess.getFinallyBlockAccess().getBlockAssignment_2());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_FinallyBlock_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_FinallyBlock_return norm1_FinallyBlock() throws RecognitionException {
        InternalN4JSParser.norm1_FinallyBlock_return retval = new InternalN4JSParser.norm1_FinallyBlock_return();
        retval.start = input.LT(1);

        Token FinallyKeyword_1=null;
        InternalN4JSParser.norm1_Block_return BlockBlockParserRuleCall_2_0 = null;




        try {
            {
            {
            FinallyKeyword_1=(Token)match(input,Finally,FOLLOW_13); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(FinallyKeyword_1, grammarAccess.getFinallyBlockAccess().getFinallyKeyword_1());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            BlockBlockParserRuleCall_2_0=norm1_Block();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((BlockBlockParserRuleCall_2_0!=null?((Token)BlockBlockParserRuleCall_2_0.start):null), (BlockBlockParserRuleCall_2_0!=null?((Token)BlockBlockParserRuleCall_2_0.stop):null), grammarAccess.getFinallyBlockAccess().getBlockAssignment_2());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleDebuggerStatement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleDebuggerStatement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleDebuggerStatement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleDebuggerStatement_return ruleDebuggerStatement() throws RecognitionException {
        InternalN4JSParser.ruleDebuggerStatement_return retval = new InternalN4JSParser.ruleDebuggerStatement_return();
        retval.start = input.LT(1);

        Token DebuggerKeyword_1=null;
        InternalN4JSParser.ruleSemi_return SemiParserRuleCall_2 = null;




        try {
            {
            {
            DebuggerKeyword_1=(Token)match(input,Debugger,FOLLOW_18); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(DebuggerKeyword_1, grammarAccess.getDebuggerStatementAccess().getDebuggerKeyword_1());
              	
            }
            pushFollow(FOLLOW_2);
            SemiParserRuleCall_2=ruleSemi();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((SemiParserRuleCall_2!=null?((Token)SemiParserRuleCall_2.start):null), (SemiParserRuleCall_2!=null?((Token)SemiParserRuleCall_2.stop):null), grammarAccess.getDebuggerStatementAccess().getSemiParserRuleCall_2()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRulePrimaryExpression() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            rulePrimaryExpression();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class rulePrimaryExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.rulePrimaryExpression_return rulePrimaryExpression() throws RecognitionException {
        InternalN4JSParser.rulePrimaryExpression_return retval = new InternalN4JSParser.rulePrimaryExpression_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleThisLiteral_return ThisLiteralParserRuleCall_0 = null;

        InternalN4JSParser.ruleSuperLiteral_return SuperLiteralParserRuleCall_1 = null;

        InternalN4JSParser.ruleIdentifierRef_return IdentifierRefParserRuleCall_2 = null;

        InternalN4JSParser.ruleJSXFragment_return JSXFragmentParserRuleCall_3 = null;

        InternalN4JSParser.ruleJSXElement_return JSXElementParserRuleCall_4 = null;

        InternalN4JSParser.ruleImportCallExpression_return ImportCallExpressionParserRuleCall_5 = null;

        InternalN4JSParser.ruleParameterizedCallExpression_return ParameterizedCallExpressionParserRuleCall_6 = null;

        InternalN4JSParser.ruleLiteral_return LiteralParserRuleCall_7 = null;

        InternalN4JSParser.ruleArrayLiteral_return ArrayLiteralParserRuleCall_8 = null;

        InternalN4JSParser.ruleObjectLiteral_return ObjectLiteralParserRuleCall_9 = null;

        InternalN4JSParser.ruleParenExpression_return ParenExpressionParserRuleCall_10 = null;

        InternalN4JSParser.ruleAnnotatedExpression_return AnnotatedExpressionParserRuleCall_11 = null;

        InternalN4JSParser.ruleFunctionExpression_return FunctionExpressionParserRuleCall_12 = null;

        InternalN4JSParser.ruleAsyncFunctionExpression_return AsyncFunctionExpressionParserRuleCall_13 = null;

        InternalN4JSParser.ruleN4ClassExpression_return N4ClassExpressionParserRuleCall_14 = null;

        InternalN4JSParser.ruleTemplateLiteral_return TemplateLiteralParserRuleCall_15 = null;




        try {
            {
            int alt231=16;
            alt231 = dfa231.predict(input);
            switch (alt231) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    ThisLiteralParserRuleCall_0=ruleThisLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ThisLiteralParserRuleCall_0!=null?((Token)ThisLiteralParserRuleCall_0.start):null), (ThisLiteralParserRuleCall_0!=null?((Token)ThisLiteralParserRuleCall_0.stop):null), grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0()); 
                    }

                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    SuperLiteralParserRuleCall_1=ruleSuperLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((SuperLiteralParserRuleCall_1!=null?((Token)SuperLiteralParserRuleCall_1.start):null), (SuperLiteralParserRuleCall_1!=null?((Token)SuperLiteralParserRuleCall_1.stop):null), grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1()); 
                    }

                    }
                    break;
                case 3 :
                    {
                    pushFollow(FOLLOW_2);
                    IdentifierRefParserRuleCall_2=ruleIdentifierRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((IdentifierRefParserRuleCall_2!=null?((Token)IdentifierRefParserRuleCall_2.start):null), (IdentifierRefParserRuleCall_2!=null?((Token)IdentifierRefParserRuleCall_2.stop):null), grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2()); 
                    }

                    }
                    break;
                case 4 :
                    {
                    pushFollow(FOLLOW_2);
                    JSXFragmentParserRuleCall_3=ruleJSXFragment();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((JSXFragmentParserRuleCall_3!=null?((Token)JSXFragmentParserRuleCall_3.start):null), (JSXFragmentParserRuleCall_3!=null?((Token)JSXFragmentParserRuleCall_3.stop):null), grammarAccess.getPrimaryExpressionAccess().getJSXFragmentParserRuleCall_3()); 
                    }

                    }
                    break;
                case 5 :
                    {
                    pushFollow(FOLLOW_2);
                    JSXElementParserRuleCall_4=ruleJSXElement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((JSXElementParserRuleCall_4!=null?((Token)JSXElementParserRuleCall_4.start):null), (JSXElementParserRuleCall_4!=null?((Token)JSXElementParserRuleCall_4.stop):null), grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_4()); 
                    }

                    }
                    break;
                case 6 :
                    {
                    pushFollow(FOLLOW_2);
                    ImportCallExpressionParserRuleCall_5=ruleImportCallExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ImportCallExpressionParserRuleCall_5!=null?((Token)ImportCallExpressionParserRuleCall_5.start):null), (ImportCallExpressionParserRuleCall_5!=null?((Token)ImportCallExpressionParserRuleCall_5.stop):null), grammarAccess.getPrimaryExpressionAccess().getImportCallExpressionParserRuleCall_5()); 
                    }

                    }
                    break;
                case 7 :
                    {
                    pushFollow(FOLLOW_2);
                    ParameterizedCallExpressionParserRuleCall_6=ruleParameterizedCallExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ParameterizedCallExpressionParserRuleCall_6!=null?((Token)ParameterizedCallExpressionParserRuleCall_6.start):null), (ParameterizedCallExpressionParserRuleCall_6!=null?((Token)ParameterizedCallExpressionParserRuleCall_6.stop):null), grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_6()); 
                    }

                    }
                    break;
                case 8 :
                    {
                    pushFollow(FOLLOW_2);
                    LiteralParserRuleCall_7=ruleLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((LiteralParserRuleCall_7!=null?((Token)LiteralParserRuleCall_7.start):null), (LiteralParserRuleCall_7!=null?((Token)LiteralParserRuleCall_7.stop):null), grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_7()); 
                    }

                    }
                    break;
                case 9 :
                    {
                    pushFollow(FOLLOW_2);
                    ArrayLiteralParserRuleCall_8=ruleArrayLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ArrayLiteralParserRuleCall_8!=null?((Token)ArrayLiteralParserRuleCall_8.start):null), (ArrayLiteralParserRuleCall_8!=null?((Token)ArrayLiteralParserRuleCall_8.stop):null), grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_8()); 
                    }

                    }
                    break;
                case 10 :
                    {
                    pushFollow(FOLLOW_2);
                    ObjectLiteralParserRuleCall_9=ruleObjectLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ObjectLiteralParserRuleCall_9!=null?((Token)ObjectLiteralParserRuleCall_9.start):null), (ObjectLiteralParserRuleCall_9!=null?((Token)ObjectLiteralParserRuleCall_9.stop):null), grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_9()); 
                    }

                    }
                    break;
                case 11 :
                    {
                    pushFollow(FOLLOW_2);
                    ParenExpressionParserRuleCall_10=ruleParenExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ParenExpressionParserRuleCall_10!=null?((Token)ParenExpressionParserRuleCall_10.start):null), (ParenExpressionParserRuleCall_10!=null?((Token)ParenExpressionParserRuleCall_10.stop):null), grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_10()); 
                    }

                    }
                    break;
                case 12 :
                    {
                    pushFollow(FOLLOW_2);
                    AnnotatedExpressionParserRuleCall_11=ruleAnnotatedExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AnnotatedExpressionParserRuleCall_11!=null?((Token)AnnotatedExpressionParserRuleCall_11.start):null), (AnnotatedExpressionParserRuleCall_11!=null?((Token)AnnotatedExpressionParserRuleCall_11.stop):null), grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_11()); 
                    }

                    }
                    break;
                case 13 :
                    {
                    pushFollow(FOLLOW_2);
                    FunctionExpressionParserRuleCall_12=ruleFunctionExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionExpressionParserRuleCall_12!=null?((Token)FunctionExpressionParserRuleCall_12.start):null), (FunctionExpressionParserRuleCall_12!=null?((Token)FunctionExpressionParserRuleCall_12.stop):null), grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_12()); 
                    }

                    }
                    break;
                case 14 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    AsyncFunctionExpressionParserRuleCall_13=ruleAsyncFunctionExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AsyncFunctionExpressionParserRuleCall_13!=null?((Token)AsyncFunctionExpressionParserRuleCall_13.start):null), (AsyncFunctionExpressionParserRuleCall_13!=null?((Token)AsyncFunctionExpressionParserRuleCall_13.stop):null), grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_13()); 
                    }

                    }


                    }
                    break;
                case 15 :
                    {
                    pushFollow(FOLLOW_2);
                    N4ClassExpressionParserRuleCall_14=ruleN4ClassExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((N4ClassExpressionParserRuleCall_14!=null?((Token)N4ClassExpressionParserRuleCall_14.start):null), (N4ClassExpressionParserRuleCall_14!=null?((Token)N4ClassExpressionParserRuleCall_14.stop):null), grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_14()); 
                    }

                    }
                    break;
                case 16 :
                    {
                    pushFollow(FOLLOW_2);
                    TemplateLiteralParserRuleCall_15=ruleTemplateLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((TemplateLiteralParserRuleCall_15!=null?((Token)TemplateLiteralParserRuleCall_15.start):null), (TemplateLiteralParserRuleCall_15!=null?((Token)TemplateLiteralParserRuleCall_15.stop):null), grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_15()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_PrimaryExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_PrimaryExpression_return norm1_PrimaryExpression() throws RecognitionException {
        InternalN4JSParser.norm1_PrimaryExpression_return retval = new InternalN4JSParser.norm1_PrimaryExpression_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleThisLiteral_return ThisLiteralParserRuleCall_0 = null;

        InternalN4JSParser.ruleSuperLiteral_return SuperLiteralParserRuleCall_1 = null;

        InternalN4JSParser.norm1_IdentifierRef_return IdentifierRefParserRuleCall_2 = null;

        InternalN4JSParser.ruleJSXFragment_return JSXFragmentParserRuleCall_3 = null;

        InternalN4JSParser.ruleJSXElement_return JSXElementParserRuleCall_4 = null;

        InternalN4JSParser.norm1_ImportCallExpression_return ImportCallExpressionParserRuleCall_5 = null;

        InternalN4JSParser.norm1_ParameterizedCallExpression_return ParameterizedCallExpressionParserRuleCall_6 = null;

        InternalN4JSParser.ruleLiteral_return LiteralParserRuleCall_7 = null;

        InternalN4JSParser.norm1_ArrayLiteral_return ArrayLiteralParserRuleCall_8 = null;

        InternalN4JSParser.norm1_ObjectLiteral_return ObjectLiteralParserRuleCall_9 = null;

        InternalN4JSParser.norm1_ParenExpression_return ParenExpressionParserRuleCall_10 = null;

        InternalN4JSParser.norm1_AnnotatedExpression_return AnnotatedExpressionParserRuleCall_11 = null;

        InternalN4JSParser.ruleFunctionExpression_return FunctionExpressionParserRuleCall_12 = null;

        InternalN4JSParser.ruleAsyncFunctionExpression_return AsyncFunctionExpressionParserRuleCall_13 = null;

        InternalN4JSParser.norm1_N4ClassExpression_return N4ClassExpressionParserRuleCall_14 = null;

        InternalN4JSParser.norm1_TemplateLiteral_return TemplateLiteralParserRuleCall_15 = null;




        try {
            {
            int alt232=16;
            alt232 = dfa232.predict(input);
            switch (alt232) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    ThisLiteralParserRuleCall_0=ruleThisLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ThisLiteralParserRuleCall_0!=null?((Token)ThisLiteralParserRuleCall_0.start):null), (ThisLiteralParserRuleCall_0!=null?((Token)ThisLiteralParserRuleCall_0.stop):null), grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0()); 
                    }

                    }
                    break;
                case 2 :
                    {
                    pushFollow(FOLLOW_2);
                    SuperLiteralParserRuleCall_1=ruleSuperLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((SuperLiteralParserRuleCall_1!=null?((Token)SuperLiteralParserRuleCall_1.start):null), (SuperLiteralParserRuleCall_1!=null?((Token)SuperLiteralParserRuleCall_1.stop):null), grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1()); 
                    }

                    }
                    break;
                case 3 :
                    {
                    pushFollow(FOLLOW_2);
                    IdentifierRefParserRuleCall_2=norm1_IdentifierRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((IdentifierRefParserRuleCall_2!=null?((Token)IdentifierRefParserRuleCall_2.start):null), (IdentifierRefParserRuleCall_2!=null?((Token)IdentifierRefParserRuleCall_2.stop):null), grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2()); 
                    }

                    }
                    break;
                case 4 :
                    {
                    pushFollow(FOLLOW_2);
                    JSXFragmentParserRuleCall_3=ruleJSXFragment();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((JSXFragmentParserRuleCall_3!=null?((Token)JSXFragmentParserRuleCall_3.start):null), (JSXFragmentParserRuleCall_3!=null?((Token)JSXFragmentParserRuleCall_3.stop):null), grammarAccess.getPrimaryExpressionAccess().getJSXFragmentParserRuleCall_3()); 
                    }

                    }
                    break;
                case 5 :
                    {
                    pushFollow(FOLLOW_2);
                    JSXElementParserRuleCall_4=ruleJSXElement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((JSXElementParserRuleCall_4!=null?((Token)JSXElementParserRuleCall_4.start):null), (JSXElementParserRuleCall_4!=null?((Token)JSXElementParserRuleCall_4.stop):null), grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_4()); 
                    }

                    }
                    break;
                case 6 :
                    {
                    pushFollow(FOLLOW_2);
                    ImportCallExpressionParserRuleCall_5=norm1_ImportCallExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ImportCallExpressionParserRuleCall_5!=null?((Token)ImportCallExpressionParserRuleCall_5.start):null), (ImportCallExpressionParserRuleCall_5!=null?((Token)ImportCallExpressionParserRuleCall_5.stop):null), grammarAccess.getPrimaryExpressionAccess().getImportCallExpressionParserRuleCall_5()); 
                    }

                    }
                    break;
                case 7 :
                    {
                    pushFollow(FOLLOW_2);
                    ParameterizedCallExpressionParserRuleCall_6=norm1_ParameterizedCallExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ParameterizedCallExpressionParserRuleCall_6!=null?((Token)ParameterizedCallExpressionParserRuleCall_6.start):null), (ParameterizedCallExpressionParserRuleCall_6!=null?((Token)ParameterizedCallExpressionParserRuleCall_6.stop):null), grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_6()); 
                    }

                    }
                    break;
                case 8 :
                    {
                    pushFollow(FOLLOW_2);
                    LiteralParserRuleCall_7=ruleLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((LiteralParserRuleCall_7!=null?((Token)LiteralParserRuleCall_7.start):null), (LiteralParserRuleCall_7!=null?((Token)LiteralParserRuleCall_7.stop):null), grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_7()); 
                    }

                    }
                    break;
                case 9 :
                    {
                    pushFollow(FOLLOW_2);
                    ArrayLiteralParserRuleCall_8=norm1_ArrayLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ArrayLiteralParserRuleCall_8!=null?((Token)ArrayLiteralParserRuleCall_8.start):null), (ArrayLiteralParserRuleCall_8!=null?((Token)ArrayLiteralParserRuleCall_8.stop):null), grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_8()); 
                    }

                    }
                    break;
                case 10 :
                    {
                    pushFollow(FOLLOW_2);
                    ObjectLiteralParserRuleCall_9=norm1_ObjectLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ObjectLiteralParserRuleCall_9!=null?((Token)ObjectLiteralParserRuleCall_9.start):null), (ObjectLiteralParserRuleCall_9!=null?((Token)ObjectLiteralParserRuleCall_9.stop):null), grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_9()); 
                    }

                    }
                    break;
                case 11 :
                    {
                    pushFollow(FOLLOW_2);
                    ParenExpressionParserRuleCall_10=norm1_ParenExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ParenExpressionParserRuleCall_10!=null?((Token)ParenExpressionParserRuleCall_10.start):null), (ParenExpressionParserRuleCall_10!=null?((Token)ParenExpressionParserRuleCall_10.stop):null), grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_10()); 
                    }

                    }
                    break;
                case 12 :
                    {
                    pushFollow(FOLLOW_2);
                    AnnotatedExpressionParserRuleCall_11=norm1_AnnotatedExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AnnotatedExpressionParserRuleCall_11!=null?((Token)AnnotatedExpressionParserRuleCall_11.start):null), (AnnotatedExpressionParserRuleCall_11!=null?((Token)AnnotatedExpressionParserRuleCall_11.stop):null), grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_11()); 
                    }

                    }
                    break;
                case 13 :
                    {
                    pushFollow(FOLLOW_2);
                    FunctionExpressionParserRuleCall_12=ruleFunctionExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((FunctionExpressionParserRuleCall_12!=null?((Token)FunctionExpressionParserRuleCall_12.start):null), (FunctionExpressionParserRuleCall_12!=null?((Token)FunctionExpressionParserRuleCall_12.stop):null), grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_12()); 
                    }

                    }
                    break;
                case 14 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    AsyncFunctionExpressionParserRuleCall_13=ruleAsyncFunctionExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AsyncFunctionExpressionParserRuleCall_13!=null?((Token)AsyncFunctionExpressionParserRuleCall_13.start):null), (AsyncFunctionExpressionParserRuleCall_13!=null?((Token)AsyncFunctionExpressionParserRuleCall_13.stop):null), grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_13()); 
                    }

                    }


                    }
                    break;
                case 15 :
                    {
                    pushFollow(FOLLOW_2);
                    N4ClassExpressionParserRuleCall_14=norm1_N4ClassExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((N4ClassExpressionParserRuleCall_14!=null?((Token)N4ClassExpressionParserRuleCall_14.start):null), (N4ClassExpressionParserRuleCall_14!=null?((Token)N4ClassExpressionParserRuleCall_14.stop):null), grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_14()); 
                    }

                    }
                    break;
                case 16 :
                    {
                    pushFollow(FOLLOW_2);
                    TemplateLiteralParserRuleCall_15=norm1_TemplateLiteral();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((TemplateLiteralParserRuleCall_15!=null?((Token)TemplateLiteralParserRuleCall_15.start):null), (TemplateLiteralParserRuleCall_15!=null?((Token)TemplateLiteralParserRuleCall_15.stop):null), grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_15()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleParenExpression() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleParenExpression();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleParenExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleParenExpression_return ruleParenExpression() throws RecognitionException {
        InternalN4JSParser.ruleParenExpression_return retval = new InternalN4JSParser.ruleParenExpression_return();
        retval.start = input.LT(1);

        Token LeftParenthesisKeyword_0=null;
        Token RightParenthesisKeyword_2=null;
        InternalN4JSParser.norm1_Expression_return ExpressionExpressionParserRuleCall_1_0 = null;




        try {
            {
            {
            LeftParenthesisKeyword_0=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_0, grammarAccess.getParenExpressionAccess().getLeftParenthesisKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_1_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.start):null), (ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.stop):null), grammarAccess.getParenExpressionAccess().getExpressionAssignment_1());
              			
            }

            }


            }

            RightParenthesisKeyword_2=(Token)match(input,RightParenthesis,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_2, grammarAccess.getParenExpressionAccess().getRightParenthesisKeyword_2());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ParenExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ParenExpression_return norm1_ParenExpression() throws RecognitionException {
        InternalN4JSParser.norm1_ParenExpression_return retval = new InternalN4JSParser.norm1_ParenExpression_return();
        retval.start = input.LT(1);

        Token LeftParenthesisKeyword_0=null;
        Token RightParenthesisKeyword_2=null;
        InternalN4JSParser.norm3_Expression_return ExpressionExpressionParserRuleCall_1_0 = null;




        try {
            {
            {
            LeftParenthesisKeyword_0=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_0, grammarAccess.getParenExpressionAccess().getLeftParenthesisKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            ExpressionExpressionParserRuleCall_1_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.start):null), (ExpressionExpressionParserRuleCall_1_0!=null?((Token)ExpressionExpressionParserRuleCall_1_0.stop):null), grammarAccess.getParenExpressionAccess().getExpressionAssignment_1());
              			
            }

            }


            }

            RightParenthesisKeyword_2=(Token)match(input,RightParenthesis,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_2, grammarAccess.getParenExpressionAccess().getRightParenthesisKeyword_2());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleIdentifierRef() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleIdentifierRef();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleIdentifierRef_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleIdentifierRef_return ruleIdentifierRef() throws RecognitionException {
        InternalN4JSParser.ruleIdentifierRef_return retval = new InternalN4JSParser.ruleIdentifierRef_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleBindingIdentifier_return IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1 = null;

        InternalN4JSParser.ruleBindingIdentifier_return IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1 = null;

        InternalN4JSParser.ruleVersionRequest_return VersionRequestParserRuleCall_1_2 = null;




        try {
            {
            int alt233=2;
            alt233 = dfa233.predict(input);
            switch (alt233) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1!=null?((Token)IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1.start):null), (IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1!=null?((Token)IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1.stop):null), grammarAccess.getIdentifierRefAccess().getIdAssignment_0());
                      			
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_98);
                    IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1!=null?((Token)IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1.start):null), (IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1!=null?((Token)IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1.stop):null), grammarAccess.getIdentifierRefAccess().getIdAssignment_1_1());
                      				
                    }

                    }


                    }

                    pushFollow(FOLLOW_2);
                    VersionRequestParserRuleCall_1_2=ruleVersionRequest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VersionRequestParserRuleCall_1_2!=null?((Token)VersionRequestParserRuleCall_1_2.start):null), (VersionRequestParserRuleCall_1_2!=null?((Token)VersionRequestParserRuleCall_1_2.stop):null), grammarAccess.getIdentifierRefAccess().getVersionRequestParserRuleCall_1_2()); 
                    }

                    }


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_IdentifierRef_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_IdentifierRef_return norm1_IdentifierRef() throws RecognitionException {
        InternalN4JSParser.norm1_IdentifierRef_return retval = new InternalN4JSParser.norm1_IdentifierRef_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_BindingIdentifier_return IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1 = null;

        InternalN4JSParser.norm1_BindingIdentifier_return IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1 = null;

        InternalN4JSParser.ruleVersionRequest_return VersionRequestParserRuleCall_1_2 = null;




        try {
            {
            int alt234=2;
            alt234 = dfa234.predict(input);
            switch (alt234) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_2);
                    IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1!=null?((Token)IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1.start):null), (IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1!=null?((Token)IdIdentifiableElementBindingIdentifierParserRuleCall_0_0_1.stop):null), grammarAccess.getIdentifierRefAccess().getIdAssignment_0());
                      			
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_98);
                    IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1!=null?((Token)IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1.start):null), (IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1!=null?((Token)IdIdentifiableElementBindingIdentifierParserRuleCall_1_1_0_1.stop):null), grammarAccess.getIdentifierRefAccess().getIdAssignment_1_1());
                      				
                    }

                    }


                    }

                    pushFollow(FOLLOW_2);
                    VersionRequestParserRuleCall_1_2=ruleVersionRequest();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((VersionRequestParserRuleCall_1_2!=null?((Token)VersionRequestParserRuleCall_1_2.start):null), (VersionRequestParserRuleCall_1_2!=null?((Token)VersionRequestParserRuleCall_1_2.stop):null), grammarAccess.getIdentifierRefAccess().getVersionRequestParserRuleCall_1_2()); 
                    }

                    }


                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleSuperLiteral() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleSuperLiteral();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleSuperLiteral_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleSuperLiteral_return ruleSuperLiteral() throws RecognitionException {
        InternalN4JSParser.ruleSuperLiteral_return retval = new InternalN4JSParser.ruleSuperLiteral_return();
        retval.start = input.LT(1);

        Token SuperKeyword_1=null;



        try {
            {
            {
            SuperKeyword_1=(Token)match(input,Super,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(SuperKeyword_1, grammarAccess.getSuperLiteralAccess().getSuperKeyword_1());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleThisLiteral() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleThisLiteral();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleThisLiteral_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleThisLiteral_return ruleThisLiteral() throws RecognitionException {
        InternalN4JSParser.ruleThisLiteral_return retval = new InternalN4JSParser.ruleThisLiteral_return();
        retval.start = input.LT(1);

        Token ThisKeyword_1=null;



        try {
            {
            {
            ThisKeyword_1=(Token)match(input,This_1,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(ThisKeyword_1, grammarAccess.getThisLiteralAccess().getThisKeyword_1());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleArrayLiteral() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleArrayLiteral();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleArrayLiteral_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleArrayLiteral_return ruleArrayLiteral() throws RecognitionException {
        InternalN4JSParser.ruleArrayLiteral_return retval = new InternalN4JSParser.ruleArrayLiteral_return();
        retval.start = input.LT(1);

        Token LeftSquareBracketKeyword_1=null;
        Token CommaKeyword_3_1_0=null;
        Token TrailingCommaCommaKeyword_3_2_0_0=null;
        Token RightSquareBracketKeyword_4=null;
        InternalN4JSParser.ruleArrayPadding_return ElementsArrayPaddingParserRuleCall_2_0 = null;

        InternalN4JSParser.ruleArrayElement_return ElementsArrayElementParserRuleCall_3_0_0 = null;

        InternalN4JSParser.ruleArrayPadding_return ElementsArrayPaddingParserRuleCall_3_1_1_0 = null;

        InternalN4JSParser.ruleArrayElement_return ElementsArrayElementParserRuleCall_3_1_2_0 = null;

        InternalN4JSParser.ruleArrayPadding_return ElementsArrayPaddingParserRuleCall_3_2_1_0 = null;




        try {
            {
            {
            LeftSquareBracketKeyword_1=(Token)match(input,LeftSquareBracket,FOLLOW_99); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftSquareBracketKeyword_1, grammarAccess.getArrayLiteralAccess().getLeftSquareBracketKeyword_1());
              	
            }
            loop235:
            do {
                int alt235=2;
                int LA235_0 = input.LA(1);

                if ( (LA235_0==Comma) ) {
                    alt235=1;
                }


                switch (alt235) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_99);
            	    ElementsArrayPaddingParserRuleCall_2_0=ruleArrayPadding();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((ElementsArrayPaddingParserRuleCall_2_0!=null?((Token)ElementsArrayPaddingParserRuleCall_2_0.start):null), (ElementsArrayPaddingParserRuleCall_2_0!=null?((Token)ElementsArrayPaddingParserRuleCall_2_0.stop):null), grammarAccess.getArrayLiteralAccess().getElementsAssignment_2());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop235;
                }
            } while (true);
            int alt240=2;
            int LA240_0 = input.LA(1);

            if ( ((LA240_0>=Intersection && LA240_0<=Implements)||(LA240_0>=Promisify && LA240_0<=Abstract)||(LA240_0>=External && LA240_0<=Function)||(LA240_0>=Private && LA240_0<=Delete)||(LA240_0>=Import && LA240_0<=Public)||LA240_0==Static||(LA240_0>=Target && LA240_0<=Await)||LA240_0==Class||(LA240_0>=False && LA240_0<=Super)||LA240_0==Union||(LA240_0>=Yield && LA240_0<=This)||(LA240_0>=From && LA240_0<=Void)||LA240_0==FullStopFullStopFullStop||(LA240_0>=Get && LA240_0<=Set)||LA240_0==PlusSignPlusSign||LA240_0==HyphenMinusHyphenMinus||LA240_0==SolidusEqualsSign||LA240_0==As||LA240_0==Of||LA240_0==ExclamationMark||LA240_0==LeftParenthesis||LA240_0==PlusSign||LA240_0==HyphenMinus||LA240_0==Solidus||LA240_0==LessThanSign||(LA240_0>=CommercialAt && LA240_0<=LeftSquareBracket)||LA240_0==LeftCurlyBracket||LA240_0==Tilde||LA240_0==RULE_DOUBLE||(LA240_0>=RULE_HEX_INT && LA240_0<=RULE_LEGACY_OCTAL_INT)||LA240_0==RULE_SCIENTIFIC_INT||LA240_0==RULE_IDENTIFIER||LA240_0==RULE_STRING||(LA240_0>=RULE_TEMPLATE_HEAD && LA240_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA240_0==RULE_INT) ) {
                alt240=1;
            }
            switch (alt240) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_100);
                    ElementsArrayElementParserRuleCall_3_0_0=ruleArrayElement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((ElementsArrayElementParserRuleCall_3_0_0!=null?((Token)ElementsArrayElementParserRuleCall_3_0_0.start):null), (ElementsArrayElementParserRuleCall_3_0_0!=null?((Token)ElementsArrayElementParserRuleCall_3_0_0.stop):null), grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_0());
                      				
                    }

                    }


                    }
                    loop237:
                    do {
                        int alt237=2;
                        alt237 = dfa237.predict(input);
                        switch (alt237) {
                    	case 1 :
                    	    {
                    	    CommaKeyword_3_1_0=(Token)match(input,Comma,FOLLOW_101); if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      				announce(CommaKeyword_3_1_0, grammarAccess.getArrayLiteralAccess().getCommaKeyword_3_1_0());
                    	      			
                    	    }
                    	    loop236:
                    	    do {
                    	        int alt236=2;
                    	        int LA236_0 = input.LA(1);

                    	        if ( (LA236_0==Comma) ) {
                    	            alt236=1;
                    	        }


                    	        switch (alt236) {
                    	    	case 1 :
                    	    	    {
                    	    	    {
                    	    	    pushFollow(FOLLOW_101);
                    	    	    ElementsArrayPaddingParserRuleCall_3_1_1_0=ruleArrayPadding();

                    	    	    state._fsp--;
                    	    	    if (state.failed) return retval;
                    	    	    if ( state.backtracking==0 ) {

                    	    	      						announce((ElementsArrayPaddingParserRuleCall_3_1_1_0!=null?((Token)ElementsArrayPaddingParserRuleCall_3_1_1_0.start):null), (ElementsArrayPaddingParserRuleCall_3_1_1_0!=null?((Token)ElementsArrayPaddingParserRuleCall_3_1_1_0.stop):null), grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_1());
                    	    	      					
                    	    	    }

                    	    	    }


                    	    	    }
                    	    	    break;

                    	    	default :
                    	    	    break loop236;
                    	        }
                    	    } while (true);
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_100);
                    	    ElementsArrayElementParserRuleCall_3_1_2_0=ruleArrayElement();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      						announce((ElementsArrayElementParserRuleCall_3_1_2_0!=null?((Token)ElementsArrayElementParserRuleCall_3_1_2_0.start):null), (ElementsArrayElementParserRuleCall_3_1_2_0!=null?((Token)ElementsArrayElementParserRuleCall_3_1_2_0.stop):null), grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_2());
                    	      					
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop237;
                        }
                    } while (true);
                    int alt239=2;
                    int LA239_0 = input.LA(1);

                    if ( (LA239_0==Comma) ) {
                        alt239=1;
                    }
                    switch (alt239) {
                        case 1 :
                            {
                            {
                            {
                            TrailingCommaCommaKeyword_3_2_0_0=(Token)match(input,Comma,FOLLOW_100); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(TrailingCommaCommaKeyword_3_2_0_0, grammarAccess.getArrayLiteralAccess().getTrailingCommaCommaKeyword_3_2_0_0());
                              					
                            }

                            }


                            }
                            loop238:
                            do {
                                int alt238=2;
                                int LA238_0 = input.LA(1);

                                if ( (LA238_0==Comma) ) {
                                    alt238=1;
                                }


                                switch (alt238) {
                            	case 1 :
                            	    {
                            	    {
                            	    pushFollow(FOLLOW_100);
                            	    ElementsArrayPaddingParserRuleCall_3_2_1_0=ruleArrayPadding();

                            	    state._fsp--;
                            	    if (state.failed) return retval;
                            	    if ( state.backtracking==0 ) {

                            	      						announce((ElementsArrayPaddingParserRuleCall_3_2_1_0!=null?((Token)ElementsArrayPaddingParserRuleCall_3_2_1_0.start):null), (ElementsArrayPaddingParserRuleCall_3_2_1_0!=null?((Token)ElementsArrayPaddingParserRuleCall_3_2_1_0.stop):null), grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_2_1());
                            	      					
                            	    }

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop238;
                                }
                            } while (true);


                            }
                            break;

                    }


                    }
                    break;

            }

            RightSquareBracketKeyword_4=(Token)match(input,RightSquareBracket,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightSquareBracketKeyword_4, grammarAccess.getArrayLiteralAccess().getRightSquareBracketKeyword_4());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ArrayLiteral_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ArrayLiteral_return norm1_ArrayLiteral() throws RecognitionException {
        InternalN4JSParser.norm1_ArrayLiteral_return retval = new InternalN4JSParser.norm1_ArrayLiteral_return();
        retval.start = input.LT(1);

        Token LeftSquareBracketKeyword_1=null;
        Token CommaKeyword_3_1_0=null;
        Token TrailingCommaCommaKeyword_3_2_0_0=null;
        Token RightSquareBracketKeyword_4=null;
        InternalN4JSParser.ruleArrayPadding_return ElementsArrayPaddingParserRuleCall_2_0 = null;

        InternalN4JSParser.norm1_ArrayElement_return ElementsArrayElementParserRuleCall_3_0_0 = null;

        InternalN4JSParser.ruleArrayPadding_return ElementsArrayPaddingParserRuleCall_3_1_1_0 = null;

        InternalN4JSParser.norm1_ArrayElement_return ElementsArrayElementParserRuleCall_3_1_2_0 = null;

        InternalN4JSParser.ruleArrayPadding_return ElementsArrayPaddingParserRuleCall_3_2_1_0 = null;




        try {
            {
            {
            LeftSquareBracketKeyword_1=(Token)match(input,LeftSquareBracket,FOLLOW_102); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftSquareBracketKeyword_1, grammarAccess.getArrayLiteralAccess().getLeftSquareBracketKeyword_1());
              	
            }
            loop241:
            do {
                int alt241=2;
                int LA241_0 = input.LA(1);

                if ( (LA241_0==Comma) ) {
                    alt241=1;
                }


                switch (alt241) {
            	case 1 :
            	    {
            	    {
            	    pushFollow(FOLLOW_102);
            	    ElementsArrayPaddingParserRuleCall_2_0=ruleArrayPadding();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      				announce((ElementsArrayPaddingParserRuleCall_2_0!=null?((Token)ElementsArrayPaddingParserRuleCall_2_0.start):null), (ElementsArrayPaddingParserRuleCall_2_0!=null?((Token)ElementsArrayPaddingParserRuleCall_2_0.stop):null), grammarAccess.getArrayLiteralAccess().getElementsAssignment_2());
            	      			
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop241;
                }
            } while (true);
            int alt246=2;
            int LA246_0 = input.LA(1);

            if ( ((LA246_0>=Intersection && LA246_0<=Implements)||(LA246_0>=Promisify && LA246_0<=Abstract)||(LA246_0>=External && LA246_0<=Function)||(LA246_0>=Private && LA246_0<=Delete)||(LA246_0>=Import && LA246_0<=Public)||LA246_0==Static||(LA246_0>=Target && LA246_0<=Await)||LA246_0==Class||(LA246_0>=False && LA246_0<=Super)||LA246_0==Union||(LA246_0>=Yield && LA246_0<=This)||(LA246_0>=From && LA246_0<=Void)||LA246_0==FullStopFullStopFullStop||(LA246_0>=Get && LA246_0<=Set)||LA246_0==PlusSignPlusSign||LA246_0==HyphenMinusHyphenMinus||LA246_0==SolidusEqualsSign||LA246_0==As||LA246_0==Of||LA246_0==ExclamationMark||LA246_0==LeftParenthesis||LA246_0==PlusSign||LA246_0==HyphenMinus||LA246_0==Solidus||LA246_0==LessThanSign||(LA246_0>=CommercialAt && LA246_0<=LeftSquareBracket)||LA246_0==LeftCurlyBracket||LA246_0==Tilde||LA246_0==RULE_DOUBLE||(LA246_0>=RULE_HEX_INT && LA246_0<=RULE_LEGACY_OCTAL_INT)||LA246_0==RULE_SCIENTIFIC_INT||LA246_0==RULE_IDENTIFIER||LA246_0==RULE_STRING||(LA246_0>=RULE_TEMPLATE_HEAD && LA246_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA246_0==RULE_INT) ) {
                alt246=1;
            }
            switch (alt246) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_100);
                    ElementsArrayElementParserRuleCall_3_0_0=norm1_ArrayElement();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((ElementsArrayElementParserRuleCall_3_0_0!=null?((Token)ElementsArrayElementParserRuleCall_3_0_0.start):null), (ElementsArrayElementParserRuleCall_3_0_0!=null?((Token)ElementsArrayElementParserRuleCall_3_0_0.stop):null), grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_0());
                      				
                    }

                    }


                    }
                    loop243:
                    do {
                        int alt243=2;
                        alt243 = dfa243.predict(input);
                        switch (alt243) {
                    	case 1 :
                    	    {
                    	    CommaKeyword_3_1_0=(Token)match(input,Comma,FOLLOW_103); if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      				announce(CommaKeyword_3_1_0, grammarAccess.getArrayLiteralAccess().getCommaKeyword_3_1_0());
                    	      			
                    	    }
                    	    loop242:
                    	    do {
                    	        int alt242=2;
                    	        int LA242_0 = input.LA(1);

                    	        if ( (LA242_0==Comma) ) {
                    	            alt242=1;
                    	        }


                    	        switch (alt242) {
                    	    	case 1 :
                    	    	    {
                    	    	    {
                    	    	    pushFollow(FOLLOW_103);
                    	    	    ElementsArrayPaddingParserRuleCall_3_1_1_0=ruleArrayPadding();

                    	    	    state._fsp--;
                    	    	    if (state.failed) return retval;
                    	    	    if ( state.backtracking==0 ) {

                    	    	      						announce((ElementsArrayPaddingParserRuleCall_3_1_1_0!=null?((Token)ElementsArrayPaddingParserRuleCall_3_1_1_0.start):null), (ElementsArrayPaddingParserRuleCall_3_1_1_0!=null?((Token)ElementsArrayPaddingParserRuleCall_3_1_1_0.stop):null), grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_1());
                    	    	      					
                    	    	    }

                    	    	    }


                    	    	    }
                    	    	    break;

                    	    	default :
                    	    	    break loop242;
                    	        }
                    	    } while (true);
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_100);
                    	    ElementsArrayElementParserRuleCall_3_1_2_0=norm1_ArrayElement();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      						announce((ElementsArrayElementParserRuleCall_3_1_2_0!=null?((Token)ElementsArrayElementParserRuleCall_3_1_2_0.start):null), (ElementsArrayElementParserRuleCall_3_1_2_0!=null?((Token)ElementsArrayElementParserRuleCall_3_1_2_0.stop):null), grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_1_2());
                    	      					
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop243;
                        }
                    } while (true);
                    int alt245=2;
                    int LA245_0 = input.LA(1);

                    if ( (LA245_0==Comma) ) {
                        alt245=1;
                    }
                    switch (alt245) {
                        case 1 :
                            {
                            {
                            {
                            TrailingCommaCommaKeyword_3_2_0_0=(Token)match(input,Comma,FOLLOW_100); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(TrailingCommaCommaKeyword_3_2_0_0, grammarAccess.getArrayLiteralAccess().getTrailingCommaCommaKeyword_3_2_0_0());
                              					
                            }

                            }


                            }
                            loop244:
                            do {
                                int alt244=2;
                                int LA244_0 = input.LA(1);

                                if ( (LA244_0==Comma) ) {
                                    alt244=1;
                                }


                                switch (alt244) {
                            	case 1 :
                            	    {
                            	    {
                            	    pushFollow(FOLLOW_100);
                            	    ElementsArrayPaddingParserRuleCall_3_2_1_0=ruleArrayPadding();

                            	    state._fsp--;
                            	    if (state.failed) return retval;
                            	    if ( state.backtracking==0 ) {

                            	      						announce((ElementsArrayPaddingParserRuleCall_3_2_1_0!=null?((Token)ElementsArrayPaddingParserRuleCall_3_2_1_0.start):null), (ElementsArrayPaddingParserRuleCall_3_2_1_0!=null?((Token)ElementsArrayPaddingParserRuleCall_3_2_1_0.stop):null), grammarAccess.getArrayLiteralAccess().getElementsAssignment_3_2_1());
                            	      					
                            	    }

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop244;
                                }
                            } while (true);


                            }
                            break;

                    }


                    }
                    break;

            }

            RightSquareBracketKeyword_4=(Token)match(input,RightSquareBracket,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightSquareBracketKeyword_4, grammarAccess.getArrayLiteralAccess().getRightSquareBracketKeyword_4());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleArrayPadding() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleArrayPadding();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleArrayPadding_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleArrayPadding_return ruleArrayPadding() throws RecognitionException {
        InternalN4JSParser.ruleArrayPadding_return retval = new InternalN4JSParser.ruleArrayPadding_return();
        retval.start = input.LT(1);

        Token CommaKeyword_1=null;



        try {
            {
            {
            CommaKeyword_1=(Token)match(input,Comma,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(CommaKeyword_1, grammarAccess.getArrayPaddingAccess().getCommaKeyword_1());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleArrayElement() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleArrayElement();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleArrayElement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleArrayElement_return ruleArrayElement() throws RecognitionException {
        InternalN4JSParser.ruleArrayElement_return retval = new InternalN4JSParser.ruleArrayElement_return();
        retval.start = input.LT(1);

        Token SpreadFullStopFullStopFullStopKeyword_1_0=null;
        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_2_0 = null;




        try {
            {
            {
            int alt247=2;
            int LA247_0 = input.LA(1);

            if ( (LA247_0==FullStopFullStopFullStop) ) {
                alt247=1;
            }
            switch (alt247) {
                case 1 :
                    {
                    {
                    SpreadFullStopFullStopFullStopKeyword_1_0=(Token)match(input,FullStopFullStopFullStop,FOLLOW_49); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(SpreadFullStopFullStopFullStopKeyword_1_0, grammarAccess.getArrayElementAccess().getSpreadFullStopFullStopFullStopKeyword_1_0());
                      			
                    }

                    }


                    }
                    break;

            }
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_2_0=norm1_AssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionAssignmentExpressionParserRuleCall_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_0.stop):null), grammarAccess.getArrayElementAccess().getExpressionAssignment_2());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ArrayElement_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ArrayElement_return norm1_ArrayElement() throws RecognitionException {
        InternalN4JSParser.norm1_ArrayElement_return retval = new InternalN4JSParser.norm1_ArrayElement_return();
        retval.start = input.LT(1);

        Token SpreadFullStopFullStopFullStopKeyword_1_0=null;
        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_2_0 = null;




        try {
            {
            {
            int alt248=2;
            int LA248_0 = input.LA(1);

            if ( (LA248_0==FullStopFullStopFullStop) ) {
                alt248=1;
            }
            switch (alt248) {
                case 1 :
                    {
                    {
                    SpreadFullStopFullStopFullStopKeyword_1_0=(Token)match(input,FullStopFullStopFullStop,FOLLOW_70); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(SpreadFullStopFullStopFullStopKeyword_1_0, grammarAccess.getArrayElementAccess().getSpreadFullStopFullStopFullStopKeyword_1_0());
                      			
                    }

                    }


                    }
                    break;

            }
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_2_0=norm3_AssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionAssignmentExpressionParserRuleCall_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_2_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_0.stop):null), grammarAccess.getArrayElementAccess().getExpressionAssignment_2());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleObjectLiteral() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleObjectLiteral();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleObjectLiteral_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleObjectLiteral_return ruleObjectLiteral() throws RecognitionException {
        InternalN4JSParser.ruleObjectLiteral_return retval = new InternalN4JSParser.ruleObjectLiteral_return();
        retval.start = input.LT(1);

        Token LeftCurlyBracketKeyword_1=null;
        Token CommaKeyword_2_1_0=null;
        Token CommaKeyword_2_2=null;
        Token RightCurlyBracketKeyword_3=null;
        InternalN4JSParser.rulePropertyAssignment_return PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0 = null;

        InternalN4JSParser.rulePropertyAssignment_return PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0 = null;




        try {
            {
            {
            LeftCurlyBracketKeyword_1=(Token)match(input,LeftCurlyBracket,FOLLOW_104); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftCurlyBracketKeyword_1, grammarAccess.getObjectLiteralAccess().getLeftCurlyBracketKeyword_1());
              	
            }
            int alt251=2;
            int LA251_0 = input.LA(1);

            if ( ((LA251_0>=Intersection && LA251_0<=With)||(LA251_0>=For && LA251_0<=Var)||(LA251_0>=As && LA251_0<=Of)||LA251_0==LeftParenthesis||LA251_0==Asterisk||LA251_0==LessThanSign||(LA251_0>=CommercialAt && LA251_0<=LeftSquareBracket)||LA251_0==LeftCurlyBracket||LA251_0==Tilde||LA251_0==RULE_DOUBLE||LA251_0==RULE_HEX_INT||LA251_0==RULE_OCTAL_INT||LA251_0==RULE_SCIENTIFIC_INT||LA251_0==RULE_IDENTIFIER||LA251_0==RULE_STRING||LA251_0==RULE_INT) ) {
                alt251=1;
            }
            switch (alt251) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_15);
                    PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0=rulePropertyAssignment();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0!=null?((Token)PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0.start):null), (PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0!=null?((Token)PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0.stop):null), grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_0());
                      				
                    }

                    }


                    }
                    loop249:
                    do {
                        int alt249=2;
                        int LA249_0 = input.LA(1);

                        if ( (LA249_0==Comma) ) {
                            int LA249_1 = input.LA(2);

                            if ( ((LA249_1>=Intersection && LA249_1<=With)||(LA249_1>=For && LA249_1<=Var)||(LA249_1>=As && LA249_1<=Of)||LA249_1==LeftParenthesis||LA249_1==Asterisk||LA249_1==LessThanSign||(LA249_1>=CommercialAt && LA249_1<=LeftSquareBracket)||LA249_1==LeftCurlyBracket||LA249_1==Tilde||LA249_1==RULE_DOUBLE||LA249_1==RULE_HEX_INT||LA249_1==RULE_OCTAL_INT||LA249_1==RULE_SCIENTIFIC_INT||LA249_1==RULE_IDENTIFIER||LA249_1==RULE_STRING||LA249_1==RULE_INT) ) {
                                alt249=1;
                            }


                        }


                        switch (alt249) {
                    	case 1 :
                    	    {
                    	    CommaKeyword_2_1_0=(Token)match(input,Comma,FOLLOW_105); if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      				announce(CommaKeyword_2_1_0, grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_1_0());
                    	      			
                    	    }
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_15);
                    	    PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0=rulePropertyAssignment();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      						announce((PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0!=null?((Token)PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0.start):null), (PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0!=null?((Token)PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0.stop):null), grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_1_1());
                    	      					
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop249;
                        }
                    } while (true);
                    int alt250=2;
                    int LA250_0 = input.LA(1);

                    if ( (LA250_0==Comma) ) {
                        alt250=1;
                    }
                    switch (alt250) {
                        case 1 :
                            {
                            CommaKeyword_2_2=(Token)match(input,Comma,FOLLOW_23); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              				announce(CommaKeyword_2_2, grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_2());
                              			
                            }

                            }
                            break;

                    }


                    }
                    break;

            }

            RightCurlyBracketKeyword_3=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightCurlyBracketKeyword_3, grammarAccess.getObjectLiteralAccess().getRightCurlyBracketKeyword_3());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ObjectLiteral_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ObjectLiteral_return norm1_ObjectLiteral() throws RecognitionException {
        InternalN4JSParser.norm1_ObjectLiteral_return retval = new InternalN4JSParser.norm1_ObjectLiteral_return();
        retval.start = input.LT(1);

        Token LeftCurlyBracketKeyword_1=null;
        Token CommaKeyword_2_1_0=null;
        Token CommaKeyword_2_2=null;
        Token RightCurlyBracketKeyword_3=null;
        InternalN4JSParser.norm1_PropertyAssignment_return PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0 = null;

        InternalN4JSParser.norm1_PropertyAssignment_return PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0 = null;




        try {
            {
            {
            LeftCurlyBracketKeyword_1=(Token)match(input,LeftCurlyBracket,FOLLOW_104); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftCurlyBracketKeyword_1, grammarAccess.getObjectLiteralAccess().getLeftCurlyBracketKeyword_1());
              	
            }
            int alt254=2;
            int LA254_0 = input.LA(1);

            if ( ((LA254_0>=Intersection && LA254_0<=With)||(LA254_0>=For && LA254_0<=Var)||(LA254_0>=As && LA254_0<=Of)||LA254_0==LeftParenthesis||LA254_0==Asterisk||LA254_0==LessThanSign||(LA254_0>=CommercialAt && LA254_0<=LeftSquareBracket)||LA254_0==LeftCurlyBracket||LA254_0==Tilde||LA254_0==RULE_DOUBLE||LA254_0==RULE_HEX_INT||LA254_0==RULE_OCTAL_INT||LA254_0==RULE_SCIENTIFIC_INT||LA254_0==RULE_IDENTIFIER||LA254_0==RULE_STRING||LA254_0==RULE_INT) ) {
                alt254=1;
            }
            switch (alt254) {
                case 1 :
                    {
                    {
                    {
                    pushFollow(FOLLOW_15);
                    PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0=norm1_PropertyAssignment();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0!=null?((Token)PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0.start):null), (PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0!=null?((Token)PropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0.stop):null), grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_0());
                      				
                    }

                    }


                    }
                    loop252:
                    do {
                        int alt252=2;
                        int LA252_0 = input.LA(1);

                        if ( (LA252_0==Comma) ) {
                            int LA252_1 = input.LA(2);

                            if ( ((LA252_1>=Intersection && LA252_1<=With)||(LA252_1>=For && LA252_1<=Var)||(LA252_1>=As && LA252_1<=Of)||LA252_1==LeftParenthesis||LA252_1==Asterisk||LA252_1==LessThanSign||(LA252_1>=CommercialAt && LA252_1<=LeftSquareBracket)||LA252_1==LeftCurlyBracket||LA252_1==Tilde||LA252_1==RULE_DOUBLE||LA252_1==RULE_HEX_INT||LA252_1==RULE_OCTAL_INT||LA252_1==RULE_SCIENTIFIC_INT||LA252_1==RULE_IDENTIFIER||LA252_1==RULE_STRING||LA252_1==RULE_INT) ) {
                                alt252=1;
                            }


                        }


                        switch (alt252) {
                    	case 1 :
                    	    {
                    	    CommaKeyword_2_1_0=(Token)match(input,Comma,FOLLOW_105); if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      				announce(CommaKeyword_2_1_0, grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_1_0());
                    	      			
                    	    }
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_15);
                    	    PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0=norm1_PropertyAssignment();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      						announce((PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0!=null?((Token)PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0.start):null), (PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0!=null?((Token)PropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0.stop):null), grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsAssignment_2_1_1());
                    	      					
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop252;
                        }
                    } while (true);
                    int alt253=2;
                    int LA253_0 = input.LA(1);

                    if ( (LA253_0==Comma) ) {
                        alt253=1;
                    }
                    switch (alt253) {
                        case 1 :
                            {
                            CommaKeyword_2_2=(Token)match(input,Comma,FOLLOW_23); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              				announce(CommaKeyword_2_2, grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_2());
                              			
                            }

                            }
                            break;

                    }


                    }
                    break;

            }

            RightCurlyBracketKeyword_3=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightCurlyBracketKeyword_3, grammarAccess.getObjectLiteralAccess().getRightCurlyBracketKeyword_3());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRulePropertyAssignment() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            rulePropertyAssignment();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class rulePropertyAssignment_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.rulePropertyAssignment_return rulePropertyAssignment() throws RecognitionException {
        InternalN4JSParser.rulePropertyAssignment_return retval = new InternalN4JSParser.rulePropertyAssignment_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleAnnotatedPropertyAssignment_return AnnotatedPropertyAssignmentParserRuleCall_0 = null;

        InternalN4JSParser.rulePropertyNameValuePair_return PropertyNameValuePairParserRuleCall_1 = null;

        InternalN4JSParser.rulePropertyGetterDeclaration_return PropertyGetterDeclarationParserRuleCall_2 = null;

        InternalN4JSParser.rulePropertySetterDeclaration_return PropertySetterDeclarationParserRuleCall_3 = null;

        InternalN4JSParser.rulePropertyMethodDeclaration_return PropertyMethodDeclarationParserRuleCall_4 = null;

        InternalN4JSParser.rulePropertyNameValuePairSingleName_return PropertyNameValuePairSingleNameParserRuleCall_5 = null;




        try {
            {
            int alt255=6;
            alt255 = dfa255.predict(input);
            switch (alt255) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    AnnotatedPropertyAssignmentParserRuleCall_0=ruleAnnotatedPropertyAssignment();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AnnotatedPropertyAssignmentParserRuleCall_0!=null?((Token)AnnotatedPropertyAssignmentParserRuleCall_0.start):null), (AnnotatedPropertyAssignmentParserRuleCall_0!=null?((Token)AnnotatedPropertyAssignmentParserRuleCall_0.stop):null), grammarAccess.getPropertyAssignmentAccess().getAnnotatedPropertyAssignmentParserRuleCall_0()); 
                    }

                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    PropertyNameValuePairParserRuleCall_1=rulePropertyNameValuePair();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((PropertyNameValuePairParserRuleCall_1!=null?((Token)PropertyNameValuePairParserRuleCall_1.start):null), (PropertyNameValuePairParserRuleCall_1!=null?((Token)PropertyNameValuePairParserRuleCall_1.stop):null), grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    PropertyGetterDeclarationParserRuleCall_2=rulePropertyGetterDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((PropertyGetterDeclarationParserRuleCall_2!=null?((Token)PropertyGetterDeclarationParserRuleCall_2.start):null), (PropertyGetterDeclarationParserRuleCall_2!=null?((Token)PropertyGetterDeclarationParserRuleCall_2.stop):null), grammarAccess.getPropertyAssignmentAccess().getPropertyGetterDeclarationParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    PropertySetterDeclarationParserRuleCall_3=rulePropertySetterDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((PropertySetterDeclarationParserRuleCall_3!=null?((Token)PropertySetterDeclarationParserRuleCall_3.start):null), (PropertySetterDeclarationParserRuleCall_3!=null?((Token)PropertySetterDeclarationParserRuleCall_3.stop):null), grammarAccess.getPropertyAssignmentAccess().getPropertySetterDeclarationParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    PropertyMethodDeclarationParserRuleCall_4=rulePropertyMethodDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((PropertyMethodDeclarationParserRuleCall_4!=null?((Token)PropertyMethodDeclarationParserRuleCall_4.start):null), (PropertyMethodDeclarationParserRuleCall_4!=null?((Token)PropertyMethodDeclarationParserRuleCall_4.stop):null), grammarAccess.getPropertyAssignmentAccess().getPropertyMethodDeclarationParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    pushFollow(FOLLOW_2);
                    PropertyNameValuePairSingleNameParserRuleCall_5=rulePropertyNameValuePairSingleName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((PropertyNameValuePairSingleNameParserRuleCall_5!=null?((Token)PropertyNameValuePairSingleNameParserRuleCall_5.start):null), (PropertyNameValuePairSingleNameParserRuleCall_5!=null?((Token)PropertyNameValuePairSingleNameParserRuleCall_5.stop):null), grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairSingleNameParserRuleCall_5()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_PropertyAssignment_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_PropertyAssignment_return norm1_PropertyAssignment() throws RecognitionException {
        InternalN4JSParser.norm1_PropertyAssignment_return retval = new InternalN4JSParser.norm1_PropertyAssignment_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_AnnotatedPropertyAssignment_return AnnotatedPropertyAssignmentParserRuleCall_0 = null;

        InternalN4JSParser.norm1_PropertyNameValuePair_return PropertyNameValuePairParserRuleCall_1 = null;

        InternalN4JSParser.norm1_PropertyGetterDeclaration_return PropertyGetterDeclarationParserRuleCall_2 = null;

        InternalN4JSParser.norm1_PropertySetterDeclaration_return PropertySetterDeclarationParserRuleCall_3 = null;

        InternalN4JSParser.norm1_PropertyMethodDeclaration_return PropertyMethodDeclarationParserRuleCall_4 = null;

        InternalN4JSParser.norm1_PropertyNameValuePairSingleName_return PropertyNameValuePairSingleNameParserRuleCall_5 = null;




        try {
            {
            int alt256=6;
            alt256 = dfa256.predict(input);
            switch (alt256) {
                case 1 :
                    {
                    pushFollow(FOLLOW_2);
                    AnnotatedPropertyAssignmentParserRuleCall_0=norm1_AnnotatedPropertyAssignment();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((AnnotatedPropertyAssignmentParserRuleCall_0!=null?((Token)AnnotatedPropertyAssignmentParserRuleCall_0.start):null), (AnnotatedPropertyAssignmentParserRuleCall_0!=null?((Token)AnnotatedPropertyAssignmentParserRuleCall_0.stop):null), grammarAccess.getPropertyAssignmentAccess().getAnnotatedPropertyAssignmentParserRuleCall_0()); 
                    }

                    }
                    break;
                case 2 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    PropertyNameValuePairParserRuleCall_1=norm1_PropertyNameValuePair();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((PropertyNameValuePairParserRuleCall_1!=null?((Token)PropertyNameValuePairParserRuleCall_1.start):null), (PropertyNameValuePairParserRuleCall_1!=null?((Token)PropertyNameValuePairParserRuleCall_1.stop):null), grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairParserRuleCall_1()); 
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    PropertyGetterDeclarationParserRuleCall_2=norm1_PropertyGetterDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((PropertyGetterDeclarationParserRuleCall_2!=null?((Token)PropertyGetterDeclarationParserRuleCall_2.start):null), (PropertyGetterDeclarationParserRuleCall_2!=null?((Token)PropertyGetterDeclarationParserRuleCall_2.stop):null), grammarAccess.getPropertyAssignmentAccess().getPropertyGetterDeclarationParserRuleCall_2()); 
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    PropertySetterDeclarationParserRuleCall_3=norm1_PropertySetterDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((PropertySetterDeclarationParserRuleCall_3!=null?((Token)PropertySetterDeclarationParserRuleCall_3.start):null), (PropertySetterDeclarationParserRuleCall_3!=null?((Token)PropertySetterDeclarationParserRuleCall_3.stop):null), grammarAccess.getPropertyAssignmentAccess().getPropertySetterDeclarationParserRuleCall_3()); 
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    pushFollow(FOLLOW_2);
                    PropertyMethodDeclarationParserRuleCall_4=norm1_PropertyMethodDeclaration();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((PropertyMethodDeclarationParserRuleCall_4!=null?((Token)PropertyMethodDeclarationParserRuleCall_4.start):null), (PropertyMethodDeclarationParserRuleCall_4!=null?((Token)PropertyMethodDeclarationParserRuleCall_4.stop):null), grammarAccess.getPropertyAssignmentAccess().getPropertyMethodDeclarationParserRuleCall_4()); 
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    pushFollow(FOLLOW_2);
                    PropertyNameValuePairSingleNameParserRuleCall_5=norm1_PropertyNameValuePairSingleName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((PropertyNameValuePairSingleNameParserRuleCall_5!=null?((Token)PropertyNameValuePairSingleNameParserRuleCall_5.start):null), (PropertyNameValuePairSingleNameParserRuleCall_5!=null?((Token)PropertyNameValuePairSingleNameParserRuleCall_5.stop):null), grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairSingleNameParserRuleCall_5()); 
                    }

                    }
                    break;

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleAnnotatedPropertyAssignment() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleAnnotatedPropertyAssignment();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleAnnotatedPropertyAssignment_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleAnnotatedPropertyAssignment_return ruleAnnotatedPropertyAssignment() throws RecognitionException {
        InternalN4JSParser.ruleAnnotatedPropertyAssignment_return retval = new InternalN4JSParser.ruleAnnotatedPropertyAssignment_return();
        retval.start = input.LT(1);

        Token ColonKeyword_1_0_0_0_3=null;
        Token SetKeyword_1_2_0_0_1=null;
        Token DeclaredOptionalQuestionMarkKeyword_1_2_1_0=null;
        Token LeftParenthesisKeyword_1_2_2=null;
        Token RightParenthesisKeyword_1_2_4=null;
        Token GeneratorAsteriskKeyword_1_3_0_0_3_0_0_0=null;
        Token SemicolonKeyword_1_3_1=null;
        Token EqualsSignKeyword_1_4_3_0=null;
        InternalN4JSParser.rulePropertyAssignmentAnnotationList_return PropertyAssignmentAnnotationListParserRuleCall_0 = null;

        InternalN4JSParser.ruleTypeRefWithModifiers_return DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0 = null;

        InternalN4JSParser.ruleLiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0_1_0 = null;

        InternalN4JSParser.ruleGetterHeader_return GetterHeaderParserRuleCall_1_1_0_0_1 = null;

        InternalN4JSParser.ruleBlock_return BodyBlockParserRuleCall_1_1_1_0 = null;

        InternalN4JSParser.ruleLiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0 = null;

        InternalN4JSParser.ruleFormalParameter_return FparFormalParameterParserRuleCall_1_2_3_0 = null;

        InternalN4JSParser.ruleBlock_return BodyBlockParserRuleCall_1_2_5_0 = null;

        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_1_3_0_0_1 = null;

        InternalN4JSParser.ruleTypeRefWithModifiers_return ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0 = null;

        InternalN4JSParser.ruleLiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0 = null;

        InternalN4JSParser.norm1_MethodParamsAndBody_return MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2 = null;

        InternalN4JSParser.ruleLiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0 = null;

        InternalN4JSParser.ruleMethodParamsAndBody_return MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1 = null;

        InternalN4JSParser.ruleTypeRef_return DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0 = null;

        InternalN4JSParser.ruleIdentifierRef_return IdentifierRefIdentifierRefParserRuleCall_1_4_2_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0 = null;




        try {
            {
            {
            pushFollow(FOLLOW_106);
            PropertyAssignmentAnnotationListParserRuleCall_0=rulePropertyAssignmentAnnotationList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((PropertyAssignmentAnnotationListParserRuleCall_0!=null?((Token)PropertyAssignmentAnnotationListParserRuleCall_0.start):null), (PropertyAssignmentAnnotationListParserRuleCall_0!=null?((Token)PropertyAssignmentAnnotationListParserRuleCall_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyAssignmentAnnotationListParserRuleCall_0()); 
            }
            int alt265=5;
            alt265 = dfa265.predict(input);
            switch (alt265) {
                case 1 :
                    {
                    {
                    {
                    {
                    int alt257=2;
                    alt257 = dfa257.predict(input);
                    switch (alt257) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_107);
                            DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0=ruleTypeRefWithModifiers();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              								announce((DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0!=null?((Token)DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0.start):null), (DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0!=null?((Token)DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_0_0_0_1());
                              							
                            }

                            }


                            }
                            break;

                    }
                    {
                    {
                    pushFollow(FOLLOW_94);
                    DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0=ruleLiteralOrComputedPropertyName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      								announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_0_0_0_2());
                      							
                    }

                    }


                    }

                    ColonKeyword_1_0_0_0_3=(Token)match(input,Colon,FOLLOW_49); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(ColonKeyword_1_0_0_0_3, grammarAccess.getAnnotatedPropertyAssignmentAccess().getColonKeyword_1_0_0_0_3());
                      					
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_0_1_0=norm1_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((ExpressionAssignmentExpressionParserRuleCall_1_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_0_1());
                      					
                    }

                    }


                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_13);
                    GetterHeaderParserRuleCall_1_1_0_0_1=ruleGetterHeader();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((GetterHeaderParserRuleCall_1_1_0_0_1!=null?((Token)GetterHeaderParserRuleCall_1_1_0_0_1.start):null), (GetterHeaderParserRuleCall_1_1_0_0_1!=null?((Token)GetterHeaderParserRuleCall_1_1_0_0_1.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getGetterHeaderParserRuleCall_1_1_0_0_1()); 
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BodyBlockParserRuleCall_1_1_1_0=ruleBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((BodyBlockParserRuleCall_1_1_1_0!=null?((Token)BodyBlockParserRuleCall_1_1_1_0.start):null), (BodyBlockParserRuleCall_1_1_1_0!=null?((Token)BodyBlockParserRuleCall_1_1_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_1_1());
                      					
                    }

                    }


                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    {
                    SetKeyword_1_2_0_0_1=(Token)match(input,Set,FOLLOW_107); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(SetKeyword_1_2_0_0_1, grammarAccess.getAnnotatedPropertyAssignmentAccess().getSetKeyword_1_2_0_0_1());
                      					
                    }
                    {
                    {
                    pushFollow(FOLLOW_108);
                    DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0=ruleLiteralOrComputedPropertyName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      								announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_2_0_0_2());
                      							
                    }

                    }


                    }


                    }


                    }
                    int alt258=2;
                    int LA258_0 = input.LA(1);

                    if ( (LA258_0==QuestionMark) ) {
                        alt258=1;
                    }
                    switch (alt258) {
                        case 1 :
                            {
                            {
                            DeclaredOptionalQuestionMarkKeyword_1_2_1_0=(Token)match(input,QuestionMark,FOLLOW_42); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(DeclaredOptionalQuestionMarkKeyword_1_2_1_0, grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredOptionalQuestionMarkKeyword_1_2_1_0());
                              					
                            }

                            }


                            }
                            break;

                    }

                    LeftParenthesisKeyword_1_2_2=(Token)match(input,LeftParenthesis,FOLLOW_55); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(LeftParenthesisKeyword_1_2_2, grammarAccess.getAnnotatedPropertyAssignmentAccess().getLeftParenthesisKeyword_1_2_2());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_72);
                    FparFormalParameterParserRuleCall_1_2_3_0=ruleFormalParameter();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((FparFormalParameterParserRuleCall_1_2_3_0!=null?((Token)FparFormalParameterParserRuleCall_1_2_3_0.start):null), (FparFormalParameterParserRuleCall_1_2_3_0!=null?((Token)FparFormalParameterParserRuleCall_1_2_3_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getFparAssignment_1_2_3());
                      					
                    }

                    }


                    }

                    RightParenthesisKeyword_1_2_4=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(RightParenthesisKeyword_1_2_4, grammarAccess.getAnnotatedPropertyAssignmentAccess().getRightParenthesisKeyword_1_2_4());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BodyBlockParserRuleCall_1_2_5_0=ruleBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((BodyBlockParserRuleCall_1_2_5_0!=null?((Token)BodyBlockParserRuleCall_1_2_5_0.start):null), (BodyBlockParserRuleCall_1_2_5_0!=null?((Token)BodyBlockParserRuleCall_1_2_5_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_2_5());
                      					
                    }

                    }


                    }


                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    {
                    {
                    int alt259=2;
                    int LA259_0 = input.LA(1);

                    if ( (LA259_0==LessThanSign) ) {
                        alt259=1;
                    }
                    switch (alt259) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_109);
                            TypeVariablesParserRuleCall_1_3_0_0_1=ruleTypeVariables();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((TypeVariablesParserRuleCall_1_3_0_0_1!=null?((Token)TypeVariablesParserRuleCall_1_3_0_0_1.start):null), (TypeVariablesParserRuleCall_1_3_0_0_1!=null?((Token)TypeVariablesParserRuleCall_1_3_0_0_1.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getTypeVariablesParserRuleCall_1_3_0_0_1()); 
                            }

                            }
                            break;

                    }
                    int alt260=2;
                    alt260 = dfa260.predict(input);
                    switch (alt260) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_109);
                            ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0=ruleTypeRefWithModifiers();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              								announce((ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0!=null?((Token)ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0.start):null), (ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0!=null?((Token)ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getReturnTypeRefAssignment_1_3_0_0_2());
                              							
                            }

                            }


                            }
                            break;

                    }
                    int alt261=2;
                    int LA261_0 = input.LA(1);

                    if ( (LA261_0==Asterisk) ) {
                        alt261=1;
                    }
                    else if ( ((LA261_0>=Intersection && LA261_0<=With)||(LA261_0>=For && LA261_0<=Var)||(LA261_0>=As && LA261_0<=Of)||LA261_0==LeftSquareBracket||LA261_0==RULE_DOUBLE||LA261_0==RULE_HEX_INT||LA261_0==RULE_OCTAL_INT||LA261_0==RULE_SCIENTIFIC_INT||LA261_0==RULE_IDENTIFIER||LA261_0==RULE_STRING||LA261_0==RULE_INT) ) {
                        alt261=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 261, 0, input);

                        throw nvae;
                    }
                    switch (alt261) {
                        case 1 :
                            {
                            {
                            {
                            {
                            GeneratorAsteriskKeyword_1_3_0_0_3_0_0_0=(Token)match(input,Asterisk,FOLLOW_107); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              										announce(GeneratorAsteriskKeyword_1_3_0_0_3_0_0_0, grammarAccess.getAnnotatedPropertyAssignmentAccess().getGeneratorAsteriskKeyword_1_3_0_0_3_0_0_0());
                              									
                            }

                            }


                            }
                            {
                            {
                            pushFollow(FOLLOW_39);
                            DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0=ruleLiteralOrComputedPropertyName();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              										announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_0_1());
                              									
                            }

                            }


                            }
                            {
                            pushFollow(FOLLOW_110);
                            MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2=norm1_MethodParamsAndBody();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2!=null?((Token)MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2.start):null), (MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2!=null?((Token)MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2()); 
                            }

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            {
                            {
                            pushFollow(FOLLOW_42);
                            DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0=ruleLiteralOrComputedPropertyName();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              										announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_1_0());
                              									
                            }

                            }


                            }
                            {
                            pushFollow(FOLLOW_110);
                            MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1=ruleMethodParamsAndBody();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1!=null?((Token)MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1.start):null), (MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1!=null?((Token)MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1()); 
                            }

                            }


                            }


                            }
                            break;

                    }


                    }


                    }
                    int alt262=2;
                    int LA262_0 = input.LA(1);

                    if ( (LA262_0==Semicolon) ) {
                        alt262=1;
                    }
                    switch (alt262) {
                        case 1 :
                            {
                            SemicolonKeyword_1_3_1=(Token)match(input,Semicolon,FOLLOW_2); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              					announce(SemicolonKeyword_1_3_1, grammarAccess.getAnnotatedPropertyAssignmentAccess().getSemicolonKeyword_1_3_1());
                              				
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    int alt263=2;
                    alt263 = dfa263.predict(input);
                    switch (alt263) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_8);
                            DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0=ruleTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce((DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0!=null?((Token)DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0.start):null), (DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0!=null?((Token)DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_4_1());
                              					
                            }

                            }


                            }
                            break;

                    }
                    {
                    {
                    pushFollow(FOLLOW_63);
                    IdentifierRefIdentifierRefParserRuleCall_1_4_2_0=ruleIdentifierRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((IdentifierRefIdentifierRefParserRuleCall_1_4_2_0!=null?((Token)IdentifierRefIdentifierRefParserRuleCall_1_4_2_0.start):null), (IdentifierRefIdentifierRefParserRuleCall_1_4_2_0!=null?((Token)IdentifierRefIdentifierRefParserRuleCall_1_4_2_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getIdentifierRefAssignment_1_4_2());
                      					
                    }

                    }


                    }
                    int alt264=2;
                    int LA264_0 = input.LA(1);

                    if ( (LA264_0==EqualsSign) ) {
                        alt264=1;
                    }
                    switch (alt264) {
                        case 1 :
                            {
                            EqualsSignKeyword_1_4_3_0=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              					announce(EqualsSignKeyword_1_4_3_0, grammarAccess.getAnnotatedPropertyAssignmentAccess().getEqualsSignKeyword_1_4_3_0());
                              				
                            }
                            {
                            {
                            pushFollow(FOLLOW_2);
                            ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0=norm1_AssignmentExpression();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              							announce((ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_4_3_1());
                              						
                            }

                            }


                            }


                            }
                            break;

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_AnnotatedPropertyAssignment_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_AnnotatedPropertyAssignment_return norm1_AnnotatedPropertyAssignment() throws RecognitionException {
        InternalN4JSParser.norm1_AnnotatedPropertyAssignment_return retval = new InternalN4JSParser.norm1_AnnotatedPropertyAssignment_return();
        retval.start = input.LT(1);

        Token ColonKeyword_1_0_0_0_3=null;
        Token SetKeyword_1_2_0_0_1=null;
        Token DeclaredOptionalQuestionMarkKeyword_1_2_1_0=null;
        Token LeftParenthesisKeyword_1_2_2=null;
        Token RightParenthesisKeyword_1_2_4=null;
        Token GeneratorAsteriskKeyword_1_3_0_0_3_0_0_0=null;
        Token SemicolonKeyword_1_3_1=null;
        Token EqualsSignKeyword_1_4_3_0=null;
        InternalN4JSParser.rulePropertyAssignmentAnnotationList_return PropertyAssignmentAnnotationListParserRuleCall_0 = null;

        InternalN4JSParser.ruleTypeRefWithModifiers_return DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0 = null;

        InternalN4JSParser.norm1_LiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0_1_0 = null;

        InternalN4JSParser.norm1_GetterHeader_return GetterHeaderParserRuleCall_1_1_0_0_1 = null;

        InternalN4JSParser.ruleBlock_return BodyBlockParserRuleCall_1_1_1_0 = null;

        InternalN4JSParser.norm1_LiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0 = null;

        InternalN4JSParser.norm1_FormalParameter_return FparFormalParameterParserRuleCall_1_2_3_0 = null;

        InternalN4JSParser.ruleBlock_return BodyBlockParserRuleCall_1_2_5_0 = null;

        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_1_3_0_0_1 = null;

        InternalN4JSParser.ruleTypeRefWithModifiers_return ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0 = null;

        InternalN4JSParser.norm1_LiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0 = null;

        InternalN4JSParser.norm1_MethodParamsAndBody_return MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2 = null;

        InternalN4JSParser.norm1_LiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0 = null;

        InternalN4JSParser.ruleMethodParamsAndBody_return MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1 = null;

        InternalN4JSParser.ruleTypeRef_return DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0 = null;

        InternalN4JSParser.norm1_IdentifierRef_return IdentifierRefIdentifierRefParserRuleCall_1_4_2_0 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0 = null;




        try {
            {
            {
            pushFollow(FOLLOW_106);
            PropertyAssignmentAnnotationListParserRuleCall_0=rulePropertyAssignmentAnnotationList();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((PropertyAssignmentAnnotationListParserRuleCall_0!=null?((Token)PropertyAssignmentAnnotationListParserRuleCall_0.start):null), (PropertyAssignmentAnnotationListParserRuleCall_0!=null?((Token)PropertyAssignmentAnnotationListParserRuleCall_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertyAssignmentAnnotationListParserRuleCall_0()); 
            }
            int alt274=5;
            alt274 = dfa274.predict(input);
            switch (alt274) {
                case 1 :
                    {
                    {
                    {
                    {
                    int alt266=2;
                    alt266 = dfa266.predict(input);
                    switch (alt266) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_107);
                            DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0=ruleTypeRefWithModifiers();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              								announce((DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0!=null?((Token)DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0.start):null), (DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0!=null?((Token)DeclaredTypeRefTypeRefWithModifiersParserRuleCall_1_0_0_0_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_0_0_0_1());
                              							
                            }

                            }


                            }
                            break;

                    }
                    {
                    {
                    pushFollow(FOLLOW_94);
                    DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0=norm1_LiteralOrComputedPropertyName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      								announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_0_0_0_2_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_0_0_0_2());
                      							
                    }

                    }


                    }

                    ColonKeyword_1_0_0_0_3=(Token)match(input,Colon,FOLLOW_70); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(ColonKeyword_1_0_0_0_3, grammarAccess.getAnnotatedPropertyAssignmentAccess().getColonKeyword_1_0_0_0_3());
                      					
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_1_0_1_0=norm3_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((ExpressionAssignmentExpressionParserRuleCall_1_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_0_1());
                      					
                    }

                    }


                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_13);
                    GetterHeaderParserRuleCall_1_1_0_0_1=norm1_GetterHeader();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((GetterHeaderParserRuleCall_1_1_0_0_1!=null?((Token)GetterHeaderParserRuleCall_1_1_0_0_1.start):null), (GetterHeaderParserRuleCall_1_1_0_0_1!=null?((Token)GetterHeaderParserRuleCall_1_1_0_0_1.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getGetterHeaderParserRuleCall_1_1_0_0_1()); 
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BodyBlockParserRuleCall_1_1_1_0=ruleBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((BodyBlockParserRuleCall_1_1_1_0!=null?((Token)BodyBlockParserRuleCall_1_1_1_0.start):null), (BodyBlockParserRuleCall_1_1_1_0!=null?((Token)BodyBlockParserRuleCall_1_1_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_1_1());
                      					
                    }

                    }


                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    {
                    SetKeyword_1_2_0_0_1=(Token)match(input,Set,FOLLOW_107); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(SetKeyword_1_2_0_0_1, grammarAccess.getAnnotatedPropertyAssignmentAccess().getSetKeyword_1_2_0_0_1());
                      					
                    }
                    {
                    {
                    pushFollow(FOLLOW_108);
                    DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0=norm1_LiteralOrComputedPropertyName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      								announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_2_0_0_2_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_2_0_0_2());
                      							
                    }

                    }


                    }


                    }


                    }
                    int alt267=2;
                    int LA267_0 = input.LA(1);

                    if ( (LA267_0==QuestionMark) ) {
                        alt267=1;
                    }
                    switch (alt267) {
                        case 1 :
                            {
                            {
                            DeclaredOptionalQuestionMarkKeyword_1_2_1_0=(Token)match(input,QuestionMark,FOLLOW_42); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce(DeclaredOptionalQuestionMarkKeyword_1_2_1_0, grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredOptionalQuestionMarkKeyword_1_2_1_0());
                              					
                            }

                            }


                            }
                            break;

                    }

                    LeftParenthesisKeyword_1_2_2=(Token)match(input,LeftParenthesis,FOLLOW_55); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(LeftParenthesisKeyword_1_2_2, grammarAccess.getAnnotatedPropertyAssignmentAccess().getLeftParenthesisKeyword_1_2_2());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_72);
                    FparFormalParameterParserRuleCall_1_2_3_0=norm1_FormalParameter();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((FparFormalParameterParserRuleCall_1_2_3_0!=null?((Token)FparFormalParameterParserRuleCall_1_2_3_0.start):null), (FparFormalParameterParserRuleCall_1_2_3_0!=null?((Token)FparFormalParameterParserRuleCall_1_2_3_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getFparAssignment_1_2_3());
                      					
                    }

                    }


                    }

                    RightParenthesisKeyword_1_2_4=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(RightParenthesisKeyword_1_2_4, grammarAccess.getAnnotatedPropertyAssignmentAccess().getRightParenthesisKeyword_1_2_4());
                      			
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    BodyBlockParserRuleCall_1_2_5_0=ruleBlock();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((BodyBlockParserRuleCall_1_2_5_0!=null?((Token)BodyBlockParserRuleCall_1_2_5_0.start):null), (BodyBlockParserRuleCall_1_2_5_0!=null?((Token)BodyBlockParserRuleCall_1_2_5_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getBodyAssignment_1_2_5());
                      					
                    }

                    }


                    }


                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    {
                    {
                    int alt268=2;
                    int LA268_0 = input.LA(1);

                    if ( (LA268_0==LessThanSign) ) {
                        alt268=1;
                    }
                    switch (alt268) {
                        case 1 :
                            {
                            pushFollow(FOLLOW_109);
                            TypeVariablesParserRuleCall_1_3_0_0_1=ruleTypeVariables();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((TypeVariablesParserRuleCall_1_3_0_0_1!=null?((Token)TypeVariablesParserRuleCall_1_3_0_0_1.start):null), (TypeVariablesParserRuleCall_1_3_0_0_1!=null?((Token)TypeVariablesParserRuleCall_1_3_0_0_1.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getTypeVariablesParserRuleCall_1_3_0_0_1()); 
                            }

                            }
                            break;

                    }
                    int alt269=2;
                    alt269 = dfa269.predict(input);
                    switch (alt269) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_109);
                            ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0=ruleTypeRefWithModifiers();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              								announce((ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0!=null?((Token)ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0.start):null), (ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0!=null?((Token)ReturnTypeRefTypeRefWithModifiersParserRuleCall_1_3_0_0_2_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getReturnTypeRefAssignment_1_3_0_0_2());
                              							
                            }

                            }


                            }
                            break;

                    }
                    int alt270=2;
                    int LA270_0 = input.LA(1);

                    if ( (LA270_0==Asterisk) ) {
                        alt270=1;
                    }
                    else if ( ((LA270_0>=Intersection && LA270_0<=With)||(LA270_0>=For && LA270_0<=Var)||(LA270_0>=As && LA270_0<=Of)||LA270_0==LeftSquareBracket||LA270_0==RULE_DOUBLE||LA270_0==RULE_HEX_INT||LA270_0==RULE_OCTAL_INT||LA270_0==RULE_SCIENTIFIC_INT||LA270_0==RULE_IDENTIFIER||LA270_0==RULE_STRING||LA270_0==RULE_INT) ) {
                        alt270=2;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return retval;}
                        NoViableAltException nvae =
                            new NoViableAltException("", 270, 0, input);

                        throw nvae;
                    }
                    switch (alt270) {
                        case 1 :
                            {
                            {
                            {
                            {
                            GeneratorAsteriskKeyword_1_3_0_0_3_0_0_0=(Token)match(input,Asterisk,FOLLOW_107); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              										announce(GeneratorAsteriskKeyword_1_3_0_0_3_0_0_0, grammarAccess.getAnnotatedPropertyAssignmentAccess().getGeneratorAsteriskKeyword_1_3_0_0_3_0_0_0());
                              									
                            }

                            }


                            }
                            {
                            {
                            pushFollow(FOLLOW_39);
                            DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0=norm1_LiteralOrComputedPropertyName();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              										announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_0_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_0_1());
                              									
                            }

                            }


                            }
                            {
                            pushFollow(FOLLOW_110);
                            MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2=norm1_MethodParamsAndBody();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2!=null?((Token)MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2.start):null), (MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2!=null?((Token)MethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_0_2()); 
                            }

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            {
                            {
                            pushFollow(FOLLOW_42);
                            DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0=norm1_LiteralOrComputedPropertyName();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              										announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_1_3_0_0_3_1_0_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredNameAssignment_1_3_0_0_3_1_0());
                              									
                            }

                            }


                            }
                            {
                            pushFollow(FOLLOW_110);
                            MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1=ruleMethodParamsAndBody();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {
                               announce((MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1!=null?((Token)MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1.start):null), (MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1!=null?((Token)MethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getMethodParamsAndBodyParserRuleCall_1_3_0_0_3_1_1()); 
                            }

                            }


                            }


                            }
                            break;

                    }


                    }


                    }
                    int alt271=2;
                    int LA271_0 = input.LA(1);

                    if ( (LA271_0==Semicolon) ) {
                        alt271=1;
                    }
                    switch (alt271) {
                        case 1 :
                            {
                            SemicolonKeyword_1_3_1=(Token)match(input,Semicolon,FOLLOW_2); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              					announce(SemicolonKeyword_1_3_1, grammarAccess.getAnnotatedPropertyAssignmentAccess().getSemicolonKeyword_1_3_1());
                              				
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    int alt272=2;
                    alt272 = dfa272.predict(input);
                    switch (alt272) {
                        case 1 :
                            {
                            {
                            pushFollow(FOLLOW_8);
                            DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0=ruleTypeRef();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              						announce((DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0!=null?((Token)DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0.start):null), (DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0!=null?((Token)DeclaredTypeRefTypeRefParserRuleCall_1_4_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getDeclaredTypeRefAssignment_1_4_1());
                              					
                            }

                            }


                            }
                            break;

                    }
                    {
                    {
                    pushFollow(FOLLOW_63);
                    IdentifierRefIdentifierRefParserRuleCall_1_4_2_0=norm1_IdentifierRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((IdentifierRefIdentifierRefParserRuleCall_1_4_2_0!=null?((Token)IdentifierRefIdentifierRefParserRuleCall_1_4_2_0.start):null), (IdentifierRefIdentifierRefParserRuleCall_1_4_2_0!=null?((Token)IdentifierRefIdentifierRefParserRuleCall_1_4_2_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getIdentifierRefAssignment_1_4_2());
                      					
                    }

                    }


                    }
                    int alt273=2;
                    int LA273_0 = input.LA(1);

                    if ( (LA273_0==EqualsSign) ) {
                        alt273=1;
                    }
                    switch (alt273) {
                        case 1 :
                            {
                            EqualsSignKeyword_1_4_3_0=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              					announce(EqualsSignKeyword_1_4_3_0, grammarAccess.getAnnotatedPropertyAssignmentAccess().getEqualsSignKeyword_1_4_3_0());
                              				
                            }
                            {
                            {
                            pushFollow(FOLLOW_2);
                            ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0=norm3_AssignmentExpression();

                            state._fsp--;
                            if (state.failed) return retval;
                            if ( state.backtracking==0 ) {

                              							announce((ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_4_3_1_0.stop):null), grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignment_1_4_3_1());
                              						
                            }

                            }


                            }


                            }
                            break;

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRulePropertyMethodDeclaration() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            rulePropertyMethodDeclaration();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class rulePropertyMethodDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.rulePropertyMethodDeclaration_return rulePropertyMethodDeclaration() throws RecognitionException {
        InternalN4JSParser.rulePropertyMethodDeclaration_return retval = new InternalN4JSParser.rulePropertyMethodDeclaration_return();
        retval.start = input.LT(1);

        Token GeneratorAsteriskKeyword_0_0_3_0_0_0=null;
        Token SemicolonKeyword_1=null;
        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_0_0_1 = null;

        InternalN4JSParser.ruleTypeRefWithModifiers_return ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0 = null;

        InternalN4JSParser.ruleLiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0 = null;

        InternalN4JSParser.norm1_MethodParamsAndBody_return MethodParamsAndBodyParserRuleCall_0_0_3_0_2 = null;

        InternalN4JSParser.ruleLiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0 = null;

        InternalN4JSParser.ruleMethodParamsAndBody_return MethodParamsAndBodyParserRuleCall_0_0_3_1_1 = null;




        try {
            {
            {
            {
            {
            int alt275=2;
            int LA275_0 = input.LA(1);

            if ( (LA275_0==LessThanSign) ) {
                alt275=1;
            }
            switch (alt275) {
                case 1 :
                    {
                    pushFollow(FOLLOW_109);
                    TypeVariablesParserRuleCall_0_0_1=ruleTypeVariables();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((TypeVariablesParserRuleCall_0_0_1!=null?((Token)TypeVariablesParserRuleCall_0_0_1.start):null), (TypeVariablesParserRuleCall_0_0_1!=null?((Token)TypeVariablesParserRuleCall_0_0_1.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getTypeVariablesParserRuleCall_0_0_1()); 
                    }

                    }
                    break;

            }
            int alt276=2;
            alt276 = dfa276.predict(input);
            switch (alt276) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_109);
                    ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0=ruleTypeRefWithModifiers();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0!=null?((Token)ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0.start):null), (ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0!=null?((Token)ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getReturnTypeRefAssignment_0_0_2());
                      					
                    }

                    }


                    }
                    break;

            }
            int alt277=2;
            int LA277_0 = input.LA(1);

            if ( (LA277_0==Asterisk) ) {
                alt277=1;
            }
            else if ( ((LA277_0>=Intersection && LA277_0<=With)||(LA277_0>=For && LA277_0<=Var)||(LA277_0>=As && LA277_0<=Of)||LA277_0==LeftSquareBracket||LA277_0==RULE_DOUBLE||LA277_0==RULE_HEX_INT||LA277_0==RULE_OCTAL_INT||LA277_0==RULE_SCIENTIFIC_INT||LA277_0==RULE_IDENTIFIER||LA277_0==RULE_STRING||LA277_0==RULE_INT) ) {
                alt277=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 277, 0, input);

                throw nvae;
            }
            switch (alt277) {
                case 1 :
                    {
                    {
                    {
                    {
                    GeneratorAsteriskKeyword_0_0_3_0_0_0=(Token)match(input,Asterisk,FOLLOW_107); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      								announce(GeneratorAsteriskKeyword_0_0_3_0_0_0, grammarAccess.getPropertyMethodDeclarationAccess().getGeneratorAsteriskKeyword_0_0_3_0_0_0());
                      							
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_39);
                    DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0=ruleLiteralOrComputedPropertyName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      								announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_0_1());
                      							
                    }

                    }


                    }
                    {
                    pushFollow(FOLLOW_110);
                    MethodParamsAndBodyParserRuleCall_0_0_3_0_2=norm1_MethodParamsAndBody();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((MethodParamsAndBodyParserRuleCall_0_0_3_0_2!=null?((Token)MethodParamsAndBodyParserRuleCall_0_0_3_0_2.start):null), (MethodParamsAndBodyParserRuleCall_0_0_3_0_2!=null?((Token)MethodParamsAndBodyParserRuleCall_0_0_3_0_2.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_0_2()); 
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_42);
                    DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0=ruleLiteralOrComputedPropertyName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      								announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_1_0());
                      							
                    }

                    }


                    }
                    {
                    pushFollow(FOLLOW_110);
                    MethodParamsAndBodyParserRuleCall_0_0_3_1_1=ruleMethodParamsAndBody();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((MethodParamsAndBodyParserRuleCall_0_0_3_1_1!=null?((Token)MethodParamsAndBodyParserRuleCall_0_0_3_1_1.start):null), (MethodParamsAndBodyParserRuleCall_0_0_3_1_1!=null?((Token)MethodParamsAndBodyParserRuleCall_0_0_3_1_1.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_1_1()); 
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }
            int alt278=2;
            int LA278_0 = input.LA(1);

            if ( (LA278_0==Semicolon) ) {
                alt278=1;
            }
            switch (alt278) {
                case 1 :
                    {
                    SemicolonKeyword_1=(Token)match(input,Semicolon,FOLLOW_2); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce(SemicolonKeyword_1, grammarAccess.getPropertyMethodDeclarationAccess().getSemicolonKeyword_1());
                      		
                    }

                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_PropertyMethodDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_PropertyMethodDeclaration_return norm1_PropertyMethodDeclaration() throws RecognitionException {
        InternalN4JSParser.norm1_PropertyMethodDeclaration_return retval = new InternalN4JSParser.norm1_PropertyMethodDeclaration_return();
        retval.start = input.LT(1);

        Token GeneratorAsteriskKeyword_0_0_3_0_0_0=null;
        Token SemicolonKeyword_1=null;
        InternalN4JSParser.ruleTypeVariables_return TypeVariablesParserRuleCall_0_0_1 = null;

        InternalN4JSParser.ruleTypeRefWithModifiers_return ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0 = null;

        InternalN4JSParser.norm1_LiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0 = null;

        InternalN4JSParser.norm1_MethodParamsAndBody_return MethodParamsAndBodyParserRuleCall_0_0_3_0_2 = null;

        InternalN4JSParser.norm1_LiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0 = null;

        InternalN4JSParser.ruleMethodParamsAndBody_return MethodParamsAndBodyParserRuleCall_0_0_3_1_1 = null;




        try {
            {
            {
            {
            {
            int alt279=2;
            int LA279_0 = input.LA(1);

            if ( (LA279_0==LessThanSign) ) {
                alt279=1;
            }
            switch (alt279) {
                case 1 :
                    {
                    pushFollow(FOLLOW_109);
                    TypeVariablesParserRuleCall_0_0_1=ruleTypeVariables();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((TypeVariablesParserRuleCall_0_0_1!=null?((Token)TypeVariablesParserRuleCall_0_0_1.start):null), (TypeVariablesParserRuleCall_0_0_1!=null?((Token)TypeVariablesParserRuleCall_0_0_1.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getTypeVariablesParserRuleCall_0_0_1()); 
                    }

                    }
                    break;

            }
            int alt280=2;
            alt280 = dfa280.predict(input);
            switch (alt280) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_109);
                    ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0=ruleTypeRefWithModifiers();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0!=null?((Token)ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0.start):null), (ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0!=null?((Token)ReturnTypeRefTypeRefWithModifiersParserRuleCall_0_0_2_0.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getReturnTypeRefAssignment_0_0_2());
                      					
                    }

                    }


                    }
                    break;

            }
            int alt281=2;
            int LA281_0 = input.LA(1);

            if ( (LA281_0==Asterisk) ) {
                alt281=1;
            }
            else if ( ((LA281_0>=Intersection && LA281_0<=With)||(LA281_0>=For && LA281_0<=Var)||(LA281_0>=As && LA281_0<=Of)||LA281_0==LeftSquareBracket||LA281_0==RULE_DOUBLE||LA281_0==RULE_HEX_INT||LA281_0==RULE_OCTAL_INT||LA281_0==RULE_SCIENTIFIC_INT||LA281_0==RULE_IDENTIFIER||LA281_0==RULE_STRING||LA281_0==RULE_INT) ) {
                alt281=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return retval;}
                NoViableAltException nvae =
                    new NoViableAltException("", 281, 0, input);

                throw nvae;
            }
            switch (alt281) {
                case 1 :
                    {
                    {
                    {
                    {
                    GeneratorAsteriskKeyword_0_0_3_0_0_0=(Token)match(input,Asterisk,FOLLOW_107); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      								announce(GeneratorAsteriskKeyword_0_0_3_0_0_0, grammarAccess.getPropertyMethodDeclarationAccess().getGeneratorAsteriskKeyword_0_0_3_0_0_0());
                      							
                    }

                    }


                    }
                    {
                    {
                    pushFollow(FOLLOW_39);
                    DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0=norm1_LiteralOrComputedPropertyName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      								announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_0_1_0.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_0_1());
                      							
                    }

                    }


                    }
                    {
                    pushFollow(FOLLOW_110);
                    MethodParamsAndBodyParserRuleCall_0_0_3_0_2=norm1_MethodParamsAndBody();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((MethodParamsAndBodyParserRuleCall_0_0_3_0_2!=null?((Token)MethodParamsAndBodyParserRuleCall_0_0_3_0_2.start):null), (MethodParamsAndBodyParserRuleCall_0_0_3_0_2!=null?((Token)MethodParamsAndBodyParserRuleCall_0_0_3_0_2.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_0_2()); 
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    pushFollow(FOLLOW_42);
                    DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0=norm1_LiteralOrComputedPropertyName();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      								announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_3_1_0_0.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getDeclaredNameAssignment_0_0_3_1_0());
                      							
                    }

                    }


                    }
                    {
                    pushFollow(FOLLOW_110);
                    MethodParamsAndBodyParserRuleCall_0_0_3_1_1=ruleMethodParamsAndBody();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((MethodParamsAndBodyParserRuleCall_0_0_3_1_1!=null?((Token)MethodParamsAndBodyParserRuleCall_0_0_3_1_1.start):null), (MethodParamsAndBodyParserRuleCall_0_0_3_1_1!=null?((Token)MethodParamsAndBodyParserRuleCall_0_0_3_1_1.stop):null), grammarAccess.getPropertyMethodDeclarationAccess().getMethodParamsAndBodyParserRuleCall_0_0_3_1_1()); 
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }
            int alt282=2;
            int LA282_0 = input.LA(1);

            if ( (LA282_0==Semicolon) ) {
                alt282=1;
            }
            switch (alt282) {
                case 1 :
                    {
                    SemicolonKeyword_1=(Token)match(input,Semicolon,FOLLOW_2); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce(SemicolonKeyword_1, grammarAccess.getPropertyMethodDeclarationAccess().getSemicolonKeyword_1());
                      		
                    }

                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRulePropertyNameValuePair() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            rulePropertyNameValuePair();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class rulePropertyNameValuePair_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.rulePropertyNameValuePair_return rulePropertyNameValuePair() throws RecognitionException {
        InternalN4JSParser.rulePropertyNameValuePair_return retval = new InternalN4JSParser.rulePropertyNameValuePair_return();
        retval.start = input.LT(1);

        Token DeclaredOptionalQuestionMarkKeyword_0_0_3_0=null;
        Token ColonKeyword_0_0_4=null;
        InternalN4JSParser.ruleTypeRefWithModifiers_return DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0 = null;

        InternalN4JSParser.ruleLiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0 = null;




        try {
            {
            {
            {
            {
            int alt283=2;
            alt283 = dfa283.predict(input);
            switch (alt283) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_107);
                    DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0=ruleTypeRefWithModifiers();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0!=null?((Token)DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0.start):null), (DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0!=null?((Token)DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0.stop):null), grammarAccess.getPropertyNameValuePairAccess().getDeclaredTypeRefAssignment_0_0_1());
                      					
                    }

                    }


                    }
                    break;

            }
            {
            {
            pushFollow(FOLLOW_111);
            DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0=ruleLiteralOrComputedPropertyName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              						announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0.stop):null), grammarAccess.getPropertyNameValuePairAccess().getDeclaredNameAssignment_0_0_2());
              					
            }

            }


            }
            int alt284=2;
            int LA284_0 = input.LA(1);

            if ( (LA284_0==QuestionMark) ) {
                alt284=1;
            }
            switch (alt284) {
                case 1 :
                    {
                    {
                    DeclaredOptionalQuestionMarkKeyword_0_0_3_0=(Token)match(input,QuestionMark,FOLLOW_94); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(DeclaredOptionalQuestionMarkKeyword_0_0_3_0, grammarAccess.getPropertyNameValuePairAccess().getDeclaredOptionalQuestionMarkKeyword_0_0_3_0());
                      					
                    }

                    }


                    }
                    break;

            }

            ColonKeyword_0_0_4=(Token)match(input,Colon,FOLLOW_49); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(ColonKeyword_0_0_4, grammarAccess.getPropertyNameValuePairAccess().getColonKeyword_0_0_4());
              			
            }

            }


            }
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_1_0=norm1_AssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionAssignmentExpressionParserRuleCall_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0.stop):null), grammarAccess.getPropertyNameValuePairAccess().getExpressionAssignment_1());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_PropertyNameValuePair_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_PropertyNameValuePair_return norm1_PropertyNameValuePair() throws RecognitionException {
        InternalN4JSParser.norm1_PropertyNameValuePair_return retval = new InternalN4JSParser.norm1_PropertyNameValuePair_return();
        retval.start = input.LT(1);

        Token DeclaredOptionalQuestionMarkKeyword_0_0_3_0=null;
        Token ColonKeyword_0_0_4=null;
        InternalN4JSParser.ruleTypeRefWithModifiers_return DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0 = null;

        InternalN4JSParser.norm1_LiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_1_0 = null;




        try {
            {
            {
            {
            {
            int alt285=2;
            alt285 = dfa285.predict(input);
            switch (alt285) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_107);
                    DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0=ruleTypeRefWithModifiers();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce((DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0!=null?((Token)DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0.start):null), (DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0!=null?((Token)DeclaredTypeRefTypeRefWithModifiersParserRuleCall_0_0_1_0.stop):null), grammarAccess.getPropertyNameValuePairAccess().getDeclaredTypeRefAssignment_0_0_1());
                      					
                    }

                    }


                    }
                    break;

            }
            {
            {
            pushFollow(FOLLOW_111);
            DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0=norm1_LiteralOrComputedPropertyName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              						announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0.stop):null), grammarAccess.getPropertyNameValuePairAccess().getDeclaredNameAssignment_0_0_2());
              					
            }

            }


            }
            int alt286=2;
            int LA286_0 = input.LA(1);

            if ( (LA286_0==QuestionMark) ) {
                alt286=1;
            }
            switch (alt286) {
                case 1 :
                    {
                    {
                    DeclaredOptionalQuestionMarkKeyword_0_0_3_0=(Token)match(input,QuestionMark,FOLLOW_94); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      						announce(DeclaredOptionalQuestionMarkKeyword_0_0_3_0, grammarAccess.getPropertyNameValuePairAccess().getDeclaredOptionalQuestionMarkKeyword_0_0_3_0());
                      					
                    }

                    }


                    }
                    break;

            }

            ColonKeyword_0_0_4=(Token)match(input,Colon,FOLLOW_70); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(ColonKeyword_0_0_4, grammarAccess.getPropertyNameValuePairAccess().getColonKeyword_0_0_4());
              			
            }

            }


            }
            {
            {
            pushFollow(FOLLOW_2);
            ExpressionAssignmentExpressionParserRuleCall_1_0=norm3_AssignmentExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((ExpressionAssignmentExpressionParserRuleCall_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_1_0.stop):null), grammarAccess.getPropertyNameValuePairAccess().getExpressionAssignment_1());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRulePropertyNameValuePairSingleName() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            rulePropertyNameValuePairSingleName();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class rulePropertyNameValuePairSingleName_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.rulePropertyNameValuePairSingleName_return rulePropertyNameValuePairSingleName() throws RecognitionException {
        InternalN4JSParser.rulePropertyNameValuePairSingleName_return retval = new InternalN4JSParser.rulePropertyNameValuePairSingleName_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_2_0=null;
        InternalN4JSParser.ruleTypeRef_return DeclaredTypeRefTypeRefParserRuleCall_0_0 = null;

        InternalN4JSParser.ruleIdentifierRef_return IdentifierRefIdentifierRefParserRuleCall_1_0 = null;

        InternalN4JSParser.norm1_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_2_1_0 = null;




        try {
            {
            {
            int alt287=2;
            alt287 = dfa287.predict(input);
            switch (alt287) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_8);
                    DeclaredTypeRefTypeRefParserRuleCall_0_0=ruleTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((DeclaredTypeRefTypeRefParserRuleCall_0_0!=null?((Token)DeclaredTypeRefTypeRefParserRuleCall_0_0.start):null), (DeclaredTypeRefTypeRefParserRuleCall_0_0!=null?((Token)DeclaredTypeRefTypeRefParserRuleCall_0_0.stop):null), grammarAccess.getPropertyNameValuePairSingleNameAccess().getDeclaredTypeRefAssignment_0());
                      			
                    }

                    }


                    }
                    break;

            }
            {
            {
            pushFollow(FOLLOW_63);
            IdentifierRefIdentifierRefParserRuleCall_1_0=ruleIdentifierRef();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((IdentifierRefIdentifierRefParserRuleCall_1_0!=null?((Token)IdentifierRefIdentifierRefParserRuleCall_1_0.start):null), (IdentifierRefIdentifierRefParserRuleCall_1_0!=null?((Token)IdentifierRefIdentifierRefParserRuleCall_1_0.stop):null), grammarAccess.getPropertyNameValuePairSingleNameAccess().getIdentifierRefAssignment_1());
              			
            }

            }


            }
            int alt288=2;
            int LA288_0 = input.LA(1);

            if ( (LA288_0==EqualsSign) ) {
                alt288=1;
            }
            switch (alt288) {
                case 1 :
                    {
                    EqualsSignKeyword_2_0=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce(EqualsSignKeyword_2_0, grammarAccess.getPropertyNameValuePairSingleNameAccess().getEqualsSignKeyword_2_0());
                      		
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_2_1_0=norm1_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((ExpressionAssignmentExpressionParserRuleCall_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_1_0.stop):null), grammarAccess.getPropertyNameValuePairSingleNameAccess().getExpressionAssignment_2_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_PropertyNameValuePairSingleName_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_PropertyNameValuePairSingleName_return norm1_PropertyNameValuePairSingleName() throws RecognitionException {
        InternalN4JSParser.norm1_PropertyNameValuePairSingleName_return retval = new InternalN4JSParser.norm1_PropertyNameValuePairSingleName_return();
        retval.start = input.LT(1);

        Token EqualsSignKeyword_2_0=null;
        InternalN4JSParser.ruleTypeRef_return DeclaredTypeRefTypeRefParserRuleCall_0_0 = null;

        InternalN4JSParser.norm1_IdentifierRef_return IdentifierRefIdentifierRefParserRuleCall_1_0 = null;

        InternalN4JSParser.norm3_AssignmentExpression_return ExpressionAssignmentExpressionParserRuleCall_2_1_0 = null;




        try {
            {
            {
            int alt289=2;
            alt289 = dfa289.predict(input);
            switch (alt289) {
                case 1 :
                    {
                    {
                    pushFollow(FOLLOW_8);
                    DeclaredTypeRefTypeRefParserRuleCall_0_0=ruleTypeRef();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce((DeclaredTypeRefTypeRefParserRuleCall_0_0!=null?((Token)DeclaredTypeRefTypeRefParserRuleCall_0_0.start):null), (DeclaredTypeRefTypeRefParserRuleCall_0_0!=null?((Token)DeclaredTypeRefTypeRefParserRuleCall_0_0.stop):null), grammarAccess.getPropertyNameValuePairSingleNameAccess().getDeclaredTypeRefAssignment_0());
                      			
                    }

                    }


                    }
                    break;

            }
            {
            {
            pushFollow(FOLLOW_63);
            IdentifierRefIdentifierRefParserRuleCall_1_0=norm1_IdentifierRef();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((IdentifierRefIdentifierRefParserRuleCall_1_0!=null?((Token)IdentifierRefIdentifierRefParserRuleCall_1_0.start):null), (IdentifierRefIdentifierRefParserRuleCall_1_0!=null?((Token)IdentifierRefIdentifierRefParserRuleCall_1_0.stop):null), grammarAccess.getPropertyNameValuePairSingleNameAccess().getIdentifierRefAssignment_1());
              			
            }

            }


            }
            int alt290=2;
            int LA290_0 = input.LA(1);

            if ( (LA290_0==EqualsSign) ) {
                alt290=1;
            }
            switch (alt290) {
                case 1 :
                    {
                    EqualsSignKeyword_2_0=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      			announce(EqualsSignKeyword_2_0, grammarAccess.getPropertyNameValuePairSingleNameAccess().getEqualsSignKeyword_2_0());
                      		
                    }
                    {
                    {
                    pushFollow(FOLLOW_2);
                    ExpressionAssignmentExpressionParserRuleCall_2_1_0=norm3_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      					announce((ExpressionAssignmentExpressionParserRuleCall_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_1_0.start):null), (ExpressionAssignmentExpressionParserRuleCall_2_1_0!=null?((Token)ExpressionAssignmentExpressionParserRuleCall_2_1_0.stop):null), grammarAccess.getPropertyNameValuePairSingleNameAccess().getExpressionAssignment_2_1());
                      				
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRulePropertyGetterDeclaration() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            rulePropertyGetterDeclaration();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class rulePropertyGetterDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.rulePropertyGetterDeclaration_return rulePropertyGetterDeclaration() throws RecognitionException {
        InternalN4JSParser.rulePropertyGetterDeclaration_return retval = new InternalN4JSParser.rulePropertyGetterDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleGetterHeader_return GetterHeaderParserRuleCall_0_0_1 = null;

        InternalN4JSParser.ruleBlock_return BodyBlockParserRuleCall_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_13);
            GetterHeaderParserRuleCall_0_0_1=ruleGetterHeader();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((GetterHeaderParserRuleCall_0_0_1!=null?((Token)GetterHeaderParserRuleCall_0_0_1.start):null), (GetterHeaderParserRuleCall_0_0_1!=null?((Token)GetterHeaderParserRuleCall_0_0_1.stop):null), grammarAccess.getPropertyGetterDeclarationAccess().getGetterHeaderParserRuleCall_0_0_1()); 
            }

            }


            }
            {
            {
            pushFollow(FOLLOW_2);
            BodyBlockParserRuleCall_1_0=ruleBlock();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((BodyBlockParserRuleCall_1_0!=null?((Token)BodyBlockParserRuleCall_1_0.start):null), (BodyBlockParserRuleCall_1_0!=null?((Token)BodyBlockParserRuleCall_1_0.stop):null), grammarAccess.getPropertyGetterDeclarationAccess().getBodyAssignment_1());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_PropertyGetterDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_PropertyGetterDeclaration_return norm1_PropertyGetterDeclaration() throws RecognitionException {
        InternalN4JSParser.norm1_PropertyGetterDeclaration_return retval = new InternalN4JSParser.norm1_PropertyGetterDeclaration_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_GetterHeader_return GetterHeaderParserRuleCall_0_0_1 = null;

        InternalN4JSParser.ruleBlock_return BodyBlockParserRuleCall_1_0 = null;




        try {
            {
            {
            {
            {
            pushFollow(FOLLOW_13);
            GetterHeaderParserRuleCall_0_0_1=norm1_GetterHeader();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((GetterHeaderParserRuleCall_0_0_1!=null?((Token)GetterHeaderParserRuleCall_0_0_1.start):null), (GetterHeaderParserRuleCall_0_0_1!=null?((Token)GetterHeaderParserRuleCall_0_0_1.stop):null), grammarAccess.getPropertyGetterDeclarationAccess().getGetterHeaderParserRuleCall_0_0_1()); 
            }

            }


            }
            {
            {
            pushFollow(FOLLOW_2);
            BodyBlockParserRuleCall_1_0=ruleBlock();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((BodyBlockParserRuleCall_1_0!=null?((Token)BodyBlockParserRuleCall_1_0.start):null), (BodyBlockParserRuleCall_1_0!=null?((Token)BodyBlockParserRuleCall_1_0.stop):null), grammarAccess.getPropertyGetterDeclarationAccess().getBodyAssignment_1());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRulePropertySetterDeclaration() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            rulePropertySetterDeclaration();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class rulePropertySetterDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.rulePropertySetterDeclaration_return rulePropertySetterDeclaration() throws RecognitionException {
        InternalN4JSParser.rulePropertySetterDeclaration_return retval = new InternalN4JSParser.rulePropertySetterDeclaration_return();
        retval.start = input.LT(1);

        Token SetKeyword_0_0_1=null;
        Token DeclaredOptionalQuestionMarkKeyword_1_0=null;
        Token LeftParenthesisKeyword_2=null;
        Token RightParenthesisKeyword_4=null;
        InternalN4JSParser.ruleLiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0 = null;

        InternalN4JSParser.ruleFormalParameter_return FparFormalParameterParserRuleCall_3_0 = null;

        InternalN4JSParser.ruleBlock_return BodyBlockParserRuleCall_5_0 = null;




        try {
            {
            {
            {
            {
            SetKeyword_0_0_1=(Token)match(input,Set,FOLLOW_107); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(SetKeyword_0_0_1, grammarAccess.getPropertySetterDeclarationAccess().getSetKeyword_0_0_1());
              			
            }
            {
            {
            pushFollow(FOLLOW_108);
            DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0=ruleLiteralOrComputedPropertyName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              						announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0.stop):null), grammarAccess.getPropertySetterDeclarationAccess().getDeclaredNameAssignment_0_0_2());
              					
            }

            }


            }


            }


            }
            int alt291=2;
            int LA291_0 = input.LA(1);

            if ( (LA291_0==QuestionMark) ) {
                alt291=1;
            }
            switch (alt291) {
                case 1 :
                    {
                    {
                    DeclaredOptionalQuestionMarkKeyword_1_0=(Token)match(input,QuestionMark,FOLLOW_42); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(DeclaredOptionalQuestionMarkKeyword_1_0, grammarAccess.getPropertySetterDeclarationAccess().getDeclaredOptionalQuestionMarkKeyword_1_0());
                      			
                    }

                    }


                    }
                    break;

            }

            LeftParenthesisKeyword_2=(Token)match(input,LeftParenthesis,FOLLOW_55); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_2, grammarAccess.getPropertySetterDeclarationAccess().getLeftParenthesisKeyword_2());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            FparFormalParameterParserRuleCall_3_0=ruleFormalParameter();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((FparFormalParameterParserRuleCall_3_0!=null?((Token)FparFormalParameterParserRuleCall_3_0.start):null), (FparFormalParameterParserRuleCall_3_0!=null?((Token)FparFormalParameterParserRuleCall_3_0.stop):null), grammarAccess.getPropertySetterDeclarationAccess().getFparAssignment_3());
              			
            }

            }


            }

            RightParenthesisKeyword_4=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_4, grammarAccess.getPropertySetterDeclarationAccess().getRightParenthesisKeyword_4());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            BodyBlockParserRuleCall_5_0=ruleBlock();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((BodyBlockParserRuleCall_5_0!=null?((Token)BodyBlockParserRuleCall_5_0.start):null), (BodyBlockParserRuleCall_5_0!=null?((Token)BodyBlockParserRuleCall_5_0.stop):null), grammarAccess.getPropertySetterDeclarationAccess().getBodyAssignment_5());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_PropertySetterDeclaration_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_PropertySetterDeclaration_return norm1_PropertySetterDeclaration() throws RecognitionException {
        InternalN4JSParser.norm1_PropertySetterDeclaration_return retval = new InternalN4JSParser.norm1_PropertySetterDeclaration_return();
        retval.start = input.LT(1);

        Token SetKeyword_0_0_1=null;
        Token DeclaredOptionalQuestionMarkKeyword_1_0=null;
        Token LeftParenthesisKeyword_2=null;
        Token RightParenthesisKeyword_4=null;
        InternalN4JSParser.norm1_LiteralOrComputedPropertyName_return DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0 = null;

        InternalN4JSParser.norm1_FormalParameter_return FparFormalParameterParserRuleCall_3_0 = null;

        InternalN4JSParser.ruleBlock_return BodyBlockParserRuleCall_5_0 = null;




        try {
            {
            {
            {
            {
            SetKeyword_0_0_1=(Token)match(input,Set,FOLLOW_107); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce(SetKeyword_0_0_1, grammarAccess.getPropertySetterDeclarationAccess().getSetKeyword_0_0_1());
              			
            }
            {
            {
            pushFollow(FOLLOW_108);
            DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0=norm1_LiteralOrComputedPropertyName();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              						announce((DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0.start):null), (DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0!=null?((Token)DeclaredNameLiteralOrComputedPropertyNameParserRuleCall_0_0_2_0.stop):null), grammarAccess.getPropertySetterDeclarationAccess().getDeclaredNameAssignment_0_0_2());
              					
            }

            }


            }


            }


            }
            int alt292=2;
            int LA292_0 = input.LA(1);

            if ( (LA292_0==QuestionMark) ) {
                alt292=1;
            }
            switch (alt292) {
                case 1 :
                    {
                    {
                    DeclaredOptionalQuestionMarkKeyword_1_0=(Token)match(input,QuestionMark,FOLLOW_42); if (state.failed) return retval;
                    if ( state.backtracking==0 ) {

                      				announce(DeclaredOptionalQuestionMarkKeyword_1_0, grammarAccess.getPropertySetterDeclarationAccess().getDeclaredOptionalQuestionMarkKeyword_1_0());
                      			
                    }

                    }


                    }
                    break;

            }

            LeftParenthesisKeyword_2=(Token)match(input,LeftParenthesis,FOLLOW_55); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_2, grammarAccess.getPropertySetterDeclarationAccess().getLeftParenthesisKeyword_2());
              	
            }
            {
            {
            pushFollow(FOLLOW_72);
            FparFormalParameterParserRuleCall_3_0=norm1_FormalParameter();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((FparFormalParameterParserRuleCall_3_0!=null?((Token)FparFormalParameterParserRuleCall_3_0.start):null), (FparFormalParameterParserRuleCall_3_0!=null?((Token)FparFormalParameterParserRuleCall_3_0.stop):null), grammarAccess.getPropertySetterDeclarationAccess().getFparAssignment_3());
              			
            }

            }


            }

            RightParenthesisKeyword_4=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_4, grammarAccess.getPropertySetterDeclarationAccess().getRightParenthesisKeyword_4());
              	
            }
            {
            {
            pushFollow(FOLLOW_2);
            BodyBlockParserRuleCall_5_0=ruleBlock();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((BodyBlockParserRuleCall_5_0!=null?((Token)BodyBlockParserRuleCall_5_0.start):null), (BodyBlockParserRuleCall_5_0!=null?((Token)BodyBlockParserRuleCall_5_0.stop):null), grammarAccess.getPropertySetterDeclarationAccess().getBodyAssignment_5());
              			
            }

            }


            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleParameterizedCallExpression() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleParameterizedCallExpression();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleParameterizedCallExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleParameterizedCallExpression_return ruleParameterizedCallExpression() throws RecognitionException {
        InternalN4JSParser.ruleParameterizedCallExpression_return retval = new InternalN4JSParser.ruleParameterizedCallExpression_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleConcreteTypeArguments_return ConcreteTypeArgumentsParserRuleCall_0 = null;

        InternalN4JSParser.ruleIdentifierRef_return TargetIdentifierRefParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleArgumentsWithParentheses_return ArgumentsWithParenthesesParserRuleCall_2 = null;




        try {
            {
            {
            pushFollow(FOLLOW_8);
            ConcreteTypeArgumentsParserRuleCall_0=ruleConcreteTypeArguments();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((ConcreteTypeArgumentsParserRuleCall_0!=null?((Token)ConcreteTypeArgumentsParserRuleCall_0.start):null), (ConcreteTypeArgumentsParserRuleCall_0!=null?((Token)ConcreteTypeArgumentsParserRuleCall_0.stop):null), grammarAccess.getParameterizedCallExpressionAccess().getConcreteTypeArgumentsParserRuleCall_0()); 
            }
            {
            {
            pushFollow(FOLLOW_42);
            TargetIdentifierRefParserRuleCall_1_0=ruleIdentifierRef();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((TargetIdentifierRefParserRuleCall_1_0!=null?((Token)TargetIdentifierRefParserRuleCall_1_0.start):null), (TargetIdentifierRefParserRuleCall_1_0!=null?((Token)TargetIdentifierRefParserRuleCall_1_0.stop):null), grammarAccess.getParameterizedCallExpressionAccess().getTargetAssignment_1());
              			
            }

            }


            }

            pushFollow(FOLLOW_2);
            ArgumentsWithParenthesesParserRuleCall_2=ruleArgumentsWithParentheses();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((ArgumentsWithParenthesesParserRuleCall_2!=null?((Token)ArgumentsWithParenthesesParserRuleCall_2.start):null), (ArgumentsWithParenthesesParserRuleCall_2!=null?((Token)ArgumentsWithParenthesesParserRuleCall_2.stop):null), grammarAccess.getParameterizedCallExpressionAccess().getArgumentsWithParenthesesParserRuleCall_2()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ParameterizedCallExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ParameterizedCallExpression_return norm1_ParameterizedCallExpression() throws RecognitionException {
        InternalN4JSParser.norm1_ParameterizedCallExpression_return retval = new InternalN4JSParser.norm1_ParameterizedCallExpression_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleConcreteTypeArguments_return ConcreteTypeArgumentsParserRuleCall_0 = null;

        InternalN4JSParser.norm1_IdentifierRef_return TargetIdentifierRefParserRuleCall_1_0 = null;

        InternalN4JSParser.norm1_ArgumentsWithParentheses_return ArgumentsWithParenthesesParserRuleCall_2 = null;




        try {
            {
            {
            pushFollow(FOLLOW_8);
            ConcreteTypeArgumentsParserRuleCall_0=ruleConcreteTypeArguments();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((ConcreteTypeArgumentsParserRuleCall_0!=null?((Token)ConcreteTypeArgumentsParserRuleCall_0.start):null), (ConcreteTypeArgumentsParserRuleCall_0!=null?((Token)ConcreteTypeArgumentsParserRuleCall_0.stop):null), grammarAccess.getParameterizedCallExpressionAccess().getConcreteTypeArgumentsParserRuleCall_0()); 
            }
            {
            {
            pushFollow(FOLLOW_42);
            TargetIdentifierRefParserRuleCall_1_0=norm1_IdentifierRef();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((TargetIdentifierRefParserRuleCall_1_0!=null?((Token)TargetIdentifierRefParserRuleCall_1_0.start):null), (TargetIdentifierRefParserRuleCall_1_0!=null?((Token)TargetIdentifierRefParserRuleCall_1_0.stop):null), grammarAccess.getParameterizedCallExpressionAccess().getTargetAssignment_1());
              			
            }

            }


            }

            pushFollow(FOLLOW_2);
            ArgumentsWithParenthesesParserRuleCall_2=norm1_ArgumentsWithParentheses();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((ArgumentsWithParenthesesParserRuleCall_2!=null?((Token)ArgumentsWithParenthesesParserRuleCall_2.start):null), (ArgumentsWithParenthesesParserRuleCall_2!=null?((Token)ArgumentsWithParenthesesParserRuleCall_2.stop):null), grammarAccess.getParameterizedCallExpressionAccess().getArgumentsWithParenthesesParserRuleCall_2()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleConcreteTypeArguments_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleConcreteTypeArguments_return ruleConcreteTypeArguments() throws RecognitionException {
        InternalN4JSParser.ruleConcreteTypeArguments_return retval = new InternalN4JSParser.ruleConcreteTypeArguments_return();
        retval.start = input.LT(1);

        Token LessThanSignKeyword_0=null;
        Token CommaKeyword_2_0=null;
        Token GreaterThanSignKeyword_3=null;
        InternalN4JSParser.ruleTypeRef_return TypeArgsTypeRefParserRuleCall_1_0 = null;

        InternalN4JSParser.ruleTypeRef_return TypeArgsTypeRefParserRuleCall_2_1_0 = null;




        try {
            {
            {
            LessThanSignKeyword_0=(Token)match(input,LessThanSign,FOLLOW_62); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LessThanSignKeyword_0, grammarAccess.getConcreteTypeArgumentsAccess().getLessThanSignKeyword_0());
              	
            }
            {
            {
            pushFollow(FOLLOW_112);
            TypeArgsTypeRefParserRuleCall_1_0=ruleTypeRef();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              				announce((TypeArgsTypeRefParserRuleCall_1_0!=null?((Token)TypeArgsTypeRefParserRuleCall_1_0.start):null), (TypeArgsTypeRefParserRuleCall_1_0!=null?((Token)TypeArgsTypeRefParserRuleCall_1_0.stop):null), grammarAccess.getConcreteTypeArgumentsAccess().getTypeArgsAssignment_1());
              			
            }

            }


            }
            loop293:
            do {
                int alt293=2;
                int LA293_0 = input.LA(1);

                if ( (LA293_0==Comma) ) {
                    alt293=1;
                }


                switch (alt293) {
            	case 1 :
            	    {
            	    CommaKeyword_2_0=(Token)match(input,Comma,FOLLOW_62); if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      			announce(CommaKeyword_2_0, grammarAccess.getConcreteTypeArgumentsAccess().getCommaKeyword_2_0());
            	      		
            	    }
            	    {
            	    {
            	    pushFollow(FOLLOW_112);
            	    TypeArgsTypeRefParserRuleCall_2_1_0=ruleTypeRef();

            	    state._fsp--;
            	    if (state.failed) return retval;
            	    if ( state.backtracking==0 ) {

            	      					announce((TypeArgsTypeRefParserRuleCall_2_1_0!=null?((Token)TypeArgsTypeRefParserRuleCall_2_1_0.start):null), (TypeArgsTypeRefParserRuleCall_2_1_0!=null?((Token)TypeArgsTypeRefParserRuleCall_2_1_0.stop):null), grammarAccess.getConcreteTypeArgumentsAccess().getTypeArgsAssignment_2_1());
            	      				
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop293;
                }
            } while (true);

            GreaterThanSignKeyword_3=(Token)match(input,GreaterThanSign,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(GreaterThanSignKeyword_3, grammarAccess.getConcreteTypeArgumentsAccess().getGreaterThanSignKeyword_3());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleImportCallExpression() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleImportCallExpression();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleImportCallExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleImportCallExpression_return ruleImportCallExpression() throws RecognitionException {
        InternalN4JSParser.ruleImportCallExpression_return retval = new InternalN4JSParser.ruleImportCallExpression_return();
        retval.start = input.LT(1);

        Token ImportKeyword_0=null;
        InternalN4JSParser.ruleArgumentsWithParentheses_return ArgumentsWithParenthesesParserRuleCall_1 = null;




        try {
            {
            {
            ImportKeyword_0=(Token)match(input,Import,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(ImportKeyword_0, grammarAccess.getImportCallExpressionAccess().getImportKeyword_0());
              	
            }
            pushFollow(FOLLOW_2);
            ArgumentsWithParenthesesParserRuleCall_1=ruleArgumentsWithParentheses();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((ArgumentsWithParenthesesParserRuleCall_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1.start):null), (ArgumentsWithParenthesesParserRuleCall_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1.stop):null), grammarAccess.getImportCallExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ImportCallExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ImportCallExpression_return norm1_ImportCallExpression() throws RecognitionException {
        InternalN4JSParser.norm1_ImportCallExpression_return retval = new InternalN4JSParser.norm1_ImportCallExpression_return();
        retval.start = input.LT(1);

        Token ImportKeyword_0=null;
        InternalN4JSParser.norm1_ArgumentsWithParentheses_return ArgumentsWithParenthesesParserRuleCall_1 = null;




        try {
            {
            {
            ImportKeyword_0=(Token)match(input,Import,FOLLOW_42); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(ImportKeyword_0, grammarAccess.getImportCallExpressionAccess().getImportKeyword_0());
              	
            }
            pushFollow(FOLLOW_2);
            ArgumentsWithParenthesesParserRuleCall_1=norm1_ArgumentsWithParentheses();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((ArgumentsWithParenthesesParserRuleCall_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1.start):null), (ArgumentsWithParenthesesParserRuleCall_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1.stop):null), grammarAccess.getImportCallExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1()); 
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }
    public final void entryRuleLeftHandSideExpression() throws RecognitionException {
        try {
            {
            pushFollow(FOLLOW_1);
            ruleLeftHandSideExpression();

            state._fsp--;
            if (state.failed) return ;
            match(input,EOF,FOLLOW_2); if (state.failed) return ;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return ;
    }

    public static class ruleLeftHandSideExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleLeftHandSideExpression_return ruleLeftHandSideExpression() throws RecognitionException {
        InternalN4JSParser.ruleLeftHandSideExpression_return retval = new InternalN4JSParser.ruleLeftHandSideExpression_return();
        retval.start = input.LT(1);

        InternalN4JSParser.ruleMemberExpression_return MemberExpressionParserRuleCall_0 = null;

        InternalN4JSParser.ruleArgumentsWithParentheses_return ArgumentsWithParenthesesParserRuleCall_1_1 = null;

        InternalN4JSParser.ruleArgumentsWithParentheses_return ArgumentsWithParenthesesParserRuleCall_1_2_0_1 = null;

        InternalN4JSParser.ruleIndexedAccessExpressionTail_return IndexedAccessExpressionTailParserRuleCall_1_2_1_1 = null;

        InternalN4JSParser.ruleParameterizedPropertyAccessExpressionTail_return ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1 = null;

        InternalN4JSParser.ruleTemplateLiteral_return TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0 = null;




        try {
            {
            {
            pushFollow(FOLLOW_113);
            MemberExpressionParserRuleCall_0=ruleMemberExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((MemberExpressionParserRuleCall_0!=null?((Token)MemberExpressionParserRuleCall_0.start):null), (MemberExpressionParserRuleCall_0!=null?((Token)MemberExpressionParserRuleCall_0.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getMemberExpressionParserRuleCall_0()); 
            }
            int alt295=2;
            int LA295_0 = input.LA(1);

            if ( (LA295_0==LeftParenthesis) ) {
                alt295=1;
            }
            switch (alt295) {
                case 1 :
                    {
                    pushFollow(FOLLOW_114);
                    ArgumentsWithParenthesesParserRuleCall_1_1=ruleArgumentsWithParentheses();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ArgumentsWithParenthesesParserRuleCall_1_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1_1.start):null), (ArgumentsWithParenthesesParserRuleCall_1_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1_1.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_1()); 
                    }
                    loop294:
                    do {
                        int alt294=5;
                        int LA294_0 = input.LA(1);

                        if ( (LA294_0==LeftParenthesis) ) {
                            alt294=1;
                        }
                        else if ( (LA294_0==LeftSquareBracket) ) {
                            alt294=2;
                        }
                        else if ( (LA294_0==FullStop) ) {
                            alt294=3;
                        }
                        else if ( (LA294_0==RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL) && (synpred172_InternalN4JSParser())) {
                            alt294=4;
                        }
                        else if ( (LA294_0==RULE_TEMPLATE_HEAD) && (synpred172_InternalN4JSParser())) {
                            alt294=4;
                        }


                        switch (alt294) {
                    	case 1 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_114);
                    	    ArgumentsWithParenthesesParserRuleCall_1_2_0_1=ruleArgumentsWithParentheses();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {
                    	       announce((ArgumentsWithParenthesesParserRuleCall_1_2_0_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1_2_0_1.start):null), (ArgumentsWithParenthesesParserRuleCall_1_2_0_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1_2_0_1.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_2_0_1()); 
                    	    }

                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_114);
                    	    IndexedAccessExpressionTailParserRuleCall_1_2_1_1=ruleIndexedAccessExpressionTail();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {
                    	       announce((IndexedAccessExpressionTailParserRuleCall_1_2_1_1!=null?((Token)IndexedAccessExpressionTailParserRuleCall_1_2_1_1.start):null), (IndexedAccessExpressionTailParserRuleCall_1_2_1_1!=null?((Token)IndexedAccessExpressionTailParserRuleCall_1_2_1_1.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_1_2_1_1()); 
                    	    }

                    	    }


                    	    }
                    	    break;
                    	case 3 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_114);
                    	    ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1=ruleParameterizedPropertyAccessExpressionTail();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {
                    	       announce((ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1!=null?((Token)ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1.start):null), (ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1!=null?((Token)ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1()); 
                    	    }

                    	    }


                    	    }
                    	    break;
                    	case 4 :
                    	    {
                    	    {
                    	    {
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_114);
                    	    TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0=ruleTemplateLiteral();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      								announce((TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0!=null?((Token)TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0.start):null), (TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0!=null?((Token)TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getTemplateAssignment_1_2_3_0_1());
                    	      							
                    	    }

                    	    }


                    	    }


                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop294;
                        }
                    } while (true);


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_LeftHandSideExpression_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_LeftHandSideExpression_return norm1_LeftHandSideExpression() throws RecognitionException {
        InternalN4JSParser.norm1_LeftHandSideExpression_return retval = new InternalN4JSParser.norm1_LeftHandSideExpression_return();
        retval.start = input.LT(1);

        InternalN4JSParser.norm1_MemberExpression_return MemberExpressionParserRuleCall_0 = null;

        InternalN4JSParser.norm1_ArgumentsWithParentheses_return ArgumentsWithParenthesesParserRuleCall_1_1 = null;

        InternalN4JSParser.norm1_ArgumentsWithParentheses_return ArgumentsWithParenthesesParserRuleCall_1_2_0_1 = null;

        InternalN4JSParser.norm1_IndexedAccessExpressionTail_return IndexedAccessExpressionTailParserRuleCall_1_2_1_1 = null;

        InternalN4JSParser.norm1_ParameterizedPropertyAccessExpressionTail_return ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1 = null;

        InternalN4JSParser.norm1_TemplateLiteral_return TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0 = null;




        try {
            {
            {
            pushFollow(FOLLOW_113);
            MemberExpressionParserRuleCall_0=norm1_MemberExpression();

            state._fsp--;
            if (state.failed) return retval;
            if ( state.backtracking==0 ) {
               announce((MemberExpressionParserRuleCall_0!=null?((Token)MemberExpressionParserRuleCall_0.start):null), (MemberExpressionParserRuleCall_0!=null?((Token)MemberExpressionParserRuleCall_0.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getMemberExpressionParserRuleCall_0()); 
            }
            int alt297=2;
            int LA297_0 = input.LA(1);

            if ( (LA297_0==LeftParenthesis) ) {
                alt297=1;
            }
            switch (alt297) {
                case 1 :
                    {
                    pushFollow(FOLLOW_114);
                    ArgumentsWithParenthesesParserRuleCall_1_1=norm1_ArgumentsWithParentheses();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ArgumentsWithParenthesesParserRuleCall_1_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1_1.start):null), (ArgumentsWithParenthesesParserRuleCall_1_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1_1.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_1()); 
                    }
                    loop296:
                    do {
                        int alt296=5;
                        int LA296_0 = input.LA(1);

                        if ( (LA296_0==LeftParenthesis) ) {
                            alt296=1;
                        }
                        else if ( (LA296_0==LeftSquareBracket) ) {
                            alt296=2;
                        }
                        else if ( (LA296_0==FullStop) ) {
                            alt296=3;
                        }
                        else if ( (LA296_0==RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL) && (synpred173_InternalN4JSParser())) {
                            alt296=4;
                        }
                        else if ( (LA296_0==RULE_TEMPLATE_HEAD) && (synpred173_InternalN4JSParser())) {
                            alt296=4;
                        }


                        switch (alt296) {
                    	case 1 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_114);
                    	    ArgumentsWithParenthesesParserRuleCall_1_2_0_1=norm1_ArgumentsWithParentheses();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {
                    	       announce((ArgumentsWithParenthesesParserRuleCall_1_2_0_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1_2_0_1.start):null), (ArgumentsWithParenthesesParserRuleCall_1_2_0_1!=null?((Token)ArgumentsWithParenthesesParserRuleCall_1_2_0_1.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getArgumentsWithParenthesesParserRuleCall_1_2_0_1()); 
                    	    }

                    	    }


                    	    }
                    	    break;
                    	case 2 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_114);
                    	    IndexedAccessExpressionTailParserRuleCall_1_2_1_1=norm1_IndexedAccessExpressionTail();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {
                    	       announce((IndexedAccessExpressionTailParserRuleCall_1_2_1_1!=null?((Token)IndexedAccessExpressionTailParserRuleCall_1_2_1_1.start):null), (IndexedAccessExpressionTailParserRuleCall_1_2_1_1!=null?((Token)IndexedAccessExpressionTailParserRuleCall_1_2_1_1.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTailParserRuleCall_1_2_1_1()); 
                    	    }

                    	    }


                    	    }
                    	    break;
                    	case 3 :
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_114);
                    	    ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1=norm1_ParameterizedPropertyAccessExpressionTail();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {
                    	       announce((ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1!=null?((Token)ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1.start):null), (ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1!=null?((Token)ParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTailParserRuleCall_1_2_2_1()); 
                    	    }

                    	    }


                    	    }
                    	    break;
                    	case 4 :
                    	    {
                    	    {
                    	    {
                    	    {
                    	    {
                    	    pushFollow(FOLLOW_114);
                    	    TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0=norm1_TemplateLiteral();

                    	    state._fsp--;
                    	    if (state.failed) return retval;
                    	    if ( state.backtracking==0 ) {

                    	      								announce((TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0!=null?((Token)TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0.start):null), (TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0!=null?((Token)TemplateTemplateLiteralParserRuleCall_1_2_3_0_1_0.stop):null), grammarAccess.getLeftHandSideExpressionAccess().getTemplateAssignment_1_2_3_0_1());
                    	      							
                    	    }

                    	    }


                    	    }


                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop296;
                        }
                    } while (true);


                    }
                    break;

            }


            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class ruleArgumentsWithParentheses_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.ruleArgumentsWithParentheses_return ruleArgumentsWithParentheses() throws RecognitionException {
        InternalN4JSParser.ruleArgumentsWithParentheses_return retval = new InternalN4JSParser.ruleArgumentsWithParentheses_return();
        retval.start = input.LT(1);

        Token LeftParenthesisKeyword_0=null;
        Token RightParenthesisKeyword_2=null;
        InternalN4JSParser.ruleArguments_return ArgumentsParserRuleCall_1 = null;




        try {
            {
            {
            LeftParenthesisKeyword_0=(Token)match(input,LeftParenthesis,FOLLOW_115); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_0, grammarAccess.getArgumentsWithParenthesesAccess().getLeftParenthesisKeyword_0());
              	
            }
            int alt298=2;
            int LA298_0 = input.LA(1);

            if ( ((LA298_0>=Intersection && LA298_0<=Implements)||(LA298_0>=Promisify && LA298_0<=Abstract)||(LA298_0>=External && LA298_0<=Function)||(LA298_0>=Private && LA298_0<=Delete)||(LA298_0>=Import && LA298_0<=Public)||LA298_0==Static||(LA298_0>=Target && LA298_0<=Await)||LA298_0==Class||(LA298_0>=False && LA298_0<=Super)||LA298_0==Union||(LA298_0>=Yield && LA298_0<=This)||(LA298_0>=From && LA298_0<=Void)||LA298_0==FullStopFullStopFullStop||(LA298_0>=Get && LA298_0<=Set)||LA298_0==PlusSignPlusSign||LA298_0==HyphenMinusHyphenMinus||LA298_0==SolidusEqualsSign||LA298_0==As||LA298_0==Of||LA298_0==ExclamationMark||LA298_0==LeftParenthesis||LA298_0==PlusSign||LA298_0==HyphenMinus||LA298_0==Solidus||LA298_0==LessThanSign||(LA298_0>=CommercialAt && LA298_0<=LeftSquareBracket)||LA298_0==LeftCurlyBracket||LA298_0==Tilde||LA298_0==RULE_DOUBLE||(LA298_0>=RULE_HEX_INT && LA298_0<=RULE_LEGACY_OCTAL_INT)||LA298_0==RULE_SCIENTIFIC_INT||LA298_0==RULE_IDENTIFIER||LA298_0==RULE_STRING||(LA298_0>=RULE_TEMPLATE_HEAD && LA298_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA298_0==RULE_INT) ) {
                alt298=1;
            }
            switch (alt298) {
                case 1 :
                    {
                    pushFollow(FOLLOW_72);
                    ArgumentsParserRuleCall_1=ruleArguments();

                    state._fsp--;
                    if (state.failed) return retval;
                    if ( state.backtracking==0 ) {
                       announce((ArgumentsParserRuleCall_1!=null?((Token)ArgumentsParserRuleCall_1.start):null), (ArgumentsParserRuleCall_1!=null?((Token)ArgumentsParserRuleCall_1.stop):null), grammarAccess.getArgumentsWithParenthesesAccess().getArgumentsParserRuleCall_1()); 
                    }

                    }
                    break;

            }

            RightParenthesisKeyword_2=(Token)match(input,RightParenthesis,FOLLOW_2); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(RightParenthesisKeyword_2, grammarAccess.getArgumentsWithParenthesesAccess().getRightParenthesisKeyword_2());
              	
            }

            }


            }

            retval.stop = input.LT(-1);

        }

            catch (RecognitionException re) {
                recover(input,re);
            }
        finally {
        }
        return retval;
    }

    public static class norm1_ArgumentsWithParentheses_return extends ParserRuleReturnScope {
    };
    public final InternalN4JSParser.norm1_ArgumentsWithParentheses_return norm1_ArgumentsWithParentheses() throws RecognitionException {
        InternalN4JSParser.norm1_ArgumentsWithParentheses_return retval = new InternalN4JSParser.norm1_ArgumentsWithParentheses_return();
        retval.start = input.LT(1);

        Token LeftParenthesisKeyword_0=null;
        Token RightParenthesisKeyword_2=null;
        InternalN4JSParser.norm1_Arguments_return ArgumentsParserRuleCall_1 = null;




        try {
            {
            {
            LeftParenthesisKeyword_0=(Token)match(input,LeftParenthesis,FOLLOW_116); if (state.failed) return retval;
            if ( state.backtracking==0 ) {

              		announce(LeftParenthesisKeyword_0, grammarAccess.getArgumentsWithParenthesesAccess().getLeftParenthesisKeyword_0());
              	
            }
            int alt299=2;
            int LA299_0 = input.LA(1);

            if ( ((LA299_0>=Intersection && LA299_0<=Implements)||(LA299_0>=Promisify && LA299_0<=Abstract)||(LA299_0>=External && LA299_0<=Function)||(LA299_0>=Private && LA299_0<=Delete)||(LA299_0>=Import && LA299_0<=Public)||LA299_0==Static||(LA299_0>=Target && LA299_0<=Await)||LA299_0==Class||(LA299_0>=False && LA299_0<=Super)||LA299_0==Union||(LA299_0>=Yield && LA299_0<=This)||(LA299_0>=From && LA299_0<=Void)||LA299_0==FullStopFullStopFullStop||(LA299_0>=Get && LA299_0<=Set)||LA299_0==PlusSignPlusSign||LA299_0==HyphenMinusHyphenMinus||LA299_0==SolidusEqualsSign||LA299_0==As||LA299_0==Of||LA299_0==ExclamationMark||LA299_0==LeftParenthesis||LA299_0==PlusSign||LA299_0==HyphenMinus||LA299_0==Solidus||LA299_0==LessThanSign||(LA299_0>=CommercialAt && LA299_0<=LeftSquareBracket)||LA299_0==LeftCurlyBracket||LA299_0==Tilde||LA299_0==RULE_DOUBLE||(LA299_0>=RULE_HEX_INT && LA299_0<=RULE_LEGACY_OCTAL_INT)||LA299_0==RULE_SCIENTIFIC_INT||LA299_0==RULE_IDENTIFIER||LA299_0==RULE_STRING||(LA299_0>=RULE_TEMPLATE_HEAD && LA299_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA299_0==RULE_INT) ) {
       