/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.utils;

import org.eclipse.xtend.lib.macro.AbstractFieldProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.InterfaceDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.expression.Expression;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class CompilerProcessor extends AbstractFieldProcessor {
  @Override
  public void doTransform(final MutableFieldDeclaration annotatedField, @Extension final TransformationContext context) {
    TypeReference _type = annotatedField.getType();
    TypeReference _string = context.getString();
    boolean _tripleEquals = (_type == _string);
    if (_tripleEquals) {
      context.addError(annotatedField, "Annotated field must be of type String.");
    } else {
      final String value = this.getInitializerAsString(annotatedField, context);
      if ((value != null)) {
        final Type resolvedType = context.findTypeGlobally(value);
        if ((resolvedType == null)) {
          context.addError(annotatedField.getInitializer(), (value + " isn\'t on the classpath."));
        } else {
          if ((!(resolvedType instanceof ClassDeclaration))) {
            context.addError(annotatedField.getInitializer(), (value + " have to resolve to a class on the classpath."));
          } else {
            final ClassDeclaration clazz = ((ClassDeclaration) resolvedType);
            final String subGeneratorInterface = "org.eclipse.n4js.generator.ISubGenerator";
            boolean _implementsInterface = this.implementsInterface(clazz, subGeneratorInterface);
            boolean _not = (!_implementsInterface);
            if (_not) {
              Expression _initializer = annotatedField.getInitializer();
              final Function1<TypeReference, String> _function = (TypeReference it) -> {
                return it.getName();
              };
              Iterable<String> _map = IterableExtensions.map(clazz.getImplementedInterfaces(), _function);
              String _plus = ((((("The class " + value) + " have to implement the interface ") + subGeneratorInterface) + ", but only implements ") + _map);
              context.addError(_initializer, _plus);
            }
          }
        }
      }
    }
  }
  
  private boolean implementsInterface(final ClassDeclaration clazz, final String expectedInterface) {
    final Function1<TypeReference, Boolean> _function = (TypeReference it) -> {
      return Boolean.valueOf(it.getName().equals(expectedInterface));
    };
    boolean _exists = IterableExtensions.exists(clazz.getImplementedInterfaces(), _function);
    if (_exists) {
      return true;
    }
    final Function1<TypeReference, Boolean> _function_1 = (TypeReference it) -> {
      Type _type = it.getType();
      return Boolean.valueOf(this.extendsInterface(((InterfaceDeclaration) _type), expectedInterface));
    };
    boolean _exists_1 = IterableExtensions.exists(clazz.getImplementedInterfaces(), _function_1);
    if (_exists_1) {
      return true;
    }
    TypeReference _extendedClass = clazz.getExtendedClass();
    boolean _tripleNotEquals = (_extendedClass != null);
    if (_tripleNotEquals) {
      Type _type = clazz.getExtendedClass().getType();
      return this.implementsInterface(((ClassDeclaration) _type), expectedInterface);
    }
    return false;
  }
  
  private boolean extendsInterface(final InterfaceDeclaration interf, final String expectedInterface) {
    final Function1<TypeReference, Boolean> _function = (TypeReference it) -> {
      return Boolean.valueOf(it.getName().equals(expectedInterface));
    };
    boolean _exists = IterableExtensions.exists(interf.getExtendedInterfaces(), _function);
    if (_exists) {
      return true;
    }
    return false;
  }
  
  public String getInitializerAsString(final FieldDeclaration f, @Extension final TransformationContext context) {
    Expression _initializer = f.getInitializer();
    String _string = null;
    if (_initializer!=null) {
      _string=_initializer.toString();
    }
    final String string = _string;
    if ((string == null)) {
      context.addError(f, "A value have to be assigned to this annotated field.");
    } else {
      boolean _not = (!(string.startsWith("\"") && string.endsWith("\"")));
      if (_not) {
        context.addError(f, "A quoted string value have to be assigned to this annotated field.");
      } else {
        int _length = string.length();
        int _minus = (_length - 1);
        return string.substring(1, _minus);
      }
    }
    return null;
  }
}
