/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.utils.beans;

import com.google.common.base.CaseFormat;
import com.google.common.base.Objects;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.n4js.utils.beans.IgnorePropertyChangeEvents;
import org.eclipse.xtend.lib.annotations.AccessorsProcessor;
import org.eclipse.xtend.lib.macro.AbstractClassProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTarget;
import org.eclipse.xtend.lib.macro.declaration.ClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Class transformation processor for generating {@link PropertyChangeSupport} for all
 * non-final non-static fields within a class annotated with {@link org.eclipse.n4js.utils.beans.PropertyChangeSupport} annotation.
 */
@SuppressWarnings("all")
public class PropertyChangeSupportProcessor extends AbstractClassProcessor {
  @Override
  public void doTransform(final MutableClassDeclaration clazz, @Extension final TransformationContext context) {
    final Function1<AnnotationReference, Boolean> _function = (AnnotationReference it) -> {
      String _qualifiedName = it.getAnnotationTypeDeclaration().getQualifiedName();
      String _name = org.eclipse.n4js.utils.beans.PropertyChangeSupport.class.getName();
      return Boolean.valueOf(Objects.equal(_qualifiedName, _name));
    };
    final Iterable<? extends AnnotationReference> annotations = IterableExtensions.filter(clazz.getAnnotations(), _function);
    boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(annotations);
    if (_isNullOrEmpty) {
      return;
    }
    int _size = IterableExtensions.size(annotations);
    boolean _greaterThan = (_size > 1);
    if (_greaterThan) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Duplicate annotation of non-repeatable type @");
      String _simpleName = org.eclipse.n4js.utils.beans.PropertyChangeSupport.class.getSimpleName();
      _builder.append(_simpleName);
      _builder.append(".");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t\t\t\t");
      _builder.append("Only annotation types marked @");
      String _simpleName_1 = Repeatable.class.getSimpleName();
      _builder.append(_simpleName_1, "\t\t\t\t\t\t");
      _builder.append(" can be used multiple times at one target.");
      context.addError(clazz, _builder.toString());
      return;
    }
    final boolean verbose = IterableExtensions.head(annotations).getBooleanValue("verbose");
    if (verbose) {
      final Procedure1<MutableFieldDeclaration> _function_1 = (MutableFieldDeclaration it) -> {
        it.setVisibility(Visibility.PRIVATE);
        it.setStatic(true);
        it.setFinal(true);
        it.setType(context.newTypeReference(Logger.class));
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append(Logger.class);
            _builder.append(".getLogger(");
            _builder.append(clazz);
            _builder.append(".class)");
          }
        };
        it.setInitializer(_client);
      };
      clazz.addField("PROPERTY_CHANGE_LOGGER", _function_1);
    }
    final Function1<MutableFieldDeclaration, Boolean> _function_2 = (MutableFieldDeclaration it) -> {
      return Boolean.valueOf(((((null != it.getType()) && (!it.isFinal())) && (!it.isStatic())) && (!this.hasAnnotation(it, IgnorePropertyChangeEvents.class))));
    };
    final Iterable<? extends MutableFieldDeclaration> fields = IterableExtensions.filter(clazz.getDeclaredFields(), _function_2);
    final Function1<MutableFieldDeclaration, Boolean> _function_3 = (MutableFieldDeclaration it) -> {
      return Boolean.valueOf(it.getType().isInferred());
    };
    final Iterable<? extends MutableFieldDeclaration> inferredFields = IterableExtensions.filter(fields, _function_3);
    boolean _isNullOrEmpty_1 = IterableExtensions.isNullOrEmpty(inferredFields);
    boolean _not = (!_isNullOrEmpty_1);
    if (_not) {
      final Consumer<MutableFieldDeclaration> _function_4 = (MutableFieldDeclaration it) -> {
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("The type of field must be explicitly declared to enable the property change support.");
        context.addError(it, _builder_1.toString());
      };
      inferredFields.forEach(_function_4);
      return;
    }
    boolean _hasSuperPropertyChangeSupportGetter = this.hasSuperPropertyChangeSupportGetter(clazz, context);
    boolean _not_1 = (!_hasSuperPropertyChangeSupportGetter);
    if (_not_1) {
      final Procedure1<MutableFieldDeclaration> _function_5 = (MutableFieldDeclaration it) -> {
        it.setVisibility(Visibility.PRIVATE);
        it.setStatic(false);
        it.setFinal(true);
        it.setType(context.newTypeReference(PropertyChangeSupport.class));
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("new ");
            _builder.append(PropertyChangeSupport.class);
            _builder.append("(this)");
          }
        };
        it.setInitializer(_client);
      };
      clazz.addField("_propertyChangeSupport", _function_5);
      final Procedure1<MutableMethodDeclaration> _function_6 = (MutableMethodDeclaration it) -> {
        it.setVisibility(Visibility.PROTECTED);
        it.setStatic(false);
        it.setFinal(true);
        it.setReturnType(context.newTypeReference(PropertyChangeSupport.class));
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("return this._propertyChangeSupport;");
            _builder.newLine();
          }
        };
        it.setBody(_client);
      };
      clazz.addMethod("internalGetPropertyChangeSupport", _function_6);
    }
    boolean _hasSuperAddPropertyChangeListener = this.hasSuperAddPropertyChangeListener(clazz, context);
    boolean _not_2 = (!_hasSuperAddPropertyChangeListener);
    if (_not_2) {
      final Procedure1<MutableMethodDeclaration> _function_7 = (MutableMethodDeclaration it) -> {
        it.setReturnType(context.getPrimitiveVoid());
        final TypeReference typeRef = context.newTypeReference(PropertyChangeListener.class);
        final MutableParameterDeclaration param = it.addParameter("listener", typeRef);
        it.setVisibility(Visibility.PUBLIC);
        it.setStatic(false);
        it.setFinal(true);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("internalGetPropertyChangeSupport().addPropertyChangeListener(");
            String _simpleName = param.getSimpleName();
            _builder.append(_simpleName);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        };
        it.setBody(_client);
      };
      clazz.addMethod("addPropertyChangeListener", _function_7);
    }
    boolean _hasSuperRemovePropertyChangeListener = this.hasSuperRemovePropertyChangeListener(clazz, context);
    boolean _not_3 = (!_hasSuperRemovePropertyChangeListener);
    if (_not_3) {
      final Procedure1<MutableMethodDeclaration> _function_8 = (MutableMethodDeclaration it) -> {
        it.setReturnType(context.getPrimitiveVoid());
        final TypeReference typeRef = context.newTypeReference(PropertyChangeListener.class);
        final MutableParameterDeclaration param = it.addParameter("listener", typeRef);
        it.setVisibility(Visibility.PUBLIC);
        it.setStatic(false);
        it.setFinal(true);
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("internalGetPropertyChangeSupport().removePropertyChangeListener(");
            String _simpleName = param.getSimpleName();
            _builder.append(_simpleName);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        };
        it.setBody(_client);
      };
      clazz.addMethod("removePropertyChangeListener", _function_8);
    }
    final Consumer<MutableFieldDeclaration> _function_9 = (MutableFieldDeclaration field) -> {
      StringConcatenation _builder_1 = new StringConcatenation();
      String _to = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, field.getSimpleName());
      _builder_1.append(_to);
      _builder_1.append("_PROPERTY");
      final String propertyName = _builder_1.toString();
      TypeReference _xifexpression = null;
      TypeReference _type = field.getType();
      boolean _tripleEquals = (null == _type);
      if (_tripleEquals) {
        _xifexpression = context.getObject();
      } else {
        _xifexpression = field.getType();
      }
      final TypeReference fieldTypeRef = _xifexpression;
      final Procedure1<MutableFieldDeclaration> _function_10 = (MutableFieldDeclaration it) -> {
        it.setVisibility(Visibility.PUBLIC);
        it.setStatic(true);
        it.setFinal(true);
        it.setType(context.getString());
        it.setConstantValueAsString(field.getSimpleName());
      };
      clazz.addField(propertyName, _function_10);
      final AccessorsProcessor.Util accessorUtil = new AccessorsProcessor.Util(context);
      boolean _shouldAddGetter = accessorUtil.shouldAddGetter(field);
      if (_shouldAddGetter) {
        accessorUtil.addGetter(field, Visibility.PUBLIC);
      }
      final Procedure1<MutableMethodDeclaration> _function_11 = (MutableMethodDeclaration it) -> {
        it.setReturnType(context.getPrimitiveVoid());
        final MutableParameterDeclaration param = it.addParameter(field.getSimpleName(), fieldTypeRef);
        String _xifexpression_1 = null;
        boolean _isAssignableFrom = context.newTypeReference(Collection.class).isAssignableFrom(fieldTypeRef);
        if (_isAssignableFrom) {
          StringConcatenation _builder_2 = new StringConcatenation();
          _builder_2.append("new ");
          String _name = ArrayList.class.getName();
          _builder_2.append(_name);
          _builder_2.append("(this.");
          String _simpleName_2 = field.getSimpleName();
          _builder_2.append(_simpleName_2);
          _builder_2.append(")");
          _xifexpression_1 = _builder_2.toString();
        } else {
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("this.");
          String _simpleName_3 = field.getSimpleName();
          _builder_3.append(_simpleName_3);
          _xifexpression_1 = _builder_3.toString();
        }
        final String oldValue = _xifexpression_1;
        StringConcatenationClient _client = new StringConcatenationClient() {
          @Override
          protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            _builder.append("internalGetPropertyChangeSupport().firePropertyChange(");
            _builder.append(propertyName);
            _builder.append(", ");
            _builder.append(oldValue);
            _builder.append(", this.");
            String _simpleName = field.getSimpleName();
            _builder.append(_simpleName);
            _builder.append(" = ");
            String _simpleName_1 = param.getSimpleName();
            _builder.append(_simpleName_1);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
          }
        };
        it.setBody(_client);
        it.setVisibility(Visibility.PUBLIC);
      };
      clazz.addMethod(accessorUtil.getSetterName(field), _function_11);
      boolean _isAssignableFrom = context.newTypeReference(Collection.class).isAssignableFrom(fieldTypeRef);
      if (_isAssignableFrom) {
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("add");
        String _firstUpper = StringExtensions.toFirstUpper(field.getSimpleName());
        _builder_2.append(_firstUpper);
        final Procedure1<MutableMethodDeclaration> _function_12 = (MutableMethodDeclaration it) -> {
          it.setReturnType(context.getPrimitiveVoid());
          TypeReference _elvis = null;
          TypeReference _head = IterableExtensions.<TypeReference>head(fieldTypeRef.getActualTypeArguments());
          if (_head != null) {
            _elvis = _head;
          } else {
            TypeReference _object = context.getObject();
            _elvis = _object;
          }
          final TypeReference typeRef = _elvis;
          StringConcatenation _builder_3 = new StringConcatenation();
          _builder_3.append("element");
          String _firstUpper_1 = StringExtensions.toFirstUpper(field.getSimpleName());
          _builder_3.append(_firstUpper_1);
          final MutableParameterDeclaration param = it.addParameter(_builder_3.toString(), typeRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("internalGetPropertyChangeSupport().firePropertyChange(");
              _builder.newLine();
              _builder.append("\t");
              _builder.append(propertyName, "\t");
              _builder.append(",");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("new ");
              String _name = ArrayList.class.getName();
              _builder.append(_name, "\t");
              _builder.append("(this.");
              String _simpleName = field.getSimpleName();
              _builder.append(_simpleName, "\t");
              _builder.append("),");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("this.");
              String _simpleName_1 = field.getSimpleName();
              _builder.append(_simpleName_1, "\t");
              _builder.append(".add(");
              String _simpleName_2 = param.getSimpleName();
              _builder.append(_simpleName_2, "\t");
              _builder.append(") ? this.");
              String _simpleName_3 = field.getSimpleName();
              _builder.append(_simpleName_3, "\t");
              _builder.append(" : this.");
              String _simpleName_4 = field.getSimpleName();
              _builder.append(_simpleName_4, "\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          };
          it.setBody(_client);
          it.setVisibility(Visibility.PUBLIC);
        };
        clazz.addMethod(_builder_2.toString(), _function_12);
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("remove");
        String _firstUpper_1 = StringExtensions.toFirstUpper(field.getSimpleName());
        _builder_3.append(_firstUpper_1);
        final Procedure1<MutableMethodDeclaration> _function_13 = (MutableMethodDeclaration it) -> {
          it.setReturnType(context.getPrimitiveVoid());
          TypeReference _elvis = null;
          TypeReference _head = IterableExtensions.<TypeReference>head(fieldTypeRef.getActualTypeArguments());
          if (_head != null) {
            _elvis = _head;
          } else {
            TypeReference _object = context.getObject();
            _elvis = _object;
          }
          final TypeReference typeRef = _elvis;
          StringConcatenation _builder_4 = new StringConcatenation();
          _builder_4.append("element");
          String _firstUpper_2 = StringExtensions.toFirstUpper(field.getSimpleName());
          _builder_4.append(_firstUpper_2);
          final MutableParameterDeclaration param = it.addParameter(_builder_4.toString(), typeRef);
          StringConcatenationClient _client = new StringConcatenationClient() {
            @Override
            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
              _builder.append("internalGetPropertyChangeSupport().firePropertyChange(");
              _builder.newLine();
              _builder.append("\t");
              _builder.append(propertyName, "\t");
              _builder.append(",");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("new ");
              String _name = ArrayList.class.getName();
              _builder.append(_name, "\t");
              _builder.append("(this.");
              String _simpleName = field.getSimpleName();
              _builder.append(_simpleName, "\t");
              _builder.append("),");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("this.");
              String _simpleName_1 = field.getSimpleName();
              _builder.append(_simpleName_1, "\t");
              _builder.append(".remove(");
              String _simpleName_2 = param.getSimpleName();
              _builder.append(_simpleName_2, "\t");
              _builder.append(") ? this.");
              String _simpleName_3 = field.getSimpleName();
              _builder.append(_simpleName_3, "\t");
              _builder.append(" : this.");
              String _simpleName_4 = field.getSimpleName();
              _builder.append(_simpleName_4, "\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          };
          it.setBody(_client);
          it.setVisibility(Visibility.PUBLIC);
        };
        clazz.addMethod(_builder_3.toString(), _function_13);
      }
    };
    fields.forEach(_function_9);
  }
  
  private boolean hasPropertyChangeSupportGetter(final ClassDeclaration it, final TransformationContext context) {
    final Function1<MethodDeclaration, Boolean> _function = (MethodDeclaration it_1) -> {
      return Boolean.valueOf((((Objects.equal(it_1.getSimpleName(), "internalGetPropertyChangeSupport") && Objects.equal(it_1.getReturnType(), context.newTypeReference(PropertyChangeSupport.class))) && (IterableExtensions.size(it_1.getParameters()) == 0)) && ((it_1.getVisibility() == Visibility.PROTECTED) || (it_1.getVisibility() == Visibility.PUBLIC))));
    };
    return IterableExtensions.exists(it.getDeclaredMethods(), _function);
  }
  
  private boolean hasSuperPropertyChangeSupportGetter(final ClassDeclaration cls, final TransformationContext context) {
    Type _type = cls.getExtendedClass().getType();
    ClassDeclaration superClass = ((ClassDeclaration) _type);
    while ((null != superClass)) {
      {
        boolean _hasPropertyChangeSupportGetter = this.hasPropertyChangeSupportGetter(superClass, context);
        if (_hasPropertyChangeSupportGetter) {
          return true;
        }
        TypeReference _extendedClass = superClass.getExtendedClass();
        Type _type_1 = null;
        if (_extendedClass!=null) {
          _type_1=_extendedClass.getType();
        }
        superClass = ((ClassDeclaration) _type_1);
      }
    }
    return false;
  }
  
  private boolean hasAnnotation(final AnnotationTarget it, final Class<? extends Annotation> annotation) {
    final Function1<AnnotationReference, Boolean> _function = (AnnotationReference it_1) -> {
      String _qualifiedName = it_1.getAnnotationTypeDeclaration().getQualifiedName();
      String _name = annotation.getName();
      return Boolean.valueOf(Objects.equal(_qualifiedName, _name));
    };
    return IterableExtensions.exists(it.getAnnotations(), _function);
  }
  
  private boolean hasAddPropertyChangeListener(final ClassDeclaration it, final TransformationContext context) {
    final Function1<MethodDeclaration, Boolean> _function = (MethodDeclaration it_1) -> {
      return Boolean.valueOf((((Objects.equal(it_1.getSimpleName(), "addPropertyChangeListener") && Objects.equal(it_1.getReturnType(), context.getPrimitiveVoid())) && (IterableExtensions.size(it_1.getParameters()) == 1)) && Objects.equal(IterableExtensions.head(it_1.getParameters()).getType(), context.newTypeReference(PropertyChangeListener.class))));
    };
    return IterableExtensions.exists(it.getDeclaredMethods(), _function);
  }
  
  private boolean hasSuperAddPropertyChangeListener(final ClassDeclaration cls, final TransformationContext context) {
    Type _type = cls.getExtendedClass().getType();
    ClassDeclaration superClass = ((ClassDeclaration) _type);
    while ((null != superClass)) {
      {
        boolean _hasAddPropertyChangeListener = this.hasAddPropertyChangeListener(superClass, context);
        if (_hasAddPropertyChangeListener) {
          return true;
        }
        TypeReference _extendedClass = superClass.getExtendedClass();
        Type _type_1 = null;
        if (_extendedClass!=null) {
          _type_1=_extendedClass.getType();
        }
        superClass = ((ClassDeclaration) _type_1);
      }
    }
    return false;
  }
  
  private boolean hasRemovePropertyChangeListener(final ClassDeclaration it, final TransformationContext context) {
    final Function1<MethodDeclaration, Boolean> _function = (MethodDeclaration it_1) -> {
      return Boolean.valueOf((((Objects.equal(it_1.getSimpleName(), "removePropertyChangeListener") && Objects.equal(it_1.getReturnType(), context.getPrimitiveVoid())) && (IterableExtensions.size(it_1.getParameters()) == 1)) && Objects.equal(IterableExtensions.head(it_1.getParameters()).getType(), context.newTypeReference(PropertyChangeListener.class))));
    };
    return IterableExtensions.exists(it.getDeclaredMethods(), _function);
  }
  
  private boolean hasSuperRemovePropertyChangeListener(final ClassDeclaration cls, final TransformationContext context) {
    Type _type = cls.getExtendedClass().getType();
    ClassDeclaration superClass = ((ClassDeclaration) _type);
    while ((null != superClass)) {
      {
        boolean _hasRemovePropertyChangeListener = this.hasRemovePropertyChangeListener(superClass, context);
        if (_hasRemovePropertyChangeListener) {
          return true;
        }
        TypeReference _extendedClass = superClass.getExtendedClass();
        Type _type_1 = null;
        if (_extendedClass!=null) {
          _type_1=_extendedClass.getType();
        }
        superClass = ((ClassDeclaration) _type_1);
      }
    }
    return false;
  }
}
