/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.accessModifiers;

import org.eclipse.n4js.scoping.utils.AbstractDescriptionWithError;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.resource.IEObjectDescription;

public class InvisibleMemberDescription
extends AbstractDescriptionWithError {
    private String accessModifierSuggestion;

    public InvisibleMemberDescription(IEObjectDescription delegate) {
        super(delegate);
    }

    public InvisibleMemberDescription(IEObjectDescription delegate, String accessorSuggestion) {
        super(delegate);
        this.accessModifierSuggestion = accessorSuggestion;
    }

    public String getMessage() {
        String memberTypeName = InvisibleMemberDescription.getMemberTypeName(this.getEObjectOrProxy(), false);
        String memberName = this.getName().getLastSegment();
        return IssueCodes.getMessageForVIS_ILLEGAL_MEMBER_ACCESS(memberTypeName, memberName);
    }

    public String getIssueCode() {
        return "VIS_ILLEGAL_MEMBER_ACCESS";
    }

    public String getUserData(String name) {
        switch (name) {
            case "org.eclipse.n4js.scoping.accessModifiers.InvisibleMemberDescription.accessModifierSuggestion": {
                return this.accessModifierSuggestion;
            }
            case "org.eclipse.n4js.scoping.accessModifiers.InvisibleMemberDescription.declarationObjectUri": {
                return this.getEObjectURI().toString();
            }
        }
        return null;
    }

    public String[] getUserDataKeys() {
        return new String[]{"org.eclipse.n4js.scoping.accessModifiers.InvisibleMemberDescription.accessModifierSuggestion", "org.eclipse.n4js.scoping.accessModifiers.InvisibleMemberDescription.declarationObjectUri"};
    }
}

