/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.formatting2;

import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.n4js.formatting2.InsertSemiBase;
import org.eclipse.n4js.formatting2.InsertSemiFollowedByTextReplacer;
import org.eclipse.n4js.utils.Log;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.internal.HiddenRegionReplacer;
import org.eclipse.xtext.formatting2.internal.TextReplacerMerger;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Log
@SuppressWarnings("all")
public class IndentHandlingTextReplaceMerger extends TextReplacerMerger {
  private final AbstractFormatter2 fmt;
  
  public IndentHandlingTextReplaceMerger(final AbstractFormatter2 formatter) {
    super(formatter);
    this.fmt = formatter;
  }
  
  /**
   * Overridden for special case of {@link InsertSemi} & {@link HiddenRegionReplacer} merging.
   * Calls super implementation if no InsertSemi object is involved
   */
  @Override
  public ITextReplacer merge(final List<? extends ITextReplacer> conflicting) {
    final Function1<ITextReplacer, Boolean> _function = (ITextReplacer it) -> {
      return Boolean.valueOf((it instanceof InsertSemiBase));
    };
    ITextReplacer _findFirst = IterableExtensions.findFirst(conflicting, _function);
    boolean _tripleEquals = (_findFirst == null);
    if (_tripleEquals) {
      final List<HiddenRegionReplacer> hrf = IterableExtensions.<HiddenRegionReplacer>toList(Iterables.<HiddenRegionReplacer>filter(conflicting, HiddenRegionReplacer.class));
      int _size = hrf.size();
      int _size_1 = conflicting.size();
      boolean _tripleEquals_1 = (_size == _size_1);
      if (_tripleEquals_1) {
        final Function1<HiddenRegionReplacer, IHiddenRegionFormatting> _function_1 = (HiddenRegionReplacer it) -> {
          return it.getFormatting();
        };
        final IHiddenRegionFormatting merged = this.fmt.createHiddenRegionFormattingMerger().merge(ListExtensions.<HiddenRegionReplacer, IHiddenRegionFormatting>map(hrf, _function_1));
        if ((merged != null)) {
          return this.fmt.createHiddenRegionReplacer(IterableExtensions.<HiddenRegionReplacer>head(hrf).getRegion(), merged);
        }
      }
      return super.merge(conflicting);
    }
    final Function1<ITextReplacer, Boolean> _function_2 = (ITextReplacer it) -> {
      return Boolean.valueOf((it instanceof InsertSemiBase));
    };
    final List<? extends ITextReplacer> semiReplacements = IterableExtensions.toList(IterableExtensions.filter(conflicting, _function_2));
    final Function1<ITextReplacer, Boolean> _function_3 = (ITextReplacer it) -> {
      return Boolean.valueOf((!(it instanceof InsertSemiBase)));
    };
    final List<? extends ITextReplacer> otherReplacements = IterableExtensions.toList(IterableExtensions.filter(conflicting, _function_3));
    if (((semiReplacements.size() != 1) || (otherReplacements.size() != 1))) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Unhandled merge-case: \"");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("\"Semis replacer (");
      int _size_2 = semiReplacements.size();
      _builder.append(_size_2, "\t");
      _builder.append(") :");
      _builder.append(semiReplacements, "\t");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("\"Non-Semi replacer ( ");
      int _size_3 = otherReplacements.size();
      _builder.append(_size_3, "\t");
      _builder.append("  ");
      _builder.append(otherReplacements, "\t");
      _builder.newLineIfNotEmpty();
      IndentHandlingTextReplaceMerger.logger.warn(_builder);
      return null;
    }
    ITextReplacer _get = semiReplacements.get(0);
    final InsertSemiBase semiRepl = ((InsertSemiBase) _get);
    final ITextReplacer otherRepl = otherReplacements.get(0);
    if ((otherRepl instanceof HiddenRegionReplacer)) {
      return new InsertSemiFollowedByTextReplacer(semiRepl, otherRepl);
    }
    return null;
  }
  
  private static final Logger logger = Logger.getLogger(IndentHandlingTextReplaceMerger.class);
}
