/**
 * Copyright (c) 2018 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.n4idl.migrations;

import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.n4js.n4idl.migrations.SwitchCondition;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * {@link SwitchCondition} which assures that at least one of the {@link #operands} conditions
 * evaluates to true.
 */
@SuppressWarnings("all")
public class OrSwitchCondition extends SwitchCondition {
  public List<SwitchCondition> operands;
  
  public OrSwitchCondition(final SwitchCondition operand1, final SwitchCondition operand2, final Iterable<? extends SwitchCondition> remainingOperands) {
    this.operands = IterableExtensions.<SwitchCondition>toList(Iterables.<SwitchCondition>concat(Collections.<SwitchCondition>unmodifiableList(CollectionLiterals.<SwitchCondition>newArrayList(operand1, operand2)), remainingOperands));
  }
  
  @Override
  public int hashCode() {
    int _hashCode = this.operands.hashCode();
    int _asInt = HashCode.fromString(OrSwitchCondition.class.getSimpleName()).asInt();
    int _multiply = (31 * _asInt);
    return (_hashCode + _multiply);
  }
  
  @Override
  public String getConditionAsString(final String valueIdentifier) {
    final Function<SwitchCondition, String> _function = (SwitchCondition o) -> {
      String _conditionAsString = o.getConditionAsString(valueIdentifier);
      String _plus = ("(" + _conditionAsString);
      return (_plus + ")");
    };
    return this.operands.stream().<String>map(_function).collect(Collectors.joining(" || "));
  }
  
  @Override
  public Iterable<? extends SwitchCondition> subConditions() {
    return this.operands;
  }
}
