package org.eclipse.n4js.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.n4js.services.N4JSGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
@SuppressWarnings("all")
public class InternalN4JSParser extends AbstractInternalAntlrParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "Intersection", "Constructor", "Implements", "Instanceof", "Promisify", "Interface", "Protected", "Abstract", "Continue", "Debugger", "External", "Function", "Default", "Extends", "Finally", "Private", "Project", "Delete", "Export", "Import", "Public", "Return", "Static", "Switch", "Target", "Typeof", "Async", "Await", "Break", "Catch", "Class", "Const", "False", "Super", "Throw", "Union", "While", "Yield", "This", "Case", "Else", "Enum", "From", "Null", "This_1", "True", "Type", "Void", "With", "ExclamationMarkEqualsSignEqualsSign", "FullStopFullStopFullStop", "LessThanSignLessThanSignEqualsSign", "EqualsSignEqualsSignEqualsSign", "For", "Get", "Let", "New", "Out", "Set", "Try", "Var", "ExclamationMarkEqualsSign", "PercentSignEqualsSign", "AmpersandAmpersand", "AmpersandEqualsSign", "AsteriskEqualsSign", "PlusSignPlusSign", "PlusSignEqualsSign", "HyphenMinusHyphenMinus", "HyphenMinusEqualsSign", "SolidusEqualsSign", "LessThanSignLessThanSign", "LessThanSignEqualsSign", "EqualsSignEqualsSign", "EqualsSignGreaterThanSign", "CommercialAtCommercialAt", "CircumflexAccentEqualsSign", "As", "Do", "If", "In", "Of", "VerticalLineEqualsSign", "VerticalLineVerticalLine", "ExclamationMark", "PercentSign", "Ampersand", "LeftParenthesis", "RightParenthesis", "Asterisk", "PlusSign", "Comma", "HyphenMinus", "FullStop", "Solidus", "Colon", "Semicolon", "LessThanSign", "EqualsSign", "GreaterThanSign", "QuestionMark", "CommercialAt", "LeftSquareBracket", "RightSquareBracket", "CircumflexAccent", "LeftCurlyBracket", "VerticalLine", "RightCurlyBracket", "Tilde", "RULE_DECIMAL_DIGIT_FRAGMENT", "RULE_EXPONENT_PART", "RULE_DECIMAL_INTEGER_LITERAL_FRAGMENT", "RULE_DOUBLE", "RULE_INT_SUFFIX", "RULE_HEX_INT", "RULE_BINARY_INT", "RULE_OCTAL_INT", "RULE_LEGACY_OCTAL_INT", "RULE_IDENTIFIER_PART", "RULE_SCIENTIFIC_INT", "RULE_SIGNED_INT", "RULE_IDENTIFIER", "RULE_DOUBLE_STRING_CHAR", "RULE_SINGLE_STRING_CHAR", "RULE_STRING", "RULE_LINE_TERMINATOR_FRAGMENT", "RULE_LINE_TERMINATOR_SEQUENCE_FRAGMENT", "RULE_BACKSLASH_SEQUENCE", "RULE_REGEX_CHAR_OR_BRACKET", "RULE_REGEX_CHAR", "RULE_ACTUAL_REGEX_TAIL", "RULE_REGEX_START", "RULE_REGEX_TAIL", "RULE_TEMPLATE_LITERAL_CHAR", "RULE_TEMPLATE_HEAD", "RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL", "RULE_ACTUAL_TEMPLATE_END", "RULE_TEMPLATE_MIDDLE", "RULE_TEMPLATE_END", "RULE_TEMPLATE_CONTINUATION", "RULE_NO_LINE_TERMINATOR", "RULE_INCOMPLETE_ASYNC_ARROW", "RULE_STRUCTMODSUFFIX", "RULE_IDENTIFIER_START", "RULE_INT", "RULE_ML_COMMENT_FRAGMENT", "RULE_ML_COMMENT", "RULE_SL_COMMENT", "RULE_EOL", "RULE_WHITESPACE_FRAGMENT", "RULE_WS", "RULE_HEX_DIGIT", "RULE_UNICODE_ESCAPE_FRAGMENT", "RULE_UNICODE_LETTER_FRAGMENT", "RULE_UNICODE_COMBINING_MARK_FRAGMENT", "RULE_UNICODE_DIGIT_FRAGMENT", "RULE_UNICODE_CONNECTOR_PUNCTUATION_FRAGMENT", "RULE_ZWNJ", "RULE_ZWJ", "RULE_DOT_DOT", "RULE_VERSION", "RULE_BOM", "RULE_UNICODE_SPACE_SEPARATOR_FRAGMENT", "RULE_SL_COMMENT_FRAGMENT", "RULE_ANY_OTHER"
    };
    public static final int Delete=21;
    public static final int Enum=45;
    public static final int RULE_REGEX_CHAR=133;
    public static final int Import=23;
    public static final int EqualsSignGreaterThanSign=78;
    public static final int Var=64;
    public static final int RULE_ACTUAL_TEMPLATE_END=140;
    public static final int Break=32;
    public static final int False=36;
    public static final int LessThanSign=101;
    public static final int LeftParenthesis=91;
    public static final int RULE_VERSION=164;
    public static final int RULE_TEMPLATE_LITERAL_CHAR=137;
    public static final int Throw=38;
    public static final int Private=19;
    public static final int Extends=17;
    public static final int RULE_REGEX_TAIL=136;
    public static final int ExclamationMark=88;
    public static final int ExclamationMarkEqualsSignEqualsSign=53;
    public static final int GreaterThanSign=103;
    public static final int RULE_LINE_TERMINATOR_SEQUENCE_FRAGMENT=130;
    public static final int RULE_TEMPLATE_HEAD=138;
    public static final int RULE_STRUCTMODSUFFIX=146;
    public static final int RULE_EOL=152;
    public static final int RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL=139;
    public static final int Out=61;
    public static final int RULE_ZWNJ=161;
    public static final int Project=20;
    public static final int EqualsSignEqualsSign=77;
    public static final int Switch=27;
    public static final int RULE_OCTAL_INT=120;
    public static final int VerticalLine=110;
    public static final int PlusSign=94;
    public static final int RULE_INT=148;
    public static final int Get=58;
    public static final int RULE_ML_COMMENT=150;
    public static final int LeftSquareBracket=106;
    public static final int LessThanSignLessThanSign=75;
    public static final int If=83;
    public static final int RULE_REGEX_START=135;
    public static final int Finally=18;
    public static final int Intersection=4;
    public static final int Set=62;
    public static final int RULE_UNICODE_ESCAPE_FRAGMENT=156;
    public static final int In=84;
    public static final int Catch=33;
    public static final int VerticalLineVerticalLine=87;
    public static final int RULE_SCIENTIFIC_INT=123;
    public static final int RULE_TEMPLATE_MIDDLE=141;
    public static final int RULE_INCOMPLETE_ASYNC_ARROW=145;
    public static final int RULE_EXPONENT_PART=114;
    public static final int Union=39;
    public static final int Case=43;
    public static final int RULE_REGEX_CHAR_OR_BRACKET=132;
    public static final int Comma=95;
    public static final int RULE_SL_COMMENT_FRAGMENT=167;
    public static final int Target=28;
    public static final int As=81;
    public static final int HyphenMinus=96;
    public static final int RULE_IDENTIFIER_PART=122;
    public static final int RULE_UNICODE_SPACE_SEPARATOR_FRAGMENT=166;
    public static final int Export=22;
    public static final int LessThanSignEqualsSign=76;
    public static final int CommercialAtCommercialAt=79;
    public static final int Solidus=98;
    public static final int RightCurlyBracket=111;
    public static final int PercentSignEqualsSign=66;
    public static final int RULE_HEX_INT=118;
    public static final int FullStop=97;
    public static final int Constructor=5;
    public static final int Abstract=11;
    public static final int Promisify=8;
    public static final int RULE_SIGNED_INT=124;
    public static final int Default=16;
    public static final int CommercialAt=105;
    public static final int Semicolon=100;
    public static final int RULE_LINE_TERMINATOR_FRAGMENT=129;
    public static final int Type=50;
    public static final int PlusSignPlusSign=70;
    public static final int QuestionMark=104;
    public static final int Else=44;
    public static final int RULE_HEX_DIGIT=155;
    public static final int RULE_UNICODE_CONNECTOR_PUNCTUATION_FRAGMENT=160;
    public static final int Yield=41;
    public static final int ExclamationMarkEqualsSign=65;
    public static final int Interface=9;
    public static final int RULE_TEMPLATE_CONTINUATION=143;
    public static final int HyphenMinusHyphenMinus=72;
    public static final int New=60;
    public static final int Null=47;
    public static final int AmpersandEqualsSign=68;
    public static final int Typeof=29;
    public static final int SolidusEqualsSign=74;
    public static final int True=49;
    public static final int FullStopFullStopFullStop=54;
    public static final int PercentSign=89;
    public static final int RULE_IDENTIFIER_START=147;
    public static final int Implements=6;
    public static final int RULE_WHITESPACE_FRAGMENT=153;
    public static final int Super=37;
    public static final int Async=30;
    public static final int This=42;
    public static final int Try=63;
    public static final int Ampersand=90;
    public static final int AsteriskEqualsSign=69;
    public static final int Void=51;
    public static final int VerticalLineEqualsSign=86;
    public static final int RightSquareBracket=107;
    public static final int RULE_BINARY_INT=119;
    public static final int Protected=10;
    public static final int Const=35;
    public static final int RULE_ACTUAL_REGEX_TAIL=134;
    public static final int For=57;
    public static final int RightParenthesis=92;
    public static final int RULE_UNICODE_COMBINING_MARK_FRAGMENT=158;
    public static final int Public=24;
    public static final int Do=82;
    public static final int RULE_LEGACY_OCTAL_INT=121;
    public static final int RULE_DOUBLE_STRING_CHAR=126;
    public static final int EqualsSignEqualsSignEqualsSign=56;
    public static final int RULE_TEMPLATE_END=142;
    public static final int This_1=48;
    public static final int RULE_NO_LINE_TERMINATOR=144;
    public static final int RULE_DOT_DOT=163;
    public static final int External=14;
    public static final int CircumflexAccentEqualsSign=80;
    public static final int Class=34;
    public static final int Static=26;
    public static final int Debugger=13;
    public static final int RULE_SINGLE_STRING_CHAR=127;
    public static final int LessThanSignLessThanSignEqualsSign=55;
    public static final int RULE_INT_SUFFIX=117;
    public static final int RULE_IDENTIFIER=125;
    public static final int RULE_ML_COMMENT_FRAGMENT=149;
    public static final int RULE_STRING=128;
    public static final int Continue=12;
    public static final int With=52;
    public static final int RULE_SL_COMMENT=151;
    public static final int Function=15;
    public static final int EqualsSign=102;
    public static final int RULE_ZWJ=162;
    public static final int RULE_UNICODE_DIGIT_FRAGMENT=159;
    public static final int AmpersandAmpersand=67;
    public static final int RULE_DOUBLE=116;
    public static final int Instanceof=7;
    public static final int HyphenMinusEqualsSign=73;
    public static final int Colon=99;
    public static final int RULE_BACKSLASH_SEQUENCE=131;
    public static final int EOF=-1;
    public static final int Asterisk=93;
    public static final int PlusSignEqualsSign=71;
    public static final int Return=25;
    public static final int RULE_WS=154;
    public static final int RULE_BOM=165;
    public static final int LeftCurlyBracket=109;
    public static final int Tilde=112;
    public static final int While=40;
    public static final int From=46;
    public static final int RULE_ANY_OTHER=168;
    public static final int CircumflexAccent=108;
    public static final int RULE_UNICODE_LETTER_FRAGMENT=157;
    public static final int RULE_DECIMAL_DIGIT_FRAGMENT=113;
    public static final int Of=85;
    public static final int RULE_DECIMAL_INTEGER_LITERAL_FRAGMENT=115;
    public static final int Let=59;
    public static final int Await=31;


        public InternalN4JSParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalN4JSParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalN4JSParser.tokenNames; }
    public String getGrammarFileName() { return "InternalN4JSParser.g"; }
    protected void setInRegularExpression() {}
    protected void setInTemplateSegment() {}
    protected boolean forcedRewind(int marker) { return true; } // overridden in subtype
    protected void promoteEOL() {} // overridden in subtype
    protected void addASIMessage() {} // overridden in subtype
    protected boolean hasDisallowedEOL() { return false; } // overridden in subtype

     	private N4JSGrammarAccess grammarAccess;

        public InternalN4JSParser(TokenStream input, N4JSGrammarAccess grammarAccess) {
            this(input);
            this.grammarAccess = grammarAccess;
            registerRules(grammarAccess.getGrammar());
        }

        @Override
        protected String getFirstRuleName() {
        	return "Script";
       	}

       	@Override
       	protected N4JSGrammarAccess getGrammarAccess() {
       		return grammarAccess;
       	}
    public final EObject entryRuleScript() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleScript = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getScriptRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleScript=ruleScript();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleScript; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleScript() throws RecognitionException {
        EObject current = null;

        EObject lv_annotations_1_0 = null;

        EObject lv_scriptElements_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getScriptAccess().getScriptAction_0(),
              					current);
              			
            }

            }
            loop1:
            do {
                int alt1=3;
                int LA1_0 = input.LA(1);

                if ( (LA1_0==CommercialAtCommercialAt) ) {
                    alt1=1;
                }
                else if ( ((LA1_0>=Intersection && LA1_0<=Implements)||(LA1_0>=Promisify && LA1_0<=Function)||(LA1_0>=Private && LA1_0<=Break)||(LA1_0>=Class && LA1_0<=This)||(LA1_0>=Enum && LA1_0<=With)||(LA1_0>=For && LA1_0<=Var)||LA1_0==PlusSignPlusSign||LA1_0==HyphenMinusHyphenMinus||LA1_0==SolidusEqualsSign||(LA1_0>=As && LA1_0<=If)||LA1_0==Of||LA1_0==ExclamationMark||LA1_0==LeftParenthesis||LA1_0==PlusSign||LA1_0==HyphenMinus||LA1_0==Solidus||(LA1_0>=Semicolon && LA1_0<=LessThanSign)||(LA1_0>=CommercialAt && LA1_0<=LeftSquareBracket)||LA1_0==LeftCurlyBracket||LA1_0==Tilde||LA1_0==RULE_DOUBLE||(LA1_0>=RULE_HEX_INT && LA1_0<=RULE_LEGACY_OCTAL_INT)||LA1_0==RULE_SCIENTIFIC_INT||LA1_0==RULE_IDENTIFIER||LA1_0==RULE_STRING||(LA1_0>=RULE_TEMPLATE_HEAD && LA1_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA1_0==RULE_INT) ) {
                    alt1=2;
                }


                switch (alt1) {
            	case 1 :
            	    {
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getScriptAccess().getAnnotationsScriptAnnotationParserRuleCall_1_0_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_3);
            	    lv_annotations_1_0=ruleScriptAnnotation();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getScriptRule());
            	      						}
            	      						add(
            	      							current,
            	      							"annotations",
            	      							lv_annotations_1_0,
            	      							"org.eclipse.n4js.N4JS.ScriptAnnotation");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;
            	case 2 :
            	    {
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getScriptAccess().getScriptElementsScriptElementParserRuleCall_1_1_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_3);
            	    lv_scriptElements_2_0=ruleScriptElement();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getScriptRule());
            	      						}
            	      						add(
            	      							current,
            	      							"scriptElements",
            	      							lv_scriptElements_2_0,
            	      							"org.eclipse.n4js.N4JS.ScriptElement");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop1;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleScriptElement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleScriptElement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getScriptElementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleScriptElement=ruleScriptElement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleScriptElement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleScriptElement() throws RecognitionException {
        EObject current = null;

        EObject this_AnnotatedScriptElement_0 = null;

        EObject this_N4ClassDeclaration_1 = null;

        EObject this_N4InterfaceDeclaration_2 = null;

        EObject this_N4EnumDeclaration_3 = null;

        EObject this_ImportDeclaration_4 = null;

        EObject this_ExportDeclaration_5 = null;

        EObject this_RootStatement_6 = null;



        	enterRule();

        try {
            {
            int alt2=7;
            alt2 = dfa2.predict(input);
            switch (alt2) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getScriptElementAccess().getAnnotatedScriptElementParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_AnnotatedScriptElement_0=ruleAnnotatedScriptElement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_AnnotatedScriptElement_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getScriptElementAccess().getN4ClassDeclarationParserRuleCall_1());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_N4ClassDeclaration_1=ruleN4ClassDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_N4ClassDeclaration_1;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getScriptElementAccess().getN4InterfaceDeclarationParserRuleCall_2());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_N4InterfaceDeclaration_2=ruleN4InterfaceDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_N4InterfaceDeclaration_2;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getScriptElementAccess().getN4EnumDeclarationParserRuleCall_3());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_N4EnumDeclaration_3=ruleN4EnumDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_N4EnumDeclaration_3;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getScriptElementAccess().getImportDeclarationParserRuleCall_4());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_ImportDeclaration_4=ruleImportDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_ImportDeclaration_4;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getScriptElementAccess().getExportDeclarationParserRuleCall_5());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ExportDeclaration_5=ruleExportDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ExportDeclaration_5;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 7 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getScriptElementAccess().getRootStatementParserRuleCall_6());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_RootStatement_6=ruleRootStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_RootStatement_6;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleAnnotatedScriptElement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleAnnotatedScriptElement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getAnnotatedScriptElementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleAnnotatedScriptElement=ruleAnnotatedScriptElement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleAnnotatedScriptElement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleAnnotatedScriptElement() throws RecognitionException {
        EObject current = null;

        Token otherlv_11=null;
        Token otherlv_19=null;
        Token otherlv_28=null;
        Token otherlv_31=null;
        Token otherlv_33=null;
        Token otherlv_35=null;
        EObject this_AnnotationList_0 = null;

        EObject this_ExportDeclarationImpl_2 = null;

        EObject this_ImportDeclarationImpl_4 = null;

        Enumerator lv_declaredModifiers_6_0 = null;

        EObject this_AsyncNoTrailingLineBreak_7 = null;

        EObject this_FunctionImpl_8 = null;

        Enumerator lv_declaredModifiers_10_0 = null;

        AntlrDatatypeRuleToken lv_typingStrategy_12_0 = null;

        AntlrDatatypeRuleToken lv_name_13_0 = null;

        EObject this_VersionDeclaration_14 = null;

        EObject this_TypeVariables_15 = null;

        EObject this_ClassExtendsImplements_16 = null;

        Enumerator lv_declaredModifiers_18_0 = null;

        AntlrDatatypeRuleToken lv_typingStrategy_20_0 = null;

        AntlrDatatypeRuleToken lv_name_21_0 = null;

        EObject this_VersionDeclaration_22 = null;

        EObject this_TypeVariables_23 = null;

        EObject this_InterfaceExtendsList_24 = null;

        EObject this_Members_25 = null;

        Enumerator lv_declaredModifiers_27_0 = null;

        AntlrDatatypeRuleToken lv_name_29_0 = null;

        EObject this_VersionDeclaration_30 = null;

        EObject lv_literals_32_0 = null;

        EObject lv_literals_34_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getAnnotationListParserRuleCall_0());
              			
            }
            pushFollow(FOLLOW_4);
            this_AnnotationList_0=ruleAnnotationList();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				current = this_AnnotationList_0;
              				afterParserOrEnumRuleCall();
              			
            }

            }
            int alt18=5;
            alt18 = dfa18.predict(input);
            switch (alt18) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getAnnotatedScriptElementAccess().getExportDeclarationAnnotationListAction_1_0_0(),
                      							current);
                      					
                    }

                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getExportDeclarationImplParserRuleCall_1_0_1());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_ExportDeclarationImpl_2=ruleExportDeclarationImpl(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_ExportDeclarationImpl_2;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getAnnotatedScriptElementAccess().getImportDeclarationAnnotationListAction_1_1_0(),
                      							current);
                      					
                    }

                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getImportDeclarationImplParserRuleCall_1_1_1());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_ImportDeclarationImpl_4=ruleImportDeclarationImpl(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_ImportDeclarationImpl_4;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getAnnotatedScriptElementAccess().getFunctionDeclarationAnnotationListAction_1_2_0(),
                      							current);
                      					
                    }

                    }
                    {
                    {
                    loop3:
                    do {
                        int alt3=2;
                        int LA3_0 = input.LA(1);

                        if ( ((LA3_0>=Protected && LA3_0<=Abstract)||LA3_0==External||(LA3_0>=Private && LA3_0<=Project)||LA3_0==Public||LA3_0==Static||LA3_0==Const) ) {
                            alt3=1;
                        }


                        switch (alt3) {
                    	case 1 :
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      									newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_2_1_0_0_0());
                    	      								
                    	    }
                    	    pushFollow(FOLLOW_5);
                    	    lv_declaredModifiers_6_0=ruleN4Modifier();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      									if (current==null) {
                    	      										current = createModelElementForParent(grammarAccess.getAnnotatedScriptElementRule());
                    	      									}
                    	      									add(
                    	      										current,
                    	      										"declaredModifiers",
                    	      										lv_declaredModifiers_6_0,
                    	      										"org.eclipse.n4js.N4JS.N4Modifier");
                    	      									afterParserOrEnumRuleCall();
                    	      								
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop3;
                        }
                    } while (true);

                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                      							}
                      							newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_2_1_0_1());
                      						
                    }
                    pushFollow(FOLLOW_5);
                    this_AsyncNoTrailingLineBreak_7=ruleAsyncNoTrailingLineBreak(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							current = this_AsyncNoTrailingLineBreak_7;
                      							afterParserOrEnumRuleCall();
                      						
                    }
                    {
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                      								}
                      								newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getFunctionImplParserRuleCall_1_2_1_0_2());
                      							
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionImpl_8=ruleFunctionImpl(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								current = this_FunctionImpl_8;
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }


                    }


                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    int alt14=2;
                    alt14 = dfa14.predict(input);
                    switch (alt14) {
                        case 1 :
                            {
                            {
                            {
                            if ( state.backtracking==0 ) {

                              								current = forceCreateModelElementAndSet(
                              									grammarAccess.getAnnotatedScriptElementAccess().getN4ClassDeclarationAnnotationListAction_1_3_0_0_0(),
                              									current);
                              							
                            }

                            }
                            loop4:
                            do {
                                int alt4=2;
                                int LA4_0 = input.LA(1);

                                if ( ((LA4_0>=Protected && LA4_0<=Abstract)||LA4_0==External||(LA4_0>=Private && LA4_0<=Project)||LA4_0==Public||LA4_0==Static||LA4_0==Const) ) {
                                    alt4=1;
                                }


                                switch (alt4) {
                            	case 1 :
                            	    {
                            	    {
                            	    if ( state.backtracking==0 ) {

                            	      									newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_3_0_0_1_0());
                            	      								
                            	    }
                            	    pushFollow(FOLLOW_6);
                            	    lv_declaredModifiers_10_0=ruleN4Modifier();

                            	    state._fsp--;
                            	    if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      									if (current==null) {
                            	      										current = createModelElementForParent(grammarAccess.getAnnotatedScriptElementRule());
                            	      									}
                            	      									add(
                            	      										current,
                            	      										"declaredModifiers",
                            	      										lv_declaredModifiers_10_0,
                            	      										"org.eclipse.n4js.N4JS.N4Modifier");
                            	      									afterParserOrEnumRuleCall();
                            	      								
                            	    }

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop4;
                                }
                            } while (true);

                            otherlv_11=(Token)match(input,Class,FOLLOW_7); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(otherlv_11, grammarAccess.getAnnotatedScriptElementAccess().getClassKeyword_1_3_0_0_2());
                              						
                            }
                            int alt5=2;
                            int LA5_0 = input.LA(1);

                            if ( (LA5_0==Tilde) ) {
                                alt5=1;
                            }
                            switch (alt5) {
                                case 1 :
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      									newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getTypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_0_3_0());
                                      								
                                    }
                                    pushFollow(FOLLOW_8);
                                    lv_typingStrategy_12_0=ruleTypingStrategyDefSiteOperator();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									if (current==null) {
                                      										current = createModelElementForParent(grammarAccess.getAnnotatedScriptElementRule());
                                      									}
                                      									set(
                                      										current,
                                      										"typingStrategy",
                                      										lv_typingStrategy_12_0,
                                      										"org.eclipse.n4js.ts.TypeExpressions.TypingStrategyDefSiteOperator");
                                      									afterParserOrEnumRuleCall();
                                      								
                                    }

                                    }


                                    }
                                    break;

                            }
                            {
                            {
                            if ( state.backtracking==0 ) {

                              									newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getNameBindingIdentifierParserRuleCall_1_3_0_0_4_0());
                              								
                            }
                            pushFollow(FOLLOW_9);
                            lv_name_13_0=ruleBindingIdentifier();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              									if (current==null) {
                              										current = createModelElementForParent(grammarAccess.getAnnotatedScriptElementRule());
                              									}
                              									set(
                              										current,
                              										"name",
                              										lv_name_13_0,
                              										"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                              									afterParserOrEnumRuleCall();
                              								
                            }

                            }


                            }
                            int alt6=2;
                            int LA6_0 = input.LA(1);

                            if ( (LA6_0==RULE_VERSION) ) {
                                alt6=1;
                            }
                            switch (alt6) {
                                case 1 :
                                    {
                                    if ( state.backtracking==0 ) {

                                      								if (current==null) {
                                      									current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                                      								}
                                      								newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_3_0_0_5());
                                      							
                                    }
                                    pushFollow(FOLLOW_9);
                                    this_VersionDeclaration_14=ruleVersionDeclaration(current);

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      								current = this_VersionDeclaration_14;
                                      								afterParserOrEnumRuleCall();
                                      							
                                    }

                                    }
                                    break;

                            }
                            int alt7=2;
                            int LA7_0 = input.LA(1);

                            if ( (LA7_0==LessThanSign) ) {
                                alt7=1;
                            }
                            switch (alt7) {
                                case 1 :
                                    {
                                    if ( state.backtracking==0 ) {

                                      								if (current==null) {
                                      									current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                                      								}
                                      								newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getTypeVariablesParserRuleCall_1_3_0_0_6());
                                      							
                                    }
                                    pushFollow(FOLLOW_9);
                                    this_TypeVariables_15=ruleTypeVariables(current);

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      								current = this_TypeVariables_15;
                                      								afterParserOrEnumRuleCall();
                                      							
                                    }

                                    }
                                    break;

                            }
                            int alt8=2;
                            int LA8_0 = input.LA(1);

                            if ( (LA8_0==Implements||LA8_0==Extends) ) {
                                alt8=1;
                            }
                            switch (alt8) {
                                case 1 :
                                    {
                                    if ( state.backtracking==0 ) {

                                      								if (current==null) {
                                      									current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                                      								}
                                      								newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getClassExtendsImplementsParserRuleCall_1_3_0_0_7());
                                      							
                                    }
                                    pushFollow(FOLLOW_9);
                                    this_ClassExtendsImplements_16=ruleClassExtendsImplements(current);

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      								current = this_ClassExtendsImplements_16;
                                      								afterParserOrEnumRuleCall();
                                      							
                                    }

                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            {
                            if ( state.backtracking==0 ) {

                              								current = forceCreateModelElementAndSet(
                              									grammarAccess.getAnnotatedScriptElementAccess().getN4InterfaceDeclarationAnnotationListAction_1_3_0_1_0(),
                              									current);
                              							
                            }

                            }
                            loop9:
                            do {
                                int alt9=2;
                                int LA9_0 = input.LA(1);

                                if ( ((LA9_0>=Protected && LA9_0<=Abstract)||LA9_0==External||(LA9_0>=Private && LA9_0<=Project)||LA9_0==Public||LA9_0==Static||LA9_0==Const) ) {
                                    alt9=1;
                                }


                                switch (alt9) {
                            	case 1 :
                            	    {
                            	    {
                            	    if ( state.backtracking==0 ) {

                            	      									newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_3_0_1_1_0());
                            	      								
                            	    }
                            	    pushFollow(FOLLOW_10);
                            	    lv_declaredModifiers_18_0=ruleN4Modifier();

                            	    state._fsp--;
                            	    if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      									if (current==null) {
                            	      										current = createModelElementForParent(grammarAccess.getAnnotatedScriptElementRule());
                            	      									}
                            	      									add(
                            	      										current,
                            	      										"declaredModifiers",
                            	      										lv_declaredModifiers_18_0,
                            	      										"org.eclipse.n4js.N4JS.N4Modifier");
                            	      									afterParserOrEnumRuleCall();
                            	      								
                            	    }

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop9;
                                }
                            } while (true);

                            otherlv_19=(Token)match(input,Interface,FOLLOW_7); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(otherlv_19, grammarAccess.getAnnotatedScriptElementAccess().getInterfaceKeyword_1_3_0_1_2());
                              						
                            }
                            int alt10=2;
                            int LA10_0 = input.LA(1);

                            if ( (LA10_0==Tilde) ) {
                                alt10=1;
                            }
                            switch (alt10) {
                                case 1 :
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      									newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getTypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_3_0_1_3_0());
                                      								
                                    }
                                    pushFollow(FOLLOW_8);
                                    lv_typingStrategy_20_0=ruleTypingStrategyDefSiteOperator();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									if (current==null) {
                                      										current = createModelElementForParent(grammarAccess.getAnnotatedScriptElementRule());
                                      									}
                                      									set(
                                      										current,
                                      										"typingStrategy",
                                      										lv_typingStrategy_20_0,
                                      										"org.eclipse.n4js.ts.TypeExpressions.TypingStrategyDefSiteOperator");
                                      									afterParserOrEnumRuleCall();
                                      								
                                    }

                                    }


                                    }
                                    break;

                            }
                            {
                            {
                            if ( state.backtracking==0 ) {

                              									newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getNameBindingIdentifierParserRuleCall_1_3_0_1_4_0());
                              								
                            }
                            pushFollow(FOLLOW_9);
                            lv_name_21_0=ruleBindingIdentifier();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              									if (current==null) {
                              										current = createModelElementForParent(grammarAccess.getAnnotatedScriptElementRule());
                              									}
                              									set(
                              										current,
                              										"name",
                              										lv_name_21_0,
                              										"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                              									afterParserOrEnumRuleCall();
                              								
                            }

                            }


                            }
                            int alt11=2;
                            int LA11_0 = input.LA(1);

                            if ( (LA11_0==RULE_VERSION) ) {
                                alt11=1;
                            }
                            switch (alt11) {
                                case 1 :
                                    {
                                    if ( state.backtracking==0 ) {

                                      								if (current==null) {
                                      									current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                                      								}
                                      								newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_3_0_1_5());
                                      							
                                    }
                                    pushFollow(FOLLOW_9);
                                    this_VersionDeclaration_22=ruleVersionDeclaration(current);

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      								current = this_VersionDeclaration_22;
                                      								afterParserOrEnumRuleCall();
                                      							
                                    }

                                    }
                                    break;

                            }
                            int alt12=2;
                            int LA12_0 = input.LA(1);

                            if ( (LA12_0==LessThanSign) ) {
                                alt12=1;
                            }
                            switch (alt12) {
                                case 1 :
                                    {
                                    if ( state.backtracking==0 ) {

                                      								if (current==null) {
                                      									current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                                      								}
                                      								newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getTypeVariablesParserRuleCall_1_3_0_1_6());
                                      							
                                    }
                                    pushFollow(FOLLOW_9);
                                    this_TypeVariables_23=ruleTypeVariables(current);

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      								current = this_TypeVariables_23;
                                      								afterParserOrEnumRuleCall();
                                      							
                                    }

                                    }
                                    break;

                            }
                            int alt13=2;
                            int LA13_0 = input.LA(1);

                            if ( (LA13_0==Implements||LA13_0==Extends) ) {
                                alt13=1;
                            }
                            switch (alt13) {
                                case 1 :
                                    {
                                    if ( state.backtracking==0 ) {

                                      								if (current==null) {
                                      									current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                                      								}
                                      								newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getInterfaceExtendsListParserRuleCall_1_3_0_1_7());
                                      							
                                    }
                                    pushFollow(FOLLOW_9);
                                    this_InterfaceExtendsList_24=ruleInterfaceExtendsList(current);

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      								current = this_InterfaceExtendsList_24;
                                      								afterParserOrEnumRuleCall();
                                      							
                                    }

                                    }
                                    break;

                            }


                            }


                            }
                            break;

                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getMembersParserRuleCall_1_3_1());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_Members_25=ruleMembers(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_Members_25;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getAnnotatedScriptElementAccess().getN4EnumDeclarationAnnotationListAction_1_4_0(),
                      							current);
                      					
                    }

                    }
                    loop15:
                    do {
                        int alt15=2;
                        int LA15_0 = input.LA(1);

                        if ( ((LA15_0>=Protected && LA15_0<=Abstract)||LA15_0==External||(LA15_0>=Private && LA15_0<=Project)||LA15_0==Public||LA15_0==Static||LA15_0==Const) ) {
                            alt15=1;
                        }


                        switch (alt15) {
                    	case 1 :
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_4_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_11);
                    	    lv_declaredModifiers_27_0=ruleN4Modifier();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getAnnotatedScriptElementRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"declaredModifiers",
                    	      								lv_declaredModifiers_27_0,
                    	      								"org.eclipse.n4js.N4JS.N4Modifier");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop15;
                        }
                    } while (true);

                    otherlv_28=(Token)match(input,Enum,FOLLOW_8); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_28, grammarAccess.getAnnotatedScriptElementAccess().getEnumKeyword_1_4_2());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getNameBindingIdentifierParserRuleCall_1_4_3_0());
                      						
                    }
                    pushFollow(FOLLOW_12);
                    lv_name_29_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getAnnotatedScriptElementRule());
                      							}
                      							set(
                      								current,
                      								"name",
                      								lv_name_29_0,
                      								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }
                    int alt16=2;
                    int LA16_0 = input.LA(1);

                    if ( (LA16_0==RULE_VERSION) ) {
                        alt16=1;
                    }
                    switch (alt16) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              						if (current==null) {
                              							current = createModelElement(grammarAccess.getAnnotatedScriptElementRule());
                              						}
                              						newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getVersionDeclarationParserRuleCall_1_4_4());
                              					
                            }
                            pushFollow(FOLLOW_13);
                            this_VersionDeclaration_30=ruleVersionDeclaration(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              						current = this_VersionDeclaration_30;
                              						afterParserOrEnumRuleCall();
                              					
                            }

                            }
                            break;

                    }

                    otherlv_31=(Token)match(input,LeftCurlyBracket,FOLLOW_14); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_31, grammarAccess.getAnnotatedScriptElementAccess().getLeftCurlyBracketKeyword_1_4_5());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getLiteralsN4EnumLiteralParserRuleCall_1_4_6_0());
                      						
                    }
                    pushFollow(FOLLOW_15);
                    lv_literals_32_0=ruleN4EnumLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getAnnotatedScriptElementRule());
                      							}
                      							add(
                      								current,
                      								"literals",
                      								lv_literals_32_0,
                      								"org.eclipse.n4js.N4JS.N4EnumLiteral");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }
                    loop17:
                    do {
                        int alt17=2;
                        int LA17_0 = input.LA(1);

                        if ( (LA17_0==Comma) ) {
                            alt17=1;
                        }


                        switch (alt17) {
                    	case 1 :
                    	    {
                    	    otherlv_33=(Token)match(input,Comma,FOLLOW_14); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      						newLeafNode(otherlv_33, grammarAccess.getAnnotatedScriptElementAccess().getCommaKeyword_1_4_7_0());
                    	      					
                    	    }
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      								newCompositeNode(grammarAccess.getAnnotatedScriptElementAccess().getLiteralsN4EnumLiteralParserRuleCall_1_4_7_1_0());
                    	      							
                    	    }
                    	    pushFollow(FOLLOW_15);
                    	    lv_literals_34_0=ruleN4EnumLiteral();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      								if (current==null) {
                    	      									current = createModelElementForParent(grammarAccess.getAnnotatedScriptElementRule());
                    	      								}
                    	      								add(
                    	      									current,
                    	      									"literals",
                    	      									lv_literals_34_0,
                    	      									"org.eclipse.n4js.N4JS.N4EnumLiteral");
                    	      								afterParserOrEnumRuleCall();
                    	      							
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop17;
                        }
                    } while (true);

                    otherlv_35=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_35, grammarAccess.getAnnotatedScriptElementAccess().getRightCurlyBracketKeyword_1_4_8());
                      				
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleExportDeclaration() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleExportDeclaration = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getExportDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleExportDeclaration=ruleExportDeclaration();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleExportDeclaration; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExportDeclaration() throws RecognitionException {
        EObject current = null;

        EObject this_ExportDeclarationImpl_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getExportDeclarationAccess().getExportDeclarationAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getExportDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getExportDeclarationAccess().getExportDeclarationImplParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_ExportDeclarationImpl_1=ruleExportDeclarationImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_ExportDeclarationImpl_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExportDeclarationImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_0=null;
        Token lv_wildcardExport_1_0=null;
        Token lv_defaultExport_8_0=null;
        EObject this_ExportFromClause_2 = null;

        EObject this_ExportClause_4 = null;

        EObject this_ExportFromClause_5 = null;

        EObject lv_exportedElement_7_0 = null;

        EObject lv_exportedElement_9_0 = null;

        EObject lv_defaultExportedExpression_10_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Export,FOLLOW_16); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getExportDeclarationImplAccess().getExportKeyword_0());
              		
            }
            int alt21=4;
            switch ( input.LA(1) ) {
            case Asterisk:
                {
                alt21=1;
                }
                break;
            case LeftCurlyBracket:
                {
                alt21=2;
                }
                break;
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Function:
            case Private:
            case Project:
            case Public:
            case Static:
            case Async:
            case Class:
            case Const:
            case Enum:
            case Let:
            case Var:
            case CommercialAt:
                {
                alt21=3;
                }
                break;
            case Default:
                {
                alt21=4;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 21, 0, input);

                throw nvae;
            }

            switch (alt21) {
                case 1 :
                    {
                    {
                    {
                    {
                    lv_wildcardExport_1_0=(Token)match(input,Asterisk,FOLLOW_17); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(lv_wildcardExport_1_0, grammarAccess.getExportDeclarationImplAccess().getWildcardExportAsteriskKeyword_1_0_0_0());
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getExportDeclarationImplRule());
                      							}
                      							setWithLastConsumed(current, "wildcardExport", true, "*");
                      						
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getExportDeclarationImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getExportDeclarationImplAccess().getExportFromClauseParserRuleCall_1_0_1());
                      				
                    }
                    pushFollow(FOLLOW_18);
                    this_ExportFromClause_2=ruleExportFromClause(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_ExportFromClause_2;
                      					afterParserOrEnumRuleCall();
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_0_2());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    ruleSemi();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getExportDeclarationImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getExportDeclarationImplAccess().getExportClauseParserRuleCall_1_1_0());
                      				
                    }
                    pushFollow(FOLLOW_19);
                    this_ExportClause_4=ruleExportClause(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_ExportClause_4;
                      					afterParserOrEnumRuleCall();
                      				
                    }
                    int alt19=2;
                    int LA19_0 = input.LA(1);

                    if ( (LA19_0==From) && (synpred9_InternalN4JSParser())) {
                        alt19=1;
                    }
                    switch (alt19) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              						if (current==null) {
                              							current = createModelElement(grammarAccess.getExportDeclarationImplRule());
                              						}
                              						newCompositeNode(grammarAccess.getExportDeclarationImplAccess().getExportFromClauseParserRuleCall_1_1_1());
                              					
                            }
                            pushFollow(FOLLOW_18);
                            this_ExportFromClause_5=ruleExportFromClause(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              						current = this_ExportFromClause_5;
                              						afterParserOrEnumRuleCall();
                              					
                            }

                            }
                            break;

                    }

                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_1_2());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    ruleSemi();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getExportDeclarationImplAccess().getExportedElementExportableElementParserRuleCall_1_2_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_exportedElement_7_0=ruleExportableElement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getExportDeclarationImplRule());
                      						}
                      						set(
                      							current,
                      							"exportedElement",
                      							lv_exportedElement_7_0,
                      							"org.eclipse.n4js.N4JS.ExportableElement");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    {
                    {
                    lv_defaultExport_8_0=(Token)match(input,Default,FOLLOW_20); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(lv_defaultExport_8_0, grammarAccess.getExportDeclarationImplAccess().getDefaultExportDefaultKeyword_1_3_0_0());
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getExportDeclarationImplRule());
                      							}
                      							setWithLastConsumed(current, "defaultExport", true, "default");
                      						
                    }

                    }


                    }
                    int alt20=2;
                    alt20 = dfa20.predict(input);
                    switch (alt20) {
                        case 1 :
                            {
                            {
                            {
                            if ( state.backtracking==0 ) {

                              								newCompositeNode(grammarAccess.getExportDeclarationImplAccess().getExportedElementExportableElementParserRuleCall_1_3_1_0_0());
                              							
                            }
                            pushFollow(FOLLOW_2);
                            lv_exportedElement_9_0=ruleExportableElement();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElementForParent(grammarAccess.getExportDeclarationImplRule());
                              								}
                              								set(
                              									current,
                              									"exportedElement",
                              									lv_exportedElement_9_0,
                              									"org.eclipse.n4js.N4JS.ExportableElement");
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            {
                            {
                            if ( state.backtracking==0 ) {

                              									newCompositeNode(grammarAccess.getExportDeclarationImplAccess().getDefaultExportedExpressionAssignmentExpressionParserRuleCall_1_3_1_1_0_0());
                              								
                            }
                            pushFollow(FOLLOW_18);
                            lv_defaultExportedExpression_10_0=norm1_AssignmentExpression();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              									if (current==null) {
                              										current = createModelElementForParent(grammarAccess.getExportDeclarationImplRule());
                              									}
                              									set(
                              										current,
                              										"defaultExportedExpression",
                              										lv_defaultExportedExpression_10_0,
                              										"org.eclipse.n4js.N4JS.AssignmentExpression");
                              									afterParserOrEnumRuleCall();
                              								
                            }

                            }


                            }

                            if ( state.backtracking==0 ) {

                              							newCompositeNode(grammarAccess.getExportDeclarationImplAccess().getSemiParserRuleCall_1_3_1_1_1());
                              						
                            }
                            pushFollow(FOLLOW_2);
                            ruleSemi();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							afterParserOrEnumRuleCall();
                              						
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExportFromClause(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_0=null;


        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,From,FOLLOW_21); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getExportFromClauseAccess().getFromKeyword_0());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getExportFromClauseRule());
              					}
              				
            }
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExportFromClauseAccess().getReexportedFromTModuleCrossReference_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            ruleModuleSpecifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExportClause(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        Token otherlv_5=null;
        EObject lv_namedExports_1_0 = null;

        EObject lv_namedExports_3_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,LeftCurlyBracket,FOLLOW_22); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getExportClauseAccess().getLeftCurlyBracketKeyword_0());
              		
            }
            int alt24=2;
            int LA24_0 = input.LA(1);

            if ( ((LA24_0>=Intersection && LA24_0<=Implements)||(LA24_0>=Promisify && LA24_0<=Abstract)||LA24_0==External||(LA24_0>=Private && LA24_0<=Project)||LA24_0==Public||LA24_0==Static||LA24_0==Target||(LA24_0>=Async && LA24_0<=Await)||LA24_0==Union||(LA24_0>=Yield && LA24_0<=This)||LA24_0==From||LA24_0==Type||(LA24_0>=Get && LA24_0<=Let)||(LA24_0>=Out && LA24_0<=Set)||LA24_0==As||LA24_0==Of||LA24_0==RULE_IDENTIFIER) ) {
                alt24=1;
            }
            switch (alt24) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getExportClauseAccess().getNamedExportsExportSpecifierParserRuleCall_1_0_0());
                      					
                    }
                    pushFollow(FOLLOW_15);
                    lv_namedExports_1_0=ruleExportSpecifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getExportClauseRule());
                      						}
                      						add(
                      							current,
                      							"namedExports",
                      							lv_namedExports_1_0,
                      							"org.eclipse.n4js.N4JS.ExportSpecifier");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }
                    loop22:
                    do {
                        int alt22=2;
                        int LA22_0 = input.LA(1);

                        if ( (LA22_0==Comma) ) {
                            int LA22_1 = input.LA(2);

                            if ( ((LA22_1>=Intersection && LA22_1<=Implements)||(LA22_1>=Promisify && LA22_1<=Abstract)||LA22_1==External||(LA22_1>=Private && LA22_1<=Project)||LA22_1==Public||LA22_1==Static||LA22_1==Target||(LA22_1>=Async && LA22_1<=Await)||LA22_1==Union||(LA22_1>=Yield && LA22_1<=This)||LA22_1==From||LA22_1==Type||(LA22_1>=Get && LA22_1<=Let)||(LA22_1>=Out && LA22_1<=Set)||LA22_1==As||LA22_1==Of||LA22_1==RULE_IDENTIFIER) ) {
                                alt22=1;
                            }


                        }


                        switch (alt22) {
                    	case 1 :
                    	    {
                    	    otherlv_2=(Token)match(input,Comma,FOLLOW_8); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_2, grammarAccess.getExportClauseAccess().getCommaKeyword_1_1_0());
                    	      				
                    	    }
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getExportClauseAccess().getNamedExportsExportSpecifierParserRuleCall_1_1_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_15);
                    	    lv_namedExports_3_0=ruleExportSpecifier();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getExportClauseRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"namedExports",
                    	      								lv_namedExports_3_0,
                    	      								"org.eclipse.n4js.N4JS.ExportSpecifier");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop22;
                        }
                    } while (true);
                    int alt23=2;
                    int LA23_0 = input.LA(1);

                    if ( (LA23_0==Comma) ) {
                        alt23=1;
                    }
                    switch (alt23) {
                        case 1 :
                            {
                            otherlv_4=(Token)match(input,Comma,FOLLOW_23); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					newLeafNode(otherlv_4, grammarAccess.getExportClauseAccess().getCommaKeyword_1_2());
                              				
                            }

                            }
                            break;

                    }


                    }
                    break;

            }

            otherlv_5=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_5, grammarAccess.getExportClauseAccess().getRightCurlyBracketKeyword_2());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleExportSpecifier() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleExportSpecifier = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getExportSpecifierRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleExportSpecifier=ruleExportSpecifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleExportSpecifier; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExportSpecifier() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_element_0_0 = null;

        AntlrDatatypeRuleToken lv_alias_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExportSpecifierAccess().getElementIdentifierRefParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_24);
            lv_element_0_0=ruleIdentifierRef();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getExportSpecifierRule());
              					}
              					set(
              						current,
              						"element",
              						lv_element_0_0,
              						"org.eclipse.n4js.N4JS.IdentifierRef");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            int alt25=2;
            int LA25_0 = input.LA(1);

            if ( (LA25_0==As) ) {
                alt25=1;
            }
            switch (alt25) {
                case 1 :
                    {
                    otherlv_1=(Token)match(input,As,FOLLOW_14); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_1, grammarAccess.getExportSpecifierAccess().getAsKeyword_1_0());
                      			
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getExportSpecifierAccess().getAliasIdentifierNameParserRuleCall_1_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_alias_2_0=ruleIdentifierName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getExportSpecifierRule());
                      						}
                      						set(
                      							current,
                      							"alias",
                      							lv_alias_2_0,
                      							"org.eclipse.n4js.ts.TypeExpressions.IdentifierName");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleExportableElement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleExportableElement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getExportableElementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleExportableElement=ruleExportableElement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleExportableElement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExportableElement() throws RecognitionException {
        EObject current = null;

        EObject this_AnnotatedExportableElement_0 = null;

        EObject this_N4ClassDeclaration_1 = null;

        EObject this_N4InterfaceDeclaration_2 = null;

        EObject this_N4EnumDeclaration_3 = null;

        EObject this_FunctionDeclaration_4 = null;

        EObject this_ExportedVariableStatement_5 = null;



        	enterRule();

        try {
            {
            int alt26=6;
            alt26 = dfa26.predict(input);
            switch (alt26) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getExportableElementAccess().getAnnotatedExportableElementParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_AnnotatedExportableElement_0=ruleAnnotatedExportableElement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_AnnotatedExportableElement_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getExportableElementAccess().getN4ClassDeclarationParserRuleCall_1());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_N4ClassDeclaration_1=ruleN4ClassDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_N4ClassDeclaration_1;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getExportableElementAccess().getN4InterfaceDeclarationParserRuleCall_2());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_N4InterfaceDeclaration_2=ruleN4InterfaceDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_N4InterfaceDeclaration_2;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getExportableElementAccess().getN4EnumDeclarationParserRuleCall_3());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_N4EnumDeclaration_3=ruleN4EnumDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_N4EnumDeclaration_3;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getExportableElementAccess().getFunctionDeclarationParserRuleCall_4());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionDeclaration_4=ruleFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_FunctionDeclaration_4;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getExportableElementAccess().getExportedVariableStatementParserRuleCall_5());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ExportedVariableStatement_5=ruleExportedVariableStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ExportedVariableStatement_5;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleAnnotatedExportableElement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleAnnotatedExportableElement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getAnnotatedExportableElementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleAnnotatedExportableElement=ruleAnnotatedExportableElement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleAnnotatedExportableElement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleAnnotatedExportableElement() throws RecognitionException {
        EObject current = null;

        Token otherlv_9=null;
        Token otherlv_14=null;
        Token otherlv_21=null;
        Token otherlv_29=null;
        Token otherlv_31=null;
        Token otherlv_33=null;
        Token otherlv_35=null;
        EObject this_AnnotationList_0 = null;

        Enumerator lv_declaredModifiers_2_0 = null;

        EObject this_AsyncNoTrailingLineBreak_3 = null;

        EObject this_FunctionImpl_4 = null;

        Enumerator lv_declaredModifiers_6_0 = null;

        Enumerator lv_varStmtKeyword_7_0 = null;

        EObject lv_varDeclsOrBindings_8_0 = null;

        EObject lv_varDeclsOrBindings_10_0 = null;

        Enumerator lv_declaredModifiers_13_0 = null;

        AntlrDatatypeRuleToken lv_typingStrategy_15_0 = null;

        AntlrDatatypeRuleToken lv_name_16_0 = null;

        EObject this_TypeVariables_17 = null;

        EObject this_ClassExtendsImplements_18 = null;

        Enumerator lv_declaredModifiers_20_0 = null;

        AntlrDatatypeRuleToken lv_typingStrategy_22_0 = null;

        AntlrDatatypeRuleToken lv_name_23_0 = null;

        EObject this_TypeVariables_24 = null;

        EObject this_InterfaceExtendsList_25 = null;

        EObject this_Members_26 = null;

        Enumerator lv_declaredModifiers_28_0 = null;

        AntlrDatatypeRuleToken lv_name_30_0 = null;

        EObject lv_literals_32_0 = null;

        EObject lv_literals_34_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getAnnotationListParserRuleCall_0());
              			
            }
            pushFollow(FOLLOW_25);
            this_AnnotationList_0=ruleAnnotationList();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				current = this_AnnotationList_0;
              				afterParserOrEnumRuleCall();
              			
            }

            }
            int alt41=4;
            alt41 = dfa41.predict(input);
            switch (alt41) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getAnnotatedExportableElementAccess().getFunctionDeclarationAnnotationListAction_1_0_0(),
                      							current);
                      					
                    }

                    }
                    loop27:
                    do {
                        int alt27=2;
                        int LA27_0 = input.LA(1);

                        if ( ((LA27_0>=Protected && LA27_0<=Abstract)||LA27_0==External||(LA27_0>=Private && LA27_0<=Project)||LA27_0==Public||LA27_0==Static||LA27_0==Const) ) {
                            alt27=1;
                        }


                        switch (alt27) {
                    	case 1 :
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_0_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_5);
                    	    lv_declaredModifiers_2_0=ruleN4Modifier();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"declaredModifiers",
                    	      								lv_declaredModifiers_2_0,
                    	      								"org.eclipse.n4js.N4JS.N4Modifier");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop27;
                        }
                    } while (true);

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedExportableElementRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_0_2());
                      				
                    }
                    pushFollow(FOLLOW_5);
                    this_AsyncNoTrailingLineBreak_3=ruleAsyncNoTrailingLineBreak(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_AsyncNoTrailingLineBreak_3;
                      					afterParserOrEnumRuleCall();
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedExportableElementRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getFunctionImplParserRuleCall_1_0_3());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionImpl_4=ruleFunctionImpl(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionImpl_4;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getAnnotatedExportableElementAccess().getExportedVariableStatementAnnotationListAction_1_1_0(),
                      							current);
                      					
                    }

                    }
                    loop28:
                    do {
                        int alt28=2;
                        alt28 = dfa28.predict(input);
                        switch (alt28) {
                    	case 1 :
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_1_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_26);
                    	    lv_declaredModifiers_6_0=ruleN4Modifier();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"declaredModifiers",
                    	      								lv_declaredModifiers_6_0,
                    	      								"org.eclipse.n4js.N4JS.N4Modifier");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop28;
                        }
                    } while (true);
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getVarStmtKeywordVariableStatementKeywordEnumRuleCall_1_1_2_0());
                      						
                    }
                    pushFollow(FOLLOW_27);
                    lv_varStmtKeyword_7_0=ruleVariableStatementKeyword();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                      							}
                      							set(
                      								current,
                      								"varStmtKeyword",
                      								lv_varStmtKeyword_7_0,
                      								"org.eclipse.n4js.N4JS.VariableStatementKeyword");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getVarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_3_0());
                      						
                    }
                    pushFollow(FOLLOW_28);
                    lv_varDeclsOrBindings_8_0=ruleExportedVariableDeclarationOrBinding();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                      							}
                      							add(
                      								current,
                      								"varDeclsOrBindings",
                      								lv_varDeclsOrBindings_8_0,
                      								"org.eclipse.n4js.N4JS.ExportedVariableDeclarationOrBinding");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }
                    loop29:
                    do {
                        int alt29=2;
                        int LA29_0 = input.LA(1);

                        if ( (LA29_0==Comma) ) {
                            alt29=1;
                        }


                        switch (alt29) {
                    	case 1 :
                    	    {
                    	    otherlv_9=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      						newLeafNode(otherlv_9, grammarAccess.getAnnotatedExportableElementAccess().getCommaKeyword_1_1_4_0());
                    	      					
                    	    }
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      								newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getVarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_1_1_4_1_0());
                    	      							
                    	    }
                    	    pushFollow(FOLLOW_28);
                    	    lv_varDeclsOrBindings_10_0=ruleExportedVariableDeclarationOrBinding();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      								if (current==null) {
                    	      									current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                    	      								}
                    	      								add(
                    	      									current,
                    	      									"varDeclsOrBindings",
                    	      									lv_varDeclsOrBindings_10_0,
                    	      									"org.eclipse.n4js.N4JS.ExportedVariableDeclarationOrBinding");
                    	      								afterParserOrEnumRuleCall();
                    	      							
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop29;
                        }
                    } while (true);

                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getSemiParserRuleCall_1_1_5());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    ruleSemi();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    int alt38=2;
                    alt38 = dfa38.predict(input);
                    switch (alt38) {
                        case 1 :
                            {
                            {
                            {
                            if ( state.backtracking==0 ) {

                              								current = forceCreateModelElementAndSet(
                              									grammarAccess.getAnnotatedExportableElementAccess().getN4ClassDeclarationAnnotationListAction_1_2_0_0_0(),
                              									current);
                              							
                            }

                            }
                            loop30:
                            do {
                                int alt30=2;
                                int LA30_0 = input.LA(1);

                                if ( ((LA30_0>=Protected && LA30_0<=Abstract)||LA30_0==External||(LA30_0>=Private && LA30_0<=Project)||LA30_0==Public||LA30_0==Static||LA30_0==Const) ) {
                                    alt30=1;
                                }


                                switch (alt30) {
                            	case 1 :
                            	    {
                            	    {
                            	    if ( state.backtracking==0 ) {

                            	      									newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_2_0_0_1_0());
                            	      								
                            	    }
                            	    pushFollow(FOLLOW_6);
                            	    lv_declaredModifiers_13_0=ruleN4Modifier();

                            	    state._fsp--;
                            	    if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      									if (current==null) {
                            	      										current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                            	      									}
                            	      									add(
                            	      										current,
                            	      										"declaredModifiers",
                            	      										lv_declaredModifiers_13_0,
                            	      										"org.eclipse.n4js.N4JS.N4Modifier");
                            	      									afterParserOrEnumRuleCall();
                            	      								
                            	    }

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop30;
                                }
                            } while (true);

                            otherlv_14=(Token)match(input,Class,FOLLOW_7); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(otherlv_14, grammarAccess.getAnnotatedExportableElementAccess().getClassKeyword_1_2_0_0_2());
                              						
                            }
                            int alt31=2;
                            int LA31_0 = input.LA(1);

                            if ( (LA31_0==Tilde) ) {
                                alt31=1;
                            }
                            switch (alt31) {
                                case 1 :
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      									newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getTypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_0_3_0());
                                      								
                                    }
                                    pushFollow(FOLLOW_8);
                                    lv_typingStrategy_15_0=ruleTypingStrategyDefSiteOperator();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									if (current==null) {
                                      										current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                                      									}
                                      									set(
                                      										current,
                                      										"typingStrategy",
                                      										lv_typingStrategy_15_0,
                                      										"org.eclipse.n4js.ts.TypeExpressions.TypingStrategyDefSiteOperator");
                                      									afterParserOrEnumRuleCall();
                                      								
                                    }

                                    }


                                    }
                                    break;

                            }
                            {
                            {
                            if ( state.backtracking==0 ) {

                              									newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getNameBindingIdentifierParserRuleCall_1_2_0_0_4_0());
                              								
                            }
                            pushFollow(FOLLOW_9);
                            lv_name_16_0=ruleBindingIdentifier();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              									if (current==null) {
                              										current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                              									}
                              									set(
                              										current,
                              										"name",
                              										lv_name_16_0,
                              										"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                              									afterParserOrEnumRuleCall();
                              								
                            }

                            }


                            }
                            int alt32=2;
                            int LA32_0 = input.LA(1);

                            if ( (LA32_0==LessThanSign) ) {
                                alt32=1;
                            }
                            switch (alt32) {
                                case 1 :
                                    {
                                    if ( state.backtracking==0 ) {

                                      								if (current==null) {
                                      									current = createModelElement(grammarAccess.getAnnotatedExportableElementRule());
                                      								}
                                      								newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getTypeVariablesParserRuleCall_1_2_0_0_5());
                                      							
                                    }
                                    pushFollow(FOLLOW_9);
                                    this_TypeVariables_17=ruleTypeVariables(current);

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      								current = this_TypeVariables_17;
                                      								afterParserOrEnumRuleCall();
                                      							
                                    }

                                    }
                                    break;

                            }
                            int alt33=2;
                            int LA33_0 = input.LA(1);

                            if ( (LA33_0==Implements||LA33_0==Extends) ) {
                                alt33=1;
                            }
                            switch (alt33) {
                                case 1 :
                                    {
                                    if ( state.backtracking==0 ) {

                                      								if (current==null) {
                                      									current = createModelElement(grammarAccess.getAnnotatedExportableElementRule());
                                      								}
                                      								newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getClassExtendsImplementsParserRuleCall_1_2_0_0_6());
                                      							
                                    }
                                    pushFollow(FOLLOW_9);
                                    this_ClassExtendsImplements_18=ruleClassExtendsImplements(current);

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      								current = this_ClassExtendsImplements_18;
                                      								afterParserOrEnumRuleCall();
                                      							
                                    }

                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            {
                            if ( state.backtracking==0 ) {

                              								current = forceCreateModelElementAndSet(
                              									grammarAccess.getAnnotatedExportableElementAccess().getN4InterfaceDeclarationAnnotationListAction_1_2_0_1_0(),
                              									current);
                              							
                            }

                            }
                            loop34:
                            do {
                                int alt34=2;
                                int LA34_0 = input.LA(1);

                                if ( ((LA34_0>=Protected && LA34_0<=Abstract)||LA34_0==External||(LA34_0>=Private && LA34_0<=Project)||LA34_0==Public||LA34_0==Static||LA34_0==Const) ) {
                                    alt34=1;
                                }


                                switch (alt34) {
                            	case 1 :
                            	    {
                            	    {
                            	    if ( state.backtracking==0 ) {

                            	      									newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_2_0_1_1_0());
                            	      								
                            	    }
                            	    pushFollow(FOLLOW_10);
                            	    lv_declaredModifiers_20_0=ruleN4Modifier();

                            	    state._fsp--;
                            	    if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      									if (current==null) {
                            	      										current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                            	      									}
                            	      									add(
                            	      										current,
                            	      										"declaredModifiers",
                            	      										lv_declaredModifiers_20_0,
                            	      										"org.eclipse.n4js.N4JS.N4Modifier");
                            	      									afterParserOrEnumRuleCall();
                            	      								
                            	    }

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop34;
                                }
                            } while (true);

                            otherlv_21=(Token)match(input,Interface,FOLLOW_7); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(otherlv_21, grammarAccess.getAnnotatedExportableElementAccess().getInterfaceKeyword_1_2_0_1_2());
                              						
                            }
                            int alt35=2;
                            int LA35_0 = input.LA(1);

                            if ( (LA35_0==Tilde) ) {
                                alt35=1;
                            }
                            switch (alt35) {
                                case 1 :
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      									newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getTypingStrategyTypingStrategyDefSiteOperatorParserRuleCall_1_2_0_1_3_0());
                                      								
                                    }
                                    pushFollow(FOLLOW_8);
                                    lv_typingStrategy_22_0=ruleTypingStrategyDefSiteOperator();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									if (current==null) {
                                      										current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                                      									}
                                      									set(
                                      										current,
                                      										"typingStrategy",
                                      										lv_typingStrategy_22_0,
                                      										"org.eclipse.n4js.ts.TypeExpressions.TypingStrategyDefSiteOperator");
                                      									afterParserOrEnumRuleCall();
                                      								
                                    }

                                    }


                                    }
                                    break;

                            }
                            {
                            {
                            if ( state.backtracking==0 ) {

                              									newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getNameBindingIdentifierParserRuleCall_1_2_0_1_4_0());
                              								
                            }
                            pushFollow(FOLLOW_9);
                            lv_name_23_0=ruleBindingIdentifier();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              									if (current==null) {
                              										current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                              									}
                              									set(
                              										current,
                              										"name",
                              										lv_name_23_0,
                              										"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                              									afterParserOrEnumRuleCall();
                              								
                            }

                            }


                            }
                            int alt36=2;
                            int LA36_0 = input.LA(1);

                            if ( (LA36_0==LessThanSign) ) {
                                alt36=1;
                            }
                            switch (alt36) {
                                case 1 :
                                    {
                                    if ( state.backtracking==0 ) {

                                      								if (current==null) {
                                      									current = createModelElement(grammarAccess.getAnnotatedExportableElementRule());
                                      								}
                                      								newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getTypeVariablesParserRuleCall_1_2_0_1_5());
                                      							
                                    }
                                    pushFollow(FOLLOW_9);
                                    this_TypeVariables_24=ruleTypeVariables(current);

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      								current = this_TypeVariables_24;
                                      								afterParserOrEnumRuleCall();
                                      							
                                    }

                                    }
                                    break;

                            }
                            int alt37=2;
                            int LA37_0 = input.LA(1);

                            if ( (LA37_0==Implements||LA37_0==Extends) ) {
                                alt37=1;
                            }
                            switch (alt37) {
                                case 1 :
                                    {
                                    if ( state.backtracking==0 ) {

                                      								if (current==null) {
                                      									current = createModelElement(grammarAccess.getAnnotatedExportableElementRule());
                                      								}
                                      								newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getInterfaceExtendsListParserRuleCall_1_2_0_1_6());
                                      							
                                    }
                                    pushFollow(FOLLOW_9);
                                    this_InterfaceExtendsList_25=ruleInterfaceExtendsList(current);

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      								current = this_InterfaceExtendsList_25;
                                      								afterParserOrEnumRuleCall();
                                      							
                                    }

                                    }
                                    break;

                            }


                            }


                            }
                            break;

                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedExportableElementRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getMembersParserRuleCall_1_2_1());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_Members_26=ruleMembers(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_Members_26;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getAnnotatedExportableElementAccess().getN4EnumDeclarationAnnotationListAction_1_3_0(),
                      							current);
                      					
                    }

                    }
                    loop39:
                    do {
                        int alt39=2;
                        int LA39_0 = input.LA(1);

                        if ( ((LA39_0>=Protected && LA39_0<=Abstract)||LA39_0==External||(LA39_0>=Private && LA39_0<=Project)||LA39_0==Public||LA39_0==Static||LA39_0==Const) ) {
                            alt39=1;
                        }


                        switch (alt39) {
                    	case 1 :
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_3_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_11);
                    	    lv_declaredModifiers_28_0=ruleN4Modifier();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"declaredModifiers",
                    	      								lv_declaredModifiers_28_0,
                    	      								"org.eclipse.n4js.N4JS.N4Modifier");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop39;
                        }
                    } while (true);

                    otherlv_29=(Token)match(input,Enum,FOLLOW_8); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_29, grammarAccess.getAnnotatedExportableElementAccess().getEnumKeyword_1_3_2());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getNameBindingIdentifierParserRuleCall_1_3_3_0());
                      						
                    }
                    pushFollow(FOLLOW_13);
                    lv_name_30_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                      							}
                      							set(
                      								current,
                      								"name",
                      								lv_name_30_0,
                      								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }

                    otherlv_31=(Token)match(input,LeftCurlyBracket,FOLLOW_14); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_31, grammarAccess.getAnnotatedExportableElementAccess().getLeftCurlyBracketKeyword_1_3_4());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getLiteralsN4EnumLiteralParserRuleCall_1_3_5_0());
                      						
                    }
                    pushFollow(FOLLOW_15);
                    lv_literals_32_0=ruleN4EnumLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                      							}
                      							add(
                      								current,
                      								"literals",
                      								lv_literals_32_0,
                      								"org.eclipse.n4js.N4JS.N4EnumLiteral");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }
                    loop40:
                    do {
                        int alt40=2;
                        int LA40_0 = input.LA(1);

                        if ( (LA40_0==Comma) ) {
                            alt40=1;
                        }


                        switch (alt40) {
                    	case 1 :
                    	    {
                    	    otherlv_33=(Token)match(input,Comma,FOLLOW_14); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      						newLeafNode(otherlv_33, grammarAccess.getAnnotatedExportableElementAccess().getCommaKeyword_1_3_6_0());
                    	      					
                    	    }
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      								newCompositeNode(grammarAccess.getAnnotatedExportableElementAccess().getLiteralsN4EnumLiteralParserRuleCall_1_3_6_1_0());
                    	      							
                    	    }
                    	    pushFollow(FOLLOW_15);
                    	    lv_literals_34_0=ruleN4EnumLiteral();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      								if (current==null) {
                    	      									current = createModelElementForParent(grammarAccess.getAnnotatedExportableElementRule());
                    	      								}
                    	      								add(
                    	      									current,
                    	      									"literals",
                    	      									lv_literals_34_0,
                    	      									"org.eclipse.n4js.N4JS.N4EnumLiteral");
                    	      								afterParserOrEnumRuleCall();
                    	      							
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop40;
                        }
                    } while (true);

                    otherlv_35=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_35, grammarAccess.getAnnotatedExportableElementAccess().getRightCurlyBracketKeyword_1_3_7());
                      				
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleImportDeclaration() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleImportDeclaration = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getImportDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleImportDeclaration=ruleImportDeclaration();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleImportDeclaration; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleImportDeclaration() throws RecognitionException {
        EObject current = null;

        EObject this_ImportDeclarationImpl_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getImportDeclarationAccess().getImportDeclarationAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getImportDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getImportDeclarationAccess().getImportDeclarationImplParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_ImportDeclarationImpl_1=ruleImportDeclarationImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_ImportDeclarationImpl_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleImportDeclarationImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_0=null;
        Token lv_importFrom_2_0=null;
        EObject this_ImportClause_1 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Import,FOLLOW_29); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getImportDeclarationImplAccess().getImportKeyword_0());
              		
            }
            int alt42=2;
            int LA42_0 = input.LA(1);

            if ( ((LA42_0>=Intersection && LA42_0<=Implements)||(LA42_0>=Promisify && LA42_0<=Abstract)||LA42_0==External||(LA42_0>=Private && LA42_0<=Project)||LA42_0==Public||LA42_0==Static||LA42_0==Target||(LA42_0>=Async && LA42_0<=Await)||LA42_0==Union||(LA42_0>=Yield && LA42_0<=This)||LA42_0==From||LA42_0==Type||(LA42_0>=Get && LA42_0<=Let)||(LA42_0>=Out && LA42_0<=Set)||LA42_0==As||LA42_0==Of||LA42_0==Asterisk||LA42_0==LeftCurlyBracket||LA42_0==RULE_IDENTIFIER) ) {
                alt42=1;
            }
            switch (alt42) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getImportDeclarationImplRule());
                      				}
                      				newCompositeNode(grammarAccess.getImportDeclarationImplAccess().getImportClauseParserRuleCall_1_0());
                      			
                    }
                    pushFollow(FOLLOW_17);
                    this_ImportClause_1=ruleImportClause(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_ImportClause_1;
                      				afterParserOrEnumRuleCall();
                      			
                    }
                    {
                    {
                    lv_importFrom_2_0=(Token)match(input,From,FOLLOW_21); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_importFrom_2_0, grammarAccess.getImportDeclarationImplAccess().getImportFromFromKeyword_1_1_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getImportDeclarationImplRule());
                      						}
                      						setWithLastConsumed(current, "importFrom", true, "from");
                      					
                    }

                    }


                    }


                    }
                    break;

            }
            {
            {
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getImportDeclarationImplRule());
              					}
              				
            }
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getImportDeclarationImplAccess().getModuleTModuleCrossReference_2_0());
              				
            }
            pushFollow(FOLLOW_18);
            ruleModuleSpecifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getImportDeclarationImplAccess().getSemiParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleImportClause(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_1=null;
        EObject lv_importSpecifiers_0_0 = null;

        EObject this_ImportSpecifiersExceptDefault_2 = null;

        EObject this_ImportSpecifiersExceptDefault_3 = null;



        	enterRule();

        try {
            {
            int alt44=2;
            int LA44_0 = input.LA(1);

            if ( ((LA44_0>=Intersection && LA44_0<=Implements)||(LA44_0>=Promisify && LA44_0<=Abstract)||LA44_0==External||(LA44_0>=Private && LA44_0<=Project)||LA44_0==Public||LA44_0==Static||LA44_0==Target||(LA44_0>=Async && LA44_0<=Await)||LA44_0==Union||(LA44_0>=Yield && LA44_0<=This)||LA44_0==From||LA44_0==Type||(LA44_0>=Get && LA44_0<=Let)||(LA44_0>=Out && LA44_0<=Set)||LA44_0==As||LA44_0==Of||LA44_0==RULE_IDENTIFIER) ) {
                alt44=1;
            }
            else if ( (LA44_0==Asterisk||LA44_0==LeftCurlyBracket) ) {
                alt44=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 44, 0, input);

                throw nvae;
            }
            switch (alt44) {
                case 1 :
                    {
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getImportClauseAccess().getImportSpecifiersDefaultImportSpecifierParserRuleCall_0_0_0());
                      					
                    }
                    pushFollow(FOLLOW_30);
                    lv_importSpecifiers_0_0=ruleDefaultImportSpecifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getImportClauseRule());
                      						}
                      						add(
                      							current,
                      							"importSpecifiers",
                      							lv_importSpecifiers_0_0,
                      							"org.eclipse.n4js.N4JS.DefaultImportSpecifier");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }
                    int alt43=2;
                    int LA43_0 = input.LA(1);

                    if ( (LA43_0==Comma) ) {
                        alt43=1;
                    }
                    switch (alt43) {
                        case 1 :
                            {
                            otherlv_1=(Token)match(input,Comma,FOLLOW_31); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					newLeafNode(otherlv_1, grammarAccess.getImportClauseAccess().getCommaKeyword_0_1_0());
                              				
                            }
                            if ( state.backtracking==0 ) {

                              					if (current==null) {
                              						current = createModelElement(grammarAccess.getImportClauseRule());
                              					}
                              					newCompositeNode(grammarAccess.getImportClauseAccess().getImportSpecifiersExceptDefaultParserRuleCall_0_1_1());
                              				
                            }
                            pushFollow(FOLLOW_2);
                            this_ImportSpecifiersExceptDefault_2=ruleImportSpecifiersExceptDefault(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					current = this_ImportSpecifiersExceptDefault_2;
                              					afterParserOrEnumRuleCall();
                              				
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			if (current==null) {
                      				current = createModelElement(grammarAccess.getImportClauseRule());
                      			}
                      			newCompositeNode(grammarAccess.getImportClauseAccess().getImportSpecifiersExceptDefaultParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ImportSpecifiersExceptDefault_3=ruleImportSpecifiersExceptDefault(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ImportSpecifiersExceptDefault_3;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleImportSpecifiersExceptDefault(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token otherlv_6=null;
        EObject lv_importSpecifiers_0_0 = null;

        EObject lv_importSpecifiers_2_0 = null;

        EObject lv_importSpecifiers_4_0 = null;



        	enterRule();

        try {
            {
            int alt48=2;
            int LA48_0 = input.LA(1);

            if ( (LA48_0==Asterisk) ) {
                alt48=1;
            }
            else if ( (LA48_0==LeftCurlyBracket) ) {
                alt48=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 48, 0, input);

                throw nvae;
            }
            switch (alt48) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersNamespaceImportSpecifierParserRuleCall_0_0());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    lv_importSpecifiers_0_0=ruleNamespaceImportSpecifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getImportSpecifiersExceptDefaultRule());
                      					}
                      					add(
                      						current,
                      						"importSpecifiers",
                      						lv_importSpecifiers_0_0,
                      						"org.eclipse.n4js.N4JS.NamespaceImportSpecifier");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    otherlv_1=(Token)match(input,LeftCurlyBracket,FOLLOW_32); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_1, grammarAccess.getImportSpecifiersExceptDefaultAccess().getLeftCurlyBracketKeyword_1_0());
                      			
                    }
                    int alt47=2;
                    int LA47_0 = input.LA(1);

                    if ( ((LA47_0>=Intersection && LA47_0<=With)||(LA47_0>=For && LA47_0<=Var)||(LA47_0>=As && LA47_0<=Of)||LA47_0==RULE_IDENTIFIER) ) {
                        alt47=1;
                    }
                    switch (alt47) {
                        case 1 :
                            {
                            {
                            {
                            if ( state.backtracking==0 ) {

                              							newCompositeNode(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_0_0());
                              						
                            }
                            pushFollow(FOLLOW_15);
                            lv_importSpecifiers_2_0=ruleNamedImportSpecifier();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElementForParent(grammarAccess.getImportSpecifiersExceptDefaultRule());
                              							}
                              							add(
                              								current,
                              								"importSpecifiers",
                              								lv_importSpecifiers_2_0,
                              								"org.eclipse.n4js.N4JS.NamedImportSpecifier");
                              							afterParserOrEnumRuleCall();
                              						
                            }

                            }


                            }
                            loop45:
                            do {
                                int alt45=2;
                                int LA45_0 = input.LA(1);

                                if ( (LA45_0==Comma) ) {
                                    int LA45_1 = input.LA(2);

                                    if ( ((LA45_1>=Intersection && LA45_1<=With)||(LA45_1>=For && LA45_1<=Var)||(LA45_1>=As && LA45_1<=Of)||LA45_1==RULE_IDENTIFIER) ) {
                                        alt45=1;
                                    }


                                }


                                switch (alt45) {
                            	case 1 :
                            	    {
                            	    otherlv_3=(Token)match(input,Comma,FOLLOW_14); if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      						newLeafNode(otherlv_3, grammarAccess.getImportSpecifiersExceptDefaultAccess().getCommaKeyword_1_1_1_0());
                            	      					
                            	    }
                            	    {
                            	    {
                            	    if ( state.backtracking==0 ) {

                            	      								newCompositeNode(grammarAccess.getImportSpecifiersExceptDefaultAccess().getImportSpecifiersNamedImportSpecifierParserRuleCall_1_1_1_1_0());
                            	      							
                            	    }
                            	    pushFollow(FOLLOW_15);
                            	    lv_importSpecifiers_4_0=ruleNamedImportSpecifier();

                            	    state._fsp--;
                            	    if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      								if (current==null) {
                            	      									current = createModelElementForParent(grammarAccess.getImportSpecifiersExceptDefaultRule());
                            	      								}
                            	      								add(
                            	      									current,
                            	      									"importSpecifiers",
                            	      									lv_importSpecifiers_4_0,
                            	      									"org.eclipse.n4js.N4JS.NamedImportSpecifier");
                            	      								afterParserOrEnumRuleCall();
                            	      							
                            	    }

                            	    }


                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop45;
                                }
                            } while (true);
                            int alt46=2;
                            int LA46_0 = input.LA(1);

                            if ( (LA46_0==Comma) ) {
                                alt46=1;
                            }
                            switch (alt46) {
                                case 1 :
                                    {
                                    otherlv_5=(Token)match(input,Comma,FOLLOW_23); if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      						newLeafNode(otherlv_5, grammarAccess.getImportSpecifiersExceptDefaultAccess().getCommaKeyword_1_1_2());
                                      					
                                    }

                                    }
                                    break;

                            }


                            }
                            break;

                    }

                    otherlv_6=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_6, grammarAccess.getImportSpecifiersExceptDefaultAccess().getRightCurlyBracketKeyword_1_2());
                      			
                    }

                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleNamedImportSpecifier() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleNamedImportSpecifier = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getNamedImportSpecifierRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleNamedImportSpecifier=ruleNamedImportSpecifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleNamedImportSpecifier; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleNamedImportSpecifier() throws RecognitionException {
        EObject current = null;

        Token otherlv_2=null;
        AntlrDatatypeRuleToken lv_alias_3_0 = null;



        	enterRule();

        try {
            {
            int alt49=2;
            alt49 = dfa49.predict(input);
            switch (alt49) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getNamedImportSpecifierRule());
                      					}
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getNamedImportSpecifierAccess().getImportedElementTExportableElementCrossReference_0_0());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getNamedImportSpecifierRule());
                      						}
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getNamedImportSpecifierAccess().getImportedElementTExportableElementCrossReference_1_0_0());
                      					
                    }
                    pushFollow(FOLLOW_33);
                    ruleIdentifierName();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    otherlv_2=(Token)match(input,As,FOLLOW_8); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_2, grammarAccess.getNamedImportSpecifierAccess().getAsKeyword_1_1());
                      			
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getNamedImportSpecifierAccess().getAliasBindingIdentifierParserRuleCall_1_2_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_alias_3_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getNamedImportSpecifierRule());
                      						}
                      						set(
                      							current,
                      							"alias",
                      							lv_alias_3_0,
                      							"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleDefaultImportSpecifier() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleDefaultImportSpecifier = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getDefaultImportSpecifierRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleDefaultImportSpecifier=ruleDefaultImportSpecifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleDefaultImportSpecifier; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleDefaultImportSpecifier() throws RecognitionException {
        EObject current = null;


        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				if (current==null) {
              					current = createModelElement(grammarAccess.getDefaultImportSpecifierRule());
              				}
              			
            }
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getDefaultImportSpecifierAccess().getImportedElementTExportableElementCrossReference_0());
              			
            }
            pushFollow(FOLLOW_2);
            ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				afterParserOrEnumRuleCall();
              			
            }

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleNamespaceImportSpecifier() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleNamespaceImportSpecifier = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getNamespaceImportSpecifierRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleNamespaceImportSpecifier=ruleNamespaceImportSpecifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleNamespaceImportSpecifier; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleNamespaceImportSpecifier() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token lv_declaredDynamic_4_0=null;
        AntlrDatatypeRuleToken lv_alias_3_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getNamespaceImportSpecifierAccess().getNamespaceImportSpecifierAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Asterisk,FOLLOW_33); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getNamespaceImportSpecifierAccess().getAsteriskKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,As,FOLLOW_8); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getNamespaceImportSpecifierAccess().getAsKeyword_2());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getNamespaceImportSpecifierAccess().getAliasBindingIdentifierParserRuleCall_3_0());
              				
            }
            pushFollow(FOLLOW_34);
            lv_alias_3_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getNamespaceImportSpecifierRule());
              					}
              					set(
              						current,
              						"alias",
              						lv_alias_3_0,
              						"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            int alt50=2;
            int LA50_0 = input.LA(1);

            if ( (LA50_0==PlusSign) ) {
                alt50=1;
            }
            switch (alt50) {
                case 1 :
                    {
                    {
                    lv_declaredDynamic_4_0=(Token)match(input,PlusSign,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(lv_declaredDynamic_4_0, grammarAccess.getNamespaceImportSpecifierAccess().getDeclaredDynamicPlusSignKeyword_4_0());
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getNamespaceImportSpecifierRule());
                      					}
                      					setWithLastConsumed(current, "declaredDynamic", true, "+");
                      				
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final String entryRuleModuleSpecifier() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleModuleSpecifier = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getModuleSpecifierRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleModuleSpecifier=ruleModuleSpecifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleModuleSpecifier.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final AntlrDatatypeRuleToken ruleModuleSpecifier() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token this_STRING_0=null;


        	enterRule();

        try {
            {
            this_STRING_0=(Token)match(input,RULE_STRING,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(this_STRING_0);
              	
            }
            if ( state.backtracking==0 ) {

              		newLeafNode(this_STRING_0, grammarAccess.getModuleSpecifierAccess().getSTRINGTerminalRuleCall());
              	
            }

            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleFunctionDeclaration() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleFunctionDeclaration = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getFunctionDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleFunctionDeclaration=ruleFunctionDeclaration();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleFunctionDeclaration; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleFunctionDeclaration() throws RecognitionException {
        EObject current = null;

        Enumerator lv_declaredModifiers_1_0 = null;

        EObject this_AsyncNoTrailingLineBreak_2 = null;

        EObject this_FunctionImpl_3 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              						current = forceCreateModelElement(
              							grammarAccess.getFunctionDeclarationAccess().getFunctionDeclarationAction_0_0_0(),
              							current);
              					
            }

            }
            loop51:
            do {
                int alt51=2;
                int LA51_0 = input.LA(1);

                if ( ((LA51_0>=Protected && LA51_0<=Abstract)||LA51_0==External||(LA51_0>=Private && LA51_0<=Project)||LA51_0==Public||LA51_0==Static||LA51_0==Const) ) {
                    alt51=1;
                }


                switch (alt51) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      							newCompositeNode(grammarAccess.getFunctionDeclarationAccess().getDeclaredModifiersN4ModifierEnumRuleCall_0_0_1_0());
            	      						
            	    }
            	    pushFollow(FOLLOW_5);
            	    lv_declaredModifiers_1_0=ruleN4Modifier();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      							if (current==null) {
            	      								current = createModelElementForParent(grammarAccess.getFunctionDeclarationRule());
            	      							}
            	      							add(
            	      								current,
            	      								"declaredModifiers",
            	      								lv_declaredModifiers_1_0,
            	      								"org.eclipse.n4js.N4JS.N4Modifier");
            	      							afterParserOrEnumRuleCall();
            	      						
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop51;
                }
            } while (true);

            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getFunctionDeclarationRule());
              					}
              					newCompositeNode(grammarAccess.getFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_0_0_2());
              				
            }
            pushFollow(FOLLOW_5);
            this_AsyncNoTrailingLineBreak_2=ruleAsyncNoTrailingLineBreak(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					current = this_AsyncNoTrailingLineBreak_2;
              					afterParserOrEnumRuleCall();
              				
            }
            {
            if ( state.backtracking==0 ) {

              						if (current==null) {
              							current = createModelElement(grammarAccess.getFunctionDeclarationRule());
              						}
              						newCompositeNode(grammarAccess.getFunctionDeclarationAccess().getFunctionImplParserRuleCall_0_0_3());
              					
            }
            pushFollow(FOLLOW_35);
            this_FunctionImpl_3=ruleFunctionImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              						current = this_FunctionImpl_3;
              						afterParserOrEnumRuleCall();
              					
            }

            }


            }


            }
            int alt52=2;
            alt52 = dfa52.predict(input);
            switch (alt52) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getFunctionDeclarationAccess().getSemiParserRuleCall_1());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    ruleSemi();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_FunctionDeclaration() throws RecognitionException {
        EObject current = null;

        Enumerator lv_declaredModifiers_1_0 = null;

        EObject this_AsyncNoTrailingLineBreak_2 = null;

        EObject this_FunctionImpl_3 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              						current = forceCreateModelElement(
              							grammarAccess.getFunctionDeclarationAccess().getFunctionDeclarationAction_0_0_0(),
              							current);
              					
            }

            }
            loop53:
            do {
                int alt53=2;
                int LA53_0 = input.LA(1);

                if ( ((LA53_0>=Protected && LA53_0<=Abstract)||LA53_0==External||(LA53_0>=Private && LA53_0<=Project)||LA53_0==Public||LA53_0==Static||LA53_0==Const) ) {
                    alt53=1;
                }


                switch (alt53) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      							newCompositeNode(grammarAccess.getFunctionDeclarationAccess().getDeclaredModifiersN4ModifierEnumRuleCall_0_0_1_0());
            	      						
            	    }
            	    pushFollow(FOLLOW_5);
            	    lv_declaredModifiers_1_0=ruleN4Modifier();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      							if (current==null) {
            	      								current = createModelElementForParent(grammarAccess.getFunctionDeclarationRule());
            	      							}
            	      							add(
            	      								current,
            	      								"declaredModifiers",
            	      								lv_declaredModifiers_1_0,
            	      								"org.eclipse.n4js.N4JS.N4Modifier");
            	      							afterParserOrEnumRuleCall();
            	      						
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop53;
                }
            } while (true);

            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getFunctionDeclarationRule());
              					}
              					newCompositeNode(grammarAccess.getFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_0_0_2());
              				
            }
            pushFollow(FOLLOW_36);
            this_AsyncNoTrailingLineBreak_2=ruleAsyncNoTrailingLineBreak(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					current = this_AsyncNoTrailingLineBreak_2;
              					afterParserOrEnumRuleCall();
              				
            }
            {
            if ( state.backtracking==0 ) {

              						if (current==null) {
              							current = createModelElement(grammarAccess.getFunctionDeclarationRule());
              						}
              						newCompositeNode(grammarAccess.getFunctionDeclarationAccess().getFunctionImplParserRuleCall_0_0_3());
              					
            }
            pushFollow(FOLLOW_35);
            this_FunctionImpl_3=norm3_FunctionImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              						current = this_FunctionImpl_3;
              						afterParserOrEnumRuleCall();
              					
            }

            }


            }


            }
            int alt54=2;
            int LA54_0 = input.LA(1);

            if ( (LA54_0==Semicolon) ) {
                int LA54_1 = input.LA(2);

                if ( (synpred22_InternalN4JSParser()) ) {
                    alt54=1;
                }
            }
            else if ( (LA54_0==EOF||LA54_0==RULE_ML_COMMENT||LA54_0==RULE_EOL) && (synpred22_InternalN4JSParser())) {
                alt54=1;
            }
            else if ( (LA54_0==RightCurlyBracket) ) {
                int LA54_3 = input.LA(2);

                if ( (synpred22_InternalN4JSParser()) ) {
                    alt54=1;
                }
            }
            switch (alt54) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getFunctionDeclarationAccess().getSemiParserRuleCall_1());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    ruleSemi();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleAsyncNoTrailingLineBreak(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token lv_declaredAsync_0_0=null;
        EObject this_NoLineTerminator_1 = null;



        	enterRule();

        try {
            {
            int alt55=2;
            int LA55_0 = input.LA(1);

            if ( (LA55_0==Async) ) {
                int LA55_1 = input.LA(2);

                if ( ((LA55_1>=Intersection && LA55_1<=With)||(LA55_1>=For && LA55_1<=Var)||(LA55_1>=As && LA55_1<=Of)||LA55_1==LeftSquareBracket||LA55_1==RULE_DOUBLE||LA55_1==RULE_HEX_INT||LA55_1==RULE_OCTAL_INT||LA55_1==RULE_SCIENTIFIC_INT||LA55_1==RULE_IDENTIFIER||LA55_1==RULE_STRING||LA55_1==RULE_NO_LINE_TERMINATOR||LA55_1==RULE_INT) ) {
                    alt55=1;
                }
            }
            switch (alt55) {
                case 1 :
                    {
                    {
                    {
                    lv_declaredAsync_0_0=(Token)match(input,Async,FOLLOW_37); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(lv_declaredAsync_0_0, grammarAccess.getAsyncNoTrailingLineBreakAccess().getDeclaredAsyncAsyncKeyword_0_0());
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAsyncNoTrailingLineBreakRule());
                      					}
                      					setWithLastConsumed(current, "declaredAsync", true, "async");
                      				
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      			if (current==null) {
                      				current = createModelElement(grammarAccess.getAsyncNoTrailingLineBreakRule());
                      			}
                      			newCompositeNode(grammarAccess.getAsyncNoTrailingLineBreakAccess().getNoLineTerminatorParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_NoLineTerminator_1=ruleNoLineTerminator(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_NoLineTerminator_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleFunctionImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_0=null;
        Token lv_generator_1_0=null;
        EObject this_FunctionHeader_2 = null;

        EObject this_FunctionBody_3 = null;

        EObject this_FunctionHeader_4 = null;

        EObject this_FunctionBody_5 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Function,FOLLOW_38); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getFunctionImplAccess().getFunctionKeyword_0());
              		
            }
            int alt56=2;
            int LA56_0 = input.LA(1);

            if ( (LA56_0==Asterisk) ) {
                alt56=1;
            }
            else if ( ((LA56_0>=Intersection && LA56_0<=Implements)||(LA56_0>=Promisify && LA56_0<=Abstract)||LA56_0==External||(LA56_0>=Private && LA56_0<=Project)||LA56_0==Public||LA56_0==Static||LA56_0==Target||(LA56_0>=Async && LA56_0<=Await)||LA56_0==Union||(LA56_0>=Yield && LA56_0<=This)||LA56_0==From||LA56_0==Type||(LA56_0>=Get && LA56_0<=Let)||(LA56_0>=Out && LA56_0<=Set)||LA56_0==As||LA56_0==Of||LA56_0==LeftParenthesis||LA56_0==LessThanSign||LA56_0==RULE_IDENTIFIER||LA56_0==RULE_VERSION) ) {
                alt56=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 56, 0, input);

                throw nvae;
            }
            switch (alt56) {
                case 1 :
                    {
                    {
                    {
                    {
                    lv_generator_1_0=(Token)match(input,Asterisk,FOLLOW_39); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(lv_generator_1_0, grammarAccess.getFunctionImplAccess().getGeneratorAsteriskKeyword_1_0_0_0());
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getFunctionImplRule());
                      							}
                      							setWithLastConsumed(current, "generator", true, "*");
                      						
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1());
                      				
                    }
                    pushFollow(FOLLOW_13);
                    this_FunctionHeader_2=norm2_FunctionHeader(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionHeader_2;
                      					afterParserOrEnumRuleCall();
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionBody_3=norm1_FunctionBody(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionBody_3;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0());
                      				
                    }
                    pushFollow(FOLLOW_13);
                    this_FunctionHeader_4=ruleFunctionHeader(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionHeader_4;
                      					afterParserOrEnumRuleCall();
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionBody_5=ruleFunctionBody(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionBody_5;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm3_FunctionImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_0=null;
        Token lv_generator_1_0=null;
        EObject this_FunctionHeader_2 = null;

        EObject this_FunctionBody_3 = null;

        EObject this_FunctionHeader_4 = null;

        EObject this_FunctionBody_5 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Function,FOLLOW_38); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getFunctionImplAccess().getFunctionKeyword_0());
              		
            }
            int alt57=2;
            int LA57_0 = input.LA(1);

            if ( (LA57_0==Asterisk) ) {
                alt57=1;
            }
            else if ( ((LA57_0>=Intersection && LA57_0<=Implements)||(LA57_0>=Promisify && LA57_0<=Abstract)||LA57_0==External||(LA57_0>=Private && LA57_0<=Project)||LA57_0==Public||LA57_0==Static||LA57_0==Target||(LA57_0>=Async && LA57_0<=Await)||LA57_0==Union||LA57_0==This||LA57_0==From||LA57_0==Type||(LA57_0>=Get && LA57_0<=Let)||(LA57_0>=Out && LA57_0<=Set)||LA57_0==As||LA57_0==Of||LA57_0==LeftParenthesis||LA57_0==LessThanSign||LA57_0==RULE_IDENTIFIER||LA57_0==RULE_VERSION) ) {
                alt57=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 57, 0, input);

                throw nvae;
            }
            switch (alt57) {
                case 1 :
                    {
                    {
                    {
                    {
                    lv_generator_1_0=(Token)match(input,Asterisk,FOLLOW_39); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(lv_generator_1_0, grammarAccess.getFunctionImplAccess().getGeneratorAsteriskKeyword_1_0_0_0());
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getFunctionImplRule());
                      							}
                      							setWithLastConsumed(current, "generator", true, "*");
                      						
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1());
                      				
                    }
                    pushFollow(FOLLOW_13);
                    this_FunctionHeader_2=norm3_FunctionHeader(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionHeader_2;
                      					afterParserOrEnumRuleCall();
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionBody_3=norm1_FunctionBody(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionBody_3;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0());
                      				
                    }
                    pushFollow(FOLLOW_13);
                    this_FunctionHeader_4=norm1_FunctionHeader(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionHeader_4;
                      					afterParserOrEnumRuleCall();
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionBody_5=ruleFunctionBody(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionBody_5;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm6_FunctionImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_0=null;
        Token lv_generator_1_0=null;
        EObject this_FunctionHeader_2 = null;

        EObject this_FunctionBody_3 = null;

        EObject this_FunctionHeader_4 = null;

        EObject this_FunctionBody_5 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Function,FOLLOW_38); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getFunctionImplAccess().getFunctionKeyword_0());
              		
            }
            int alt58=2;
            int LA58_0 = input.LA(1);

            if ( (LA58_0==Asterisk) ) {
                alt58=1;
            }
            else if ( ((LA58_0>=Intersection && LA58_0<=Implements)||(LA58_0>=Promisify && LA58_0<=Abstract)||LA58_0==External||(LA58_0>=Private && LA58_0<=Project)||LA58_0==Public||LA58_0==Static||LA58_0==Target||(LA58_0>=Async && LA58_0<=Await)||LA58_0==Union||(LA58_0>=Yield && LA58_0<=This)||LA58_0==From||LA58_0==Type||(LA58_0>=Get && LA58_0<=Let)||(LA58_0>=Out && LA58_0<=Set)||LA58_0==As||LA58_0==Of||LA58_0==LeftParenthesis||LA58_0==LessThanSign||LA58_0==RULE_IDENTIFIER||LA58_0==RULE_VERSION) ) {
                alt58=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 58, 0, input);

                throw nvae;
            }
            switch (alt58) {
                case 1 :
                    {
                    {
                    {
                    {
                    lv_generator_1_0=(Token)match(input,Asterisk,FOLLOW_39); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(lv_generator_1_0, grammarAccess.getFunctionImplAccess().getGeneratorAsteriskKeyword_1_0_0_0());
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getFunctionImplRule());
                      							}
                      							setWithLastConsumed(current, "generator", true, "*");
                      						
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_0_1());
                      				
                    }
                    pushFollow(FOLLOW_13);
                    this_FunctionHeader_2=norm3_FunctionHeader(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionHeader_2;
                      					afterParserOrEnumRuleCall();
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_0_2());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionBody_3=norm3_FunctionBody(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionBody_3;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionHeaderParserRuleCall_1_1_0());
                      				
                    }
                    pushFollow(FOLLOW_13);
                    this_FunctionHeader_4=ruleFunctionHeader(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionHeader_4;
                      					afterParserOrEnumRuleCall();
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getFunctionImplRule());
                      					}
                      					newCompositeNode(grammarAccess.getFunctionImplAccess().getFunctionBodyParserRuleCall_1_1_1());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionBody_5=norm2_FunctionBody(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionBody_5;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleFunctionHeader(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        EObject this_TypeVariables_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject this_VersionDeclaration_2 = null;

        EObject this_StrictFormalParameters_3 = null;

        EObject this_ColonSepReturnTypeRef_4 = null;



        	enterRule();

        try {
            {
            {
            int alt59=2;
            int LA59_0 = input.LA(1);

            if ( (LA59_0==LessThanSign) ) {
                alt59=1;
            }
            switch (alt59) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_40);
                    this_TypeVariables_0=ruleTypeVariables(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_TypeVariables_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }
            int alt60=2;
            int LA60_0 = input.LA(1);

            if ( ((LA60_0>=Intersection && LA60_0<=Implements)||(LA60_0>=Promisify && LA60_0<=Abstract)||LA60_0==External||(LA60_0>=Private && LA60_0<=Project)||LA60_0==Public||LA60_0==Static||LA60_0==Target||(LA60_0>=Async && LA60_0<=Await)||LA60_0==Union||(LA60_0>=Yield && LA60_0<=This)||LA60_0==From||LA60_0==Type||(LA60_0>=Get && LA60_0<=Let)||(LA60_0>=Out && LA60_0<=Set)||LA60_0==As||LA60_0==Of||LA60_0==RULE_IDENTIFIER) ) {
                alt60=1;
            }
            switch (alt60) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getFunctionHeaderAccess().getNameBindingIdentifierParserRuleCall_1_0());
                      				
                    }
                    pushFollow(FOLLOW_41);
                    lv_name_1_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getFunctionHeaderRule());
                      					}
                      					set(
                      						current,
                      						"name",
                      						lv_name_1_0,
                      						"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }
            int alt61=2;
            int LA61_0 = input.LA(1);

            if ( (LA61_0==RULE_VERSION) ) {
                alt61=1;
            }
            switch (alt61) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2());
                      			
                    }
                    pushFollow(FOLLOW_42);
                    this_VersionDeclaration_2=ruleVersionDeclaration(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VersionDeclaration_2;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getFunctionHeaderRule());
              			}
              			newCompositeNode(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_43);
            this_StrictFormalParameters_3=ruleStrictFormalParameters(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_StrictFormalParameters_3;
              			afterParserOrEnumRuleCall();
              		
            }
            int alt62=2;
            int LA62_0 = input.LA(1);

            if ( (LA62_0==Colon) && (synpred23_InternalN4JSParser())) {
                alt62=1;
            }
            switch (alt62) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_ColonSepReturnTypeRef_4=ruleColonSepReturnTypeRef(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_ColonSepReturnTypeRef_4;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_FunctionHeader(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        EObject this_TypeVariables_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject this_VersionDeclaration_2 = null;

        EObject this_StrictFormalParameters_3 = null;

        EObject this_ColonSepReturnTypeRef_4 = null;



        	enterRule();

        try {
            {
            {
            int alt63=2;
            int LA63_0 = input.LA(1);

            if ( (LA63_0==LessThanSign) ) {
                alt63=1;
            }
            switch (alt63) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_40);
                    this_TypeVariables_0=ruleTypeVariables(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_TypeVariables_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }
            int alt64=2;
            int LA64_0 = input.LA(1);

            if ( ((LA64_0>=Intersection && LA64_0<=Implements)||(LA64_0>=Promisify && LA64_0<=Abstract)||LA64_0==External||(LA64_0>=Private && LA64_0<=Project)||LA64_0==Public||LA64_0==Static||LA64_0==Target||(LA64_0>=Async && LA64_0<=Await)||LA64_0==Union||LA64_0==This||LA64_0==From||LA64_0==Type||(LA64_0>=Get && LA64_0<=Let)||(LA64_0>=Out && LA64_0<=Set)||LA64_0==As||LA64_0==Of||LA64_0==RULE_IDENTIFIER) ) {
                alt64=1;
            }
            switch (alt64) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getFunctionHeaderAccess().getNameBindingIdentifierParserRuleCall_1_0());
                      				
                    }
                    pushFollow(FOLLOW_41);
                    lv_name_1_0=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getFunctionHeaderRule());
                      					}
                      					set(
                      						current,
                      						"name",
                      						lv_name_1_0,
                      						"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }
            int alt65=2;
            int LA65_0 = input.LA(1);

            if ( (LA65_0==RULE_VERSION) ) {
                alt65=1;
            }
            switch (alt65) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2());
                      			
                    }
                    pushFollow(FOLLOW_42);
                    this_VersionDeclaration_2=ruleVersionDeclaration(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VersionDeclaration_2;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getFunctionHeaderRule());
              			}
              			newCompositeNode(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_43);
            this_StrictFormalParameters_3=ruleStrictFormalParameters(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_StrictFormalParameters_3;
              			afterParserOrEnumRuleCall();
              		
            }
            int alt66=2;
            int LA66_0 = input.LA(1);

            if ( (LA66_0==Colon) && (synpred24_InternalN4JSParser())) {
                alt66=1;
            }
            switch (alt66) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_ColonSepReturnTypeRef_4=ruleColonSepReturnTypeRef(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_ColonSepReturnTypeRef_4;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm2_FunctionHeader(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        EObject this_TypeVariables_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject this_VersionDeclaration_2 = null;

        EObject this_StrictFormalParameters_3 = null;

        EObject this_ColonSepReturnTypeRef_4 = null;



        	enterRule();

        try {
            {
            {
            int alt67=2;
            int LA67_0 = input.LA(1);

            if ( (LA67_0==LessThanSign) ) {
                alt67=1;
            }
            switch (alt67) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_39);
                    this_TypeVariables_0=ruleTypeVariables(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_TypeVariables_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }
            int alt68=2;
            int LA68_0 = input.LA(1);

            if ( ((LA68_0>=Intersection && LA68_0<=Implements)||(LA68_0>=Promisify && LA68_0<=Abstract)||LA68_0==External||(LA68_0>=Private && LA68_0<=Project)||LA68_0==Public||LA68_0==Static||LA68_0==Target||(LA68_0>=Async && LA68_0<=Await)||LA68_0==Union||(LA68_0>=Yield && LA68_0<=This)||LA68_0==From||LA68_0==Type||(LA68_0>=Get && LA68_0<=Let)||(LA68_0>=Out && LA68_0<=Set)||LA68_0==As||LA68_0==Of||LA68_0==RULE_IDENTIFIER) ) {
                alt68=1;
            }
            switch (alt68) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getFunctionHeaderAccess().getNameBindingIdentifierParserRuleCall_1_0());
                      				
                    }
                    pushFollow(FOLLOW_39);
                    lv_name_1_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getFunctionHeaderRule());
                      					}
                      					set(
                      						current,
                      						"name",
                      						lv_name_1_0,
                      						"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }
            int alt69=2;
            int LA69_0 = input.LA(1);

            if ( (LA69_0==RULE_VERSION) ) {
                alt69=1;
            }
            switch (alt69) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2());
                      			
                    }
                    pushFollow(FOLLOW_39);
                    this_VersionDeclaration_2=ruleVersionDeclaration(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VersionDeclaration_2;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getFunctionHeaderRule());
              			}
              			newCompositeNode(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_43);
            this_StrictFormalParameters_3=norm1_StrictFormalParameters(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_StrictFormalParameters_3;
              			afterParserOrEnumRuleCall();
              		
            }
            int alt70=2;
            int LA70_0 = input.LA(1);

            if ( (LA70_0==Colon) && (synpred25_InternalN4JSParser())) {
                alt70=1;
            }
            switch (alt70) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_ColonSepReturnTypeRef_4=ruleColonSepReturnTypeRef(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_ColonSepReturnTypeRef_4;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm3_FunctionHeader(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        EObject this_TypeVariables_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject this_VersionDeclaration_2 = null;

        EObject this_StrictFormalParameters_3 = null;

        EObject this_ColonSepReturnTypeRef_4 = null;



        	enterRule();

        try {
            {
            {
            int alt71=2;
            int LA71_0 = input.LA(1);

            if ( (LA71_0==LessThanSign) ) {
                alt71=1;
            }
            switch (alt71) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getTypeVariablesParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_39);
                    this_TypeVariables_0=ruleTypeVariables(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_TypeVariables_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }
            int alt72=2;
            int LA72_0 = input.LA(1);

            if ( ((LA72_0>=Intersection && LA72_0<=Implements)||(LA72_0>=Promisify && LA72_0<=Abstract)||LA72_0==External||(LA72_0>=Private && LA72_0<=Project)||LA72_0==Public||LA72_0==Static||LA72_0==Target||(LA72_0>=Async && LA72_0<=Await)||LA72_0==Union||LA72_0==This||LA72_0==From||LA72_0==Type||(LA72_0>=Get && LA72_0<=Let)||(LA72_0>=Out && LA72_0<=Set)||LA72_0==As||LA72_0==Of||LA72_0==RULE_IDENTIFIER) ) {
                alt72=1;
            }
            switch (alt72) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getFunctionHeaderAccess().getNameBindingIdentifierParserRuleCall_1_0());
                      				
                    }
                    pushFollow(FOLLOW_39);
                    lv_name_1_0=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getFunctionHeaderRule());
                      					}
                      					set(
                      						current,
                      						"name",
                      						lv_name_1_0,
                      						"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }
            int alt73=2;
            int LA73_0 = input.LA(1);

            if ( (LA73_0==RULE_VERSION) ) {
                alt73=1;
            }
            switch (alt73) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getVersionDeclarationParserRuleCall_2());
                      			
                    }
                    pushFollow(FOLLOW_39);
                    this_VersionDeclaration_2=ruleVersionDeclaration(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VersionDeclaration_2;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getFunctionHeaderRule());
              			}
              			newCompositeNode(grammarAccess.getFunctionHeaderAccess().getStrictFormalParametersParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_43);
            this_StrictFormalParameters_3=norm1_StrictFormalParameters(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_StrictFormalParameters_3;
              			afterParserOrEnumRuleCall();
              		
            }
            int alt74=2;
            int LA74_0 = input.LA(1);

            if ( (LA74_0==Colon) && (synpred26_InternalN4JSParser())) {
                alt74=1;
            }
            switch (alt74) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getFunctionHeaderRule());
                      				}
                      				newCompositeNode(grammarAccess.getFunctionHeaderAccess().getColonSepReturnTypeRefParserRuleCall_4());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_ColonSepReturnTypeRef_4=ruleColonSepReturnTypeRef(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_ColonSepReturnTypeRef_4;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleFunctionBody(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        EObject lv_body_0_0 = null;



        	enterRule();

        try {
            {
            int alt75=2;
            alt75 = dfa75.predict(input);
            switch (alt75) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getFunctionBodyAccess().getBodyBlockParserRuleCall_1_0_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    lv_body_0_0=ruleBlock();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElementForParent(grammarAccess.getFunctionBodyRule());
                      				}
                      				set(
                      					current,
                      					"body",
                      					lv_body_0_0,
                      					"org.eclipse.n4js.N4JS.Block");
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_FunctionBody(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        EObject lv_body_0_0 = null;



        	enterRule();

        try {
            {
            int alt76=2;
            alt76 = dfa76.predict(input);
            switch (alt76) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getFunctionBodyAccess().getBodyBlockParserRuleCall_1_0_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    lv_body_0_0=norm1_Block();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElementForParent(grammarAccess.getFunctionBodyRule());
                      				}
                      				set(
                      					current,
                      					"body",
                      					lv_body_0_0,
                      					"org.eclipse.n4js.N4JS.Block");
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm2_FunctionBody(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        EObject lv_body_0_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getFunctionBodyAccess().getBodyBlockParserRuleCall_0_0_0());
              			
            }
            pushFollow(FOLLOW_2);
            lv_body_0_0=ruleBlock();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				if (current==null) {
              					current = createModelElementForParent(grammarAccess.getFunctionBodyRule());
              				}
              				set(
              					current,
              					"body",
              					lv_body_0_0,
              					"org.eclipse.n4js.N4JS.Block");
              				afterParserOrEnumRuleCall();
              			
            }

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm3_FunctionBody(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        EObject lv_body_0_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getFunctionBodyAccess().getBodyBlockParserRuleCall_0_0_0());
              			
            }
            pushFollow(FOLLOW_2);
            lv_body_0_0=norm1_Block();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				if (current==null) {
              					current = createModelElementForParent(grammarAccess.getFunctionBodyRule());
              				}
              				set(
              					current,
              					"body",
              					lv_body_0_0,
              					"org.eclipse.n4js.N4JS.Block");
              				afterParserOrEnumRuleCall();
              			
            }

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleAnnotatedFunctionDeclaration() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleAnnotatedFunctionDeclaration = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getAnnotatedFunctionDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleAnnotatedFunctionDeclaration=ruleAnnotatedFunctionDeclaration();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleAnnotatedFunctionDeclaration; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleAnnotatedFunctionDeclaration() throws RecognitionException {
        EObject current = null;

        EObject lv_annotationList_0_0 = null;

        Enumerator lv_declaredModifiers_1_0 = null;

        EObject this_AsyncNoTrailingLineBreak_2 = null;

        EObject this_FunctionImpl_3 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAnnotationListAnnotationListParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_5);
            lv_annotationList_0_0=ruleAnnotationList();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getAnnotatedFunctionDeclarationRule());
              					}
              					set(
              						current,
              						"annotationList",
              						lv_annotationList_0_0,
              						"org.eclipse.n4js.N4JS.AnnotationList");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            loop77:
            do {
                int alt77=2;
                int LA77_0 = input.LA(1);

                if ( ((LA77_0>=Protected && LA77_0<=Abstract)||LA77_0==External||(LA77_0>=Private && LA77_0<=Project)||LA77_0==Public||LA77_0==Static||LA77_0==Const) ) {
                    alt77=1;
                }


                switch (alt77) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getAnnotatedFunctionDeclarationAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_5);
            	    lv_declaredModifiers_1_0=ruleN4Modifier();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getAnnotatedFunctionDeclarationRule());
            	      					}
            	      					add(
            	      						current,
            	      						"declaredModifiers",
            	      						lv_declaredModifiers_1_0,
            	      						"org.eclipse.n4js.N4JS.N4Modifier");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop77;
                }
            } while (true);

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getAnnotatedFunctionDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_2());
              		
            }
            pushFollow(FOLLOW_5);
            this_AsyncNoTrailingLineBreak_2=ruleAsyncNoTrailingLineBreak(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_AsyncNoTrailingLineBreak_2;
              			afterParserOrEnumRuleCall();
              		
            }
            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getAnnotatedFunctionDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getAnnotatedFunctionDeclarationAccess().getFunctionImplParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_2);
            this_FunctionImpl_3=ruleFunctionImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_FunctionImpl_3;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_AnnotatedFunctionDeclaration() throws RecognitionException {
        EObject current = null;

        EObject lv_annotationList_0_0 = null;

        Enumerator lv_declaredModifiers_1_0 = null;

        EObject this_AsyncNoTrailingLineBreak_2 = null;

        EObject this_FunctionImpl_3 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAnnotationListAnnotationListParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_5);
            lv_annotationList_0_0=ruleAnnotationList();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getAnnotatedFunctionDeclarationRule());
              					}
              					set(
              						current,
              						"annotationList",
              						lv_annotationList_0_0,
              						"org.eclipse.n4js.N4JS.AnnotationList");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            loop78:
            do {
                int alt78=2;
                int LA78_0 = input.LA(1);

                if ( ((LA78_0>=Protected && LA78_0<=Abstract)||LA78_0==External||(LA78_0>=Private && LA78_0<=Project)||LA78_0==Public||LA78_0==Static||LA78_0==Const) ) {
                    alt78=1;
                }


                switch (alt78) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getAnnotatedFunctionDeclarationAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_5);
            	    lv_declaredModifiers_1_0=ruleN4Modifier();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getAnnotatedFunctionDeclarationRule());
            	      					}
            	      					add(
            	      						current,
            	      						"declaredModifiers",
            	      						lv_declaredModifiers_1_0,
            	      						"org.eclipse.n4js.N4JS.N4Modifier");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop78;
                }
            } while (true);

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getAnnotatedFunctionDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getAnnotatedFunctionDeclarationAccess().getAsyncNoTrailingLineBreakParserRuleCall_2());
              		
            }
            pushFollow(FOLLOW_36);
            this_AsyncNoTrailingLineBreak_2=ruleAsyncNoTrailingLineBreak(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_AsyncNoTrailingLineBreak_2;
              			afterParserOrEnumRuleCall();
              		
            }
            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getAnnotatedFunctionDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getAnnotatedFunctionDeclarationAccess().getFunctionImplParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_2);
            this_FunctionImpl_3=norm3_FunctionImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_FunctionImpl_3;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleFunctionExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleFunctionExpression = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getFunctionExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleFunctionExpression=ruleFunctionExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleFunctionExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleFunctionExpression() throws RecognitionException {
        EObject current = null;

        EObject this_FunctionImpl_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getFunctionExpressionAccess().getFunctionExpressionAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getFunctionExpressionRule());
              			}
              			newCompositeNode(grammarAccess.getFunctionExpressionAccess().getFunctionImplParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_FunctionImpl_1=norm6_FunctionImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_FunctionImpl_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleAsyncFunctionExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleAsyncFunctionExpression = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getAsyncFunctionExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleAsyncFunctionExpression=ruleAsyncFunctionExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleAsyncFunctionExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleAsyncFunctionExpression() throws RecognitionException {
        EObject current = null;

        Token lv_declaredAsync_0_0=null;
        Token otherlv_2=null;
        EObject this_NoLineTerminator_1 = null;

        EObject this_FunctionHeader_3 = null;

        EObject this_FunctionBody_4 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            {
            {
            lv_declaredAsync_0_0=(Token)match(input,Async,FOLLOW_44); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              							newLeafNode(lv_declaredAsync_0_0, grammarAccess.getAsyncFunctionExpressionAccess().getDeclaredAsyncAsyncKeyword_0_0_0_0());
              						
            }
            if ( state.backtracking==0 ) {

              							if (current==null) {
              								current = createModelElement(grammarAccess.getAsyncFunctionExpressionRule());
              							}
              							setWithLastConsumed(current, "declaredAsync", true, "async");
              						
            }

            }


            }

            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElement(grammarAccess.getAsyncFunctionExpressionRule());
              					}
              					newCompositeNode(grammarAccess.getAsyncFunctionExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_1());
              				
            }
            pushFollow(FOLLOW_45);
            this_NoLineTerminator_1=ruleNoLineTerminator(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					current = this_NoLineTerminator_1;
              					afterParserOrEnumRuleCall();
              				
            }
            otherlv_2=(Token)match(input,Function,FOLLOW_38); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_2, grammarAccess.getAsyncFunctionExpressionAccess().getFunctionKeyword_0_0_2());
              				
            }

            }


            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getAsyncFunctionExpressionRule());
              			}
              			newCompositeNode(grammarAccess.getAsyncFunctionExpressionAccess().getFunctionHeaderParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_13);
            this_FunctionHeader_3=ruleFunctionHeader(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_FunctionHeader_3;
              			afterParserOrEnumRuleCall();
              		
            }
            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getAsyncFunctionExpressionRule());
              			}
              			newCompositeNode(grammarAccess.getAsyncFunctionExpressionAccess().getFunctionBodyParserRuleCall_2());
              		
            }
            pushFollow(FOLLOW_2);
            this_FunctionBody_4=norm2_FunctionBody(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_FunctionBody_4;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleArrowExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleArrowExpression = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getArrowExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleArrowExpression=ruleArrowExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleArrowExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleArrowExpression() throws RecognitionException {
        EObject current = null;

        Token lv_declaredAsync_2_0=null;
        Token otherlv_7=null;
        Token lv_hasBracesAroundBody_8_0=null;
        Token otherlv_10=null;
        EObject this_StrictFormalParameters_0 = null;

        EObject this_ColonSepReturnTypeRef_1 = null;

        EObject this_NoLineTerminator_3 = null;

        EObject this_StrictFormalParameters_4 = null;

        EObject this_ColonSepReturnTypeRef_5 = null;

        EObject lv_fpars_6_0 = null;

        EObject lv_body_9_0 = null;

        EObject lv_body_11_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            int alt81=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt81=1;
                }
                break;
            case Async:
                {
                int LA81_2 = input.LA(2);

                if ( (LA81_2==EqualsSignGreaterThanSign) ) {
                    alt81=3;
                }
                else if ( (LA81_2==RULE_NO_LINE_TERMINATOR) && (synpred37_InternalN4JSParser())) {
                    alt81=2;
                }
                else if ( (LA81_2==LeftParenthesis) && (synpred37_InternalN4JSParser())) {
                    alt81=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 81, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case Yield:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt81=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 81, 0, input);

                throw nvae;
            }

            switch (alt81) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getArrowExpressionRule());
                      							}
                      							newCompositeNode(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0());
                      						
                    }
                    pushFollow(FOLLOW_46);
                    this_StrictFormalParameters_0=ruleStrictFormalParameters(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							current = this_StrictFormalParameters_0;
                      							afterParserOrEnumRuleCall();
                      						
                    }
                    int alt79=2;
                    int LA79_0 = input.LA(1);

                    if ( (LA79_0==Colon) ) {
                        alt79=1;
                    }
                    switch (alt79) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElement(grammarAccess.getArrowExpressionRule());
                              								}
                              								newCompositeNode(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1());
                              							
                            }
                            pushFollow(FOLLOW_47);
                            this_ColonSepReturnTypeRef_1=ruleColonSepReturnTypeRef(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								current = this_ColonSepReturnTypeRef_1;
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    {
                    lv_declaredAsync_2_0=(Token)match(input,Async,FOLLOW_48); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      											newLeafNode(lv_declaredAsync_2_0, grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0());
                      										
                    }
                    if ( state.backtracking==0 ) {

                      											if (current==null) {
                      												current = createModelElement(grammarAccess.getArrowExpressionRule());
                      											}
                      											setWithLastConsumed(current, "declaredAsync", true, "async");
                      										
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      									if (current==null) {
                      										current = createModelElement(grammarAccess.getArrowExpressionRule());
                      									}
                      									newCompositeNode(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1());
                      								
                    }
                    pushFollow(FOLLOW_42);
                    this_NoLineTerminator_3=ruleNoLineTerminator(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      									current = this_NoLineTerminator_3;
                      									afterParserOrEnumRuleCall();
                      								
                    }
                    {
                    if ( state.backtracking==0 ) {

                      										if (current==null) {
                      											current = createModelElement(grammarAccess.getArrowExpressionRule());
                      										}
                      										newCompositeNode(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2());
                      									
                    }
                    pushFollow(FOLLOW_46);
                    this_StrictFormalParameters_4=ruleStrictFormalParameters(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      										current = this_StrictFormalParameters_4;
                      										afterParserOrEnumRuleCall();
                      									
                    }

                    }


                    }


                    }
                    int alt80=2;
                    int LA80_0 = input.LA(1);

                    if ( (LA80_0==Colon) ) {
                        alt80=1;
                    }
                    switch (alt80) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElement(grammarAccess.getArrowExpressionRule());
                              								}
                              								newCompositeNode(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1());
                              							
                            }
                            pushFollow(FOLLOW_47);
                            this_ColonSepReturnTypeRef_5=ruleColonSepReturnTypeRef(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								current = this_ColonSepReturnTypeRef_5;
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      								newCompositeNode(grammarAccess.getArrowExpressionAccess().getFparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0());
                      							
                    }
                    pushFollow(FOLLOW_47);
                    lv_fpars_6_0=ruleBindingIdentifierAsFormalParameter();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      								}
                      								add(
                      									current,
                      									"fpars",
                      									lv_fpars_6_0,
                      									"org.eclipse.n4js.N4JS.BindingIdentifierAsFormalParameter");
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }


                    }
                    break;

            }

            otherlv_7=(Token)match(input,EqualsSignGreaterThanSign,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_7, grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1());
              				
            }

            }


            }
            int alt82=2;
            alt82 = dfa82.predict(input);
            switch (alt82) {
                case 1 :
                    {
                    {
                    {
                    {
                    lv_hasBracesAroundBody_8_0=(Token)match(input,LeftCurlyBracket,FOLLOW_50); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(lv_hasBracesAroundBody_8_0, grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0());
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getArrowExpressionRule());
                      							}
                      							setWithLastConsumed(current, "hasBracesAroundBody", true, "{");
                      						
                    }

                    }


                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getArrowExpressionAccess().getBodyBlockMinusBracesParserRuleCall_1_0_1_0());
                      						
                    }
                    pushFollow(FOLLOW_23);
                    lv_body_9_0=ruleBlockMinusBraces();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      							}
                      							set(
                      								current,
                      								"body",
                      								lv_body_9_0,
                      								"org.eclipse.n4js.N4JS.BlockMinusBraces");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }

                    otherlv_10=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_10, grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2());
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getArrowExpressionAccess().getBodyExpressionDisguisedAsBlockParserRuleCall_1_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_body_11_0=ruleExpressionDisguisedAsBlock();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      						}
                      						set(
                      							current,
                      							"body",
                      							lv_body_11_0,
                      							"org.eclipse.n4js.N4JS.ExpressionDisguisedAsBlock");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ArrowExpression() throws RecognitionException {
        EObject current = null;

        Token lv_declaredAsync_2_0=null;
        Token otherlv_7=null;
        Token lv_hasBracesAroundBody_8_0=null;
        Token otherlv_10=null;
        EObject this_StrictFormalParameters_0 = null;

        EObject this_ColonSepReturnTypeRef_1 = null;

        EObject this_NoLineTerminator_3 = null;

        EObject this_StrictFormalParameters_4 = null;

        EObject this_ColonSepReturnTypeRef_5 = null;

        EObject lv_fpars_6_0 = null;

        EObject lv_body_9_0 = null;

        EObject lv_body_11_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            int alt85=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt85=1;
                }
                break;
            case Async:
                {
                int LA85_2 = input.LA(2);

                if ( (LA85_2==EqualsSignGreaterThanSign) ) {
                    alt85=3;
                }
                else if ( (LA85_2==RULE_NO_LINE_TERMINATOR) && (synpred43_InternalN4JSParser())) {
                    alt85=2;
                }
                else if ( (LA85_2==LeftParenthesis) && (synpred43_InternalN4JSParser())) {
                    alt85=2;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 85, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case Yield:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt85=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 85, 0, input);

                throw nvae;
            }

            switch (alt85) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getArrowExpressionRule());
                      							}
                      							newCompositeNode(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0());
                      						
                    }
                    pushFollow(FOLLOW_46);
                    this_StrictFormalParameters_0=ruleStrictFormalParameters(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							current = this_StrictFormalParameters_0;
                      							afterParserOrEnumRuleCall();
                      						
                    }
                    int alt83=2;
                    int LA83_0 = input.LA(1);

                    if ( (LA83_0==Colon) ) {
                        alt83=1;
                    }
                    switch (alt83) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElement(grammarAccess.getArrowExpressionRule());
                              								}
                              								newCompositeNode(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1());
                              							
                            }
                            pushFollow(FOLLOW_47);
                            this_ColonSepReturnTypeRef_1=ruleColonSepReturnTypeRef(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								current = this_ColonSepReturnTypeRef_1;
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    {
                    lv_declaredAsync_2_0=(Token)match(input,Async,FOLLOW_48); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      											newLeafNode(lv_declaredAsync_2_0, grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0());
                      										
                    }
                    if ( state.backtracking==0 ) {

                      											if (current==null) {
                      												current = createModelElement(grammarAccess.getArrowExpressionRule());
                      											}
                      											setWithLastConsumed(current, "declaredAsync", true, "async");
                      										
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      									if (current==null) {
                      										current = createModelElement(grammarAccess.getArrowExpressionRule());
                      									}
                      									newCompositeNode(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1());
                      								
                    }
                    pushFollow(FOLLOW_42);
                    this_NoLineTerminator_3=ruleNoLineTerminator(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      									current = this_NoLineTerminator_3;
                      									afterParserOrEnumRuleCall();
                      								
                    }
                    {
                    if ( state.backtracking==0 ) {

                      										if (current==null) {
                      											current = createModelElement(grammarAccess.getArrowExpressionRule());
                      										}
                      										newCompositeNode(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2());
                      									
                    }
                    pushFollow(FOLLOW_46);
                    this_StrictFormalParameters_4=ruleStrictFormalParameters(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      										current = this_StrictFormalParameters_4;
                      										afterParserOrEnumRuleCall();
                      									
                    }

                    }


                    }


                    }
                    int alt84=2;
                    int LA84_0 = input.LA(1);

                    if ( (LA84_0==Colon) ) {
                        alt84=1;
                    }
                    switch (alt84) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElement(grammarAccess.getArrowExpressionRule());
                              								}
                              								newCompositeNode(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1());
                              							
                            }
                            pushFollow(FOLLOW_47);
                            this_ColonSepReturnTypeRef_5=ruleColonSepReturnTypeRef(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								current = this_ColonSepReturnTypeRef_5;
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      								newCompositeNode(grammarAccess.getArrowExpressionAccess().getFparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0());
                      							
                    }
                    pushFollow(FOLLOW_47);
                    lv_fpars_6_0=ruleBindingIdentifierAsFormalParameter();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      								}
                      								add(
                      									current,
                      									"fpars",
                      									lv_fpars_6_0,
                      									"org.eclipse.n4js.N4JS.BindingIdentifierAsFormalParameter");
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }


                    }
                    break;

            }

            otherlv_7=(Token)match(input,EqualsSignGreaterThanSign,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_7, grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1());
              				
            }

            }


            }
            int alt86=2;
            alt86 = dfa86.predict(input);
            switch (alt86) {
                case 1 :
                    {
                    {
                    {
                    {
                    lv_hasBracesAroundBody_8_0=(Token)match(input,LeftCurlyBracket,FOLLOW_50); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(lv_hasBracesAroundBody_8_0, grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0());
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getArrowExpressionRule());
                      							}
                      							setWithLastConsumed(current, "hasBracesAroundBody", true, "{");
                      						
                    }

                    }


                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getArrowExpressionAccess().getBodyBlockMinusBracesParserRuleCall_1_0_1_0());
                      						
                    }
                    pushFollow(FOLLOW_23);
                    lv_body_9_0=ruleBlockMinusBraces();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      							}
                      							set(
                      								current,
                      								"body",
                      								lv_body_9_0,
                      								"org.eclipse.n4js.N4JS.BlockMinusBraces");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }

                    otherlv_10=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_10, grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2());
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getArrowExpressionAccess().getBodyExpressionDisguisedAsBlockParserRuleCall_1_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_body_11_0=norm1_ExpressionDisguisedAsBlock();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      						}
                      						set(
                      							current,
                      							"body",
                      							lv_body_11_0,
                      							"org.eclipse.n4js.N4JS.ExpressionDisguisedAsBlock");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm2_ArrowExpression() throws RecognitionException {
        EObject current = null;

        Token lv_declaredAsync_2_0=null;
        Token otherlv_7=null;
        Token lv_hasBracesAroundBody_8_0=null;
        Token otherlv_10=null;
        EObject this_StrictFormalParameters_0 = null;

        EObject this_ColonSepReturnTypeRef_1 = null;

        EObject this_NoLineTerminator_3 = null;

        EObject this_StrictFormalParameters_4 = null;

        EObject this_ColonSepReturnTypeRef_5 = null;

        EObject lv_fpars_6_0 = null;

        EObject lv_body_9_0 = null;

        EObject lv_body_11_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            int alt89=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt89=1;
                }
                break;
            case Async:
                {
                int LA89_2 = input.LA(2);

                if ( (LA89_2==RULE_NO_LINE_TERMINATOR) && (synpred49_InternalN4JSParser())) {
                    alt89=2;
                }
                else if ( (LA89_2==LeftParenthesis) && (synpred49_InternalN4JSParser())) {
                    alt89=2;
                }
                else if ( (LA89_2==EqualsSignGreaterThanSign) ) {
                    alt89=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 89, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt89=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 89, 0, input);

                throw nvae;
            }

            switch (alt89) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getArrowExpressionRule());
                      							}
                      							newCompositeNode(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0());
                      						
                    }
                    pushFollow(FOLLOW_46);
                    this_StrictFormalParameters_0=norm1_StrictFormalParameters(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							current = this_StrictFormalParameters_0;
                      							afterParserOrEnumRuleCall();
                      						
                    }
                    int alt87=2;
                    int LA87_0 = input.LA(1);

                    if ( (LA87_0==Colon) ) {
                        alt87=1;
                    }
                    switch (alt87) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElement(grammarAccess.getArrowExpressionRule());
                              								}
                              								newCompositeNode(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1());
                              							
                            }
                            pushFollow(FOLLOW_47);
                            this_ColonSepReturnTypeRef_1=ruleColonSepReturnTypeRef(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								current = this_ColonSepReturnTypeRef_1;
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    {
                    lv_declaredAsync_2_0=(Token)match(input,Async,FOLLOW_51); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      											newLeafNode(lv_declaredAsync_2_0, grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0());
                      										
                    }
                    if ( state.backtracking==0 ) {

                      											if (current==null) {
                      												current = createModelElement(grammarAccess.getArrowExpressionRule());
                      											}
                      											setWithLastConsumed(current, "declaredAsync", true, "async");
                      										
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      									if (current==null) {
                      										current = createModelElement(grammarAccess.getArrowExpressionRule());
                      									}
                      									newCompositeNode(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1());
                      								
                    }
                    pushFollow(FOLLOW_39);
                    this_NoLineTerminator_3=ruleNoLineTerminator(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      									current = this_NoLineTerminator_3;
                      									afterParserOrEnumRuleCall();
                      								
                    }
                    {
                    if ( state.backtracking==0 ) {

                      										if (current==null) {
                      											current = createModelElement(grammarAccess.getArrowExpressionRule());
                      										}
                      										newCompositeNode(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2());
                      									
                    }
                    pushFollow(FOLLOW_46);
                    this_StrictFormalParameters_4=norm1_StrictFormalParameters(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      										current = this_StrictFormalParameters_4;
                      										afterParserOrEnumRuleCall();
                      									
                    }

                    }


                    }


                    }
                    int alt88=2;
                    int LA88_0 = input.LA(1);

                    if ( (LA88_0==Colon) ) {
                        alt88=1;
                    }
                    switch (alt88) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElement(grammarAccess.getArrowExpressionRule());
                              								}
                              								newCompositeNode(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1());
                              							
                            }
                            pushFollow(FOLLOW_47);
                            this_ColonSepReturnTypeRef_5=ruleColonSepReturnTypeRef(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								current = this_ColonSepReturnTypeRef_5;
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      								newCompositeNode(grammarAccess.getArrowExpressionAccess().getFparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0());
                      							
                    }
                    pushFollow(FOLLOW_47);
                    lv_fpars_6_0=norm1_BindingIdentifierAsFormalParameter();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      								}
                      								add(
                      									current,
                      									"fpars",
                      									lv_fpars_6_0,
                      									"org.eclipse.n4js.N4JS.BindingIdentifierAsFormalParameter");
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }


                    }
                    break;

            }

            otherlv_7=(Token)match(input,EqualsSignGreaterThanSign,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_7, grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1());
              				
            }

            }


            }
            int alt90=2;
            alt90 = dfa90.predict(input);
            switch (alt90) {
                case 1 :
                    {
                    {
                    {
                    {
                    lv_hasBracesAroundBody_8_0=(Token)match(input,LeftCurlyBracket,FOLLOW_52); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(lv_hasBracesAroundBody_8_0, grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0());
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getArrowExpressionRule());
                      							}
                      							setWithLastConsumed(current, "hasBracesAroundBody", true, "{");
                      						
                    }

                    }


                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getArrowExpressionAccess().getBodyBlockMinusBracesParserRuleCall_1_0_1_0());
                      						
                    }
                    pushFollow(FOLLOW_23);
                    lv_body_9_0=norm1_BlockMinusBraces();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      							}
                      							set(
                      								current,
                      								"body",
                      								lv_body_9_0,
                      								"org.eclipse.n4js.N4JS.BlockMinusBraces");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }

                    otherlv_10=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_10, grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2());
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getArrowExpressionAccess().getBodyExpressionDisguisedAsBlockParserRuleCall_1_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_body_11_0=ruleExpressionDisguisedAsBlock();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      						}
                      						set(
                      							current,
                      							"body",
                      							lv_body_11_0,
                      							"org.eclipse.n4js.N4JS.ExpressionDisguisedAsBlock");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm3_ArrowExpression() throws RecognitionException {
        EObject current = null;

        Token lv_declaredAsync_2_0=null;
        Token otherlv_7=null;
        Token lv_hasBracesAroundBody_8_0=null;
        Token otherlv_10=null;
        EObject this_StrictFormalParameters_0 = null;

        EObject this_ColonSepReturnTypeRef_1 = null;

        EObject this_NoLineTerminator_3 = null;

        EObject this_StrictFormalParameters_4 = null;

        EObject this_ColonSepReturnTypeRef_5 = null;

        EObject lv_fpars_6_0 = null;

        EObject lv_body_9_0 = null;

        EObject lv_body_11_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            int alt93=3;
            switch ( input.LA(1) ) {
            case LeftParenthesis:
                {
                alt93=1;
                }
                break;
            case Async:
                {
                int LA93_2 = input.LA(2);

                if ( (LA93_2==RULE_NO_LINE_TERMINATOR) && (synpred55_InternalN4JSParser())) {
                    alt93=2;
                }
                else if ( (LA93_2==LeftParenthesis) && (synpred55_InternalN4JSParser())) {
                    alt93=2;
                }
                else if ( (LA93_2==EqualsSignGreaterThanSign) ) {
                    alt93=3;
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return current;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 93, 2, input);

                    throw nvae;
                }
                }
                break;
            case Intersection:
            case Constructor:
            case Implements:
            case Promisify:
            case Interface:
            case Protected:
            case Abstract:
            case External:
            case Private:
            case Project:
            case Public:
            case Static:
            case Target:
            case Await:
            case Union:
            case This:
            case From:
            case Type:
            case Get:
            case Let:
            case Out:
            case Set:
            case As:
            case Of:
            case RULE_IDENTIFIER:
                {
                alt93=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 93, 0, input);

                throw nvae;
            }

            switch (alt93) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getArrowExpressionRule());
                      							}
                      							newCompositeNode(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_0_0());
                      						
                    }
                    pushFollow(FOLLOW_46);
                    this_StrictFormalParameters_0=norm1_StrictFormalParameters(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							current = this_StrictFormalParameters_0;
                      							afterParserOrEnumRuleCall();
                      						
                    }
                    int alt91=2;
                    int LA91_0 = input.LA(1);

                    if ( (LA91_0==Colon) ) {
                        alt91=1;
                    }
                    switch (alt91) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElement(grammarAccess.getArrowExpressionRule());
                              								}
                              								newCompositeNode(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_0_1());
                              							
                            }
                            pushFollow(FOLLOW_47);
                            this_ColonSepReturnTypeRef_1=ruleColonSepReturnTypeRef(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								current = this_ColonSepReturnTypeRef_1;
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    {
                    lv_declaredAsync_2_0=(Token)match(input,Async,FOLLOW_51); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      											newLeafNode(lv_declaredAsync_2_0, grammarAccess.getArrowExpressionAccess().getDeclaredAsyncAsyncKeyword_0_0_0_1_0_0_0_0());
                      										
                    }
                    if ( state.backtracking==0 ) {

                      											if (current==null) {
                      												current = createModelElement(grammarAccess.getArrowExpressionRule());
                      											}
                      											setWithLastConsumed(current, "declaredAsync", true, "async");
                      										
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      									if (current==null) {
                      										current = createModelElement(grammarAccess.getArrowExpressionRule());
                      									}
                      									newCompositeNode(grammarAccess.getArrowExpressionAccess().getNoLineTerminatorParserRuleCall_0_0_0_1_0_0_1());
                      								
                    }
                    pushFollow(FOLLOW_39);
                    this_NoLineTerminator_3=ruleNoLineTerminator(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      									current = this_NoLineTerminator_3;
                      									afterParserOrEnumRuleCall();
                      								
                    }
                    {
                    if ( state.backtracking==0 ) {

                      										if (current==null) {
                      											current = createModelElement(grammarAccess.getArrowExpressionRule());
                      										}
                      										newCompositeNode(grammarAccess.getArrowExpressionAccess().getStrictFormalParametersParserRuleCall_0_0_0_1_0_0_2());
                      									
                    }
                    pushFollow(FOLLOW_46);
                    this_StrictFormalParameters_4=norm1_StrictFormalParameters(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      										current = this_StrictFormalParameters_4;
                      										afterParserOrEnumRuleCall();
                      									
                    }

                    }


                    }


                    }
                    int alt92=2;
                    int LA92_0 = input.LA(1);

                    if ( (LA92_0==Colon) ) {
                        alt92=1;
                    }
                    switch (alt92) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              								if (current==null) {
                              									current = createModelElement(grammarAccess.getArrowExpressionRule());
                              								}
                              								newCompositeNode(grammarAccess.getArrowExpressionAccess().getColonSepReturnTypeRefParserRuleCall_0_0_0_1_1());
                              							
                            }
                            pushFollow(FOLLOW_47);
                            this_ColonSepReturnTypeRef_5=ruleColonSepReturnTypeRef(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              								current = this_ColonSepReturnTypeRef_5;
                              								afterParserOrEnumRuleCall();
                              							
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      								newCompositeNode(grammarAccess.getArrowExpressionAccess().getFparsBindingIdentifierAsFormalParameterParserRuleCall_0_0_0_2_0());
                      							
                    }
                    pushFollow(FOLLOW_47);
                    lv_fpars_6_0=norm1_BindingIdentifierAsFormalParameter();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      								}
                      								add(
                      									current,
                      									"fpars",
                      									lv_fpars_6_0,
                      									"org.eclipse.n4js.N4JS.BindingIdentifierAsFormalParameter");
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }


                    }
                    break;

            }

            otherlv_7=(Token)match(input,EqualsSignGreaterThanSign,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_7, grammarAccess.getArrowExpressionAccess().getEqualsSignGreaterThanSignKeyword_0_0_1());
              				
            }

            }


            }
            int alt94=2;
            alt94 = dfa94.predict(input);
            switch (alt94) {
                case 1 :
                    {
                    {
                    {
                    {
                    lv_hasBracesAroundBody_8_0=(Token)match(input,LeftCurlyBracket,FOLLOW_52); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							newLeafNode(lv_hasBracesAroundBody_8_0, grammarAccess.getArrowExpressionAccess().getHasBracesAroundBodyLeftCurlyBracketKeyword_1_0_0_0());
                      						
                    }
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getArrowExpressionRule());
                      							}
                      							setWithLastConsumed(current, "hasBracesAroundBody", true, "{");
                      						
                    }

                    }


                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getArrowExpressionAccess().getBodyBlockMinusBracesParserRuleCall_1_0_1_0());
                      						
                    }
                    pushFollow(FOLLOW_23);
                    lv_body_9_0=norm1_BlockMinusBraces();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      							}
                      							set(
                      								current,
                      								"body",
                      								lv_body_9_0,
                      								"org.eclipse.n4js.N4JS.BlockMinusBraces");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }

                    otherlv_10=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_10, grammarAccess.getArrowExpressionAccess().getRightCurlyBracketKeyword_1_0_2());
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getArrowExpressionAccess().getBodyExpressionDisguisedAsBlockParserRuleCall_1_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_body_11_0=norm1_ExpressionDisguisedAsBlock();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getArrowExpressionRule());
                      						}
                      						set(
                      							current,
                      							"body",
                      							lv_body_11_0,
                      							"org.eclipse.n4js.N4JS.ExpressionDisguisedAsBlock");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleStrictFormalParameters(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        EObject lv_fpars_1_0 = null;

        EObject lv_fpars_3_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,LeftParenthesis,FOLLOW_53); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getStrictFormalParametersAccess().getLeftParenthesisKeyword_0());
              		
            }
            int alt96=2;
            int LA96_0 = input.LA(1);

            if ( ((LA96_0>=Intersection && LA96_0<=Implements)||(LA96_0>=Promisify && LA96_0<=Abstract)||LA96_0==External||LA96_0==Default||(LA96_0>=Private && LA96_0<=Project)||LA96_0==Public||LA96_0==Static||LA96_0==Target||(LA96_0>=Async && LA96_0<=Await)||LA96_0==Union||(LA96_0>=Yield && LA96_0<=This)||LA96_0==From||LA96_0==This_1||(LA96_0>=Type && LA96_0<=Void)||LA96_0==FullStopFullStopFullStop||(LA96_0>=Get && LA96_0<=Let)||(LA96_0>=Out && LA96_0<=Set)||LA96_0==As||LA96_0==Of||(LA96_0>=CommercialAt && LA96_0<=LeftSquareBracket)||LA96_0==LeftCurlyBracket||LA96_0==Tilde||LA96_0==RULE_IDENTIFIER) ) {
                alt96=1;
            }
            switch (alt96) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getStrictFormalParametersAccess().getFparsFormalParameterParserRuleCall_1_0_0());
                      					
                    }
                    pushFollow(FOLLOW_54);
                    lv_fpars_1_0=ruleFormalParameter();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getStrictFormalParametersRule());
                      						}
                      						add(
                      							current,
                      							"fpars",
                      							lv_fpars_1_0,
                      							"org.eclipse.n4js.N4JS.FormalParameter");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }
                    loop95:
                    do {
                        int alt95=2;
                        int LA95_0 = input.LA(1);

                        if ( (LA95_0==Comma) ) {
                            alt95=1;
                        }


                        switch (alt95) {
                    	case 1 :
                    	    {
                    	    otherlv_2=(Token)match(input,Comma,FOLLOW_55); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_2, grammarAccess.getStrictFormalParametersAccess().getCommaKeyword_1_1_0());
                    	      				
                    	    }
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getStrictFormalParametersAccess().getFparsFormalParameterParserRuleCall_1_1_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_54);
                    	    lv_fpars_3_0=ruleFormalParameter();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getStrictFormalParametersRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"fpars",
                    	      								lv_fpars_3_0,
                    	      								"org.eclipse.n4js.N4JS.FormalParameter");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop95;
                        }
                    } while (true);


                    }
                    break;

            }

            otherlv_4=(Token)match(input,RightParenthesis,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_4, grammarAccess.getStrictFormalParametersAccess().getRightParenthesisKeyword_2());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_StrictFormalParameters(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        EObject lv_fpars_1_0 = null;

        EObject lv_fpars_3_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,LeftParenthesis,FOLLOW_53); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getStrictFormalParametersAccess().getLeftParenthesisKeyword_0());
              		
            }
            int alt98=2;
            int LA98_0 = input.LA(1);

            if ( ((LA98_0>=Intersection && LA98_0<=Implements)||(LA98_0>=Promisify && LA98_0<=Abstract)||LA98_0==External||LA98_0==Default||(LA98_0>=Private && LA98_0<=Project)||LA98_0==Public||LA98_0==Static||LA98_0==Target||(LA98_0>=Async && LA98_0<=Await)||LA98_0==Union||LA98_0==This||LA98_0==From||LA98_0==This_1||(LA98_0>=Type && LA98_0<=Void)||LA98_0==FullStopFullStopFullStop||(LA98_0>=Get && LA98_0<=Let)||(LA98_0>=Out && LA98_0<=Set)||LA98_0==As||LA98_0==Of||(LA98_0>=CommercialAt && LA98_0<=LeftSquareBracket)||LA98_0==LeftCurlyBracket||LA98_0==Tilde||LA98_0==RULE_IDENTIFIER) ) {
                alt98=1;
            }
            switch (alt98) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getStrictFormalParametersAccess().getFparsFormalParameterParserRuleCall_1_0_0());
                      					
                    }
                    pushFollow(FOLLOW_54);
                    lv_fpars_1_0=norm1_FormalParameter();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getStrictFormalParametersRule());
                      						}
                      						add(
                      							current,
                      							"fpars",
                      							lv_fpars_1_0,
                      							"org.eclipse.n4js.N4JS.FormalParameter");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }
                    loop97:
                    do {
                        int alt97=2;
                        int LA97_0 = input.LA(1);

                        if ( (LA97_0==Comma) ) {
                            alt97=1;
                        }


                        switch (alt97) {
                    	case 1 :
                    	    {
                    	    otherlv_2=(Token)match(input,Comma,FOLLOW_55); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_2, grammarAccess.getStrictFormalParametersAccess().getCommaKeyword_1_1_0());
                    	      				
                    	    }
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getStrictFormalParametersAccess().getFparsFormalParameterParserRuleCall_1_1_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_54);
                    	    lv_fpars_3_0=norm1_FormalParameter();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getStrictFormalParametersRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"fpars",
                    	      								lv_fpars_3_0,
                    	      								"org.eclipse.n4js.N4JS.FormalParameter");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop97;
                        }
                    } while (true);


                    }
                    break;

            }

            otherlv_4=(Token)match(input,RightParenthesis,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_4, grammarAccess.getStrictFormalParametersAccess().getRightParenthesisKeyword_2());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleBindingIdentifierAsFormalParameter() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleBindingIdentifierAsFormalParameter = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getBindingIdentifierAsFormalParameterRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleBindingIdentifierAsFormalParameter=ruleBindingIdentifierAsFormalParameter();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleBindingIdentifierAsFormalParameter; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleBindingIdentifierAsFormalParameter() throws RecognitionException {
        EObject current = null;

        AntlrDatatypeRuleToken lv_name_0_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameBindingIdentifierParserRuleCall_0());
              			
            }
            pushFollow(FOLLOW_2);
            lv_name_0_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				if (current==null) {
              					current = createModelElementForParent(grammarAccess.getBindingIdentifierAsFormalParameterRule());
              				}
              				set(
              					current,
              					"name",
              					lv_name_0_0,
              					"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              				afterParserOrEnumRuleCall();
              			
            }

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_BindingIdentifierAsFormalParameter() throws RecognitionException {
        EObject current = null;

        AntlrDatatypeRuleToken lv_name_0_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameBindingIdentifierParserRuleCall_0());
              			
            }
            pushFollow(FOLLOW_2);
            lv_name_0_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				if (current==null) {
              					current = createModelElementForParent(grammarAccess.getBindingIdentifierAsFormalParameterRule());
              				}
              				set(
              					current,
              					"name",
              					lv_name_0_0,
              					"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              				afterParserOrEnumRuleCall();
              			
            }

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleBlockMinusBraces() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleBlockMinusBraces = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getBlockMinusBracesRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleBlockMinusBraces=ruleBlockMinusBraces();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleBlockMinusBraces; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleBlockMinusBraces() throws RecognitionException {
        EObject current = null;

        EObject lv_statements_1_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getBlockMinusBracesAccess().getBlockAction_0(),
              					current);
              			
            }

            }
            loop99:
            do {
                int alt99=2;
                int LA99_0 = input.LA(1);

                if ( ((LA99_0>=Intersection && LA99_0<=Implements)||(LA99_0>=Promisify && LA99_0<=Function)||(LA99_0>=Private && LA99_0<=Delete)||(LA99_0>=Import && LA99_0<=Break)||(LA99_0>=Class && LA99_0<=This)||(LA99_0>=From && LA99_0<=With)||(LA99_0>=For && LA99_0<=Var)||LA99_0==PlusSignPlusSign||LA99_0==HyphenMinusHyphenMinus||LA99_0==SolidusEqualsSign||(LA99_0>=As && LA99_0<=If)||LA99_0==Of||LA99_0==ExclamationMark||LA99_0==LeftParenthesis||LA99_0==PlusSign||LA99_0==HyphenMinus||LA99_0==Solidus||(LA99_0>=Semicolon && LA99_0<=LessThanSign)||(LA99_0>=CommercialAt && LA99_0<=LeftSquareBracket)||LA99_0==LeftCurlyBracket||LA99_0==Tilde||LA99_0==RULE_DOUBLE||(LA99_0>=RULE_HEX_INT && LA99_0<=RULE_LEGACY_OCTAL_INT)||LA99_0==RULE_SCIENTIFIC_INT||LA99_0==RULE_IDENTIFIER||LA99_0==RULE_STRING||(LA99_0>=RULE_TEMPLATE_HEAD && LA99_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA99_0==RULE_INT) ) {
                    alt99=1;
                }


                switch (alt99) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getBlockMinusBracesAccess().getStatementsStatementParserRuleCall_1_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_3);
            	    lv_statements_1_0=ruleStatement();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getBlockMinusBracesRule());
            	      					}
            	      					add(
            	      						current,
            	      						"statements",
            	      						lv_statements_1_0,
            	      						"org.eclipse.n4js.N4JS.Statement");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop99;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_BlockMinusBraces() throws RecognitionException {
        EObject current = null;

        EObject lv_statements_1_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getBlockMinusBracesAccess().getBlockAction_0(),
              					current);
              			
            }

            }
            loop100:
            do {
                int alt100=2;
                int LA100_0 = input.LA(1);

                if ( ((LA100_0>=Intersection && LA100_0<=Implements)||(LA100_0>=Promisify && LA100_0<=Function)||(LA100_0>=Private && LA100_0<=Delete)||(LA100_0>=Import && LA100_0<=Break)||(LA100_0>=Class && LA100_0<=This)||(LA100_0>=From && LA100_0<=With)||(LA100_0>=For && LA100_0<=Var)||LA100_0==PlusSignPlusSign||LA100_0==HyphenMinusHyphenMinus||LA100_0==SolidusEqualsSign||(LA100_0>=As && LA100_0<=If)||LA100_0==Of||LA100_0==ExclamationMark||LA100_0==LeftParenthesis||LA100_0==PlusSign||LA100_0==HyphenMinus||LA100_0==Solidus||(LA100_0>=Semicolon && LA100_0<=LessThanSign)||(LA100_0>=CommercialAt && LA100_0<=LeftSquareBracket)||LA100_0==LeftCurlyBracket||LA100_0==Tilde||LA100_0==RULE_DOUBLE||(LA100_0>=RULE_HEX_INT && LA100_0<=RULE_LEGACY_OCTAL_INT)||LA100_0==RULE_SCIENTIFIC_INT||LA100_0==RULE_IDENTIFIER||LA100_0==RULE_STRING||(LA100_0>=RULE_TEMPLATE_HEAD && LA100_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA100_0==RULE_INT) ) {
                    alt100=1;
                }


                switch (alt100) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getBlockMinusBracesAccess().getStatementsStatementParserRuleCall_1_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_56);
            	    lv_statements_1_0=norm1_Statement();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getBlockMinusBracesRule());
            	      					}
            	      					add(
            	      						current,
            	      						"statements",
            	      						lv_statements_1_0,
            	      						"org.eclipse.n4js.N4JS.Statement");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop100;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleExpressionDisguisedAsBlock() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleExpressionDisguisedAsBlock = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getExpressionDisguisedAsBlockRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleExpressionDisguisedAsBlock=ruleExpressionDisguisedAsBlock();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleExpressionDisguisedAsBlock; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExpressionDisguisedAsBlock() throws RecognitionException {
        EObject current = null;

        EObject lv_statements_1_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getExpressionDisguisedAsBlockAccess().getBlockAction_0(),
              					current);
              			
            }

            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExpressionDisguisedAsBlockAccess().getStatementsAssignmentExpressionStatementParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_statements_1_0=ruleAssignmentExpressionStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getExpressionDisguisedAsBlockRule());
              					}
              					add(
              						current,
              						"statements",
              						lv_statements_1_0,
              						"org.eclipse.n4js.N4JS.AssignmentExpressionStatement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ExpressionDisguisedAsBlock() throws RecognitionException {
        EObject current = null;

        EObject lv_statements_1_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getExpressionDisguisedAsBlockAccess().getBlockAction_0(),
              					current);
              			
            }

            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExpressionDisguisedAsBlockAccess().getStatementsAssignmentExpressionStatementParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_statements_1_0=norm1_AssignmentExpressionStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getExpressionDisguisedAsBlockRule());
              					}
              					add(
              						current,
              						"statements",
              						lv_statements_1_0,
              						"org.eclipse.n4js.N4JS.AssignmentExpressionStatement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleAssignmentExpressionStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleAssignmentExpressionStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getAssignmentExpressionStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleAssignmentExpressionStatement=ruleAssignmentExpressionStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleAssignmentExpressionStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleAssignmentExpressionStatement() throws RecognitionException {
        EObject current = null;

        EObject lv_expression_0_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignmentExpressionParserRuleCall_0());
              			
            }
            pushFollow(FOLLOW_2);
            lv_expression_0_0=ruleAssignmentExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				if (current==null) {
              					current = createModelElementForParent(grammarAccess.getAssignmentExpressionStatementRule());
              				}
              				set(
              					current,
              					"expression",
              					lv_expression_0_0,
              					"org.eclipse.n4js.N4JS.AssignmentExpression");
              				afterParserOrEnumRuleCall();
              			
            }

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_AssignmentExpressionStatement() throws RecognitionException {
        EObject current = null;

        EObject lv_expression_0_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignmentExpressionParserRuleCall_0());
              			
            }
            pushFollow(FOLLOW_2);
            lv_expression_0_0=norm1_AssignmentExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				if (current==null) {
              					current = createModelElementForParent(grammarAccess.getAssignmentExpressionStatementRule());
              				}
              				set(
              					current,
              					"expression",
              					lv_expression_0_0,
              					"org.eclipse.n4js.N4JS.AssignmentExpression");
              				afterParserOrEnumRuleCall();
              			
            }

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleAnnotatedExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleAnnotatedExpression = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getAnnotatedExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleAnnotatedExpression=ruleAnnotatedExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleAnnotatedExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleAnnotatedExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_2=null;
        EObject this_ExpressionAnnotationList_0 = null;

        AntlrDatatypeRuleToken lv_name_3_0 = null;

        EObject this_ClassExtendsImplements_4 = null;

        EObject this_Members_5 = null;

        EObject this_AsyncNoTrailingLineBreak_7 = null;

        EObject this_FunctionImpl_8 = null;



        	enterRule();

        try {
            {
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getExpressionAnnotationListParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_57);
            this_ExpressionAnnotationList_0=ruleExpressionAnnotationList();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_ExpressionAnnotationList_0;
              			afterParserOrEnumRuleCall();
              		
            }
            int alt103=2;
            int LA103_0 = input.LA(1);

            if ( (LA103_0==Class) ) {
                alt103=1;
            }
            else if ( (LA103_0==Function||LA103_0==Async) ) {
                alt103=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 103, 0, input);

                throw nvae;
            }
            switch (alt103) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getAnnotatedExpressionAccess().getN4ClassExpressionAnnotationListAction_1_0_0(),
                      							current);
                      					
                    }

                    }

                    otherlv_2=(Token)match(input,Class,FOLLOW_58); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_2, grammarAccess.getAnnotatedExpressionAccess().getClassKeyword_1_0_1());
                      				
                    }
                    int alt101=2;
                    int LA101_0 = input.LA(1);

                    if ( ((LA101_0>=Intersection && LA101_0<=Constructor)||(LA101_0>=Promisify && LA101_0<=Abstract)||LA101_0==External||(LA101_0>=Private && LA101_0<=Project)||LA101_0==Public||LA101_0==Static||LA101_0==Target||(LA101_0>=Async && LA101_0<=Await)||LA101_0==Union||(LA101_0>=Yield && LA101_0<=This)||LA101_0==From||LA101_0==Type||(LA101_0>=Get && LA101_0<=Let)||(LA101_0>=Out && LA101_0<=Set)||LA101_0==As||LA101_0==Of||LA101_0==RULE_IDENTIFIER) ) {
                        alt101=1;
                    }
                    else if ( (LA101_0==Implements) ) {
                        int LA101_2 = input.LA(2);

                        if ( (LA101_2==Implements||LA101_2==Extends||LA101_2==LeftCurlyBracket) ) {
                            alt101=1;
                        }
                    }
                    switch (alt101) {
                        case 1 :
                            {
                            {
                            if ( state.backtracking==0 ) {

                              							newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getNameBindingIdentifierParserRuleCall_1_0_2_0());
                              						
                            }
                            pushFollow(FOLLOW_9);
                            lv_name_3_0=ruleBindingIdentifier();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElementForParent(grammarAccess.getAnnotatedExpressionRule());
                              							}
                              							set(
                              								current,
                              								"name",
                              								lv_name_3_0,
                              								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                              							afterParserOrEnumRuleCall();
                              						
                            }

                            }


                            }
                            break;

                    }
                    int alt102=2;
                    int LA102_0 = input.LA(1);

                    if ( (LA102_0==Implements||LA102_0==Extends) ) {
                        alt102=1;
                    }
                    switch (alt102) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              						if (current==null) {
                              							current = createModelElement(grammarAccess.getAnnotatedExpressionRule());
                              						}
                              						newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getClassExtendsImplementsParserRuleCall_1_0_3());
                              					
                            }
                            pushFollow(FOLLOW_9);
                            this_ClassExtendsImplements_4=ruleClassExtendsImplements(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              						current = this_ClassExtendsImplements_4;
                              						afterParserOrEnumRuleCall();
                              					
                            }

                            }
                            break;

                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedExpressionRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getMembersParserRuleCall_1_0_4());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_Members_5=ruleMembers(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_Members_5;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getAnnotatedExpressionAccess().getFunctionExpressionAnnotationListAction_1_1_0(),
                      							current);
                      					
                    }

                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedExpressionRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_1_1());
                      				
                    }
                    pushFollow(FOLLOW_45);
                    this_AsyncNoTrailingLineBreak_7=ruleAsyncNoTrailingLineBreak(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_AsyncNoTrailingLineBreak_7;
                      					afterParserOrEnumRuleCall();
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedExpressionRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getFunctionImplParserRuleCall_1_1_2());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionImpl_8=norm6_FunctionImpl(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionImpl_8;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_AnnotatedExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_2=null;
        EObject this_ExpressionAnnotationList_0 = null;

        AntlrDatatypeRuleToken lv_name_3_0 = null;

        EObject this_ClassExtendsImplements_4 = null;

        EObject this_Members_5 = null;

        EObject this_AsyncNoTrailingLineBreak_7 = null;

        EObject this_FunctionImpl_8 = null;



        	enterRule();

        try {
            {
            {
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getExpressionAnnotationListParserRuleCall_0());
              		
            }
            pushFollow(FOLLOW_57);
            this_ExpressionAnnotationList_0=ruleExpressionAnnotationList();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_ExpressionAnnotationList_0;
              			afterParserOrEnumRuleCall();
              		
            }
            int alt106=2;
            int LA106_0 = input.LA(1);

            if ( (LA106_0==Class) ) {
                alt106=1;
            }
            else if ( (LA106_0==Function||LA106_0==Async) ) {
                alt106=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 106, 0, input);

                throw nvae;
            }
            switch (alt106) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getAnnotatedExpressionAccess().getN4ClassExpressionAnnotationListAction_1_0_0(),
                      							current);
                      					
                    }

                    }

                    otherlv_2=(Token)match(input,Class,FOLLOW_59); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_2, grammarAccess.getAnnotatedExpressionAccess().getClassKeyword_1_0_1());
                      				
                    }
                    int alt104=2;
                    int LA104_0 = input.LA(1);

                    if ( ((LA104_0>=Intersection && LA104_0<=Constructor)||(LA104_0>=Promisify && LA104_0<=Abstract)||LA104_0==External||(LA104_0>=Private && LA104_0<=Project)||LA104_0==Public||LA104_0==Static||LA104_0==Target||(LA104_0>=Async && LA104_0<=Await)||LA104_0==Union||LA104_0==This||LA104_0==From||LA104_0==Type||(LA104_0>=Get && LA104_0<=Let)||(LA104_0>=Out && LA104_0<=Set)||LA104_0==As||LA104_0==Of||LA104_0==RULE_IDENTIFIER) ) {
                        alt104=1;
                    }
                    else if ( (LA104_0==Implements) ) {
                        int LA104_2 = input.LA(2);

                        if ( (LA104_2==Implements||LA104_2==Extends||LA104_2==LeftCurlyBracket) ) {
                            alt104=1;
                        }
                    }
                    switch (alt104) {
                        case 1 :
                            {
                            {
                            if ( state.backtracking==0 ) {

                              							newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getNameBindingIdentifierParserRuleCall_1_0_2_0());
                              						
                            }
                            pushFollow(FOLLOW_59);
                            lv_name_3_0=norm1_BindingIdentifier();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElementForParent(grammarAccess.getAnnotatedExpressionRule());
                              							}
                              							set(
                              								current,
                              								"name",
                              								lv_name_3_0,
                              								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                              							afterParserOrEnumRuleCall();
                              						
                            }

                            }


                            }
                            break;

                    }
                    int alt105=2;
                    int LA105_0 = input.LA(1);

                    if ( (LA105_0==Implements||LA105_0==Extends) ) {
                        alt105=1;
                    }
                    switch (alt105) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              						if (current==null) {
                              							current = createModelElement(grammarAccess.getAnnotatedExpressionRule());
                              						}
                              						newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getClassExtendsImplementsParserRuleCall_1_0_3());
                              					
                            }
                            pushFollow(FOLLOW_59);
                            this_ClassExtendsImplements_4=norm1_ClassExtendsImplements(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              						current = this_ClassExtendsImplements_4;
                              						afterParserOrEnumRuleCall();
                              					
                            }

                            }
                            break;

                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedExpressionRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getMembersParserRuleCall_1_0_4());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_Members_5=norm1_Members(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_Members_5;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						current = forceCreateModelElementAndSet(
                      							grammarAccess.getAnnotatedExpressionAccess().getFunctionExpressionAnnotationListAction_1_1_0(),
                      							current);
                      					
                    }

                    }

                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedExpressionRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getAsyncNoTrailingLineBreakParserRuleCall_1_1_1());
                      				
                    }
                    pushFollow(FOLLOW_45);
                    this_AsyncNoTrailingLineBreak_7=ruleAsyncNoTrailingLineBreak(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_AsyncNoTrailingLineBreak_7;
                      					afterParserOrEnumRuleCall();
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getAnnotatedExpressionRule());
                      					}
                      					newCompositeNode(grammarAccess.getAnnotatedExpressionAccess().getFunctionImplParserRuleCall_1_1_2());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionImpl_8=norm6_FunctionImpl(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					current = this_FunctionImpl_8;
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleTypeVariable() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleTypeVariable = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getTypeVariableRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleTypeVariable=ruleTypeVariable();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleTypeVariable; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleTypeVariable() throws RecognitionException {
        EObject current = null;

        Token lv_declaredCovariant_0_0=null;
        Token lv_declaredContravariant_1_0=null;
        Token otherlv_3=null;
        AntlrDatatypeRuleToken lv_name_2_0 = null;

        EObject lv_declaredUpperBound_4_0 = null;



        	enterRule();

        try {
            {
            {
            int alt107=3;
            int LA107_0 = input.LA(1);

            if ( (LA107_0==Out) ) {
                alt107=1;
            }
            else if ( (LA107_0==In) ) {
                alt107=2;
            }
            switch (alt107) {
                case 1 :
                    {
                    {
                    {
                    lv_declaredCovariant_0_0=(Token)match(input,Out,FOLLOW_60); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_declaredCovariant_0_0, grammarAccess.getTypeVariableAccess().getDeclaredCovariantOutKeyword_0_0_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getTypeVariableRule());
                      						}
                      						setWithLastConsumed(current, "declaredCovariant", true, "out");
                      					
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    lv_declaredContravariant_1_0=(Token)match(input,In,FOLLOW_60); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_declaredContravariant_1_0, grammarAccess.getTypeVariableAccess().getDeclaredContravariantInKeyword_0_1_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getTypeVariableRule());
                      						}
                      						setWithLastConsumed(current, "declaredContravariant", true, "in");
                      					
                    }

                    }


                    }


                    }
                    break;

            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getTypeVariableAccess().getNameIdentifierOrThisParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_61);
            lv_name_2_0=ruleIdentifierOrThis();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getTypeVariableRule());
              					}
              					set(
              						current,
              						"name",
              						lv_name_2_0,
              						"org.eclipse.n4js.N4JS.IdentifierOrThis");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            int alt108=2;
            int LA108_0 = input.LA(1);

            if ( (LA108_0==Extends) ) {
                alt108=1;
            }
            switch (alt108) {
                case 1 :
                    {
                    otherlv_3=(Token)match(input,Extends,FOLLOW_62); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_3, grammarAccess.getTypeVariableAccess().getExtendsKeyword_2_0());
                      			
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getTypeVariableAccess().getDeclaredUpperBoundTypeRefParserRuleCall_2_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_declaredUpperBound_4_0=ruleTypeRef();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getTypeVariableRule());
                      						}
                      						set(
                      							current,
                      							"declaredUpperBound",
                      							lv_declaredUpperBound_4_0,
                      							"org.eclipse.n4js.ts.TypeExpressions.TypeRef");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleFormalParameter() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleFormalParameter = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getFormalParameterRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleFormalParameter=ruleFormalParameter();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleFormalParameter; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleFormalParameter() throws RecognitionException {
        EObject current = null;

        EObject this_BindingElementFragment_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getFormalParameterAccess().getFormalParameterAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getFormalParameterRule());
              			}
              			newCompositeNode(grammarAccess.getFormalParameterAccess().getBindingElementFragmentParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_BindingElementFragment_1=ruleBindingElementFragment(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_BindingElementFragment_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_FormalParameter() throws RecognitionException {
        EObject current = null;

        EObject this_BindingElementFragment_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getFormalParameterAccess().getFormalParameterAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getFormalParameterRule());
              			}
              			newCompositeNode(grammarAccess.getFormalParameterAccess().getBindingElementFragmentParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_BindingElementFragment_1=norm1_BindingElementFragment(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_BindingElementFragment_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleBindingElementFragment(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token lv_variadic_3_0=null;
        Token lv_hasInitializerAssignment_6_0=null;
        EObject lv_bindingPattern_0_0 = null;

        EObject lv_annotations_1_0 = null;

        EObject this_BogusTypeRefFragment_2 = null;

        AntlrDatatypeRuleToken lv_name_4_0 = null;

        EObject this_ColonSepDeclaredTypeRef_5 = null;

        EObject lv_initializer_7_0 = null;



        	enterRule();

        try {
            {
            {
            int alt113=2;
            alt113 = dfa113.predict(input);
            switch (alt113) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getBindingPatternBindingPatternParserRuleCall_0_0_0());
                      					
                    }
                    pushFollow(FOLLOW_63);
                    lv_bindingPattern_0_0=ruleBindingPattern();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getBindingElementFragmentRule());
                      						}
                      						set(
                      							current,
                      							"bindingPattern",
                      							lv_bindingPattern_0_0,
                      							"org.eclipse.n4js.N4JS.BindingPattern");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    loop109:
                    do {
                        int alt109=2;
                        int LA109_0 = input.LA(1);

                        if ( (LA109_0==CommercialAt) ) {
                            alt109=1;
                        }


                        switch (alt109) {
                    	case 1 :
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getAnnotationsAnnotationParserRuleCall_0_1_0_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_64);
                    	    lv_annotations_1_0=ruleAnnotation();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getBindingElementFragmentRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"annotations",
                    	      								lv_annotations_1_0,
                    	      								"org.eclipse.n4js.N4JS.Annotation");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop109;
                        }
                    } while (true);
                    int alt110=2;
                    alt110 = dfa110.predict(input);
                    switch (alt110) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              						if (current==null) {
                              							current = createModelElement(grammarAccess.getBindingElementFragmentRule());
                              						}
                              						newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getBogusTypeRefFragmentParserRuleCall_0_1_1());
                              					
                            }
                            pushFollow(FOLLOW_65);
                            this_BogusTypeRefFragment_2=ruleBogusTypeRefFragment(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              						current = this_BogusTypeRefFragment_2;
                              						afterParserOrEnumRuleCall();
                              					
                            }

                            }
                            break;

                    }
                    int alt111=2;
                    int LA111_0 = input.LA(1);

                    if ( (LA111_0==FullStopFullStopFullStop) ) {
                        alt111=1;
                    }
                    switch (alt111) {
                        case 1 :
                            {
                            {
                            lv_variadic_3_0=(Token)match(input,FullStopFullStopFullStop,FOLLOW_8); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(lv_variadic_3_0, grammarAccess.getBindingElementFragmentAccess().getVariadicFullStopFullStopFullStopKeyword_0_1_2_0());
                              						
                            }
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElement(grammarAccess.getBindingElementFragmentRule());
                              							}
                              							setWithLastConsumed(current, "variadic", true, "...");
                              						
                            }

                            }


                            }
                            break;

                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getNameBindingIdentifierParserRuleCall_0_1_3_0());
                      						
                    }
                    pushFollow(FOLLOW_66);
                    lv_name_4_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getBindingElementFragmentRule());
                      							}
                      							set(
                      								current,
                      								"name",
                      								lv_name_4_0,
                      								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }
                    int alt112=2;
                    int LA112_0 = input.LA(1);

                    if ( (LA112_0==Colon) ) {
                        alt112=1;
                    }
                    switch (alt112) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              						if (current==null) {
                              							current = createModelElement(grammarAccess.getBindingElementFragmentRule());
                              						}
                              						newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getColonSepDeclaredTypeRefParserRuleCall_0_1_4());
                              					
                            }
                            pushFollow(FOLLOW_63);
                            this_ColonSepDeclaredTypeRef_5=ruleColonSepDeclaredTypeRef(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              						current = this_ColonSepDeclaredTypeRef_5;
                              						afterParserOrEnumRuleCall();
                              					
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;

            }
            int alt115=2;
            int LA115_0 = input.LA(1);

            if ( (LA115_0==EqualsSign) ) {
                alt115=1;
            }
            switch (alt115) {
                case 1 :
                    {
                    {
                    {
                    lv_hasInitializerAssignment_6_0=(Token)match(input,EqualsSign,FOLLOW_67); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_hasInitializerAssignment_6_0, grammarAccess.getBindingElementFragmentAccess().getHasInitializerAssignmentEqualsSignKeyword_1_0_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getBindingElementFragmentRule());
                      						}
                      						setWithLastConsumed(current, "hasInitializerAssignment", true, "=");
                      					
                    }

                    }


                    }
                    int alt114=2;
                    int LA114_0 = input.LA(1);

                    if ( ((LA114_0>=Intersection && LA114_0<=Implements)||(LA114_0>=Promisify && LA114_0<=Abstract)||(LA114_0>=External && LA114_0<=Function)||(LA114_0>=Private && LA114_0<=Delete)||(LA114_0>=Import && LA114_0<=Public)||LA114_0==Static||(LA114_0>=Target && LA114_0<=Await)||LA114_0==Class||(LA114_0>=False && LA114_0<=Super)||LA114_0==Union||(LA114_0>=Yield && LA114_0<=This)||(LA114_0>=From && LA114_0<=Void)||(LA114_0>=Get && LA114_0<=Set)||LA114_0==PlusSignPlusSign||LA114_0==HyphenMinusHyphenMinus||LA114_0==SolidusEqualsSign||LA114_0==As||LA114_0==Of||LA114_0==ExclamationMark||LA114_0==LeftParenthesis||LA114_0==PlusSign||LA114_0==HyphenMinus||LA114_0==Solidus||LA114_0==LessThanSign||(LA114_0>=CommercialAt && LA114_0<=LeftSquareBracket)||LA114_0==LeftCurlyBracket||LA114_0==Tilde||LA114_0==RULE_DOUBLE||(LA114_0>=RULE_HEX_INT && LA114_0<=RULE_LEGACY_OCTAL_INT)||LA114_0==RULE_SCIENTIFIC_INT||LA114_0==RULE_IDENTIFIER||LA114_0==RULE_STRING||(LA114_0>=RULE_TEMPLATE_HEAD && LA114_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA114_0==RULE_INT) ) {
                        alt114=1;
                    }
                    switch (alt114) {
                        case 1 :
                            {
                            {
                            if ( state.backtracking==0 ) {

                              						newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getInitializerAssignmentExpressionParserRuleCall_1_1_0());
                              					
                            }
                            pushFollow(FOLLOW_2);
                            lv_initializer_7_0=norm1_AssignmentExpression();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              						if (current==null) {
                              							current = createModelElementForParent(grammarAccess.getBindingElementFragmentRule());
                              						}
                              						set(
                              							current,
                              							"initializer",
                              							lv_initializer_7_0,
                              							"org.eclipse.n4js.N4JS.AssignmentExpression");
                              						afterParserOrEnumRuleCall();
                              					
                            }

                            }


                            }
                            break;

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_BindingElementFragment(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token lv_variadic_3_0=null;
        Token lv_hasInitializerAssignment_6_0=null;
        EObject lv_bindingPattern_0_0 = null;

        EObject lv_annotations_1_0 = null;

        EObject this_BogusTypeRefFragment_2 = null;

        AntlrDatatypeRuleToken lv_name_4_0 = null;

        EObject this_ColonSepDeclaredTypeRef_5 = null;

        EObject lv_initializer_7_0 = null;



        	enterRule();

        try {
            {
            {
            int alt120=2;
            alt120 = dfa120.predict(input);
            switch (alt120) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getBindingPatternBindingPatternParserRuleCall_0_0_0());
                      					
                    }
                    pushFollow(FOLLOW_63);
                    lv_bindingPattern_0_0=norm1_BindingPattern();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getBindingElementFragmentRule());
                      						}
                      						set(
                      							current,
                      							"bindingPattern",
                      							lv_bindingPattern_0_0,
                      							"org.eclipse.n4js.N4JS.BindingPattern");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    loop116:
                    do {
                        int alt116=2;
                        int LA116_0 = input.LA(1);

                        if ( (LA116_0==CommercialAt) ) {
                            alt116=1;
                        }


                        switch (alt116) {
                    	case 1 :
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getAnnotationsAnnotationParserRuleCall_0_1_0_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_64);
                    	    lv_annotations_1_0=ruleAnnotation();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getBindingElementFragmentRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"annotations",
                    	      								lv_annotations_1_0,
                    	      								"org.eclipse.n4js.N4JS.Annotation");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop116;
                        }
                    } while (true);
                    int alt117=2;
                    alt117 = dfa117.predict(input);
                    switch (alt117) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              						if (current==null) {
                              							current = createModelElement(grammarAccess.getBindingElementFragmentRule());
                              						}
                              						newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getBogusTypeRefFragmentParserRuleCall_0_1_1());
                              					
                            }
                            pushFollow(FOLLOW_65);
                            this_BogusTypeRefFragment_2=ruleBogusTypeRefFragment(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              						current = this_BogusTypeRefFragment_2;
                              						afterParserOrEnumRuleCall();
                              					
                            }

                            }
                            break;

                    }
                    int alt118=2;
                    int LA118_0 = input.LA(1);

                    if ( (LA118_0==FullStopFullStopFullStop) ) {
                        alt118=1;
                    }
                    switch (alt118) {
                        case 1 :
                            {
                            {
                            lv_variadic_3_0=(Token)match(input,FullStopFullStopFullStop,FOLLOW_8); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(lv_variadic_3_0, grammarAccess.getBindingElementFragmentAccess().getVariadicFullStopFullStopFullStopKeyword_0_1_2_0());
                              						
                            }
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElement(grammarAccess.getBindingElementFragmentRule());
                              							}
                              							setWithLastConsumed(current, "variadic", true, "...");
                              						
                            }

                            }


                            }
                            break;

                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getNameBindingIdentifierParserRuleCall_0_1_3_0());
                      						
                    }
                    pushFollow(FOLLOW_66);
                    lv_name_4_0=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getBindingElementFragmentRule());
                      							}
                      							set(
                      								current,
                      								"name",
                      								lv_name_4_0,
                      								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }
                    int alt119=2;
                    int LA119_0 = input.LA(1);

                    if ( (LA119_0==Colon) ) {
                        alt119=1;
                    }
                    switch (alt119) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              						if (current==null) {
                              							current = createModelElement(grammarAccess.getBindingElementFragmentRule());
                              						}
                              						newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getColonSepDeclaredTypeRefParserRuleCall_0_1_4());
                              					
                            }
                            pushFollow(FOLLOW_63);
                            this_ColonSepDeclaredTypeRef_5=ruleColonSepDeclaredTypeRef(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              						current = this_ColonSepDeclaredTypeRef_5;
                              						afterParserOrEnumRuleCall();
                              					
                            }

                            }
                            break;

                    }


                    }


                    }
                    break;

            }
            int alt122=2;
            int LA122_0 = input.LA(1);

            if ( (LA122_0==EqualsSign) ) {
                alt122=1;
            }
            switch (alt122) {
                case 1 :
                    {
                    {
                    {
                    lv_hasInitializerAssignment_6_0=(Token)match(input,EqualsSign,FOLLOW_68); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(lv_hasInitializerAssignment_6_0, grammarAccess.getBindingElementFragmentAccess().getHasInitializerAssignmentEqualsSignKeyword_1_0_0());
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getBindingElementFragmentRule());
                      						}
                      						setWithLastConsumed(current, "hasInitializerAssignment", true, "=");
                      					
                    }

                    }


                    }
                    int alt121=2;
                    int LA121_0 = input.LA(1);

                    if ( ((LA121_0>=Intersection && LA121_0<=Implements)||(LA121_0>=Promisify && LA121_0<=Abstract)||(LA121_0>=External && LA121_0<=Function)||(LA121_0>=Private && LA121_0<=Delete)||(LA121_0>=Import && LA121_0<=Public)||LA121_0==Static||(LA121_0>=Target && LA121_0<=Await)||LA121_0==Class||(LA121_0>=False && LA121_0<=Super)||LA121_0==Union||(LA121_0>=Yield && LA121_0<=This)||(LA121_0>=From && LA121_0<=Void)||(LA121_0>=Get && LA121_0<=Set)||LA121_0==PlusSignPlusSign||LA121_0==HyphenMinusHyphenMinus||LA121_0==SolidusEqualsSign||LA121_0==As||LA121_0==Of||LA121_0==ExclamationMark||LA121_0==LeftParenthesis||LA121_0==PlusSign||LA121_0==HyphenMinus||LA121_0==Solidus||LA121_0==LessThanSign||(LA121_0>=CommercialAt && LA121_0<=LeftSquareBracket)||LA121_0==LeftCurlyBracket||LA121_0==Tilde||LA121_0==RULE_DOUBLE||(LA121_0>=RULE_HEX_INT && LA121_0<=RULE_LEGACY_OCTAL_INT)||LA121_0==RULE_SCIENTIFIC_INT||LA121_0==RULE_IDENTIFIER||LA121_0==RULE_STRING||(LA121_0>=RULE_TEMPLATE_HEAD && LA121_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA121_0==RULE_INT) ) {
                        alt121=1;
                    }
                    switch (alt121) {
                        case 1 :
                            {
                            {
                            if ( state.backtracking==0 ) {

                              						newCompositeNode(grammarAccess.getBindingElementFragmentAccess().getInitializerAssignmentExpressionParserRuleCall_1_1_0());
                              					
                            }
                            pushFollow(FOLLOW_2);
                            lv_initializer_7_0=norm3_AssignmentExpression();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              						if (current==null) {
                              							current = createModelElementForParent(grammarAccess.getBindingElementFragmentRule());
                              						}
                              						set(
                              							current,
                              							"initializer",
                              							lv_initializer_7_0,
                              							"org.eclipse.n4js.N4JS.AssignmentExpression");
                              						afterParserOrEnumRuleCall();
                              					
                            }

                            }


                            }
                            break;

                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleBogusTypeRefFragment(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        EObject lv_bogusTypeRef_0_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getBogusTypeRefFragmentAccess().getBogusTypeRefTypeRefWithModifiersParserRuleCall_0());
              			
            }
            pushFollow(FOLLOW_2);
            lv_bogusTypeRef_0_0=ruleTypeRefWithModifiers();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				if (current==null) {
              					current = createModelElementForParent(grammarAccess.getBogusTypeRefFragmentRule());
              				}
              				set(
              					current,
              					"bogusTypeRef",
              					lv_bogusTypeRef_0_0,
              					"org.eclipse.n4js.ts.TypeExpressions.TypeRefWithModifiers");
              				afterParserOrEnumRuleCall();
              			
            }

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleBlock() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleBlock = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getBlockRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleBlock=ruleBlock();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleBlock; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleBlock() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        EObject lv_statements_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              						current = forceCreateModelElement(
              							grammarAccess.getBlockAccess().getBlockAction_0_0_0(),
              							current);
              					
            }

            }

            otherlv_1=(Token)match(input,LeftCurlyBracket,FOLLOW_50); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_1, grammarAccess.getBlockAccess().getLeftCurlyBracketKeyword_0_0_1());
              				
            }

            }


            }
            loop123:
            do {
                int alt123=2;
                int LA123_0 = input.LA(1);

                if ( ((LA123_0>=Intersection && LA123_0<=Implements)||(LA123_0>=Promisify && LA123_0<=Function)||(LA123_0>=Private && LA123_0<=Delete)||(LA123_0>=Import && LA123_0<=Break)||(LA123_0>=Class && LA123_0<=This)||(LA123_0>=From && LA123_0<=With)||(LA123_0>=For && LA123_0<=Var)||LA123_0==PlusSignPlusSign||LA123_0==HyphenMinusHyphenMinus||LA123_0==SolidusEqualsSign||(LA123_0>=As && LA123_0<=If)||LA123_0==Of||LA123_0==ExclamationMark||LA123_0==LeftParenthesis||LA123_0==PlusSign||LA123_0==HyphenMinus||LA123_0==Solidus||(LA123_0>=Semicolon && LA123_0<=LessThanSign)||(LA123_0>=CommercialAt && LA123_0<=LeftSquareBracket)||LA123_0==LeftCurlyBracket||LA123_0==Tilde||LA123_0==RULE_DOUBLE||(LA123_0>=RULE_HEX_INT && LA123_0<=RULE_LEGACY_OCTAL_INT)||LA123_0==RULE_SCIENTIFIC_INT||LA123_0==RULE_IDENTIFIER||LA123_0==RULE_STRING||(LA123_0>=RULE_TEMPLATE_HEAD && LA123_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA123_0==RULE_INT) ) {
                    alt123=1;
                }


                switch (alt123) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getBlockAccess().getStatementsStatementParserRuleCall_1_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_50);
            	    lv_statements_2_0=ruleStatement();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getBlockRule());
            	      					}
            	      					add(
            	      						current,
            	      						"statements",
            	      						lv_statements_2_0,
            	      						"org.eclipse.n4js.N4JS.Statement");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop123;
                }
            } while (true);

            otherlv_3=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getBlockAccess().getRightCurlyBracketKeyword_2());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_Block() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        EObject lv_statements_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              						current = forceCreateModelElement(
              							grammarAccess.getBlockAccess().getBlockAction_0_0_0(),
              							current);
              					
            }

            }

            otherlv_1=(Token)match(input,LeftCurlyBracket,FOLLOW_52); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_1, grammarAccess.getBlockAccess().getLeftCurlyBracketKeyword_0_0_1());
              				
            }

            }


            }
            loop124:
            do {
                int alt124=2;
                int LA124_0 = input.LA(1);

                if ( ((LA124_0>=Intersection && LA124_0<=Implements)||(LA124_0>=Promisify && LA124_0<=Function)||(LA124_0>=Private && LA124_0<=Delete)||(LA124_0>=Import && LA124_0<=Break)||(LA124_0>=Class && LA124_0<=This)||(LA124_0>=From && LA124_0<=With)||(LA124_0>=For && LA124_0<=Var)||LA124_0==PlusSignPlusSign||LA124_0==HyphenMinusHyphenMinus||LA124_0==SolidusEqualsSign||(LA124_0>=As && LA124_0<=If)||LA124_0==Of||LA124_0==ExclamationMark||LA124_0==LeftParenthesis||LA124_0==PlusSign||LA124_0==HyphenMinus||LA124_0==Solidus||(LA124_0>=Semicolon && LA124_0<=LessThanSign)||(LA124_0>=CommercialAt && LA124_0<=LeftSquareBracket)||LA124_0==LeftCurlyBracket||LA124_0==Tilde||LA124_0==RULE_DOUBLE||(LA124_0>=RULE_HEX_INT && LA124_0<=RULE_LEGACY_OCTAL_INT)||LA124_0==RULE_SCIENTIFIC_INT||LA124_0==RULE_IDENTIFIER||LA124_0==RULE_STRING||(LA124_0>=RULE_TEMPLATE_HEAD && LA124_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA124_0==RULE_INT) ) {
                    alt124=1;
                }


                switch (alt124) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getBlockAccess().getStatementsStatementParserRuleCall_1_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_52);
            	    lv_statements_2_0=norm1_Statement();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getBlockRule());
            	      					}
            	      					add(
            	      						current,
            	      						"statements",
            	      						lv_statements_2_0,
            	      						"org.eclipse.n4js.N4JS.Statement");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop124;
                }
            } while (true);

            otherlv_3=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getBlockAccess().getRightCurlyBracketKeyword_2());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleRootStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleRootStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getRootStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleRootStatement=ruleRootStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleRootStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleRootStatement() throws RecognitionException {
        EObject current = null;

        EObject this_Block_0 = null;

        EObject this_FunctionDeclaration_1 = null;

        EObject this_VariableStatement_2 = null;

        EObject this_EmptyStatement_3 = null;

        EObject this_LabelledStatement_4 = null;

        EObject this_ExpressionStatement_5 = null;

        EObject this_IfStatement_6 = null;

        EObject this_IterationStatement_7 = null;

        EObject this_ContinueStatement_8 = null;

        EObject this_BreakStatement_9 = null;

        EObject this_ReturnStatement_10 = null;

        EObject this_WithStatement_11 = null;

        EObject this_SwitchStatement_12 = null;

        EObject this_ThrowStatement_13 = null;

        EObject this_TryStatement_14 = null;

        EObject this_DebuggerStatement_15 = null;



        	enterRule();

        try {
            {
            int alt125=16;
            alt125 = dfa125.predict(input);
            switch (alt125) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_Block_0=ruleBlock();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_Block_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionDeclaration_1=ruleFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_FunctionDeclaration_1;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableStatement_2=norm1_VariableStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VariableStatement_2;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_EmptyStatement_3=ruleEmptyStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_EmptyStatement_3;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_LabelledStatement_4=ruleLabelledStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_LabelledStatement_4;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ExpressionStatement_5=ruleExpressionStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ExpressionStatement_5;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 7 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_IfStatement_6=ruleIfStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_IfStatement_6;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 8 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_IterationStatement_7=ruleIterationStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_IterationStatement_7;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 9 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ContinueStatement_8=ruleContinueStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ContinueStatement_8;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 10 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_BreakStatement_9=ruleBreakStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_BreakStatement_9;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 11 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ReturnStatement_10=ruleReturnStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ReturnStatement_10;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 12 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_WithStatement_11=ruleWithStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_WithStatement_11;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 13 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_SwitchStatement_12=ruleSwitchStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_SwitchStatement_12;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 14 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ThrowStatement_13=ruleThrowStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ThrowStatement_13;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 15 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_TryStatement_14=ruleTryStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_TryStatement_14;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 16 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_DebuggerStatement_15=ruleDebuggerStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_DebuggerStatement_15;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_RootStatement() throws RecognitionException {
        EObject current = null;

        EObject this_Block_0 = null;

        EObject this_FunctionDeclaration_1 = null;

        EObject this_VariableStatement_2 = null;

        EObject this_EmptyStatement_3 = null;

        EObject this_LabelledStatement_4 = null;

        EObject this_ExpressionStatement_5 = null;

        EObject this_IfStatement_6 = null;

        EObject this_IterationStatement_7 = null;

        EObject this_ContinueStatement_8 = null;

        EObject this_BreakStatement_9 = null;

        EObject this_ReturnStatement_10 = null;

        EObject this_WithStatement_11 = null;

        EObject this_SwitchStatement_12 = null;

        EObject this_ThrowStatement_13 = null;

        EObject this_TryStatement_14 = null;

        EObject this_DebuggerStatement_15 = null;



        	enterRule();

        try {
            {
            int alt126=16;
            alt126 = dfa126.predict(input);
            switch (alt126) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getRootStatementAccess().getBlockParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_Block_0=norm1_Block();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_Block_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getRootStatementAccess().getFunctionDeclarationParserRuleCall_1());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionDeclaration_1=norm1_FunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_FunctionDeclaration_1;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getRootStatementAccess().getVariableStatementParserRuleCall_2());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableStatement_2=norm3_VariableStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VariableStatement_2;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getEmptyStatementParserRuleCall_3());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_EmptyStatement_3=ruleEmptyStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_EmptyStatement_3;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getRootStatementAccess().getLabelledStatementParserRuleCall_4());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_LabelledStatement_4=norm1_LabelledStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_LabelledStatement_4;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getExpressionStatementParserRuleCall_5());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ExpressionStatement_5=norm1_ExpressionStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ExpressionStatement_5;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 7 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getIfStatementParserRuleCall_6());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_IfStatement_6=norm1_IfStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_IfStatement_6;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 8 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getIterationStatementParserRuleCall_7());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_IterationStatement_7=norm1_IterationStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_IterationStatement_7;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 9 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getContinueStatementParserRuleCall_8());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ContinueStatement_8=norm1_ContinueStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ContinueStatement_8;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 10 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getBreakStatementParserRuleCall_9());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_BreakStatement_9=norm1_BreakStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_BreakStatement_9;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 11 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getReturnStatementParserRuleCall_10());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ReturnStatement_10=norm1_ReturnStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ReturnStatement_10;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 12 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getWithStatementParserRuleCall_11());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_WithStatement_11=norm1_WithStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_WithStatement_11;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 13 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getSwitchStatementParserRuleCall_12());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_SwitchStatement_12=norm1_SwitchStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_SwitchStatement_12;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 14 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getThrowStatementParserRuleCall_13());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ThrowStatement_13=norm1_ThrowStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ThrowStatement_13;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 15 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getTryStatementParserRuleCall_14());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_TryStatement_14=norm1_TryStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_TryStatement_14;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 16 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getRootStatementAccess().getDebuggerStatementParserRuleCall_15());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_DebuggerStatement_15=ruleDebuggerStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_DebuggerStatement_15;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleStatement=ruleStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleStatement() throws RecognitionException {
        EObject current = null;

        EObject this_AnnotatedFunctionDeclaration_0 = null;

        EObject this_RootStatement_1 = null;



        	enterRule();

        try {
            {
            int alt127=2;
            alt127 = dfa127.predict(input);
            switch (alt127) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_AnnotatedFunctionDeclaration_0=ruleAnnotatedFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_AnnotatedFunctionDeclaration_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_RootStatement_1=ruleRootStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_RootStatement_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_Statement() throws RecognitionException {
        EObject current = null;

        EObject this_AnnotatedFunctionDeclaration_0 = null;

        EObject this_RootStatement_1 = null;



        	enterRule();

        try {
            {
            int alt128=2;
            alt128 = dfa128.predict(input);
            switch (alt128) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getStatementAccess().getAnnotatedFunctionDeclarationParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_AnnotatedFunctionDeclaration_0=norm1_AnnotatedFunctionDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_AnnotatedFunctionDeclaration_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getStatementAccess().getRootStatementParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_RootStatement_1=norm1_RootStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_RootStatement_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_VariableStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_3=null;
        Enumerator lv_varStmtKeyword_1_0 = null;

        EObject lv_varDeclsOrBindings_2_0 = null;

        EObject lv_varDeclsOrBindings_4_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              						current = forceCreateModelElement(
              							grammarAccess.getVariableStatementAccess().getVariableStatementAction_0_0_0(),
              							current);
              					
            }

            }
            {
            {
            if ( state.backtracking==0 ) {

              							newCompositeNode(grammarAccess.getVariableStatementAccess().getVarStmtKeywordVariableStatementKeywordEnumRuleCall_0_0_1_0());
              						
            }
            pushFollow(FOLLOW_27);
            lv_varStmtKeyword_1_0=ruleVariableStatementKeyword();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              							if (current==null) {
              								current = createModelElementForParent(grammarAccess.getVariableStatementRule());
              							}
              							set(
              								current,
              								"varStmtKeyword",
              								lv_varStmtKeyword_1_0,
              								"org.eclipse.n4js.N4JS.VariableStatementKeyword");
              							afterParserOrEnumRuleCall();
              						
            }

            }


            }


            }


            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_28);
            lv_varDeclsOrBindings_2_0=norm1_VariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getVariableStatementRule());
              					}
              					add(
              						current,
              						"varDeclsOrBindings",
              						lv_varDeclsOrBindings_2_0,
              						"org.eclipse.n4js.N4JS.VariableDeclarationOrBinding");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            loop129:
            do {
                int alt129=2;
                int LA129_0 = input.LA(1);

                if ( (LA129_0==Comma) ) {
                    alt129=1;
                }


                switch (alt129) {
            	case 1 :
            	    {
            	    otherlv_3=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      				newLeafNode(otherlv_3, grammarAccess.getVariableStatementAccess().getCommaKeyword_2_0());
            	      			
            	    }
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_28);
            	    lv_varDeclsOrBindings_4_0=norm1_VariableDeclarationOrBinding();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getVariableStatementRule());
            	      						}
            	      						add(
            	      							current,
            	      							"varDeclsOrBindings",
            	      							lv_varDeclsOrBindings_4_0,
            	      							"org.eclipse.n4js.N4JS.VariableDeclarationOrBinding");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop129;
                }
            } while (true);

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getVariableStatementAccess().getSemiParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm3_VariableStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_3=null;
        Enumerator lv_varStmtKeyword_1_0 = null;

        EObject lv_varDeclsOrBindings_2_0 = null;

        EObject lv_varDeclsOrBindings_4_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              						current = forceCreateModelElement(
              							grammarAccess.getVariableStatementAccess().getVariableStatementAction_0_0_0(),
              							current);
              					
            }

            }
            {
            {
            if ( state.backtracking==0 ) {

              							newCompositeNode(grammarAccess.getVariableStatementAccess().getVarStmtKeywordVariableStatementKeywordEnumRuleCall_0_0_1_0());
              						
            }
            pushFollow(FOLLOW_27);
            lv_varStmtKeyword_1_0=ruleVariableStatementKeyword();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              							if (current==null) {
              								current = createModelElementForParent(grammarAccess.getVariableStatementRule());
              							}
              							set(
              								current,
              								"varStmtKeyword",
              								lv_varStmtKeyword_1_0,
              								"org.eclipse.n4js.N4JS.VariableStatementKeyword");
              							afterParserOrEnumRuleCall();
              						
            }

            }


            }


            }


            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_28);
            lv_varDeclsOrBindings_2_0=norm3_VariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getVariableStatementRule());
              					}
              					add(
              						current,
              						"varDeclsOrBindings",
              						lv_varDeclsOrBindings_2_0,
              						"org.eclipse.n4js.N4JS.VariableDeclarationOrBinding");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            loop130:
            do {
                int alt130=2;
                int LA130_0 = input.LA(1);

                if ( (LA130_0==Comma) ) {
                    alt130=1;
                }


                switch (alt130) {
            	case 1 :
            	    {
            	    otherlv_3=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      				newLeafNode(otherlv_3, grammarAccess.getVariableStatementAccess().getCommaKeyword_2_0());
            	      			
            	    }
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getVariableStatementAccess().getVarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_2_1_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_28);
            	    lv_varDeclsOrBindings_4_0=norm3_VariableDeclarationOrBinding();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getVariableStatementRule());
            	      						}
            	      						add(
            	      							current,
            	      							"varDeclsOrBindings",
            	      							lv_varDeclsOrBindings_4_0,
            	      							"org.eclipse.n4js.N4JS.VariableDeclarationOrBinding");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop130;
                }
            } while (true);

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getVariableStatementAccess().getSemiParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleExportedVariableStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleExportedVariableStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getExportedVariableStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleExportedVariableStatement=ruleExportedVariableStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleExportedVariableStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExportedVariableStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_4=null;
        Enumerator lv_declaredModifiers_1_0 = null;

        Enumerator lv_varStmtKeyword_2_0 = null;

        EObject lv_varDeclsOrBindings_3_0 = null;

        EObject lv_varDeclsOrBindings_5_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getExportedVariableStatementAccess().getExportedVariableStatementAction_0(),
              					current);
              			
            }

            }
            loop131:
            do {
                int alt131=2;
                alt131 = dfa131.predict(input);
                switch (alt131) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getExportedVariableStatementAccess().getDeclaredModifiersN4ModifierEnumRuleCall_1_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_26);
            	    lv_declaredModifiers_1_0=ruleN4Modifier();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getExportedVariableStatementRule());
            	      					}
            	      					add(
            	      						current,
            	      						"declaredModifiers",
            	      						lv_declaredModifiers_1_0,
            	      						"org.eclipse.n4js.N4JS.N4Modifier");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop131;
                }
            } while (true);
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExportedVariableStatementAccess().getVarStmtKeywordVariableStatementKeywordEnumRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_27);
            lv_varStmtKeyword_2_0=ruleVariableStatementKeyword();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getExportedVariableStatementRule());
              					}
              					set(
              						current,
              						"varStmtKeyword",
              						lv_varStmtKeyword_2_0,
              						"org.eclipse.n4js.N4JS.VariableStatementKeyword");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExportedVariableStatementAccess().getVarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_3_0());
              				
            }
            pushFollow(FOLLOW_28);
            lv_varDeclsOrBindings_3_0=ruleExportedVariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getExportedVariableStatementRule());
              					}
              					add(
              						current,
              						"varDeclsOrBindings",
              						lv_varDeclsOrBindings_3_0,
              						"org.eclipse.n4js.N4JS.ExportedVariableDeclarationOrBinding");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            loop132:
            do {
                int alt132=2;
                int LA132_0 = input.LA(1);

                if ( (LA132_0==Comma) ) {
                    alt132=1;
                }


                switch (alt132) {
            	case 1 :
            	    {
            	    otherlv_4=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      				newLeafNode(otherlv_4, grammarAccess.getExportedVariableStatementAccess().getCommaKeyword_4_0());
            	      			
            	    }
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      						newCompositeNode(grammarAccess.getExportedVariableStatementAccess().getVarDeclsOrBindingsExportedVariableDeclarationOrBindingParserRuleCall_4_1_0());
            	      					
            	    }
            	    pushFollow(FOLLOW_28);
            	    lv_varDeclsOrBindings_5_0=ruleExportedVariableDeclarationOrBinding();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      						if (current==null) {
            	      							current = createModelElementForParent(grammarAccess.getExportedVariableStatementRule());
            	      						}
            	      						add(
            	      							current,
            	      							"varDeclsOrBindings",
            	      							lv_varDeclsOrBindings_5_0,
            	      							"org.eclipse.n4js.N4JS.ExportedVariableDeclarationOrBinding");
            	      						afterParserOrEnumRuleCall();
            	      					
            	    }

            	    }


            	    }


            	    }
            	    break;

            	default :
            	    break loop132;
                }
            } while (true);

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getExportedVariableStatementAccess().getSemiParserRuleCall_5());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleVariableDeclarationOrBinding() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleVariableDeclarationOrBinding = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getVariableDeclarationOrBindingRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleVariableDeclarationOrBinding=ruleVariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleVariableDeclarationOrBinding; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleVariableDeclarationOrBinding() throws RecognitionException {
        EObject current = null;

        EObject this_VariableBinding_0 = null;

        EObject this_VariableDeclaration_1 = null;



        	enterRule();

        try {
            {
            int alt133=2;
            int LA133_0 = input.LA(1);

            if ( (LA133_0==LeftCurlyBracket) && (synpred74_InternalN4JSParser())) {
                alt133=1;
            }
            else if ( (LA133_0==LeftSquareBracket) && (synpred74_InternalN4JSParser())) {
                alt133=1;
            }
            else if ( ((LA133_0>=Intersection && LA133_0<=Implements)||(LA133_0>=Promisify && LA133_0<=Abstract)||LA133_0==External||(LA133_0>=Private && LA133_0<=Project)||LA133_0==Public||LA133_0==Static||LA133_0==Target||(LA133_0>=Async && LA133_0<=Await)||LA133_0==Union||(LA133_0>=Yield && LA133_0<=This)||LA133_0==From||LA133_0==Type||(LA133_0>=Get && LA133_0<=Let)||(LA133_0>=Out && LA133_0<=Set)||LA133_0==As||LA133_0==Of||LA133_0==CommercialAt||LA133_0==RULE_IDENTIFIER) ) {
                alt133=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 133, 0, input);

                throw nvae;
            }
            switch (alt133) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableBinding_0=ruleVariableBinding();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VariableBinding_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableDeclaration_1=norm4_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_VariableDeclaration_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_VariableDeclarationOrBinding() throws RecognitionException {
        EObject current = null;

        EObject this_VariableBinding_0 = null;

        EObject this_VariableDeclaration_1 = null;



        	enterRule();

        try {
            {
            int alt134=2;
            int LA134_0 = input.LA(1);

            if ( (LA134_0==LeftCurlyBracket) && (synpred75_InternalN4JSParser())) {
                alt134=1;
            }
            else if ( (LA134_0==LeftSquareBracket) && (synpred75_InternalN4JSParser())) {
                alt134=1;
            }
            else if ( ((LA134_0>=Intersection && LA134_0<=Implements)||(LA134_0>=Promisify && LA134_0<=Abstract)||LA134_0==External||(LA134_0>=Private && LA134_0<=Project)||LA134_0==Public||LA134_0==Static||LA134_0==Target||(LA134_0>=Async && LA134_0<=Await)||LA134_0==Union||(LA134_0>=Yield && LA134_0<=This)||LA134_0==From||LA134_0==Type||(LA134_0>=Get && LA134_0<=Let)||(LA134_0>=Out && LA134_0<=Set)||LA134_0==As||LA134_0==Of||LA134_0==CommercialAt||LA134_0==RULE_IDENTIFIER) ) {
                alt134=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 134, 0, input);

                throw nvae;
            }
            switch (alt134) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableBinding_0=norm1_VariableBinding();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VariableBinding_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableDeclaration_1=norm5_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_VariableDeclaration_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm2_VariableDeclarationOrBinding() throws RecognitionException {
        EObject current = null;

        EObject this_VariableBinding_0 = null;

        EObject this_VariableDeclaration_1 = null;



        	enterRule();

        try {
            {
            int alt135=2;
            int LA135_0 = input.LA(1);

            if ( (LA135_0==LeftCurlyBracket) && (synpred76_InternalN4JSParser())) {
                alt135=1;
            }
            else if ( (LA135_0==LeftSquareBracket) && (synpred76_InternalN4JSParser())) {
                alt135=1;
            }
            else if ( ((LA135_0>=Intersection && LA135_0<=Implements)||(LA135_0>=Promisify && LA135_0<=Abstract)||LA135_0==External||(LA135_0>=Private && LA135_0<=Project)||LA135_0==Public||LA135_0==Static||LA135_0==Target||(LA135_0>=Async && LA135_0<=Await)||LA135_0==Union||LA135_0==This||LA135_0==From||LA135_0==Type||(LA135_0>=Get && LA135_0<=Let)||(LA135_0>=Out && LA135_0<=Set)||LA135_0==As||LA135_0==Of||LA135_0==CommercialAt||LA135_0==RULE_IDENTIFIER) ) {
                alt135=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 135, 0, input);

                throw nvae;
            }
            switch (alt135) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableBinding_0=norm2_VariableBinding();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VariableBinding_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableDeclaration_1=norm6_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_VariableDeclaration_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm3_VariableDeclarationOrBinding() throws RecognitionException {
        EObject current = null;

        EObject this_VariableBinding_0 = null;

        EObject this_VariableDeclaration_1 = null;



        	enterRule();

        try {
            {
            int alt136=2;
            int LA136_0 = input.LA(1);

            if ( (LA136_0==LeftCurlyBracket) && (synpred77_InternalN4JSParser())) {
                alt136=1;
            }
            else if ( (LA136_0==LeftSquareBracket) && (synpred77_InternalN4JSParser())) {
                alt136=1;
            }
            else if ( ((LA136_0>=Intersection && LA136_0<=Implements)||(LA136_0>=Promisify && LA136_0<=Abstract)||LA136_0==External||(LA136_0>=Private && LA136_0<=Project)||LA136_0==Public||LA136_0==Static||LA136_0==Target||(LA136_0>=Async && LA136_0<=Await)||LA136_0==Union||LA136_0==This||LA136_0==From||LA136_0==Type||(LA136_0>=Get && LA136_0<=Let)||(LA136_0>=Out && LA136_0<=Set)||LA136_0==As||LA136_0==Of||LA136_0==CommercialAt||LA136_0==RULE_IDENTIFIER) ) {
                alt136=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 136, 0, input);

                throw nvae;
            }
            switch (alt136) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableBinding_0=norm3_VariableBinding();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VariableBinding_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableDeclaration_1=norm7_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_VariableDeclaration_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm4_VariableDeclarationOrBinding() throws RecognitionException {
        EObject current = null;

        EObject this_VariableBinding_0 = null;

        EObject this_VariableDeclaration_1 = null;



        	enterRule();

        try {
            {
            int alt137=2;
            int LA137_0 = input.LA(1);

            if ( (LA137_0==LeftCurlyBracket) && (synpred78_InternalN4JSParser())) {
                alt137=1;
            }
            else if ( (LA137_0==LeftSquareBracket) && (synpred78_InternalN4JSParser())) {
                alt137=1;
            }
            else if ( ((LA137_0>=Intersection && LA137_0<=Implements)||(LA137_0>=Promisify && LA137_0<=Abstract)||LA137_0==External||(LA137_0>=Private && LA137_0<=Project)||LA137_0==Public||LA137_0==Static||LA137_0==Target||(LA137_0>=Async && LA137_0<=Await)||LA137_0==Union||(LA137_0>=Yield && LA137_0<=This)||LA137_0==From||LA137_0==Type||(LA137_0>=Get && LA137_0<=Let)||(LA137_0>=Out && LA137_0<=Set)||LA137_0==As||LA137_0==Of||LA137_0==CommercialAt||LA137_0==RULE_IDENTIFIER) ) {
                alt137=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 137, 0, input);

                throw nvae;
            }
            switch (alt137) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableBinding_0=norm4_VariableBinding();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VariableBinding_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableDeclaration_1=norm4_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_VariableDeclaration_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm6_VariableDeclarationOrBinding() throws RecognitionException {
        EObject current = null;

        EObject this_VariableBinding_0 = null;

        EObject this_VariableDeclaration_1 = null;



        	enterRule();

        try {
            {
            int alt138=2;
            int LA138_0 = input.LA(1);

            if ( (LA138_0==LeftCurlyBracket) && (synpred79_InternalN4JSParser())) {
                alt138=1;
            }
            else if ( (LA138_0==LeftSquareBracket) && (synpred79_InternalN4JSParser())) {
                alt138=1;
            }
            else if ( ((LA138_0>=Intersection && LA138_0<=Implements)||(LA138_0>=Promisify && LA138_0<=Abstract)||LA138_0==External||(LA138_0>=Private && LA138_0<=Project)||LA138_0==Public||LA138_0==Static||LA138_0==Target||(LA138_0>=Async && LA138_0<=Await)||LA138_0==Union||LA138_0==This||LA138_0==From||LA138_0==Type||(LA138_0>=Get && LA138_0<=Let)||(LA138_0>=Out && LA138_0<=Set)||LA138_0==As||LA138_0==Of||LA138_0==CommercialAt||LA138_0==RULE_IDENTIFIER) ) {
                alt138=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 138, 0, input);

                throw nvae;
            }
            switch (alt138) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableBindingParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableBinding_0=norm6_VariableBinding();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VariableBinding_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getVariableDeclarationOrBindingAccess().getVariableDeclarationParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_VariableDeclaration_1=norm6_VariableDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_VariableDeclaration_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleVariableBinding() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleVariableBinding = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getVariableBindingRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleVariableBinding=ruleVariableBinding();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleVariableBinding; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleVariableBinding() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_pattern_0_0 = null;

        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getVariableBindingAccess().getPatternBindingPatternParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_69);
            lv_pattern_0_0=ruleBindingPattern();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              					}
              					set(
              						current,
              						"pattern",
              						lv_pattern_0_0,
              						"org.eclipse.n4js.N4JS.BindingPattern");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            {
            otherlv_1=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				newLeafNode(otherlv_1, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0());
              			
            }
            {
            {
            if ( state.backtracking==0 ) {

              						newCompositeNode(grammarAccess.getVariableBindingAccess().getExpressionAssignmentExpressionParserRuleCall_1_1_1_0());
              					
            }
            pushFollow(FOLLOW_2);
            lv_expression_2_0=ruleAssignmentExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              						if (current==null) {
              							current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              						}
              						set(
              							current,
              							"expression",
              							lv_expression_2_0,
              							"org.eclipse.n4js.N4JS.AssignmentExpression");
              						afterParserOrEnumRuleCall();
              					
            }

            }


            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_VariableBinding() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_pattern_0_0 = null;

        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getVariableBindingAccess().getPatternBindingPatternParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_69);
            lv_pattern_0_0=ruleBindingPattern();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              					}
              					set(
              						current,
              						"pattern",
              						lv_pattern_0_0,
              						"org.eclipse.n4js.N4JS.BindingPattern");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            {
            otherlv_1=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				newLeafNode(otherlv_1, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0());
              			
            }
            {
            {
            if ( state.backtracking==0 ) {

              						newCompositeNode(grammarAccess.getVariableBindingAccess().getExpressionAssignmentExpressionParserRuleCall_1_1_1_0());
              					
            }
            pushFollow(FOLLOW_2);
            lv_expression_2_0=norm1_AssignmentExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              						if (current==null) {
              							current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              						}
              						set(
              							current,
              							"expression",
              							lv_expression_2_0,
              							"org.eclipse.n4js.N4JS.AssignmentExpression");
              						afterParserOrEnumRuleCall();
              					
            }

            }


            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm2_VariableBinding() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_pattern_0_0 = null;

        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getVariableBindingAccess().getPatternBindingPatternParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_69);
            lv_pattern_0_0=norm1_BindingPattern();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              					}
              					set(
              						current,
              						"pattern",
              						lv_pattern_0_0,
              						"org.eclipse.n4js.N4JS.BindingPattern");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            {
            otherlv_1=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				newLeafNode(otherlv_1, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0());
              			
            }
            {
            {
            if ( state.backtracking==0 ) {

              						newCompositeNode(grammarAccess.getVariableBindingAccess().getExpressionAssignmentExpressionParserRuleCall_1_1_1_0());
              					
            }
            pushFollow(FOLLOW_2);
            lv_expression_2_0=norm2_AssignmentExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              						if (current==null) {
              							current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              						}
              						set(
              							current,
              							"expression",
              							lv_expression_2_0,
              							"org.eclipse.n4js.N4JS.AssignmentExpression");
              						afterParserOrEnumRuleCall();
              					
            }

            }


            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm3_VariableBinding() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_pattern_0_0 = null;

        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getVariableBindingAccess().getPatternBindingPatternParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_69);
            lv_pattern_0_0=norm1_BindingPattern();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              					}
              					set(
              						current,
              						"pattern",
              						lv_pattern_0_0,
              						"org.eclipse.n4js.N4JS.BindingPattern");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            {
            otherlv_1=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				newLeafNode(otherlv_1, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_1_0());
              			
            }
            {
            {
            if ( state.backtracking==0 ) {

              						newCompositeNode(grammarAccess.getVariableBindingAccess().getExpressionAssignmentExpressionParserRuleCall_1_1_1_0());
              					
            }
            pushFollow(FOLLOW_2);
            lv_expression_2_0=norm3_AssignmentExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              						if (current==null) {
              							current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              						}
              						set(
              							current,
              							"expression",
              							lv_expression_2_0,
              							"org.eclipse.n4js.N4JS.AssignmentExpression");
              						afterParserOrEnumRuleCall();
              					
            }

            }


            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm4_VariableBinding() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_pattern_0_0 = null;

        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getVariableBindingAccess().getPatternBindingPatternParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_63);
            lv_pattern_0_0=ruleBindingPattern();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              					}
              					set(
              						current,
              						"pattern",
              						lv_pattern_0_0,
              						"org.eclipse.n4js.N4JS.BindingPattern");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            int alt139=2;
            int LA139_0 = input.LA(1);

            if ( (LA139_0==EqualsSign) ) {
                alt139=1;
            }
            switch (alt139) {
                case 1 :
                    {
                    otherlv_1=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_1, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0());
                      			
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getVariableBindingAccess().getExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_2_0=ruleAssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getVariableBindingRule());
                      						}
                      						set(
                      							current,
                      							"expression",
                      							lv_expression_2_0,
                      							"org.eclipse.n4js.N4JS.AssignmentExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm5_VariableBinding() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_pattern_0_0 = null;

        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getVariableBindingAccess().getPatternBindingPatternParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_63);
            lv_pattern_0_0=ruleBindingPattern();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              					}
              					set(
              						current,
              						"pattern",
              						lv_pattern_0_0,
              						"org.eclipse.n4js.N4JS.BindingPattern");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            int alt140=2;
            int LA140_0 = input.LA(1);

            if ( (LA140_0==EqualsSign) ) {
                alt140=1;
            }
            switch (alt140) {
                case 1 :
                    {
                    otherlv_1=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_1, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0());
                      			
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getVariableBindingAccess().getExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_2_0=norm1_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getVariableBindingRule());
                      						}
                      						set(
                      							current,
                      							"expression",
                      							lv_expression_2_0,
                      							"org.eclipse.n4js.N4JS.AssignmentExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm6_VariableBinding() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_pattern_0_0 = null;

        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getVariableBindingAccess().getPatternBindingPatternParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_63);
            lv_pattern_0_0=norm1_BindingPattern();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              					}
              					set(
              						current,
              						"pattern",
              						lv_pattern_0_0,
              						"org.eclipse.n4js.N4JS.BindingPattern");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            int alt141=2;
            int LA141_0 = input.LA(1);

            if ( (LA141_0==EqualsSign) ) {
                alt141=1;
            }
            switch (alt141) {
                case 1 :
                    {
                    otherlv_1=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_1, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0());
                      			
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getVariableBindingAccess().getExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_2_0=norm2_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getVariableBindingRule());
                      						}
                      						set(
                      							current,
                      							"expression",
                      							lv_expression_2_0,
                      							"org.eclipse.n4js.N4JS.AssignmentExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm7_VariableBinding() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_pattern_0_0 = null;

        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getVariableBindingAccess().getPatternBindingPatternParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_63);
            lv_pattern_0_0=norm1_BindingPattern();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getVariableBindingRule());
              					}
              					set(
              						current,
              						"pattern",
              						lv_pattern_0_0,
              						"org.eclipse.n4js.N4JS.BindingPattern");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            int alt142=2;
            int LA142_0 = input.LA(1);

            if ( (LA142_0==EqualsSign) ) {
                alt142=1;
            }
            switch (alt142) {
                case 1 :
                    {
                    otherlv_1=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				newLeafNode(otherlv_1, grammarAccess.getVariableBindingAccess().getEqualsSignKeyword_1_0_0_0());
                      			
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getVariableBindingAccess().getExpressionAssignmentExpressionParserRuleCall_1_0_0_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_2_0=norm3_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getVariableBindingRule());
                      						}
                      						set(
                      							current,
                      							"expression",
                      							lv_expression_2_0,
                      							"org.eclipse.n4js.N4JS.AssignmentExpression");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_VariableDeclaration() throws RecognitionException {
        EObject current = null;

        EObject this_VariableDeclarationImpl_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getVariableDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_VariableDeclarationImpl_1=norm1_VariableDeclarationImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_VariableDeclarationImpl_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm3_VariableDeclaration() throws RecognitionException {
        EObject current = null;

        EObject this_VariableDeclarationImpl_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getVariableDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_VariableDeclarationImpl_1=norm3_VariableDeclarationImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_VariableDeclarationImpl_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm4_VariableDeclaration() throws RecognitionException {
        EObject current = null;

        EObject this_VariableDeclarationImpl_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getVariableDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_VariableDeclarationImpl_1=norm4_VariableDeclarationImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_VariableDeclarationImpl_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm5_VariableDeclaration() throws RecognitionException {
        EObject current = null;

        EObject this_VariableDeclarationImpl_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getVariableDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_VariableDeclarationImpl_1=norm5_VariableDeclarationImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_VariableDeclarationImpl_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm6_VariableDeclaration() throws RecognitionException {
        EObject current = null;

        EObject this_VariableDeclarationImpl_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getVariableDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_VariableDeclarationImpl_1=norm6_VariableDeclarationImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_VariableDeclarationImpl_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm7_VariableDeclaration() throws RecognitionException {
        EObject current = null;

        EObject this_VariableDeclarationImpl_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getVariableDeclarationAccess().getVariableDeclarationAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getVariableDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_VariableDeclarationImpl_1=norm7_VariableDeclarationImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_VariableDeclarationImpl_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleVariableDeclarationImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_2=null;
        EObject lv_annotations_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject lv_expression_3_0 = null;



        	enterRule();

        try {
            {
            {
            loop143:
            do {
                int alt143=2;
                alt143 = dfa143.predict(input);
                switch (alt143) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAnnotationParserRuleCall_0_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_71);
            	    lv_annotations_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
            	      					}
            	      					add(
            	      						current,
            	      						"annotations",
            	      						lv_annotations_0_0,
            	      						"org.eclipse.n4js.N4JS.Annotation");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop143;
                }
            } while (true);
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getNameBindingIdentifierParserRuleCall_1_1_0_0_0());
              						
            }
            pushFollow(FOLLOW_63);
            lv_name_1_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              							if (current==null) {
              								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
              							}
              							set(
              								current,
              								"name",
              								lv_name_1_0,
              								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              							afterParserOrEnumRuleCall();
              						
            }

            }


            }


            }
            int alt144=2;
            int LA144_0 = input.LA(1);

            if ( (LA144_0==EqualsSign) ) {
                alt144=1;
            }
            switch (alt144) {
                case 1 :
                    {
                    otherlv_2=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_2, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0());
                      						
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_3_0=ruleAssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							set(
                      								current,
                      								"expression",
                      								lv_expression_3_0,
                      								"org.eclipse.n4js.N4JS.AssignmentExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_VariableDeclarationImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_2=null;
        EObject lv_annotations_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject lv_expression_3_0 = null;



        	enterRule();

        try {
            {
            {
            loop145:
            do {
                int alt145=2;
                alt145 = dfa145.predict(input);
                switch (alt145) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAnnotationParserRuleCall_0_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_71);
            	    lv_annotations_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
            	      					}
            	      					add(
            	      						current,
            	      						"annotations",
            	      						lv_annotations_0_0,
            	      						"org.eclipse.n4js.N4JS.Annotation");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop145;
                }
            } while (true);
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getNameBindingIdentifierParserRuleCall_1_1_0_0_0());
              						
            }
            pushFollow(FOLLOW_63);
            lv_name_1_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              							if (current==null) {
              								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
              							}
              							set(
              								current,
              								"name",
              								lv_name_1_0,
              								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              							afterParserOrEnumRuleCall();
              						
            }

            }


            }


            }
            int alt146=2;
            int LA146_0 = input.LA(1);

            if ( (LA146_0==EqualsSign) ) {
                alt146=1;
            }
            switch (alt146) {
                case 1 :
                    {
                    otherlv_2=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_2, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0());
                      						
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_3_0=norm1_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							set(
                      								current,
                      								"expression",
                      								lv_expression_3_0,
                      								"org.eclipse.n4js.N4JS.AssignmentExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm2_VariableDeclarationImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_2=null;
        EObject lv_annotations_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject lv_expression_3_0 = null;



        	enterRule();

        try {
            {
            {
            loop147:
            do {
                int alt147=2;
                alt147 = dfa147.predict(input);
                switch (alt147) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAnnotationParserRuleCall_0_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_71);
            	    lv_annotations_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
            	      					}
            	      					add(
            	      						current,
            	      						"annotations",
            	      						lv_annotations_0_0,
            	      						"org.eclipse.n4js.N4JS.Annotation");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop147;
                }
            } while (true);
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getNameBindingIdentifierParserRuleCall_1_1_0_0_0());
              						
            }
            pushFollow(FOLLOW_63);
            lv_name_1_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              							if (current==null) {
              								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
              							}
              							set(
              								current,
              								"name",
              								lv_name_1_0,
              								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              							afterParserOrEnumRuleCall();
              						
            }

            }


            }


            }
            int alt148=2;
            int LA148_0 = input.LA(1);

            if ( (LA148_0==EqualsSign) ) {
                alt148=1;
            }
            switch (alt148) {
                case 1 :
                    {
                    otherlv_2=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_2, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0());
                      						
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_3_0=norm2_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							set(
                      								current,
                      								"expression",
                      								lv_expression_3_0,
                      								"org.eclipse.n4js.N4JS.AssignmentExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm3_VariableDeclarationImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_2=null;
        EObject lv_annotations_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject lv_expression_3_0 = null;



        	enterRule();

        try {
            {
            {
            loop149:
            do {
                int alt149=2;
                alt149 = dfa149.predict(input);
                switch (alt149) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAnnotationParserRuleCall_0_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_71);
            	    lv_annotations_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
            	      					}
            	      					add(
            	      						current,
            	      						"annotations",
            	      						lv_annotations_0_0,
            	      						"org.eclipse.n4js.N4JS.Annotation");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop149;
                }
            } while (true);
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getNameBindingIdentifierParserRuleCall_1_1_0_0_0());
              						
            }
            pushFollow(FOLLOW_63);
            lv_name_1_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              							if (current==null) {
              								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
              							}
              							set(
              								current,
              								"name",
              								lv_name_1_0,
              								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              							afterParserOrEnumRuleCall();
              						
            }

            }


            }


            }
            int alt150=2;
            int LA150_0 = input.LA(1);

            if ( (LA150_0==EqualsSign) ) {
                alt150=1;
            }
            switch (alt150) {
                case 1 :
                    {
                    otherlv_2=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_2, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_1_1_0());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignmentExpressionParserRuleCall_1_1_1_1_0());
                      						
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_3_0=norm3_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							set(
                      								current,
                      								"expression",
                      								lv_expression_3_0,
                      								"org.eclipse.n4js.N4JS.AssignmentExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm4_VariableDeclarationImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_3=null;
        EObject lv_annotations_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject this_ColonSepDeclaredTypeRef_2 = null;

        EObject lv_expression_4_0 = null;



        	enterRule();

        try {
            {
            {
            loop151:
            do {
                int alt151=2;
                alt151 = dfa151.predict(input);
                switch (alt151) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAnnotationParserRuleCall_0_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_71);
            	    lv_annotations_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
            	      					}
            	      					add(
            	      						current,
            	      						"annotations",
            	      						lv_annotations_0_0,
            	      						"org.eclipse.n4js.N4JS.Annotation");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop151;
                }
            } while (true);
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              								newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getNameBindingIdentifierParserRuleCall_1_0_0_0_0_0());
              							
            }
            pushFollow(FOLLOW_66);
            lv_name_1_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              								if (current==null) {
              									current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
              								}
              								set(
              									current,
              									"name",
              									lv_name_1_0,
              									"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              								afterParserOrEnumRuleCall();
              							
            }

            }


            }
            int alt152=2;
            int LA152_0 = input.LA(1);

            if ( (LA152_0==Colon) ) {
                alt152=1;
            }
            switch (alt152) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1());
                      						
                    }
                    pushFollow(FOLLOW_63);
                    this_ColonSepDeclaredTypeRef_2=ruleColonSepDeclaredTypeRef(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							current = this_ColonSepDeclaredTypeRef_2;
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }
                    break;

            }


            }


            }
            int alt153=2;
            int LA153_0 = input.LA(1);

            if ( (LA153_0==EqualsSign) ) {
                alt153=1;
            }
            switch (alt153) {
                case 1 :
                    {
                    otherlv_3=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_3, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0());
                      						
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_4_0=ruleAssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							set(
                      								current,
                      								"expression",
                      								lv_expression_4_0,
                      								"org.eclipse.n4js.N4JS.AssignmentExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm5_VariableDeclarationImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_3=null;
        EObject lv_annotations_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject this_ColonSepDeclaredTypeRef_2 = null;

        EObject lv_expression_4_0 = null;



        	enterRule();

        try {
            {
            {
            loop154:
            do {
                int alt154=2;
                alt154 = dfa154.predict(input);
                switch (alt154) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAnnotationParserRuleCall_0_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_71);
            	    lv_annotations_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
            	      					}
            	      					add(
            	      						current,
            	      						"annotations",
            	      						lv_annotations_0_0,
            	      						"org.eclipse.n4js.N4JS.Annotation");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop154;
                }
            } while (true);
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              								newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getNameBindingIdentifierParserRuleCall_1_0_0_0_0_0());
              							
            }
            pushFollow(FOLLOW_66);
            lv_name_1_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              								if (current==null) {
              									current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
              								}
              								set(
              									current,
              									"name",
              									lv_name_1_0,
              									"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              								afterParserOrEnumRuleCall();
              							
            }

            }


            }
            int alt155=2;
            int LA155_0 = input.LA(1);

            if ( (LA155_0==Colon) ) {
                alt155=1;
            }
            switch (alt155) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1());
                      						
                    }
                    pushFollow(FOLLOW_63);
                    this_ColonSepDeclaredTypeRef_2=ruleColonSepDeclaredTypeRef(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							current = this_ColonSepDeclaredTypeRef_2;
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }
                    break;

            }


            }


            }
            int alt156=2;
            int LA156_0 = input.LA(1);

            if ( (LA156_0==EqualsSign) ) {
                alt156=1;
            }
            switch (alt156) {
                case 1 :
                    {
                    otherlv_3=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_3, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0());
                      						
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_4_0=norm1_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							set(
                      								current,
                      								"expression",
                      								lv_expression_4_0,
                      								"org.eclipse.n4js.N4JS.AssignmentExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm6_VariableDeclarationImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_3=null;
        EObject lv_annotations_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject this_ColonSepDeclaredTypeRef_2 = null;

        EObject lv_expression_4_0 = null;



        	enterRule();

        try {
            {
            {
            loop157:
            do {
                int alt157=2;
                alt157 = dfa157.predict(input);
                switch (alt157) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAnnotationParserRuleCall_0_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_71);
            	    lv_annotations_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
            	      					}
            	      					add(
            	      						current,
            	      						"annotations",
            	      						lv_annotations_0_0,
            	      						"org.eclipse.n4js.N4JS.Annotation");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop157;
                }
            } while (true);
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              								newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getNameBindingIdentifierParserRuleCall_1_0_0_0_0_0());
              							
            }
            pushFollow(FOLLOW_66);
            lv_name_1_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              								if (current==null) {
              									current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
              								}
              								set(
              									current,
              									"name",
              									lv_name_1_0,
              									"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              								afterParserOrEnumRuleCall();
              							
            }

            }


            }
            int alt158=2;
            int LA158_0 = input.LA(1);

            if ( (LA158_0==Colon) ) {
                alt158=1;
            }
            switch (alt158) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1());
                      						
                    }
                    pushFollow(FOLLOW_63);
                    this_ColonSepDeclaredTypeRef_2=ruleColonSepDeclaredTypeRef(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							current = this_ColonSepDeclaredTypeRef_2;
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }
                    break;

            }


            }


            }
            int alt159=2;
            int LA159_0 = input.LA(1);

            if ( (LA159_0==EqualsSign) ) {
                alt159=1;
            }
            switch (alt159) {
                case 1 :
                    {
                    otherlv_3=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_3, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0());
                      						
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_4_0=norm2_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							set(
                      								current,
                      								"expression",
                      								lv_expression_4_0,
                      								"org.eclipse.n4js.N4JS.AssignmentExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm7_VariableDeclarationImpl(EObject in_current) throws RecognitionException {
        EObject current = in_current;

        Token otherlv_3=null;
        EObject lv_annotations_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject this_ColonSepDeclaredTypeRef_2 = null;

        EObject lv_expression_4_0 = null;



        	enterRule();

        try {
            {
            {
            loop160:
            do {
                int alt160=2;
                alt160 = dfa160.predict(input);
                switch (alt160) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getAnnotationsAnnotationParserRuleCall_0_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_71);
            	    lv_annotations_0_0=ruleAnnotation();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
            	      					}
            	      					add(
            	      						current,
            	      						"annotations",
            	      						lv_annotations_0_0,
            	      						"org.eclipse.n4js.N4JS.Annotation");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop160;
                }
            } while (true);
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              								newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getNameBindingIdentifierParserRuleCall_1_0_0_0_0_0());
              							
            }
            pushFollow(FOLLOW_66);
            lv_name_1_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              								if (current==null) {
              									current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
              								}
              								set(
              									current,
              									"name",
              									lv_name_1_0,
              									"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              								afterParserOrEnumRuleCall();
              							
            }

            }


            }
            int alt161=2;
            int LA161_0 = input.LA(1);

            if ( (LA161_0==Colon) ) {
                alt161=1;
            }
            switch (alt161) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElement(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_0_0_1());
                      						
                    }
                    pushFollow(FOLLOW_63);
                    this_ColonSepDeclaredTypeRef_2=ruleColonSepDeclaredTypeRef(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							current = this_ColonSepDeclaredTypeRef_2;
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }
                    break;

            }


            }


            }
            int alt162=2;
            int LA162_0 = input.LA(1);

            if ( (LA162_0==EqualsSign) ) {
                alt162=1;
            }
            switch (alt162) {
                case 1 :
                    {
                    otherlv_3=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_3, grammarAccess.getVariableDeclarationImplAccess().getEqualsSignKeyword_1_0_1_0());
                      				
                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getVariableDeclarationImplAccess().getExpressionAssignmentExpressionParserRuleCall_1_0_1_1_0());
                      						
                    }
                    pushFollow(FOLLOW_2);
                    lv_expression_4_0=norm3_AssignmentExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getVariableDeclarationImplRule());
                      							}
                      							set(
                      								current,
                      								"expression",
                      								lv_expression_4_0,
                      								"org.eclipse.n4js.N4JS.AssignmentExpression");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleExportedVariableDeclarationOrBinding() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleExportedVariableDeclarationOrBinding = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getExportedVariableDeclarationOrBindingRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleExportedVariableDeclarationOrBinding=ruleExportedVariableDeclarationOrBinding();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleExportedVariableDeclarationOrBinding; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExportedVariableDeclarationOrBinding() throws RecognitionException {
        EObject current = null;

        EObject this_ExportedVariableBinding_0 = null;

        EObject this_ExportedVariableDeclaration_1 = null;



        	enterRule();

        try {
            {
            int alt163=2;
            int LA163_0 = input.LA(1);

            if ( (LA163_0==LeftCurlyBracket) && (synpred96_InternalN4JSParser())) {
                alt163=1;
            }
            else if ( (LA163_0==LeftSquareBracket) && (synpred96_InternalN4JSParser())) {
                alt163=1;
            }
            else if ( ((LA163_0>=Intersection && LA163_0<=Implements)||(LA163_0>=Promisify && LA163_0<=Abstract)||LA163_0==External||(LA163_0>=Private && LA163_0<=Project)||LA163_0==Public||LA163_0==Static||LA163_0==Target||(LA163_0>=Async && LA163_0<=Await)||LA163_0==Union||(LA163_0>=Yield && LA163_0<=This)||LA163_0==From||LA163_0==Type||(LA163_0>=Get && LA163_0<=Let)||(LA163_0>=Out && LA163_0<=Set)||LA163_0==As||LA163_0==Of||LA163_0==CommercialAt||LA163_0==RULE_IDENTIFIER) ) {
                alt163=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 163, 0, input);

                throw nvae;
            }
            switch (alt163) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_ExportedVariableBinding_0=ruleExportedVariableBinding();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_ExportedVariableBinding_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ExportedVariableDeclaration_1=ruleExportedVariableDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ExportedVariableDeclaration_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ExportedVariableDeclarationOrBinding() throws RecognitionException {
        EObject current = null;

        EObject this_ExportedVariableBinding_0 = null;

        EObject this_ExportedVariableDeclaration_1 = null;



        	enterRule();

        try {
            {
            int alt164=2;
            int LA164_0 = input.LA(1);

            if ( (LA164_0==LeftCurlyBracket) && (synpred97_InternalN4JSParser())) {
                alt164=1;
            }
            else if ( (LA164_0==LeftSquareBracket) && (synpred97_InternalN4JSParser())) {
                alt164=1;
            }
            else if ( ((LA164_0>=Intersection && LA164_0<=Implements)||(LA164_0>=Promisify && LA164_0<=Abstract)||LA164_0==External||(LA164_0>=Private && LA164_0<=Project)||LA164_0==Public||LA164_0==Static||LA164_0==Target||(LA164_0>=Async && LA164_0<=Await)||LA164_0==Union||LA164_0==This||LA164_0==From||LA164_0==Type||(LA164_0>=Get && LA164_0<=Let)||(LA164_0>=Out && LA164_0<=Set)||LA164_0==As||LA164_0==Of||LA164_0==CommercialAt||LA164_0==RULE_IDENTIFIER) ) {
                alt164=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 164, 0, input);

                throw nvae;
            }
            switch (alt164) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableBindingParserRuleCall_0());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_ExportedVariableBinding_0=norm1_ExportedVariableBinding();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_ExportedVariableBinding_0;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getExportedVariableDeclarationOrBindingAccess().getExportedVariableDeclarationParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ExportedVariableDeclaration_1=norm1_ExportedVariableDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ExportedVariableDeclaration_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleExportedVariableBinding() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleExportedVariableBinding = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getExportedVariableBindingRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleExportedVariableBinding=ruleExportedVariableBinding();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleExportedVariableBinding; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExportedVariableBinding() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_pattern_0_0 = null;

        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExportedVariableBindingAccess().getPatternBindingPatternParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_69);
            lv_pattern_0_0=ruleBindingPattern();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getExportedVariableBindingRule());
              					}
              					set(
              						current,
              						"pattern",
              						lv_pattern_0_0,
              						"org.eclipse.n4js.N4JS.BindingPattern");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_1=(Token)match(input,EqualsSign,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getExportedVariableBindingAccess().getEqualsSignKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExportedVariableBindingAccess().getExpressionAssignmentExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_expression_2_0=norm1_AssignmentExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getExportedVariableBindingRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.AssignmentExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ExportedVariableBinding() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_pattern_0_0 = null;

        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExportedVariableBindingAccess().getPatternBindingPatternParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_69);
            lv_pattern_0_0=norm1_BindingPattern();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getExportedVariableBindingRule());
              					}
              					set(
              						current,
              						"pattern",
              						lv_pattern_0_0,
              						"org.eclipse.n4js.N4JS.BindingPattern");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_1=(Token)match(input,EqualsSign,FOLLOW_70); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getExportedVariableBindingAccess().getEqualsSignKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExportedVariableBindingAccess().getExpressionAssignmentExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_expression_2_0=norm3_AssignmentExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getExportedVariableBindingRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.AssignmentExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleExportedVariableDeclaration() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleExportedVariableDeclaration = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getExportedVariableDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleExportedVariableDeclaration=ruleExportedVariableDeclaration();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleExportedVariableDeclaration; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExportedVariableDeclaration() throws RecognitionException {
        EObject current = null;

        EObject this_VariableDeclarationImpl_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getExportedVariableDeclarationAccess().getExportedVariableDeclarationAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getExportedVariableDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getExportedVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_VariableDeclarationImpl_1=norm5_VariableDeclarationImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_VariableDeclarationImpl_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ExportedVariableDeclaration() throws RecognitionException {
        EObject current = null;

        EObject this_VariableDeclarationImpl_1 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getExportedVariableDeclarationAccess().getExportedVariableDeclarationAction_0(),
              					current);
              			
            }

            }

            if ( state.backtracking==0 ) {

              			if (current==null) {
              				current = createModelElement(grammarAccess.getExportedVariableDeclarationRule());
              			}
              			newCompositeNode(grammarAccess.getExportedVariableDeclarationAccess().getVariableDeclarationImplParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            this_VariableDeclarationImpl_1=norm7_VariableDeclarationImpl(current);

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			current = this_VariableDeclarationImpl_1;
              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleEmptyStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleEmptyStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getEmptyStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleEmptyStatement=ruleEmptyStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleEmptyStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleEmptyStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;


        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getEmptyStatementAccess().getEmptyStatementAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Semicolon,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getEmptyStatementAccess().getSemicolonKeyword_1());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleExpressionStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleExpressionStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getExpressionStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleExpressionStatement=ruleExpressionStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleExpressionStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleExpressionStatement() throws RecognitionException {
        EObject current = null;

        EObject lv_expression_0_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExpressionStatementAccess().getExpressionExpressionParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_18);
            lv_expression_0_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getExpressionStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_0_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getExpressionStatementAccess().getSemiParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ExpressionStatement() throws RecognitionException {
        EObject current = null;

        EObject lv_expression_0_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getExpressionStatementAccess().getExpressionExpressionParserRuleCall_0_0());
              				
            }
            pushFollow(FOLLOW_18);
            lv_expression_0_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getExpressionStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_0_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getExpressionStatementAccess().getSemiParserRuleCall_1());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleIfStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleIfStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getIfStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleIfStatement=ruleIfStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleIfStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleIfStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        EObject lv_expression_2_0 = null;

        EObject lv_ifStmt_4_0 = null;

        EObject lv_elseStmt_6_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,If,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getIfStatementAccess().getIfKeyword_0());
              		
            }
            otherlv_1=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getIfStatementAccess().getLeftParenthesisKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getIfStatementAccess().getExpressionExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_2_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getIfStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_3=(Token)match(input,RightParenthesis,FOLLOW_73); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getIfStatementAccess().getRightParenthesisKeyword_3());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getIfStatementAccess().getIfStmtStatementParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_74);
            lv_ifStmt_4_0=ruleStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getIfStatementRule());
              					}
              					set(
              						current,
              						"ifStmt",
              						lv_ifStmt_4_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            int alt165=2;
            int LA165_0 = input.LA(1);

            if ( (LA165_0==Else) ) {
                int LA165_1 = input.LA(2);

                if ( (synpred100_InternalN4JSParser()) ) {
                    alt165=1;
                }
            }
            switch (alt165) {
                case 1 :
                    {
                    {
                    otherlv_5=(Token)match(input,Else,FOLLOW_73); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_5, grammarAccess.getIfStatementAccess().getElseKeyword_5_0());
                      				
                    }

                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getIfStatementAccess().getElseStmtStatementParserRuleCall_5_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_elseStmt_6_0=ruleStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getIfStatementRule());
                      						}
                      						set(
                      							current,
                      							"elseStmt",
                      							lv_elseStmt_6_0,
                      							"org.eclipse.n4js.N4JS.Statement");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_IfStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        EObject lv_expression_2_0 = null;

        EObject lv_ifStmt_4_0 = null;

        EObject lv_elseStmt_6_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,If,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getIfStatementAccess().getIfKeyword_0());
              		
            }
            otherlv_1=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getIfStatementAccess().getLeftParenthesisKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getIfStatementAccess().getExpressionExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_2_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getIfStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_3=(Token)match(input,RightParenthesis,FOLLOW_75); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getIfStatementAccess().getRightParenthesisKeyword_3());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getIfStatementAccess().getIfStmtStatementParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_74);
            lv_ifStmt_4_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getIfStatementRule());
              					}
              					set(
              						current,
              						"ifStmt",
              						lv_ifStmt_4_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            int alt166=2;
            int LA166_0 = input.LA(1);

            if ( (LA166_0==Else) ) {
                int LA166_1 = input.LA(2);

                if ( (synpred101_InternalN4JSParser()) ) {
                    alt166=1;
                }
            }
            switch (alt166) {
                case 1 :
                    {
                    {
                    otherlv_5=(Token)match(input,Else,FOLLOW_75); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_5, grammarAccess.getIfStatementAccess().getElseKeyword_5_0());
                      				
                    }

                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getIfStatementAccess().getElseStmtStatementParserRuleCall_5_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_elseStmt_6_0=norm1_Statement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getIfStatementRule());
                      						}
                      						set(
                      							current,
                      							"elseStmt",
                      							lv_elseStmt_6_0,
                      							"org.eclipse.n4js.N4JS.Statement");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleIterationStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleIterationStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getIterationStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleIterationStatement=ruleIterationStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleIterationStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleIterationStatement() throws RecognitionException {
        EObject current = null;

        EObject this_DoStatement_0 = null;

        EObject this_WhileStatement_1 = null;

        EObject this_ForStatement_2 = null;



        	enterRule();

        try {
            {
            int alt167=3;
            switch ( input.LA(1) ) {
            case Do:
                {
                alt167=1;
                }
                break;
            case While:
                {
                alt167=2;
                }
                break;
            case For:
                {
                alt167=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 167, 0, input);

                throw nvae;
            }

            switch (alt167) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_DoStatement_0=ruleDoStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_DoStatement_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_WhileStatement_1=ruleWhileStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_WhileStatement_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 3 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ForStatement_2=ruleForStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ForStatement_2;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_IterationStatement() throws RecognitionException {
        EObject current = null;

        EObject this_DoStatement_0 = null;

        EObject this_WhileStatement_1 = null;

        EObject this_ForStatement_2 = null;



        	enterRule();

        try {
            {
            int alt168=3;
            switch ( input.LA(1) ) {
            case Do:
                {
                alt168=1;
                }
                break;
            case While:
                {
                alt168=2;
                }
                break;
            case For:
                {
                alt168=3;
                }
                break;
            default:
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 168, 0, input);

                throw nvae;
            }

            switch (alt168) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getIterationStatementAccess().getDoStatementParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_DoStatement_0=norm1_DoStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_DoStatement_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getIterationStatementAccess().getWhileStatementParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_WhileStatement_1=norm1_WhileStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_WhileStatement_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 3 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getIterationStatementAccess().getForStatementParserRuleCall_2());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ForStatement_2=norm1_ForStatement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ForStatement_2;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleDoStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleDoStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getDoStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleDoStatement=ruleDoStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleDoStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleDoStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        EObject lv_statement_1_0 = null;

        EObject lv_expression_4_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Do,FOLLOW_73); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getDoStatementAccess().getDoKeyword_0());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getDoStatementAccess().getStatementStatementParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_76);
            lv_statement_1_0=ruleStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getDoStatementRule());
              					}
              					set(
              						current,
              						"statement",
              						lv_statement_1_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_2=(Token)match(input,While,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getDoStatementAccess().getWhileKeyword_2());
              		
            }
            otherlv_3=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getDoStatementAccess().getLeftParenthesisKeyword_3());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getDoStatementAccess().getExpressionExpressionParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_4_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getDoStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_4_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_5=(Token)match(input,RightParenthesis,FOLLOW_35); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_5, grammarAccess.getDoStatementAccess().getRightParenthesisKeyword_5());
              		
            }
            int alt169=2;
            alt169 = dfa169.predict(input);
            switch (alt169) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getDoStatementAccess().getSemiParserRuleCall_6());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    ruleSemi();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_DoStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        EObject lv_statement_1_0 = null;

        EObject lv_expression_4_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Do,FOLLOW_75); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getDoStatementAccess().getDoKeyword_0());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getDoStatementAccess().getStatementStatementParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_76);
            lv_statement_1_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getDoStatementRule());
              					}
              					set(
              						current,
              						"statement",
              						lv_statement_1_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_2=(Token)match(input,While,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getDoStatementAccess().getWhileKeyword_2());
              		
            }
            otherlv_3=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getDoStatementAccess().getLeftParenthesisKeyword_3());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getDoStatementAccess().getExpressionExpressionParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_4_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getDoStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_4_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_5=(Token)match(input,RightParenthesis,FOLLOW_35); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_5, grammarAccess.getDoStatementAccess().getRightParenthesisKeyword_5());
              		
            }
            int alt170=2;
            int LA170_0 = input.LA(1);

            if ( (LA170_0==Semicolon) ) {
                int LA170_1 = input.LA(2);

                if ( (synpred103_InternalN4JSParser()) ) {
                    alt170=1;
                }
            }
            else if ( (LA170_0==EOF||LA170_0==RULE_ML_COMMENT||LA170_0==RULE_EOL) && (synpred103_InternalN4JSParser())) {
                alt170=1;
            }
            else if ( (LA170_0==RightCurlyBracket) ) {
                int LA170_3 = input.LA(2);

                if ( (synpred103_InternalN4JSParser()) ) {
                    alt170=1;
                }
            }
            switch (alt170) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getDoStatementAccess().getSemiParserRuleCall_6());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    ruleSemi();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleWhileStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleWhileStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getWhileStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleWhileStatement=ruleWhileStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleWhileStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleWhileStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_1=null;
        Token otherlv_3=null;
        EObject lv_expression_2_0 = null;

        EObject lv_statement_4_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,While,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getWhileStatementAccess().getWhileKeyword_0());
              		
            }
            otherlv_1=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getWhileStatementAccess().getLeftParenthesisKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getWhileStatementAccess().getExpressionExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_2_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getWhileStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_3=(Token)match(input,RightParenthesis,FOLLOW_73); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getWhileStatementAccess().getRightParenthesisKeyword_3());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getWhileStatementAccess().getStatementStatementParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_statement_4_0=ruleStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getWhileStatementRule());
              					}
              					set(
              						current,
              						"statement",
              						lv_statement_4_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_WhileStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_1=null;
        Token otherlv_3=null;
        EObject lv_expression_2_0 = null;

        EObject lv_statement_4_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,While,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getWhileStatementAccess().getWhileKeyword_0());
              		
            }
            otherlv_1=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getWhileStatementAccess().getLeftParenthesisKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getWhileStatementAccess().getExpressionExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_2_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getWhileStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_3=(Token)match(input,RightParenthesis,FOLLOW_75); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getWhileStatementAccess().getRightParenthesisKeyword_3());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getWhileStatementAccess().getStatementStatementParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_statement_4_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getWhileStatementRule());
              					}
              					set(
              						current,
              						"statement",
              						lv_statement_4_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleForStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleForStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getForStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleForStatement=ruleForStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleForStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleForStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token lv_forIn_4_0=null;
        Token otherlv_6=null;
        Token lv_forIn_9_0=null;
        Token lv_forOf_10_0=null;
        Token otherlv_13=null;
        Token otherlv_15=null;
        Token otherlv_17=null;
        Token lv_forIn_19_0=null;
        Token lv_forOf_21_0=null;
        Token otherlv_24=null;
        Token otherlv_26=null;
        Token lv_forIn_28_0=null;
        Token lv_forOf_30_0=null;
        Token otherlv_32=null;
        Token otherlv_34=null;
        Token otherlv_36=null;
        EObject lv_initExpr_3_0 = null;

        EObject lv_expression_5_0 = null;

        Enumerator lv_varStmtKeyword_7_0 = null;

        EObject lv_varDeclsOrBindings_8_0 = null;

        EObject lv_expression_11_0 = null;

        EObject lv_varDeclsOrBindings_12_0 = null;

        EObject lv_varDeclsOrBindings_14_0 = null;

        EObject lv_expression_16_0 = null;

        EObject lv_updateExpr_18_0 = null;

        EObject lv_expression_20_0 = null;

        EObject lv_expression_22_0 = null;

        EObject lv_initExpr_23_0 = null;

        EObject lv_expression_25_0 = null;

        EObject lv_updateExpr_27_0 = null;

        EObject lv_expression_29_0 = null;

        EObject lv_expression_31_0 = null;

        EObject lv_expression_33_0 = null;

        EObject lv_updateExpr_35_0 = null;

        EObject lv_statement_37_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getForStatementAccess().getForStatementAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,For,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getForStatementAccess().getForKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,LeftParenthesis,FOLLOW_77); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getForStatementAccess().getLeftParenthesisKeyword_2());
              		
            }
            int alt188=2;
            alt188 = dfa188.predict(input);
            switch (alt188) {
                case 1 :
                    {
                    {
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      								newCompositeNode(grammarAccess.getForStatementAccess().getInitExprLetIdentifierRefParserRuleCall_3_0_0_0_0());
                      							
                    }
                    pushFollow(FOLLOW_78);
                    lv_initExpr_3_0=ruleLetIdentifierRef();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElementForParent(grammarAccess.getForStatementRule());
                      								}
                      								set(
                      									current,
                      									"initExpr",
                      									lv_initExpr_3_0,
                      									"org.eclipse.n4js.N4JS.LetIdentifierRef");
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }
                    {
                    {
                    lv_forIn_4_0=(Token)match(input,In,FOLLOW_49); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								newLeafNode(lv_forIn_4_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_0_0_1_0());
                      							
                    }
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElement(grammarAccess.getForStatementRule());
                      								}
                      								setWithLastConsumed(current, "forIn", true, "in");
                      							
                    }

                    }


                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      								newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_0_0_2_0());
                      							
                    }
                    pushFollow(FOLLOW_72);
                    lv_expression_5_0=norm1_Expression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElementForParent(grammarAccess.getForStatementRule());
                      								}
                      								set(
                      									current,
                      									"expression",
                      									lv_expression_5_0,
                      									"org.eclipse.n4js.N4JS.Expression");
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }

                    otherlv_6=(Token)match(input,RightParenthesis,FOLLOW_73); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(otherlv_6, grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_0_0_3());
                      					
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    int alt187=3;
                    alt187 = dfa187.predict(input);
                    switch (alt187) {
                        case 1 :
                            {
                            {
                            {
                            {
                            if ( state.backtracking==0 ) {

                              									newCompositeNode(grammarAccess.getForStatementAccess().getVarStmtKeywordVariableStatementKeywordEnumRuleCall_3_1_0_0_0_0());
                              								
                            }
                            pushFollow(FOLLOW_27);
                            lv_varStmtKeyword_7_0=ruleVariableStatementKeyword();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              									if (current==null) {
                              										current = createModelElementForParent(grammarAccess.getForStatementRule());
                              									}
                              									set(
                              										current,
                              										"varStmtKeyword",
                              										lv_varStmtKeyword_7_0,
                              										"org.eclipse.n4js.N4JS.VariableStatementKeyword");
                              									afterParserOrEnumRuleCall();
                              								
                            }

                            }


                            }
                            int alt179=2;
                            alt179 = dfa179.predict(input);
                            switch (alt179) {
                                case 1 :
                                    {
                                    {
                                    {
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      												newCompositeNode(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0());
                                      											
                                    }
                                    pushFollow(FOLLOW_79);
                                    lv_varDeclsOrBindings_8_0=ruleBindingIdentifierAsVariableDeclaration();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      												if (current==null) {
                                      													current = createModelElementForParent(grammarAccess.getForStatementRule());
                                      												}
                                      												add(
                                      													current,
                                      													"varDeclsOrBindings",
                                      													lv_varDeclsOrBindings_8_0,
                                      													"org.eclipse.n4js.N4JS.BindingIdentifierAsVariableDeclaration");
                                      												afterParserOrEnumRuleCall();
                                      											
                                    }

                                    }


                                    }
                                    int alt171=2;
                                    int LA171_0 = input.LA(1);

                                    if ( (LA171_0==In) ) {
                                        alt171=1;
                                    }
                                    else if ( (LA171_0==Of) ) {
                                        alt171=2;
                                    }
                                    else {
                                        if (state.backtracking>0) {state.failed=true; return current;}
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 171, 0, input);

                                        throw nvae;
                                    }
                                    switch (alt171) {
                                        case 1 :
                                            {
                                            {
                                            {
                                            lv_forIn_9_0=(Token)match(input,In,FOLLOW_80); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              													newLeafNode(lv_forIn_9_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_0_1_0_0_1_0_0());
                                              												
                                            }
                                            if ( state.backtracking==0 ) {

                                              													if (current==null) {
                                              														current = createModelElement(grammarAccess.getForStatementRule());
                                              													}
                                              													setWithLastConsumed(current, "forIn", true, "in");
                                              												
                                            }

                                            }


                                            }


                                            }
                                            break;
                                        case 2 :
                                            {
                                            {
                                            {
                                            lv_forOf_10_0=(Token)match(input,Of,FOLLOW_80); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              													newLeafNode(lv_forOf_10_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_0_1_0_0_1_1_0());
                                              												
                                            }
                                            if ( state.backtracking==0 ) {

                                              													if (current==null) {
                                              														current = createModelElement(grammarAccess.getForStatementRule());
                                              													}
                                              													setWithLastConsumed(current, "forOf", true, "of");
                                              												
                                            }

                                            }


                                            }


                                            }
                                            break;

                                    }
                                    int alt172=2;
                                    alt172 = dfa172.predict(input);
                                    switch (alt172) {
                                        case 1 :
                                            {
                                            {
                                            if ( state.backtracking==0 ) {

                                              												newCompositeNode(grammarAccess.getForStatementAccess().getExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0());
                                              											
                                            }
                                            pushFollow(FOLLOW_72);
                                            lv_expression_11_0=norm1_AssignmentExpression();

                                            state._fsp--;
                                            if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              												if (current==null) {
                                              													current = createModelElementForParent(grammarAccess.getForStatementRule());
                                              												}
                                              												set(
                                              													current,
                                              													"expression",
                                              													lv_expression_11_0,
                                              													"org.eclipse.n4js.N4JS.AssignmentExpression");
                                              												afterParserOrEnumRuleCall();
                                              											
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }


                                    }
                                    break;
                                case 2 :
                                    {
                                    {
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      											newCompositeNode(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0());
                                      										
                                    }
                                    pushFollow(FOLLOW_81);
                                    lv_varDeclsOrBindings_12_0=norm4_VariableDeclarationOrBinding();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      											if (current==null) {
                                      												current = createModelElementForParent(grammarAccess.getForStatementRule());
                                      											}
                                      											add(
                                      												current,
                                      												"varDeclsOrBindings",
                                      												lv_varDeclsOrBindings_12_0,
                                      												"org.eclipse.n4js.N4JS.VariableDeclarationOrBinding");
                                      											afterParserOrEnumRuleCall();
                                      										
                                    }

                                    }


                                    }
                                    int alt178=3;
                                    switch ( input.LA(1) ) {
                                    case Comma:
                                    case Semicolon:
                                        {
                                        alt178=1;
                                        }
                                        break;
                                    case In:
                                        {
                                        alt178=2;
                                        }
                                        break;
                                    case Of:
                                        {
                                        alt178=3;
                                        }
                                        break;
                                    default:
                                        if (state.backtracking>0) {state.failed=true; return current;}
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 178, 0, input);

                                        throw nvae;
                                    }

                                    switch (alt178) {
                                        case 1 :
                                            {
                                            {
                                            loop173:
                                            do {
                                                int alt173=2;
                                                int LA173_0 = input.LA(1);

                                                if ( (LA173_0==Comma) ) {
                                                    alt173=1;
                                                }


                                                switch (alt173) {
                                            	case 1 :
                                            	    {
                                            	    otherlv_13=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return current;
                                            	    if ( state.backtracking==0 ) {

                                            	      												newLeafNode(otherlv_13, grammarAccess.getForStatementAccess().getCommaKeyword_3_1_0_0_1_1_1_0_0_0());
                                            	      											
                                            	    }
                                            	    {
                                            	    {
                                            	    if ( state.backtracking==0 ) {

                                            	      														newCompositeNode(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0());
                                            	      													
                                            	    }
                                            	    pushFollow(FOLLOW_82);
                                            	    lv_varDeclsOrBindings_14_0=ruleVariableDeclarationOrBinding();

                                            	    state._fsp--;
                                            	    if (state.failed) return current;
                                            	    if ( state.backtracking==0 ) {

                                            	      														if (current==null) {
                                            	      															current = createModelElementForParent(grammarAccess.getForStatementRule());
                                            	      														}
                                            	      														add(
                                            	      															current,
                                            	      															"varDeclsOrBindings",
                                            	      															lv_varDeclsOrBindings_14_0,
                                            	      															"org.eclipse.n4js.N4JS.VariableDeclarationOrBinding");
                                            	      														afterParserOrEnumRuleCall();
                                            	      													
                                            	    }

                                            	    }


                                            	    }


                                            	    }
                                            	    break;

                                            	default :
                                            	    break loop173;
                                                }
                                            } while (true);

                                            otherlv_15=(Token)match(input,Semicolon,FOLLOW_83); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											newLeafNode(otherlv_15, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_1());
                                              										
                                            }
                                            int alt174=2;
                                            int LA174_0 = input.LA(1);

                                            if ( ((LA174_0>=Intersection && LA174_0<=Implements)||(LA174_0>=Promisify && LA174_0<=Abstract)||(LA174_0>=External && LA174_0<=Function)||(LA174_0>=Private && LA174_0<=Delete)||(LA174_0>=Import && LA174_0<=Public)||LA174_0==Static||(LA174_0>=Target && LA174_0<=Await)||LA174_0==Class||(LA174_0>=False && LA174_0<=Super)||LA174_0==Union||(LA174_0>=Yield && LA174_0<=This)||(LA174_0>=From && LA174_0<=Void)||(LA174_0>=Get && LA174_0<=Set)||LA174_0==PlusSignPlusSign||LA174_0==HyphenMinusHyphenMinus||LA174_0==SolidusEqualsSign||LA174_0==As||LA174_0==Of||LA174_0==ExclamationMark||LA174_0==LeftParenthesis||LA174_0==PlusSign||LA174_0==HyphenMinus||LA174_0==Solidus||LA174_0==LessThanSign||(LA174_0>=CommercialAt && LA174_0<=LeftSquareBracket)||LA174_0==LeftCurlyBracket||LA174_0==Tilde||LA174_0==RULE_DOUBLE||(LA174_0>=RULE_HEX_INT && LA174_0<=RULE_LEGACY_OCTAL_INT)||LA174_0==RULE_SCIENTIFIC_INT||LA174_0==RULE_IDENTIFIER||LA174_0==RULE_STRING||(LA174_0>=RULE_TEMPLATE_HEAD && LA174_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA174_0==RULE_INT) ) {
                                                alt174=1;
                                            }
                                            switch (alt174) {
                                                case 1 :
                                                    {
                                                    {
                                                    if ( state.backtracking==0 ) {

                                                      													newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0());
                                                      												
                                                    }
                                                    pushFollow(FOLLOW_84);
                                                    lv_expression_16_0=norm1_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return current;
                                                    if ( state.backtracking==0 ) {

                                                      													if (current==null) {
                                                      														current = createModelElementForParent(grammarAccess.getForStatementRule());
                                                      													}
                                                      													set(
                                                      														current,
                                                      														"expression",
                                                      														lv_expression_16_0,
                                                      														"org.eclipse.n4js.N4JS.Expression");
                                                      													afterParserOrEnumRuleCall();
                                                      												
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }

                                            otherlv_17=(Token)match(input,Semicolon,FOLLOW_80); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											newLeafNode(otherlv_17, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_3());
                                              										
                                            }
                                            int alt175=2;
                                            int LA175_0 = input.LA(1);

                                            if ( ((LA175_0>=Intersection && LA175_0<=Implements)||(LA175_0>=Promisify && LA175_0<=Abstract)||(LA175_0>=External && LA175_0<=Function)||(LA175_0>=Private && LA175_0<=Delete)||(LA175_0>=Import && LA175_0<=Public)||LA175_0==Static||(LA175_0>=Target && LA175_0<=Await)||LA175_0==Class||(LA175_0>=False && LA175_0<=Super)||LA175_0==Union||(LA175_0>=Yield && LA175_0<=This)||(LA175_0>=From && LA175_0<=Void)||(LA175_0>=Get && LA175_0<=Set)||LA175_0==PlusSignPlusSign||LA175_0==HyphenMinusHyphenMinus||LA175_0==SolidusEqualsSign||LA175_0==As||LA175_0==Of||LA175_0==ExclamationMark||LA175_0==LeftParenthesis||LA175_0==PlusSign||LA175_0==HyphenMinus||LA175_0==Solidus||LA175_0==LessThanSign||(LA175_0>=CommercialAt && LA175_0<=LeftSquareBracket)||LA175_0==LeftCurlyBracket||LA175_0==Tilde||LA175_0==RULE_DOUBLE||(LA175_0>=RULE_HEX_INT && LA175_0<=RULE_LEGACY_OCTAL_INT)||LA175_0==RULE_SCIENTIFIC_INT||LA175_0==RULE_IDENTIFIER||LA175_0==RULE_STRING||(LA175_0>=RULE_TEMPLATE_HEAD && LA175_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA175_0==RULE_INT) ) {
                                                alt175=1;
                                            }
                                            switch (alt175) {
                                                case 1 :
                                                    {
                                                    {
                                                    if ( state.backtracking==0 ) {

                                                      													newCompositeNode(grammarAccess.getForStatementAccess().getUpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0());
                                                      												
                                                    }
                                                    pushFollow(FOLLOW_72);
                                                    lv_updateExpr_18_0=norm1_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return current;
                                                    if ( state.backtracking==0 ) {

                                                      													if (current==null) {
                                                      														current = createModelElementForParent(grammarAccess.getForStatementRule());
                                                      													}
                                                      													set(
                                                      														current,
                                                      														"updateExpr",
                                                      														lv_updateExpr_18_0,
                                                      														"org.eclipse.n4js.N4JS.Expression");
                                                      													afterParserOrEnumRuleCall();
                                                      												
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;
                                        case 2 :
                                            {
                                            {
                                            {
                                            {
                                            lv_forIn_19_0=(Token)match(input,In,FOLLOW_80); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              													newLeafNode(lv_forIn_19_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_0_1_1_1_1_0_0());
                                              												
                                            }
                                            if ( state.backtracking==0 ) {

                                              													if (current==null) {
                                              														current = createModelElement(grammarAccess.getForStatementRule());
                                              													}
                                              													setWithLastConsumed(current, "forIn", true, "in");
                                              												
                                            }

                                            }


                                            }
                                            int alt176=2;
                                            int LA176_0 = input.LA(1);

                                            if ( ((LA176_0>=Intersection && LA176_0<=Implements)||(LA176_0>=Promisify && LA176_0<=Abstract)||(LA176_0>=External && LA176_0<=Function)||(LA176_0>=Private && LA176_0<=Delete)||(LA176_0>=Import && LA176_0<=Public)||LA176_0==Static||(LA176_0>=Target && LA176_0<=Await)||LA176_0==Class||(LA176_0>=False && LA176_0<=Super)||LA176_0==Union||(LA176_0>=Yield && LA176_0<=This)||(LA176_0>=From && LA176_0<=Void)||(LA176_0>=Get && LA176_0<=Set)||LA176_0==PlusSignPlusSign||LA176_0==HyphenMinusHyphenMinus||LA176_0==SolidusEqualsSign||LA176_0==As||LA176_0==Of||LA176_0==ExclamationMark||LA176_0==LeftParenthesis||LA176_0==PlusSign||LA176_0==HyphenMinus||LA176_0==Solidus||LA176_0==LessThanSign||(LA176_0>=CommercialAt && LA176_0<=LeftSquareBracket)||LA176_0==LeftCurlyBracket||LA176_0==Tilde||LA176_0==RULE_DOUBLE||(LA176_0>=RULE_HEX_INT && LA176_0<=RULE_LEGACY_OCTAL_INT)||LA176_0==RULE_SCIENTIFIC_INT||LA176_0==RULE_IDENTIFIER||LA176_0==RULE_STRING||(LA176_0>=RULE_TEMPLATE_HEAD && LA176_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA176_0==RULE_INT) ) {
                                                alt176=1;
                                            }
                                            switch (alt176) {
                                                case 1 :
                                                    {
                                                    {
                                                    if ( state.backtracking==0 ) {

                                                      													newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0());
                                                      												
                                                    }
                                                    pushFollow(FOLLOW_72);
                                                    lv_expression_20_0=norm1_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return current;
                                                    if ( state.backtracking==0 ) {

                                                      													if (current==null) {
                                                      														current = createModelElementForParent(grammarAccess.getForStatementRule());
                                                      													}
                                                      													set(
                                                      														current,
                                                      														"expression",
                                                      														lv_expression_20_0,
                                                      														"org.eclipse.n4js.N4JS.Expression");
                                                      													afterParserOrEnumRuleCall();
                                                      												
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;
                                        case 3 :
                                            {
                                            {
                                            {
                                            {
                                            lv_forOf_21_0=(Token)match(input,Of,FOLLOW_80); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              													newLeafNode(lv_forOf_21_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_0_1_1_1_2_0_0());
                                              												
                                            }
                                            if ( state.backtracking==0 ) {

                                              													if (current==null) {
                                              														current = createModelElement(grammarAccess.getForStatementRule());
                                              													}
                                              													setWithLastConsumed(current, "forOf", true, "of");
                                              												
                                            }

                                            }


                                            }
                                            int alt177=2;
                                            int LA177_0 = input.LA(1);

                                            if ( ((LA177_0>=Intersection && LA177_0<=Implements)||(LA177_0>=Promisify && LA177_0<=Abstract)||(LA177_0>=External && LA177_0<=Function)||(LA177_0>=Private && LA177_0<=Delete)||(LA177_0>=Import && LA177_0<=Public)||LA177_0==Static||(LA177_0>=Target && LA177_0<=Await)||LA177_0==Class||(LA177_0>=False && LA177_0<=Super)||LA177_0==Union||(LA177_0>=Yield && LA177_0<=This)||(LA177_0>=From && LA177_0<=Void)||(LA177_0>=Get && LA177_0<=Set)||LA177_0==PlusSignPlusSign||LA177_0==HyphenMinusHyphenMinus||LA177_0==SolidusEqualsSign||LA177_0==As||LA177_0==Of||LA177_0==ExclamationMark||LA177_0==LeftParenthesis||LA177_0==PlusSign||LA177_0==HyphenMinus||LA177_0==Solidus||LA177_0==LessThanSign||(LA177_0>=CommercialAt && LA177_0<=LeftSquareBracket)||LA177_0==LeftCurlyBracket||LA177_0==Tilde||LA177_0==RULE_DOUBLE||(LA177_0>=RULE_HEX_INT && LA177_0<=RULE_LEGACY_OCTAL_INT)||LA177_0==RULE_SCIENTIFIC_INT||LA177_0==RULE_IDENTIFIER||LA177_0==RULE_STRING||(LA177_0>=RULE_TEMPLATE_HEAD && LA177_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA177_0==RULE_INT) ) {
                                                alt177=1;
                                            }
                                            switch (alt177) {
                                                case 1 :
                                                    {
                                                    {
                                                    if ( state.backtracking==0 ) {

                                                      													newCompositeNode(grammarAccess.getForStatementAccess().getExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0());
                                                      												
                                                    }
                                                    pushFollow(FOLLOW_72);
                                                    lv_expression_22_0=norm1_AssignmentExpression();

                                                    state._fsp--;
                                                    if (state.failed) return current;
                                                    if ( state.backtracking==0 ) {

                                                      													if (current==null) {
                                                      														current = createModelElementForParent(grammarAccess.getForStatementRule());
                                                      													}
                                                      													set(
                                                      														current,
                                                      														"expression",
                                                      														lv_expression_22_0,
                                                      														"org.eclipse.n4js.N4JS.AssignmentExpression");
                                                      													afterParserOrEnumRuleCall();
                                                      												
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            {
                            {
                            if ( state.backtracking==0 ) {

                              									newCompositeNode(grammarAccess.getForStatementAccess().getInitExprExpressionParserRuleCall_3_1_0_1_0_0());
                              								
                            }
                            pushFollow(FOLLOW_85);
                            lv_initExpr_23_0=ruleExpression();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              									if (current==null) {
                              										current = createModelElementForParent(grammarAccess.getForStatementRule());
                              									}
                              									set(
                              										current,
                              										"initExpr",
                              										lv_initExpr_23_0,
                              										"org.eclipse.n4js.N4JS.Expression");
                              									afterParserOrEnumRuleCall();
                              								
                            }

                            }


                            }
                            int alt184=3;
                            switch ( input.LA(1) ) {
                            case Semicolon:
                                {
                                alt184=1;
                                }
                                break;
                            case In:
                                {
                                alt184=2;
                                }
                                break;
                            case Of:
                                {
                                alt184=3;
                                }
                                break;
                            default:
                                if (state.backtracking>0) {state.failed=true; return current;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 184, 0, input);

                                throw nvae;
                            }

                            switch (alt184) {
                                case 1 :
                                    {
                                    {
                                    otherlv_24=(Token)match(input,Semicolon,FOLLOW_83); if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									newLeafNode(otherlv_24, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_0());
                                      								
                                    }
                                    int alt180=2;
                                    int LA180_0 = input.LA(1);

                                    if ( ((LA180_0>=Intersection && LA180_0<=Implements)||(LA180_0>=Promisify && LA180_0<=Abstract)||(LA180_0>=External && LA180_0<=Function)||(LA180_0>=Private && LA180_0<=Delete)||(LA180_0>=Import && LA180_0<=Public)||LA180_0==Static||(LA180_0>=Target && LA180_0<=Await)||LA180_0==Class||(LA180_0>=False && LA180_0<=Super)||LA180_0==Union||(LA180_0>=Yield && LA180_0<=This)||(LA180_0>=From && LA180_0<=Void)||(LA180_0>=Get && LA180_0<=Set)||LA180_0==PlusSignPlusSign||LA180_0==HyphenMinusHyphenMinus||LA180_0==SolidusEqualsSign||LA180_0==As||LA180_0==Of||LA180_0==ExclamationMark||LA180_0==LeftParenthesis||LA180_0==PlusSign||LA180_0==HyphenMinus||LA180_0==Solidus||LA180_0==LessThanSign||(LA180_0>=CommercialAt && LA180_0<=LeftSquareBracket)||LA180_0==LeftCurlyBracket||LA180_0==Tilde||LA180_0==RULE_DOUBLE||(LA180_0>=RULE_HEX_INT && LA180_0<=RULE_LEGACY_OCTAL_INT)||LA180_0==RULE_SCIENTIFIC_INT||LA180_0==RULE_IDENTIFIER||LA180_0==RULE_STRING||(LA180_0>=RULE_TEMPLATE_HEAD && LA180_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA180_0==RULE_INT) ) {
                                        alt180=1;
                                    }
                                    switch (alt180) {
                                        case 1 :
                                            {
                                            {
                                            if ( state.backtracking==0 ) {

                                              											newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0());
                                              										
                                            }
                                            pushFollow(FOLLOW_84);
                                            lv_expression_25_0=norm1_Expression();

                                            state._fsp--;
                                            if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											if (current==null) {
                                              												current = createModelElementForParent(grammarAccess.getForStatementRule());
                                              											}
                                              											set(
                                              												current,
                                              												"expression",
                                              												lv_expression_25_0,
                                              												"org.eclipse.n4js.N4JS.Expression");
                                              											afterParserOrEnumRuleCall();
                                              										
                                            }

                                            }


                                            }
                                            break;

                                    }

                                    otherlv_26=(Token)match(input,Semicolon,FOLLOW_80); if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									newLeafNode(otherlv_26, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_2());
                                      								
                                    }
                                    int alt181=2;
                                    int LA181_0 = input.LA(1);

                                    if ( ((LA181_0>=Intersection && LA181_0<=Implements)||(LA181_0>=Promisify && LA181_0<=Abstract)||(LA181_0>=External && LA181_0<=Function)||(LA181_0>=Private && LA181_0<=Delete)||(LA181_0>=Import && LA181_0<=Public)||LA181_0==Static||(LA181_0>=Target && LA181_0<=Await)||LA181_0==Class||(LA181_0>=False && LA181_0<=Super)||LA181_0==Union||(LA181_0>=Yield && LA181_0<=This)||(LA181_0>=From && LA181_0<=Void)||(LA181_0>=Get && LA181_0<=Set)||LA181_0==PlusSignPlusSign||LA181_0==HyphenMinusHyphenMinus||LA181_0==SolidusEqualsSign||LA181_0==As||LA181_0==Of||LA181_0==ExclamationMark||LA181_0==LeftParenthesis||LA181_0==PlusSign||LA181_0==HyphenMinus||LA181_0==Solidus||LA181_0==LessThanSign||(LA181_0>=CommercialAt && LA181_0<=LeftSquareBracket)||LA181_0==LeftCurlyBracket||LA181_0==Tilde||LA181_0==RULE_DOUBLE||(LA181_0>=RULE_HEX_INT && LA181_0<=RULE_LEGACY_OCTAL_INT)||LA181_0==RULE_SCIENTIFIC_INT||LA181_0==RULE_IDENTIFIER||LA181_0==RULE_STRING||(LA181_0>=RULE_TEMPLATE_HEAD && LA181_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA181_0==RULE_INT) ) {
                                        alt181=1;
                                    }
                                    switch (alt181) {
                                        case 1 :
                                            {
                                            {
                                            if ( state.backtracking==0 ) {

                                              											newCompositeNode(grammarAccess.getForStatementAccess().getUpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0());
                                              										
                                            }
                                            pushFollow(FOLLOW_72);
                                            lv_updateExpr_27_0=norm1_Expression();

                                            state._fsp--;
                                            if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											if (current==null) {
                                              												current = createModelElementForParent(grammarAccess.getForStatementRule());
                                              											}
                                              											set(
                                              												current,
                                              												"updateExpr",
                                              												lv_updateExpr_27_0,
                                              												"org.eclipse.n4js.N4JS.Expression");
                                              											afterParserOrEnumRuleCall();
                                              										
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;
                                case 2 :
                                    {
                                    {
                                    {
                                    {
                                    lv_forIn_28_0=(Token)match(input,In,FOLLOW_80); if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      											newLeafNode(lv_forIn_28_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_1_1_1_0_0());
                                      										
                                    }
                                    if ( state.backtracking==0 ) {

                                      											if (current==null) {
                                      												current = createModelElement(grammarAccess.getForStatementRule());
                                      											}
                                      											setWithLastConsumed(current, "forIn", true, "in");
                                      										
                                    }

                                    }


                                    }
                                    int alt182=2;
                                    int LA182_0 = input.LA(1);

                                    if ( ((LA182_0>=Intersection && LA182_0<=Implements)||(LA182_0>=Promisify && LA182_0<=Abstract)||(LA182_0>=External && LA182_0<=Function)||(LA182_0>=Private && LA182_0<=Delete)||(LA182_0>=Import && LA182_0<=Public)||LA182_0==Static||(LA182_0>=Target && LA182_0<=Await)||LA182_0==Class||(LA182_0>=False && LA182_0<=Super)||LA182_0==Union||(LA182_0>=Yield && LA182_0<=This)||(LA182_0>=From && LA182_0<=Void)||(LA182_0>=Get && LA182_0<=Set)||LA182_0==PlusSignPlusSign||LA182_0==HyphenMinusHyphenMinus||LA182_0==SolidusEqualsSign||LA182_0==As||LA182_0==Of||LA182_0==ExclamationMark||LA182_0==LeftParenthesis||LA182_0==PlusSign||LA182_0==HyphenMinus||LA182_0==Solidus||LA182_0==LessThanSign||(LA182_0>=CommercialAt && LA182_0<=LeftSquareBracket)||LA182_0==LeftCurlyBracket||LA182_0==Tilde||LA182_0==RULE_DOUBLE||(LA182_0>=RULE_HEX_INT && LA182_0<=RULE_LEGACY_OCTAL_INT)||LA182_0==RULE_SCIENTIFIC_INT||LA182_0==RULE_IDENTIFIER||LA182_0==RULE_STRING||(LA182_0>=RULE_TEMPLATE_HEAD && LA182_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA182_0==RULE_INT) ) {
                                        alt182=1;
                                    }
                                    switch (alt182) {
                                        case 1 :
                                            {
                                            {
                                            if ( state.backtracking==0 ) {

                                              											newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0());
                                              										
                                            }
                                            pushFollow(FOLLOW_72);
                                            lv_expression_29_0=norm1_Expression();

                                            state._fsp--;
                                            if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											if (current==null) {
                                              												current = createModelElementForParent(grammarAccess.getForStatementRule());
                                              											}
                                              											set(
                                              												current,
                                              												"expression",
                                              												lv_expression_29_0,
                                              												"org.eclipse.n4js.N4JS.Expression");
                                              											afterParserOrEnumRuleCall();
                                              										
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;
                                case 3 :
                                    {
                                    {
                                    {
                                    {
                                    lv_forOf_30_0=(Token)match(input,Of,FOLLOW_80); if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      											newLeafNode(lv_forOf_30_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_1_1_2_0_0());
                                      										
                                    }
                                    if ( state.backtracking==0 ) {

                                      											if (current==null) {
                                      												current = createModelElement(grammarAccess.getForStatementRule());
                                      											}
                                      											setWithLastConsumed(current, "forOf", true, "of");
                                      										
                                    }

                                    }


                                    }
                                    int alt183=2;
                                    int LA183_0 = input.LA(1);

                                    if ( ((LA183_0>=Intersection && LA183_0<=Implements)||(LA183_0>=Promisify && LA183_0<=Abstract)||(LA183_0>=External && LA183_0<=Function)||(LA183_0>=Private && LA183_0<=Delete)||(LA183_0>=Import && LA183_0<=Public)||LA183_0==Static||(LA183_0>=Target && LA183_0<=Await)||LA183_0==Class||(LA183_0>=False && LA183_0<=Super)||LA183_0==Union||(LA183_0>=Yield && LA183_0<=This)||(LA183_0>=From && LA183_0<=Void)||(LA183_0>=Get && LA183_0<=Set)||LA183_0==PlusSignPlusSign||LA183_0==HyphenMinusHyphenMinus||LA183_0==SolidusEqualsSign||LA183_0==As||LA183_0==Of||LA183_0==ExclamationMark||LA183_0==LeftParenthesis||LA183_0==PlusSign||LA183_0==HyphenMinus||LA183_0==Solidus||LA183_0==LessThanSign||(LA183_0>=CommercialAt && LA183_0<=LeftSquareBracket)||LA183_0==LeftCurlyBracket||LA183_0==Tilde||LA183_0==RULE_DOUBLE||(LA183_0>=RULE_HEX_INT && LA183_0<=RULE_LEGACY_OCTAL_INT)||LA183_0==RULE_SCIENTIFIC_INT||LA183_0==RULE_IDENTIFIER||LA183_0==RULE_STRING||(LA183_0>=RULE_TEMPLATE_HEAD && LA183_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA183_0==RULE_INT) ) {
                                        alt183=1;
                                    }
                                    switch (alt183) {
                                        case 1 :
                                            {
                                            {
                                            if ( state.backtracking==0 ) {

                                              											newCompositeNode(grammarAccess.getForStatementAccess().getExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0());
                                              										
                                            }
                                            pushFollow(FOLLOW_72);
                                            lv_expression_31_0=norm1_AssignmentExpression();

                                            state._fsp--;
                                            if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											if (current==null) {
                                              												current = createModelElementForParent(grammarAccess.getForStatementRule());
                                              											}
                                              											set(
                                              												current,
                                              												"expression",
                                              												lv_expression_31_0,
                                              												"org.eclipse.n4js.N4JS.AssignmentExpression");
                                              											afterParserOrEnumRuleCall();
                                              										
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 3 :
                            {
                            {
                            otherlv_32=(Token)match(input,Semicolon,FOLLOW_83); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(otherlv_32, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_0());
                              						
                            }
                            int alt185=2;
                            int LA185_0 = input.LA(1);

                            if ( ((LA185_0>=Intersection && LA185_0<=Implements)||(LA185_0>=Promisify && LA185_0<=Abstract)||(LA185_0>=External && LA185_0<=Function)||(LA185_0>=Private && LA185_0<=Delete)||(LA185_0>=Import && LA185_0<=Public)||LA185_0==Static||(LA185_0>=Target && LA185_0<=Await)||LA185_0==Class||(LA185_0>=False && LA185_0<=Super)||LA185_0==Union||(LA185_0>=Yield && LA185_0<=This)||(LA185_0>=From && LA185_0<=Void)||(LA185_0>=Get && LA185_0<=Set)||LA185_0==PlusSignPlusSign||LA185_0==HyphenMinusHyphenMinus||LA185_0==SolidusEqualsSign||LA185_0==As||LA185_0==Of||LA185_0==ExclamationMark||LA185_0==LeftParenthesis||LA185_0==PlusSign||LA185_0==HyphenMinus||LA185_0==Solidus||LA185_0==LessThanSign||(LA185_0>=CommercialAt && LA185_0<=LeftSquareBracket)||LA185_0==LeftCurlyBracket||LA185_0==Tilde||LA185_0==RULE_DOUBLE||(LA185_0>=RULE_HEX_INT && LA185_0<=RULE_LEGACY_OCTAL_INT)||LA185_0==RULE_SCIENTIFIC_INT||LA185_0==RULE_IDENTIFIER||LA185_0==RULE_STRING||(LA185_0>=RULE_TEMPLATE_HEAD && LA185_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA185_0==RULE_INT) ) {
                                alt185=1;
                            }
                            switch (alt185) {
                                case 1 :
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      									newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_1_0_2_1_0());
                                      								
                                    }
                                    pushFollow(FOLLOW_84);
                                    lv_expression_33_0=norm1_Expression();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									if (current==null) {
                                      										current = createModelElementForParent(grammarAccess.getForStatementRule());
                                      									}
                                      									set(
                                      										current,
                                      										"expression",
                                      										lv_expression_33_0,
                                      										"org.eclipse.n4js.N4JS.Expression");
                                      									afterParserOrEnumRuleCall();
                                      								
                                    }

                                    }


                                    }
                                    break;

                            }

                            otherlv_34=(Token)match(input,Semicolon,FOLLOW_80); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(otherlv_34, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_2());
                              						
                            }
                            int alt186=2;
                            int LA186_0 = input.LA(1);

                            if ( ((LA186_0>=Intersection && LA186_0<=Implements)||(LA186_0>=Promisify && LA186_0<=Abstract)||(LA186_0>=External && LA186_0<=Function)||(LA186_0>=Private && LA186_0<=Delete)||(LA186_0>=Import && LA186_0<=Public)||LA186_0==Static||(LA186_0>=Target && LA186_0<=Await)||LA186_0==Class||(LA186_0>=False && LA186_0<=Super)||LA186_0==Union||(LA186_0>=Yield && LA186_0<=This)||(LA186_0>=From && LA186_0<=Void)||(LA186_0>=Get && LA186_0<=Set)||LA186_0==PlusSignPlusSign||LA186_0==HyphenMinusHyphenMinus||LA186_0==SolidusEqualsSign||LA186_0==As||LA186_0==Of||LA186_0==ExclamationMark||LA186_0==LeftParenthesis||LA186_0==PlusSign||LA186_0==HyphenMinus||LA186_0==Solidus||LA186_0==LessThanSign||(LA186_0>=CommercialAt && LA186_0<=LeftSquareBracket)||LA186_0==LeftCurlyBracket||LA186_0==Tilde||LA186_0==RULE_DOUBLE||(LA186_0>=RULE_HEX_INT && LA186_0<=RULE_LEGACY_OCTAL_INT)||LA186_0==RULE_SCIENTIFIC_INT||LA186_0==RULE_IDENTIFIER||LA186_0==RULE_STRING||(LA186_0>=RULE_TEMPLATE_HEAD && LA186_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA186_0==RULE_INT) ) {
                                alt186=1;
                            }
                            switch (alt186) {
                                case 1 :
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      									newCompositeNode(grammarAccess.getForStatementAccess().getUpdateExprExpressionParserRuleCall_3_1_0_2_3_0());
                                      								
                                    }
                                    pushFollow(FOLLOW_72);
                                    lv_updateExpr_35_0=norm1_Expression();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									if (current==null) {
                                      										current = createModelElementForParent(grammarAccess.getForStatementRule());
                                      									}
                                      									set(
                                      										current,
                                      										"updateExpr",
                                      										lv_updateExpr_35_0,
                                      										"org.eclipse.n4js.N4JS.Expression");
                                      									afterParserOrEnumRuleCall();
                                      								
                                    }

                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;

                    }

                    otherlv_36=(Token)match(input,RightParenthesis,FOLLOW_73); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_36, grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_1_1());
                      				
                    }

                    }


                    }
                    break;

            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getForStatementAccess().getStatementStatementParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_statement_37_0=ruleStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getForStatementRule());
              					}
              					set(
              						current,
              						"statement",
              						lv_statement_37_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ForStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token lv_forIn_4_0=null;
        Token otherlv_6=null;
        Token lv_forIn_9_0=null;
        Token lv_forOf_10_0=null;
        Token otherlv_13=null;
        Token otherlv_15=null;
        Token otherlv_17=null;
        Token lv_forIn_19_0=null;
        Token lv_forOf_21_0=null;
        Token otherlv_24=null;
        Token otherlv_26=null;
        Token lv_forIn_28_0=null;
        Token lv_forOf_30_0=null;
        Token otherlv_32=null;
        Token otherlv_34=null;
        Token otherlv_36=null;
        EObject lv_initExpr_3_0 = null;

        EObject lv_expression_5_0 = null;

        Enumerator lv_varStmtKeyword_7_0 = null;

        EObject lv_varDeclsOrBindings_8_0 = null;

        EObject lv_expression_11_0 = null;

        EObject lv_varDeclsOrBindings_12_0 = null;

        EObject lv_varDeclsOrBindings_14_0 = null;

        EObject lv_expression_16_0 = null;

        EObject lv_updateExpr_18_0 = null;

        EObject lv_expression_20_0 = null;

        EObject lv_expression_22_0 = null;

        EObject lv_initExpr_23_0 = null;

        EObject lv_expression_25_0 = null;

        EObject lv_updateExpr_27_0 = null;

        EObject lv_expression_29_0 = null;

        EObject lv_expression_31_0 = null;

        EObject lv_expression_33_0 = null;

        EObject lv_updateExpr_35_0 = null;

        EObject lv_statement_37_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getForStatementAccess().getForStatementAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,For,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getForStatementAccess().getForKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,LeftParenthesis,FOLLOW_86); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getForStatementAccess().getLeftParenthesisKeyword_2());
              		
            }
            int alt206=2;
            alt206 = dfa206.predict(input);
            switch (alt206) {
                case 1 :
                    {
                    {
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      								newCompositeNode(grammarAccess.getForStatementAccess().getInitExprLetIdentifierRefParserRuleCall_3_0_0_0_0());
                      							
                    }
                    pushFollow(FOLLOW_78);
                    lv_initExpr_3_0=ruleLetIdentifierRef();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElementForParent(grammarAccess.getForStatementRule());
                      								}
                      								set(
                      									current,
                      									"initExpr",
                      									lv_initExpr_3_0,
                      									"org.eclipse.n4js.N4JS.LetIdentifierRef");
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }
                    {
                    {
                    lv_forIn_4_0=(Token)match(input,In,FOLLOW_70); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								newLeafNode(lv_forIn_4_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_0_0_1_0());
                      							
                    }
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElement(grammarAccess.getForStatementRule());
                      								}
                      								setWithLastConsumed(current, "forIn", true, "in");
                      							
                    }

                    }


                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      								newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_0_0_2_0());
                      							
                    }
                    pushFollow(FOLLOW_72);
                    lv_expression_5_0=norm3_Expression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      								if (current==null) {
                      									current = createModelElementForParent(grammarAccess.getForStatementRule());
                      								}
                      								set(
                      									current,
                      									"expression",
                      									lv_expression_5_0,
                      									"org.eclipse.n4js.N4JS.Expression");
                      								afterParserOrEnumRuleCall();
                      							
                    }

                    }


                    }

                    otherlv_6=(Token)match(input,RightParenthesis,FOLLOW_75); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						newLeafNode(otherlv_6, grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_0_0_3());
                      					
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    int alt205=3;
                    alt205 = dfa205.predict(input);
                    switch (alt205) {
                        case 1 :
                            {
                            {
                            {
                            {
                            if ( state.backtracking==0 ) {

                              									newCompositeNode(grammarAccess.getForStatementAccess().getVarStmtKeywordVariableStatementKeywordEnumRuleCall_3_1_0_0_0_0());
                              								
                            }
                            pushFollow(FOLLOW_27);
                            lv_varStmtKeyword_7_0=ruleVariableStatementKeyword();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              									if (current==null) {
                              										current = createModelElementForParent(grammarAccess.getForStatementRule());
                              									}
                              									set(
                              										current,
                              										"varStmtKeyword",
                              										lv_varStmtKeyword_7_0,
                              										"org.eclipse.n4js.N4JS.VariableStatementKeyword");
                              									afterParserOrEnumRuleCall();
                              								
                            }

                            }


                            }
                            int alt197=2;
                            alt197 = dfa197.predict(input);
                            switch (alt197) {
                                case 1 :
                                    {
                                    {
                                    {
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      												newCompositeNode(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsBindingIdentifierAsVariableDeclarationParserRuleCall_3_1_0_0_1_0_0_0_0());
                                      											
                                    }
                                    pushFollow(FOLLOW_79);
                                    lv_varDeclsOrBindings_8_0=norm2_BindingIdentifierAsVariableDeclaration();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      												if (current==null) {
                                      													current = createModelElementForParent(grammarAccess.getForStatementRule());
                                      												}
                                      												add(
                                      													current,
                                      													"varDeclsOrBindings",
                                      													lv_varDeclsOrBindings_8_0,
                                      													"org.eclipse.n4js.N4JS.BindingIdentifierAsVariableDeclaration");
                                      												afterParserOrEnumRuleCall();
                                      											
                                    }

                                    }


                                    }
                                    int alt189=2;
                                    int LA189_0 = input.LA(1);

                                    if ( (LA189_0==In) ) {
                                        alt189=1;
                                    }
                                    else if ( (LA189_0==Of) ) {
                                        alt189=2;
                                    }
                                    else {
                                        if (state.backtracking>0) {state.failed=true; return current;}
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 189, 0, input);

                                        throw nvae;
                                    }
                                    switch (alt189) {
                                        case 1 :
                                            {
                                            {
                                            {
                                            lv_forIn_9_0=(Token)match(input,In,FOLLOW_87); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              													newLeafNode(lv_forIn_9_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_0_1_0_0_1_0_0());
                                              												
                                            }
                                            if ( state.backtracking==0 ) {

                                              													if (current==null) {
                                              														current = createModelElement(grammarAccess.getForStatementRule());
                                              													}
                                              													setWithLastConsumed(current, "forIn", true, "in");
                                              												
                                            }

                                            }


                                            }


                                            }
                                            break;
                                        case 2 :
                                            {
                                            {
                                            {
                                            lv_forOf_10_0=(Token)match(input,Of,FOLLOW_87); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              													newLeafNode(lv_forOf_10_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_0_1_0_0_1_1_0());
                                              												
                                            }
                                            if ( state.backtracking==0 ) {

                                              													if (current==null) {
                                              														current = createModelElement(grammarAccess.getForStatementRule());
                                              													}
                                              													setWithLastConsumed(current, "forOf", true, "of");
                                              												
                                            }

                                            }


                                            }


                                            }
                                            break;

                                    }
                                    int alt190=2;
                                    alt190 = dfa190.predict(input);
                                    switch (alt190) {
                                        case 1 :
                                            {
                                            {
                                            if ( state.backtracking==0 ) {

                                              												newCompositeNode(grammarAccess.getForStatementAccess().getExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_0_0_2_0());
                                              											
                                            }
                                            pushFollow(FOLLOW_72);
                                            lv_expression_11_0=norm3_AssignmentExpression();

                                            state._fsp--;
                                            if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              												if (current==null) {
                                              													current = createModelElementForParent(grammarAccess.getForStatementRule());
                                              												}
                                              												set(
                                              													current,
                                              													"expression",
                                              													lv_expression_11_0,
                                              													"org.eclipse.n4js.N4JS.AssignmentExpression");
                                              												afterParserOrEnumRuleCall();
                                              											
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }


                                    }
                                    break;
                                case 2 :
                                    {
                                    {
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      											newCompositeNode(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_0_0());
                                      										
                                    }
                                    pushFollow(FOLLOW_81);
                                    lv_varDeclsOrBindings_12_0=norm6_VariableDeclarationOrBinding();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      											if (current==null) {
                                      												current = createModelElementForParent(grammarAccess.getForStatementRule());
                                      											}
                                      											add(
                                      												current,
                                      												"varDeclsOrBindings",
                                      												lv_varDeclsOrBindings_12_0,
                                      												"org.eclipse.n4js.N4JS.VariableDeclarationOrBinding");
                                      											afterParserOrEnumRuleCall();
                                      										
                                    }

                                    }


                                    }
                                    int alt196=3;
                                    switch ( input.LA(1) ) {
                                    case Comma:
                                    case Semicolon:
                                        {
                                        alt196=1;
                                        }
                                        break;
                                    case In:
                                        {
                                        alt196=2;
                                        }
                                        break;
                                    case Of:
                                        {
                                        alt196=3;
                                        }
                                        break;
                                    default:
                                        if (state.backtracking>0) {state.failed=true; return current;}
                                        NoViableAltException nvae =
                                            new NoViableAltException("", 196, 0, input);

                                        throw nvae;
                                    }

                                    switch (alt196) {
                                        case 1 :
                                            {
                                            {
                                            loop191:
                                            do {
                                                int alt191=2;
                                                int LA191_0 = input.LA(1);

                                                if ( (LA191_0==Comma) ) {
                                                    alt191=1;
                                                }


                                                switch (alt191) {
                                            	case 1 :
                                            	    {
                                            	    otherlv_13=(Token)match(input,Comma,FOLLOW_27); if (state.failed) return current;
                                            	    if ( state.backtracking==0 ) {

                                            	      												newLeafNode(otherlv_13, grammarAccess.getForStatementAccess().getCommaKeyword_3_1_0_0_1_1_1_0_0_0());
                                            	      											
                                            	    }
                                            	    {
                                            	    {
                                            	    if ( state.backtracking==0 ) {

                                            	      														newCompositeNode(grammarAccess.getForStatementAccess().getVarDeclsOrBindingsVariableDeclarationOrBindingParserRuleCall_3_1_0_0_1_1_1_0_0_1_0());
                                            	      													
                                            	    }
                                            	    pushFollow(FOLLOW_82);
                                            	    lv_varDeclsOrBindings_14_0=norm2_VariableDeclarationOrBinding();

                                            	    state._fsp--;
                                            	    if (state.failed) return current;
                                            	    if ( state.backtracking==0 ) {

                                            	      														if (current==null) {
                                            	      															current = createModelElementForParent(grammarAccess.getForStatementRule());
                                            	      														}
                                            	      														add(
                                            	      															current,
                                            	      															"varDeclsOrBindings",
                                            	      															lv_varDeclsOrBindings_14_0,
                                            	      															"org.eclipse.n4js.N4JS.VariableDeclarationOrBinding");
                                            	      														afterParserOrEnumRuleCall();
                                            	      													
                                            	    }

                                            	    }


                                            	    }


                                            	    }
                                            	    break;

                                            	default :
                                            	    break loop191;
                                                }
                                            } while (true);

                                            otherlv_15=(Token)match(input,Semicolon,FOLLOW_88); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											newLeafNode(otherlv_15, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_1());
                                              										
                                            }
                                            int alt192=2;
                                            int LA192_0 = input.LA(1);

                                            if ( ((LA192_0>=Intersection && LA192_0<=Implements)||(LA192_0>=Promisify && LA192_0<=Abstract)||(LA192_0>=External && LA192_0<=Function)||(LA192_0>=Private && LA192_0<=Delete)||(LA192_0>=Import && LA192_0<=Public)||LA192_0==Static||(LA192_0>=Target && LA192_0<=Await)||LA192_0==Class||(LA192_0>=False && LA192_0<=Super)||LA192_0==Union||(LA192_0>=Yield && LA192_0<=This)||(LA192_0>=From && LA192_0<=Void)||(LA192_0>=Get && LA192_0<=Set)||LA192_0==PlusSignPlusSign||LA192_0==HyphenMinusHyphenMinus||LA192_0==SolidusEqualsSign||LA192_0==As||LA192_0==Of||LA192_0==ExclamationMark||LA192_0==LeftParenthesis||LA192_0==PlusSign||LA192_0==HyphenMinus||LA192_0==Solidus||LA192_0==LessThanSign||(LA192_0>=CommercialAt && LA192_0<=LeftSquareBracket)||LA192_0==LeftCurlyBracket||LA192_0==Tilde||LA192_0==RULE_DOUBLE||(LA192_0>=RULE_HEX_INT && LA192_0<=RULE_LEGACY_OCTAL_INT)||LA192_0==RULE_SCIENTIFIC_INT||LA192_0==RULE_IDENTIFIER||LA192_0==RULE_STRING||(LA192_0>=RULE_TEMPLATE_HEAD && LA192_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA192_0==RULE_INT) ) {
                                                alt192=1;
                                            }
                                            switch (alt192) {
                                                case 1 :
                                                    {
                                                    {
                                                    if ( state.backtracking==0 ) {

                                                      													newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_0_2_0());
                                                      												
                                                    }
                                                    pushFollow(FOLLOW_84);
                                                    lv_expression_16_0=norm3_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return current;
                                                    if ( state.backtracking==0 ) {

                                                      													if (current==null) {
                                                      														current = createModelElementForParent(grammarAccess.getForStatementRule());
                                                      													}
                                                      													set(
                                                      														current,
                                                      														"expression",
                                                      														lv_expression_16_0,
                                                      														"org.eclipse.n4js.N4JS.Expression");
                                                      													afterParserOrEnumRuleCall();
                                                      												
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }

                                            otherlv_17=(Token)match(input,Semicolon,FOLLOW_87); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											newLeafNode(otherlv_17, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_0_1_1_1_0_3());
                                              										
                                            }
                                            int alt193=2;
                                            int LA193_0 = input.LA(1);

                                            if ( ((LA193_0>=Intersection && LA193_0<=Implements)||(LA193_0>=Promisify && LA193_0<=Abstract)||(LA193_0>=External && LA193_0<=Function)||(LA193_0>=Private && LA193_0<=Delete)||(LA193_0>=Import && LA193_0<=Public)||LA193_0==Static||(LA193_0>=Target && LA193_0<=Await)||LA193_0==Class||(LA193_0>=False && LA193_0<=Super)||LA193_0==Union||(LA193_0>=Yield && LA193_0<=This)||(LA193_0>=From && LA193_0<=Void)||(LA193_0>=Get && LA193_0<=Set)||LA193_0==PlusSignPlusSign||LA193_0==HyphenMinusHyphenMinus||LA193_0==SolidusEqualsSign||LA193_0==As||LA193_0==Of||LA193_0==ExclamationMark||LA193_0==LeftParenthesis||LA193_0==PlusSign||LA193_0==HyphenMinus||LA193_0==Solidus||LA193_0==LessThanSign||(LA193_0>=CommercialAt && LA193_0<=LeftSquareBracket)||LA193_0==LeftCurlyBracket||LA193_0==Tilde||LA193_0==RULE_DOUBLE||(LA193_0>=RULE_HEX_INT && LA193_0<=RULE_LEGACY_OCTAL_INT)||LA193_0==RULE_SCIENTIFIC_INT||LA193_0==RULE_IDENTIFIER||LA193_0==RULE_STRING||(LA193_0>=RULE_TEMPLATE_HEAD && LA193_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA193_0==RULE_INT) ) {
                                                alt193=1;
                                            }
                                            switch (alt193) {
                                                case 1 :
                                                    {
                                                    {
                                                    if ( state.backtracking==0 ) {

                                                      													newCompositeNode(grammarAccess.getForStatementAccess().getUpdateExprExpressionParserRuleCall_3_1_0_0_1_1_1_0_4_0());
                                                      												
                                                    }
                                                    pushFollow(FOLLOW_72);
                                                    lv_updateExpr_18_0=norm3_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return current;
                                                    if ( state.backtracking==0 ) {

                                                      													if (current==null) {
                                                      														current = createModelElementForParent(grammarAccess.getForStatementRule());
                                                      													}
                                                      													set(
                                                      														current,
                                                      														"updateExpr",
                                                      														lv_updateExpr_18_0,
                                                      														"org.eclipse.n4js.N4JS.Expression");
                                                      													afterParserOrEnumRuleCall();
                                                      												
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;
                                        case 2 :
                                            {
                                            {
                                            {
                                            {
                                            lv_forIn_19_0=(Token)match(input,In,FOLLOW_87); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              													newLeafNode(lv_forIn_19_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_0_1_1_1_1_0_0());
                                              												
                                            }
                                            if ( state.backtracking==0 ) {

                                              													if (current==null) {
                                              														current = createModelElement(grammarAccess.getForStatementRule());
                                              													}
                                              													setWithLastConsumed(current, "forIn", true, "in");
                                              												
                                            }

                                            }


                                            }
                                            int alt194=2;
                                            int LA194_0 = input.LA(1);

                                            if ( ((LA194_0>=Intersection && LA194_0<=Implements)||(LA194_0>=Promisify && LA194_0<=Abstract)||(LA194_0>=External && LA194_0<=Function)||(LA194_0>=Private && LA194_0<=Delete)||(LA194_0>=Import && LA194_0<=Public)||LA194_0==Static||(LA194_0>=Target && LA194_0<=Await)||LA194_0==Class||(LA194_0>=False && LA194_0<=Super)||LA194_0==Union||(LA194_0>=Yield && LA194_0<=This)||(LA194_0>=From && LA194_0<=Void)||(LA194_0>=Get && LA194_0<=Set)||LA194_0==PlusSignPlusSign||LA194_0==HyphenMinusHyphenMinus||LA194_0==SolidusEqualsSign||LA194_0==As||LA194_0==Of||LA194_0==ExclamationMark||LA194_0==LeftParenthesis||LA194_0==PlusSign||LA194_0==HyphenMinus||LA194_0==Solidus||LA194_0==LessThanSign||(LA194_0>=CommercialAt && LA194_0<=LeftSquareBracket)||LA194_0==LeftCurlyBracket||LA194_0==Tilde||LA194_0==RULE_DOUBLE||(LA194_0>=RULE_HEX_INT && LA194_0<=RULE_LEGACY_OCTAL_INT)||LA194_0==RULE_SCIENTIFIC_INT||LA194_0==RULE_IDENTIFIER||LA194_0==RULE_STRING||(LA194_0>=RULE_TEMPLATE_HEAD && LA194_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA194_0==RULE_INT) ) {
                                                alt194=1;
                                            }
                                            switch (alt194) {
                                                case 1 :
                                                    {
                                                    {
                                                    if ( state.backtracking==0 ) {

                                                      													newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_1_0_0_1_1_1_1_1_0());
                                                      												
                                                    }
                                                    pushFollow(FOLLOW_72);
                                                    lv_expression_20_0=norm3_Expression();

                                                    state._fsp--;
                                                    if (state.failed) return current;
                                                    if ( state.backtracking==0 ) {

                                                      													if (current==null) {
                                                      														current = createModelElementForParent(grammarAccess.getForStatementRule());
                                                      													}
                                                      													set(
                                                      														current,
                                                      														"expression",
                                                      														lv_expression_20_0,
                                                      														"org.eclipse.n4js.N4JS.Expression");
                                                      													afterParserOrEnumRuleCall();
                                                      												
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;
                                        case 3 :
                                            {
                                            {
                                            {
                                            {
                                            lv_forOf_21_0=(Token)match(input,Of,FOLLOW_87); if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              													newLeafNode(lv_forOf_21_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_0_1_1_1_2_0_0());
                                              												
                                            }
                                            if ( state.backtracking==0 ) {

                                              													if (current==null) {
                                              														current = createModelElement(grammarAccess.getForStatementRule());
                                              													}
                                              													setWithLastConsumed(current, "forOf", true, "of");
                                              												
                                            }

                                            }


                                            }
                                            int alt195=2;
                                            int LA195_0 = input.LA(1);

                                            if ( ((LA195_0>=Intersection && LA195_0<=Implements)||(LA195_0>=Promisify && LA195_0<=Abstract)||(LA195_0>=External && LA195_0<=Function)||(LA195_0>=Private && LA195_0<=Delete)||(LA195_0>=Import && LA195_0<=Public)||LA195_0==Static||(LA195_0>=Target && LA195_0<=Await)||LA195_0==Class||(LA195_0>=False && LA195_0<=Super)||LA195_0==Union||(LA195_0>=Yield && LA195_0<=This)||(LA195_0>=From && LA195_0<=Void)||(LA195_0>=Get && LA195_0<=Set)||LA195_0==PlusSignPlusSign||LA195_0==HyphenMinusHyphenMinus||LA195_0==SolidusEqualsSign||LA195_0==As||LA195_0==Of||LA195_0==ExclamationMark||LA195_0==LeftParenthesis||LA195_0==PlusSign||LA195_0==HyphenMinus||LA195_0==Solidus||LA195_0==LessThanSign||(LA195_0>=CommercialAt && LA195_0<=LeftSquareBracket)||LA195_0==LeftCurlyBracket||LA195_0==Tilde||LA195_0==RULE_DOUBLE||(LA195_0>=RULE_HEX_INT && LA195_0<=RULE_LEGACY_OCTAL_INT)||LA195_0==RULE_SCIENTIFIC_INT||LA195_0==RULE_IDENTIFIER||LA195_0==RULE_STRING||(LA195_0>=RULE_TEMPLATE_HEAD && LA195_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA195_0==RULE_INT) ) {
                                                alt195=1;
                                            }
                                            switch (alt195) {
                                                case 1 :
                                                    {
                                                    {
                                                    if ( state.backtracking==0 ) {

                                                      													newCompositeNode(grammarAccess.getForStatementAccess().getExpressionAssignmentExpressionParserRuleCall_3_1_0_0_1_1_1_2_1_0());
                                                      												
                                                    }
                                                    pushFollow(FOLLOW_72);
                                                    lv_expression_22_0=norm3_AssignmentExpression();

                                                    state._fsp--;
                                                    if (state.failed) return current;
                                                    if ( state.backtracking==0 ) {

                                                      													if (current==null) {
                                                      														current = createModelElementForParent(grammarAccess.getForStatementRule());
                                                      													}
                                                      													set(
                                                      														current,
                                                      														"expression",
                                                      														lv_expression_22_0,
                                                      														"org.eclipse.n4js.N4JS.AssignmentExpression");
                                                      													afterParserOrEnumRuleCall();
                                                      												
                                                    }

                                                    }


                                                    }
                                                    break;

                                            }


                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 2 :
                            {
                            {
                            {
                            {
                            if ( state.backtracking==0 ) {

                              									newCompositeNode(grammarAccess.getForStatementAccess().getInitExprExpressionParserRuleCall_3_1_0_1_0_0());
                              								
                            }
                            pushFollow(FOLLOW_85);
                            lv_initExpr_23_0=norm2_Expression();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              									if (current==null) {
                              										current = createModelElementForParent(grammarAccess.getForStatementRule());
                              									}
                              									set(
                              										current,
                              										"initExpr",
                              										lv_initExpr_23_0,
                              										"org.eclipse.n4js.N4JS.Expression");
                              									afterParserOrEnumRuleCall();
                              								
                            }

                            }


                            }
                            int alt202=3;
                            switch ( input.LA(1) ) {
                            case Semicolon:
                                {
                                alt202=1;
                                }
                                break;
                            case In:
                                {
                                alt202=2;
                                }
                                break;
                            case Of:
                                {
                                alt202=3;
                                }
                                break;
                            default:
                                if (state.backtracking>0) {state.failed=true; return current;}
                                NoViableAltException nvae =
                                    new NoViableAltException("", 202, 0, input);

                                throw nvae;
                            }

                            switch (alt202) {
                                case 1 :
                                    {
                                    {
                                    otherlv_24=(Token)match(input,Semicolon,FOLLOW_88); if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									newLeafNode(otherlv_24, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_0());
                                      								
                                    }
                                    int alt198=2;
                                    int LA198_0 = input.LA(1);

                                    if ( ((LA198_0>=Intersection && LA198_0<=Implements)||(LA198_0>=Promisify && LA198_0<=Abstract)||(LA198_0>=External && LA198_0<=Function)||(LA198_0>=Private && LA198_0<=Delete)||(LA198_0>=Import && LA198_0<=Public)||LA198_0==Static||(LA198_0>=Target && LA198_0<=Await)||LA198_0==Class||(LA198_0>=False && LA198_0<=Super)||LA198_0==Union||(LA198_0>=Yield && LA198_0<=This)||(LA198_0>=From && LA198_0<=Void)||(LA198_0>=Get && LA198_0<=Set)||LA198_0==PlusSignPlusSign||LA198_0==HyphenMinusHyphenMinus||LA198_0==SolidusEqualsSign||LA198_0==As||LA198_0==Of||LA198_0==ExclamationMark||LA198_0==LeftParenthesis||LA198_0==PlusSign||LA198_0==HyphenMinus||LA198_0==Solidus||LA198_0==LessThanSign||(LA198_0>=CommercialAt && LA198_0<=LeftSquareBracket)||LA198_0==LeftCurlyBracket||LA198_0==Tilde||LA198_0==RULE_DOUBLE||(LA198_0>=RULE_HEX_INT && LA198_0<=RULE_LEGACY_OCTAL_INT)||LA198_0==RULE_SCIENTIFIC_INT||LA198_0==RULE_IDENTIFIER||LA198_0==RULE_STRING||(LA198_0>=RULE_TEMPLATE_HEAD && LA198_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA198_0==RULE_INT) ) {
                                        alt198=1;
                                    }
                                    switch (alt198) {
                                        case 1 :
                                            {
                                            {
                                            if ( state.backtracking==0 ) {

                                              											newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_1_0_1_1_0_1_0());
                                              										
                                            }
                                            pushFollow(FOLLOW_84);
                                            lv_expression_25_0=norm3_Expression();

                                            state._fsp--;
                                            if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											if (current==null) {
                                              												current = createModelElementForParent(grammarAccess.getForStatementRule());
                                              											}
                                              											set(
                                              												current,
                                              												"expression",
                                              												lv_expression_25_0,
                                              												"org.eclipse.n4js.N4JS.Expression");
                                              											afterParserOrEnumRuleCall();
                                              										
                                            }

                                            }


                                            }
                                            break;

                                    }

                                    otherlv_26=(Token)match(input,Semicolon,FOLLOW_87); if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									newLeafNode(otherlv_26, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_1_1_0_2());
                                      								
                                    }
                                    int alt199=2;
                                    int LA199_0 = input.LA(1);

                                    if ( ((LA199_0>=Intersection && LA199_0<=Implements)||(LA199_0>=Promisify && LA199_0<=Abstract)||(LA199_0>=External && LA199_0<=Function)||(LA199_0>=Private && LA199_0<=Delete)||(LA199_0>=Import && LA199_0<=Public)||LA199_0==Static||(LA199_0>=Target && LA199_0<=Await)||LA199_0==Class||(LA199_0>=False && LA199_0<=Super)||LA199_0==Union||(LA199_0>=Yield && LA199_0<=This)||(LA199_0>=From && LA199_0<=Void)||(LA199_0>=Get && LA199_0<=Set)||LA199_0==PlusSignPlusSign||LA199_0==HyphenMinusHyphenMinus||LA199_0==SolidusEqualsSign||LA199_0==As||LA199_0==Of||LA199_0==ExclamationMark||LA199_0==LeftParenthesis||LA199_0==PlusSign||LA199_0==HyphenMinus||LA199_0==Solidus||LA199_0==LessThanSign||(LA199_0>=CommercialAt && LA199_0<=LeftSquareBracket)||LA199_0==LeftCurlyBracket||LA199_0==Tilde||LA199_0==RULE_DOUBLE||(LA199_0>=RULE_HEX_INT && LA199_0<=RULE_LEGACY_OCTAL_INT)||LA199_0==RULE_SCIENTIFIC_INT||LA199_0==RULE_IDENTIFIER||LA199_0==RULE_STRING||(LA199_0>=RULE_TEMPLATE_HEAD && LA199_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA199_0==RULE_INT) ) {
                                        alt199=1;
                                    }
                                    switch (alt199) {
                                        case 1 :
                                            {
                                            {
                                            if ( state.backtracking==0 ) {

                                              											newCompositeNode(grammarAccess.getForStatementAccess().getUpdateExprExpressionParserRuleCall_3_1_0_1_1_0_3_0());
                                              										
                                            }
                                            pushFollow(FOLLOW_72);
                                            lv_updateExpr_27_0=norm3_Expression();

                                            state._fsp--;
                                            if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											if (current==null) {
                                              												current = createModelElementForParent(grammarAccess.getForStatementRule());
                                              											}
                                              											set(
                                              												current,
                                              												"updateExpr",
                                              												lv_updateExpr_27_0,
                                              												"org.eclipse.n4js.N4JS.Expression");
                                              											afterParserOrEnumRuleCall();
                                              										
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;
                                case 2 :
                                    {
                                    {
                                    {
                                    {
                                    lv_forIn_28_0=(Token)match(input,In,FOLLOW_87); if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      											newLeafNode(lv_forIn_28_0, grammarAccess.getForStatementAccess().getForInInKeyword_3_1_0_1_1_1_0_0());
                                      										
                                    }
                                    if ( state.backtracking==0 ) {

                                      											if (current==null) {
                                      												current = createModelElement(grammarAccess.getForStatementRule());
                                      											}
                                      											setWithLastConsumed(current, "forIn", true, "in");
                                      										
                                    }

                                    }


                                    }
                                    int alt200=2;
                                    int LA200_0 = input.LA(1);

                                    if ( ((LA200_0>=Intersection && LA200_0<=Implements)||(LA200_0>=Promisify && LA200_0<=Abstract)||(LA200_0>=External && LA200_0<=Function)||(LA200_0>=Private && LA200_0<=Delete)||(LA200_0>=Import && LA200_0<=Public)||LA200_0==Static||(LA200_0>=Target && LA200_0<=Await)||LA200_0==Class||(LA200_0>=False && LA200_0<=Super)||LA200_0==Union||(LA200_0>=Yield && LA200_0<=This)||(LA200_0>=From && LA200_0<=Void)||(LA200_0>=Get && LA200_0<=Set)||LA200_0==PlusSignPlusSign||LA200_0==HyphenMinusHyphenMinus||LA200_0==SolidusEqualsSign||LA200_0==As||LA200_0==Of||LA200_0==ExclamationMark||LA200_0==LeftParenthesis||LA200_0==PlusSign||LA200_0==HyphenMinus||LA200_0==Solidus||LA200_0==LessThanSign||(LA200_0>=CommercialAt && LA200_0<=LeftSquareBracket)||LA200_0==LeftCurlyBracket||LA200_0==Tilde||LA200_0==RULE_DOUBLE||(LA200_0>=RULE_HEX_INT && LA200_0<=RULE_LEGACY_OCTAL_INT)||LA200_0==RULE_SCIENTIFIC_INT||LA200_0==RULE_IDENTIFIER||LA200_0==RULE_STRING||(LA200_0>=RULE_TEMPLATE_HEAD && LA200_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA200_0==RULE_INT) ) {
                                        alt200=1;
                                    }
                                    switch (alt200) {
                                        case 1 :
                                            {
                                            {
                                            if ( state.backtracking==0 ) {

                                              											newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_1_0_1_1_1_1_0());
                                              										
                                            }
                                            pushFollow(FOLLOW_72);
                                            lv_expression_29_0=norm3_Expression();

                                            state._fsp--;
                                            if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											if (current==null) {
                                              												current = createModelElementForParent(grammarAccess.getForStatementRule());
                                              											}
                                              											set(
                                              												current,
                                              												"expression",
                                              												lv_expression_29_0,
                                              												"org.eclipse.n4js.N4JS.Expression");
                                              											afterParserOrEnumRuleCall();
                                              										
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;
                                case 3 :
                                    {
                                    {
                                    {
                                    {
                                    lv_forOf_30_0=(Token)match(input,Of,FOLLOW_87); if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      											newLeafNode(lv_forOf_30_0, grammarAccess.getForStatementAccess().getForOfOfKeyword_3_1_0_1_1_2_0_0());
                                      										
                                    }
                                    if ( state.backtracking==0 ) {

                                      											if (current==null) {
                                      												current = createModelElement(grammarAccess.getForStatementRule());
                                      											}
                                      											setWithLastConsumed(current, "forOf", true, "of");
                                      										
                                    }

                                    }


                                    }
                                    int alt201=2;
                                    int LA201_0 = input.LA(1);

                                    if ( ((LA201_0>=Intersection && LA201_0<=Implements)||(LA201_0>=Promisify && LA201_0<=Abstract)||(LA201_0>=External && LA201_0<=Function)||(LA201_0>=Private && LA201_0<=Delete)||(LA201_0>=Import && LA201_0<=Public)||LA201_0==Static||(LA201_0>=Target && LA201_0<=Await)||LA201_0==Class||(LA201_0>=False && LA201_0<=Super)||LA201_0==Union||(LA201_0>=Yield && LA201_0<=This)||(LA201_0>=From && LA201_0<=Void)||(LA201_0>=Get && LA201_0<=Set)||LA201_0==PlusSignPlusSign||LA201_0==HyphenMinusHyphenMinus||LA201_0==SolidusEqualsSign||LA201_0==As||LA201_0==Of||LA201_0==ExclamationMark||LA201_0==LeftParenthesis||LA201_0==PlusSign||LA201_0==HyphenMinus||LA201_0==Solidus||LA201_0==LessThanSign||(LA201_0>=CommercialAt && LA201_0<=LeftSquareBracket)||LA201_0==LeftCurlyBracket||LA201_0==Tilde||LA201_0==RULE_DOUBLE||(LA201_0>=RULE_HEX_INT && LA201_0<=RULE_LEGACY_OCTAL_INT)||LA201_0==RULE_SCIENTIFIC_INT||LA201_0==RULE_IDENTIFIER||LA201_0==RULE_STRING||(LA201_0>=RULE_TEMPLATE_HEAD && LA201_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA201_0==RULE_INT) ) {
                                        alt201=1;
                                    }
                                    switch (alt201) {
                                        case 1 :
                                            {
                                            {
                                            if ( state.backtracking==0 ) {

                                              											newCompositeNode(grammarAccess.getForStatementAccess().getExpressionAssignmentExpressionParserRuleCall_3_1_0_1_1_2_1_0());
                                              										
                                            }
                                            pushFollow(FOLLOW_72);
                                            lv_expression_31_0=norm3_AssignmentExpression();

                                            state._fsp--;
                                            if (state.failed) return current;
                                            if ( state.backtracking==0 ) {

                                              											if (current==null) {
                                              												current = createModelElementForParent(grammarAccess.getForStatementRule());
                                              											}
                                              											set(
                                              												current,
                                              												"expression",
                                              												lv_expression_31_0,
                                              												"org.eclipse.n4js.N4JS.AssignmentExpression");
                                              											afterParserOrEnumRuleCall();
                                              										
                                            }

                                            }


                                            }
                                            break;

                                    }


                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;
                        case 3 :
                            {
                            {
                            otherlv_32=(Token)match(input,Semicolon,FOLLOW_88); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(otherlv_32, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_0());
                              						
                            }
                            int alt203=2;
                            int LA203_0 = input.LA(1);

                            if ( ((LA203_0>=Intersection && LA203_0<=Implements)||(LA203_0>=Promisify && LA203_0<=Abstract)||(LA203_0>=External && LA203_0<=Function)||(LA203_0>=Private && LA203_0<=Delete)||(LA203_0>=Import && LA203_0<=Public)||LA203_0==Static||(LA203_0>=Target && LA203_0<=Await)||LA203_0==Class||(LA203_0>=False && LA203_0<=Super)||LA203_0==Union||(LA203_0>=Yield && LA203_0<=This)||(LA203_0>=From && LA203_0<=Void)||(LA203_0>=Get && LA203_0<=Set)||LA203_0==PlusSignPlusSign||LA203_0==HyphenMinusHyphenMinus||LA203_0==SolidusEqualsSign||LA203_0==As||LA203_0==Of||LA203_0==ExclamationMark||LA203_0==LeftParenthesis||LA203_0==PlusSign||LA203_0==HyphenMinus||LA203_0==Solidus||LA203_0==LessThanSign||(LA203_0>=CommercialAt && LA203_0<=LeftSquareBracket)||LA203_0==LeftCurlyBracket||LA203_0==Tilde||LA203_0==RULE_DOUBLE||(LA203_0>=RULE_HEX_INT && LA203_0<=RULE_LEGACY_OCTAL_INT)||LA203_0==RULE_SCIENTIFIC_INT||LA203_0==RULE_IDENTIFIER||LA203_0==RULE_STRING||(LA203_0>=RULE_TEMPLATE_HEAD && LA203_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA203_0==RULE_INT) ) {
                                alt203=1;
                            }
                            switch (alt203) {
                                case 1 :
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      									newCompositeNode(grammarAccess.getForStatementAccess().getExpressionExpressionParserRuleCall_3_1_0_2_1_0());
                                      								
                                    }
                                    pushFollow(FOLLOW_84);
                                    lv_expression_33_0=norm3_Expression();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									if (current==null) {
                                      										current = createModelElementForParent(grammarAccess.getForStatementRule());
                                      									}
                                      									set(
                                      										current,
                                      										"expression",
                                      										lv_expression_33_0,
                                      										"org.eclipse.n4js.N4JS.Expression");
                                      									afterParserOrEnumRuleCall();
                                      								
                                    }

                                    }


                                    }
                                    break;

                            }

                            otherlv_34=(Token)match(input,Semicolon,FOLLOW_87); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(otherlv_34, grammarAccess.getForStatementAccess().getSemicolonKeyword_3_1_0_2_2());
                              						
                            }
                            int alt204=2;
                            int LA204_0 = input.LA(1);

                            if ( ((LA204_0>=Intersection && LA204_0<=Implements)||(LA204_0>=Promisify && LA204_0<=Abstract)||(LA204_0>=External && LA204_0<=Function)||(LA204_0>=Private && LA204_0<=Delete)||(LA204_0>=Import && LA204_0<=Public)||LA204_0==Static||(LA204_0>=Target && LA204_0<=Await)||LA204_0==Class||(LA204_0>=False && LA204_0<=Super)||LA204_0==Union||(LA204_0>=Yield && LA204_0<=This)||(LA204_0>=From && LA204_0<=Void)||(LA204_0>=Get && LA204_0<=Set)||LA204_0==PlusSignPlusSign||LA204_0==HyphenMinusHyphenMinus||LA204_0==SolidusEqualsSign||LA204_0==As||LA204_0==Of||LA204_0==ExclamationMark||LA204_0==LeftParenthesis||LA204_0==PlusSign||LA204_0==HyphenMinus||LA204_0==Solidus||LA204_0==LessThanSign||(LA204_0>=CommercialAt && LA204_0<=LeftSquareBracket)||LA204_0==LeftCurlyBracket||LA204_0==Tilde||LA204_0==RULE_DOUBLE||(LA204_0>=RULE_HEX_INT && LA204_0<=RULE_LEGACY_OCTAL_INT)||LA204_0==RULE_SCIENTIFIC_INT||LA204_0==RULE_IDENTIFIER||LA204_0==RULE_STRING||(LA204_0>=RULE_TEMPLATE_HEAD && LA204_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA204_0==RULE_INT) ) {
                                alt204=1;
                            }
                            switch (alt204) {
                                case 1 :
                                    {
                                    {
                                    if ( state.backtracking==0 ) {

                                      									newCompositeNode(grammarAccess.getForStatementAccess().getUpdateExprExpressionParserRuleCall_3_1_0_2_3_0());
                                      								
                                    }
                                    pushFollow(FOLLOW_72);
                                    lv_updateExpr_35_0=norm3_Expression();

                                    state._fsp--;
                                    if (state.failed) return current;
                                    if ( state.backtracking==0 ) {

                                      									if (current==null) {
                                      										current = createModelElementForParent(grammarAccess.getForStatementRule());
                                      									}
                                      									set(
                                      										current,
                                      										"updateExpr",
                                      										lv_updateExpr_35_0,
                                      										"org.eclipse.n4js.N4JS.Expression");
                                      									afterParserOrEnumRuleCall();
                                      								
                                    }

                                    }


                                    }
                                    break;

                            }


                            }


                            }
                            break;

                    }

                    otherlv_36=(Token)match(input,RightParenthesis,FOLLOW_75); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(otherlv_36, grammarAccess.getForStatementAccess().getRightParenthesisKeyword_3_1_1());
                      				
                    }

                    }


                    }
                    break;

            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getForStatementAccess().getStatementStatementParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_statement_37_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getForStatementRule());
              					}
              					set(
              						current,
              						"statement",
              						lv_statement_37_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleLetIdentifierRef() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleLetIdentifierRef = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getLetIdentifierRefRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleLetIdentifierRef=ruleLetIdentifierRef();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleLetIdentifierRef; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleLetIdentifierRef() throws RecognitionException {
        EObject current = null;


        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				if (current==null) {
              					current = createModelElement(grammarAccess.getLetIdentifierRefRule());
              				}
              			
            }
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getLetIdentifierRefAccess().getIdIdentifiableElementCrossReference_0());
              			
            }
            pushFollow(FOLLOW_2);
            ruleLetAsIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				afterParserOrEnumRuleCall();
              			
            }

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final String entryRuleLetAsIdentifier() throws RecognitionException {
        String current = null;

        AntlrDatatypeRuleToken iv_ruleLetAsIdentifier = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getLetAsIdentifierRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleLetAsIdentifier=ruleLetAsIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleLetAsIdentifier.getText(); 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final AntlrDatatypeRuleToken ruleLetAsIdentifier() throws RecognitionException {
        AntlrDatatypeRuleToken current = new AntlrDatatypeRuleToken();

        Token kw=null;


        	enterRule();

        try {
            {
            kw=(Token)match(input,Let,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              		current.merge(kw);
              		newLeafNode(kw, grammarAccess.getLetAsIdentifierAccess().getLetKeyword());
              	
            }

            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleBindingIdentifierAsVariableDeclaration() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleBindingIdentifierAsVariableDeclaration = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getBindingIdentifierAsVariableDeclarationRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleBindingIdentifierAsVariableDeclaration=ruleBindingIdentifierAsVariableDeclaration();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleBindingIdentifierAsVariableDeclaration; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleBindingIdentifierAsVariableDeclaration() throws RecognitionException {
        EObject current = null;

        AntlrDatatypeRuleToken lv_name_0_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameBindingIdentifierParserRuleCall_0());
              			
            }
            pushFollow(FOLLOW_2);
            lv_name_0_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				if (current==null) {
              					current = createModelElementForParent(grammarAccess.getBindingIdentifierAsVariableDeclarationRule());
              				}
              				set(
              					current,
              					"name",
              					lv_name_0_0,
              					"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              				afterParserOrEnumRuleCall();
              			
            }

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm2_BindingIdentifierAsVariableDeclaration() throws RecognitionException {
        EObject current = null;

        AntlrDatatypeRuleToken lv_name_0_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				newCompositeNode(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameBindingIdentifierParserRuleCall_0());
              			
            }
            pushFollow(FOLLOW_2);
            lv_name_0_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              				if (current==null) {
              					current = createModelElementForParent(grammarAccess.getBindingIdentifierAsVariableDeclarationRule());
              				}
              				set(
              					current,
              					"name",
              					lv_name_0_0,
              					"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              				afterParserOrEnumRuleCall();
              			
            }

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleContinueStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleContinueStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getContinueStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleContinueStatement=ruleContinueStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleContinueStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleContinueStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;


        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getContinueStatementAccess().getContinueStatementAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Continue,FOLLOW_89); if (state.failed) return current;
            if ( state.backtracking==0 ) {
               promoteEOL(); 
            }
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getContinueStatementAccess().getContinueKeyword_1());
              		
            }
            int alt207=2;
            int LA207_0 = input.LA(1);

            if ( ((LA207_0>=Intersection && LA207_0<=Implements)||(LA207_0>=Promisify && LA207_0<=Abstract)||LA207_0==External||(LA207_0>=Private && LA207_0<=Project)||LA207_0==Public||LA207_0==Static||LA207_0==Target||(LA207_0>=Async && LA207_0<=Await)||LA207_0==Union||(LA207_0>=Yield && LA207_0<=This)||LA207_0==From||LA207_0==Type||(LA207_0>=Get && LA207_0<=Let)||(LA207_0>=Out && LA207_0<=Set)||LA207_0==As||LA207_0==Of||LA207_0==RULE_IDENTIFIER) ) {
                alt207=1;
            }
            switch (alt207) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getContinueStatementRule());
                      					}
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getContinueStatementAccess().getLabelLabelledStatementCrossReference_2_0());
                      				
                    }
                    pushFollow(FOLLOW_18);
                    ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getContinueStatementAccess().getSemiParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ContinueStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;


        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getContinueStatementAccess().getContinueStatementAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Continue,FOLLOW_89); if (state.failed) return current;
            if ( state.backtracking==0 ) {
               promoteEOL(); 
            }
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getContinueStatementAccess().getContinueKeyword_1());
              		
            }
            int alt208=2;
            int LA208_0 = input.LA(1);

            if ( ((LA208_0>=Intersection && LA208_0<=Implements)||(LA208_0>=Promisify && LA208_0<=Abstract)||LA208_0==External||(LA208_0>=Private && LA208_0<=Project)||LA208_0==Public||LA208_0==Static||LA208_0==Target||(LA208_0>=Async && LA208_0<=Await)||LA208_0==Union||LA208_0==This||LA208_0==From||LA208_0==Type||(LA208_0>=Get && LA208_0<=Let)||(LA208_0>=Out && LA208_0<=Set)||LA208_0==As||LA208_0==Of||LA208_0==RULE_IDENTIFIER) ) {
                alt208=1;
            }
            switch (alt208) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getContinueStatementRule());
                      					}
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getContinueStatementAccess().getLabelLabelledStatementCrossReference_2_0());
                      				
                    }
                    pushFollow(FOLLOW_18);
                    norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getContinueStatementAccess().getSemiParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleBreakStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleBreakStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getBreakStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleBreakStatement=ruleBreakStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleBreakStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleBreakStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;


        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getBreakStatementAccess().getBreakStatementAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Break,FOLLOW_89); if (state.failed) return current;
            if ( state.backtracking==0 ) {
               promoteEOL(); 
            }
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getBreakStatementAccess().getBreakKeyword_1());
              		
            }
            int alt209=2;
            int LA209_0 = input.LA(1);

            if ( ((LA209_0>=Intersection && LA209_0<=Implements)||(LA209_0>=Promisify && LA209_0<=Abstract)||LA209_0==External||(LA209_0>=Private && LA209_0<=Project)||LA209_0==Public||LA209_0==Static||LA209_0==Target||(LA209_0>=Async && LA209_0<=Await)||LA209_0==Union||(LA209_0>=Yield && LA209_0<=This)||LA209_0==From||LA209_0==Type||(LA209_0>=Get && LA209_0<=Let)||(LA209_0>=Out && LA209_0<=Set)||LA209_0==As||LA209_0==Of||LA209_0==RULE_IDENTIFIER) ) {
                alt209=1;
            }
            switch (alt209) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getBreakStatementRule());
                      					}
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getBreakStatementAccess().getLabelLabelledStatementCrossReference_2_0());
                      				
                    }
                    pushFollow(FOLLOW_18);
                    ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getBreakStatementAccess().getSemiParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_BreakStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;


        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getBreakStatementAccess().getBreakStatementAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Break,FOLLOW_89); if (state.failed) return current;
            if ( state.backtracking==0 ) {
               promoteEOL(); 
            }
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getBreakStatementAccess().getBreakKeyword_1());
              		
            }
            int alt210=2;
            int LA210_0 = input.LA(1);

            if ( ((LA210_0>=Intersection && LA210_0<=Implements)||(LA210_0>=Promisify && LA210_0<=Abstract)||LA210_0==External||(LA210_0>=Private && LA210_0<=Project)||LA210_0==Public||LA210_0==Static||LA210_0==Target||(LA210_0>=Async && LA210_0<=Await)||LA210_0==Union||LA210_0==This||LA210_0==From||LA210_0==Type||(LA210_0>=Get && LA210_0<=Let)||(LA210_0>=Out && LA210_0<=Set)||LA210_0==As||LA210_0==Of||LA210_0==RULE_IDENTIFIER) ) {
                alt210=1;
            }
            switch (alt210) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getBreakStatementRule());
                      					}
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getBreakStatementAccess().getLabelLabelledStatementCrossReference_2_0());
                      				
                    }
                    pushFollow(FOLLOW_18);
                    norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getBreakStatementAccess().getSemiParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleReturnStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleReturnStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getReturnStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleReturnStatement=ruleReturnStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleReturnStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleReturnStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getReturnStatementAccess().getReturnStatementAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Return,FOLLOW_90); if (state.failed) return current;
            if ( state.backtracking==0 ) {
               promoteEOL(); 
            }
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getReturnStatementAccess().getReturnKeyword_1());
              		
            }
            int alt211=2;
            int LA211_0 = input.LA(1);

            if ( ((LA211_0>=Intersection && LA211_0<=Implements)||(LA211_0>=Promisify && LA211_0<=Abstract)||(LA211_0>=External && LA211_0<=Function)||(LA211_0>=Private && LA211_0<=Delete)||(LA211_0>=Import && LA211_0<=Public)||LA211_0==Static||(LA211_0>=Target && LA211_0<=Await)||LA211_0==Class||(LA211_0>=False && LA211_0<=Super)||LA211_0==Union||(LA211_0>=Yield && LA211_0<=This)||(LA211_0>=From && LA211_0<=Void)||(LA211_0>=Get && LA211_0<=Set)||LA211_0==PlusSignPlusSign||LA211_0==HyphenMinusHyphenMinus||LA211_0==SolidusEqualsSign||LA211_0==As||LA211_0==Of||LA211_0==ExclamationMark||LA211_0==LeftParenthesis||LA211_0==PlusSign||LA211_0==HyphenMinus||LA211_0==Solidus||LA211_0==LessThanSign||(LA211_0>=CommercialAt && LA211_0<=LeftSquareBracket)||LA211_0==LeftCurlyBracket||LA211_0==Tilde||LA211_0==RULE_DOUBLE||(LA211_0>=RULE_HEX_INT && LA211_0<=RULE_LEGACY_OCTAL_INT)||LA211_0==RULE_SCIENTIFIC_INT||LA211_0==RULE_IDENTIFIER||LA211_0==RULE_STRING||(LA211_0>=RULE_TEMPLATE_HEAD && LA211_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA211_0==RULE_INT) ) {
                alt211=1;
            }
            switch (alt211) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getReturnStatementAccess().getExpressionExpressionParserRuleCall_2_0());
                      				
                    }
                    pushFollow(FOLLOW_18);
                    lv_expression_2_0=norm1_Expression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getReturnStatementRule());
                      					}
                      					set(
                      						current,
                      						"expression",
                      						lv_expression_2_0,
                      						"org.eclipse.n4js.N4JS.Expression");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getReturnStatementAccess().getSemiParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ReturnStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getReturnStatementAccess().getReturnStatementAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Return,FOLLOW_91); if (state.failed) return current;
            if ( state.backtracking==0 ) {
               promoteEOL(); 
            }
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getReturnStatementAccess().getReturnKeyword_1());
              		
            }
            int alt212=2;
            int LA212_0 = input.LA(1);

            if ( ((LA212_0>=Intersection && LA212_0<=Implements)||(LA212_0>=Promisify && LA212_0<=Abstract)||(LA212_0>=External && LA212_0<=Function)||(LA212_0>=Private && LA212_0<=Delete)||(LA212_0>=Import && LA212_0<=Public)||LA212_0==Static||(LA212_0>=Target && LA212_0<=Await)||LA212_0==Class||(LA212_0>=False && LA212_0<=Super)||LA212_0==Union||(LA212_0>=Yield && LA212_0<=This)||(LA212_0>=From && LA212_0<=Void)||(LA212_0>=Get && LA212_0<=Set)||LA212_0==PlusSignPlusSign||LA212_0==HyphenMinusHyphenMinus||LA212_0==SolidusEqualsSign||LA212_0==As||LA212_0==Of||LA212_0==ExclamationMark||LA212_0==LeftParenthesis||LA212_0==PlusSign||LA212_0==HyphenMinus||LA212_0==Solidus||LA212_0==LessThanSign||(LA212_0>=CommercialAt && LA212_0<=LeftSquareBracket)||LA212_0==LeftCurlyBracket||LA212_0==Tilde||LA212_0==RULE_DOUBLE||(LA212_0>=RULE_HEX_INT && LA212_0<=RULE_LEGACY_OCTAL_INT)||LA212_0==RULE_SCIENTIFIC_INT||LA212_0==RULE_IDENTIFIER||LA212_0==RULE_STRING||(LA212_0>=RULE_TEMPLATE_HEAD && LA212_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA212_0==RULE_INT) ) {
                alt212=1;
            }
            switch (alt212) {
                case 1 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getReturnStatementAccess().getExpressionExpressionParserRuleCall_2_0());
                      				
                    }
                    pushFollow(FOLLOW_18);
                    lv_expression_2_0=norm3_Expression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getReturnStatementRule());
                      					}
                      					set(
                      						current,
                      						"expression",
                      						lv_expression_2_0,
                      						"org.eclipse.n4js.N4JS.Expression");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }
                    break;

            }

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getReturnStatementAccess().getSemiParserRuleCall_3());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleWithStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleWithStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getWithStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleWithStatement=ruleWithStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleWithStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleWithStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_1=null;
        Token otherlv_3=null;
        EObject lv_expression_2_0 = null;

        EObject lv_statement_4_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,With,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getWithStatementAccess().getWithKeyword_0());
              		
            }
            otherlv_1=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getWithStatementAccess().getLeftParenthesisKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getWithStatementAccess().getExpressionExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_2_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getWithStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_3=(Token)match(input,RightParenthesis,FOLLOW_73); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getWithStatementAccess().getRightParenthesisKeyword_3());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getWithStatementAccess().getStatementStatementParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_statement_4_0=ruleStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getWithStatementRule());
              					}
              					set(
              						current,
              						"statement",
              						lv_statement_4_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_WithStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_1=null;
        Token otherlv_3=null;
        EObject lv_expression_2_0 = null;

        EObject lv_statement_4_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,With,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getWithStatementAccess().getWithKeyword_0());
              		
            }
            otherlv_1=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getWithStatementAccess().getLeftParenthesisKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getWithStatementAccess().getExpressionExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_2_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getWithStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_3=(Token)match(input,RightParenthesis,FOLLOW_75); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getWithStatementAccess().getRightParenthesisKeyword_3());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getWithStatementAccess().getStatementStatementParserRuleCall_4_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_statement_4_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getWithStatementRule());
              					}
              					set(
              						current,
              						"statement",
              						lv_statement_4_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleSwitchStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleSwitchStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getSwitchStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleSwitchStatement=ruleSwitchStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleSwitchStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleSwitchStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_4=null;
        Token otherlv_8=null;
        EObject lv_expression_2_0 = null;

        EObject lv_cases_5_0 = null;

        EObject lv_cases_6_0 = null;

        EObject lv_cases_7_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Switch,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getSwitchStatementAccess().getSwitchKeyword_0());
              		
            }
            otherlv_1=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getSwitchStatementAccess().getLeftParenthesisKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getSwitchStatementAccess().getExpressionExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_2_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getSwitchStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_3=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getSwitchStatementAccess().getRightParenthesisKeyword_3());
              		
            }
            otherlv_4=(Token)match(input,LeftCurlyBracket,FOLLOW_92); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_4, grammarAccess.getSwitchStatementAccess().getLeftCurlyBracketKeyword_4());
              		
            }
            loop213:
            do {
                int alt213=2;
                int LA213_0 = input.LA(1);

                if ( (LA213_0==Case) ) {
                    alt213=1;
                }


                switch (alt213) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getSwitchStatementAccess().getCasesCaseClauseParserRuleCall_5_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_92);
            	    lv_cases_5_0=ruleCaseClause();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getSwitchStatementRule());
            	      					}
            	      					add(
            	      						current,
            	      						"cases",
            	      						lv_cases_5_0,
            	      						"org.eclipse.n4js.N4JS.CaseClause");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop213;
                }
            } while (true);
            int alt215=2;
            int LA215_0 = input.LA(1);

            if ( (LA215_0==Default) ) {
                alt215=1;
            }
            switch (alt215) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getSwitchStatementAccess().getCasesDefaultClauseParserRuleCall_6_0_0());
                      					
                    }
                    pushFollow(FOLLOW_93);
                    lv_cases_6_0=ruleDefaultClause();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getSwitchStatementRule());
                      						}
                      						add(
                      							current,
                      							"cases",
                      							lv_cases_6_0,
                      							"org.eclipse.n4js.N4JS.DefaultClause");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }
                    loop214:
                    do {
                        int alt214=2;
                        int LA214_0 = input.LA(1);

                        if ( (LA214_0==Case) ) {
                            alt214=1;
                        }


                        switch (alt214) {
                    	case 1 :
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      						newCompositeNode(grammarAccess.getSwitchStatementAccess().getCasesCaseClauseParserRuleCall_6_1_0());
                    	      					
                    	    }
                    	    pushFollow(FOLLOW_93);
                    	    lv_cases_7_0=ruleCaseClause();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      						if (current==null) {
                    	      							current = createModelElementForParent(grammarAccess.getSwitchStatementRule());
                    	      						}
                    	      						add(
                    	      							current,
                    	      							"cases",
                    	      							lv_cases_7_0,
                    	      							"org.eclipse.n4js.N4JS.CaseClause");
                    	      						afterParserOrEnumRuleCall();
                    	      					
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop214;
                        }
                    } while (true);


                    }
                    break;

            }

            otherlv_8=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_8, grammarAccess.getSwitchStatementAccess().getRightCurlyBracketKeyword_7());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_SwitchStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_4=null;
        Token otherlv_8=null;
        EObject lv_expression_2_0 = null;

        EObject lv_cases_5_0 = null;

        EObject lv_cases_6_0 = null;

        EObject lv_cases_7_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Switch,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getSwitchStatementAccess().getSwitchKeyword_0());
              		
            }
            otherlv_1=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getSwitchStatementAccess().getLeftParenthesisKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getSwitchStatementAccess().getExpressionExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_2_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getSwitchStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_3=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_3, grammarAccess.getSwitchStatementAccess().getRightParenthesisKeyword_3());
              		
            }
            otherlv_4=(Token)match(input,LeftCurlyBracket,FOLLOW_92); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_4, grammarAccess.getSwitchStatementAccess().getLeftCurlyBracketKeyword_4());
              		
            }
            loop216:
            do {
                int alt216=2;
                int LA216_0 = input.LA(1);

                if ( (LA216_0==Case) ) {
                    alt216=1;
                }


                switch (alt216) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getSwitchStatementAccess().getCasesCaseClauseParserRuleCall_5_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_92);
            	    lv_cases_5_0=norm1_CaseClause();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getSwitchStatementRule());
            	      					}
            	      					add(
            	      						current,
            	      						"cases",
            	      						lv_cases_5_0,
            	      						"org.eclipse.n4js.N4JS.CaseClause");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop216;
                }
            } while (true);
            int alt218=2;
            int LA218_0 = input.LA(1);

            if ( (LA218_0==Default) ) {
                alt218=1;
            }
            switch (alt218) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getSwitchStatementAccess().getCasesDefaultClauseParserRuleCall_6_0_0());
                      					
                    }
                    pushFollow(FOLLOW_93);
                    lv_cases_6_0=norm1_DefaultClause();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getSwitchStatementRule());
                      						}
                      						add(
                      							current,
                      							"cases",
                      							lv_cases_6_0,
                      							"org.eclipse.n4js.N4JS.DefaultClause");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }
                    loop217:
                    do {
                        int alt217=2;
                        int LA217_0 = input.LA(1);

                        if ( (LA217_0==Case) ) {
                            alt217=1;
                        }


                        switch (alt217) {
                    	case 1 :
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      						newCompositeNode(grammarAccess.getSwitchStatementAccess().getCasesCaseClauseParserRuleCall_6_1_0());
                    	      					
                    	    }
                    	    pushFollow(FOLLOW_93);
                    	    lv_cases_7_0=norm1_CaseClause();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      						if (current==null) {
                    	      							current = createModelElementForParent(grammarAccess.getSwitchStatementRule());
                    	      						}
                    	      						add(
                    	      							current,
                    	      							"cases",
                    	      							lv_cases_7_0,
                    	      							"org.eclipse.n4js.N4JS.CaseClause");
                    	      						afterParserOrEnumRuleCall();
                    	      					
                    	    }

                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop217;
                        }
                    } while (true);


                    }
                    break;

            }

            otherlv_8=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_8, grammarAccess.getSwitchStatementAccess().getRightCurlyBracketKeyword_7());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleCaseClause() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleCaseClause = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getCaseClauseRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleCaseClause=ruleCaseClause();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleCaseClause; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleCaseClause() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        EObject lv_expression_1_0 = null;

        EObject lv_statements_3_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Case,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getCaseClauseAccess().getCaseKeyword_0());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getCaseClauseAccess().getExpressionExpressionParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_94);
            lv_expression_1_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getCaseClauseRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_1_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_2=(Token)match(input,Colon,FOLLOW_3); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getCaseClauseAccess().getColonKeyword_2());
              		
            }
            loop219:
            do {
                int alt219=2;
                int LA219_0 = input.LA(1);

                if ( ((LA219_0>=Intersection && LA219_0<=Implements)||(LA219_0>=Promisify && LA219_0<=Function)||(LA219_0>=Private && LA219_0<=Delete)||(LA219_0>=Import && LA219_0<=Break)||(LA219_0>=Class && LA219_0<=This)||(LA219_0>=From && LA219_0<=With)||(LA219_0>=For && LA219_0<=Var)||LA219_0==PlusSignPlusSign||LA219_0==HyphenMinusHyphenMinus||LA219_0==SolidusEqualsSign||(LA219_0>=As && LA219_0<=If)||LA219_0==Of||LA219_0==ExclamationMark||LA219_0==LeftParenthesis||LA219_0==PlusSign||LA219_0==HyphenMinus||LA219_0==Solidus||(LA219_0>=Semicolon && LA219_0<=LessThanSign)||(LA219_0>=CommercialAt && LA219_0<=LeftSquareBracket)||LA219_0==LeftCurlyBracket||LA219_0==Tilde||LA219_0==RULE_DOUBLE||(LA219_0>=RULE_HEX_INT && LA219_0<=RULE_LEGACY_OCTAL_INT)||LA219_0==RULE_SCIENTIFIC_INT||LA219_0==RULE_IDENTIFIER||LA219_0==RULE_STRING||(LA219_0>=RULE_TEMPLATE_HEAD && LA219_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA219_0==RULE_INT) ) {
                    alt219=1;
                }


                switch (alt219) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getCaseClauseAccess().getStatementsStatementParserRuleCall_3_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_3);
            	    lv_statements_3_0=ruleStatement();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getCaseClauseRule());
            	      					}
            	      					add(
            	      						current,
            	      						"statements",
            	      						lv_statements_3_0,
            	      						"org.eclipse.n4js.N4JS.Statement");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop219;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_CaseClause() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        EObject lv_expression_1_0 = null;

        EObject lv_statements_3_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Case,FOLLOW_70); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getCaseClauseAccess().getCaseKeyword_0());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getCaseClauseAccess().getExpressionExpressionParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_94);
            lv_expression_1_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getCaseClauseRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_1_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_2=(Token)match(input,Colon,FOLLOW_56); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getCaseClauseAccess().getColonKeyword_2());
              		
            }
            loop220:
            do {
                int alt220=2;
                int LA220_0 = input.LA(1);

                if ( ((LA220_0>=Intersection && LA220_0<=Implements)||(LA220_0>=Promisify && LA220_0<=Function)||(LA220_0>=Private && LA220_0<=Delete)||(LA220_0>=Import && LA220_0<=Break)||(LA220_0>=Class && LA220_0<=This)||(LA220_0>=From && LA220_0<=With)||(LA220_0>=For && LA220_0<=Var)||LA220_0==PlusSignPlusSign||LA220_0==HyphenMinusHyphenMinus||LA220_0==SolidusEqualsSign||(LA220_0>=As && LA220_0<=If)||LA220_0==Of||LA220_0==ExclamationMark||LA220_0==LeftParenthesis||LA220_0==PlusSign||LA220_0==HyphenMinus||LA220_0==Solidus||(LA220_0>=Semicolon && LA220_0<=LessThanSign)||(LA220_0>=CommercialAt && LA220_0<=LeftSquareBracket)||LA220_0==LeftCurlyBracket||LA220_0==Tilde||LA220_0==RULE_DOUBLE||(LA220_0>=RULE_HEX_INT && LA220_0<=RULE_LEGACY_OCTAL_INT)||LA220_0==RULE_SCIENTIFIC_INT||LA220_0==RULE_IDENTIFIER||LA220_0==RULE_STRING||(LA220_0>=RULE_TEMPLATE_HEAD && LA220_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA220_0==RULE_INT) ) {
                    alt220=1;
                }


                switch (alt220) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getCaseClauseAccess().getStatementsStatementParserRuleCall_3_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_56);
            	    lv_statements_3_0=norm1_Statement();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getCaseClauseRule());
            	      					}
            	      					add(
            	      						current,
            	      						"statements",
            	      						lv_statements_3_0,
            	      						"org.eclipse.n4js.N4JS.Statement");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop220;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleDefaultClause() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleDefaultClause = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getDefaultClauseRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleDefaultClause=ruleDefaultClause();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleDefaultClause; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleDefaultClause() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        EObject lv_statements_3_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getDefaultClauseAccess().getDefaultClauseAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Default,FOLLOW_94); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getDefaultClauseAccess().getDefaultKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,Colon,FOLLOW_3); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getDefaultClauseAccess().getColonKeyword_2());
              		
            }
            loop221:
            do {
                int alt221=2;
                int LA221_0 = input.LA(1);

                if ( ((LA221_0>=Intersection && LA221_0<=Implements)||(LA221_0>=Promisify && LA221_0<=Function)||(LA221_0>=Private && LA221_0<=Delete)||(LA221_0>=Import && LA221_0<=Break)||(LA221_0>=Class && LA221_0<=This)||(LA221_0>=From && LA221_0<=With)||(LA221_0>=For && LA221_0<=Var)||LA221_0==PlusSignPlusSign||LA221_0==HyphenMinusHyphenMinus||LA221_0==SolidusEqualsSign||(LA221_0>=As && LA221_0<=If)||LA221_0==Of||LA221_0==ExclamationMark||LA221_0==LeftParenthesis||LA221_0==PlusSign||LA221_0==HyphenMinus||LA221_0==Solidus||(LA221_0>=Semicolon && LA221_0<=LessThanSign)||(LA221_0>=CommercialAt && LA221_0<=LeftSquareBracket)||LA221_0==LeftCurlyBracket||LA221_0==Tilde||LA221_0==RULE_DOUBLE||(LA221_0>=RULE_HEX_INT && LA221_0<=RULE_LEGACY_OCTAL_INT)||LA221_0==RULE_SCIENTIFIC_INT||LA221_0==RULE_IDENTIFIER||LA221_0==RULE_STRING||(LA221_0>=RULE_TEMPLATE_HEAD && LA221_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA221_0==RULE_INT) ) {
                    alt221=1;
                }


                switch (alt221) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getDefaultClauseAccess().getStatementsStatementParserRuleCall_3_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_3);
            	    lv_statements_3_0=ruleStatement();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getDefaultClauseRule());
            	      					}
            	      					add(
            	      						current,
            	      						"statements",
            	      						lv_statements_3_0,
            	      						"org.eclipse.n4js.N4JS.Statement");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop221;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_DefaultClause() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        EObject lv_statements_3_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getDefaultClauseAccess().getDefaultClauseAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Default,FOLLOW_94); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getDefaultClauseAccess().getDefaultKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,Colon,FOLLOW_56); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getDefaultClauseAccess().getColonKeyword_2());
              		
            }
            loop222:
            do {
                int alt222=2;
                int LA222_0 = input.LA(1);

                if ( ((LA222_0>=Intersection && LA222_0<=Implements)||(LA222_0>=Promisify && LA222_0<=Function)||(LA222_0>=Private && LA222_0<=Delete)||(LA222_0>=Import && LA222_0<=Break)||(LA222_0>=Class && LA222_0<=This)||(LA222_0>=From && LA222_0<=With)||(LA222_0>=For && LA222_0<=Var)||LA222_0==PlusSignPlusSign||LA222_0==HyphenMinusHyphenMinus||LA222_0==SolidusEqualsSign||(LA222_0>=As && LA222_0<=If)||LA222_0==Of||LA222_0==ExclamationMark||LA222_0==LeftParenthesis||LA222_0==PlusSign||LA222_0==HyphenMinus||LA222_0==Solidus||(LA222_0>=Semicolon && LA222_0<=LessThanSign)||(LA222_0>=CommercialAt && LA222_0<=LeftSquareBracket)||LA222_0==LeftCurlyBracket||LA222_0==Tilde||LA222_0==RULE_DOUBLE||(LA222_0>=RULE_HEX_INT && LA222_0<=RULE_LEGACY_OCTAL_INT)||LA222_0==RULE_SCIENTIFIC_INT||LA222_0==RULE_IDENTIFIER||LA222_0==RULE_STRING||(LA222_0>=RULE_TEMPLATE_HEAD && LA222_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA222_0==RULE_INT) ) {
                    alt222=1;
                }


                switch (alt222) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getDefaultClauseAccess().getStatementsStatementParserRuleCall_3_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_56);
            	    lv_statements_3_0=norm1_Statement();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getDefaultClauseRule());
            	      					}
            	      					add(
            	      						current,
            	      						"statements",
            	      						lv_statements_3_0,
            	      						"org.eclipse.n4js.N4JS.Statement");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop222;
                }
            } while (true);


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleLabelledStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleLabelledStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getLabelledStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleLabelledStatement=ruleLabelledStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleLabelledStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleLabelledStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        AntlrDatatypeRuleToken lv_name_0_0 = null;

        EObject lv_statement_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              							newCompositeNode(grammarAccess.getLabelledStatementAccess().getNameBindingIdentifierParserRuleCall_0_0_0_0());
              						
            }
            pushFollow(FOLLOW_94);
            lv_name_0_0=ruleBindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              							if (current==null) {
              								current = createModelElementForParent(grammarAccess.getLabelledStatementRule());
              							}
              							set(
              								current,
              								"name",
              								lv_name_0_0,
              								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              							afterParserOrEnumRuleCall();
              						
            }

            }


            }

            otherlv_1=(Token)match(input,Colon,FOLLOW_73); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_1, grammarAccess.getLabelledStatementAccess().getColonKeyword_0_0_1());
              				
            }

            }


            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getLabelledStatementAccess().getStatementStatementParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_statement_2_0=ruleStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getLabelledStatementRule());
              					}
              					set(
              						current,
              						"statement",
              						lv_statement_2_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_LabelledStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        AntlrDatatypeRuleToken lv_name_0_0 = null;

        EObject lv_statement_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            {
            {
            {
            if ( state.backtracking==0 ) {

              							newCompositeNode(grammarAccess.getLabelledStatementAccess().getNameBindingIdentifierParserRuleCall_0_0_0_0());
              						
            }
            pushFollow(FOLLOW_94);
            lv_name_0_0=norm1_BindingIdentifier();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              							if (current==null) {
              								current = createModelElementForParent(grammarAccess.getLabelledStatementRule());
              							}
              							set(
              								current,
              								"name",
              								lv_name_0_0,
              								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
              							afterParserOrEnumRuleCall();
              						
            }

            }


            }

            otherlv_1=(Token)match(input,Colon,FOLLOW_75); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					newLeafNode(otherlv_1, grammarAccess.getLabelledStatementAccess().getColonKeyword_0_0_1());
              				
            }

            }


            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getLabelledStatementAccess().getStatementStatementParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_statement_2_0=norm1_Statement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getLabelledStatementRule());
              					}
              					set(
              						current,
              						"statement",
              						lv_statement_2_0,
              						"org.eclipse.n4js.N4JS.Statement");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleThrowStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleThrowStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getThrowStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleThrowStatement=ruleThrowStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleThrowStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleThrowStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        EObject lv_expression_1_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Throw,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {
               promoteEOL(); 
            }
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getThrowStatementAccess().getThrowKeyword_0());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getThrowStatementAccess().getExpressionExpressionParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_18);
            lv_expression_1_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getThrowStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_1_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getThrowStatementAccess().getSemiParserRuleCall_2());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ThrowStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        EObject lv_expression_1_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Throw,FOLLOW_70); if (state.failed) return current;
            if ( state.backtracking==0 ) {
               promoteEOL(); 
            }
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getThrowStatementAccess().getThrowKeyword_0());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getThrowStatementAccess().getExpressionExpressionParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_18);
            lv_expression_1_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getThrowStatementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_1_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getThrowStatementAccess().getSemiParserRuleCall_2());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleTryStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleTryStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getTryStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleTryStatement=ruleTryStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleTryStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleTryStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        EObject lv_block_1_0 = null;

        EObject lv_catch_2_0 = null;

        EObject lv_finally_3_0 = null;

        EObject lv_finally_4_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Try,FOLLOW_13); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getTryStatementAccess().getTryKeyword_0());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getTryStatementAccess().getBlockBlockParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_95);
            lv_block_1_0=ruleBlock();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getTryStatementRule());
              					}
              					set(
              						current,
              						"block",
              						lv_block_1_0,
              						"org.eclipse.n4js.N4JS.Block");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            int alt224=2;
            int LA224_0 = input.LA(1);

            if ( (LA224_0==Catch) ) {
                alt224=1;
            }
            else if ( (LA224_0==Finally) ) {
                alt224=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 224, 0, input);

                throw nvae;
            }
            switch (alt224) {
                case 1 :
                    {
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getTryStatementAccess().getCatchCatchBlockParserRuleCall_2_0_0_0());
                      						
                    }
                    pushFollow(FOLLOW_96);
                    lv_catch_2_0=ruleCatchBlock();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getTryStatementRule());
                      							}
                      							set(
                      								current,
                      								"catch",
                      								lv_catch_2_0,
                      								"org.eclipse.n4js.N4JS.CatchBlock");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }
                    int alt223=2;
                    int LA223_0 = input.LA(1);

                    if ( (LA223_0==Finally) ) {
                        alt223=1;
                    }
                    switch (alt223) {
                        case 1 :
                            {
                            {
                            if ( state.backtracking==0 ) {

                              							newCompositeNode(grammarAccess.getTryStatementAccess().getFinallyFinallyBlockParserRuleCall_2_0_1_0());
                              						
                            }
                            pushFollow(FOLLOW_2);
                            lv_finally_3_0=ruleFinallyBlock();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElementForParent(grammarAccess.getTryStatementRule());
                              							}
                              							set(
                              								current,
                              								"finally",
                              								lv_finally_3_0,
                              								"org.eclipse.n4js.N4JS.FinallyBlock");
                              							afterParserOrEnumRuleCall();
                              						
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getTryStatementAccess().getFinallyFinallyBlockParserRuleCall_2_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_finally_4_0=ruleFinallyBlock();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getTryStatementRule());
                      						}
                      						set(
                      							current,
                      							"finally",
                      							lv_finally_4_0,
                      							"org.eclipse.n4js.N4JS.FinallyBlock");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_TryStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        EObject lv_block_1_0 = null;

        EObject lv_catch_2_0 = null;

        EObject lv_finally_3_0 = null;

        EObject lv_finally_4_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,Try,FOLLOW_13); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getTryStatementAccess().getTryKeyword_0());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getTryStatementAccess().getBlockBlockParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_95);
            lv_block_1_0=norm1_Block();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getTryStatementRule());
              					}
              					set(
              						current,
              						"block",
              						lv_block_1_0,
              						"org.eclipse.n4js.N4JS.Block");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }
            int alt226=2;
            int LA226_0 = input.LA(1);

            if ( (LA226_0==Catch) ) {
                alt226=1;
            }
            else if ( (LA226_0==Finally) ) {
                alt226=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return current;}
                NoViableAltException nvae =
                    new NoViableAltException("", 226, 0, input);

                throw nvae;
            }
            switch (alt226) {
                case 1 :
                    {
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getTryStatementAccess().getCatchCatchBlockParserRuleCall_2_0_0_0());
                      						
                    }
                    pushFollow(FOLLOW_96);
                    lv_catch_2_0=norm1_CatchBlock();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getTryStatementRule());
                      							}
                      							set(
                      								current,
                      								"catch",
                      								lv_catch_2_0,
                      								"org.eclipse.n4js.N4JS.CatchBlock");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }
                    int alt225=2;
                    int LA225_0 = input.LA(1);

                    if ( (LA225_0==Finally) ) {
                        alt225=1;
                    }
                    switch (alt225) {
                        case 1 :
                            {
                            {
                            if ( state.backtracking==0 ) {

                              							newCompositeNode(grammarAccess.getTryStatementAccess().getFinallyFinallyBlockParserRuleCall_2_0_1_0());
                              						
                            }
                            pushFollow(FOLLOW_2);
                            lv_finally_3_0=norm1_FinallyBlock();

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElementForParent(grammarAccess.getTryStatementRule());
                              							}
                              							set(
                              								current,
                              								"finally",
                              								lv_finally_3_0,
                              								"org.eclipse.n4js.N4JS.FinallyBlock");
                              							afterParserOrEnumRuleCall();
                              						
                            }

                            }


                            }
                            break;

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getTryStatementAccess().getFinallyFinallyBlockParserRuleCall_2_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_finally_4_0=norm1_FinallyBlock();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getTryStatementRule());
                      						}
                      						set(
                      							current,
                      							"finally",
                      							lv_finally_4_0,
                      							"org.eclipse.n4js.N4JS.FinallyBlock");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }
                    break;

            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleCatchBlock() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleCatchBlock = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getCatchBlockRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleCatchBlock=ruleCatchBlock();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleCatchBlock; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleCatchBlock() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        EObject lv_catchVariable_3_0 = null;

        EObject lv_block_5_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getCatchBlockAccess().getCatchBlockAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Catch,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getCatchBlockAccess().getCatchKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,LeftParenthesis,FOLLOW_97); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getCatchBlockAccess().getLeftParenthesisKeyword_2());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getCatchBlockAccess().getCatchVariableCatchVariableParserRuleCall_3_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_catchVariable_3_0=ruleCatchVariable();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getCatchBlockRule());
              					}
              					set(
              						current,
              						"catchVariable",
              						lv_catchVariable_3_0,
              						"org.eclipse.n4js.N4JS.CatchVariable");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_4=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_4, grammarAccess.getCatchBlockAccess().getRightParenthesisKeyword_4());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getCatchBlockAccess().getBlockBlockParserRuleCall_5_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_block_5_0=ruleBlock();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getCatchBlockRule());
              					}
              					set(
              						current,
              						"block",
              						lv_block_5_0,
              						"org.eclipse.n4js.N4JS.Block");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_CatchBlock() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_2=null;
        Token otherlv_4=null;
        EObject lv_catchVariable_3_0 = null;

        EObject lv_block_5_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getCatchBlockAccess().getCatchBlockAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Catch,FOLLOW_42); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getCatchBlockAccess().getCatchKeyword_1());
              		
            }
            otherlv_2=(Token)match(input,LeftParenthesis,FOLLOW_97); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getCatchBlockAccess().getLeftParenthesisKeyword_2());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getCatchBlockAccess().getCatchVariableCatchVariableParserRuleCall_3_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_catchVariable_3_0=norm1_CatchVariable();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getCatchBlockRule());
              					}
              					set(
              						current,
              						"catchVariable",
              						lv_catchVariable_3_0,
              						"org.eclipse.n4js.N4JS.CatchVariable");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_4=(Token)match(input,RightParenthesis,FOLLOW_13); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_4, grammarAccess.getCatchBlockAccess().getRightParenthesisKeyword_4());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getCatchBlockAccess().getBlockBlockParserRuleCall_5_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_block_5_0=norm1_Block();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getCatchBlockRule());
              					}
              					set(
              						current,
              						"block",
              						lv_block_5_0,
              						"org.eclipse.n4js.N4JS.Block");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleCatchVariable() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleCatchVariable = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getCatchVariableRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleCatchVariable=ruleCatchVariable();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleCatchVariable; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleCatchVariable() throws RecognitionException {
        EObject current = null;

        EObject lv_bindingPattern_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject this_ColonSepDeclaredTypeRef_2 = null;

        EObject this_BogusTypeRefFragment_3 = null;

        AntlrDatatypeRuleToken lv_name_4_0 = null;



        	enterRule();

        try {
            {
            int alt228=3;
            alt228 = dfa228.predict(input);
            switch (alt228) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getCatchVariableAccess().getBindingPatternBindingPatternParserRuleCall_0_0());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    lv_bindingPattern_0_0=ruleBindingPattern();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getCatchVariableRule());
                      					}
                      					set(
                      						current,
                      						"bindingPattern",
                      						lv_bindingPattern_0_0,
                      						"org.eclipse.n4js.N4JS.BindingPattern");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getCatchVariableAccess().getNameBindingIdentifierParserRuleCall_1_0_0_0());
                      						
                    }
                    pushFollow(FOLLOW_94);
                    lv_name_1_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getCatchVariableRule());
                      							}
                      							set(
                      								current,
                      								"name",
                      								lv_name_1_0,
                      								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }
                    {
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getCatchVariableRule());
                      						}
                      						newCompositeNode(grammarAccess.getCatchVariableAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_1());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    this_ColonSepDeclaredTypeRef_2=ruleColonSepDeclaredTypeRef(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						current = this_ColonSepDeclaredTypeRef_2;
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    int alt227=2;
                    alt227 = dfa227.predict(input);
                    switch (alt227) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              					if (current==null) {
                              						current = createModelElement(grammarAccess.getCatchVariableRule());
                              					}
                              					newCompositeNode(grammarAccess.getCatchVariableAccess().getBogusTypeRefFragmentParserRuleCall_2_0());
                              				
                            }
                            pushFollow(FOLLOW_8);
                            this_BogusTypeRefFragment_3=ruleBogusTypeRefFragment(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					current = this_BogusTypeRefFragment_3;
                              					afterParserOrEnumRuleCall();
                              				
                            }

                            }
                            break;

                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getCatchVariableAccess().getNameBindingIdentifierParserRuleCall_2_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_name_4_0=ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getCatchVariableRule());
                      						}
                      						set(
                      							current,
                      							"name",
                      							lv_name_4_0,
                      							"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_CatchVariable() throws RecognitionException {
        EObject current = null;

        EObject lv_bindingPattern_0_0 = null;

        AntlrDatatypeRuleToken lv_name_1_0 = null;

        EObject this_ColonSepDeclaredTypeRef_2 = null;

        EObject this_BogusTypeRefFragment_3 = null;

        AntlrDatatypeRuleToken lv_name_4_0 = null;



        	enterRule();

        try {
            {
            int alt230=3;
            alt230 = dfa230.predict(input);
            switch (alt230) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getCatchVariableAccess().getBindingPatternBindingPatternParserRuleCall_0_0());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    lv_bindingPattern_0_0=norm1_BindingPattern();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElementForParent(grammarAccess.getCatchVariableRule());
                      					}
                      					set(
                      						current,
                      						"bindingPattern",
                      						lv_bindingPattern_0_0,
                      						"org.eclipse.n4js.N4JS.BindingPattern");
                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      							newCompositeNode(grammarAccess.getCatchVariableAccess().getNameBindingIdentifierParserRuleCall_1_0_0_0());
                      						
                    }
                    pushFollow(FOLLOW_94);
                    lv_name_1_0=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      							if (current==null) {
                      								current = createModelElementForParent(grammarAccess.getCatchVariableRule());
                      							}
                      							set(
                      								current,
                      								"name",
                      								lv_name_1_0,
                      								"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      							afterParserOrEnumRuleCall();
                      						
                    }

                    }


                    }
                    {
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getCatchVariableRule());
                      						}
                      						newCompositeNode(grammarAccess.getCatchVariableAccess().getColonSepDeclaredTypeRefParserRuleCall_1_0_1());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    this_ColonSepDeclaredTypeRef_2=ruleColonSepDeclaredTypeRef(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						current = this_ColonSepDeclaredTypeRef_2;
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    int alt229=2;
                    alt229 = dfa229.predict(input);
                    switch (alt229) {
                        case 1 :
                            {
                            if ( state.backtracking==0 ) {

                              					if (current==null) {
                              						current = createModelElement(grammarAccess.getCatchVariableRule());
                              					}
                              					newCompositeNode(grammarAccess.getCatchVariableAccess().getBogusTypeRefFragmentParserRuleCall_2_0());
                              				
                            }
                            pushFollow(FOLLOW_8);
                            this_BogusTypeRefFragment_3=ruleBogusTypeRefFragment(current);

                            state._fsp--;
                            if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					current = this_BogusTypeRefFragment_3;
                              					afterParserOrEnumRuleCall();
                              				
                            }

                            }
                            break;

                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getCatchVariableAccess().getNameBindingIdentifierParserRuleCall_2_1_0());
                      					
                    }
                    pushFollow(FOLLOW_2);
                    lv_name_4_0=norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getCatchVariableRule());
                      						}
                      						set(
                      							current,
                      							"name",
                      							lv_name_4_0,
                      							"org.eclipse.n4js.ts.TypeExpressions.BindingIdentifier");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }


                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleFinallyBlock() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleFinallyBlock = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getFinallyBlockRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleFinallyBlock=ruleFinallyBlock();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleFinallyBlock; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleFinallyBlock() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_block_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getFinallyBlockAccess().getFinallyBlockAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Finally,FOLLOW_13); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getFinallyBlockAccess().getFinallyKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getFinallyBlockAccess().getBlockBlockParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_block_2_0=ruleBlock();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getFinallyBlockRule());
              					}
              					set(
              						current,
              						"block",
              						lv_block_2_0,
              						"org.eclipse.n4js.N4JS.Block");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_FinallyBlock() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        EObject lv_block_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getFinallyBlockAccess().getFinallyBlockAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Finally,FOLLOW_13); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getFinallyBlockAccess().getFinallyKeyword_1());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getFinallyBlockAccess().getBlockBlockParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_block_2_0=norm1_Block();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getFinallyBlockRule());
              					}
              					set(
              						current,
              						"block",
              						lv_block_2_0,
              						"org.eclipse.n4js.N4JS.Block");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleDebuggerStatement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleDebuggerStatement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getDebuggerStatementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleDebuggerStatement=ruleDebuggerStatement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleDebuggerStatement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleDebuggerStatement() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;


        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getDebuggerStatementAccess().getDebuggerStatementAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Debugger,FOLLOW_18); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getDebuggerStatementAccess().getDebuggerKeyword_1());
              		
            }
            if ( state.backtracking==0 ) {

              			newCompositeNode(grammarAccess.getDebuggerStatementAccess().getSemiParserRuleCall_2());
              		
            }
            pushFollow(FOLLOW_2);
            ruleSemi();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			afterParserOrEnumRuleCall();
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRulePrimaryExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_rulePrimaryExpression = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getPrimaryExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_rulePrimaryExpression=rulePrimaryExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_rulePrimaryExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject rulePrimaryExpression() throws RecognitionException {
        EObject current = null;
        EObject this_ThisLiteral_0 = null;

        EObject this_SuperLiteral_1 = null;

        EObject this_IdentifierRef_2 = null;

        EObject this_JSXFragment_3 = null;

        EObject this_JSXElement_4 = null;

        EObject this_ImportCallExpression_5 = null;

        EObject this_ParameterizedCallExpression_6 = null;

        EObject this_Literal_7 = null;

        EObject this_ArrayLiteral_8 = null;

        EObject this_ObjectLiteral_9 = null;

        EObject this_ParenExpression_10 = null;

        EObject this_AnnotatedExpression_11 = null;

        EObject this_FunctionExpression_12 = null;

        EObject this_AsyncFunctionExpression_13 = null;

        EObject this_N4ClassExpression_14 = null;

        EObject this_TemplateLiteral_15 = null;



        enterRule();
        try { 
        	{
            int alt231=16;
            // REPLACEMENT rulePrimaryExpression.java.replacement START
            try {
                alt231 = dfa231.predict(input);
            } catch (NoViableAltException re) {
            	int as = input.LA(1);
            	if (as==Async) { alt231=3; }
            	else throw re;
            }
            // REPLACEMENT rulePrimaryExpression.java.replacement END
            switch (alt231) {
                case 1 : 
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ThisLiteral_0=ruleThisLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ThisLiteral_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_SuperLiteral_1=ruleSuperLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_SuperLiteral_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 3 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_IdentifierRef_2=ruleIdentifierRef();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_IdentifierRef_2;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 4 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getJSXFragmentParserRuleCall_3());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_JSXFragment_3=ruleJSXFragment();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_JSXFragment_3;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 5 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_4());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_JSXElement_4=ruleJSXElement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_JSXElement_4;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 6 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getImportCallExpressionParserRuleCall_5());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ImportCallExpression_5=ruleImportCallExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ImportCallExpression_5;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 7 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_6());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ParameterizedCallExpression_6=ruleParameterizedCallExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ParameterizedCallExpression_6;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 8 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_7());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_Literal_7=ruleLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_Literal_7;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 9 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_8());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ArrayLiteral_8=ruleArrayLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ArrayLiteral_8;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 10 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_9());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ObjectLiteral_9=ruleObjectLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ObjectLiteral_9;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 11 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_10());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ParenExpression_10=ruleParenExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ParenExpression_10;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 12 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_11());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_AnnotatedExpression_11=ruleAnnotatedExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_AnnotatedExpression_11;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 13 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_12());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionExpression_12=ruleFunctionExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_FunctionExpression_12;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 14 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_13());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_AsyncFunctionExpression_13=ruleAsyncFunctionExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_AsyncFunctionExpression_13;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 15 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_14());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_N4ClassExpression_14=ruleN4ClassExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_N4ClassExpression_14;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 16 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_15());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_TemplateLiteral_15=ruleTemplateLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_TemplateLiteral_15;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_PrimaryExpression() throws RecognitionException {
        EObject current = null;

        EObject this_ThisLiteral_0 = null;

        EObject this_SuperLiteral_1 = null;

        EObject this_IdentifierRef_2 = null;

        EObject this_JSXFragment_3 = null;

        EObject this_JSXElement_4 = null;

        EObject this_ImportCallExpression_5 = null;

        EObject this_ParameterizedCallExpression_6 = null;

        EObject this_Literal_7 = null;

        EObject this_ArrayLiteral_8 = null;

        EObject this_ObjectLiteral_9 = null;

        EObject this_ParenExpression_10 = null;

        EObject this_AnnotatedExpression_11 = null;

        EObject this_FunctionExpression_12 = null;

        EObject this_AsyncFunctionExpression_13 = null;

        EObject this_N4ClassExpression_14 = null;

        EObject this_TemplateLiteral_15 = null;



        	enterRule();

        try {
            {
            int alt232=16;
            alt232 = dfa232.predict(input);
            switch (alt232) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getThisLiteralParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ThisLiteral_0=ruleThisLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ThisLiteral_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getSuperLiteralParserRuleCall_1());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_SuperLiteral_1=ruleSuperLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_SuperLiteral_1;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 3 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getIdentifierRefParserRuleCall_2());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_IdentifierRef_2=norm1_IdentifierRef();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_IdentifierRef_2;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 4 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getJSXFragmentParserRuleCall_3());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_JSXFragment_3=ruleJSXFragment();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_JSXFragment_3;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 5 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getJSXElementParserRuleCall_4());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_JSXElement_4=ruleJSXElement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_JSXElement_4;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 6 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getImportCallExpressionParserRuleCall_5());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ImportCallExpression_5=norm1_ImportCallExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ImportCallExpression_5;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 7 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getParameterizedCallExpressionParserRuleCall_6());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ParameterizedCallExpression_6=norm1_ParameterizedCallExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ParameterizedCallExpression_6;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 8 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getLiteralParserRuleCall_7());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_Literal_7=ruleLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_Literal_7;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 9 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getArrayLiteralParserRuleCall_8());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ArrayLiteral_8=norm1_ArrayLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ArrayLiteral_8;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 10 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getObjectLiteralParserRuleCall_9());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ObjectLiteral_9=norm1_ObjectLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ObjectLiteral_9;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 11 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getParenExpressionParserRuleCall_10());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_ParenExpression_10=norm1_ParenExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_ParenExpression_10;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 12 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getAnnotatedExpressionParserRuleCall_11());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_AnnotatedExpression_11=norm1_AnnotatedExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_AnnotatedExpression_11;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 13 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getFunctionExpressionParserRuleCall_12());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_FunctionExpression_12=ruleFunctionExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_FunctionExpression_12;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 14 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getAsyncFunctionExpressionParserRuleCall_13());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_AsyncFunctionExpression_13=ruleAsyncFunctionExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_AsyncFunctionExpression_13;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 15 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getN4ClassExpressionParserRuleCall_14());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_N4ClassExpression_14=norm1_N4ClassExpression();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_N4ClassExpression_14;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 16 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPrimaryExpressionAccess().getTemplateLiteralParserRuleCall_15());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_TemplateLiteral_15=norm1_TemplateLiteral();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_TemplateLiteral_15;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleParenExpression() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleParenExpression = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getParenExpressionRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleParenExpression=ruleParenExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleParenExpression; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleParenExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        EObject lv_expression_1_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,LeftParenthesis,FOLLOW_49); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getParenExpressionAccess().getLeftParenthesisKeyword_0());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getParenExpressionAccess().getExpressionExpressionParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_1_0=norm1_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getParenExpressionRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_1_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_2=(Token)match(input,RightParenthesis,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getParenExpressionAccess().getRightParenthesisKeyword_2());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ParenExpression() throws RecognitionException {
        EObject current = null;

        Token otherlv_0=null;
        Token otherlv_2=null;
        EObject lv_expression_1_0 = null;



        	enterRule();

        try {
            {
            {
            otherlv_0=(Token)match(input,LeftParenthesis,FOLLOW_70); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_0, grammarAccess.getParenExpressionAccess().getLeftParenthesisKeyword_0());
              		
            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getParenExpressionAccess().getExpressionExpressionParserRuleCall_1_0());
              				
            }
            pushFollow(FOLLOW_72);
            lv_expression_1_0=norm3_Expression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getParenExpressionRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_1_0,
              						"org.eclipse.n4js.N4JS.Expression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }

            otherlv_2=(Token)match(input,RightParenthesis,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_2, grammarAccess.getParenExpressionAccess().getRightParenthesisKeyword_2());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleIdentifierRef() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleIdentifierRef = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getIdentifierRefRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleIdentifierRef=ruleIdentifierRef();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleIdentifierRef; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleIdentifierRef() throws RecognitionException {
        EObject current = null;

        EObject this_VersionRequest_3 = null;



        	enterRule();

        try {
            {
            int alt233=2;
            alt233 = dfa233.predict(input);
            switch (alt233) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getIdentifierRefRule());
                      					}
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getIdentifierRefAccess().getIdIdentifiableElementCrossReference_0_0());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					current = forceCreateModelElement(
                      						grammarAccess.getIdentifierRefAccess().getVersionedIdentifierRefAction_1_0(),
                      						current);
                      				
                    }

                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getIdentifierRefRule());
                      						}
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getIdentifierRefAccess().getIdIdentifiableElementCrossReference_1_1_0());
                      					
                    }
                    pushFollow(FOLLOW_98);
                    ruleBindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getIdentifierRefRule());
                      				}
                      				newCompositeNode(grammarAccess.getIdentifierRefAccess().getVersionRequestParserRuleCall_1_2());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_VersionRequest_3=ruleVersionRequest(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VersionRequest_3;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_IdentifierRef() throws RecognitionException {
        EObject current = null;

        EObject this_VersionRequest_3 = null;



        	enterRule();

        try {
            {
            int alt234=2;
            alt234 = dfa234.predict(input);
            switch (alt234) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getIdentifierRefRule());
                      					}
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					newCompositeNode(grammarAccess.getIdentifierRefAccess().getIdIdentifiableElementCrossReference_0_0());
                      				
                    }
                    pushFollow(FOLLOW_2);
                    norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					afterParserOrEnumRuleCall();
                      				
                    }

                    }


                    }


                    }
                    break;
                case 2 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      					current = forceCreateModelElement(
                      						grammarAccess.getIdentifierRefAccess().getVersionedIdentifierRefAction_1_0(),
                      						current);
                      				
                    }

                    }
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElement(grammarAccess.getIdentifierRefRule());
                      						}
                      					
                    }
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getIdentifierRefAccess().getIdIdentifiableElementCrossReference_1_1_0());
                      					
                    }
                    pushFollow(FOLLOW_98);
                    norm1_BindingIdentifier();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }

                    if ( state.backtracking==0 ) {

                      				if (current==null) {
                      					current = createModelElement(grammarAccess.getIdentifierRefRule());
                      				}
                      				newCompositeNode(grammarAccess.getIdentifierRefAccess().getVersionRequestParserRuleCall_1_2());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_VersionRequest_3=ruleVersionRequest(current);

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_VersionRequest_3;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleSuperLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleSuperLiteral = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getSuperLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleSuperLiteral=ruleSuperLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleSuperLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleSuperLiteral() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;


        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getSuperLiteralAccess().getSuperLiteralAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Super,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getSuperLiteralAccess().getSuperKeyword_1());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleThisLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleThisLiteral = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getThisLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleThisLiteral=ruleThisLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleThisLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleThisLiteral() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;


        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getThisLiteralAccess().getThisLiteralAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,This_1,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getThisLiteralAccess().getThisKeyword_1());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleArrayLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleArrayLiteral = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getArrayLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleArrayLiteral=ruleArrayLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleArrayLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleArrayLiteral() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_4=null;
        Token lv_trailingComma_7_0=null;
        Token otherlv_9=null;
        EObject lv_elements_2_0 = null;

        EObject lv_elements_3_0 = null;

        EObject lv_elements_5_0 = null;

        EObject lv_elements_6_0 = null;

        EObject lv_elements_8_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getArrayLiteralAccess().getArrayLiteralAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,LeftSquareBracket,FOLLOW_99); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getArrayLiteralAccess().getLeftSquareBracketKeyword_1());
              		
            }
            loop235:
            do {
                int alt235=2;
                int LA235_0 = input.LA(1);

                if ( (LA235_0==Comma) ) {
                    alt235=1;
                }


                switch (alt235) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getArrayLiteralAccess().getElementsArrayPaddingParserRuleCall_2_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_99);
            	    lv_elements_2_0=ruleArrayPadding();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getArrayLiteralRule());
            	      					}
            	      					add(
            	      						current,
            	      						"elements",
            	      						lv_elements_2_0,
            	      						"org.eclipse.n4js.N4JS.ArrayPadding");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop235;
                }
            } while (true);
            int alt240=2;
            int LA240_0 = input.LA(1);

            if ( ((LA240_0>=Intersection && LA240_0<=Implements)||(LA240_0>=Promisify && LA240_0<=Abstract)||(LA240_0>=External && LA240_0<=Function)||(LA240_0>=Private && LA240_0<=Delete)||(LA240_0>=Import && LA240_0<=Public)||LA240_0==Static||(LA240_0>=Target && LA240_0<=Await)||LA240_0==Class||(LA240_0>=False && LA240_0<=Super)||LA240_0==Union||(LA240_0>=Yield && LA240_0<=This)||(LA240_0>=From && LA240_0<=Void)||LA240_0==FullStopFullStopFullStop||(LA240_0>=Get && LA240_0<=Set)||LA240_0==PlusSignPlusSign||LA240_0==HyphenMinusHyphenMinus||LA240_0==SolidusEqualsSign||LA240_0==As||LA240_0==Of||LA240_0==ExclamationMark||LA240_0==LeftParenthesis||LA240_0==PlusSign||LA240_0==HyphenMinus||LA240_0==Solidus||LA240_0==LessThanSign||(LA240_0>=CommercialAt && LA240_0<=LeftSquareBracket)||LA240_0==LeftCurlyBracket||LA240_0==Tilde||LA240_0==RULE_DOUBLE||(LA240_0>=RULE_HEX_INT && LA240_0<=RULE_LEGACY_OCTAL_INT)||LA240_0==RULE_SCIENTIFIC_INT||LA240_0==RULE_IDENTIFIER||LA240_0==RULE_STRING||(LA240_0>=RULE_TEMPLATE_HEAD && LA240_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA240_0==RULE_INT) ) {
                alt240=1;
            }
            switch (alt240) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getArrayLiteralAccess().getElementsArrayElementParserRuleCall_3_0_0());
                      					
                    }
                    pushFollow(FOLLOW_100);
                    lv_elements_3_0=ruleArrayElement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getArrayLiteralRule());
                      						}
                      						add(
                      							current,
                      							"elements",
                      							lv_elements_3_0,
                      							"org.eclipse.n4js.N4JS.ArrayElement");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }
                    loop237:
                    do {
                        int alt237=2;
                        alt237 = dfa237.predict(input);
                        switch (alt237) {
                    	case 1 :
                    	    {
                    	    otherlv_4=(Token)match(input,Comma,FOLLOW_101); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_4, grammarAccess.getArrayLiteralAccess().getCommaKeyword_3_1_0());
                    	      				
                    	    }
                    	    loop236:
                    	    do {
                    	        int alt236=2;
                    	        int LA236_0 = input.LA(1);

                    	        if ( (LA236_0==Comma) ) {
                    	            alt236=1;
                    	        }


                    	        switch (alt236) {
                    	    	case 1 :
                    	    	    {
                    	    	    {
                    	    	    if ( state.backtracking==0 ) {

                    	    	      							newCompositeNode(grammarAccess.getArrayLiteralAccess().getElementsArrayPaddingParserRuleCall_3_1_1_0());
                    	    	      						
                    	    	    }
                    	    	    pushFollow(FOLLOW_101);
                    	    	    lv_elements_5_0=ruleArrayPadding();

                    	    	    state._fsp--;
                    	    	    if (state.failed) return current;
                    	    	    if ( state.backtracking==0 ) {

                    	    	      							if (current==null) {
                    	    	      								current = createModelElementForParent(grammarAccess.getArrayLiteralRule());
                    	    	      							}
                    	    	      							add(
                    	    	      								current,
                    	    	      								"elements",
                    	    	      								lv_elements_5_0,
                    	    	      								"org.eclipse.n4js.N4JS.ArrayPadding");
                    	    	      							afterParserOrEnumRuleCall();
                    	    	      						
                    	    	    }

                    	    	    }


                    	    	    }
                    	    	    break;

                    	    	default :
                    	    	    break loop236;
                    	        }
                    	    } while (true);
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getArrayLiteralAccess().getElementsArrayElementParserRuleCall_3_1_2_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_100);
                    	    lv_elements_6_0=ruleArrayElement();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getArrayLiteralRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"elements",
                    	      								lv_elements_6_0,
                    	      								"org.eclipse.n4js.N4JS.ArrayElement");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop237;
                        }
                    } while (true);
                    int alt239=2;
                    int LA239_0 = input.LA(1);

                    if ( (LA239_0==Comma) ) {
                        alt239=1;
                    }
                    switch (alt239) {
                        case 1 :
                            {
                            {
                            {
                            lv_trailingComma_7_0=(Token)match(input,Comma,FOLLOW_100); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(lv_trailingComma_7_0, grammarAccess.getArrayLiteralAccess().getTrailingCommaCommaKeyword_3_2_0_0());
                              						
                            }
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElement(grammarAccess.getArrayLiteralRule());
                              							}
                              							setWithLastConsumed(current, "trailingComma", true, ",");
                              						
                            }

                            }


                            }
                            loop238:
                            do {
                                int alt238=2;
                                int LA238_0 = input.LA(1);

                                if ( (LA238_0==Comma) ) {
                                    alt238=1;
                                }


                                switch (alt238) {
                            	case 1 :
                            	    {
                            	    {
                            	    if ( state.backtracking==0 ) {

                            	      							newCompositeNode(grammarAccess.getArrayLiteralAccess().getElementsArrayPaddingParserRuleCall_3_2_1_0());
                            	      						
                            	    }
                            	    pushFollow(FOLLOW_100);
                            	    lv_elements_8_0=ruleArrayPadding();

                            	    state._fsp--;
                            	    if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      							if (current==null) {
                            	      								current = createModelElementForParent(grammarAccess.getArrayLiteralRule());
                            	      							}
                            	      							add(
                            	      								current,
                            	      								"elements",
                            	      								lv_elements_8_0,
                            	      								"org.eclipse.n4js.N4JS.ArrayPadding");
                            	      							afterParserOrEnumRuleCall();
                            	      						
                            	    }

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop238;
                                }
                            } while (true);


                            }
                            break;

                    }


                    }
                    break;

            }

            otherlv_9=(Token)match(input,RightSquareBracket,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_9, grammarAccess.getArrayLiteralAccess().getRightSquareBracketKeyword_4());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ArrayLiteral() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_4=null;
        Token lv_trailingComma_7_0=null;
        Token otherlv_9=null;
        EObject lv_elements_2_0 = null;

        EObject lv_elements_3_0 = null;

        EObject lv_elements_5_0 = null;

        EObject lv_elements_6_0 = null;

        EObject lv_elements_8_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getArrayLiteralAccess().getArrayLiteralAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,LeftSquareBracket,FOLLOW_102); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getArrayLiteralAccess().getLeftSquareBracketKeyword_1());
              		
            }
            loop241:
            do {
                int alt241=2;
                int LA241_0 = input.LA(1);

                if ( (LA241_0==Comma) ) {
                    alt241=1;
                }


                switch (alt241) {
            	case 1 :
            	    {
            	    {
            	    if ( state.backtracking==0 ) {

            	      					newCompositeNode(grammarAccess.getArrayLiteralAccess().getElementsArrayPaddingParserRuleCall_2_0());
            	      				
            	    }
            	    pushFollow(FOLLOW_102);
            	    lv_elements_2_0=ruleArrayPadding();

            	    state._fsp--;
            	    if (state.failed) return current;
            	    if ( state.backtracking==0 ) {

            	      					if (current==null) {
            	      						current = createModelElementForParent(grammarAccess.getArrayLiteralRule());
            	      					}
            	      					add(
            	      						current,
            	      						"elements",
            	      						lv_elements_2_0,
            	      						"org.eclipse.n4js.N4JS.ArrayPadding");
            	      					afterParserOrEnumRuleCall();
            	      				
            	    }

            	    }


            	    }
            	    break;

            	default :
            	    break loop241;
                }
            } while (true);
            int alt246=2;
            int LA246_0 = input.LA(1);

            if ( ((LA246_0>=Intersection && LA246_0<=Implements)||(LA246_0>=Promisify && LA246_0<=Abstract)||(LA246_0>=External && LA246_0<=Function)||(LA246_0>=Private && LA246_0<=Delete)||(LA246_0>=Import && LA246_0<=Public)||LA246_0==Static||(LA246_0>=Target && LA246_0<=Await)||LA246_0==Class||(LA246_0>=False && LA246_0<=Super)||LA246_0==Union||(LA246_0>=Yield && LA246_0<=This)||(LA246_0>=From && LA246_0<=Void)||LA246_0==FullStopFullStopFullStop||(LA246_0>=Get && LA246_0<=Set)||LA246_0==PlusSignPlusSign||LA246_0==HyphenMinusHyphenMinus||LA246_0==SolidusEqualsSign||LA246_0==As||LA246_0==Of||LA246_0==ExclamationMark||LA246_0==LeftParenthesis||LA246_0==PlusSign||LA246_0==HyphenMinus||LA246_0==Solidus||LA246_0==LessThanSign||(LA246_0>=CommercialAt && LA246_0<=LeftSquareBracket)||LA246_0==LeftCurlyBracket||LA246_0==Tilde||LA246_0==RULE_DOUBLE||(LA246_0>=RULE_HEX_INT && LA246_0<=RULE_LEGACY_OCTAL_INT)||LA246_0==RULE_SCIENTIFIC_INT||LA246_0==RULE_IDENTIFIER||LA246_0==RULE_STRING||(LA246_0>=RULE_TEMPLATE_HEAD && LA246_0<=RULE_NO_SUBSTITUTION_TEMPLATE_LITERAL)||LA246_0==RULE_INT) ) {
                alt246=1;
            }
            switch (alt246) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getArrayLiteralAccess().getElementsArrayElementParserRuleCall_3_0_0());
                      					
                    }
                    pushFollow(FOLLOW_100);
                    lv_elements_3_0=norm1_ArrayElement();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getArrayLiteralRule());
                      						}
                      						add(
                      							current,
                      							"elements",
                      							lv_elements_3_0,
                      							"org.eclipse.n4js.N4JS.ArrayElement");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }
                    loop243:
                    do {
                        int alt243=2;
                        alt243 = dfa243.predict(input);
                        switch (alt243) {
                    	case 1 :
                    	    {
                    	    otherlv_4=(Token)match(input,Comma,FOLLOW_103); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_4, grammarAccess.getArrayLiteralAccess().getCommaKeyword_3_1_0());
                    	      				
                    	    }
                    	    loop242:
                    	    do {
                    	        int alt242=2;
                    	        int LA242_0 = input.LA(1);

                    	        if ( (LA242_0==Comma) ) {
                    	            alt242=1;
                    	        }


                    	        switch (alt242) {
                    	    	case 1 :
                    	    	    {
                    	    	    {
                    	    	    if ( state.backtracking==0 ) {

                    	    	      							newCompositeNode(grammarAccess.getArrayLiteralAccess().getElementsArrayPaddingParserRuleCall_3_1_1_0());
                    	    	      						
                    	    	    }
                    	    	    pushFollow(FOLLOW_103);
                    	    	    lv_elements_5_0=ruleArrayPadding();

                    	    	    state._fsp--;
                    	    	    if (state.failed) return current;
                    	    	    if ( state.backtracking==0 ) {

                    	    	      							if (current==null) {
                    	    	      								current = createModelElementForParent(grammarAccess.getArrayLiteralRule());
                    	    	      							}
                    	    	      							add(
                    	    	      								current,
                    	    	      								"elements",
                    	    	      								lv_elements_5_0,
                    	    	      								"org.eclipse.n4js.N4JS.ArrayPadding");
                    	    	      							afterParserOrEnumRuleCall();
                    	    	      						
                    	    	    }

                    	    	    }


                    	    	    }
                    	    	    break;

                    	    	default :
                    	    	    break loop242;
                    	        }
                    	    } while (true);
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getArrayLiteralAccess().getElementsArrayElementParserRuleCall_3_1_2_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_100);
                    	    lv_elements_6_0=norm1_ArrayElement();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getArrayLiteralRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"elements",
                    	      								lv_elements_6_0,
                    	      								"org.eclipse.n4js.N4JS.ArrayElement");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop243;
                        }
                    } while (true);
                    int alt245=2;
                    int LA245_0 = input.LA(1);

                    if ( (LA245_0==Comma) ) {
                        alt245=1;
                    }
                    switch (alt245) {
                        case 1 :
                            {
                            {
                            {
                            lv_trailingComma_7_0=(Token)match(input,Comma,FOLLOW_100); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              							newLeafNode(lv_trailingComma_7_0, grammarAccess.getArrayLiteralAccess().getTrailingCommaCommaKeyword_3_2_0_0());
                              						
                            }
                            if ( state.backtracking==0 ) {

                              							if (current==null) {
                              								current = createModelElement(grammarAccess.getArrayLiteralRule());
                              							}
                              							setWithLastConsumed(current, "trailingComma", true, ",");
                              						
                            }

                            }


                            }
                            loop244:
                            do {
                                int alt244=2;
                                int LA244_0 = input.LA(1);

                                if ( (LA244_0==Comma) ) {
                                    alt244=1;
                                }


                                switch (alt244) {
                            	case 1 :
                            	    {
                            	    {
                            	    if ( state.backtracking==0 ) {

                            	      							newCompositeNode(grammarAccess.getArrayLiteralAccess().getElementsArrayPaddingParserRuleCall_3_2_1_0());
                            	      						
                            	    }
                            	    pushFollow(FOLLOW_100);
                            	    lv_elements_8_0=ruleArrayPadding();

                            	    state._fsp--;
                            	    if (state.failed) return current;
                            	    if ( state.backtracking==0 ) {

                            	      							if (current==null) {
                            	      								current = createModelElementForParent(grammarAccess.getArrayLiteralRule());
                            	      							}
                            	      							add(
                            	      								current,
                            	      								"elements",
                            	      								lv_elements_8_0,
                            	      								"org.eclipse.n4js.N4JS.ArrayPadding");
                            	      							afterParserOrEnumRuleCall();
                            	      						
                            	    }

                            	    }


                            	    }
                            	    break;

                            	default :
                            	    break loop244;
                                }
                            } while (true);


                            }
                            break;

                    }


                    }
                    break;

            }

            otherlv_9=(Token)match(input,RightSquareBracket,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_9, grammarAccess.getArrayLiteralAccess().getRightSquareBracketKeyword_4());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleArrayPadding() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleArrayPadding = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getArrayPaddingRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleArrayPadding=ruleArrayPadding();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleArrayPadding; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleArrayPadding() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;


        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getArrayPaddingAccess().getArrayPaddingAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,Comma,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getArrayPaddingAccess().getCommaKeyword_1());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleArrayElement() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleArrayElement = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getArrayElementRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleArrayElement=ruleArrayElement();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleArrayElement; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleArrayElement() throws RecognitionException {
        EObject current = null;

        Token lv_spread_1_0=null;
        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getArrayElementAccess().getArrayElementAction_0(),
              					current);
              			
            }

            }
            int alt247=2;
            int LA247_0 = input.LA(1);

            if ( (LA247_0==FullStopFullStopFullStop) ) {
                alt247=1;
            }
            switch (alt247) {
                case 1 :
                    {
                    {
                    lv_spread_1_0=(Token)match(input,FullStopFullStopFullStop,FOLLOW_49); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(lv_spread_1_0, grammarAccess.getArrayElementAccess().getSpreadFullStopFullStopFullStopKeyword_1_0());
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getArrayElementRule());
                      					}
                      					setWithLastConsumed(current, "spread", true, "...");
                      				
                    }

                    }


                    }
                    break;

            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getArrayElementAccess().getExpressionAssignmentExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_expression_2_0=norm1_AssignmentExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getArrayElementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.AssignmentExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ArrayElement() throws RecognitionException {
        EObject current = null;

        Token lv_spread_1_0=null;
        EObject lv_expression_2_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getArrayElementAccess().getArrayElementAction_0(),
              					current);
              			
            }

            }
            int alt248=2;
            int LA248_0 = input.LA(1);

            if ( (LA248_0==FullStopFullStopFullStop) ) {
                alt248=1;
            }
            switch (alt248) {
                case 1 :
                    {
                    {
                    lv_spread_1_0=(Token)match(input,FullStopFullStopFullStop,FOLLOW_70); if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      					newLeafNode(lv_spread_1_0, grammarAccess.getArrayElementAccess().getSpreadFullStopFullStopFullStopKeyword_1_0());
                      				
                    }
                    if ( state.backtracking==0 ) {

                      					if (current==null) {
                      						current = createModelElement(grammarAccess.getArrayElementRule());
                      					}
                      					setWithLastConsumed(current, "spread", true, "...");
                      				
                    }

                    }


                    }
                    break;

            }
            {
            {
            if ( state.backtracking==0 ) {

              					newCompositeNode(grammarAccess.getArrayElementAccess().getExpressionAssignmentExpressionParserRuleCall_2_0());
              				
            }
            pushFollow(FOLLOW_2);
            lv_expression_2_0=norm3_AssignmentExpression();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {

              					if (current==null) {
              						current = createModelElementForParent(grammarAccess.getArrayElementRule());
              					}
              					set(
              						current,
              						"expression",
              						lv_expression_2_0,
              						"org.eclipse.n4js.N4JS.AssignmentExpression");
              					afterParserOrEnumRuleCall();
              				
            }

            }


            }


            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRuleObjectLiteral() throws RecognitionException {
        EObject current = null;

        EObject iv_ruleObjectLiteral = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getObjectLiteralRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_ruleObjectLiteral=ruleObjectLiteral();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_ruleObjectLiteral; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject ruleObjectLiteral() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token otherlv_6=null;
        EObject lv_propertyAssignments_2_0 = null;

        EObject lv_propertyAssignments_4_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getObjectLiteralAccess().getObjectLiteralAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,LeftCurlyBracket,FOLLOW_104); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getObjectLiteralAccess().getLeftCurlyBracketKeyword_1());
              		
            }
            int alt251=2;
            int LA251_0 = input.LA(1);

            if ( ((LA251_0>=Intersection && LA251_0<=With)||(LA251_0>=For && LA251_0<=Var)||(LA251_0>=As && LA251_0<=Of)||LA251_0==LeftParenthesis||LA251_0==Asterisk||LA251_0==LessThanSign||(LA251_0>=QuestionMark && LA251_0<=LeftSquareBracket)||LA251_0==LeftCurlyBracket||LA251_0==Tilde||LA251_0==RULE_DOUBLE||LA251_0==RULE_HEX_INT||LA251_0==RULE_OCTAL_INT||LA251_0==RULE_SCIENTIFIC_INT||LA251_0==RULE_IDENTIFIER||LA251_0==RULE_STRING||LA251_0==RULE_INT) ) {
                alt251=1;
            }
            switch (alt251) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0());
                      					
                    }
                    pushFollow(FOLLOW_15);
                    lv_propertyAssignments_2_0=rulePropertyAssignment();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getObjectLiteralRule());
                      						}
                      						add(
                      							current,
                      							"propertyAssignments",
                      							lv_propertyAssignments_2_0,
                      							"org.eclipse.n4js.N4JS.PropertyAssignment");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }
                    loop249:
                    do {
                        int alt249=2;
                        int LA249_0 = input.LA(1);

                        if ( (LA249_0==Comma) ) {
                            int LA249_1 = input.LA(2);

                            if ( ((LA249_1>=Intersection && LA249_1<=With)||(LA249_1>=For && LA249_1<=Var)||(LA249_1>=As && LA249_1<=Of)||LA249_1==LeftParenthesis||LA249_1==Asterisk||LA249_1==LessThanSign||(LA249_1>=QuestionMark && LA249_1<=LeftSquareBracket)||LA249_1==LeftCurlyBracket||LA249_1==Tilde||LA249_1==RULE_DOUBLE||LA249_1==RULE_HEX_INT||LA249_1==RULE_OCTAL_INT||LA249_1==RULE_SCIENTIFIC_INT||LA249_1==RULE_IDENTIFIER||LA249_1==RULE_STRING||LA249_1==RULE_INT) ) {
                                alt249=1;
                            }


                        }


                        switch (alt249) {
                    	case 1 :
                    	    {
                    	    otherlv_3=(Token)match(input,Comma,FOLLOW_105); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_3, grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_1_0());
                    	      				
                    	    }
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_15);
                    	    lv_propertyAssignments_4_0=rulePropertyAssignment();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getObjectLiteralRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"propertyAssignments",
                    	      								lv_propertyAssignments_4_0,
                    	      								"org.eclipse.n4js.N4JS.PropertyAssignment");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop249;
                        }
                    } while (true);
                    int alt250=2;
                    int LA250_0 = input.LA(1);

                    if ( (LA250_0==Comma) ) {
                        alt250=1;
                    }
                    switch (alt250) {
                        case 1 :
                            {
                            otherlv_5=(Token)match(input,Comma,FOLLOW_23); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					newLeafNode(otherlv_5, grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_2());
                              				
                            }

                            }
                            break;

                    }


                    }
                    break;

            }

            otherlv_6=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_6, grammarAccess.getObjectLiteralAccess().getRightCurlyBracketKeyword_3());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject norm1_ObjectLiteral() throws RecognitionException {
        EObject current = null;

        Token otherlv_1=null;
        Token otherlv_3=null;
        Token otherlv_5=null;
        Token otherlv_6=null;
        EObject lv_propertyAssignments_2_0 = null;

        EObject lv_propertyAssignments_4_0 = null;



        	enterRule();

        try {
            {
            {
            {
            if ( state.backtracking==0 ) {

              				current = forceCreateModelElement(
              					grammarAccess.getObjectLiteralAccess().getObjectLiteralAction_0(),
              					current);
              			
            }

            }

            otherlv_1=(Token)match(input,LeftCurlyBracket,FOLLOW_104); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_1, grammarAccess.getObjectLiteralAccess().getLeftCurlyBracketKeyword_1());
              		
            }
            int alt254=2;
            int LA254_0 = input.LA(1);

            if ( ((LA254_0>=Intersection && LA254_0<=With)||(LA254_0>=For && LA254_0<=Var)||(LA254_0>=As && LA254_0<=Of)||LA254_0==LeftParenthesis||LA254_0==Asterisk||LA254_0==LessThanSign||(LA254_0>=QuestionMark && LA254_0<=LeftSquareBracket)||LA254_0==LeftCurlyBracket||LA254_0==Tilde||LA254_0==RULE_DOUBLE||LA254_0==RULE_HEX_INT||LA254_0==RULE_OCTAL_INT||LA254_0==RULE_SCIENTIFIC_INT||LA254_0==RULE_IDENTIFIER||LA254_0==RULE_STRING||LA254_0==RULE_INT) ) {
                alt254=1;
            }
            switch (alt254) {
                case 1 :
                    {
                    {
                    {
                    if ( state.backtracking==0 ) {

                      						newCompositeNode(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsPropertyAssignmentParserRuleCall_2_0_0());
                      					
                    }
                    pushFollow(FOLLOW_15);
                    lv_propertyAssignments_2_0=norm1_PropertyAssignment();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      						if (current==null) {
                      							current = createModelElementForParent(grammarAccess.getObjectLiteralRule());
                      						}
                      						add(
                      							current,
                      							"propertyAssignments",
                      							lv_propertyAssignments_2_0,
                      							"org.eclipse.n4js.N4JS.PropertyAssignment");
                      						afterParserOrEnumRuleCall();
                      					
                    }

                    }


                    }
                    loop252:
                    do {
                        int alt252=2;
                        int LA252_0 = input.LA(1);

                        if ( (LA252_0==Comma) ) {
                            int LA252_1 = input.LA(2);

                            if ( ((LA252_1>=Intersection && LA252_1<=With)||(LA252_1>=For && LA252_1<=Var)||(LA252_1>=As && LA252_1<=Of)||LA252_1==LeftParenthesis||LA252_1==Asterisk||LA252_1==LessThanSign||(LA252_1>=QuestionMark && LA252_1<=LeftSquareBracket)||LA252_1==LeftCurlyBracket||LA252_1==Tilde||LA252_1==RULE_DOUBLE||LA252_1==RULE_HEX_INT||LA252_1==RULE_OCTAL_INT||LA252_1==RULE_SCIENTIFIC_INT||LA252_1==RULE_IDENTIFIER||LA252_1==RULE_STRING||LA252_1==RULE_INT) ) {
                                alt252=1;
                            }


                        }


                        switch (alt252) {
                    	case 1 :
                    	    {
                    	    otherlv_3=(Token)match(input,Comma,FOLLOW_105); if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      					newLeafNode(otherlv_3, grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_1_0());
                    	      				
                    	    }
                    	    {
                    	    {
                    	    if ( state.backtracking==0 ) {

                    	      							newCompositeNode(grammarAccess.getObjectLiteralAccess().getPropertyAssignmentsPropertyAssignmentParserRuleCall_2_1_1_0());
                    	      						
                    	    }
                    	    pushFollow(FOLLOW_15);
                    	    lv_propertyAssignments_4_0=norm1_PropertyAssignment();

                    	    state._fsp--;
                    	    if (state.failed) return current;
                    	    if ( state.backtracking==0 ) {

                    	      							if (current==null) {
                    	      								current = createModelElementForParent(grammarAccess.getObjectLiteralRule());
                    	      							}
                    	      							add(
                    	      								current,
                    	      								"propertyAssignments",
                    	      								lv_propertyAssignments_4_0,
                    	      								"org.eclipse.n4js.N4JS.PropertyAssignment");
                    	      							afterParserOrEnumRuleCall();
                    	      						
                    	    }

                    	    }


                    	    }


                    	    }
                    	    break;

                    	default :
                    	    break loop252;
                        }
                    } while (true);
                    int alt253=2;
                    int LA253_0 = input.LA(1);

                    if ( (LA253_0==Comma) ) {
                        alt253=1;
                    }
                    switch (alt253) {
                        case 1 :
                            {
                            otherlv_5=(Token)match(input,Comma,FOLLOW_23); if (state.failed) return current;
                            if ( state.backtracking==0 ) {

                              					newLeafNode(otherlv_5, grammarAccess.getObjectLiteralAccess().getCommaKeyword_2_2());
                              				
                            }

                            }
                            break;

                    }


                    }
                    break;

            }

            otherlv_6=(Token)match(input,RightCurlyBracket,FOLLOW_2); if (state.failed) return current;
            if ( state.backtracking==0 ) {

              			newLeafNode(otherlv_6, grammarAccess.getObjectLiteralAccess().getRightCurlyBracketKeyword_3());
              		
            }

            }


            }

            if ( state.backtracking==0 ) {

              	leaveRule();

            }
        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject entryRulePropertyAssignment() throws RecognitionException {
        EObject current = null;

        EObject iv_rulePropertyAssignment = null;


        try {
            {
            if ( state.backtracking==0 ) {
               newCompositeNode(grammarAccess.getPropertyAssignmentRule()); 
            }
            pushFollow(FOLLOW_1);
            iv_rulePropertyAssignment=rulePropertyAssignment();

            state._fsp--;
            if (state.failed) return current;
            if ( state.backtracking==0 ) {
               current =iv_rulePropertyAssignment; 
            }
            match(input,EOF,FOLLOW_2); if (state.failed) return current;

            }

        }

            catch (RecognitionException re) {
                recover(input,re);
                appendSkippedTokens();
            }
        finally {
        }
        return current;
    }
    public final EObject rulePropertyAssignment() throws RecognitionException {
        EObject current = null;

        EObject this_AnnotatedPropertyAssignment_0 = null;

        EObject this_PropertyNameValuePair_1 = null;

        EObject this_PropertyGetterDeclaration_2 = null;

        EObject this_PropertySetterDeclaration_3 = null;

        EObject this_PropertyMethodDeclaration_4 = null;

        EObject this_PropertyNameValuePairSingleName_5 = null;



        	enterRule();

        try {
            {
            int alt255=6;
            alt255 = dfa255.predict(input);
            switch (alt255) {
                case 1 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPropertyAssignmentAccess().getAnnotatedPropertyAssignmentParserRuleCall_0());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_AnnotatedPropertyAssignment_0=ruleAnnotatedPropertyAssignment();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      			current = this_AnnotatedPropertyAssignment_0;
                      			afterParserOrEnumRuleCall();
                      		
                    }

                    }
                    break;
                case 2 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairParserRuleCall_1());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_PropertyNameValuePair_1=rulePropertyNameValuePair();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_PropertyNameValuePair_1;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 3 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getPropertyAssignmentAccess().getPropertyGetterDeclarationParserRuleCall_2());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_PropertyGetterDeclaration_2=rulePropertyGetterDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_PropertyGetterDeclaration_2;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 4 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getPropertyAssignmentAccess().getPropertySetterDeclarationParserRuleCall_3());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_PropertySetterDeclaration_3=rulePropertySetterDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_PropertySetterDeclaration_3;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 5 :
                    {
                    {
                    if ( state.backtracking==0 ) {

                      				newCompositeNode(grammarAccess.getPropertyAssignmentAccess().getPropertyMethodDeclarationParserRuleCall_4());
                      			
                    }
                    pushFollow(FOLLOW_2);
                    this_PropertyMethodDeclaration_4=rulePropertyMethodDeclaration();

                    state._fsp--;
                    if (state.failed) return current;
                    if ( state.backtracking==0 ) {

                      				current = this_PropertyMethodDeclaration_4;
                      				afterParserOrEnumRuleCall();
                      			
                    }

                    }


                    }
                    break;
                case 6 :
                    {
                    if ( state.backtracking==0 ) {

                      			newCompositeNode(grammarAccess.getPropertyAssignmentAccess().getPropertyNameValuePairSingleNameParserRuleCall_5());
                      		
                    }
                    pushFollow(FOLLOW_2);
                    this_PropertyNameValuePairSingleName_5=rulePropertyNameValuePairSingleName();

                    state._fsp--;
                    if (state.failed) return current;