/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.N4JSInjectorProvider;
import org.eclipse.n4js.N4JSParseHelper;
import org.eclipse.n4js.N4JSTestHelper;
import org.eclipse.n4js.N4JSValidationTestHelper;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.testing.InjectWith;
import org.eclipse.xtext.testing.XtextRunner;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=XtextRunner.class)
@InjectWith(value=N4JSInjectorProvider.class)
public abstract class AbstractN4JSTest
extends Assert {
    @Inject
    @Extension
    protected N4JSTestHelper _n4JSTestHelper;
    @Inject
    @Extension
    protected N4JSParseHelper _n4JSParseHelper;
    @Inject
    @Extension
    protected N4JSValidationTestHelper _n4JSValidationTestHelper;
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private IN4JSCore n4jsCore;

    protected N4JSResource createFromFile(URI uri) {
        return (N4JSResource)IterableExtensions.head(this.createFromFiles(uri));
    }

    protected List<N4JSResource> createFromFiles(URI ... uris) {
        XtextResourceSet resSet = (XtextResourceSet)this.resourceSetProvider.get();
        Function<URI, N4JSResource> _function = u -> {
            URI normalizedURI = resSet.getURIConverter().normalize(u);
            Resource _createResource = resSet.createResource(normalizedURI);
            return (N4JSResource)_createResource;
        };
        List<N4JSResource> resources = ((List)Conversions.doWrapArray((Object)uris)).stream().map(_function).collect(Collectors.toList());
        return resources;
    }

    protected N4JSResource loadFromFile(URI uri) {
        try {
            N4JSResource res = this.createFromFile(uri);
            res.load(CollectionLiterals.emptyMap());
            return res;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected N4JSResource parseFromFile(URI uri) {
        N4JSResource res = this.loadFromFile(uri);
        res.getContents();
        return res;
    }

    protected N4JSResource loadFromDescription(URI uri) {
        return (N4JSResource)IterableExtensions.head(this.loadFromDescriptions(uri));
    }

    protected List<N4JSResource> loadFromDescriptions(URI ... uris) {
        boolean _isEmpty = ((List)Conversions.doWrapArray((Object)uris)).isEmpty();
        if (_isEmpty) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        List<N4JSResource> resources = this.createFromFiles(uris);
        Consumer<N4JSResource> _function = res -> {
            try {
                res.load(CollectionLiterals.emptyMap());
                res.getContents();
                res.performPostProcessing();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        resources.forEach(_function);
        ResourceSet resSet = ((N4JSResource)IterableExtensions.head(resources)).getResourceSet();
        Function<N4JSResource, IResourceDescription> _function_1 = res -> {
            this._n4JSValidationTestHelper.assertNoErrors((Resource)res);
            URI uri = res.getURI();
            IResourceDescriptions resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions((Resource)res);
            Assert.assertFalse((String)"index has not been filled", (boolean)IterableExtensions.isEmpty((Iterable)resourceDescriptions.getAllResourceDescriptions()));
            IResourceDescription description = resourceDescriptions.getResourceDescription(uri);
            ((IEObjectDescription)IterableExtensions.head((Iterable)description.getExportedObjects())).getUserData("serializedScript");
            Assert.assertTrue((boolean)res.isFullyInitialized());
            Assert.assertTrue((boolean)res.isFullyProcessed());
            return description;
        };
        List descriptions = resources.stream().map(_function_1).collect(Collectors.toList());
        Consumer<N4JSResource> _function_2 = res -> {
            res.unload();
            resSet.getResources().remove(res);
        };
        resources.forEach(_function_2);
        Function<IResourceDescription, N4JSResource> _function_3 = resDesc -> {
            Resource _eResource = this.n4jsCore.loadModuleFromIndex(resSet, resDesc, false).eResource();
            N4JSResource resFromIndex = (N4JSResource)_eResource;
            Assert.assertTrue((boolean)resFromIndex.getScript().eIsProxy());
            Assert.assertFalse((boolean)resFromIndex.getModule().eIsProxy());
            return resFromIndex;
        };
        List<N4JSResource> reloadedResources = descriptions.stream().map(_function_3).collect(Collectors.toList());
        return reloadedResources;
    }
}

