/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.csv;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.n4js.csv.CSVRecord;

public class CSVData
implements Iterable<CSVRecord> {
    private final List<CSVRecord> records;

    protected CSVData() {
        this.records = new ArrayList<CSVRecord>();
    }

    private CSVData(List<CSVRecord> records) {
        this.records = Objects.requireNonNull(records);
    }

    protected void add(CSVRecord record) {
        this.records.add(Objects.requireNonNull(record));
    }

    public int getSize() {
        return this.records.size();
    }

    public CSVRecord get(int index) {
        return this.records.get(index);
    }

    public String get(int rowIndex, int colIndex) {
        return this.get(rowIndex).get(colIndex);
    }

    public CSVData getRange(int rowIndex, int colIndex, int rowCount, int colCount) {
        int actualRowCount = rowCount < 0 ? this.getSize() - rowIndex : rowCount;
        ArrayList<CSVRecord> result = new ArrayList<CSVRecord>();
        int i = rowIndex;
        while (i < rowIndex + actualRowCount) {
            result.add(this.get(i).getRange(colIndex, colCount));
            ++i;
        }
        return new CSVData(result);
    }

    @Override
    public Iterator<CSVRecord> iterator() {
        return Collections.unmodifiableList(this.records).iterator();
    }

    public String toString() {
        return this.records.toString();
    }
}

