/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.test.helper.hlc;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.n4js.json.JSONStandaloneSetup;
import org.eclipse.n4js.test.helper.hlc.EnvironmentVariableUtils;
import org.eclipse.n4js.test.helper.hlc.N4jsLibsAccess;
import org.eclipse.n4js.utils.io.FileCopier;
import org.eclipse.n4js.utils.io.FileDeleter;
import org.eclipse.xtext.testing.GlobalRegistries;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

public class N4CliHelper {
    public static final String PACKAGES = "packages";
    private static final Set<String> N4JS_LIBS_BLACKLIST = new HashSet<String>(Arrays.asList("n4js-cli", "org.eclipse.n4js.mangelhaft.test", "org.eclipse.n4js.mangelhaft.assert.test", "org.eclipse.n4js.mangelhaft.reporter.ide.test"));
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase();

    public static void assertExpectedOutput(String expectedString, File log) {
        N4CliHelper.assertExpectedOutput(expectedString, N4CliHelper.readLogfile(log));
    }

    public static void assertExpectedOutput(String expectedString, String out) {
        Assert.assertEquals((String)"Output differs", (Object)expectedString, (Object)out);
    }

    @Deprecated
    public static void assertExpectedOutputEndsWith(String expectedString, File log) {
        String x = N4CliHelper.readLogfile(log);
        N4CliHelper.assertExpectedOutputEndsWith(expectedString, x);
    }

    public static void assertEndOfOutputExpectedToContain(String endMarker, String expectedString, File log) {
        String r = N4CliHelper.readLogfile(log);
        int idx = r.indexOf(endMarker);
        if (idx == -1) {
            Assert.fail((String)("Log did not contain endmarker'" + endMarker + "' expected '" + expectedString + "' not found."));
        }
        String x = r.substring(idx);
        N4CliHelper.assertExpectedOutputContains(expectedString, x);
    }

    public static void assertExpectedOutputContains(String expectedString, String x) {
        if (!x.contains(expectedString)) {
            Assert.fail((String)("expected '" + expectedString + "' not found in '" + x + "'"));
        }
    }

    public static void assertExpectedOutputNotContains(String expectedString, String x) {
        if (x.contains(expectedString)) {
            Assert.fail((String)("expected '" + expectedString + "' found in '" + x + "'"));
        }
    }

    public static void assertExpectedOutputEndsWith(String expectedString, String x) {
        int beginIndex = x.length() - expectedString.length();
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        String gotThisOutput = x.substring(beginIndex);
        Assert.assertEquals((String)"Output differs", (Object)expectedString, (Object)gotThisOutput);
    }

    public static String readLogfile(File log) {
        LinkedHashSet<Charset> charsets = new LinkedHashSet<Charset>();
        charsets.add(Charset.defaultCharset());
        if (N4CliHelper.isWindows()) {
            charsets.add(Charset.forName("CP1252"));
            charsets.add(Charset.forName("CP437"));
        }
        charsets.add(StandardCharsets.UTF_8);
        charsets.add(StandardCharsets.UTF_16);
        for (Charset currCharset : charsets) {
            try {
                return N4CliHelper.readLogfile(log, currCharset);
            }
            catch (Throwable th) {
                System.err.println(th.getMessage());
            }
        }
        Assert.fail((String)("Cannot read log-file with any of the following charsets: " + Joiner.on((String)", ").join(charsets)));
        return null;
    }

    public static String readLogfile(File log, Charset charset) {
        try {
            System.out.println("Trying to load log file \"" + log + "\" with charset \"" + charset.name() + "\" ...");
            String result = Joiner.on((String)"\n").join(Files.readAllLines(log.toPath(), charset));
            System.out.println("... done.");
            return result;
        }
        catch (IOException e) {
            System.out.println("... failed:");
            e.printStackTrace();
            Assert.fail((String)("Problems reading log-file \"" + log + "\" with charset \"" + charset.name() + "\": " + e));
            return null;
        }
    }

    public static void assertContainsString(String toFind, File log) {
        Assert.assertNotEquals((String)("expected string '" + toFind + "' not found in log"), (long)-1L, (long)N4CliHelper.readLogfile(log).indexOf(toFind));
    }

    public static void assertNotContainsString(String toFind, File log) {
        MatcherAssert.assertThat((String)("unexpected string '" + toFind + "' found in log"), (N4CliHelper.readLogfile(log).indexOf(toFind) < 0 ? 1 : 0) != 0);
    }

    public static boolean isWindows() {
        return OS_NAME.indexOf("win") >= 0;
    }

    public static Process createAndStartProcessIntern(File log, String workingDir, Map<String, String> environment, String ... args) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.environment().putAll(environment);
        pb.directory(new File(workingDir));
        EnvironmentVariableUtils.inheritNodeJsPathEnvVariableUtils(pb);
        pb.redirectErrorStream(true);
        pb.redirectOutput(ProcessBuilder.Redirect.to(log));
        Process p = pb.start();
        assert (pb.redirectInput() == ProcessBuilder.Redirect.PIPE);
        assert (pb.redirectOutput().file() == log);
        assert (p.getInputStream().read() == -1);
        return p;
    }

    public static void appendExternalOutputToStdout(File outputLogFile) {
        System.out.println("===== <= Content of external Process-output below (@see: " + outputLogFile + ") => =====");
        String output = N4CliHelper.readLogfile(outputLogFile);
        System.out.println(output);
    }

    public static void setupWorkspace(Path sourceLocation, Path destinationLocation, Predicate<String> n4jsLibrariesPredicate, boolean createYarnWorkspace) throws IOException {
        Path projectLocation;
        Path path = projectLocation = createYarnWorkspace ? destinationLocation.resolve(PACKAGES) : destinationLocation;
        if (Files.exists(destinationLocation, new LinkOption[0])) {
            FileDeleter.delete((Path)destinationLocation, (boolean)true);
        }
        Files.createDirectories(destinationLocation, new FileAttribute[0]);
        Files.createDirectories(projectLocation, new FileAttribute[0]);
        FileCopier.copy((Path)sourceLocation, (Path)projectLocation, (boolean)true);
        Path libsLocation = createYarnWorkspace ? projectLocation : Files.list(projectLocation).findFirst().get().resolve("node_modules");
        N4CliHelper.copyN4jsLibsToLocation(libsLocation, n4jsLibrariesPredicate);
        if (createYarnWorkspace) {
            ArrayList packageJsonLines = Lists.newArrayList((Object[])new String[]{"{", "\t\"private\": true,", "\t\"workspaces\": [ \"packages/*\" ]", "}"});
            Files.write(destinationLocation.resolve("package.json"), (Iterable<? extends CharSequence>)packageJsonLines, new OpenOption[0]);
            Path nodeModulesFolder = destinationLocation.resolve("node_modules");
            Files.createDirectories(nodeModulesFolder, new FileAttribute[0]);
            for (Path project : Files.list(projectLocation).collect(Collectors.toList())) {
                if (!Files.isDirectory(project, new LinkOption[0])) continue;
                Files.createSymbolicLink(nodeModulesFolder.resolve(project.getFileName()), project.toAbsolutePath(), new FileAttribute[0]);
            }
        }
    }

    public static void copyN4jsLibsToLocation(Path location, String ... n4jsLibs) throws IOException {
        N4CliHelper.copyN4jsLibsToLocation(location, (Predicate<String>)((Predicate)libName -> org.eclipse.xtext.util.Arrays.contains((Object[])n4jsLibs, (Object)libName)));
    }

    public static void copyN4jsLibsToLocation(Path location, Predicate<String> n4jsLibrariesPredicate) throws IOException {
        GlobalRegistries.GlobalStateMemento originalGlobalState = null;
        if (!JSONStandaloneSetup.isSetUp()) {
            originalGlobalState = GlobalRegistries.makeCopyOfGlobalState();
            JSONStandaloneSetup.doSetup();
        }
        try {
            N4jsLibsAccess.installN4jsLibs(location, true, false, false, libName -> !N4JS_LIBS_BLACKLIST.contains(libName) && n4jsLibrariesPredicate.test(libName));
        }
        finally {
            if (originalGlobalState != null) {
                originalGlobalState.restoreGlobalState();
            }
        }
    }
}

