/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.test.helper.hlc;

import com.google.common.base.Charsets;
import com.google.common.base.Predicates;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.libs.build.BuildN4jsLibs;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.utils.UtilN4;
import org.eclipse.n4js.utils.io.FileCopier;
import org.eclipse.n4js.utils.io.FileDeleter;
import org.junit.Assert;

public class N4jsLibsAccess {
    private static final String N4JS_REPO_NAME = "n4js";
    private static final String TEST_HELPERS_NAME = "testhelpers";
    private static final String N4JS_LIBS_NAME = "n4js-libs";

    public static Path findN4jsLibsLocation() {
        Path n4jsLibsLocation;
        String searchStr;
        URI myLocation = N4jsLibsAccess.findMyLocation();
        if (myLocation == null || !myLocation.isFile()) {
            Path result = UtilN4.findN4jsRepoRootPath().resolve(N4JS_LIBS_NAME).resolve("packages").toAbsolutePath();
            N4jsLibsAccess.assertN4jsLibsAreBuilt(result);
            return result;
        }
        String myLocationStr = myLocation.toFileString();
        int idx = myLocationStr.indexOf(searchStr = String.valueOf(File.separator) + N4JS_REPO_NAME + File.separator + TEST_HELPERS_NAME + File.separator);
        if (idx < 0) {
            throw new IllegalStateException("cannot obtain location of n4js-libs: unable to find segments '..." + searchStr + "...' in location path of class " + N4jsLibsAccess.class.getSimpleName());
        }
        String repoLocationStr = myLocationStr.substring(0, idx);
        String n4jsLibsLocationStr = String.valueOf(repoLocationStr) + File.separator + N4JS_REPO_NAME + File.separator + N4JS_LIBS_NAME;
        try {
            n4jsLibsLocation = Paths.get(n4jsLibsLocationStr, new String[0]);
        }
        catch (InvalidPathException e) {
            throw new IllegalStateException("cannot obtain location of n4js-libs: invalid path", e);
        }
        Path result = n4jsLibsLocation.resolve("packages").toAbsolutePath();
        N4jsLibsAccess.assertN4jsLibsAreBuilt(result);
        return result;
    }

    public static Path findN4jsLib(String projectName) {
        Path base = N4jsLibsAccess.findN4jsLibsLocation();
        return N4jsLibsAccess.findN4jsLib(base, projectName, false);
    }

    private static Path findN4jsLib(Path n4jsLibs, String projectName, boolean searchNodeModules) {
        Path result = N4jsLibsAccess.toProjectPath(n4jsLibs, projectName);
        if (searchNodeModules && !Files.exists(result, new LinkOption[0])) {
            Path nodeModules = n4jsLibs.getParent().resolve("node_modules");
            result = N4jsLibsAccess.toProjectPath(nodeModules, projectName);
        }
        if (!Files.exists(result, new LinkOption[0])) {
            throw new IllegalArgumentException("cannot find a project among n4js-libs " + (searchNodeModules ? "or the node_modules folder of the containing yarn workspace " : "") + "with name: " + projectName);
        }
        return result;
    }

    public static Map<String, Path> findAllN4jsLibs() {
        Path location = N4jsLibsAccess.findN4jsLibsLocation();
        try {
            return Files.list(location).filter(p -> N4jsLibsAccess.isNpmPackage(p)).collect(Collectors.toMap(p -> p.getFileName().toString(), Function.identity()));
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot obtain list of n4js-libs: " + e.getMessage(), e);
        }
    }

    public static Map<String, Path> installAllN4jsLibs(Path targetPath, boolean includeDependencies, boolean useSymbolicLinks, boolean deleteOnExit) throws IOException {
        return N4jsLibsAccess.installN4jsLibs(targetPath, includeDependencies, useSymbolicLinks, deleteOnExit, (Predicate<String>)Predicates.alwaysTrue());
    }

    public static Map<String, Path> installN4jsLibs(Path targetPath, boolean includeDependencies, boolean useSymbolicLinks, boolean deleteOnExit, Predicate<String> n4jsLibsToInstall) throws IOException {
        Map<String, Path> allN4jsLibs = N4jsLibsAccess.findAllN4jsLibs();
        Map<String, Path> toBeInstalled = allN4jsLibs.entrySet().stream().filter(e -> n4jsLibsToInstall.test((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return N4jsLibsAccess.installN4jsLibs(targetPath, includeDependencies, useSymbolicLinks, deleteOnExit, toBeInstalled);
    }

    public static Map<String, Path> installN4jsLibs(Path targetPath, boolean includeDependencies, boolean useSymbolicLinks, boolean deleteOnExit, String ... n4jsLibsNames) throws IOException {
        Path n4jsLibsLocation = N4jsLibsAccess.findN4jsLibsLocation();
        HashMap<String, Path> toBeInstalled = new HashMap<String, Path>();
        String[] stringArray = n4jsLibsNames;
        int n = n4jsLibsNames.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            Path projectPath = N4jsLibsAccess.findN4jsLib(n4jsLibsLocation, projectName, false);
            toBeInstalled.put(projectName, projectPath);
            ++n2;
        }
        return N4jsLibsAccess.installN4jsLibs(targetPath, includeDependencies, useSymbolicLinks, deleteOnExit, toBeInstalled);
    }

    private static Map<String, Path> installN4jsLibs(Path targetPath, boolean includeDependencies, boolean useSymbolicLinks, boolean deleteOnExit, Map<String, Path> n4jsLibsToBeInstalled) throws IOException {
        LinkedHashMap<String, Path> toBeInstalled = new LinkedHashMap<String, Path>();
        toBeInstalled.putAll(n4jsLibsToBeInstalled);
        if (includeDependencies) {
            Path n4jsLibsLocation = N4jsLibsAccess.findN4jsLibsLocation();
            for (Path projectPath : new ArrayList(toBeInstalled.values())) {
                N4jsLibsAccess.collectDependencies(n4jsLibsLocation, projectPath, toBeInstalled);
            }
        }
        for (Map.Entry projectEntry : toBeInstalled.entrySet()) {
            String projectName = (String)projectEntry.getKey();
            Path projectPath = (Path)projectEntry.getValue();
            Path targetProjectPath = N4jsLibsAccess.toProjectPath(targetPath, projectName);
            if (useSymbolicLinks) {
                Files.createDirectories(targetPath, new FileAttribute[0]);
                Path symLinkPath = Files.createSymbolicLink(targetProjectPath, projectPath, new FileAttribute[0]);
                if (!deleteOnExit) continue;
                symLinkPath.toFile().deleteOnExit();
                continue;
            }
            Files.createDirectories(targetProjectPath, new FileAttribute[0]);
            FileCopier.copy((Path)projectPath, (Path)targetProjectPath);
            if (!deleteOnExit) continue;
            FileDeleter.deleteOnExit((Path)targetProjectPath);
        }
        return toBeInstalled;
    }

    private static void collectDependencies(Path n4jsLibsLocation, Path projectPath, Map<String, Path> addHere) throws IOException {
        Set<String> dependencyNames = N4jsLibsAccess.loadDepenencies(projectPath, false, true, true);
        for (String dependencyName : dependencyNames) {
            Path dependencyPath;
            if (addHere.putIfAbsent(dependencyName, dependencyPath = N4jsLibsAccess.findN4jsLib(n4jsLibsLocation, dependencyName, true)) != null) continue;
            N4jsLibsAccess.collectDependencies(n4jsLibsLocation, dependencyPath, addHere);
        }
    }

    private static Set<String> loadDepenencies(Path projectPath, boolean includeDevDependencies, boolean excludeNestedProjects, boolean includeDepsOfNestedProjects) throws IOException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Map<String, Path> nestedProjects = N4jsLibsAccess.getNestedProjects(projectPath);
        List<String> dependencyNames = N4jsLibsAccess.loadDepenencies(projectPath, includeDevDependencies);
        result.addAll(dependencyNames);
        if (includeDepsOfNestedProjects) {
            for (Path nestedProjectPath : nestedProjects.values()) {
                Set<String> nestedDependencyNames = N4jsLibsAccess.loadDepenencies(nestedProjectPath, false, excludeNestedProjects, includeDepsOfNestedProjects);
                result.addAll(nestedDependencyNames);
            }
        }
        if (excludeNestedProjects) {
            result.removeAll(nestedProjects.keySet());
        }
        return result;
    }

    private static List<String> loadDepenencies(Path projectPath, boolean includeDevDependencies) throws IOException {
        JSONObject devDependenciesObj;
        ArrayList<String> result = new ArrayList<String>();
        Path packageJsonPath = projectPath.resolve("package.json");
        JSONDocument packageJsonDoc = JSONModelUtils.loadJSON((Path)packageJsonPath, (Charset)Charsets.UTF_8);
        JSONObject dependenciesObj = JSONModelUtils.getProperty((JSONDocument)packageJsonDoc, (String)PackageJsonProperties.DEPENDENCIES.name).orElse(null);
        if (dependenciesObj != null) {
            result.addAll(dependenciesObj.getNameValuePairs().stream().map(nvp -> nvp.getName()).collect(Collectors.toList()));
        }
        if (includeDevDependencies && (devDependenciesObj = (JSONObject)JSONModelUtils.getProperty((JSONDocument)packageJsonDoc, (String)PackageJsonProperties.DEV_DEPENDENCIES.name).orElse(null)) != null) {
            result.addAll(devDependenciesObj.getNameValuePairs().stream().map(nvp -> nvp.getName()).collect(Collectors.toList()));
        }
        return result;
    }

    private static Map<String, Path> getNestedProjects(Path projectPath) {
        HashMap<String, Path> result = new HashMap<String, Path>();
        Path nodeModulesPath = projectPath.resolve("node_modules");
        if (Files.exists(nodeModulesPath, new LinkOption[0])) {
            File[] fileArray = nodeModulesPath.toFile().listFiles(File::isDirectory);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File childDir = fileArray[n2];
                if (childDir.getName().startsWith("@")) {
                    File[] fileArray2 = childDir.listFiles(File::isDirectory);
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File grandChildDir = fileArray2[n4];
                        if (N4jsLibsAccess.isNpmPackage(grandChildDir.toPath())) {
                            result.put(String.valueOf(childDir.getName()) + '/' + grandChildDir.getName(), grandChildDir.toPath());
                        }
                        ++n4;
                    }
                } else if (N4jsLibsAccess.isNpmPackage(childDir.toPath())) {
                    result.put(childDir.getName(), childDir.toPath());
                }
                ++n2;
            }
        }
        return result;
    }

    private static boolean isNpmPackage(Path path) {
        return !path.getFileName().toString().startsWith(".") && Files.isDirectory(path, new LinkOption[0]) && Files.isReadable(path.resolve("package.json"));
    }

    private static Path toProjectPath(Path location, String projectName) {
        String projectNameAsPath = projectName.replace('/', File.separatorChar);
        return location.resolve(projectNameAsPath);
    }

    private static URI findMyLocation() {
        URL url = N4jsLibsAccess.class.getResource(String.valueOf(N4jsLibsAccess.class.getSimpleName()) + ".class");
        return url != null ? URI.createURI((String)url.toString()) : null;
    }

    private static void assertN4jsLibsAreBuilt(Path n4jsLibsLocation) {
        Path n4jsLibsFolder = n4jsLibsLocation.getParent();
        Path nodeModulesFolder = n4jsLibsFolder.resolve("node_modules");
        Path n4jsRuntimeLink = nodeModulesFolder.resolve("n4js-runtime");
        Path n4jsRuntimeSrcGen = n4jsRuntimeLink.resolve("src-gen");
        String warning = "\n******************************************************************\nMaybe you forgot to run MWE2 workflow " + BuildN4jsLibs.class.getSimpleName() + "?\n" + "******************************************************************";
        Assert.assertTrue((String)("not a symbolic link pointing to package \"n4js-runtime\": " + n4jsRuntimeLink + warning), (boolean)Files.isSymbolicLink(n4jsRuntimeLink));
        Assert.assertTrue((String)("src-gen folder in n4js-runtime does not exist: " + n4jsRuntimeSrcGen + warning), (boolean)Files.isDirectory(n4jsRuntimeSrcGen, new LinkOption[0]));
    }
}

