/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.es.assistants.BlockAssistant;

/**
 * Transforms ES2015 arrow functions to an ES5 equivalent, using ordinary function expressions.
 */
@TransformationDependency.Optional(GeneratorOption.ArrowFunctions)
@SuppressWarnings("all")
public class ArrowFunction_Part1_Transformation extends Transformation {
  @Inject
  private BlockAssistant blockAssistant;
  
  @Override
  public void analyze() {
  }
  
  @Override
  public void assertPreConditions() {
    this.blockAssistant.assertArrowFunctionConditions();
  }
  
  @Override
  public void assertPostConditions() {
  }
  
  @Override
  public void transform() {
    final Consumer<ArrowFunction> _function = (ArrowFunction it) -> {
      this.transformArrowFunction(it);
    };
    this.<ArrowFunction>collectNodes(this.getState().im, ArrowFunction.class, true).forEach(_function);
  }
  
  /**
   * turn implicit returns into explicit ones.
   */
  private void transformArrowFunction(final ArrowFunction arrowFunc) {
    boolean _isSingleExprImplicitReturn = arrowFunc.isSingleExprImplicitReturn();
    if (_isSingleExprImplicitReturn) {
      boolean _needsReturnInsertionForBody = this.blockAssistant.needsReturnInsertionForBody(arrowFunc);
      if (_needsReturnInsertionForBody) {
        Statement _get = arrowFunc.getBody().getStatements().get(0);
        ExpressionStatement exprToWrap = ((ExpressionStatement) _get);
        this.replace(exprToWrap, TranspilerBuilderBlocks._ReturnStmnt(exprToWrap.getExpression()));
      }
    }
  }
}
