/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.building;

import com.google.inject.Inject;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.n4js.generator.CompilerDescriptor;
import org.eclipse.n4js.generator.ICompositeGenerator;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

@SuppressWarnings("all")
public class N4JSOutputConfigurationProvider implements IOutputConfigurationProvider {
  @Inject
  private ICompositeGenerator compositeGenerator;
  
  /**
   * This method is called in org.eclipse.xtext.generator.Delegate and in
   * org.eclipse.xtext.generator.GeneratorComponent. This methods returns the default
   * configuration. If there is something different configured in the preference
   * page these differences will be overlaid by the caller of this method.
   */
  @Override
  public Set<OutputConfiguration> getOutputConfigurations() {
    final LinkedHashSet<OutputConfiguration> outputConfigurations = CollectionLiterals.<OutputConfiguration>newLinkedHashSet();
    Set<CompilerDescriptor> _compilerDescriptors = this.compositeGenerator.getCompilerDescriptors();
    for (final CompilerDescriptor compilerDescriptor : _compilerDescriptors) {
      OutputConfiguration _outputConfiguration = compilerDescriptor.getOutputConfiguration();
      boolean _tripleNotEquals = (_outputConfiguration != null);
      if (_tripleNotEquals) {
        outputConfigurations.add(compilerDescriptor.getOutputConfiguration());
      }
    }
    return outputConfigurations;
  }
}
