/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Parts originally copied from org.eclipse.xtext.ui.editor.doubleClicking.AbstractPartitionDoubleClickSelector
 * 	in bundle  org.eclipse.xtext.ui
 * 	available under the terms of the Eclipse Public License 2.0
 * 	Copyright (c) 2011 itemis AG (http://www.itemis.eu) and others.
 * 
 * and org.eclipse.jdt.internal.ui.text.java.JavadocDoubleClickStrategy
 * 	in bundle org.eclipse.jdt.ui
 * 	available under the terms of the Eclipse Public License 2.0
 *  Copyright (c) 2000, 2011 IBM Corporation and others.
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.editor;

import com.google.common.base.Objects;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.n4js.ui.editor.syntaxcoloring.TokenTypeToPartitionMapper;
import org.eclipse.xtext.ui.editor.doubleClicking.AbstractPartitionDoubleClickSelector;
import org.eclipse.xtext.ui.editor.doubleClicking.DoubleClickStrategyProvider;
import org.eclipse.xtext.ui.editor.model.CommonBreakIterator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

/**
 * Double click strategy that is aware of template and regex partitions.
 */
@SuppressWarnings("all")
public class N4JSDoubleClickStrategyProvider extends DoubleClickStrategyProvider {
  public static class MyBreakIterator extends CommonBreakIterator {
    public static class Braces extends CommonBreakIterator.Other {
      @Override
      protected boolean isValid(final char ch) {
        return (N4JSDoubleClickStrategyProvider.is(ch, '{') || N4JSDoubleClickStrategyProvider.is(ch, '}'));
      }
    }
    
    public static class Parentheses extends CommonBreakIterator.Other {
      @Override
      protected boolean isValid(final char ch) {
        return (N4JSDoubleClickStrategyProvider.is(ch, '(') || N4JSDoubleClickStrategyProvider.is(ch, ')'));
      }
    }
    
    private final N4JSDoubleClickStrategyProvider.MyBreakIterator.Braces braces = new N4JSDoubleClickStrategyProvider.MyBreakIterator.Braces();
    
    private final N4JSDoubleClickStrategyProvider.MyBreakIterator.Parentheses parentheses = new N4JSDoubleClickStrategyProvider.MyBreakIterator.Parentheses();
    
    public MyBreakIterator() {
      super(false);
    }
    
    @Override
    protected CommonBreakIterator.Run getRun(final char ch) {
      boolean _isValid = this.braces.isValid(ch);
      if (_isValid) {
        return this.braces;
      }
      boolean _isValid_1 = this.parentheses.isValid(ch);
      if (_isValid_1) {
        return this.parentheses;
      }
      return super.getRun(ch);
    }
  }
  
  @Override
  public ITextDoubleClickStrategy getStrategy(final ISourceViewer sourceViewer, final String contentType, final String documentPartitioning) {
    boolean _equals = Objects.equal(TokenTypeToPartitionMapper.REG_EX_PARTITION, contentType);
    if (_equals) {
      return new AbstractPartitionDoubleClickSelector(documentPartitioning) {
        @Override
        protected IRegion findExtendedDoubleClickSelection(@Extension final IDocument document, final int offset) {
          try {
            final ITypedRegion region = TextUtilities.getPartition(document, documentPartitioning, offset, true);
            boolean doSelect = false;
            int trimRight = 0;
            if (((offset == (region.getOffset() + 1)) || (offset >= ((region.getOffset() + region.getLength()) - 2)))) {
              int _offset = region.getOffset();
              int _plus = (_offset + 1);
              boolean _tripleEquals = (offset == _plus);
              doSelect = _tripleEquals;
              String textInRegion = document.get(region.getOffset(), region.getLength());
              int lastSlash = N4JSDoubleClickStrategyProvider.this.last(textInRegion, '/');
              if ((lastSlash != 0)) {
                doSelect = (doSelect || (offset == ((region.getOffset() + lastSlash) - 1)));
                int _length = region.getLength();
                int _minus = (_length - lastSlash);
                trimRight = _minus;
              }
            }
            if (doSelect) {
              final int trimLeft = 1;
              int _offset_1 = region.getOffset();
              int _plus_1 = (_offset_1 + trimLeft);
              int _length_1 = region.getLength();
              int _minus_1 = (_length_1 - trimLeft);
              int _minus_2 = (_minus_1 - trimRight);
              return new Region(_plus_1, _minus_2);
            }
          } catch (final Throwable _t) {
            if (_t instanceof BadLocationException) {
              return null;
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
          return null;
        }
      };
    }
    boolean _equals_1 = Objects.equal(TokenTypeToPartitionMapper.TEMPLATE_LITERAL_PARTITION, contentType);
    if (_equals_1) {
      return new AbstractPartitionDoubleClickSelector(documentPartitioning) {
        @Override
        protected IRegion findExtendedDoubleClickSelection(@Extension final IDocument document, final int offset) {
          try {
            final ITypedRegion region = TextUtilities.getPartition(document, documentPartitioning, offset, true);
            int _offset = region.getOffset();
            int _plus = (_offset + 1);
            boolean doSelect = (offset == _plus);
            int trimRight = 0;
            int _offset_1 = region.getOffset();
            int _length = region.getLength();
            int _plus_1 = (_offset_1 + _length);
            final int endOffset = (_plus_1 - 1);
            final char lastChar = document.getChar(endOffset);
            boolean _is = N4JSDoubleClickStrategyProvider.is(lastChar, '`');
            if (_is) {
              doSelect = (doSelect || (offset == endOffset));
              trimRight = 1;
            } else {
              if ((N4JSDoubleClickStrategyProvider.is(lastChar, '{') && N4JSDoubleClickStrategyProvider.is(document.getChar((endOffset - 1)), '$'))) {
                doSelect = (doSelect || (offset == (endOffset - 1)));
                trimRight = 2;
              }
            }
            if (doSelect) {
              int trimLeft = 1;
              int _offset_2 = region.getOffset();
              int _plus_2 = (_offset_2 + trimLeft);
              int _length_1 = region.getLength();
              int _minus = (_length_1 - trimLeft);
              int _minus_1 = (_minus - trimRight);
              return new Region(_plus_2, _minus_1);
            }
          } catch (final Throwable _t) {
            if (_t instanceof BadLocationException) {
              return null;
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
          return null;
        }
      };
    }
    boolean _equals_2 = Objects.equal(TokenTypeToPartitionMapper.JS_DOC_PARTITION, contentType);
    if (_equals_2) {
      return new AbstractPartitionDoubleClickSelector(documentPartitioning) {
        /**
         * Copied from Xtend's Javadoc comment handling.
         * Allows to select the complete <code>@param</code> instead of just the literal <code>param</code>.
         * Copied from org.eclipse.jdt.internal.ui.text.java.JavadocDoubleClickStrategy.
         */
        @Override
        protected IRegion findExtendedDoubleClickSelection(@Extension final IDocument document, final int position) {
          try {
            IRegion match = super.findExtendedDoubleClickSelection(document, position);
            if ((match != null)) {
              return match;
            }
            final IRegion word = this.findWord(document, position);
            final IRegion line = document.getLineInformationOfOffset(position);
            int _offset = line.getOffset();
            int _length = line.getLength();
            int _plus = (_offset + _length);
            boolean _tripleEquals = (position == _plus);
            if (_tripleEquals) {
              return null;
            }
            int start = word.getOffset();
            int _length_1 = word.getLength();
            final int end = (start + _length_1);
            if (((((start > 0) && N4JSDoubleClickStrategyProvider.is(document.getChar((start - 1)), '@')) && Character.isJavaIdentifierPart(document.getChar(start))) && 
              (((start == 1) || Character.isWhitespace(document.getChar((start - 2)))) || N4JSDoubleClickStrategyProvider.is(document.getChar((start - 2)), '{')))) {
              start--;
            } else {
              if (((((end == position) && (end == (start + 1))) && (end < (line.getOffset() + line.getLength()))) && 
                N4JSDoubleClickStrategyProvider.is(document.getChar(end), '@'))) {
                return this.findExtendedDoubleClickSelection(document, (position + 1));
              }
            }
            if ((start == end)) {
              return null;
            }
            return new Region(start, (end - start));
          } catch (final Throwable _t) {
            if (_t instanceof BadLocationException) {
              return null;
            } else {
              throw Exceptions.sneakyThrow(_t);
            }
          }
        }
        
        @Override
        protected CommonBreakIterator createBreakIterator() {
          return new N4JSDoubleClickStrategyProvider.MyBreakIterator();
        }
      };
    }
    return super.getStrategy(sourceViewer, contentType, documentPartitioning);
  }
  
  public static boolean is(final char a, final char b) {
    return (a == b);
  }
  
  public int last(final String s, final char b) {
    return s.lastIndexOf(b);
  }
}
