/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.projectDescription.ModuleFilter;
import org.eclipse.n4js.projectDescription.ModuleFilterType;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.URIUtils;
import org.eclipse.n4js.utils.io.FileUtils;

public class N4JSProject
implements IN4JSProject {
    private final N4JSModel model;
    private final URI location;
    private Boolean exists;
    private final boolean external;

    protected N4JSProject(URI location, boolean external, N4JSModel model) {
        this.location = location;
        this.external = external;
        this.model = model;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof N4JSProject) {
            N4JSProject otherP = (N4JSProject)obj;
            if (this.external != otherP.external) {
                return false;
            }
            if (this.external && otherP.external) {
                return this.location == otherP.location;
            }
            return URIUtils.equals((URI)this.location, (URI)otherP.location);
        }
        return false;
    }

    public int hashCode() {
        return URIUtils.hashCode((URI)this.getLocation());
    }

    protected N4JSModel getModel() {
        return this.model;
    }

    @Override
    public boolean exists() {
        if (this.exists != null) {
            return this.exists;
        }
        this.exists = this.checkExists();
        return this.exists;
    }

    @Override
    public Optional<URI> getProjectDescriptionLocation() {
        File projectDescriptionFile = (File)N4JSProject.getProjectDescriptionFile(this.location).orNull();
        if (projectDescriptionFile == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)this.getFileUri(projectDescriptionFile));
    }

    protected URI getFileUri(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            File canonicalFile = file.getCanonicalFile();
            return URI.createFileURI((String)canonicalFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Error while resolving the canonical File of package.json file " + file.getPath() + ".", e);
        }
    }

    protected boolean checkExists() {
        return N4JSProject.getProjectDescriptionFile(this.location).isPresent();
    }

    @Override
    public ImmutableList<? extends IN4JSProject> getDependencies() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.model.getDependencies(this, false);
    }

    @Override
    public ImmutableList<? extends IN4JSProject> getDependenciesAndImplementedApis() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.model.getDependenciesAndImplementedApis(this, false);
    }

    @Override
    public Optional<String> getImplementationId() {
        if (!this.exists()) {
            return Optional.absent();
        }
        ProjectDescription pd = this.model.getProjectDescription(this.getLocation());
        if (pd == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)pd.getImplementationId());
    }

    @Override
    public ImmutableList<? extends IN4JSProject> getImplementedProjects() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.model.getImplementedProjects(this);
    }

    @Override
    public ImmutableList<? extends IN4JSProject> getAllDirectDependencies() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        result.addAll(this.getDependencies());
        return result.build();
    }

    @Override
    public ImmutableList<? extends IN4JSProject> getProvidedRuntimeLibraries() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.model.getProvidedRuntimeLibraries(this);
    }

    @Override
    public String getProjectName() {
        return ProjectDescriptionUtils.deriveN4JSProjectNameFromURI(this.location);
    }

    @Override
    public String getVendorID() {
        if (!this.exists()) {
            return null;
        }
        ProjectDescription pd = this.model.getProjectDescription(this.getLocation());
        if (pd == null) {
            return null;
        }
        return pd.getVendorId();
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    @Override
    public Path getLocationPath() {
        String pathStr = this.location.toFileString();
        return pathStr != null ? Paths.get(pathStr, new String[0]) : null;
    }

    @Override
    public ImmutableList<? extends IN4JSSourceContainer> getSourceContainers() {
        if (!this.exists()) {
            return ImmutableList.of();
        }
        return this.model.getN4JSSourceContainers(this);
    }

    @Override
    public VersionNumber getVersion() {
        if (!this.exists()) {
            return null;
        }
        ProjectDescription pd = this.model.getProjectDescription(this.getLocation());
        if (pd == null) {
            return null;
        }
        return pd.getProjectVersion();
    }

    @Override
    public String getOutputPath() {
        if (!this.exists()) {
            return null;
        }
        ProjectDescription pd = this.model.getProjectDescription(this.getLocation());
        if (pd == null) {
            return null;
        }
        return FileUtils.normalizeToDotWhenEmpty((String)pd.getOutputPath());
    }

    @Override
    public ModuleFilter getModuleValidationFilter() {
        return this.getModuleFilterByType(ModuleFilterType.NO_VALIDATE);
    }

    private ModuleFilter getModuleFilterByType(ModuleFilterType type) {
        for (ModuleFilter moduleFilter : this.getModuleFilters()) {
            if (moduleFilter.getModuleFilterType() != type) continue;
            return moduleFilter;
        }
        return null;
    }

    private List<ModuleFilter> getModuleFilters() {
        ProjectDescription pd = this.model.getProjectDescription(this.getLocation());
        if (pd == null) {
            return Collections.emptyList();
        }
        return pd.getModuleFilters();
    }

    @Override
    public ProjectType getProjectType() {
        if (!this.exists()) {
            return null;
        }
        ProjectDescription pd = this.model.getProjectDescription(this.getLocation());
        if (pd == null) {
            return null;
        }
        return pd.getProjectType();
    }

    @Override
    public String getMainModule() {
        if (!this.exists()) {
            return null;
        }
        ProjectDescription pd = this.model.getProjectDescription(this.getLocation());
        if (pd == null) {
            return null;
        }
        return pd.getMainModule();
    }

    @Override
    public Optional<String> getExtendedRuntimeEnvironmentId() {
        return Optional.fromNullable((Object)((String)this.model.getExtendedRuntimeEnvironmentName(this.location).orNull()));
    }

    @Override
    public Optional<IN4JSProject> getExtendedRuntimeEnvironment() {
        return Optional.fromNullable((Object)((IN4JSProject)this.model.getExtendedRuntimeEnvironment(this).orNull()));
    }

    @Override
    public Collection<IN4JSProject> getTestedProjects() {
        if (!this.exists()) {
            return Collections.emptyList();
        }
        return this.model.getTestedProjects(this);
    }

    public String toString() {
        String str = this.getProjectName();
        str = String.valueOf(str) + " (" + (this.exists() ? this.getProjectType() : "doesn't exist") + ")";
        return str;
    }

    @Override
    public boolean isExternal() {
        return this.external;
    }

    public static boolean isN4JSProjectDirectory(URI location) {
        return N4JSProject.getProjectDescriptionFile(location).isPresent();
    }

    private static Optional<File> getProjectDescriptionFile(URI projectLocation) {
        File locationAsFile = new File(projectLocation.toFileString());
        if (locationAsFile.isDirectory()) {
            File packageJSON = new File(locationAsFile, "package.json");
            if (packageJSON.isFile()) {
                return Optional.fromNullable((Object)packageJSON);
            }
            File packageJSONXpect = new File(locationAsFile, "package.json.xt");
            if (packageJSONXpect.isFile()) {
                return Optional.fromNullable((Object)packageJSONXpect);
            }
        }
        return Optional.absent();
    }

    @Override
    public boolean hasN4JSNature() {
        if (!this.exists()) {
            return false;
        }
        ProjectDescription pd = this.model.getProjectDescription(this.getLocation());
        if (pd == null) {
            return false;
        }
        return pd.isHasN4JSNature();
    }

    @Override
    public String getDefinesPackageName() {
        return this.getModel().getDefinesPackage(this);
    }
}

