/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.MethodDeclaration;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.TypeDefiningElement;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.naming.ModuleNameComputer;
import org.eclipse.n4js.naming.SpecifierConverter;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.typesbuilder.N4JSClassDeclarationTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSEnumDeclarationTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSFunctionDefinitionTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSInterfaceDeclarationTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSNamespaceImportTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSObjectLiteralTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.n4js.typesbuilder.N4JSTypesFromTypeRefBuilder;
import org.eclipse.n4js.typesbuilder.N4JSVariableStatementTypesBuilder;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class N4JSTypesBuilder {
    @Inject(optional=true)
    private TypesFactory typesFactory = TypesFactory.eINSTANCE;
    @Inject
    @Extension
    private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;
    @Inject
    @Extension
    private N4JSClassDeclarationTypesBuilder _n4JSClassDeclarationTypesBuilder;
    @Inject
    @Extension
    private N4JSInterfaceDeclarationTypesBuilder _n4JSInterfaceDeclarationTypesBuilder;
    @Inject
    @Extension
    private N4JSEnumDeclarationTypesBuilder _n4JSEnumDeclarationTypesBuilder;
    @Inject
    @Extension
    private N4JSObjectLiteralTypesBuilder _n4JSObjectLiteralTypesBuilder;
    @Inject
    @Extension
    private N4JSFunctionDefinitionTypesBuilder _n4JSFunctionDefinitionTypesBuilder;
    @Inject
    @Extension
    private N4JSVariableStatementTypesBuilder _n4JSVariableStatementTypesBuilder;
    @Inject
    @Extension
    private N4JSTypesFromTypeRefBuilder _n4JSTypesFromTypeRefBuilder;
    @Inject
    @Extension
    private N4JSNamespaceImportTypesBuilder _n4JSNamespaceImportTypesBuilder;
    @Inject
    @Extension
    private ModuleNameComputer _moduleNameComputer;
    @Inject
    private IN4JSCore n4jscore;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private SpecifierConverter specifierConverter;
    @Inject
    protected JavaScriptVariantHelper jsVariantHelper;

    public void relinkTModuleToSource(DerivedStateAwareResource resource, boolean preLinkingPhase) {
        TModule module;
        Script script;
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            String _astMD5;
            boolean _notEquals;
            EObject _rootASTElement = parseResult.getRootASTElement();
            script = (Script)_rootASTElement;
            EObject _get = (EObject)resource.getContents().get(1);
            module = (TModule)_get;
            String astMD5New = N4JSASTUtils.md5Hex((XtextResource)resource);
            boolean bl = _notEquals = !Objects.equal((Object)astMD5New, (Object)(_astMD5 = module.getAstMD5()));
            if (_notEquals) {
                URI _uRI = resource.getURI();
                String _plus = "cannot link existing TModule to new AST due to hash mismatch: " + _uRI;
                throw new IllegalStateException(_plus);
            }
        } else {
            URI _uRI_1 = resource.getURI();
            String _plus_1 = "resource has no parse result: " + _uRI_1;
            throw new IllegalStateException(_plus_1);
        }
        module.setReconciled(true);
        this._n4JSNamespaceImportTypesBuilder.relinkNamespaceTypes(script, module, preLinkingPhase);
        this.buildTypesFromTypeRefs(script, module, preLinkingPhase);
        this.relinkTypes(script, module, preLinkingPhase);
        module.setAstElement((EObject)script);
        script.setModule(module);
    }

    public void createTModuleFromSource(DerivedStateAwareResource resource, boolean preLinkingPhase) {
        TModule result;
        Script script;
        IParseResult parseResult = resource.getParseResult();
        if (parseResult != null) {
            EObject _rootASTElement = parseResult.getRootASTElement();
            script = (Script)_rootASTElement;
            result = this.typesFactory.createTModule();
            result.setAstMD5(N4JSASTUtils.md5Hex((XtextResource)resource));
            result.setReconciled(false);
            QualifiedName qualifiedModuleName = this._moduleNameComputer.getQualifiedModuleName((Resource)resource);
            result.setQualifiedName(this.qualifiedNameConverter.toString(qualifiedModuleName));
            result.setPreLinkingPhase(preLinkingPhase);
            Optional<? extends IN4JSProject> optionalProject = this.n4jscore.findProject(resource.getURI());
            boolean _isPresent = optionalProject.isPresent();
            if (_isPresent) {
                IN4JSProject project = (IN4JSProject)optionalProject.get();
                result.setProjectName(project.getProjectName());
                result.setVendorID(project.getVendorID());
                String mainModuleSpec = project.getMainModule();
                if (mainModuleSpec != null) {
                    QualifiedName _qualifiedModuleName = this._moduleNameComputer.getQualifiedModuleName((Resource)resource);
                    QualifiedName _qualifiedName = this.specifierConverter.toQualifiedName(mainModuleSpec);
                    boolean _equals = Objects.equal((Object)_qualifiedModuleName, (Object)_qualifiedName);
                    result.setMainModule(_equals);
                }
            }
        } else {
            URI _uRI = resource.getURI();
            String _plus = _uRI + " has no parse result.";
            throw new IllegalStateException(_plus);
        }
        this._n4JSTypesBuilderHelper.copyAnnotations((TAnnotableElement)result, (AnnotableElement)script, preLinkingPhase);
        this.buildNamespaceTypesFromModuleImports(script, result, preLinkingPhase);
        result.setN4jsdModule(this.jsVariantHelper.isExternalMode((EObject)script));
        result.setStaticPolyfillModule(N4JSLanguageUtils.isContainedInStaticPolyfillModule((TAnnotableElement)result));
        result.setStaticPolyfillAware(N4JSLanguageUtils.isContainedInStaticPolyfillAware((TAnnotableElement)result));
        this.buildTypesFromTypeRefs(script, result, preLinkingPhase);
        this.buildTypes(script, result, preLinkingPhase);
        result.setAstElement((EObject)script);
        script.setModule(result);
        ((N4JSResource)resource).sneakyAddToContent((EObject)result);
    }

    private void buildNamespaceTypesFromModuleImports(Script script, TModule target, boolean preLinkingPhase) {
        if (!preLinkingPhase) {
            List _list = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)script.getScriptElements(), ImportDeclaration.class));
            for (ImportDeclaration importDeclaration : _list) {
                NamespaceImportSpecifier namespaceImport = this._n4JSNamespaceImportTypesBuilder.getNamespaceImportSpecifier(importDeclaration);
                if (namespaceImport == null) continue;
                Object _eGet = importDeclaration.eGet((EStructuralFeature)N4JSPackage.eINSTANCE.getImportDeclaration_Module(), false);
                TModule importedModule = (TModule)_eGet;
                EList _internalTypes = target.getInternalTypes();
                ModuleNamespaceVirtualType _createModuleNamespaceVirtualType = this._n4JSNamespaceImportTypesBuilder.createModuleNamespaceVirtualType(namespaceImport, importedModule);
                _internalTypes.add((Object)_createModuleNamespaceVirtualType);
            }
        }
    }

    private void buildTypesFromTypeRefs(Script script, TModule target, boolean preLinkingPhase) {
        if (!preLinkingPhase) {
            List _reverseView = ListExtensions.reverseView((List)IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)script.eAllContents(), TypeRef.class)));
            for (TypeRef tr : _reverseView) {
                boolean _matched = false;
                if (tr instanceof StructuralTypeRef) {
                    _matched = true;
                    this._n4JSTypesFromTypeRefBuilder.createStructuralType((StructuralTypeRef)tr, target);
                }
                if (_matched || !(tr instanceof FunctionTypeExpression)) continue;
                _matched = true;
                this._n4JSTypesFromTypeRefBuilder.createTFunction((FunctionTypeExpression)tr, target);
            }
        }
    }

    private void relinkTypes(Script script, TModule target, boolean preLinkingPhase) {
        int topLevelTypesIdx = 0;
        int variableIndex = 0;
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)script.eAllContents());
        for (EObject n : _iterable) {
            boolean _matched = false;
            if (n instanceof TypeDefiningElement) {
                _matched = true;
                topLevelTypesIdx = this.relinkType(n, target, preLinkingPhase, topLevelTypesIdx);
            }
            if (_matched || !(n instanceof ExportedVariableStatement)) continue;
            _matched = true;
            variableIndex = this.relinkType(n, target, preLinkingPhase, variableIndex);
        }
    }

    protected int _relinkType(TypeDefiningElement other, TModule target, boolean preLinkingPhase, int idx) {
        EClass _eClass = null;
        if (other != null) {
            _eClass = other.eClass();
        }
        String _name = _eClass.getName();
        String _plus = "unknown subclass of TypeDefiningElement: " + _name;
        throw new IllegalArgumentException(_plus);
    }

    protected int _relinkType(NamespaceImportSpecifier nsImpSpec, TModule target, boolean preLinkingPhase, int idx) {
        return idx;
    }

    protected int _relinkType(N4ClassDeclaration n4Class, TModule target, boolean preLinkingPhase, int idx) {
        boolean _relinkTClass = this._n4JSClassDeclarationTypesBuilder.relinkTClass(n4Class, target, preLinkingPhase, idx);
        if (_relinkTClass) {
            return idx + 1;
        }
        return idx;
    }

    protected int _relinkType(N4ClassExpression n4Class, TModule target, boolean preLinkingPhase, int idx) {
        this._n4JSClassDeclarationTypesBuilder.createTClass(n4Class, target, preLinkingPhase);
        return idx;
    }

    protected int _relinkType(N4InterfaceDeclaration n4Interface, TModule target, boolean preLinkingPhase, int idx) {
        boolean _relinkTInterface = this._n4JSInterfaceDeclarationTypesBuilder.relinkTInterface(n4Interface, target, preLinkingPhase, idx);
        if (_relinkTInterface) {
            return idx + 1;
        }
        return idx;
    }

    protected int _relinkType(N4EnumDeclaration n4Enum, TModule target, boolean preLinkingPhase, int idx) {
        boolean _relinkTEnum = this._n4JSEnumDeclarationTypesBuilder.relinkTEnum(n4Enum, target, preLinkingPhase, idx);
        if (_relinkTEnum) {
            return idx + 1;
        }
        return idx;
    }

    protected int _relinkType(ObjectLiteral objectLiteral, TModule target, boolean preLinkingPhase, int idx) {
        this._n4JSObjectLiteralTypesBuilder.createObjectLiteral(objectLiteral, target, preLinkingPhase);
        return idx;
    }

    protected int _relinkType(MethodDeclaration n4MethodDecl, TModule target, boolean preLinkingPhase, int idx) {
        return idx;
    }

    protected int _relinkType(FunctionDeclaration n4FunctionDecl, TModule target, boolean preLinkingPhase, int idx) {
        boolean _relinkTFunction = this._n4JSFunctionDefinitionTypesBuilder.relinkTFunction(n4FunctionDecl, target, preLinkingPhase, idx);
        if (_relinkTFunction) {
            return idx + 1;
        }
        return idx;
    }

    protected int _relinkType(FunctionExpression n4FunctionExpr, TModule target, boolean preLinkingPhase, int idx) {
        this._n4JSFunctionDefinitionTypesBuilder.createTFunction(n4FunctionExpr, target, preLinkingPhase);
        return idx;
    }

    protected int _relinkType(ExportedVariableStatement n4VariableStatement, TModule target, boolean preLinkingPhase, int idx) {
        return this._n4JSVariableStatementTypesBuilder.relinkVariableTypes((VariableStatement)n4VariableStatement, target, preLinkingPhase, idx);
    }

    private void buildTypes(Script script, TModule target, boolean preLinkingPhase) {
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)script.eAllContents());
        for (EObject n : _iterable) {
            boolean _matched = false;
            if (n instanceof TypeDefiningElement) {
                _matched = true;
                this.createType(n, target, preLinkingPhase);
            }
            if (_matched || !(n instanceof ExportedVariableStatement)) continue;
            _matched = true;
            this.createType(n, target, preLinkingPhase);
        }
    }

    protected void _createType(TypeDefiningElement other, TModule target, boolean preLinkingPhase) {
        EClass _eClass = null;
        if (other != null) {
            _eClass = other.eClass();
        }
        String _name = _eClass.getName();
        String _plus = "unknown subclass of TypeDefiningElement: " + _name;
        throw new IllegalArgumentException(_plus);
    }

    protected void _createType(NamespaceImportSpecifier nsImpSpec, TModule target, boolean preLinkingPhase) {
    }

    protected void _createType(N4ClassDeclaration n4Class, TModule target, boolean preLinkingPhase) {
        this._n4JSClassDeclarationTypesBuilder.createTClass(n4Class, target, preLinkingPhase);
    }

    protected void _createType(N4ClassExpression n4Class, TModule target, boolean preLinkingPhase) {
        this._n4JSClassDeclarationTypesBuilder.createTClass(n4Class, target, preLinkingPhase);
    }

    protected void _createType(N4InterfaceDeclaration n4Interface, TModule target, boolean preLinkingPhase) {
        this._n4JSInterfaceDeclarationTypesBuilder.createTInterface(n4Interface, target, preLinkingPhase);
    }

    protected void _createType(N4EnumDeclaration n4Enum, TModule target, boolean preLinkingPhase) {
        this._n4JSEnumDeclarationTypesBuilder.createTEnum(n4Enum, target, preLinkingPhase);
    }

    protected void _createType(ObjectLiteral objectLiteral, TModule target, boolean preLinkingPhase) {
        this._n4JSObjectLiteralTypesBuilder.createObjectLiteral(objectLiteral, target, preLinkingPhase);
    }

    protected void _createType(MethodDeclaration n4MethodDecl, TModule target, boolean preLinkingPhase) {
    }

    protected void _createType(FunctionDeclaration n4FunctionDecl, TModule target, boolean preLinkingPhase) {
        this._n4JSFunctionDefinitionTypesBuilder.createTFunction(n4FunctionDecl, target, preLinkingPhase);
    }

    protected void _createType(FunctionExpression n4FunctionExpr, TModule target, boolean preLinkingPhase) {
        this._n4JSFunctionDefinitionTypesBuilder.createTFunction(n4FunctionExpr, target, preLinkingPhase);
    }

    protected void _createType(ExportedVariableStatement n4VariableStatement, TModule target, boolean preLinkingPhase) {
        this._n4JSVariableStatementTypesBuilder.createVariableTypes((VariableStatement)n4VariableStatement, target, preLinkingPhase);
    }

    protected int relinkType(EObject n4Class, TModule target, boolean preLinkingPhase, int idx) {
        if (n4Class instanceof N4ClassDeclaration) {
            return this._relinkType((N4ClassDeclaration)n4Class, target, preLinkingPhase, idx);
        }
        if (n4Class instanceof N4ClassExpression) {
            return this._relinkType((N4ClassExpression)n4Class, target, preLinkingPhase, idx);
        }
        if (n4Class instanceof N4InterfaceDeclaration) {
            return this._relinkType((N4InterfaceDeclaration)n4Class, target, preLinkingPhase, idx);
        }
        if (n4Class instanceof N4EnumDeclaration) {
            return this._relinkType((N4EnumDeclaration)n4Class, target, preLinkingPhase, idx);
        }
        if (n4Class instanceof ExportedVariableStatement) {
            return this._relinkType((ExportedVariableStatement)n4Class, target, preLinkingPhase, idx);
        }
        if (n4Class instanceof FunctionDeclaration) {
            return this._relinkType((FunctionDeclaration)n4Class, target, preLinkingPhase, idx);
        }
        if (n4Class instanceof FunctionExpression) {
            return this._relinkType((FunctionExpression)n4Class, target, preLinkingPhase, idx);
        }
        if (n4Class instanceof MethodDeclaration) {
            return this._relinkType((MethodDeclaration)n4Class, target, preLinkingPhase, idx);
        }
        if (n4Class instanceof ObjectLiteral) {
            return this._relinkType((ObjectLiteral)n4Class, target, preLinkingPhase, idx);
        }
        if (n4Class instanceof NamespaceImportSpecifier) {
            return this._relinkType((NamespaceImportSpecifier)n4Class, target, preLinkingPhase, idx);
        }
        if (n4Class instanceof TypeDefiningElement) {
            return this._relinkType((TypeDefiningElement)n4Class, target, preLinkingPhase, idx);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(n4Class, target, preLinkingPhase, idx).toString());
    }

    protected void createType(EObject n4Class, TModule target, boolean preLinkingPhase) {
        if (n4Class instanceof N4ClassDeclaration) {
            this._createType((N4ClassDeclaration)n4Class, target, preLinkingPhase);
            return;
        }
        if (n4Class instanceof N4ClassExpression) {
            this._createType((N4ClassExpression)n4Class, target, preLinkingPhase);
            return;
        }
        if (n4Class instanceof N4InterfaceDeclaration) {
            this._createType((N4InterfaceDeclaration)n4Class, target, preLinkingPhase);
            return;
        }
        if (n4Class instanceof N4EnumDeclaration) {
            this._createType((N4EnumDeclaration)n4Class, target, preLinkingPhase);
            return;
        }
        if (n4Class instanceof ExportedVariableStatement) {
            this._createType((ExportedVariableStatement)n4Class, target, preLinkingPhase);
            return;
        }
        if (n4Class instanceof FunctionDeclaration) {
            this._createType((FunctionDeclaration)n4Class, target, preLinkingPhase);
            return;
        }
        if (n4Class instanceof FunctionExpression) {
            this._createType((FunctionExpression)n4Class, target, preLinkingPhase);
            return;
        }
        if (n4Class instanceof MethodDeclaration) {
            this._createType((MethodDeclaration)n4Class, target, preLinkingPhase);
            return;
        }
        if (n4Class instanceof ObjectLiteral) {
            this._createType((ObjectLiteral)n4Class, target, preLinkingPhase);
            return;
        }
        if (n4Class instanceof NamespaceImportSpecifier) {
            this._createType((NamespaceImportSpecifier)n4Class, target, preLinkingPhase);
            return;
        }
        if (n4Class instanceof TypeDefiningElement) {
            this._createType((TypeDefiningElement)n4Class, target, preLinkingPhase);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(n4Class, target, preLinkingPhase).toString());
    }
}

