/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.ts.scoping.N4TSQualifiedNameProvider;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.n4js.utils.ProjectResolveHelper;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;

@Singleton
public final class StaticPolyfillHelper {
    @Inject
    private ProjectResolveHelper projectResolver;
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ResourceDescriptionsProvider indexAccess;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public boolean hasStaticPolyfill(Resource resource) {
        N4JSResource res;
        if (resource instanceof N4JSResource && N4JSLanguageUtils.isContainedInStaticPolyfillAware((AnnotableElement)(res = (N4JSResource)resource).getScript())) {
            boolean strategyIndex = true;
            if (strategyIndex) {
                QualifiedName qnFilled = this.qualifiedNameConverter.toQualifiedName(res.getModule().getQualifiedName());
                IResourceDescriptions index = this.indexAccess.getResourceDescriptions(res.getResourceSet());
                Optional optQnFilling = N4TSQualifiedNameProvider.toStaticPolyfillFQN((QualifiedName)qnFilled);
                if (optQnFilling.isPresent()) {
                    QualifiedName qnFilling = (QualifiedName)optQnFilling.get();
                    Iterable modules = index.getExportedObjectsByType(TypesPackage.Literals.TMODULE);
                    for (IEObjectDescription module : modules) {
                        if (module.getQualifiedName() != qnFilling) continue;
                        return true;
                    }
                }
            } else {
                URI fillingURI = this.findStaticPolyfiller((Resource)res);
                if (fillingURI != null) {
                    return true;
                }
            }
        }
        return false;
    }

    public URI findStaticPolyfiller(Resource resource) {
        if (resource instanceof N4JSResource) {
            N4JSResource res = (N4JSResource)resource;
            if (!N4JSLanguageUtils.isContainedInStaticPolyfillAware((AnnotableElement)res.getScript())) {
                return null;
            }
            QualifiedName qnFilled = this.qualifiedNameConverter.toQualifiedName(res.getModule().getQualifiedName());
            IN4JSProject project = this.projectResolver.resolveProject(res.getURI());
            QualifiedName fqn = qnFilled;
            com.google.common.base.Optional fileExtension = com.google.common.base.Optional.of((Object)res.getURI().fileExtension());
            IN4JSSourceContainer filledSrcContainer = (IN4JSSourceContainer)this.n4jsCore.findN4JSSourceContainer(res.getURI()).get();
            for (IN4JSSourceContainer srcConti : project.getSourceContainers()) {
                URI uri;
                if (Objects.equals(filledSrcContainer, srcConti) || (uri = srcConti.findArtifact(fqn, (com.google.common.base.Optional<String>)fileExtension)) == null) continue;
                return uri;
            }
        }
        return null;
    }

    public N4JSResource getStaticPolyfillResource(Resource res) {
        URI uri = this.findStaticPolyfiller(res);
        if (uri != null) {
            return (N4JSResource)res.getResourceSet().getResource(uri, true);
        }
        return null;
    }

    public N4ClassDeclaration getStaticPolyfill(Type type) {
        return this.getStaticPolyfill(this.getStaticPolyfillResource(type.eResource()), type);
    }

    public N4ClassDeclaration getStaticPolyfill(N4JSResource fillingResource, Type type) {
        if (type instanceof TClass) {
            if (fillingResource == null) {
                return null;
            }
            Script scriptFiller = fillingResource.getScriptResolved();
            if (scriptFiller != null) {
                N4ClassDeclaration staticPolyfiller = EcoreUtil2.getAllContentsOfType((EObject)scriptFiller, N4ClassDeclaration.class).stream().filter(it -> it.getDefinedTypeAsClass().isDeclaredStaticPolyfill() && it.getSuperClassRef().getDeclaredType() == type).findFirst().orElseGet(() -> null);
                return staticPolyfiller;
            }
        }
        return null;
    }
}

