/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.generation;

import com.google.inject.Inject;
import org.eclipse.xtext.xtext.generator.XtextGeneratorNaming;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

@SuppressWarnings("all")
public class N4TSGeneratorNaming extends XtextGeneratorNaming {
  @Inject
  private IXtextProjectConfig projectConfig;
  
  @Override
  public TypeReference getEclipsePluginActivator() {
    TypeReference _xblockexpression = null;
    {
      final String pluginName = this.projectConfig.getEclipsePlugin().getName();
      TypeReference _xifexpression = null;
      if ((pluginName == null)) {
        return null;
      } else {
        _xifexpression = new TypeReference((pluginName + ".internal"), "TypesActivator");
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
