/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.chrome;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.runner.chrome.ChromeRunnerRunOptions;

public class NodeEngineCommandBuilder {
    private static final String NODE_OPTIONS = "NODE_OPTIONS";
    @Inject
    private Provider<NodeJsBinary> nodeJsBinary;

    public String[] createCmds(ChromeRunnerRunOptions runConfiguration) throws IOException {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(((NodeJsBinary)this.nodeJsBinary.get()).getBinaryAbsolutePath());
        String nodeOptions = System.getProperty(NODE_OPTIONS);
        if (nodeOptions != null) {
            String[] stringArray = nodeOptions.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String nodeOption = stringArray[n2];
                commands.add(nodeOption);
                ++n2;
            }
        }
        StringBuilder elfData = this.getELFCode(runConfiguration.getInitModules(), runConfiguration.getExecModule(), runConfiguration.getExecutionData());
        File elf = NodeEngineCommandBuilder.createTempFileFor(elfData.toString());
        commands.add(elf.getCanonicalPath());
        return commands.toArray(new String[0]);
    }

    private StringBuilder getELFCode(List<String> bootstrapModules, String entryPoint, String executionData) {
        StringBuilder elfCode = new StringBuilder();
        elfCode.append(this.generateExecutionData(executionData)).append("\n");
        elfCode.append(this.generateNativeLoad(entryPoint)).append("\n");
        return elfCode;
    }

    private String generateExecutionData(String data) {
        return "global.$executionData = " + data + ";";
    }

    private String generateNativeLoad(String moduleName) {
        return "require('" + moduleName + "');";
    }

    private static File createTempFileFor(String content) throws IOException {
        File temp = File.createTempFile("n4jsnode", "js");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(temp));){
            writer.write(content);
        }
        temp.deleteOnExit();
        return temp;
    }
}

