/**
 * Copyright (c) 2017 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.serializer;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.n4js.n4JS.AdditiveExpression;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.AnnotationList;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.ArrayBindingPattern;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrayPadding;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.AwaitExpression;
import org.eclipse.n4js.n4JS.BinaryBitwiseExpression;
import org.eclipse.n4js.n4JS.BinaryIntLiteral;
import org.eclipse.n4js.n4JS.BinaryLogicalExpression;
import org.eclipse.n4js.n4JS.BindingElement;
import org.eclipse.n4js.n4JS.BindingProperty;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.BooleanLiteral;
import org.eclipse.n4js.n4JS.BreakStatement;
import org.eclipse.n4js.n4JS.CaseClause;
import org.eclipse.n4js.n4JS.CastExpression;
import org.eclipse.n4js.n4JS.CatchBlock;
import org.eclipse.n4js.n4JS.CatchVariable;
import org.eclipse.n4js.n4JS.CommaExpression;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.ContinueStatement;
import org.eclipse.n4js.n4JS.DebuggerStatement;
import org.eclipse.n4js.n4JS.DefaultClause;
import org.eclipse.n4js.n4JS.DefaultImportSpecifier;
import org.eclipse.n4js.n4JS.DoStatement;
import org.eclipse.n4js.n4JS.DoubleLiteral;
import org.eclipse.n4js.n4JS.EmptyStatement;
import org.eclipse.n4js.n4JS.EqualityExpression;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportSpecifier;
import org.eclipse.n4js.n4JS.ExportedVariableBinding;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.ExpressionAnnotationList;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FinallyBlock;
import org.eclipse.n4js.n4JS.ForStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.HexIntLiteral;
import org.eclipse.n4js.n4JS.IdentifierRef;
import org.eclipse.n4js.n4JS.IfStatement;
import org.eclipse.n4js.n4JS.ImportCallExpression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.IndexedAccessExpression;
import org.eclipse.n4js.n4JS.IntLiteral;
import org.eclipse.n4js.n4JS.JSXElement;
import org.eclipse.n4js.n4JS.JSXElementName;
import org.eclipse.n4js.n4JS.JSXExpression;
import org.eclipse.n4js.n4JS.JSXFragment;
import org.eclipse.n4js.n4JS.JSXPropertyAttribute;
import org.eclipse.n4js.n4JS.JSXSpreadAttribute;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.LegacyOctalIntLiteral;
import org.eclipse.n4js.n4JS.LiteralAnnotationArgument;
import org.eclipse.n4js.n4JS.LiteralOrComputedPropertyName;
import org.eclipse.n4js.n4JS.MultiplicativeExpression;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberAnnotationList;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.NewExpression;
import org.eclipse.n4js.n4JS.NewTarget;
import org.eclipse.n4js.n4JS.NullLiteral;
import org.eclipse.n4js.n4JS.ObjectBindingPattern;
import org.eclipse.n4js.n4JS.ObjectLiteral;
import org.eclipse.n4js.n4JS.OctalIntLiteral;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.ParenExpression;
import org.eclipse.n4js.n4JS.PostfixExpression;
import org.eclipse.n4js.n4JS.PromisifyExpression;
import org.eclipse.n4js.n4JS.PropertyAssignmentAnnotationList;
import org.eclipse.n4js.n4JS.PropertyGetterDeclaration;
import org.eclipse.n4js.n4JS.PropertyMethodDeclaration;
import org.eclipse.n4js.n4JS.PropertyNameValuePair;
import org.eclipse.n4js.n4JS.PropertyNameValuePairSingleName;
import org.eclipse.n4js.n4JS.PropertySetterDeclaration;
import org.eclipse.n4js.n4JS.PropertySpread;
import org.eclipse.n4js.n4JS.RegularExpressionLiteral;
import org.eclipse.n4js.n4JS.RelationalExpression;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.ScientificIntLiteral;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.ShiftExpression;
import org.eclipse.n4js.n4JS.StringLiteral;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.SwitchStatement;
import org.eclipse.n4js.n4JS.TaggedTemplateString;
import org.eclipse.n4js.n4JS.TemplateLiteral;
import org.eclipse.n4js.n4JS.TemplateSegment;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.n4JS.ThrowStatement;
import org.eclipse.n4js.n4JS.TryStatement;
import org.eclipse.n4js.n4JS.TypeRefAnnotationArgument;
import org.eclipse.n4js.n4JS.UnaryExpression;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.VersionedIdentifierRef;
import org.eclipse.n4js.n4JS.WhileStatement;
import org.eclipse.n4js.n4JS.WithStatement;
import org.eclipse.n4js.n4JS.YieldExpression;
import org.eclipse.n4js.services.N4JSGrammarAccess;
import org.eclipse.n4js.ts.serializer.TypeExpressionsSemanticSequencer;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefNominal;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.VersionedParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.VersionedParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.TAnonymousFormalParameter;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TStructField;
import org.eclipse.n4js.ts.types.TStructGetter;
import org.eclipse.n4js.ts.types.TStructMethod;
import org.eclipse.n4js.ts.types.TStructSetter;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class N4JSSemanticSequencer extends TypeExpressionsSemanticSequencer {

	@Inject
	private N4JSGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == N4JSPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case N4JSPackage.ADDITIVE_EXPRESSION:
				sequence_AdditiveExpression(context, (AdditiveExpression) semanticObject); 
				return; 
			case N4JSPackage.ANNOTATION:
				sequence_AnnotationNoAtSign(context, (Annotation) semanticObject); 
				return; 
			case N4JSPackage.ANNOTATION_LIST:
				sequence_AnnotationList(context, (AnnotationList) semanticObject); 
				return; 
			case N4JSPackage.ARGUMENT:
				sequence_Argument(context, (Argument) semanticObject); 
				return; 
			case N4JSPackage.ARRAY_BINDING_PATTERN:
				sequence_ArrayBindingPattern(context, (ArrayBindingPattern) semanticObject); 
				return; 
			case N4JSPackage.ARRAY_ELEMENT:
				sequence_ArrayElement(context, (ArrayElement) semanticObject); 
				return; 
			case N4JSPackage.ARRAY_LITERAL:
				sequence_ArrayLiteral(context, (ArrayLiteral) semanticObject); 
				return; 
			case N4JSPackage.ARRAY_PADDING:
				sequence_ArrayPadding(context, (ArrayPadding) semanticObject); 
				return; 
			case N4JSPackage.ARROW_FUNCTION:
				sequence_ArrowExpression_ColonSepReturnTypeRef_StrictFormalParameters(context, (ArrowFunction) semanticObject); 
				return; 
			case N4JSPackage.ASSIGNMENT_EXPRESSION:
				sequence_AssignmentExpression(context, (AssignmentExpression) semanticObject); 
				return; 
			case N4JSPackage.AWAIT_EXPRESSION:
				sequence_AwaitExpression(context, (AwaitExpression) semanticObject); 
				return; 
			case N4JSPackage.BINARY_BITWISE_EXPRESSION:
				if (rule == grammarAccess.getBitwiseANDExpressionRule()
						|| action == grammarAccess.getBitwiseANDExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()) {
					sequence_BitwiseANDExpression(context, (BinaryBitwiseExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getBitwiseORExpressionRule()
						|| action == grammarAccess.getBitwiseORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalANDExpressionRule()
						|| action == grammarAccess.getLogicalANDExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalORExpressionRule()
						|| action == grammarAccess.getLogicalORExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getConditionalExpressionRule()
						|| action == grammarAccess.getConditionalExpressionAccess().getConditionalExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getAssignmentExpressionRule()
						|| action == grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionLhsAction_4_1_0_0_0()
						|| rule == grammarAccess.getExpressionRule()
						|| action == grammarAccess.getExpressionAccess().getCommaExpressionExprsAction_1_0()) {
					sequence_BitwiseANDExpression_BitwiseORExpression_BitwiseXORExpression(context, (BinaryBitwiseExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getBitwiseXORExpressionRule()
						|| action == grammarAccess.getBitwiseXORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()) {
					sequence_BitwiseANDExpression_BitwiseXORExpression(context, (BinaryBitwiseExpression) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.BINARY_INT_LITERAL:
				sequence_BinaryIntLiteral(context, (BinaryIntLiteral) semanticObject); 
				return; 
			case N4JSPackage.BINARY_LOGICAL_EXPRESSION:
				if (rule == grammarAccess.getLogicalANDExpressionRule()
						|| action == grammarAccess.getLogicalANDExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()) {
					sequence_LogicalANDExpression(context, (BinaryLogicalExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getLogicalORExpressionRule()
						|| action == grammarAccess.getLogicalORExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getConditionalExpressionRule()
						|| action == grammarAccess.getConditionalExpressionAccess().getConditionalExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getAssignmentExpressionRule()
						|| action == grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionLhsAction_4_1_0_0_0()
						|| rule == grammarAccess.getExpressionRule()
						|| action == grammarAccess.getExpressionAccess().getCommaExpressionExprsAction_1_0()) {
					sequence_LogicalANDExpression_LogicalORExpression(context, (BinaryLogicalExpression) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.BINDING_ELEMENT:
				if (rule == grammarAccess.getBindingElementRule()) {
					sequence_BindingElementImpl(context, (BindingElement) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getBindingRestElementRule()) {
					sequence_BindingElementImpl_BindingRestElement(context, (BindingElement) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getElisionRule()) {
					sequence_Elision(context, (BindingElement) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getSingleNameBindingRule()) {
					sequence_SingleNameBinding(context, (BindingElement) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.BINDING_PROPERTY:
				sequence_BindingProperty(context, (BindingProperty) semanticObject); 
				return; 
			case N4JSPackage.BLOCK:
				if (rule == grammarAccess.getBlockMinusBracesRule()) {
					sequence_BlockMinusBraces(context, (Block) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getScriptElementRule()
						|| rule == grammarAccess.getBlockRule()
						|| rule == grammarAccess.getRootStatementRule()
						|| rule == grammarAccess.getStatementRule()) {
					sequence_Block(context, (Block) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getExpressionDisguisedAsBlockRule()) {
					sequence_ExpressionDisguisedAsBlock(context, (Block) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.BOOLEAN_LITERAL:
				sequence_BooleanLiteral(context, (BooleanLiteral) semanticObject); 
				return; 
			case N4JSPackage.BREAK_STATEMENT:
				sequence_BreakStatement(context, (BreakStatement) semanticObject); 
				return; 
			case N4JSPackage.CASE_CLAUSE:
				sequence_CaseClause(context, (CaseClause) semanticObject); 
				return; 
			case N4JSPackage.CAST_EXPRESSION:
				sequence_CastExpression(context, (CastExpression) semanticObject); 
				return; 
			case N4JSPackage.CATCH_BLOCK:
				sequence_CatchBlock(context, (CatchBlock) semanticObject); 
				return; 
			case N4JSPackage.CATCH_VARIABLE:
				sequence_BogusTypeRefFragment_CatchVariable_ColonSepDeclaredTypeRef(context, (CatchVariable) semanticObject); 
				return; 
			case N4JSPackage.COMMA_EXPRESSION:
				sequence_Expression(context, (CommaExpression) semanticObject); 
				return; 
			case N4JSPackage.CONDITIONAL_EXPRESSION:
				sequence_ConditionalExpression(context, (ConditionalExpression) semanticObject); 
				return; 
			case N4JSPackage.CONTINUE_STATEMENT:
				sequence_ContinueStatement(context, (ContinueStatement) semanticObject); 
				return; 
			case N4JSPackage.DEBUGGER_STATEMENT:
				sequence_DebuggerStatement(context, (DebuggerStatement) semanticObject); 
				return; 
			case N4JSPackage.DEFAULT_CLAUSE:
				sequence_DefaultClause(context, (DefaultClause) semanticObject); 
				return; 
			case N4JSPackage.DEFAULT_IMPORT_SPECIFIER:
				sequence_DefaultImportSpecifier(context, (DefaultImportSpecifier) semanticObject); 
				return; 
			case N4JSPackage.DO_STATEMENT:
				sequence_DoStatement(context, (DoStatement) semanticObject); 
				return; 
			case N4JSPackage.DOUBLE_LITERAL:
				sequence_DoubleLiteral(context, (DoubleLiteral) semanticObject); 
				return; 
			case N4JSPackage.EMPTY_STATEMENT:
				sequence_EmptyStatement(context, (EmptyStatement) semanticObject); 
				return; 
			case N4JSPackage.EQUALITY_EXPRESSION:
				sequence_EqualityExpression(context, (EqualityExpression) semanticObject); 
				return; 
			case N4JSPackage.EXPORT_DECLARATION:
				if (rule == grammarAccess.getAnnotatedScriptElementRule()) {
					sequence_AnnotatedScriptElement_ExportClause_ExportDeclarationImpl_ExportFromClause(context, (ExportDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getScriptElementRule()) {
					sequence_AnnotatedScriptElement_ExportClause_ExportDeclaration_ExportDeclarationImpl_ExportFromClause(context, (ExportDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getExportDeclarationRule()) {
					sequence_ExportClause_ExportDeclaration_ExportDeclarationImpl_ExportFromClause(context, (ExportDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.EXPORT_SPECIFIER:
				sequence_ExportSpecifier(context, (ExportSpecifier) semanticObject); 
				return; 
			case N4JSPackage.EXPORTED_VARIABLE_BINDING:
				sequence_ExportedVariableBinding(context, (ExportedVariableBinding) semanticObject); 
				return; 
			case N4JSPackage.EXPORTED_VARIABLE_DECLARATION:
				sequence_ColonSepDeclaredTypeRef_ExportedVariableDeclaration_VariableDeclarationImpl(context, (ExportedVariableDeclaration) semanticObject); 
				return; 
			case N4JSPackage.EXPORTED_VARIABLE_STATEMENT:
				if (rule == grammarAccess.getAnnotatedExportableElementRule()) {
					sequence_AnnotatedExportableElement(context, (ExportedVariableStatement) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getExportableElementRule()) {
					sequence_AnnotatedExportableElement_ExportedVariableStatement(context, (ExportedVariableStatement) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getExportedVariableStatementRule()) {
					sequence_ExportedVariableStatement(context, (ExportedVariableStatement) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.EXPRESSION_ANNOTATION_LIST:
				sequence_ExpressionAnnotationList(context, (ExpressionAnnotationList) semanticObject); 
				return; 
			case N4JSPackage.EXPRESSION_STATEMENT:
				if (rule == grammarAccess.getAssignmentExpressionStatementRule()) {
					sequence_AssignmentExpressionStatement(context, (ExpressionStatement) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getScriptElementRule()
						|| rule == grammarAccess.getRootStatementRule()
						|| rule == grammarAccess.getStatementRule()
						|| rule == grammarAccess.getExpressionStatementRule()) {
					sequence_ExpressionStatement(context, (ExpressionStatement) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.FINALLY_BLOCK:
				sequence_FinallyBlock(context, (FinallyBlock) semanticObject); 
				return; 
			case N4JSPackage.FOR_STATEMENT:
				sequence_ForStatement(context, (ForStatement) semanticObject); 
				return; 
			case N4JSPackage.FORMAL_PARAMETER:
				if (rule == grammarAccess.getFormalParameterRule()) {
					sequence_BindingElementFragment_BogusTypeRefFragment_ColonSepDeclaredTypeRef_FormalParameter(context, (FormalParameter) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getBindingIdentifierAsFormalParameterRule()) {
					sequence_BindingIdentifierAsFormalParameter(context, (FormalParameter) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.FUNCTION_DECLARATION:
				if (rule == grammarAccess.getExportableElementRule()) {
					sequence_AnnotatedExportableElement_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionDeclaration_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(context, (FunctionDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotatedExportableElementRule()) {
					sequence_AnnotatedExportableElement_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(context, (FunctionDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getStatementRule()) {
					sequence_AnnotatedFunctionDeclaration_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionDeclaration_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(context, (FunctionDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotatedFunctionDeclarationRule()) {
					sequence_AnnotatedFunctionDeclaration_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(context, (FunctionDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getScriptElementRule()) {
					sequence_AnnotatedScriptElement_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionDeclaration_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(context, (FunctionDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotatedScriptElementRule()) {
					sequence_AnnotatedScriptElement_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(context, (FunctionDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getFunctionDeclarationRule()
						|| rule == grammarAccess.getRootStatementRule()) {
					sequence_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionDeclaration_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(context, (FunctionDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.FUNCTION_EXPRESSION:
				if (rule == grammarAccess.getPrimaryExpressionRule()
						|| rule == grammarAccess.getLeftHandSideExpressionRule()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()
						|| rule == grammarAccess.getMemberExpressionRule()
						|| action == grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_2_1_0_0()
						|| action == grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_2_1_1_0()
						|| action == grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_2_1_2_0()
						|| rule == grammarAccess.getPostfixExpressionRule()
						|| action == grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()
						|| rule == grammarAccess.getCastExpressionRule()
						|| action == grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getUnaryExpressionRule()
						|| rule == grammarAccess.getMultiplicativeExpressionRule()
						|| action == grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getAdditiveExpressionRule()
						|| action == grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getShiftExpressionRule()
						|| action == grammarAccess.getShiftExpressionAccess().getShiftExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getRelationalExpressionRule()
						|| action == grammarAccess.getRelationalExpressionAccess().getRelationalExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getEqualityExpressionRule()
						|| action == grammarAccess.getEqualityExpressionAccess().getEqualityExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseANDExpressionRule()
						|| action == grammarAccess.getBitwiseANDExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseXORExpressionRule()
						|| action == grammarAccess.getBitwiseXORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseORExpressionRule()
						|| action == grammarAccess.getBitwiseORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalANDExpressionRule()
						|| action == grammarAccess.getLogicalANDExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalORExpressionRule()
						|| action == grammarAccess.getLogicalORExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getConditionalExpressionRule()
						|| action == grammarAccess.getConditionalExpressionAccess().getConditionalExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getAssignmentExpressionRule()
						|| action == grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionLhsAction_4_1_0_0_0()
						|| rule == grammarAccess.getExpressionRule()
						|| action == grammarAccess.getExpressionAccess().getCommaExpressionExprsAction_1_0()) {
					sequence_AnnotatedExpression_AsyncFunctionExpression_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionExpression_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(context, (FunctionExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotatedExpressionRule()) {
					sequence_AnnotatedExpression_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(context, (FunctionExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAsyncFunctionExpressionRule()) {
					sequence_AsyncFunctionExpression_ColonSepReturnTypeRef_FunctionBody_FunctionHeader_StrictFormalParameters_TypeVariables_VersionDeclaration(context, (FunctionExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getFunctionExpressionRule()) {
					sequence_ColonSepReturnTypeRef_FunctionBody_FunctionExpression_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(context, (FunctionExpression) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.HEX_INT_LITERAL:
				sequence_HexIntLiteral(context, (HexIntLiteral) semanticObject); 
				return; 
			case N4JSPackage.IDENTIFIER_REF:
				if (rule == grammarAccess.getPrimaryExpressionRule()
						|| rule == grammarAccess.getIdentifierRefRule()
						|| rule == grammarAccess.getLeftHandSideExpressionRule()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()
						|| rule == grammarAccess.getMemberExpressionRule()
						|| action == grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_2_1_0_0()
						|| action == grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_2_1_1_0()
						|| action == grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_2_1_2_0()
						|| rule == grammarAccess.getPostfixExpressionRule()
						|| action == grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()
						|| rule == grammarAccess.getCastExpressionRule()
						|| action == grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getUnaryExpressionRule()
						|| rule == grammarAccess.getMultiplicativeExpressionRule()
						|| action == grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getAdditiveExpressionRule()
						|| action == grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getShiftExpressionRule()
						|| action == grammarAccess.getShiftExpressionAccess().getShiftExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getRelationalExpressionRule()
						|| action == grammarAccess.getRelationalExpressionAccess().getRelationalExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getEqualityExpressionRule()
						|| action == grammarAccess.getEqualityExpressionAccess().getEqualityExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseANDExpressionRule()
						|| action == grammarAccess.getBitwiseANDExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseXORExpressionRule()
						|| action == grammarAccess.getBitwiseXORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseORExpressionRule()
						|| action == grammarAccess.getBitwiseORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalANDExpressionRule()
						|| action == grammarAccess.getLogicalANDExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalORExpressionRule()
						|| action == grammarAccess.getLogicalORExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getConditionalExpressionRule()
						|| action == grammarAccess.getConditionalExpressionAccess().getConditionalExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getAssignmentExpressionRule()
						|| action == grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionLhsAction_4_1_0_0_0()
						|| rule == grammarAccess.getExpressionRule()
						|| action == grammarAccess.getExpressionAccess().getCommaExpressionExprsAction_1_0()
						|| rule == grammarAccess.getJSXElementNameExpressionRule()
						|| action == grammarAccess.getJSXElementNameExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_0()) {
					sequence_IdentifierRef(context, (IdentifierRef) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getLetIdentifierRefRule()) {
					sequence_LetIdentifierRef(context, (IdentifierRef) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.IF_STATEMENT:
				sequence_IfStatement(context, (IfStatement) semanticObject); 
				return; 
			case N4JSPackage.IMPORT_CALL_EXPRESSION:
				sequence_Arguments(context, (ImportCallExpression) semanticObject); 
				return; 
			case N4JSPackage.IMPORT_DECLARATION:
				if (rule == grammarAccess.getAnnotatedScriptElementRule()) {
					sequence_AnnotatedScriptElement_ImportClause_ImportDeclarationImpl_ImportSpecifiersExceptDefault(context, (ImportDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getScriptElementRule()) {
					sequence_AnnotatedScriptElement_ImportClause_ImportDeclaration_ImportDeclarationImpl_ImportSpecifiersExceptDefault(context, (ImportDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getImportDeclarationRule()) {
					sequence_ImportClause_ImportDeclaration_ImportDeclarationImpl_ImportSpecifiersExceptDefault(context, (ImportDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.INDEXED_ACCESS_EXPRESSION:
				if (action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_2_0_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTargetAction_1_2_1_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_2_2_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getTaggedTemplateStringTargetAction_1_2_3_0_0()) {
					sequence_IndexedAccessExpressionTail_LeftHandSideExpression_IndexedAccessExpression_1_2_1_0_ParameterizedCallExpression_1_2_0_0_ParameterizedPropertyAccessExpression_1_2_2_0_TaggedTemplateString_1_2_3_0_0(context, (IndexedAccessExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getLeftHandSideExpressionRule()
						|| rule == grammarAccess.getPostfixExpressionRule()
						|| action == grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()
						|| rule == grammarAccess.getCastExpressionRule()
						|| action == grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getUnaryExpressionRule()
						|| rule == grammarAccess.getMultiplicativeExpressionRule()
						|| action == grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getAdditiveExpressionRule()
						|| action == grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getShiftExpressionRule()
						|| action == grammarAccess.getShiftExpressionAccess().getShiftExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getRelationalExpressionRule()
						|| action == grammarAccess.getRelationalExpressionAccess().getRelationalExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getEqualityExpressionRule()
						|| action == grammarAccess.getEqualityExpressionAccess().getEqualityExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseANDExpressionRule()
						|| action == grammarAccess.getBitwiseANDExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseXORExpressionRule()
						|| action == grammarAccess.getBitwiseXORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseORExpressionRule()
						|| action == grammarAccess.getBitwiseORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalANDExpressionRule()
						|| action == grammarAccess.getLogicalANDExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalORExpressionRule()
						|| action == grammarAccess.getLogicalORExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getConditionalExpressionRule()
						|| action == grammarAccess.getConditionalExpressionAccess().getConditionalExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getAssignmentExpressionRule()
						|| action == grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionLhsAction_4_1_0_0_0()
						|| rule == grammarAccess.getExpressionRule()
						|| action == grammarAccess.getExpressionAccess().getCommaExpressionExprsAction_1_0()) {
					sequence_IndexedAccessExpressionTail_LeftHandSideExpression_MemberExpression(context, (IndexedAccessExpression) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()
						|| rule == grammarAccess.getMemberExpressionRule()) {
					sequence_IndexedAccessExpressionTail_MemberExpression(context, (IndexedAccessExpression) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_1_3_3_0_0()
						|| action == grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_3_3_1_0()
						|| action == grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_1_3_3_2_0()) {
					sequence_IndexedAccessExpressionTail_MemberExpression_IndexedAccessExpression_1_3_3_0_0_ParameterizedPropertyAccessExpression_1_3_3_1_0_TaggedTemplateString_1_3_3_2_0(context, (IndexedAccessExpression) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_2_1_0_0()
						|| action == grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_2_1_1_0()
						|| action == grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_2_1_2_0()) {
					sequence_IndexedAccessExpressionTail_MemberExpression_IndexedAccessExpression_2_1_0_0_ParameterizedPropertyAccessExpression_2_1_1_0_TaggedTemplateString_2_1_2_0(context, (IndexedAccessExpression) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.INT_LITERAL:
				sequence_IntLiteral(context, (IntLiteral) semanticObject); 
				return; 
			case N4JSPackage.JSX_ELEMENT:
				sequence_JSXAttributes_JSXElement(context, (JSXElement) semanticObject); 
				return; 
			case N4JSPackage.JSX_ELEMENT_NAME:
				sequence_JSXElementName(context, (JSXElementName) semanticObject); 
				return; 
			case N4JSPackage.JSX_EXPRESSION:
				sequence_JSXExpression(context, (JSXExpression) semanticObject); 
				return; 
			case N4JSPackage.JSX_FRAGMENT:
				sequence_JSXFragment(context, (JSXFragment) semanticObject); 
				return; 
			case N4JSPackage.JSX_PROPERTY_ATTRIBUTE:
				sequence_JSXPropertyAttribute(context, (JSXPropertyAttribute) semanticObject); 
				return; 
			case N4JSPackage.JSX_SPREAD_ATTRIBUTE:
				sequence_JSXSpreadAttribute(context, (JSXSpreadAttribute) semanticObject); 
				return; 
			case N4JSPackage.LABELLED_STATEMENT:
				sequence_LabelledStatement(context, (LabelledStatement) semanticObject); 
				return; 
			case N4JSPackage.LEGACY_OCTAL_INT_LITERAL:
				sequence_LegacyOctalIntLiteral(context, (LegacyOctalIntLiteral) semanticObject); 
				return; 
			case N4JSPackage.LITERAL_ANNOTATION_ARGUMENT:
				sequence_LiteralAnnotationArgument(context, (LiteralAnnotationArgument) semanticObject); 
				return; 
			case N4JSPackage.LITERAL_OR_COMPUTED_PROPERTY_NAME:
				sequence_LiteralOrComputedPropertyName(context, (LiteralOrComputedPropertyName) semanticObject); 
				return; 
			case N4JSPackage.MULTIPLICATIVE_EXPRESSION:
				sequence_MultiplicativeExpression(context, (MultiplicativeExpression) semanticObject); 
				return; 
			case N4JSPackage.N4_CLASS_DECLARATION:
				if (rule == grammarAccess.getExportableElementRule()) {
					sequence_AnnotatedExportableElement_ClassExtendsClause_ClassImplementsList_Members_N4ClassDeclaration_TypeVariables_VersionDeclaration(context, (N4ClassDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotatedExportableElementRule()) {
					sequence_AnnotatedExportableElement_ClassExtendsClause_ClassImplementsList_Members_TypeVariables(context, (N4ClassDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getScriptElementRule()) {
					sequence_AnnotatedScriptElement_ClassExtendsClause_ClassImplementsList_Members_N4ClassDeclaration_TypeVariables_VersionDeclaration(context, (N4ClassDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotatedScriptElementRule()) {
					sequence_AnnotatedScriptElement_ClassExtendsClause_ClassImplementsList_Members_TypeVariables_VersionDeclaration(context, (N4ClassDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4ClassDeclarationRule()) {
					sequence_ClassExtendsClause_ClassImplementsList_Members_N4ClassDeclaration_TypeVariables_VersionDeclaration(context, (N4ClassDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.N4_CLASS_EXPRESSION:
				if (rule == grammarAccess.getAnnotatedExpressionRule()) {
					sequence_AnnotatedExpression_ClassExtendsClause_ClassImplementsList_Members(context, (N4ClassExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPrimaryExpressionRule()
						|| rule == grammarAccess.getLeftHandSideExpressionRule()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()
						|| rule == grammarAccess.getMemberExpressionRule()
						|| action == grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_2_1_0_0()
						|| action == grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_2_1_1_0()
						|| action == grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_2_1_2_0()
						|| rule == grammarAccess.getPostfixExpressionRule()
						|| action == grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()
						|| rule == grammarAccess.getCastExpressionRule()
						|| action == grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getUnaryExpressionRule()
						|| rule == grammarAccess.getMultiplicativeExpressionRule()
						|| action == grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getAdditiveExpressionRule()
						|| action == grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getShiftExpressionRule()
						|| action == grammarAccess.getShiftExpressionAccess().getShiftExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getRelationalExpressionRule()
						|| action == grammarAccess.getRelationalExpressionAccess().getRelationalExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getEqualityExpressionRule()
						|| action == grammarAccess.getEqualityExpressionAccess().getEqualityExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseANDExpressionRule()
						|| action == grammarAccess.getBitwiseANDExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseXORExpressionRule()
						|| action == grammarAccess.getBitwiseXORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseORExpressionRule()
						|| action == grammarAccess.getBitwiseORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalANDExpressionRule()
						|| action == grammarAccess.getLogicalANDExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalORExpressionRule()
						|| action == grammarAccess.getLogicalORExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getConditionalExpressionRule()
						|| action == grammarAccess.getConditionalExpressionAccess().getConditionalExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getAssignmentExpressionRule()
						|| action == grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionLhsAction_4_1_0_0_0()
						|| rule == grammarAccess.getExpressionRule()
						|| action == grammarAccess.getExpressionAccess().getCommaExpressionExprsAction_1_0()) {
					sequence_AnnotatedExpression_ClassExtendsClause_ClassImplementsList_Members_N4ClassExpression(context, (N4ClassExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4ClassExpressionRule()) {
					sequence_ClassExtendsClause_ClassImplementsList_Members_N4ClassExpression(context, (N4ClassExpression) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.N4_ENUM_DECLARATION:
				if (rule == grammarAccess.getAnnotatedExportableElementRule()) {
					sequence_AnnotatedExportableElement(context, (N4EnumDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getExportableElementRule()) {
					sequence_AnnotatedExportableElement_N4EnumDeclaration_VersionDeclaration(context, (N4EnumDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getScriptElementRule()) {
					sequence_AnnotatedScriptElement_N4EnumDeclaration_VersionDeclaration(context, (N4EnumDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotatedScriptElementRule()) {
					sequence_AnnotatedScriptElement_VersionDeclaration(context, (N4EnumDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4EnumDeclarationRule()) {
					sequence_N4EnumDeclaration_VersionDeclaration(context, (N4EnumDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.N4_ENUM_LITERAL:
				sequence_N4EnumLiteral(context, (N4EnumLiteral) semanticObject); 
				return; 
			case N4JSPackage.N4_FIELD_DECLARATION:
				if (rule == grammarAccess.getAnnotatedN4MemberDeclarationRule()) {
					sequence_AnnotatedN4MemberDeclaration_BogusTypeRefFragment_ColonSepDeclaredTypeRef_FieldDeclarationImpl(context, (N4FieldDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4MemberDeclarationRule()) {
					sequence_AnnotatedN4MemberDeclaration_BogusTypeRefFragment_ColonSepDeclaredTypeRef_FieldDeclarationImpl_N4FieldDeclaration(context, (N4FieldDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4FieldDeclarationRule()) {
					sequence_BogusTypeRefFragment_ColonSepDeclaredTypeRef_FieldDeclarationImpl_N4FieldDeclaration(context, (N4FieldDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.N4_GETTER_DECLARATION:
				if (rule == grammarAccess.getAnnotatedN4MemberDeclarationRule()) {
					sequence_AnnotatedN4MemberDeclaration_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader(context, (N4GetterDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4MemberDeclarationRule()) {
					sequence_AnnotatedN4MemberDeclaration_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader_N4GetterDeclaration(context, (N4GetterDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4GetterDeclarationRule()) {
					sequence_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader_N4GetterDeclaration(context, (N4GetterDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.N4_INTERFACE_DECLARATION:
				if (rule == grammarAccess.getExportableElementRule()) {
					sequence_AnnotatedExportableElement_InterfaceExtendsList_Members_N4InterfaceDeclaration_TypeVariables_VersionDeclaration(context, (N4InterfaceDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotatedExportableElementRule()) {
					sequence_AnnotatedExportableElement_InterfaceExtendsList_Members_TypeVariables(context, (N4InterfaceDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getScriptElementRule()) {
					sequence_AnnotatedScriptElement_InterfaceExtendsList_Members_N4InterfaceDeclaration_TypeVariables_VersionDeclaration(context, (N4InterfaceDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotatedScriptElementRule()) {
					sequence_AnnotatedScriptElement_InterfaceExtendsList_Members_TypeVariables_VersionDeclaration(context, (N4InterfaceDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4InterfaceDeclarationRule()) {
					sequence_InterfaceExtendsList_Members_N4InterfaceDeclaration_TypeVariables_VersionDeclaration(context, (N4InterfaceDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.N4_MEMBER_ANNOTATION_LIST:
				sequence_N4MemberAnnotationList(context, (N4MemberAnnotationList) semanticObject); 
				return; 
			case N4JSPackage.N4_METHOD_DECLARATION:
				if (rule == grammarAccess.getN4MemberDeclarationRule()) {
					sequence_AnnotatedN4MemberDeclaration_AsyncNoTrailingLineBreak_BogusTypeRefFragment_ColonSepReturnTypeRef_MethodParamsReturnAndBody_N4MethodDeclaration_StrictFormalParameters_TypeVariables(context, (N4MethodDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotatedN4MemberDeclarationRule()) {
					sequence_AnnotatedN4MemberDeclaration_AsyncNoTrailingLineBreak_BogusTypeRefFragment_ColonSepReturnTypeRef_MethodParamsReturnAndBody_StrictFormalParameters_TypeVariables(context, (N4MethodDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4MethodDeclarationRule()) {
					sequence_AsyncNoTrailingLineBreak_BogusTypeRefFragment_ColonSepReturnTypeRef_MethodParamsReturnAndBody_N4MethodDeclaration_StrictFormalParameters_TypeVariables(context, (N4MethodDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4CallableConstructorDeclarationRule()) {
					sequence_ColonSepReturnTypeRef_MethodParamsReturnAndBody_StrictFormalParameters(context, (N4MethodDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.N4_SETTER_DECLARATION:
				if (rule == grammarAccess.getAnnotatedN4MemberDeclarationRule()) {
					sequence_AnnotatedN4MemberDeclaration(context, (N4SetterDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4MemberDeclarationRule()) {
					sequence_AnnotatedN4MemberDeclaration_N4SetterDeclaration(context, (N4SetterDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getN4SetterDeclarationRule()) {
					sequence_N4SetterDeclaration(context, (N4SetterDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.NAMED_IMPORT_SPECIFIER:
				sequence_NamedImportSpecifier(context, (NamedImportSpecifier) semanticObject); 
				return; 
			case N4JSPackage.NAMESPACE_IMPORT_SPECIFIER:
				sequence_NamespaceImportSpecifier(context, (NamespaceImportSpecifier) semanticObject); 
				return; 
			case N4JSPackage.NEW_EXPRESSION:
				if (action == grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_1_3_3_0_0()
						|| action == grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_3_3_1_0()
						|| action == grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_1_3_3_2_0()) {
					sequence_Arguments_ConcreteTypeArguments_MemberExpression_IndexedAccessExpression_1_3_3_0_0_ParameterizedPropertyAccessExpression_1_3_3_1_0_TaggedTemplateString_1_3_3_2_0(context, (NewExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getLeftHandSideExpressionRule()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()
						|| rule == grammarAccess.getMemberExpressionRule()
						|| rule == grammarAccess.getPostfixExpressionRule()
						|| action == grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()
						|| rule == grammarAccess.getCastExpressionRule()
						|| action == grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getUnaryExpressionRule()
						|| rule == grammarAccess.getMultiplicativeExpressionRule()
						|| action == grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getAdditiveExpressionRule()
						|| action == grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getShiftExpressionRule()
						|| action == grammarAccess.getShiftExpressionAccess().getShiftExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getRelationalExpressionRule()
						|| action == grammarAccess.getRelationalExpressionAccess().getRelationalExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getEqualityExpressionRule()
						|| action == grammarAccess.getEqualityExpressionAccess().getEqualityExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseANDExpressionRule()
						|| action == grammarAccess.getBitwiseANDExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseXORExpressionRule()
						|| action == grammarAccess.getBitwiseXORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseORExpressionRule()
						|| action == grammarAccess.getBitwiseORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalANDExpressionRule()
						|| action == grammarAccess.getLogicalANDExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalORExpressionRule()
						|| action == grammarAccess.getLogicalORExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getConditionalExpressionRule()
						|| action == grammarAccess.getConditionalExpressionAccess().getConditionalExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getAssignmentExpressionRule()
						|| action == grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionLhsAction_4_1_0_0_0()
						|| rule == grammarAccess.getExpressionRule()
						|| action == grammarAccess.getExpressionAccess().getCommaExpressionExprsAction_1_0()) {
					sequence_Arguments_ConcreteTypeArguments_MemberExpression(context, (NewExpression) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.NEW_TARGET:
				sequence_MemberExpression(context, (NewTarget) semanticObject); 
				return; 
			case N4JSPackage.NULL_LITERAL:
				sequence_NullLiteral(context, (NullLiteral) semanticObject); 
				return; 
			case N4JSPackage.OBJECT_BINDING_PATTERN:
				sequence_ObjectBindingPattern(context, (ObjectBindingPattern) semanticObject); 
				return; 
			case N4JSPackage.OBJECT_LITERAL:
				sequence_ObjectLiteral(context, (ObjectLiteral) semanticObject); 
				return; 
			case N4JSPackage.OCTAL_INT_LITERAL:
				sequence_OctalIntLiteral(context, (OctalIntLiteral) semanticObject); 
				return; 
			case N4JSPackage.PARAMETERIZED_CALL_EXPRESSION:
				if (rule == grammarAccess.getLeftHandSideExpressionRule()
						|| rule == grammarAccess.getPostfixExpressionRule()
						|| action == grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()
						|| rule == grammarAccess.getCastExpressionRule()
						|| action == grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getUnaryExpressionRule()
						|| rule == grammarAccess.getMultiplicativeExpressionRule()
						|| action == grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getAdditiveExpressionRule()
						|| action == grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getShiftExpressionRule()
						|| action == grammarAccess.getShiftExpressionAccess().getShiftExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getRelationalExpressionRule()
						|| action == grammarAccess.getRelationalExpressionAccess().getRelationalExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getEqualityExpressionRule()
						|| action == grammarAccess.getEqualityExpressionAccess().getEqualityExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseANDExpressionRule()
						|| action == grammarAccess.getBitwiseANDExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseXORExpressionRule()
						|| action == grammarAccess.getBitwiseXORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseORExpressionRule()
						|| action == grammarAccess.getBitwiseORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalANDExpressionRule()
						|| action == grammarAccess.getLogicalANDExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalORExpressionRule()
						|| action == grammarAccess.getLogicalORExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getConditionalExpressionRule()
						|| action == grammarAccess.getConditionalExpressionAccess().getConditionalExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getAssignmentExpressionRule()
						|| action == grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionLhsAction_4_1_0_0_0()
						|| rule == grammarAccess.getExpressionRule()
						|| action == grammarAccess.getExpressionAccess().getCommaExpressionExprsAction_1_0()) {
					sequence_Arguments_ConcreteTypeArguments_LeftHandSideExpression_ParameterizedCallExpression(context, (ParameterizedCallExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPrimaryExpressionRule()
						|| rule == grammarAccess.getParameterizedCallExpressionRule()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()
						|| rule == grammarAccess.getMemberExpressionRule()
						|| action == grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_2_1_0_0()
						|| action == grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_2_1_1_0()
						|| action == grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_2_1_2_0()) {
					sequence_Arguments_ConcreteTypeArguments_ParameterizedCallExpression(context, (ParameterizedCallExpression) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_2_0_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTargetAction_1_2_1_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_2_2_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getTaggedTemplateStringTargetAction_1_2_3_0_0()) {
					sequence_Arguments_LeftHandSideExpression_IndexedAccessExpression_1_2_1_0_ParameterizedCallExpression_1_2_0_0_ParameterizedPropertyAccessExpression_1_2_2_0_TaggedTemplateString_1_2_3_0_0(context, (ParameterizedCallExpression) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.PARAMETERIZED_PROPERTY_ACCESS_EXPRESSION:
				if (rule == grammarAccess.getJSXElementNameExpressionRule()
						|| action == grammarAccess.getJSXElementNameExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_0()) {
					sequence_ConcreteTypeArguments_JSXElementNameExpression_ParameterizedPropertyAccessExpressionTail(context, (ParameterizedPropertyAccessExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getLeftHandSideExpressionRule()
						|| rule == grammarAccess.getPostfixExpressionRule()
						|| action == grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()
						|| rule == grammarAccess.getCastExpressionRule()
						|| action == grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getUnaryExpressionRule()
						|| rule == grammarAccess.getMultiplicativeExpressionRule()
						|| action == grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getAdditiveExpressionRule()
						|| action == grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getShiftExpressionRule()
						|| action == grammarAccess.getShiftExpressionAccess().getShiftExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getRelationalExpressionRule()
						|| action == grammarAccess.getRelationalExpressionAccess().getRelationalExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getEqualityExpressionRule()
						|| action == grammarAccess.getEqualityExpressionAccess().getEqualityExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseANDExpressionRule()
						|| action == grammarAccess.getBitwiseANDExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseXORExpressionRule()
						|| action == grammarAccess.getBitwiseXORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseORExpressionRule()
						|| action == grammarAccess.getBitwiseORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalANDExpressionRule()
						|| action == grammarAccess.getLogicalANDExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalORExpressionRule()
						|| action == grammarAccess.getLogicalORExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getConditionalExpressionRule()
						|| action == grammarAccess.getConditionalExpressionAccess().getConditionalExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getAssignmentExpressionRule()
						|| action == grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionLhsAction_4_1_0_0_0()
						|| rule == grammarAccess.getExpressionRule()
						|| action == grammarAccess.getExpressionAccess().getCommaExpressionExprsAction_1_0()) {
					sequence_ConcreteTypeArguments_LeftHandSideExpression_MemberExpression_ParameterizedPropertyAccessExpressionTail(context, (ParameterizedPropertyAccessExpression) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_2_0_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTargetAction_1_2_1_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_2_2_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getTaggedTemplateStringTargetAction_1_2_3_0_0()) {
					sequence_ConcreteTypeArguments_LeftHandSideExpression_ParameterizedPropertyAccessExpressionTail_IndexedAccessExpression_1_2_1_0_ParameterizedCallExpression_1_2_0_0_ParameterizedPropertyAccessExpression_1_2_2_0_TaggedTemplateString_1_2_3_0_0(context, (ParameterizedPropertyAccessExpression) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_1_3_3_0_0()
						|| action == grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_3_3_1_0()
						|| action == grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_1_3_3_2_0()) {
					sequence_ConcreteTypeArguments_MemberExpression_ParameterizedPropertyAccessExpressionTail_IndexedAccessExpression_1_3_3_0_0_ParameterizedPropertyAccessExpression_1_3_3_1_0_TaggedTemplateString_1_3_3_2_0(context, (ParameterizedPropertyAccessExpression) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_2_1_0_0()
						|| action == grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_2_1_1_0()
						|| action == grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_2_1_2_0()) {
					sequence_ConcreteTypeArguments_MemberExpression_ParameterizedPropertyAccessExpressionTail_IndexedAccessExpression_2_1_0_0_ParameterizedPropertyAccessExpression_2_1_1_0_TaggedTemplateString_2_1_2_0(context, (ParameterizedPropertyAccessExpression) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()
						|| rule == grammarAccess.getMemberExpressionRule()) {
					sequence_ConcreteTypeArguments_MemberExpression_ParameterizedPropertyAccessExpressionTail(context, (ParameterizedPropertyAccessExpression) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.PAREN_EXPRESSION:
				sequence_ParenExpression(context, (ParenExpression) semanticObject); 
				return; 
			case N4JSPackage.POSTFIX_EXPRESSION:
				sequence_PostfixExpression(context, (PostfixExpression) semanticObject); 
				return; 
			case N4JSPackage.PROMISIFY_EXPRESSION:
				sequence_PromisifyExpression(context, (PromisifyExpression) semanticObject); 
				return; 
			case N4JSPackage.PROPERTY_ASSIGNMENT_ANNOTATION_LIST:
				sequence_PropertyAssignmentAnnotationList(context, (PropertyAssignmentAnnotationList) semanticObject); 
				return; 
			case N4JSPackage.PROPERTY_GETTER_DECLARATION:
				if (rule == grammarAccess.getAnnotatedPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader(context, (PropertyGetterDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader_PropertyGetterDeclaration(context, (PropertyGetterDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPropertyGetterDeclarationRule()) {
					sequence_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader_PropertyGetterDeclaration(context, (PropertyGetterDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.PROPERTY_METHOD_DECLARATION:
				if (rule == grammarAccess.getPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment_MethodParamsAndBody_PropertyMethodDeclaration_StrictFormalParameters_TypeVariables(context, (PropertyMethodDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getAnnotatedPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment_MethodParamsAndBody_StrictFormalParameters_TypeVariables(context, (PropertyMethodDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPropertyMethodDeclarationRule()) {
					sequence_MethodParamsAndBody_PropertyMethodDeclaration_StrictFormalParameters_TypeVariables(context, (PropertyMethodDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.PROPERTY_NAME_VALUE_PAIR:
				if (rule == grammarAccess.getAnnotatedPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment(context, (PropertyNameValuePair) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment_PropertyNameValuePair(context, (PropertyNameValuePair) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPropertyNameValuePairRule()) {
					sequence_PropertyNameValuePair(context, (PropertyNameValuePair) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.PROPERTY_NAME_VALUE_PAIR_SINGLE_NAME:
				if (rule == grammarAccess.getAnnotatedPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment(context, (PropertyNameValuePairSingleName) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment_PropertyNameValuePairSingleName(context, (PropertyNameValuePairSingleName) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPropertyNameValuePairSingleNameRule()) {
					sequence_PropertyNameValuePairSingleName(context, (PropertyNameValuePairSingleName) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.PROPERTY_SETTER_DECLARATION:
				if (rule == grammarAccess.getAnnotatedPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment(context, (PropertySetterDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment_PropertySetterDeclaration(context, (PropertySetterDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPropertySetterDeclarationRule()) {
					sequence_PropertySetterDeclaration(context, (PropertySetterDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.PROPERTY_SPREAD:
				if (rule == grammarAccess.getAnnotatedPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment(context, (PropertySpread) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPropertyAssignmentRule()) {
					sequence_AnnotatedPropertyAssignment_PropertySpread(context, (PropertySpread) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getPropertySpreadRule()) {
					sequence_PropertySpread(context, (PropertySpread) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.REGULAR_EXPRESSION_LITERAL:
				sequence_RegularExpressionLiteral(context, (RegularExpressionLiteral) semanticObject); 
				return; 
			case N4JSPackage.RELATIONAL_EXPRESSION:
				sequence_RelationalExpression(context, (RelationalExpression) semanticObject); 
				return; 
			case N4JSPackage.RETURN_STATEMENT:
				sequence_ReturnStatement(context, (ReturnStatement) semanticObject); 
				return; 
			case N4JSPackage.SCIENTIFIC_INT_LITERAL:
				sequence_ScientificIntLiteral(context, (ScientificIntLiteral) semanticObject); 
				return; 
			case N4JSPackage.SCRIPT:
				sequence_Script(context, (Script) semanticObject); 
				return; 
			case N4JSPackage.SHIFT_EXPRESSION:
				sequence_ShiftExpression(context, (ShiftExpression) semanticObject); 
				return; 
			case N4JSPackage.STRING_LITERAL:
				sequence_StringLiteral(context, (StringLiteral) semanticObject); 
				return; 
			case N4JSPackage.SUPER_LITERAL:
				sequence_SuperLiteral(context, (SuperLiteral) semanticObject); 
				return; 
			case N4JSPackage.SWITCH_STATEMENT:
				sequence_SwitchStatement(context, (SwitchStatement) semanticObject); 
				return; 
			case N4JSPackage.TAGGED_TEMPLATE_STRING:
				if (action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_2_0_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getIndexedAccessExpressionTargetAction_1_2_1_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_2_2_0()
						|| action == grammarAccess.getLeftHandSideExpressionAccess().getTaggedTemplateStringTargetAction_1_2_3_0_0()) {
					sequence_LeftHandSideExpression_IndexedAccessExpression_1_2_1_0_ParameterizedCallExpression_1_2_0_0_ParameterizedPropertyAccessExpression_1_2_2_0_TaggedTemplateString_1_2_3_0_0(context, (TaggedTemplateString) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getLeftHandSideExpressionRule()
						|| rule == grammarAccess.getPostfixExpressionRule()
						|| action == grammarAccess.getPostfixExpressionAccess().getPostfixExpressionExpressionAction_1_0_0()
						|| rule == grammarAccess.getCastExpressionRule()
						|| action == grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getUnaryExpressionRule()
						|| rule == grammarAccess.getMultiplicativeExpressionRule()
						|| action == grammarAccess.getMultiplicativeExpressionAccess().getMultiplicativeExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getAdditiveExpressionRule()
						|| action == grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getShiftExpressionRule()
						|| action == grammarAccess.getShiftExpressionAccess().getShiftExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getRelationalExpressionRule()
						|| action == grammarAccess.getRelationalExpressionAccess().getRelationalExpressionLhsAction_1_0_0()
						|| rule == grammarAccess.getEqualityExpressionRule()
						|| action == grammarAccess.getEqualityExpressionAccess().getEqualityExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseANDExpressionRule()
						|| action == grammarAccess.getBitwiseANDExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseXORExpressionRule()
						|| action == grammarAccess.getBitwiseXORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getBitwiseORExpressionRule()
						|| action == grammarAccess.getBitwiseORExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalANDExpressionRule()
						|| action == grammarAccess.getLogicalANDExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getLogicalORExpressionRule()
						|| action == grammarAccess.getLogicalORExpressionAccess().getBinaryLogicalExpressionLhsAction_1_0_0_0()
						|| rule == grammarAccess.getConditionalExpressionRule()
						|| action == grammarAccess.getConditionalExpressionAccess().getConditionalExpressionExpressionAction_1_0_0_0()
						|| rule == grammarAccess.getAssignmentExpressionRule()
						|| action == grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionLhsAction_4_1_0_0_0()
						|| rule == grammarAccess.getExpressionRule()
						|| action == grammarAccess.getExpressionAccess().getCommaExpressionExprsAction_1_0()) {
					sequence_LeftHandSideExpression_MemberExpression(context, (TaggedTemplateString) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_1_3_3_0_0()
						|| action == grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_1_3_3_1_0()
						|| action == grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_1_3_3_2_0()) {
					sequence_MemberExpression_IndexedAccessExpression_1_3_3_0_0_ParameterizedPropertyAccessExpression_1_3_3_1_0_TaggedTemplateString_1_3_3_2_0(context, (TaggedTemplateString) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getMemberExpressionAccess().getIndexedAccessExpressionTargetAction_2_1_0_0()
						|| action == grammarAccess.getMemberExpressionAccess().getParameterizedPropertyAccessExpressionTargetAction_2_1_1_0()
						|| action == grammarAccess.getMemberExpressionAccess().getTaggedTemplateStringTargetAction_2_1_2_0()) {
					sequence_MemberExpression_IndexedAccessExpression_2_1_0_0_ParameterizedPropertyAccessExpression_2_1_1_0_TaggedTemplateString_2_1_2_0(context, (TaggedTemplateString) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getLeftHandSideExpressionAccess().getParameterizedCallExpressionTargetAction_1_0()
						|| rule == grammarAccess.getMemberExpressionRule()) {
					sequence_MemberExpression(context, (TaggedTemplateString) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.TEMPLATE_LITERAL:
				sequence_TemplateLiteral(context, (TemplateLiteral) semanticObject); 
				return; 
			case N4JSPackage.TEMPLATE_SEGMENT:
				if (rule == grammarAccess.getNoSubstitutionTemplateRule()) {
					sequence_NoSubstitutionTemplate(context, (TemplateSegment) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTemplateHeadRule()) {
					sequence_TemplateHead(context, (TemplateSegment) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTemplateMiddleRule()) {
					sequence_TemplateMiddle(context, (TemplateSegment) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTemplateTailRule()) {
					sequence_TemplateTail(context, (TemplateSegment) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.THIS_LITERAL:
				sequence_ThisLiteral(context, (ThisLiteral) semanticObject); 
				return; 
			case N4JSPackage.THROW_STATEMENT:
				sequence_ThrowStatement(context, (ThrowStatement) semanticObject); 
				return; 
			case N4JSPackage.TRY_STATEMENT:
				sequence_TryStatement(context, (TryStatement) semanticObject); 
				return; 
			case N4JSPackage.TYPE_REF_ANNOTATION_ARGUMENT:
				sequence_TypeRefAnnotationArgument(context, (TypeRefAnnotationArgument) semanticObject); 
				return; 
			case N4JSPackage.UNARY_EXPRESSION:
				sequence_UnaryExpression(context, (UnaryExpression) semanticObject); 
				return; 
			case N4JSPackage.VARIABLE_BINDING:
				if (rule == grammarAccess.getVariableDeclarationOrBindingRule() && (ImmutableSet.of(grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(0/*In*/), grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(1/*Yield*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(0/*In*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(1/*Yield*/)).equals(parameters)
				 			|| parameters.isEmpty())
						|| rule == grammarAccess.getVariableBindingRule() && (ImmutableSet.of(grammarAccess.getVariableBindingRule().getParameters().get(0/*In*/), grammarAccess.getVariableBindingRule().getParameters().get(1/*Yield*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableBindingRule().getParameters().get(0/*In*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableBindingRule().getParameters().get(1/*Yield*/)).equals(parameters)
				 			|| parameters.isEmpty())) {
					sequence_VariableBinding$OptionalInit$false$(context, (VariableBinding) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getVariableDeclarationOrBindingRule() && (ImmutableSet.of(grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(0/*In*/), grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(1/*Yield*/), grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(2/*OptionalInit*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(0/*In*/), grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(2/*OptionalInit*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(1/*Yield*/), grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(2/*OptionalInit*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableDeclarationOrBindingRule().getParameters().get(2/*OptionalInit*/)).equals(parameters))
						|| rule == grammarAccess.getVariableBindingRule() && (ImmutableSet.of(grammarAccess.getVariableBindingRule().getParameters().get(0/*In*/), grammarAccess.getVariableBindingRule().getParameters().get(1/*Yield*/), grammarAccess.getVariableBindingRule().getParameters().get(2/*OptionalInit*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableBindingRule().getParameters().get(0/*In*/), grammarAccess.getVariableBindingRule().getParameters().get(2/*OptionalInit*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableBindingRule().getParameters().get(1/*Yield*/), grammarAccess.getVariableBindingRule().getParameters().get(2/*OptionalInit*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableBindingRule().getParameters().get(2/*OptionalInit*/)).equals(parameters))) {
					sequence_VariableBinding(context, (VariableBinding) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.VARIABLE_DECLARATION:
				if (rule == grammarAccess.getBindingIdentifierAsVariableDeclarationRule()) {
					sequence_BindingIdentifierAsVariableDeclaration(context, (VariableDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getVariableDeclarationOrBindingRule()
						|| rule == grammarAccess.getVariableDeclarationRule() && (ImmutableSet.of(grammarAccess.getVariableDeclarationRule().getParameters().get(0/*In*/), grammarAccess.getVariableDeclarationRule().getParameters().get(1/*Yield*/), grammarAccess.getVariableDeclarationRule().getParameters().get(2/*AllowType*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableDeclarationRule().getParameters().get(0/*In*/), grammarAccess.getVariableDeclarationRule().getParameters().get(2/*AllowType*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableDeclarationRule().getParameters().get(1/*Yield*/), grammarAccess.getVariableDeclarationRule().getParameters().get(2/*AllowType*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableDeclarationRule().getParameters().get(2/*AllowType*/)).equals(parameters))) {
					sequence_ColonSepDeclaredTypeRef_VariableDeclaration_VariableDeclarationImpl(context, (VariableDeclaration) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getVariableDeclarationRule() && (ImmutableSet.of(grammarAccess.getVariableDeclarationRule().getParameters().get(0/*In*/), grammarAccess.getVariableDeclarationRule().getParameters().get(1/*Yield*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableDeclarationRule().getParameters().get(0/*In*/)).equals(parameters)
				 			|| ImmutableSet.of(grammarAccess.getVariableDeclarationRule().getParameters().get(1/*Yield*/)).equals(parameters)
				 			|| parameters.isEmpty())) {
					sequence_VariableDeclaration$AllowType$false$_VariableDeclarationImpl(context, (VariableDeclaration) semanticObject); 
					return; 
				}
				else break;
			case N4JSPackage.VARIABLE_STATEMENT:
				sequence_VariableStatement(context, (VariableStatement) semanticObject); 
				return; 
			case N4JSPackage.VERSIONED_IDENTIFIER_REF:
				sequence_IdentifierRef_VersionRequest(context, (VersionedIdentifierRef) semanticObject); 
				return; 
			case N4JSPackage.WHILE_STATEMENT:
				sequence_WhileStatement(context, (WhileStatement) semanticObject); 
				return; 
			case N4JSPackage.WITH_STATEMENT:
				sequence_WithStatement(context, (WithStatement) semanticObject); 
				return; 
			case N4JSPackage.YIELD_EXPRESSION:
				sequence_YieldExpression(context, (YieldExpression) semanticObject); 
				return; 
			}
		else if (epackage == TypeRefsPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case TypeRefsPackage.FUNCTION_TYPE_EXPRESSION:
				if (rule == grammarAccess.getTypeRefRule()
						|| action == grammarAccess.getTypeRefAccess().getUnionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getIntersectionTypeExpressionRule()
						|| action == grammarAccess.getIntersectionTypeExpressionAccess().getIntersectionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getArrayTypeExpressionRule()
						|| action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_2_1_0_0()
						|| rule == grammarAccess.getPrimaryTypeExpressionRule()
						|| rule == grammarAccess.getTypeArgumentRule()) {
					sequence_ArrowFunctionTypeExpression_ColonSepReturnTypeRef_FunctionTypeExpressionOLD_TAnonymousFormalParameterList_TypeRefWithModifiers(context, (FunctionTypeExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getArrowFunctionTypeExpressionRule()) {
					sequence_ArrowFunctionTypeExpression_TAnonymousFormalParameterList(context, (FunctionTypeExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithoutModifiersRule()
						|| rule == grammarAccess.getFunctionTypeExpressionOLDRule()) {
					sequence_ColonSepReturnTypeRef_FunctionTypeExpressionOLD_TAnonymousFormalParameterList(context, (FunctionTypeExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithModifiersRule()) {
					sequence_ColonSepReturnTypeRef_FunctionTypeExpressionOLD_TAnonymousFormalParameterList_TypeRefWithModifiers(context, (FunctionTypeExpression) semanticObject); 
					return; 
				}
				else break;
			case TypeRefsPackage.INTERSECTION_TYPE_EXPRESSION:
				if (rule == grammarAccess.getTypeRefWithoutModifiersRule()
						|| rule == grammarAccess.getTypeRefFunctionTypeExpressionRule()
						|| rule == grammarAccess.getIntersectionTypeExpressionOLDRule()) {
					sequence_IntersectionTypeExpressionOLD(context, (IntersectionTypeExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithModifiersRule()) {
					sequence_IntersectionTypeExpressionOLD_TypeRefWithModifiers(context, (IntersectionTypeExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefRule()
						|| action == grammarAccess.getTypeRefAccess().getUnionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getIntersectionTypeExpressionRule()
						|| action == grammarAccess.getIntersectionTypeExpressionAccess().getIntersectionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getArrayTypeExpressionRule()
						|| action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_2_1_0_0()
						|| rule == grammarAccess.getPrimaryTypeExpressionRule()
						|| rule == grammarAccess.getTypeArgumentRule()) {
					sequence_IntersectionTypeExpression_IntersectionTypeExpressionOLD_TypeRefWithModifiers(context, (IntersectionTypeExpression) semanticObject); 
					return; 
				}
				else break;
			case TypeRefsPackage.PARAMETERIZED_TYPE_REF:
				if (rule == grammarAccess.getTypeRefRule()
						|| action == grammarAccess.getTypeRefAccess().getUnionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getIntersectionTypeExpressionRule()
						|| action == grammarAccess.getIntersectionTypeExpressionAccess().getIntersectionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getArrayTypeExpressionRule()
						|| action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_2_1_0_0()
						|| rule == grammarAccess.getPrimaryTypeExpressionRule()
						|| rule == grammarAccess.getTypeArgumentRule()) {
					sequence_ArrayTypeExpression_IterableTypeExpression_TypeArguments_TypeRefWithModifiers_TypeRefWithoutModifiers_TypeReference(context, (ParameterizedTypeRef) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_0_4_0_0()) {
					sequence_ArrayTypeExpression_ParameterizedTypeRef_0_4_0_0(context, (ParameterizedTypeRef) semanticObject); 
					return; 
				}
				else if (action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_1_6_0_0()) {
					sequence_ArrayTypeExpression_ParameterizedTypeRef_1_6_0_0(context, (ParameterizedTypeRef) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getIterableTypeExpressionRule()) {
					sequence_IterableTypeExpression(context, (ParameterizedTypeRef) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefFunctionTypeExpressionRule()) {
					sequence_IterableTypeExpression_TypeArguments_TypeReference(context, (ParameterizedTypeRef) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithModifiersRule()) {
					sequence_TypeArguments_TypeRefWithModifiers_TypeRefWithoutModifiers_TypeReference(context, (ParameterizedTypeRef) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithoutModifiersRule()) {
					sequence_TypeArguments_TypeRefWithoutModifiers_TypeReference(context, (ParameterizedTypeRef) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeArgInTypeTypeRefRule()
						|| rule == grammarAccess.getParameterizedTypeRefRule()
						|| rule == grammarAccess.getParameterizedTypeRefNominalRule()) {
					sequence_TypeArguments_TypeReference(context, (ParameterizedTypeRef) semanticObject); 
					return; 
				}
				else break;
			case TypeRefsPackage.PARAMETERIZED_TYPE_REF_STRUCTURAL:
				if (rule == grammarAccess.getTypeRefRule()
						|| action == grammarAccess.getTypeRefAccess().getUnionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getIntersectionTypeExpressionRule()
						|| action == grammarAccess.getIntersectionTypeExpressionAccess().getIntersectionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getArrayTypeExpressionRule()
						|| action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_2_1_0_0()
						|| rule == grammarAccess.getPrimaryTypeExpressionRule()
						|| rule == grammarAccess.getTypeRefWithModifiersRule()
						|| rule == grammarAccess.getTypeArgumentRule()) {
					sequence_ParameterizedTypeRefStructural_TStructMemberList_TypeArguments_TypeRefWithModifiers_TypeRefWithoutModifiers_TypeReference(context, (ParameterizedTypeRefStructural) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithoutModifiersRule()) {
					sequence_ParameterizedTypeRefStructural_TStructMemberList_TypeArguments_TypeRefWithoutModifiers_TypeReference(context, (ParameterizedTypeRefStructural) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefFunctionTypeExpressionRule()
						|| rule == grammarAccess.getParameterizedTypeRefRule()
						|| rule == grammarAccess.getParameterizedTypeRefStructuralRule()) {
					sequence_ParameterizedTypeRefStructural_TStructMemberList_TypeArguments_TypeReference(context, (ParameterizedTypeRefStructural) semanticObject); 
					return; 
				}
				else break;
			case TypeRefsPackage.THIS_TYPE_REF_NOMINAL:
				if (rule == grammarAccess.getTypeArgInTypeTypeRefRule()
						|| rule == grammarAccess.getThisTypeRefRule()
						|| rule == grammarAccess.getThisTypeRefNominalRule()) {
					sequence_ThisTypeRefNominal(context, (ThisTypeRefNominal) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefRule()
						|| action == grammarAccess.getTypeRefAccess().getUnionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getIntersectionTypeExpressionRule()
						|| action == grammarAccess.getIntersectionTypeExpressionAccess().getIntersectionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getArrayTypeExpressionRule()
						|| action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_2_1_0_0()
						|| rule == grammarAccess.getPrimaryTypeExpressionRule()
						|| rule == grammarAccess.getTypeRefWithModifiersRule()
						|| rule == grammarAccess.getTypeArgumentRule()) {
					sequence_ThisTypeRefNominal_TypeRefWithModifiers_TypeRefWithoutModifiers(context, (ThisTypeRefNominal) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithoutModifiersRule()) {
					sequence_ThisTypeRefNominal_TypeRefWithoutModifiers(context, (ThisTypeRefNominal) semanticObject); 
					return; 
				}
				else break;
			case TypeRefsPackage.THIS_TYPE_REF_STRUCTURAL:
				if (rule == grammarAccess.getThisTypeRefRule()
						|| rule == grammarAccess.getThisTypeRefStructuralRule()) {
					sequence_TStructMemberList_ThisTypeRefStructural(context, (ThisTypeRefStructural) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefRule()
						|| action == grammarAccess.getTypeRefAccess().getUnionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getIntersectionTypeExpressionRule()
						|| action == grammarAccess.getIntersectionTypeExpressionAccess().getIntersectionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getArrayTypeExpressionRule()
						|| action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_2_1_0_0()
						|| rule == grammarAccess.getPrimaryTypeExpressionRule()
						|| rule == grammarAccess.getTypeRefWithModifiersRule()
						|| rule == grammarAccess.getTypeArgumentRule()) {
					sequence_TStructMemberList_ThisTypeRefStructural_TypeRefWithModifiers_TypeRefWithoutModifiers(context, (ThisTypeRefStructural) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithoutModifiersRule()) {
					sequence_TStructMemberList_ThisTypeRefStructural_TypeRefWithoutModifiers(context, (ThisTypeRefStructural) semanticObject); 
					return; 
				}
				else break;
			case TypeRefsPackage.TYPE_TYPE_REF:
				if (rule == grammarAccess.getTypeRefRule()
						|| action == grammarAccess.getTypeRefAccess().getUnionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getIntersectionTypeExpressionRule()
						|| action == grammarAccess.getIntersectionTypeExpressionAccess().getIntersectionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getArrayTypeExpressionRule()
						|| action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_2_1_0_0()
						|| rule == grammarAccess.getPrimaryTypeExpressionRule()
						|| rule == grammarAccess.getTypeRefWithModifiersRule()
						|| rule == grammarAccess.getTypeArgumentRule()) {
					sequence_TypeRefWithModifiers_TypeTypeRef(context, (TypeTypeRef) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithoutModifiersRule()
						|| rule == grammarAccess.getTypeRefFunctionTypeExpressionRule()
						|| rule == grammarAccess.getTypeTypeRefRule()) {
					sequence_TypeTypeRef(context, (TypeTypeRef) semanticObject); 
					return; 
				}
				else break;
			case TypeRefsPackage.UNION_TYPE_EXPRESSION:
				if (rule == grammarAccess.getTypeRefWithModifiersRule()) {
					sequence_TypeRefWithModifiers_UnionTypeExpressionOLD(context, (UnionTypeExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefRule()
						|| action == grammarAccess.getTypeRefAccess().getUnionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getIntersectionTypeExpressionRule()
						|| action == grammarAccess.getIntersectionTypeExpressionAccess().getIntersectionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getArrayTypeExpressionRule()
						|| action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_2_1_0_0()
						|| rule == grammarAccess.getPrimaryTypeExpressionRule()
						|| rule == grammarAccess.getTypeArgumentRule()) {
					sequence_TypeRef_TypeRefWithModifiers_UnionTypeExpressionOLD(context, (UnionTypeExpression) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithoutModifiersRule()
						|| rule == grammarAccess.getTypeRefFunctionTypeExpressionRule()
						|| rule == grammarAccess.getUnionTypeExpressionOLDRule()) {
					sequence_UnionTypeExpressionOLD(context, (UnionTypeExpression) semanticObject); 
					return; 
				}
				else break;
			case TypeRefsPackage.VERSIONED_PARAMETERIZED_TYPE_REF:
				if (rule == grammarAccess.getTypeRefRule()
						|| action == grammarAccess.getTypeRefAccess().getUnionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getIntersectionTypeExpressionRule()
						|| action == grammarAccess.getIntersectionTypeExpressionAccess().getIntersectionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getArrayTypeExpressionRule()
						|| action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_2_1_0_0()
						|| rule == grammarAccess.getPrimaryTypeExpressionRule()
						|| rule == grammarAccess.getTypeRefWithModifiersRule()
						|| rule == grammarAccess.getTypeArgumentRule()) {
					sequence_ParameterizedTypeRefNominal_TypeArguments_TypeRefWithModifiers_TypeRefWithoutModifiers_TypeReference_VersionRequest(context, (VersionedParameterizedTypeRef) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithoutModifiersRule()) {
					sequence_ParameterizedTypeRefNominal_TypeArguments_TypeRefWithoutModifiers_TypeReference_VersionRequest(context, (VersionedParameterizedTypeRef) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefFunctionTypeExpressionRule()
						|| rule == grammarAccess.getTypeArgInTypeTypeRefRule()
						|| rule == grammarAccess.getParameterizedTypeRefRule()
						|| rule == grammarAccess.getParameterizedTypeRefNominalRule()) {
					sequence_ParameterizedTypeRefNominal_TypeArguments_TypeReference_VersionRequest(context, (VersionedParameterizedTypeRef) semanticObject); 
					return; 
				}
				else break;
			case TypeRefsPackage.VERSIONED_PARAMETERIZED_TYPE_REF_STRUCTURAL:
				if (rule == grammarAccess.getTypeRefRule()
						|| action == grammarAccess.getTypeRefAccess().getUnionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getIntersectionTypeExpressionRule()
						|| action == grammarAccess.getIntersectionTypeExpressionAccess().getIntersectionTypeExpressionTypeRefsAction_1_0()
						|| rule == grammarAccess.getArrayTypeExpressionRule()
						|| action == grammarAccess.getArrayTypeExpressionAccess().getParameterizedTypeRefTypeArgsAction_2_1_0_0()
						|| rule == grammarAccess.getPrimaryTypeExpressionRule()
						|| rule == grammarAccess.getTypeRefWithModifiersRule()
						|| rule == grammarAccess.getTypeArgumentRule()) {
					sequence_ParameterizedTypeRefStructural_TStructMemberList_TypeArguments_TypeRefWithModifiers_TypeRefWithoutModifiers_TypeReference_VersionRequest(context, (VersionedParameterizedTypeRefStructural) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefWithoutModifiersRule()) {
					sequence_ParameterizedTypeRefStructural_TStructMemberList_TypeArguments_TypeRefWithoutModifiers_TypeReference_VersionRequest(context, (VersionedParameterizedTypeRefStructural) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeRefFunctionTypeExpressionRule()
						|| rule == grammarAccess.getParameterizedTypeRefRule()
						|| rule == grammarAccess.getParameterizedTypeRefStructuralRule()) {
					sequence_ParameterizedTypeRefStructural_TStructMemberList_TypeArguments_TypeReference_VersionRequest(context, (VersionedParameterizedTypeRefStructural) semanticObject); 
					return; 
				}
				else break;
			case TypeRefsPackage.WILDCARD:
				if (rule == grammarAccess.getEmptyIterableTypeExpressionTailRule()
						|| rule == grammarAccess.getWildcardOldNotationWithoutBoundRule()) {
					sequence_EmptyIterableTypeExpressionTail_WildcardOldNotationWithoutBound(context, (Wildcard) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getWildcardNewNotationRule()) {
					sequence_WildcardNewNotation(context, (Wildcard) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeArgumentRule()
						|| rule == grammarAccess.getWildcardRule()) {
					sequence_WildcardNewNotation_WildcardOldNotation(context, (Wildcard) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getTypeArgInTypeTypeRefRule()
						|| rule == grammarAccess.getWildcardOldNotationRule()) {
					sequence_WildcardOldNotation(context, (Wildcard) semanticObject); 
					return; 
				}
				else break;
			}
		else if (epackage == TypesPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case TypesPackage.TANONYMOUS_FORMAL_PARAMETER:
				sequence_ColonSepTypeRef_DefaultFormalParameter_TAnonymousFormalParameter(context, (TAnonymousFormalParameter) semanticObject); 
				return; 
			case TypesPackage.TFORMAL_PARAMETER:
				sequence_ColonSepTypeRef_DefaultFormalParameter_TFormalParameter(context, (TFormalParameter) semanticObject); 
				return; 
			case TypesPackage.TSTRUCT_FIELD:
				sequence_ColonSepTypeRef_TStructField(context, (TStructField) semanticObject); 
				return; 
			case TypesPackage.TSTRUCT_GETTER:
				sequence_ColonSepDeclaredTypeRef_TStructGetter(context, (TStructGetter) semanticObject); 
				return; 
			case TypesPackage.TSTRUCT_METHOD:
				sequence_ColonSepReturnTypeRef_TAnonymousFormalParameterList_TStructMethod_TypeVariables(context, (TStructMethod) semanticObject); 
				return; 
			case TypesPackage.TSTRUCT_SETTER:
				sequence_TStructSetter(context, (TStructSetter) semanticObject); 
				return; 
			case TypesPackage.TYPE_VARIABLE:
				sequence_TypeVariable(context, (TypeVariable) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     AdditiveExpression<Yield> returns AdditiveExpression
	 *     AdditiveExpression returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns AdditiveExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns AdditiveExpression
	 *     ShiftExpression<Yield> returns AdditiveExpression
	 *     ShiftExpression returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns AdditiveExpression
	 *     ShiftExpression.ShiftExpression_1_0_0 returns AdditiveExpression
	 *     RelationalExpression<In,Yield> returns AdditiveExpression
	 *     RelationalExpression<In> returns AdditiveExpression
	 *     RelationalExpression<Yield> returns AdditiveExpression
	 *     RelationalExpression returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns AdditiveExpression
	 *     RelationalExpression.RelationalExpression_1_0_0 returns AdditiveExpression
	 *     EqualityExpression<In,Yield> returns AdditiveExpression
	 *     EqualityExpression<In> returns AdditiveExpression
	 *     EqualityExpression<Yield> returns AdditiveExpression
	 *     EqualityExpression returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns AdditiveExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns AdditiveExpression
	 *     BitwiseANDExpression<In,Yield> returns AdditiveExpression
	 *     BitwiseANDExpression<In> returns AdditiveExpression
	 *     BitwiseANDExpression<Yield> returns AdditiveExpression
	 *     BitwiseANDExpression returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns AdditiveExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns AdditiveExpression
	 *     BitwiseXORExpression<In,Yield> returns AdditiveExpression
	 *     BitwiseXORExpression<In> returns AdditiveExpression
	 *     BitwiseXORExpression<Yield> returns AdditiveExpression
	 *     BitwiseXORExpression returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns AdditiveExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns AdditiveExpression
	 *     BitwiseORExpression<In,Yield> returns AdditiveExpression
	 *     BitwiseORExpression<In> returns AdditiveExpression
	 *     BitwiseORExpression<Yield> returns AdditiveExpression
	 *     BitwiseORExpression returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns AdditiveExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns AdditiveExpression
	 *     LogicalANDExpression<In,Yield> returns AdditiveExpression
	 *     LogicalANDExpression<In> returns AdditiveExpression
	 *     LogicalANDExpression<Yield> returns AdditiveExpression
	 *     LogicalANDExpression returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns AdditiveExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns AdditiveExpression
	 *     LogicalORExpression<In,Yield> returns AdditiveExpression
	 *     LogicalORExpression<In> returns AdditiveExpression
	 *     LogicalORExpression<Yield> returns AdditiveExpression
	 *     LogicalORExpression returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns AdditiveExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns AdditiveExpression
	 *     ConditionalExpression<In,Yield> returns AdditiveExpression
	 *     ConditionalExpression<In> returns AdditiveExpression
	 *     ConditionalExpression<Yield> returns AdditiveExpression
	 *     ConditionalExpression returns AdditiveExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns AdditiveExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns AdditiveExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns AdditiveExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns AdditiveExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns AdditiveExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns AdditiveExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns AdditiveExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns AdditiveExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns AdditiveExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns AdditiveExpression
	 *     AssignmentExpression<In,Yield> returns AdditiveExpression
	 *     AssignmentExpression<In> returns AdditiveExpression
	 *     AssignmentExpression<Yield> returns AdditiveExpression
	 *     AssignmentExpression returns AdditiveExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns AdditiveExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns AdditiveExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns AdditiveExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns AdditiveExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns AdditiveExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns AdditiveExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns AdditiveExpression
	 *     Expression<In,Yield> returns AdditiveExpression
	 *     Expression<In> returns AdditiveExpression
	 *     Expression<Yield> returns AdditiveExpression
	 *     Expression returns AdditiveExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns AdditiveExpression
	 *     Expression.CommaExpression_1_0<In> returns AdditiveExpression
	 *     Expression.CommaExpression_1_0<Yield> returns AdditiveExpression
	 *     Expression.CommaExpression_1_0 returns AdditiveExpression
	 *
	 * Constraint:
	 *     (lhs=AdditiveExpression_AdditiveExpression_1_0_0_0 op=AdditiveOperator rhs=MultiplicativeExpression)
	 */
	protected void sequence_AdditiveExpression(ISerializationContext context, AdditiveExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.ADDITIVE_EXPRESSION__LHS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.ADDITIVE_EXPRESSION__LHS));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.ADDITIVE_EXPRESSION__OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.ADDITIVE_EXPRESSION__OP));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.ADDITIVE_EXPRESSION__RHS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.ADDITIVE_EXPRESSION__RHS));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAdditiveExpressionAccess().getAdditiveExpressionLhsAction_1_0_0_0(), semanticObject.getLhs());
		feeder.accept(grammarAccess.getAdditiveExpressionAccess().getOpAdditiveOperatorEnumRuleCall_1_0_0_1_0(), semanticObject.getOp());
		feeder.accept(grammarAccess.getAdditiveExpressionAccess().getRhsMultiplicativeExpressionParserRuleCall_1_1_0(), semanticObject.getRhs());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ExportableElement returns FunctionDeclaration
	 *
	 * Constraint:
	 *     (
	 *         ((annotationList=AnnotatedExportableElement_FunctionDeclaration_1_0_0 declaredModifiers+=N4Modifier*) | declaredModifiers+=N4Modifier+)? 
	 *         declaredAsync?='async'? 
	 *         generator?='*'? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedExportableElement_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionDeclaration_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(ISerializationContext context, FunctionDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedExportableElement<Yield> returns FunctionDeclaration
	 *     AnnotatedExportableElement returns FunctionDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedExportableElement_FunctionDeclaration_1_0_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         declaredAsync?='async'? 
	 *         generator?='*'? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedExportableElement_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(ISerializationContext context, FunctionDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExportableElement returns N4ClassDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             (
	 *                 annotationList=AnnotatedExportableElement_N4ClassDeclaration_1_2_0_0_0 
	 *                 declaredModifiers+=N4Modifier* 
	 *                 typingStrategy=TypingStrategyDefSiteOperator? 
	 *                 name=BindingIdentifier
	 *             ) | 
	 *             (declaredModifiers+=N4Modifier* typingStrategy=TypingStrategyDefSiteOperator? name=BindingIdentifier? declaredVersion=VERSION?)
	 *         ) 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *         (
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal* 
	 *             (
	 *                 (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal*
	 *             )* 
	 *             (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)?
	 *         )? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_AnnotatedExportableElement_ClassExtendsClause_ClassImplementsList_Members_N4ClassDeclaration_TypeVariables_VersionDeclaration(ISerializationContext context, N4ClassDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedExportableElement<Yield> returns N4ClassDeclaration
	 *     AnnotatedExportableElement returns N4ClassDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedExportableElement_N4ClassDeclaration_1_2_0_0_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         typingStrategy=TypingStrategyDefSiteOperator? 
	 *         name=BindingIdentifier 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *         (
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal* 
	 *             (
	 *                 (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal*
	 *             )* 
	 *             (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)?
	 *         )? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_AnnotatedExportableElement_ClassExtendsClause_ClassImplementsList_Members_TypeVariables(ISerializationContext context, N4ClassDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedExportableElement<Yield> returns ExportedVariableStatement
	 *     AnnotatedExportableElement returns ExportedVariableStatement
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedExportableElement_ExportedVariableStatement_1_1_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         varStmtKeyword=VariableStatementKeyword 
	 *         varDeclsOrBindings+=ExportedVariableDeclarationOrBinding 
	 *         varDeclsOrBindings+=ExportedVariableDeclarationOrBinding*
	 *     )
	 */
	protected void sequence_AnnotatedExportableElement(ISerializationContext context, ExportedVariableStatement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExportableElement returns ExportedVariableStatement
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             annotationList=AnnotatedExportableElement_ExportedVariableStatement_1_1_0 
	 *             declaredModifiers+=N4Modifier* 
	 *             varStmtKeyword=VariableStatementKeyword 
	 *             varDeclsOrBindings+=ExportedVariableDeclarationOrBinding 
	 *             varDeclsOrBindings+=ExportedVariableDeclarationOrBinding*
	 *         ) | 
	 *         (
	 *             declaredModifiers+=N4Modifier* 
	 *             varStmtKeyword=VariableStatementKeyword 
	 *             varDeclsOrBindings+=ExportedVariableDeclarationOrBinding 
	 *             varDeclsOrBindings+=ExportedVariableDeclarationOrBinding*
	 *         )
	 *     )
	 */
	protected void sequence_AnnotatedExportableElement_ExportedVariableStatement(ISerializationContext context, ExportedVariableStatement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExportableElement returns N4InterfaceDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             (
	 *                 annotationList=AnnotatedExportableElement_N4InterfaceDeclaration_1_2_0_1_0 
	 *                 declaredModifiers+=N4Modifier* 
	 *                 typingStrategy=TypingStrategyDefSiteOperator? 
	 *                 name=BindingIdentifier
	 *             ) | 
	 *             (declaredModifiers+=N4Modifier* typingStrategy=TypingStrategyDefSiteOperator? name=BindingIdentifier? declaredVersion=VERSION?)
	 *         ) 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         (superInterfaceRefs+=ParameterizedTypeRefNominal superInterfaceRefs+=ParameterizedTypeRefNominal*)? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_AnnotatedExportableElement_InterfaceExtendsList_Members_N4InterfaceDeclaration_TypeVariables_VersionDeclaration(ISerializationContext context, N4InterfaceDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedExportableElement<Yield> returns N4InterfaceDeclaration
	 *     AnnotatedExportableElement returns N4InterfaceDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedExportableElement_N4InterfaceDeclaration_1_2_0_1_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         typingStrategy=TypingStrategyDefSiteOperator? 
	 *         name=BindingIdentifier 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         (superInterfaceRefs+=ParameterizedTypeRefNominal superInterfaceRefs+=ParameterizedTypeRefNominal*)? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_AnnotatedExportableElement_InterfaceExtendsList_Members_TypeVariables(ISerializationContext context, N4InterfaceDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedExportableElement<Yield> returns N4EnumDeclaration
	 *     AnnotatedExportableElement returns N4EnumDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedExportableElement_N4EnumDeclaration_1_3_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         name=BindingIdentifier 
	 *         literals+=N4EnumLiteral 
	 *         literals+=N4EnumLiteral*
	 *     )
	 */
	protected void sequence_AnnotatedExportableElement(ISerializationContext context, N4EnumDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExportableElement returns N4EnumDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             annotationList=AnnotatedExportableElement_N4EnumDeclaration_1_3_0 
	 *             declaredModifiers+=N4Modifier* 
	 *             name=BindingIdentifier 
	 *             literals+=N4EnumLiteral 
	 *             literals+=N4EnumLiteral*
	 *         ) | 
	 *         (declaredModifiers+=N4Modifier* name=BindingIdentifier? declaredVersion=VERSION? (literals+=N4EnumLiteral literals+=N4EnumLiteral*)?)
	 *     )
	 */
	protected void sequence_AnnotatedExportableElement_N4EnumDeclaration_VersionDeclaration(ISerializationContext context, N4EnumDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PrimaryExpression<Yield> returns FunctionExpression
	 *     PrimaryExpression returns FunctionExpression
	 *     LeftHandSideExpression<Yield> returns FunctionExpression
	 *     LeftHandSideExpression returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<PostfixExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<CastExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<UnaryExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<MultiplicativeExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AdditiveExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ShiftExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In,RelationalExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In,EqualityExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0 returns FunctionExpression
	 *     MemberExpression<Yield> returns FunctionExpression
	 *     MemberExpression returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LeftHandSideExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<PostfixExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<CastExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<UnaryExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<MultiplicativeExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AdditiveExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ShiftExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0 returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LeftHandSideExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<PostfixExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<CastExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<UnaryExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<MultiplicativeExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AdditiveExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ShiftExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In,RelationalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In,EqualityExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0 returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LeftHandSideExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<PostfixExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<CastExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<UnaryExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<MultiplicativeExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AdditiveExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ShiftExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In,RelationalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In,EqualityExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0 returns FunctionExpression
	 *     PostfixExpression<Yield> returns FunctionExpression
	 *     PostfixExpression returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<CastExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<UnaryExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<MultiplicativeExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AdditiveExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ShiftExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     PostfixExpression.PostfixExpression_1_0_0 returns FunctionExpression
	 *     CastExpression<Yield> returns FunctionExpression
	 *     CastExpression returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<UnaryExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<MultiplicativeExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<AdditiveExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<ShiftExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     CastExpression.CastExpression_1_0_0_0 returns FunctionExpression
	 *     UnaryExpression<Yield> returns FunctionExpression
	 *     UnaryExpression returns FunctionExpression
	 *     MultiplicativeExpression<Yield> returns FunctionExpression
	 *     MultiplicativeExpression returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AdditiveExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ShiftExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0 returns FunctionExpression
	 *     AdditiveExpression<Yield> returns FunctionExpression
	 *     AdditiveExpression returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns FunctionExpression
	 *     ShiftExpression<Yield> returns FunctionExpression
	 *     ShiftExpression returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     ShiftExpression.ShiftExpression_1_0_0 returns FunctionExpression
	 *     RelationalExpression<In,Yield> returns FunctionExpression
	 *     RelationalExpression<In> returns FunctionExpression
	 *     RelationalExpression<Yield> returns FunctionExpression
	 *     RelationalExpression returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     RelationalExpression.RelationalExpression_1_0_0 returns FunctionExpression
	 *     EqualityExpression<In,Yield> returns FunctionExpression
	 *     EqualityExpression<In> returns FunctionExpression
	 *     EqualityExpression<Yield> returns FunctionExpression
	 *     EqualityExpression returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns FunctionExpression
	 *     BitwiseANDExpression<In,Yield> returns FunctionExpression
	 *     BitwiseANDExpression<In> returns FunctionExpression
	 *     BitwiseANDExpression<Yield> returns FunctionExpression
	 *     BitwiseANDExpression returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns FunctionExpression
	 *     BitwiseXORExpression<In,Yield> returns FunctionExpression
	 *     BitwiseXORExpression<In> returns FunctionExpression
	 *     BitwiseXORExpression<Yield> returns FunctionExpression
	 *     BitwiseXORExpression returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns FunctionExpression
	 *     BitwiseORExpression<In,Yield> returns FunctionExpression
	 *     BitwiseORExpression<In> returns FunctionExpression
	 *     BitwiseORExpression<Yield> returns FunctionExpression
	 *     BitwiseORExpression returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns FunctionExpression
	 *     LogicalANDExpression<In,Yield> returns FunctionExpression
	 *     LogicalANDExpression<In> returns FunctionExpression
	 *     LogicalANDExpression<Yield> returns FunctionExpression
	 *     LogicalANDExpression returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns FunctionExpression
	 *     LogicalORExpression<In,Yield> returns FunctionExpression
	 *     LogicalORExpression<In> returns FunctionExpression
	 *     LogicalORExpression<Yield> returns FunctionExpression
	 *     LogicalORExpression returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns FunctionExpression
	 *     ConditionalExpression<In,Yield> returns FunctionExpression
	 *     ConditionalExpression<In> returns FunctionExpression
	 *     ConditionalExpression<Yield> returns FunctionExpression
	 *     ConditionalExpression returns FunctionExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns FunctionExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns FunctionExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns FunctionExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns FunctionExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns FunctionExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns FunctionExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns FunctionExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns FunctionExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns FunctionExpression
	 *     AssignmentExpression<In,Yield> returns FunctionExpression
	 *     AssignmentExpression<In> returns FunctionExpression
	 *     AssignmentExpression<Yield> returns FunctionExpression
	 *     AssignmentExpression returns FunctionExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns FunctionExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns FunctionExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns FunctionExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns FunctionExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns FunctionExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns FunctionExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns FunctionExpression
	 *     Expression<In,Yield> returns FunctionExpression
	 *     Expression<In> returns FunctionExpression
	 *     Expression<Yield> returns FunctionExpression
	 *     Expression returns FunctionExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns FunctionExpression
	 *     Expression.CommaExpression_1_0<In> returns FunctionExpression
	 *     Expression.CommaExpression_1_0<Yield> returns FunctionExpression
	 *     Expression.CommaExpression_1_0 returns FunctionExpression
	 *
	 * Constraint:
	 *     (
	 *         (declaredAsync?='async' | (annotationList=AnnotatedExpression_FunctionExpression_1_1_0 declaredAsync?='async'?))? 
	 *         generator?='*'? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block
	 *     )
	 */
	protected void sequence_AnnotatedExpression_AsyncFunctionExpression_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionExpression_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(ISerializationContext context, FunctionExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedExpression<Yield> returns FunctionExpression
	 *     AnnotatedExpression returns FunctionExpression
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedExpression_FunctionExpression_1_1_0 
	 *         declaredAsync?='async'? 
	 *         generator?='*'? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block
	 *     )
	 */
	protected void sequence_AnnotatedExpression_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(ISerializationContext context, FunctionExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedExpression<Yield> returns N4ClassExpression
	 *     AnnotatedExpression returns N4ClassExpression
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedExpression_N4ClassExpression_1_0_0 
	 *         name=BindingIdentifier? 
	 *         (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *         (
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal* 
	 *             (
	 *                 (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal*
	 *             )* 
	 *             (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)?
	 *         )? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_AnnotatedExpression_ClassExtendsClause_ClassImplementsList_Members(ISerializationContext context, N4ClassExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PrimaryExpression<Yield> returns N4ClassExpression
	 *     PrimaryExpression returns N4ClassExpression
	 *     LeftHandSideExpression<Yield> returns N4ClassExpression
	 *     LeftHandSideExpression returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<PostfixExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<CastExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<UnaryExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<MultiplicativeExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AdditiveExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ShiftExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In,RelationalExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In,EqualityExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0 returns N4ClassExpression
	 *     MemberExpression<Yield> returns N4ClassExpression
	 *     MemberExpression returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LeftHandSideExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<PostfixExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<CastExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<UnaryExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<MultiplicativeExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AdditiveExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ShiftExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0 returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LeftHandSideExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<PostfixExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<CastExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<UnaryExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<MultiplicativeExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AdditiveExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ShiftExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In,RelationalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In,EqualityExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0 returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LeftHandSideExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<PostfixExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<CastExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<UnaryExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<MultiplicativeExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AdditiveExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ShiftExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In,RelationalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In,EqualityExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0 returns N4ClassExpression
	 *     PostfixExpression<Yield> returns N4ClassExpression
	 *     PostfixExpression returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<CastExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<UnaryExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<MultiplicativeExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AdditiveExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ShiftExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     PostfixExpression.PostfixExpression_1_0_0 returns N4ClassExpression
	 *     CastExpression<Yield> returns N4ClassExpression
	 *     CastExpression returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<UnaryExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<MultiplicativeExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<AdditiveExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<ShiftExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     CastExpression.CastExpression_1_0_0_0 returns N4ClassExpression
	 *     UnaryExpression<Yield> returns N4ClassExpression
	 *     UnaryExpression returns N4ClassExpression
	 *     MultiplicativeExpression<Yield> returns N4ClassExpression
	 *     MultiplicativeExpression returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AdditiveExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ShiftExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0 returns N4ClassExpression
	 *     AdditiveExpression<Yield> returns N4ClassExpression
	 *     AdditiveExpression returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns N4ClassExpression
	 *     ShiftExpression<Yield> returns N4ClassExpression
	 *     ShiftExpression returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     ShiftExpression.ShiftExpression_1_0_0 returns N4ClassExpression
	 *     RelationalExpression<In,Yield> returns N4ClassExpression
	 *     RelationalExpression<In> returns N4ClassExpression
	 *     RelationalExpression<Yield> returns N4ClassExpression
	 *     RelationalExpression returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     RelationalExpression.RelationalExpression_1_0_0 returns N4ClassExpression
	 *     EqualityExpression<In,Yield> returns N4ClassExpression
	 *     EqualityExpression<In> returns N4ClassExpression
	 *     EqualityExpression<Yield> returns N4ClassExpression
	 *     EqualityExpression returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns N4ClassExpression
	 *     BitwiseANDExpression<In,Yield> returns N4ClassExpression
	 *     BitwiseANDExpression<In> returns N4ClassExpression
	 *     BitwiseANDExpression<Yield> returns N4ClassExpression
	 *     BitwiseANDExpression returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns N4ClassExpression
	 *     BitwiseXORExpression<In,Yield> returns N4ClassExpression
	 *     BitwiseXORExpression<In> returns N4ClassExpression
	 *     BitwiseXORExpression<Yield> returns N4ClassExpression
	 *     BitwiseXORExpression returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns N4ClassExpression
	 *     BitwiseORExpression<In,Yield> returns N4ClassExpression
	 *     BitwiseORExpression<In> returns N4ClassExpression
	 *     BitwiseORExpression<Yield> returns N4ClassExpression
	 *     BitwiseORExpression returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns N4ClassExpression
	 *     LogicalANDExpression<In,Yield> returns N4ClassExpression
	 *     LogicalANDExpression<In> returns N4ClassExpression
	 *     LogicalANDExpression<Yield> returns N4ClassExpression
	 *     LogicalANDExpression returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns N4ClassExpression
	 *     LogicalORExpression<In,Yield> returns N4ClassExpression
	 *     LogicalORExpression<In> returns N4ClassExpression
	 *     LogicalORExpression<Yield> returns N4ClassExpression
	 *     LogicalORExpression returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns N4ClassExpression
	 *     ConditionalExpression<In,Yield> returns N4ClassExpression
	 *     ConditionalExpression<In> returns N4ClassExpression
	 *     ConditionalExpression<Yield> returns N4ClassExpression
	 *     ConditionalExpression returns N4ClassExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns N4ClassExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns N4ClassExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns N4ClassExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns N4ClassExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns N4ClassExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns N4ClassExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns N4ClassExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns N4ClassExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns N4ClassExpression
	 *     AssignmentExpression<In,Yield> returns N4ClassExpression
	 *     AssignmentExpression<In> returns N4ClassExpression
	 *     AssignmentExpression<Yield> returns N4ClassExpression
	 *     AssignmentExpression returns N4ClassExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns N4ClassExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns N4ClassExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns N4ClassExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns N4ClassExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns N4ClassExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns N4ClassExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns N4ClassExpression
	 *     Expression<In,Yield> returns N4ClassExpression
	 *     Expression<In> returns N4ClassExpression
	 *     Expression<Yield> returns N4ClassExpression
	 *     Expression returns N4ClassExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns N4ClassExpression
	 *     Expression.CommaExpression_1_0<In> returns N4ClassExpression
	 *     Expression.CommaExpression_1_0<Yield> returns N4ClassExpression
	 *     Expression.CommaExpression_1_0 returns N4ClassExpression
	 *
	 * Constraint:
	 *     (
	 *         ((annotationList=AnnotatedExpression_N4ClassExpression_1_0_0 name=BindingIdentifier?) | name=BindingIdentifier)? 
	 *         (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *         (
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal* 
	 *             (
	 *                 (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal*
	 *             )* 
	 *             (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)?
	 *         )? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_AnnotatedExpression_ClassExtendsClause_ClassImplementsList_Members_N4ClassExpression(ISerializationContext context, N4ClassExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Statement<Yield> returns FunctionDeclaration
	 *     Statement returns FunctionDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (declaredModifiers+=N4Modifier+ | (annotationList=AnnotationList declaredModifiers+=N4Modifier*))? 
	 *         declaredAsync?='async'? 
	 *         generator?='*'? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedFunctionDeclaration_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionDeclaration_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(ISerializationContext context, FunctionDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedFunctionDeclaration<Yield,Default> returns FunctionDeclaration
	 *     AnnotatedFunctionDeclaration<Yield> returns FunctionDeclaration
	 *     AnnotatedFunctionDeclaration<Default> returns FunctionDeclaration
	 *     AnnotatedFunctionDeclaration returns FunctionDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotationList 
	 *         declaredModifiers+=N4Modifier* 
	 *         declaredAsync?='async'? 
	 *         generator?='*'? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedFunctionDeclaration_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(ISerializationContext context, FunctionDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     N4MemberDeclaration<Yield> returns N4MethodDeclaration
	 *     N4MemberDeclaration returns N4MethodDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             (
	 *                 (
	 *                     (annotationList=AnnotatedN4MemberDeclaration_N4MethodDeclaration_1_2_0_0_0 declaredModifiers+=N4Modifier* bogusTypeRef=TypeRefWithModifiers?) | 
	 *                     (
	 *                         ((annotationList=AnnotatedN4MemberDeclaration_N4MethodDeclaration_1_2_0_0_0 declaredModifiers+=N4Modifier*) | declaredModifiers+=N4Modifier+) 
	 *                         typeVars+=TypeVariable 
	 *                         typeVars+=TypeVariable* 
	 *                         bogusTypeRef=TypeRefWithModifiers?
	 *                     ) | 
	 *                     declaredModifiers+=N4Modifier+ | 
	 *                     (declaredModifiers+=N4Modifier+ bogusTypeRef=TypeRefWithModifiers?)
	 *                 )? 
	 *                 declaredAsync?='async' 
	 *                 (declaredName=LiteralOrComputedPropertyName | declaredName=LiteralOrComputedPropertyName)
	 *             ) | 
	 *             (
	 *                 annotationList=AnnotatedN4MemberDeclaration_N4MethodDeclaration_1_2_0_0_0 
	 *                 declaredModifiers+=N4Modifier* 
	 *                 (
	 *                     (bogusTypeRef=TypeRefWithModifiers? generator?='*' declaredName=LiteralOrComputedPropertyName) | 
	 *                     (bogusTypeRef=TypeRefWithModifiers? generator?='*' declaredName=LiteralOrComputedPropertyName) | 
	 *                     declaredName=LiteralOrComputedPropertyName
	 *                 )
	 *             ) | 
	 *             (
	 *                 ((annotationList=AnnotatedN4MemberDeclaration_N4MethodDeclaration_1_2_0_0_0 declaredModifiers+=N4Modifier*) | declaredModifiers+=N4Modifier+) 
	 *                 typeVars+=TypeVariable 
	 *                 typeVars+=TypeVariable* 
	 *                 (
	 *                     (bogusTypeRef=TypeRefWithModifiers? generator?='*' declaredName=LiteralOrComputedPropertyName) | 
	 *                     (bogusTypeRef=TypeRefWithModifiers? generator?='*' declaredName=LiteralOrComputedPropertyName) | 
	 *                     declaredName=LiteralOrComputedPropertyName | 
	 *                     declaredName=LiteralOrComputedPropertyName
	 *                 )
	 *             ) | 
	 *             (
	 *                 (
	 *                     (
	 *                         annotationList=AnnotatedN4MemberDeclaration_N4MethodDeclaration_1_2_0_0_0 
	 *                         declaredModifiers+=N4Modifier* 
	 *                         (typeVars+=TypeVariable typeVars+=TypeVariable*)?
	 *                     ) | 
	 *                     declaredModifiers+=N4Modifier+ | 
	 *                     (declaredModifiers+=N4Modifier+ (typeVars+=TypeVariable typeVars+=TypeVariable*)?)
	 *                 ) 
	 *                 bogusTypeRef=TypeRefWithModifiers? 
	 *                 (declaredName=LiteralOrComputedPropertyName | declaredName=LiteralOrComputedPropertyName)
	 *             ) | 
	 *             (
	 *                 (declaredModifiers+=N4Modifier+ | (declaredModifiers+=N4Modifier+ bogusTypeRef=TypeRefWithModifiers?)) 
	 *                 generator?='*' 
	 *                 declaredName=LiteralOrComputedPropertyName
	 *             ) | 
	 *             (declaredModifiers+=N4Modifier+ declaredName=LiteralOrComputedPropertyName) | 
	 *             (declaredModifiers+=N4Modifier+ bogusTypeRef=TypeRefWithModifiers? generator?='*' declaredName=LiteralOrComputedPropertyName)
	 *         )? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedN4MemberDeclaration_AsyncNoTrailingLineBreak_BogusTypeRefFragment_ColonSepReturnTypeRef_MethodParamsReturnAndBody_N4MethodDeclaration_StrictFormalParameters_TypeVariables(ISerializationContext context, N4MethodDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedN4MemberDeclaration<Yield> returns N4MethodDeclaration
	 *     AnnotatedN4MemberDeclaration returns N4MethodDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedN4MemberDeclaration_N4MethodDeclaration_1_2_0_0_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         bogusTypeRef=TypeRefWithModifiers? 
	 *         ((declaredAsync?='async'? declaredName=LiteralOrComputedPropertyName) | (generator?='*' declaredName=LiteralOrComputedPropertyName)) 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedN4MemberDeclaration_AsyncNoTrailingLineBreak_BogusTypeRefFragment_ColonSepReturnTypeRef_MethodParamsReturnAndBody_StrictFormalParameters_TypeVariables(ISerializationContext context, N4MethodDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedN4MemberDeclaration<Yield> returns N4FieldDeclaration
	 *     AnnotatedN4MemberDeclaration returns N4FieldDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedN4MemberDeclaration_N4FieldDeclaration_1_3_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         bogusTypeRef=TypeRefWithModifiers? 
	 *         declaredName=LiteralOrComputedPropertyName 
	 *         declaredOptional?='?'? 
	 *         declaredTypeRef=TypeRef? 
	 *         expression=Expression?
	 *     )
	 */
	protected void sequence_AnnotatedN4MemberDeclaration_BogusTypeRefFragment_ColonSepDeclaredTypeRef_FieldDeclarationImpl(ISerializationContext context, N4FieldDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     N4MemberDeclaration<Yield> returns N4FieldDeclaration
	 *     N4MemberDeclaration returns N4FieldDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedN4MemberDeclaration_N4FieldDeclaration_1_3_0? 
	 *         declaredModifiers+=N4Modifier* 
	 *         bogusTypeRef=TypeRefWithModifiers? 
	 *         declaredName=LiteralOrComputedPropertyName 
	 *         declaredOptional?='?'? 
	 *         declaredTypeRef=TypeRef? 
	 *         expression=Expression?
	 *     )
	 */
	protected void sequence_AnnotatedN4MemberDeclaration_BogusTypeRefFragment_ColonSepDeclaredTypeRef_FieldDeclarationImpl_N4FieldDeclaration(ISerializationContext context, N4FieldDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedN4MemberDeclaration<Yield> returns N4GetterDeclaration
	 *     AnnotatedN4MemberDeclaration returns N4GetterDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedN4MemberDeclaration_N4GetterDeclaration_1_0_0_0_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         bogusTypeRef=TypeRefWithModifiers? 
	 *         declaredName=LiteralOrComputedPropertyName 
	 *         declaredOptional?='?'? 
	 *         declaredTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedN4MemberDeclaration_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader(ISerializationContext context, N4GetterDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     N4MemberDeclaration<Yield> returns N4GetterDeclaration
	 *     N4MemberDeclaration returns N4GetterDeclaration
	 *
	 * Constraint:
	 *     (
	 *         ((annotationList=AnnotatedN4MemberDeclaration_N4GetterDeclaration_1_0_0_0_0 declaredModifiers+=N4Modifier*) | declaredModifiers+=N4Modifier+)? 
	 *         bogusTypeRef=TypeRefWithModifiers? 
	 *         declaredName=LiteralOrComputedPropertyName 
	 *         declaredOptional?='?'? 
	 *         declaredTypeRef=TypeRef? 
	 *         (body=Block | body=Block)?
	 *     )
	 */
	protected void sequence_AnnotatedN4MemberDeclaration_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader_N4GetterDeclaration(ISerializationContext context, N4GetterDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedN4MemberDeclaration<Yield> returns N4SetterDeclaration
	 *     AnnotatedN4MemberDeclaration returns N4SetterDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedN4MemberDeclaration_N4SetterDeclaration_1_1_0_0_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         declaredName=LiteralOrComputedPropertyName 
	 *         declaredOptional?='?'? 
	 *         fpar=FormalParameter 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedN4MemberDeclaration(ISerializationContext context, N4SetterDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     N4MemberDeclaration<Yield> returns N4SetterDeclaration
	 *     N4MemberDeclaration returns N4SetterDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             annotationList=AnnotatedN4MemberDeclaration_N4SetterDeclaration_1_1_0_0_0 
	 *             declaredModifiers+=N4Modifier* 
	 *             declaredName=LiteralOrComputedPropertyName 
	 *             declaredOptional?='?'? 
	 *             fpar=FormalParameter 
	 *             body=Block?
	 *         ) | 
	 *         (declaredModifiers+=N4Modifier* declaredName=LiteralOrComputedPropertyName declaredOptional?='?'? fpar=FormalParameter body=Block?)
	 *     )
	 */
	protected void sequence_AnnotatedN4MemberDeclaration_N4SetterDeclaration(ISerializationContext context, N4SetterDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedPropertyAssignment<Yield> returns PropertyGetterDeclaration
	 *     AnnotatedPropertyAssignment returns PropertyGetterDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedPropertyAssignment_PropertyGetterDeclaration_1_1_0_0_0 
	 *         bogusTypeRef=TypeRefWithModifiers? 
	 *         declaredName=LiteralOrComputedPropertyName 
	 *         declaredOptional?='?'? 
	 *         declaredTypeRef=TypeRef? 
	 *         body=Block
	 *     )
	 */
	protected void sequence_AnnotatedPropertyAssignment_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader(ISerializationContext context, PropertyGetterDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PropertyAssignment<Yield> returns PropertyGetterDeclaration
	 *     PropertyAssignment returns PropertyGetterDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedPropertyAssignment_PropertyGetterDeclaration_1_1_0_0_0? 
	 *         bogusTypeRef=TypeRefWithModifiers? 
	 *         declaredName=LiteralOrComputedPropertyName 
	 *         declaredOptional?='?'? 
	 *         declaredTypeRef=TypeRef? 
	 *         (body=Block | body=Block)
	 *     )
	 */
	protected void sequence_AnnotatedPropertyAssignment_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader_PropertyGetterDeclaration(ISerializationContext context, PropertyGetterDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PropertyAssignment<Yield> returns PropertyMethodDeclaration
	 *     PropertyAssignment returns PropertyMethodDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             (
	 *                 (annotationList=AnnotatedPropertyAssignment_PropertyMethodDeclaration_1_3_0_0_0 typeVars+=TypeVariable typeVars+=TypeVariable*) 
	 *                 returnTypeRef=TypeRefWithModifiers? 
	 *                 ((generator?='*' declaredName=LiteralOrComputedPropertyName) | declaredName=LiteralOrComputedPropertyName)
	 *             ) | 
	 *             (
	 *                 (
	 *                     annotationList=AnnotatedPropertyAssignment_PropertyMethodDeclaration_1_3_0_0_0 | 
	 *                     (annotationList=AnnotatedPropertyAssignment_PropertyMethodDeclaration_1_3_0_0_0 typeVars+=TypeVariable typeVars+=TypeVariable*)
	 *                 )? 
	 *                 returnTypeRef=TypeRefWithModifiers? 
	 *                 ((generator?='*' declaredName=LiteralOrComputedPropertyName) | declaredName=LiteralOrComputedPropertyName)
	 *             )
	 *         ) 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedPropertyAssignment_MethodParamsAndBody_PropertyMethodDeclaration_StrictFormalParameters_TypeVariables(ISerializationContext context, PropertyMethodDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedPropertyAssignment<Yield> returns PropertyMethodDeclaration
	 *     AnnotatedPropertyAssignment returns PropertyMethodDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedPropertyAssignment_PropertyMethodDeclaration_1_3_0_0_0 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         returnTypeRef=TypeRefWithModifiers? 
	 *         ((generator?='*' declaredName=LiteralOrComputedPropertyName) | declaredName=LiteralOrComputedPropertyName) 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedPropertyAssignment_MethodParamsAndBody_StrictFormalParameters_TypeVariables(ISerializationContext context, PropertyMethodDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedPropertyAssignment<Yield> returns PropertyNameValuePair
	 *     AnnotatedPropertyAssignment returns PropertyNameValuePair
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedPropertyAssignment_PropertyNameValuePair_1_0_0_0_0 
	 *         declaredTypeRef=TypeRefWithModifiers? 
	 *         declaredName=LiteralOrComputedPropertyName 
	 *         expression=AssignmentExpression
	 *     )
	 */
	protected void sequence_AnnotatedPropertyAssignment(ISerializationContext context, PropertyNameValuePair semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedPropertyAssignment<Yield> returns PropertyNameValuePairSingleName
	 *     AnnotatedPropertyAssignment returns PropertyNameValuePairSingleName
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedPropertyAssignment_PropertyNameValuePairSingleName_1_4_0 
	 *         declaredTypeRef=TypeRef? 
	 *         identifierRef=IdentifierRef 
	 *         expression=AssignmentExpression?
	 *     )
	 */
	protected void sequence_AnnotatedPropertyAssignment(ISerializationContext context, PropertyNameValuePairSingleName semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PropertyAssignment<Yield> returns PropertyNameValuePairSingleName
	 *     PropertyAssignment returns PropertyNameValuePairSingleName
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             annotationList=AnnotatedPropertyAssignment_PropertyNameValuePairSingleName_1_4_0 
	 *             declaredTypeRef=TypeRef? 
	 *             identifierRef=IdentifierRef 
	 *             expression=AssignmentExpression?
	 *         ) | 
	 *         (declaredTypeRef=TypeRef? identifierRef=IdentifierRef expression=AssignmentExpression?)
	 *     )
	 */
	protected void sequence_AnnotatedPropertyAssignment_PropertyNameValuePairSingleName(ISerializationContext context, PropertyNameValuePairSingleName semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PropertyAssignment<Yield> returns PropertyNameValuePair
	 *     PropertyAssignment returns PropertyNameValuePair
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             annotationList=AnnotatedPropertyAssignment_PropertyNameValuePair_1_0_0_0_0 
	 *             declaredTypeRef=TypeRefWithModifiers? 
	 *             declaredName=LiteralOrComputedPropertyName 
	 *             expression=AssignmentExpression
	 *         ) | 
	 *         (declaredTypeRef=TypeRefWithModifiers? declaredName=LiteralOrComputedPropertyName declaredOptional?='?'? expression=AssignmentExpression)
	 *     )
	 */
	protected void sequence_AnnotatedPropertyAssignment_PropertyNameValuePair(ISerializationContext context, PropertyNameValuePair semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedPropertyAssignment<Yield> returns PropertySetterDeclaration
	 *     AnnotatedPropertyAssignment returns PropertySetterDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedPropertyAssignment_PropertySetterDeclaration_1_2_0_0_0 
	 *         declaredName=LiteralOrComputedPropertyName 
	 *         declaredOptional?='?'? 
	 *         fpar=FormalParameter 
	 *         body=Block
	 *     )
	 */
	protected void sequence_AnnotatedPropertyAssignment(ISerializationContext context, PropertySetterDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PropertyAssignment<Yield> returns PropertySetterDeclaration
	 *     PropertyAssignment returns PropertySetterDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             annotationList=AnnotatedPropertyAssignment_PropertySetterDeclaration_1_2_0_0_0 
	 *             declaredName=LiteralOrComputedPropertyName 
	 *             declaredOptional?='?'? 
	 *             fpar=FormalParameter 
	 *             body=Block
	 *         ) | 
	 *         (declaredName=LiteralOrComputedPropertyName declaredOptional?='?'? fpar=FormalParameter body=Block)
	 *     )
	 */
	protected void sequence_AnnotatedPropertyAssignment_PropertySetterDeclaration(ISerializationContext context, PropertySetterDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedPropertyAssignment<Yield> returns PropertySpread
	 *     AnnotatedPropertyAssignment returns PropertySpread
	 *
	 * Constraint:
	 *     (annotationList=AnnotatedPropertyAssignment_PropertySpread_1_5_0 expression=AssignmentExpression)
	 */
	protected void sequence_AnnotatedPropertyAssignment(ISerializationContext context, PropertySpread semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.ANNOTABLE_PROPERTY_ASSIGNMENT__ANNOTATION_LIST) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.ANNOTABLE_PROPERTY_ASSIGNMENT__ANNOTATION_LIST));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.PROPERTY_SPREAD__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.PROPERTY_SPREAD__EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAnnotatedPropertyAssignmentAccess().getPropertySpreadAnnotationListAction_1_5_0(), semanticObject.getAnnotationList());
		feeder.accept(grammarAccess.getAnnotatedPropertyAssignmentAccess().getExpressionAssignmentExpressionParserRuleCall_1_5_2_0(), semanticObject.getExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     PropertyAssignment<Yield> returns PropertySpread
	 *     PropertyAssignment returns PropertySpread
	 *
	 * Constraint:
	 *     ((annotationList=AnnotatedPropertyAssignment_PropertySpread_1_5_0 expression=AssignmentExpression) | expression=AssignmentExpression)
	 */
	protected void sequence_AnnotatedPropertyAssignment_PropertySpread(ISerializationContext context, PropertySpread semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns FunctionDeclaration
	 *
	 * Constraint:
	 *     (
	 *         ((annotationList=AnnotatedScriptElement_FunctionDeclaration_1_2_0 declaredModifiers+=N4Modifier*) | declaredModifiers+=N4Modifier+)? 
	 *         declaredAsync?='async'? 
	 *         generator?='*'? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionDeclaration_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(ISerializationContext context, FunctionDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedScriptElement returns FunctionDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedScriptElement_FunctionDeclaration_1_2_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         declaredAsync?='async'? 
	 *         generator?='*'? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(ISerializationContext context, FunctionDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns N4ClassDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             (
	 *                 annotationList=AnnotatedScriptElement_N4ClassDeclaration_1_3_0_0_0 
	 *                 declaredModifiers+=N4Modifier* 
	 *                 typingStrategy=TypingStrategyDefSiteOperator? 
	 *                 name=BindingIdentifier
	 *             ) | 
	 *             (declaredModifiers+=N4Modifier* typingStrategy=TypingStrategyDefSiteOperator? name=BindingIdentifier?)
	 *         ) 
	 *         declaredVersion=VERSION? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *         (
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal* 
	 *             (
	 *                 (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal*
	 *             )* 
	 *             (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)?
	 *         )? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_ClassExtendsClause_ClassImplementsList_Members_N4ClassDeclaration_TypeVariables_VersionDeclaration(ISerializationContext context, N4ClassDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedScriptElement returns N4ClassDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedScriptElement_N4ClassDeclaration_1_3_0_0_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         typingStrategy=TypingStrategyDefSiteOperator? 
	 *         name=BindingIdentifier 
	 *         declaredVersion=VERSION? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *         (
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal* 
	 *             (
	 *                 (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal*
	 *             )* 
	 *             (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)?
	 *         )? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_ClassExtendsClause_ClassImplementsList_Members_TypeVariables_VersionDeclaration(ISerializationContext context, N4ClassDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedScriptElement returns ExportDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedScriptElement_ExportDeclaration_1_0_0 
	 *         (
	 *             (wildcardExport?='*'? reexportedFrom=[TModule|ModuleSpecifier]?) | 
	 *             exportedElement=ExportableElement | 
	 *             (defaultExport?='default' (exportedElement=ExportableElement | defaultExportedExpression=AssignmentExpression)) | 
	 *             (namedExports+=ExportSpecifier namedExports+=ExportSpecifier* reexportedFrom=[TModule|ModuleSpecifier]?)
	 *         )?
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_ExportClause_ExportDeclarationImpl_ExportFromClause(ISerializationContext context, ExportDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns ExportDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedScriptElement_ExportDeclaration_1_0_0? 
	 *         (
	 *             (wildcardExport?='*'? reexportedFrom=[TModule|ModuleSpecifier]?) | 
	 *             exportedElement=ExportableElement | 
	 *             (defaultExport?='default' (exportedElement=ExportableElement | defaultExportedExpression=AssignmentExpression)) | 
	 *             (namedExports+=ExportSpecifier namedExports+=ExportSpecifier* reexportedFrom=[TModule|ModuleSpecifier]?)
	 *         )?
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_ExportClause_ExportDeclaration_ExportDeclarationImpl_ExportFromClause(ISerializationContext context, ExportDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedScriptElement returns ImportDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedScriptElement_ImportDeclaration_1_1_0 
	 *         (
	 *             importSpecifiers+=DefaultImportSpecifier? 
	 *             (importSpecifiers+=NamespaceImportSpecifier | (importSpecifiers+=NamedImportSpecifier importSpecifiers+=NamedImportSpecifier*))? 
	 *             importFrom?='from'
	 *         )? 
	 *         module=[TModule|ModuleSpecifier]
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_ImportClause_ImportDeclarationImpl_ImportSpecifiersExceptDefault(ISerializationContext context, ImportDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns ImportDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedScriptElement_ImportDeclaration_1_1_0? 
	 *         (
	 *             importSpecifiers+=DefaultImportSpecifier? 
	 *             (importSpecifiers+=NamespaceImportSpecifier | (importSpecifiers+=NamedImportSpecifier importSpecifiers+=NamedImportSpecifier*))? 
	 *             importFrom?='from'
	 *         )? 
	 *         module=[TModule|ModuleSpecifier]
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_ImportClause_ImportDeclaration_ImportDeclarationImpl_ImportSpecifiersExceptDefault(ISerializationContext context, ImportDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns N4InterfaceDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             (
	 *                 annotationList=AnnotatedScriptElement_N4InterfaceDeclaration_1_3_0_1_0 
	 *                 declaredModifiers+=N4Modifier* 
	 *                 typingStrategy=TypingStrategyDefSiteOperator? 
	 *                 name=BindingIdentifier
	 *             ) | 
	 *             (declaredModifiers+=N4Modifier* typingStrategy=TypingStrategyDefSiteOperator? name=BindingIdentifier?)
	 *         ) 
	 *         declaredVersion=VERSION? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         (superInterfaceRefs+=ParameterizedTypeRefNominal superInterfaceRefs+=ParameterizedTypeRefNominal*)? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_InterfaceExtendsList_Members_N4InterfaceDeclaration_TypeVariables_VersionDeclaration(ISerializationContext context, N4InterfaceDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedScriptElement returns N4InterfaceDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedScriptElement_N4InterfaceDeclaration_1_3_0_1_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         typingStrategy=TypingStrategyDefSiteOperator? 
	 *         name=BindingIdentifier 
	 *         declaredVersion=VERSION? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         (superInterfaceRefs+=ParameterizedTypeRefNominal superInterfaceRefs+=ParameterizedTypeRefNominal*)? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_InterfaceExtendsList_Members_TypeVariables_VersionDeclaration(ISerializationContext context, N4InterfaceDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns N4EnumDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             annotationList=AnnotatedScriptElement_N4EnumDeclaration_1_4_0 
	 *             declaredModifiers+=N4Modifier* 
	 *             name=BindingIdentifier 
	 *             (
	 *                 (declaredVersion=VERSION? (literals+=N4EnumLiteral literals+=N4EnumLiteral*)?) | 
	 *                 (declaredVersion=VERSION? literals+=N4EnumLiteral literals+=N4EnumLiteral*)
	 *             )
	 *         ) | 
	 *         (
	 *             declaredModifiers+=N4Modifier* 
	 *             name=BindingIdentifier? 
	 *             (
	 *                 (declaredVersion=VERSION? (literals+=N4EnumLiteral literals+=N4EnumLiteral*)?) | 
	 *                 (declaredVersion=VERSION? literals+=N4EnumLiteral literals+=N4EnumLiteral*)
	 *             )
	 *         )
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_N4EnumDeclaration_VersionDeclaration(ISerializationContext context, N4EnumDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedScriptElement returns N4EnumDeclaration
	 *
	 * Constraint:
	 *     (
	 *         annotationList=AnnotatedScriptElement_N4EnumDeclaration_1_4_0 
	 *         declaredModifiers+=N4Modifier* 
	 *         name=BindingIdentifier 
	 *         declaredVersion=VERSION? 
	 *         literals+=N4EnumLiteral 
	 *         literals+=N4EnumLiteral*
	 *     )
	 */
	protected void sequence_AnnotatedScriptElement_VersionDeclaration(ISerializationContext context, N4EnumDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedScriptElement.ExportDeclaration_1_0_0 returns AnnotationList
	 *     AnnotatedScriptElement.ImportDeclaration_1_1_0 returns AnnotationList
	 *     AnnotatedScriptElement.FunctionDeclaration_1_2_0 returns AnnotationList
	 *     AnnotatedScriptElement.N4ClassDeclaration_1_3_0_0_0 returns AnnotationList
	 *     AnnotatedScriptElement.N4InterfaceDeclaration_1_3_0_1_0 returns AnnotationList
	 *     AnnotatedScriptElement.N4EnumDeclaration_1_4_0 returns AnnotationList
	 *     AnnotatedExportableElement.FunctionDeclaration_1_0_0<Yield> returns AnnotationList
	 *     AnnotatedExportableElement.FunctionDeclaration_1_0_0 returns AnnotationList
	 *     AnnotatedExportableElement.ExportedVariableStatement_1_1_0<Yield> returns AnnotationList
	 *     AnnotatedExportableElement.ExportedVariableStatement_1_1_0 returns AnnotationList
	 *     AnnotatedExportableElement.N4ClassDeclaration_1_2_0_0_0<Yield> returns AnnotationList
	 *     AnnotatedExportableElement.N4ClassDeclaration_1_2_0_0_0 returns AnnotationList
	 *     AnnotatedExportableElement.N4InterfaceDeclaration_1_2_0_1_0<Yield> returns AnnotationList
	 *     AnnotatedExportableElement.N4InterfaceDeclaration_1_2_0_1_0 returns AnnotationList
	 *     AnnotatedExportableElement.N4EnumDeclaration_1_3_0<Yield> returns AnnotationList
	 *     AnnotatedExportableElement.N4EnumDeclaration_1_3_0 returns AnnotationList
	 *     AnnotationList returns AnnotationList
	 *
	 * Constraint:
	 *     (annotations+=AnnotationNoAtSign annotations+=Annotation*)
	 */
	protected void sequence_AnnotationList(ISerializationContext context, AnnotationList semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Annotation returns Annotation
	 *     ScriptAnnotation returns Annotation
	 *     AnnotationNoAtSign returns Annotation
	 *
	 * Constraint:
	 *     (name=AnnotationName (args+=AnnotationArgument args+=AnnotationArgument*)?)
	 */
	protected void sequence_AnnotationNoAtSign(ISerializationContext context, Annotation semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Argument<Yield> returns Argument
	 *     Argument returns Argument
	 *
	 * Constraint:
	 *     (spread?='...'? expression=AssignmentExpression)
	 */
	protected void sequence_Argument(ISerializationContext context, Argument semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     LeftHandSideExpression<Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression returns ParameterizedCallExpression
	 *     PostfixExpression<Yield> returns ParameterizedCallExpression
	 *     PostfixExpression returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<CastExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<UnaryExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<MultiplicativeExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AdditiveExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0 returns ParameterizedCallExpression
	 *     CastExpression<Yield> returns ParameterizedCallExpression
	 *     CastExpression returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<UnaryExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<MultiplicativeExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<AdditiveExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     CastExpression.CastExpression_1_0_0_0 returns ParameterizedCallExpression
	 *     UnaryExpression<Yield> returns ParameterizedCallExpression
	 *     UnaryExpression returns ParameterizedCallExpression
	 *     MultiplicativeExpression<Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AdditiveExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0 returns ParameterizedCallExpression
	 *     AdditiveExpression<Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns ParameterizedCallExpression
	 *     ShiftExpression<Yield> returns ParameterizedCallExpression
	 *     ShiftExpression returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0 returns ParameterizedCallExpression
	 *     RelationalExpression<In,Yield> returns ParameterizedCallExpression
	 *     RelationalExpression<In> returns ParameterizedCallExpression
	 *     RelationalExpression<Yield> returns ParameterizedCallExpression
	 *     RelationalExpression returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0 returns ParameterizedCallExpression
	 *     EqualityExpression<In,Yield> returns ParameterizedCallExpression
	 *     EqualityExpression<In> returns ParameterizedCallExpression
	 *     EqualityExpression<Yield> returns ParameterizedCallExpression
	 *     EqualityExpression returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns ParameterizedCallExpression
	 *     BitwiseANDExpression<In,Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression<In> returns ParameterizedCallExpression
	 *     BitwiseANDExpression<Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns ParameterizedCallExpression
	 *     BitwiseXORExpression<In,Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression<In> returns ParameterizedCallExpression
	 *     BitwiseXORExpression<Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns ParameterizedCallExpression
	 *     BitwiseORExpression<In,Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression<In> returns ParameterizedCallExpression
	 *     BitwiseORExpression<Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns ParameterizedCallExpression
	 *     LogicalANDExpression<In,Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression<In> returns ParameterizedCallExpression
	 *     LogicalANDExpression<Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns ParameterizedCallExpression
	 *     LogicalORExpression<In,Yield> returns ParameterizedCallExpression
	 *     LogicalORExpression<In> returns ParameterizedCallExpression
	 *     LogicalORExpression<Yield> returns ParameterizedCallExpression
	 *     LogicalORExpression returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns ParameterizedCallExpression
	 *     ConditionalExpression<In,Yield> returns ParameterizedCallExpression
	 *     ConditionalExpression<In> returns ParameterizedCallExpression
	 *     ConditionalExpression<Yield> returns ParameterizedCallExpression
	 *     ConditionalExpression returns ParameterizedCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns ParameterizedCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns ParameterizedCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns ParameterizedCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns ParameterizedCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns ParameterizedCallExpression
	 *     AssignmentExpression<In,Yield> returns ParameterizedCallExpression
	 *     AssignmentExpression<In> returns ParameterizedCallExpression
	 *     AssignmentExpression<Yield> returns ParameterizedCallExpression
	 *     AssignmentExpression returns ParameterizedCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns ParameterizedCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns ParameterizedCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns ParameterizedCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns ParameterizedCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns ParameterizedCallExpression
	 *     Expression<In,Yield> returns ParameterizedCallExpression
	 *     Expression<In> returns ParameterizedCallExpression
	 *     Expression<Yield> returns ParameterizedCallExpression
	 *     Expression returns ParameterizedCallExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns ParameterizedCallExpression
	 *     Expression.CommaExpression_1_0<In> returns ParameterizedCallExpression
	 *     Expression.CommaExpression_1_0<Yield> returns ParameterizedCallExpression
	 *     Expression.CommaExpression_1_0 returns ParameterizedCallExpression
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             (typeArgs+=TypeRef typeArgs+=TypeRef* target=IdentifierRef) | 
	 *             target=LeftHandSideExpression_ParameterizedCallExpression_1_0 | 
	 *             target=LeftHandSideExpression_ParameterizedCallExpression_1_2_0_0
	 *         ) 
	 *         (arguments+=Argument arguments+=Argument*)?
	 *     )
	 */
	protected void sequence_Arguments_ConcreteTypeArguments_LeftHandSideExpression_ParameterizedCallExpression(ISerializationContext context, ParameterizedCallExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LeftHandSideExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<PostfixExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<CastExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<UnaryExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<MultiplicativeExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<AdditiveExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<ShiftExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<RelationalExpression.In> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<RelationalExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<RelationalExpression.In,RelationalExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<EqualityExpression.In> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<EqualityExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<EqualityExpression.In,EqualityExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseANDExpression.In> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseANDExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseXORExpression.In> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseORExpression.In> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseORExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalANDExpression.In> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalANDExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalORExpression.In> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<ConditionalExpression.In> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<AssignmentExpression.In> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<Expression.In> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<Expression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0 returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LeftHandSideExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<PostfixExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<CastExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<UnaryExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<MultiplicativeExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<AdditiveExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<ShiftExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<RelationalExpression.In> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<RelationalExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<RelationalExpression.In,RelationalExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<EqualityExpression.In> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<EqualityExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<EqualityExpression.In,EqualityExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseANDExpression.In> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseANDExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseXORExpression.In> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseORExpression.In> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseORExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalANDExpression.In> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalANDExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalORExpression.In> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalORExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<ConditionalExpression.In> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<ConditionalExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<AssignmentExpression.In> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<AssignmentExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<Expression.In> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<Expression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<Expression.In,Expression.Yield> returns NewExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0 returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LeftHandSideExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<PostfixExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<CastExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<UnaryExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<MultiplicativeExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<AdditiveExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<ShiftExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<RelationalExpression.In> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<RelationalExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<RelationalExpression.In,RelationalExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<EqualityExpression.In> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<EqualityExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<EqualityExpression.In,EqualityExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseANDExpression.In> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseANDExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseXORExpression.In> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseORExpression.In> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseORExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalANDExpression.In> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalANDExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalORExpression.In> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalORExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<ConditionalExpression.In> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<ConditionalExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<AssignmentExpression.In> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<AssignmentExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<Expression.In> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<Expression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<Expression.In,Expression.Yield> returns NewExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0 returns NewExpression
	 *
	 * Constraint:
	 *     (callee=MemberExpression (typeArgs+=TypeRef typeArgs+=TypeRef*)? withArgs?='(' (arguments+=Argument arguments+=Argument*)?)
	 */
	protected void sequence_Arguments_ConcreteTypeArguments_MemberExpression_IndexedAccessExpression_1_3_3_0_0_ParameterizedPropertyAccessExpression_1_3_3_1_0_TaggedTemplateString_1_3_3_2_0(ISerializationContext context, NewExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     LeftHandSideExpression<Yield> returns NewExpression
	 *     LeftHandSideExpression returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<PostfixExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<CastExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<UnaryExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<MultiplicativeExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AdditiveExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ShiftExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In,RelationalExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In,EqualityExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In,Expression.Yield> returns NewExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0 returns NewExpression
	 *     MemberExpression<Yield> returns NewExpression
	 *     MemberExpression returns NewExpression
	 *     PostfixExpression<Yield> returns NewExpression
	 *     PostfixExpression returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<CastExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<UnaryExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<MultiplicativeExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AdditiveExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ShiftExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     PostfixExpression.PostfixExpression_1_0_0 returns NewExpression
	 *     CastExpression<Yield> returns NewExpression
	 *     CastExpression returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<UnaryExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<MultiplicativeExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<AdditiveExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<ShiftExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     CastExpression.CastExpression_1_0_0_0 returns NewExpression
	 *     UnaryExpression<Yield> returns NewExpression
	 *     UnaryExpression returns NewExpression
	 *     MultiplicativeExpression<Yield> returns NewExpression
	 *     MultiplicativeExpression returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AdditiveExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ShiftExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0 returns NewExpression
	 *     AdditiveExpression<Yield> returns NewExpression
	 *     AdditiveExpression returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns NewExpression
	 *     ShiftExpression<Yield> returns NewExpression
	 *     ShiftExpression returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     ShiftExpression.ShiftExpression_1_0_0 returns NewExpression
	 *     RelationalExpression<In,Yield> returns NewExpression
	 *     RelationalExpression<In> returns NewExpression
	 *     RelationalExpression<Yield> returns NewExpression
	 *     RelationalExpression returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     RelationalExpression.RelationalExpression_1_0_0 returns NewExpression
	 *     EqualityExpression<In,Yield> returns NewExpression
	 *     EqualityExpression<In> returns NewExpression
	 *     EqualityExpression<Yield> returns NewExpression
	 *     EqualityExpression returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns NewExpression
	 *     BitwiseANDExpression<In,Yield> returns NewExpression
	 *     BitwiseANDExpression<In> returns NewExpression
	 *     BitwiseANDExpression<Yield> returns NewExpression
	 *     BitwiseANDExpression returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns NewExpression
	 *     BitwiseXORExpression<In,Yield> returns NewExpression
	 *     BitwiseXORExpression<In> returns NewExpression
	 *     BitwiseXORExpression<Yield> returns NewExpression
	 *     BitwiseXORExpression returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns NewExpression
	 *     BitwiseORExpression<In,Yield> returns NewExpression
	 *     BitwiseORExpression<In> returns NewExpression
	 *     BitwiseORExpression<Yield> returns NewExpression
	 *     BitwiseORExpression returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns NewExpression
	 *     LogicalANDExpression<In,Yield> returns NewExpression
	 *     LogicalANDExpression<In> returns NewExpression
	 *     LogicalANDExpression<Yield> returns NewExpression
	 *     LogicalANDExpression returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns NewExpression
	 *     LogicalORExpression<In,Yield> returns NewExpression
	 *     LogicalORExpression<In> returns NewExpression
	 *     LogicalORExpression<Yield> returns NewExpression
	 *     LogicalORExpression returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns NewExpression
	 *     ConditionalExpression<In,Yield> returns NewExpression
	 *     ConditionalExpression<In> returns NewExpression
	 *     ConditionalExpression<Yield> returns NewExpression
	 *     ConditionalExpression returns NewExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns NewExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns NewExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns NewExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns NewExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns NewExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns NewExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns NewExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns NewExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns NewExpression
	 *     AssignmentExpression<In,Yield> returns NewExpression
	 *     AssignmentExpression<In> returns NewExpression
	 *     AssignmentExpression<Yield> returns NewExpression
	 *     AssignmentExpression returns NewExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns NewExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns NewExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns NewExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns NewExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns NewExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns NewExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns NewExpression
	 *     Expression<In,Yield> returns NewExpression
	 *     Expression<In> returns NewExpression
	 *     Expression<Yield> returns NewExpression
	 *     Expression returns NewExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns NewExpression
	 *     Expression.CommaExpression_1_0<In> returns NewExpression
	 *     Expression.CommaExpression_1_0<Yield> returns NewExpression
	 *     Expression.CommaExpression_1_0 returns NewExpression
	 *
	 * Constraint:
	 *     (callee=MemberExpression (typeArgs+=TypeRef typeArgs+=TypeRef*)? (withArgs?='(' (arguments+=Argument arguments+=Argument*)?)?)
	 */
	protected void sequence_Arguments_ConcreteTypeArguments_MemberExpression(ISerializationContext context, NewExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PrimaryExpression<Yield> returns ParameterizedCallExpression
	 *     PrimaryExpression returns ParameterizedCallExpression
	 *     ParameterizedCallExpression<Yield> returns ParameterizedCallExpression
	 *     ParameterizedCallExpression returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<PostfixExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<CastExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<UnaryExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<MultiplicativeExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AdditiveExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0 returns ParameterizedCallExpression
	 *     MemberExpression<Yield> returns ParameterizedCallExpression
	 *     MemberExpression returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LeftHandSideExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<PostfixExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<CastExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<UnaryExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<MultiplicativeExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AdditiveExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0 returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LeftHandSideExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<PostfixExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<CastExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<UnaryExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<MultiplicativeExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AdditiveExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0 returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LeftHandSideExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<PostfixExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<CastExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<UnaryExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<MultiplicativeExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AdditiveExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0 returns ParameterizedCallExpression
	 *
	 * Constraint:
	 *     (typeArgs+=TypeRef typeArgs+=TypeRef* target=IdentifierRef (arguments+=Argument arguments+=Argument*)?)
	 */
	protected void sequence_Arguments_ConcreteTypeArguments_ParameterizedCallExpression(ISerializationContext context, ParameterizedCallExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PrimaryExpression<Yield> returns ImportCallExpression
	 *     PrimaryExpression returns ImportCallExpression
	 *     ImportCallExpression<Yield> returns ImportCallExpression
	 *     ImportCallExpression returns ImportCallExpression
	 *     LeftHandSideExpression<Yield> returns ImportCallExpression
	 *     LeftHandSideExpression returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<PostfixExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<CastExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<UnaryExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<MultiplicativeExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AdditiveExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ShiftExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0 returns ImportCallExpression
	 *     MemberExpression<Yield> returns ImportCallExpression
	 *     MemberExpression returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LeftHandSideExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<PostfixExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<CastExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<UnaryExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<MultiplicativeExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AdditiveExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ShiftExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0 returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LeftHandSideExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<PostfixExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<CastExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<UnaryExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<MultiplicativeExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AdditiveExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ShiftExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0 returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LeftHandSideExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<PostfixExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<CastExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<UnaryExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<MultiplicativeExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AdditiveExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ShiftExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In,RelationalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In,EqualityExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0 returns ImportCallExpression
	 *     PostfixExpression<Yield> returns ImportCallExpression
	 *     PostfixExpression returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<CastExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<UnaryExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<MultiplicativeExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AdditiveExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ShiftExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     PostfixExpression.PostfixExpression_1_0_0 returns ImportCallExpression
	 *     CastExpression<Yield> returns ImportCallExpression
	 *     CastExpression returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<UnaryExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<MultiplicativeExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<AdditiveExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<ShiftExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     CastExpression.CastExpression_1_0_0_0 returns ImportCallExpression
	 *     UnaryExpression<Yield> returns ImportCallExpression
	 *     UnaryExpression returns ImportCallExpression
	 *     MultiplicativeExpression<Yield> returns ImportCallExpression
	 *     MultiplicativeExpression returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AdditiveExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ShiftExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0 returns ImportCallExpression
	 *     AdditiveExpression<Yield> returns ImportCallExpression
	 *     AdditiveExpression returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns ImportCallExpression
	 *     ShiftExpression<Yield> returns ImportCallExpression
	 *     ShiftExpression returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     ShiftExpression.ShiftExpression_1_0_0 returns ImportCallExpression
	 *     RelationalExpression<In,Yield> returns ImportCallExpression
	 *     RelationalExpression<In> returns ImportCallExpression
	 *     RelationalExpression<Yield> returns ImportCallExpression
	 *     RelationalExpression returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     RelationalExpression.RelationalExpression_1_0_0 returns ImportCallExpression
	 *     EqualityExpression<In,Yield> returns ImportCallExpression
	 *     EqualityExpression<In> returns ImportCallExpression
	 *     EqualityExpression<Yield> returns ImportCallExpression
	 *     EqualityExpression returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns ImportCallExpression
	 *     BitwiseANDExpression<In,Yield> returns ImportCallExpression
	 *     BitwiseANDExpression<In> returns ImportCallExpression
	 *     BitwiseANDExpression<Yield> returns ImportCallExpression
	 *     BitwiseANDExpression returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns ImportCallExpression
	 *     BitwiseXORExpression<In,Yield> returns ImportCallExpression
	 *     BitwiseXORExpression<In> returns ImportCallExpression
	 *     BitwiseXORExpression<Yield> returns ImportCallExpression
	 *     BitwiseXORExpression returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns ImportCallExpression
	 *     BitwiseORExpression<In,Yield> returns ImportCallExpression
	 *     BitwiseORExpression<In> returns ImportCallExpression
	 *     BitwiseORExpression<Yield> returns ImportCallExpression
	 *     BitwiseORExpression returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns ImportCallExpression
	 *     LogicalANDExpression<In,Yield> returns ImportCallExpression
	 *     LogicalANDExpression<In> returns ImportCallExpression
	 *     LogicalANDExpression<Yield> returns ImportCallExpression
	 *     LogicalANDExpression returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns ImportCallExpression
	 *     LogicalORExpression<In,Yield> returns ImportCallExpression
	 *     LogicalORExpression<In> returns ImportCallExpression
	 *     LogicalORExpression<Yield> returns ImportCallExpression
	 *     LogicalORExpression returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns ImportCallExpression
	 *     ConditionalExpression<In,Yield> returns ImportCallExpression
	 *     ConditionalExpression<In> returns ImportCallExpression
	 *     ConditionalExpression<Yield> returns ImportCallExpression
	 *     ConditionalExpression returns ImportCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns ImportCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns ImportCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns ImportCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns ImportCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns ImportCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ImportCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns ImportCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns ImportCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns ImportCallExpression
	 *     AssignmentExpression<In,Yield> returns ImportCallExpression
	 *     AssignmentExpression<In> returns ImportCallExpression
	 *     AssignmentExpression<Yield> returns ImportCallExpression
	 *     AssignmentExpression returns ImportCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns ImportCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns ImportCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns ImportCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns ImportCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns ImportCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns ImportCallExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns ImportCallExpression
	 *     Expression<In,Yield> returns ImportCallExpression
	 *     Expression<In> returns ImportCallExpression
	 *     Expression<Yield> returns ImportCallExpression
	 *     Expression returns ImportCallExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns ImportCallExpression
	 *     Expression.CommaExpression_1_0<In> returns ImportCallExpression
	 *     Expression.CommaExpression_1_0<Yield> returns ImportCallExpression
	 *     Expression.CommaExpression_1_0 returns ImportCallExpression
	 *
	 * Constraint:
	 *     (arguments+=Argument arguments+=Argument*)?
	 */
	protected void sequence_Arguments(ISerializationContext context, ImportCallExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<PostfixExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<CastExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<UnaryExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<MultiplicativeExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<AdditiveExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<Expression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0 returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<PostfixExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<CastExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<UnaryExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<MultiplicativeExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<AdditiveExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<Expression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<Expression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0 returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<PostfixExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<CastExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<UnaryExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<MultiplicativeExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<AdditiveExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<Expression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<Expression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0 returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<PostfixExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<CastExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<UnaryExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<MultiplicativeExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<AdditiveExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<ShiftExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<RelationalExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<EqualityExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseANDExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseXORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalANDExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalORExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<ConditionalExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<AssignmentExpression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<Expression.In> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<Expression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<Expression.In,Expression.Yield> returns ParameterizedCallExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0 returns ParameterizedCallExpression
	 *
	 * Constraint:
	 *     (
	 *         (target=LeftHandSideExpression_ParameterizedCallExpression_1_0 | target=LeftHandSideExpression_ParameterizedCallExpression_1_2_0_0) 
	 *         (arguments+=Argument arguments+=Argument*)?
	 *     )
	 */
	protected void sequence_Arguments_LeftHandSideExpression_IndexedAccessExpression_1_2_1_0_ParameterizedCallExpression_1_2_0_0_ParameterizedPropertyAccessExpression_1_2_2_0_TaggedTemplateString_1_2_3_0_0(ISerializationContext context, ParameterizedCallExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     BindingPattern<Yield> returns ArrayBindingPattern
	 *     BindingPattern returns ArrayBindingPattern
	 *     ArrayBindingPattern<Yield> returns ArrayBindingPattern
	 *     ArrayBindingPattern returns ArrayBindingPattern
	 *
	 * Constraint:
	 *     (elements+=Elision* (elements+=BindingRestElement (elements+=Elision* elements+=BindingRestElement)* elements+=Elision*)?)
	 */
	protected void sequence_ArrayBindingPattern(ISerializationContext context, ArrayBindingPattern semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ArrayElement<Yield> returns ArrayElement
	 *     ArrayElement returns ArrayElement
	 *
	 * Constraint:
	 *     (spread?='...'? expression=AssignmentExpression)
	 */
	protected void sequence_ArrayElement(ISerializationContext context, ArrayElement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PrimaryExpression<Yield> returns ArrayLiteral
	 *     PrimaryExpression returns ArrayLiteral
	 *     ArrayLiteral<Yield> returns ArrayLiteral
	 *     ArrayLiteral returns ArrayLiteral
	 *     LeftHandSideExpression<Yield> returns ArrayLiteral
	 *     LeftHandSideExpression returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<PostfixExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<CastExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<UnaryExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<MultiplicativeExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AdditiveExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ShiftExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0 returns ArrayLiteral
	 *     MemberExpression<Yield> returns ArrayLiteral
	 *     MemberExpression returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LeftHandSideExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<PostfixExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<CastExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<UnaryExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<MultiplicativeExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AdditiveExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ShiftExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0 returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LeftHandSideExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<PostfixExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<CastExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<UnaryExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<MultiplicativeExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AdditiveExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ShiftExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0 returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LeftHandSideExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<PostfixExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<CastExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<UnaryExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<MultiplicativeExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AdditiveExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ShiftExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In,RelationalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In,EqualityExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0 returns ArrayLiteral
	 *     PostfixExpression<Yield> returns ArrayLiteral
	 *     PostfixExpression returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<CastExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<UnaryExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<MultiplicativeExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AdditiveExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ShiftExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0 returns ArrayLiteral
	 *     CastExpression<Yield> returns ArrayLiteral
	 *     CastExpression returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<UnaryExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<MultiplicativeExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AdditiveExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ShiftExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     CastExpression.CastExpression_1_0_0_0 returns ArrayLiteral
	 *     UnaryExpression<Yield> returns ArrayLiteral
	 *     UnaryExpression returns ArrayLiteral
	 *     MultiplicativeExpression<Yield> returns ArrayLiteral
	 *     MultiplicativeExpression returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AdditiveExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ShiftExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0 returns ArrayLiteral
	 *     AdditiveExpression<Yield> returns ArrayLiteral
	 *     AdditiveExpression returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns ArrayLiteral
	 *     ShiftExpression<Yield> returns ArrayLiteral
	 *     ShiftExpression returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0 returns ArrayLiteral
	 *     RelationalExpression<In,Yield> returns ArrayLiteral
	 *     RelationalExpression<In> returns ArrayLiteral
	 *     RelationalExpression<Yield> returns ArrayLiteral
	 *     RelationalExpression returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0 returns ArrayLiteral
	 *     EqualityExpression<In,Yield> returns ArrayLiteral
	 *     EqualityExpression<In> returns ArrayLiteral
	 *     EqualityExpression<Yield> returns ArrayLiteral
	 *     EqualityExpression returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns ArrayLiteral
	 *     BitwiseANDExpression<In,Yield> returns ArrayLiteral
	 *     BitwiseANDExpression<In> returns ArrayLiteral
	 *     BitwiseANDExpression<Yield> returns ArrayLiteral
	 *     BitwiseANDExpression returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns ArrayLiteral
	 *     BitwiseXORExpression<In,Yield> returns ArrayLiteral
	 *     BitwiseXORExpression<In> returns ArrayLiteral
	 *     BitwiseXORExpression<Yield> returns ArrayLiteral
	 *     BitwiseXORExpression returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns ArrayLiteral
	 *     BitwiseORExpression<In,Yield> returns ArrayLiteral
	 *     BitwiseORExpression<In> returns ArrayLiteral
	 *     BitwiseORExpression<Yield> returns ArrayLiteral
	 *     BitwiseORExpression returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns ArrayLiteral
	 *     LogicalANDExpression<In,Yield> returns ArrayLiteral
	 *     LogicalANDExpression<In> returns ArrayLiteral
	 *     LogicalANDExpression<Yield> returns ArrayLiteral
	 *     LogicalANDExpression returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns ArrayLiteral
	 *     LogicalORExpression<In,Yield> returns ArrayLiteral
	 *     LogicalORExpression<In> returns ArrayLiteral
	 *     LogicalORExpression<Yield> returns ArrayLiteral
	 *     LogicalORExpression returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns ArrayLiteral
	 *     ConditionalExpression<In,Yield> returns ArrayLiteral
	 *     ConditionalExpression<In> returns ArrayLiteral
	 *     ConditionalExpression<Yield> returns ArrayLiteral
	 *     ConditionalExpression returns ArrayLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns ArrayLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns ArrayLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns ArrayLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns ArrayLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns ArrayLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ArrayLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns ArrayLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns ArrayLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns ArrayLiteral
	 *     AssignmentExpression<In,Yield> returns ArrayLiteral
	 *     AssignmentExpression<In> returns ArrayLiteral
	 *     AssignmentExpression<Yield> returns ArrayLiteral
	 *     AssignmentExpression returns ArrayLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns ArrayLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns ArrayLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns ArrayLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns ArrayLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns ArrayLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns ArrayLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns ArrayLiteral
	 *     Expression<In,Yield> returns ArrayLiteral
	 *     Expression<In> returns ArrayLiteral
	 *     Expression<Yield> returns ArrayLiteral
	 *     Expression returns ArrayLiteral
	 *     Expression.CommaExpression_1_0<In,Yield> returns ArrayLiteral
	 *     Expression.CommaExpression_1_0<In> returns ArrayLiteral
	 *     Expression.CommaExpression_1_0<Yield> returns ArrayLiteral
	 *     Expression.CommaExpression_1_0 returns ArrayLiteral
	 *
	 * Constraint:
	 *     (
	 *         elements+=ArrayPadding* 
	 *         (elements+=ArrayElement (elements+=ArrayPadding* elements+=ArrayElement)* (trailingComma?=',' elements+=ArrayPadding*)?)?
	 *     )
	 */
	protected void sequence_ArrayLiteral(ISerializationContext context, ArrayLiteral semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ArrayPadding returns ArrayPadding
	 *
	 * Constraint:
	 *     {ArrayPadding}
	 */
	protected void sequence_ArrayPadding(ISerializationContext context, ArrayPadding semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     TypeRef returns ParameterizedTypeRef
	 *     TypeRef.UnionTypeExpression_1_0 returns ParameterizedTypeRef
	 *     IntersectionTypeExpression returns ParameterizedTypeRef
	 *     IntersectionTypeExpression.IntersectionTypeExpression_1_0 returns ParameterizedTypeRef
	 *     ArrayTypeExpression returns ParameterizedTypeRef
	 *     ArrayTypeExpression.ParameterizedTypeRef_2_1_0_0 returns ParameterizedTypeRef
	 *     PrimaryTypeExpression returns ParameterizedTypeRef
	 *     TypeArgument returns ParameterizedTypeRef
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             astNamespace=[ModuleNamespaceVirtualType|TypeReferenceName]? 
	 *             declaredType=[Type|TypeReferenceName] 
	 *             (typeArgs+=TypeArgument typeArgs+=TypeArgument*)? 
	 *             dynamic?='+'? 
	 *             followedByQuestionMark?='?'?
	 *         ) | 
	 *         (typeArgs+=WildcardOldNotationWithoutBound arrayTypeExpression?='[') | 
	 *         (typeArgs+=ArrayTypeExpression_ParameterizedTypeRef_0_4_0_0 arrayTypeExpression?='[') | 
	 *         (typeArgs+=Wildcard arrayTypeExpression?='[') | 
	 *         (typeArgs+=ArrayTypeExpression_ParameterizedTypeRef_1_6_0_0 arrayTypeExpression?='[') | 
	 *         (typeArgs+=ArrayTypeExpression_ParameterizedTypeRef_2_1_0_0 arrayTypeExpression?='[') | 
	 *         (iterableTypeExpression?='[' (typeArgs+=EmptyIterableTypeExpressionTail | (typeArgs+=TypeArgument typeArgs+=TypeArgument*)))
	 *     )
	 */
	protected void sequence_ArrayTypeExpression_IterableTypeExpression_TypeArguments_TypeRefWithModifiers_TypeRefWithoutModifiers_TypeReference(ISerializationContext context, ParameterizedTypeRef semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ArrowExpression<In,Yield> returns ArrowFunction
	 *     ArrowExpression<In> returns ArrowFunction
	 *     ArrowExpression<Yield> returns ArrowFunction
	 *     ArrowExpression returns ArrowFunction
	 *     AssignmentExpression<In,Yield> returns ArrowFunction
	 *     AssignmentExpression<In> returns ArrowFunction
	 *     AssignmentExpression<Yield> returns ArrowFunction
	 *     AssignmentExpression returns ArrowFunction
	 *     Expression<In,Yield> returns ArrowFunction
	 *     Expression<In> returns ArrowFunction
	 *     Expression<Yield> returns ArrowFunction
	 *     Expression returns ArrowFunction
	 *     Expression.CommaExpression_1_0<In,Yield> returns ArrowFunction
	 *     Expression.CommaExpression_1_0<In> returns ArrowFunction
	 *     Expression.CommaExpression_1_0<Yield> returns ArrowFunction
	 *     Expression.CommaExpression_1_0 returns ArrowFunction
	 *
	 * Constraint:
	 *     (
	 *         ((declaredAsync?='async'? (fpars+=FormalParameter fpars+=FormalParameter*)? returnTypeRef=TypeRef?) | fpars+=BindingIdentifierAsFormalParameter)? 
	 *         ((hasBracesAroundBody?='{' body=BlockMinusBraces) | body=ExpressionDisguisedAsBlock)
	 *     )
	 */
	protected void sequence_ArrowExpression_ColonSepReturnTypeRef_StrictFormalParameters(ISerializationContext context, ArrowFunction semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AssignmentExpressionStatement<In> returns ExpressionStatement
	 *     AssignmentExpressionStatement returns ExpressionStatement
	 *
	 * Constraint:
	 *     expression=AssignmentExpression
	 */
	protected void sequence_AssignmentExpressionStatement(ISerializationContext context, ExpressionStatement semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.EXPRESSION_STATEMENT__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.EXPRESSION_STATEMENT__EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAssignmentExpressionStatementAccess().getExpressionAssignmentExpressionParserRuleCall_0(), semanticObject.getExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     AssignmentExpression<In,Yield> returns AssignmentExpression
	 *     AssignmentExpression<In> returns AssignmentExpression
	 *     AssignmentExpression<Yield> returns AssignmentExpression
	 *     AssignmentExpression returns AssignmentExpression
	 *     Expression<In,Yield> returns AssignmentExpression
	 *     Expression<In> returns AssignmentExpression
	 *     Expression<Yield> returns AssignmentExpression
	 *     Expression returns AssignmentExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns AssignmentExpression
	 *     Expression.CommaExpression_1_0<In> returns AssignmentExpression
	 *     Expression.CommaExpression_1_0<Yield> returns AssignmentExpression
	 *     Expression.CommaExpression_1_0 returns AssignmentExpression
	 *
	 * Constraint:
	 *     (lhs=AssignmentExpression_AssignmentExpression_4_1_0_0_0 op=AssignmentOperator rhs=AssignmentExpression)
	 */
	protected void sequence_AssignmentExpression(ISerializationContext context, AssignmentExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.ASSIGNMENT_EXPRESSION__LHS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.ASSIGNMENT_EXPRESSION__LHS));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.ASSIGNMENT_EXPRESSION__OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.ASSIGNMENT_EXPRESSION__OP));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.ASSIGNMENT_EXPRESSION__RHS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.ASSIGNMENT_EXPRESSION__RHS));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAssignmentExpressionAccess().getAssignmentExpressionLhsAction_4_1_0_0_0(), semanticObject.getLhs());
		feeder.accept(grammarAccess.getAssignmentExpressionAccess().getOpAssignmentOperatorParserRuleCall_4_1_0_0_1_0(), semanticObject.getOp());
		feeder.accept(grammarAccess.getAssignmentExpressionAccess().getRhsAssignmentExpressionParserRuleCall_4_1_1_0(), semanticObject.getRhs());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     AsyncFunctionExpression returns FunctionExpression
	 *
	 * Constraint:
	 *     (
	 *         declaredAsync?='async' 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block
	 *     )
	 */
	protected void sequence_AsyncFunctionExpression_ColonSepReturnTypeRef_FunctionBody_FunctionHeader_StrictFormalParameters_TypeVariables_VersionDeclaration(ISerializationContext context, FunctionExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     N4MethodDeclaration<Yield> returns N4MethodDeclaration
	 *     N4MethodDeclaration returns N4MethodDeclaration
	 *
	 * Constraint:
	 *     (
	 *         declaredModifiers+=N4Modifier* 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         bogusTypeRef=TypeRefWithModifiers? 
	 *         ((declaredAsync?='async'? declaredName=LiteralOrComputedPropertyName) | (generator?='*' declaredName=LiteralOrComputedPropertyName)) 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AsyncNoTrailingLineBreak_BogusTypeRefFragment_ColonSepReturnTypeRef_MethodParamsReturnAndBody_N4MethodDeclaration_StrictFormalParameters_TypeVariables(ISerializationContext context, N4MethodDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     FunctionDeclaration<Yield> returns FunctionDeclaration
	 *     FunctionDeclaration returns FunctionDeclaration
	 *     RootStatement<Yield> returns FunctionDeclaration
	 *     RootStatement returns FunctionDeclaration
	 *
	 * Constraint:
	 *     (
	 *         declaredModifiers+=N4Modifier* 
	 *         declaredAsync?='async'? 
	 *         generator?='*'? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_AsyncNoTrailingLineBreak_ColonSepReturnTypeRef_FunctionBody_FunctionDeclaration_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(ISerializationContext context, FunctionDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AssignmentExpression<In,Yield> returns AwaitExpression
	 *     AssignmentExpression<In> returns AwaitExpression
	 *     AssignmentExpression<Yield> returns AwaitExpression
	 *     AssignmentExpression returns AwaitExpression
	 *     AwaitExpression<In,Yield> returns AwaitExpression
	 *     AwaitExpression<In> returns AwaitExpression
	 *     AwaitExpression<Yield> returns AwaitExpression
	 *     AwaitExpression returns AwaitExpression
	 *     Expression<In,Yield> returns AwaitExpression
	 *     Expression<In> returns AwaitExpression
	 *     Expression<Yield> returns AwaitExpression
	 *     Expression returns AwaitExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns AwaitExpression
	 *     Expression.CommaExpression_1_0<In> returns AwaitExpression
	 *     Expression.CommaExpression_1_0<Yield> returns AwaitExpression
	 *     Expression.CommaExpression_1_0 returns AwaitExpression
	 *
	 * Constraint:
	 *     expression=AssignmentExpression
	 */
	protected void sequence_AwaitExpression(ISerializationContext context, AwaitExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.AWAIT_EXPRESSION__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.AWAIT_EXPRESSION__EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getAwaitExpressionAccess().getExpressionAssignmentExpressionParserRuleCall_1_0(), semanticObject.getExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     PrimaryExpression<Yield> returns BinaryIntLiteral
	 *     PrimaryExpression returns BinaryIntLiteral
	 *     LeftHandSideExpression<Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<PostfixExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<CastExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<UnaryExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<MultiplicativeExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AdditiveExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ShiftExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In,RelationalExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In,EqualityExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0 returns BinaryIntLiteral
	 *     MemberExpression<Yield> returns BinaryIntLiteral
	 *     MemberExpression returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LeftHandSideExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<PostfixExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<CastExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<UnaryExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<MultiplicativeExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AdditiveExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ShiftExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0 returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LeftHandSideExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<PostfixExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<CastExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<UnaryExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<MultiplicativeExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AdditiveExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ShiftExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In,RelationalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In,EqualityExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0 returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LeftHandSideExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<PostfixExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<CastExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<UnaryExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<MultiplicativeExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AdditiveExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ShiftExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In,RelationalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In,EqualityExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0 returns BinaryIntLiteral
	 *     PostfixExpression<Yield> returns BinaryIntLiteral
	 *     PostfixExpression returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<CastExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<UnaryExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<MultiplicativeExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AdditiveExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ShiftExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0 returns BinaryIntLiteral
	 *     CastExpression<Yield> returns BinaryIntLiteral
	 *     CastExpression returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<UnaryExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<MultiplicativeExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AdditiveExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ShiftExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     CastExpression.CastExpression_1_0_0_0 returns BinaryIntLiteral
	 *     UnaryExpression<Yield> returns BinaryIntLiteral
	 *     UnaryExpression returns BinaryIntLiteral
	 *     MultiplicativeExpression<Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AdditiveExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ShiftExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0 returns BinaryIntLiteral
	 *     AdditiveExpression<Yield> returns BinaryIntLiteral
	 *     AdditiveExpression returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns BinaryIntLiteral
	 *     ShiftExpression<Yield> returns BinaryIntLiteral
	 *     ShiftExpression returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0 returns BinaryIntLiteral
	 *     RelationalExpression<In,Yield> returns BinaryIntLiteral
	 *     RelationalExpression<In> returns BinaryIntLiteral
	 *     RelationalExpression<Yield> returns BinaryIntLiteral
	 *     RelationalExpression returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0 returns BinaryIntLiteral
	 *     EqualityExpression<In,Yield> returns BinaryIntLiteral
	 *     EqualityExpression<In> returns BinaryIntLiteral
	 *     EqualityExpression<Yield> returns BinaryIntLiteral
	 *     EqualityExpression returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns BinaryIntLiteral
	 *     BitwiseANDExpression<In,Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression<In> returns BinaryIntLiteral
	 *     BitwiseANDExpression<Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns BinaryIntLiteral
	 *     BitwiseXORExpression<In,Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression<In> returns BinaryIntLiteral
	 *     BitwiseXORExpression<Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns BinaryIntLiteral
	 *     BitwiseORExpression<In,Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression<In> returns BinaryIntLiteral
	 *     BitwiseORExpression<Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns BinaryIntLiteral
	 *     LogicalANDExpression<In,Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression<In> returns BinaryIntLiteral
	 *     LogicalANDExpression<Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns BinaryIntLiteral
	 *     LogicalORExpression<In,Yield> returns BinaryIntLiteral
	 *     LogicalORExpression<In> returns BinaryIntLiteral
	 *     LogicalORExpression<Yield> returns BinaryIntLiteral
	 *     LogicalORExpression returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns BinaryIntLiteral
	 *     ConditionalExpression<In,Yield> returns BinaryIntLiteral
	 *     ConditionalExpression<In> returns BinaryIntLiteral
	 *     ConditionalExpression<Yield> returns BinaryIntLiteral
	 *     ConditionalExpression returns BinaryIntLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns BinaryIntLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns BinaryIntLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns BinaryIntLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns BinaryIntLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryIntLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns BinaryIntLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns BinaryIntLiteral
	 *     AssignmentExpression<In,Yield> returns BinaryIntLiteral
	 *     AssignmentExpression<In> returns BinaryIntLiteral
	 *     AssignmentExpression<Yield> returns BinaryIntLiteral
	 *     AssignmentExpression returns BinaryIntLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns BinaryIntLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns BinaryIntLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns BinaryIntLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns BinaryIntLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns BinaryIntLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns BinaryIntLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns BinaryIntLiteral
	 *     Expression<In,Yield> returns BinaryIntLiteral
	 *     Expression<In> returns BinaryIntLiteral
	 *     Expression<Yield> returns BinaryIntLiteral
	 *     Expression returns BinaryIntLiteral
	 *     Expression.CommaExpression_1_0<In,Yield> returns BinaryIntLiteral
	 *     Expression.CommaExpression_1_0<In> returns BinaryIntLiteral
	 *     Expression.CommaExpression_1_0<Yield> returns BinaryIntLiteral
	 *     Expression.CommaExpression_1_0 returns BinaryIntLiteral
	 *     Literal returns BinaryIntLiteral
	 *     NumericLiteral returns BinaryIntLiteral
	 *     BinaryIntLiteral returns BinaryIntLiteral
	 *
	 * Constraint:
	 *     value=BINARY_INT
	 */
	protected void sequence_BinaryIntLiteral(ISerializationContext context, BinaryIntLiteral semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.NUMERIC_LITERAL__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.NUMERIC_LITERAL__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getBinaryIntLiteralAccess().getValueBINARY_INTTerminalRuleCall_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     FormalParameter<Yield> returns FormalParameter
	 *     FormalParameter returns FormalParameter
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             bindingPattern=BindingPattern | 
	 *             (annotations+=Annotation* bogusTypeRef=TypeRefWithModifiers? variadic?='...'? name=BindingIdentifier declaredTypeRef=TypeRef?)
	 *         ) 
	 *         (hasInitializerAssignment?='=' initializer=AssignmentExpression?)?
	 *     )
	 */
	protected void sequence_BindingElementFragment_BogusTypeRefFragment_ColonSepDeclaredTypeRef_FormalParameter(ISerializationContext context, FormalParameter semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     BindingElement<Yield> returns BindingElement
	 *     BindingElement returns BindingElement
	 *
	 * Constraint:
	 *     ((nestedPattern=BindingPattern expression=AssignmentExpression?) | varDecl=VariableDeclaration)
	 */
	protected void sequence_BindingElementImpl(ISerializationContext context, BindingElement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     BindingRestElement<Yield> returns BindingElement
	 *     BindingRestElement returns BindingElement
	 *
	 * Constraint:
	 *     (rest?='...'? ((nestedPattern=BindingPattern expression=AssignmentExpression?) | varDecl=VariableDeclaration))
	 */
	protected void sequence_BindingElementImpl_BindingRestElement(ISerializationContext context, BindingElement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     BindingIdentifierAsFormalParameter<Yield> returns FormalParameter
	 *     BindingIdentifierAsFormalParameter returns FormalParameter
	 *
	 * Constraint:
	 *     name=BindingIdentifier
	 */
	protected void sequence_BindingIdentifierAsFormalParameter(ISerializationContext context, FormalParameter semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getBindingIdentifierAsFormalParameterAccess().getNameBindingIdentifierParserRuleCall_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     BindingIdentifierAsVariableDeclaration<In,Yield> returns VariableDeclaration
	 *     BindingIdentifierAsVariableDeclaration<In> returns VariableDeclaration
	 *     BindingIdentifierAsVariableDeclaration<Yield> returns VariableDeclaration
	 *     BindingIdentifierAsVariableDeclaration returns VariableDeclaration
	 *
	 * Constraint:
	 *     name=BindingIdentifier
	 */
	protected void sequence_BindingIdentifierAsVariableDeclaration(ISerializationContext context, VariableDeclaration semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getBindingIdentifierAsVariableDeclarationAccess().getNameBindingIdentifierParserRuleCall_0(), semanticObject.getName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     BindingProperty<Yield,AllowType> returns BindingProperty
	 *     BindingProperty<Yield> returns BindingProperty
	 *     BindingProperty<AllowType> returns BindingProperty
	 *     BindingProperty returns BindingProperty
	 *
	 * Constraint:
	 *     ((declaredName=LiteralOrComputedPropertyName value=BindingElement) | value=SingleNameBinding)
	 */
	protected void sequence_BindingProperty(ISerializationContext context, BindingProperty semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     BitwiseANDExpression<In,Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression<In> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression<Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns BinaryBitwiseExpression
	 *
	 * Constraint:
	 *     (lhs=BitwiseANDExpression_BinaryBitwiseExpression_1_0_0_0 op=BitwiseANDOperator rhs=EqualityExpression)
	 */
	protected void sequence_BitwiseANDExpression(ISerializationContext context, BinaryBitwiseExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.BINARY_BITWISE_EXPRESSION__LHS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.BINARY_BITWISE_EXPRESSION__LHS));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.BINARY_BITWISE_EXPRESSION__OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.BINARY_BITWISE_EXPRESSION__OP));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.BINARY_BITWISE_EXPRESSION__RHS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.BINARY_BITWISE_EXPRESSION__RHS));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getBitwiseANDExpressionAccess().getBinaryBitwiseExpressionLhsAction_1_0_0_0(), semanticObject.getLhs());
		feeder.accept(grammarAccess.getBitwiseANDExpressionAccess().getOpBitwiseANDOperatorParserRuleCall_1_0_0_1_0(), semanticObject.getOp());
		feeder.accept(grammarAccess.getBitwiseANDExpressionAccess().getRhsEqualityExpressionParserRuleCall_1_1_0(), semanticObject.getRhs());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     BitwiseORExpression<In,Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression<In> returns BinaryBitwiseExpression
	 *     BitwiseORExpression<Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns BinaryBitwiseExpression
	 *     LogicalANDExpression<In,Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression<In> returns BinaryBitwiseExpression
	 *     LogicalANDExpression<Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryBitwiseExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns BinaryBitwiseExpression
	 *     LogicalORExpression<In,Yield> returns BinaryBitwiseExpression
	 *     LogicalORExpression<In> returns BinaryBitwiseExpression
	 *     LogicalORExpression<Yield> returns BinaryBitwiseExpression
	 *     LogicalORExpression returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryBitwiseExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns BinaryBitwiseExpression
	 *     ConditionalExpression<In,Yield> returns BinaryBitwiseExpression
	 *     ConditionalExpression<In> returns BinaryBitwiseExpression
	 *     ConditionalExpression<Yield> returns BinaryBitwiseExpression
	 *     ConditionalExpression returns BinaryBitwiseExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns BinaryBitwiseExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns BinaryBitwiseExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns BinaryBitwiseExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns BinaryBitwiseExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns BinaryBitwiseExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns BinaryBitwiseExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryBitwiseExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns BinaryBitwiseExpression
	 *     AssignmentExpression<In,Yield> returns BinaryBitwiseExpression
	 *     AssignmentExpression<In> returns BinaryBitwiseExpression
	 *     AssignmentExpression<Yield> returns BinaryBitwiseExpression
	 *     AssignmentExpression returns BinaryBitwiseExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns BinaryBitwiseExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns BinaryBitwiseExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns BinaryBitwiseExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns BinaryBitwiseExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns BinaryBitwiseExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns BinaryBitwiseExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns BinaryBitwiseExpression
	 *     Expression<In,Yield> returns BinaryBitwiseExpression
	 *     Expression<In> returns BinaryBitwiseExpression
	 *     Expression<Yield> returns BinaryBitwiseExpression
	 *     Expression returns BinaryBitwiseExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns BinaryBitwiseExpression
	 *     Expression.CommaExpression_1_0<In> returns BinaryBitwiseExpression
	 *     Expression.CommaExpression_1_0<Yield> returns BinaryBitwiseExpression
	 *     Expression.CommaExpression_1_0 returns BinaryBitwiseExpression
	 *
	 * Constraint:
	 *     (
	 *         (lhs=BitwiseANDExpression_BinaryBitwiseExpression_1_0_0_0 op=BitwiseANDOperator rhs=EqualityExpression) | 
	 *         (lhs=BitwiseXORExpression_BinaryBitwiseExpression_1_0_0_0 op=BitwiseXOROperator rhs=BitwiseANDExpression) | 
	 *         (lhs=BitwiseORExpression_BinaryBitwiseExpression_1_0_0_0 op=BitwiseOROperator rhs=BitwiseXORExpression)
	 *     )
	 */
	protected void sequence_BitwiseANDExpression_BitwiseORExpression_BitwiseXORExpression(ISerializationContext context, BinaryBitwiseExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     BitwiseXORExpression<In,Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression<In> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression<Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns BinaryBitwiseExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns BinaryBitwiseExpression
	 *
	 * Constraint:
	 *     (
	 *         (lhs=BitwiseANDExpression_BinaryBitwiseExpression_1_0_0_0 op=BitwiseANDOperator rhs=EqualityExpression) | 
	 *         (lhs=BitwiseXORExpression_BinaryBitwiseExpression_1_0_0_0 op=BitwiseXOROperator rhs=BitwiseANDExpression)
	 *     )
	 */
	protected void sequence_BitwiseANDExpression_BitwiseXORExpression(ISerializationContext context, BinaryBitwiseExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     BlockMinusBraces<Yield> returns Block
	 *     BlockMinusBraces returns Block
	 *
	 * Constraint:
	 *     statements+=Statement*
	 */
	protected void sequence_BlockMinusBraces(ISerializationContext context, Block semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns Block
	 *     Block<Yield> returns Block
	 *     Block returns Block
	 *     RootStatement<Yield> returns Block
	 *     RootStatement returns Block
	 *     Statement<Yield> returns Block
	 *     Statement returns Block
	 *
	 * Constraint:
	 *     statements+=Statement*
	 */
	protected void sequence_Block(ISerializationContext context, Block semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     CatchVariable<Yield> returns CatchVariable
	 *     CatchVariable returns CatchVariable
	 *
	 * Constraint:
	 *     ((bogusTypeRef=TypeRefWithModifiers? name=BindingIdentifier) | bindingPattern=BindingPattern | (name=BindingIdentifier declaredTypeRef=TypeRef))
	 */
	protected void sequence_BogusTypeRefFragment_CatchVariable_ColonSepDeclaredTypeRef(ISerializationContext context, CatchVariable semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     N4FieldDeclaration<Yield> returns N4FieldDeclaration
	 *     N4FieldDeclaration returns N4FieldDeclaration
	 *
	 * Constraint:
	 *     (
	 *         declaredModifiers+=N4Modifier* 
	 *         bogusTypeRef=TypeRefWithModifiers? 
	 *         declaredName=LiteralOrComputedPropertyName 
	 *         declaredOptional?='?'? 
	 *         declaredTypeRef=TypeRef? 
	 *         expression=Expression?
	 *     )
	 */
	protected void sequence_BogusTypeRefFragment_ColonSepDeclaredTypeRef_FieldDeclarationImpl_N4FieldDeclaration(ISerializationContext context, N4FieldDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     N4GetterDeclaration<Yield> returns N4GetterDeclaration
	 *     N4GetterDeclaration returns N4GetterDeclaration
	 *
	 * Constraint:
	 *     (
	 *         declaredModifiers+=N4Modifier* 
	 *         bogusTypeRef=TypeRefWithModifiers? 
	 *         declaredName=LiteralOrComputedPropertyName 
	 *         declaredOptional?='?'? 
	 *         declaredTypeRef=TypeRef? 
	 *         body=Block?
	 *     )
	 */
	protected void sequence_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader_N4GetterDeclaration(ISerializationContext context, N4GetterDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PropertyGetterDeclaration<Yield> returns PropertyGetterDeclaration
	 *     PropertyGetterDeclaration returns PropertyGetterDeclaration
	 *
	 * Constraint:
	 *     (bogusTypeRef=TypeRefWithModifiers? declaredName=LiteralOrComputedPropertyName declaredOptional?='?'? declaredTypeRef=TypeRef? body=Block)
	 */
	protected void sequence_BogusTypeRefFragment_ColonSepDeclaredTypeRef_GetterHeader_PropertyGetterDeclaration(ISerializationContext context, PropertyGetterDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PrimaryExpression<Yield> returns BooleanLiteral
	 *     PrimaryExpression returns BooleanLiteral
	 *     LeftHandSideExpression<Yield> returns BooleanLiteral
	 *     LeftHandSideExpression returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<PostfixExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<CastExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<UnaryExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<MultiplicativeExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AdditiveExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ShiftExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In,RelationalExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In,EqualityExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0 returns BooleanLiteral
	 *     MemberExpression<Yield> returns BooleanLiteral
	 *     MemberExpression returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LeftHandSideExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<PostfixExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<CastExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<UnaryExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<MultiplicativeExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AdditiveExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ShiftExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0 returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LeftHandSideExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<PostfixExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<CastExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<UnaryExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<MultiplicativeExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AdditiveExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ShiftExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In,RelationalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In,EqualityExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0 returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LeftHandSideExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<PostfixExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<CastExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<UnaryExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<MultiplicativeExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AdditiveExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ShiftExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In,RelationalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In,EqualityExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0 returns BooleanLiteral
	 *     PostfixExpression<Yield> returns BooleanLiteral
	 *     PostfixExpression returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<CastExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<UnaryExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<MultiplicativeExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AdditiveExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ShiftExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0 returns BooleanLiteral
	 *     CastExpression<Yield> returns BooleanLiteral
	 *     CastExpression returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<UnaryExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<MultiplicativeExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AdditiveExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ShiftExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     CastExpression.CastExpression_1_0_0_0 returns BooleanLiteral
	 *     UnaryExpression<Yield> returns BooleanLiteral
	 *     UnaryExpression returns BooleanLiteral
	 *     MultiplicativeExpression<Yield> returns BooleanLiteral
	 *     MultiplicativeExpression returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AdditiveExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ShiftExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0 returns BooleanLiteral
	 *     AdditiveExpression<Yield> returns BooleanLiteral
	 *     AdditiveExpression returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns BooleanLiteral
	 *     ShiftExpression<Yield> returns BooleanLiteral
	 *     ShiftExpression returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0 returns BooleanLiteral
	 *     RelationalExpression<In,Yield> returns BooleanLiteral
	 *     RelationalExpression<In> returns BooleanLiteral
	 *     RelationalExpression<Yield> returns BooleanLiteral
	 *     RelationalExpression returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0 returns BooleanLiteral
	 *     EqualityExpression<In,Yield> returns BooleanLiteral
	 *     EqualityExpression<In> returns BooleanLiteral
	 *     EqualityExpression<Yield> returns BooleanLiteral
	 *     EqualityExpression returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns BooleanLiteral
	 *     BitwiseANDExpression<In,Yield> returns BooleanLiteral
	 *     BitwiseANDExpression<In> returns BooleanLiteral
	 *     BitwiseANDExpression<Yield> returns BooleanLiteral
	 *     BitwiseANDExpression returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns BooleanLiteral
	 *     BitwiseXORExpression<In,Yield> returns BooleanLiteral
	 *     BitwiseXORExpression<In> returns BooleanLiteral
	 *     BitwiseXORExpression<Yield> returns BooleanLiteral
	 *     BitwiseXORExpression returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns BooleanLiteral
	 *     BitwiseORExpression<In,Yield> returns BooleanLiteral
	 *     BitwiseORExpression<In> returns BooleanLiteral
	 *     BitwiseORExpression<Yield> returns BooleanLiteral
	 *     BitwiseORExpression returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns BooleanLiteral
	 *     LogicalANDExpression<In,Yield> returns BooleanLiteral
	 *     LogicalANDExpression<In> returns BooleanLiteral
	 *     LogicalANDExpression<Yield> returns BooleanLiteral
	 *     LogicalANDExpression returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns BooleanLiteral
	 *     LogicalORExpression<In,Yield> returns BooleanLiteral
	 *     LogicalORExpression<In> returns BooleanLiteral
	 *     LogicalORExpression<Yield> returns BooleanLiteral
	 *     LogicalORExpression returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns BooleanLiteral
	 *     ConditionalExpression<In,Yield> returns BooleanLiteral
	 *     ConditionalExpression<In> returns BooleanLiteral
	 *     ConditionalExpression<Yield> returns BooleanLiteral
	 *     ConditionalExpression returns BooleanLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns BooleanLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns BooleanLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns BooleanLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns BooleanLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns BooleanLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns BooleanLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns BooleanLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns BooleanLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns BooleanLiteral
	 *     AssignmentExpression<In,Yield> returns BooleanLiteral
	 *     AssignmentExpression<In> returns BooleanLiteral
	 *     AssignmentExpression<Yield> returns BooleanLiteral
	 *     AssignmentExpression returns BooleanLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns BooleanLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns BooleanLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns BooleanLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns BooleanLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns BooleanLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns BooleanLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns BooleanLiteral
	 *     Expression<In,Yield> returns BooleanLiteral
	 *     Expression<In> returns BooleanLiteral
	 *     Expression<Yield> returns BooleanLiteral
	 *     Expression returns BooleanLiteral
	 *     Expression.CommaExpression_1_0<In,Yield> returns BooleanLiteral
	 *     Expression.CommaExpression_1_0<In> returns BooleanLiteral
	 *     Expression.CommaExpression_1_0<Yield> returns BooleanLiteral
	 *     Expression.CommaExpression_1_0 returns BooleanLiteral
	 *     Literal returns BooleanLiteral
	 *     BooleanLiteral returns BooleanLiteral
	 *
	 * Constraint:
	 *     true?='true'?
	 */
	protected void sequence_BooleanLiteral(ISerializationContext context, BooleanLiteral semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns BreakStatement
	 *     RootStatement<Yield> returns BreakStatement
	 *     RootStatement returns BreakStatement
	 *     Statement<Yield> returns BreakStatement
	 *     Statement returns BreakStatement
	 *     BreakStatement<Yield> returns BreakStatement
	 *     BreakStatement returns BreakStatement
	 *
	 * Constraint:
	 *     label=[LabelledStatement|BindingIdentifier]?
	 */
	protected void sequence_BreakStatement(ISerializationContext context, BreakStatement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     CaseClause<Yield> returns CaseClause
	 *     CaseClause returns CaseClause
	 *
	 * Constraint:
	 *     (expression=Expression statements+=Statement*)
	 */
	protected void sequence_CaseClause(ISerializationContext context, CaseClause semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     CastExpression<Yield> returns CastExpression
	 *     CastExpression returns CastExpression
	 *     UnaryExpression<Yield> returns CastExpression
	 *     UnaryExpression returns CastExpression
	 *     MultiplicativeExpression<Yield> returns CastExpression
	 *     MultiplicativeExpression returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AdditiveExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ShiftExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0 returns CastExpression
	 *     AdditiveExpression<Yield> returns CastExpression
	 *     AdditiveExpression returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns CastExpression
	 *     ShiftExpression<Yield> returns CastExpression
	 *     ShiftExpression returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     ShiftExpression.ShiftExpression_1_0_0 returns CastExpression
	 *     RelationalExpression<In,Yield> returns CastExpression
	 *     RelationalExpression<In> returns CastExpression
	 *     RelationalExpression<Yield> returns CastExpression
	 *     RelationalExpression returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     RelationalExpression.RelationalExpression_1_0_0 returns CastExpression
	 *     EqualityExpression<In,Yield> returns CastExpression
	 *     EqualityExpression<In> returns CastExpression
	 *     EqualityExpression<Yield> returns CastExpression
	 *     EqualityExpression returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns CastExpression
	 *     BitwiseANDExpression<In,Yield> returns CastExpression
	 *     BitwiseANDExpression<In> returns CastExpression
	 *     BitwiseANDExpression<Yield> returns CastExpression
	 *     BitwiseANDExpression returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns CastExpression
	 *     BitwiseXORExpression<In,Yield> returns CastExpression
	 *     BitwiseXORExpression<In> returns CastExpression
	 *     BitwiseXORExpression<Yield> returns CastExpression
	 *     BitwiseXORExpression returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns CastExpression
	 *     BitwiseORExpression<In,Yield> returns CastExpression
	 *     BitwiseORExpression<In> returns CastExpression
	 *     BitwiseORExpression<Yield> returns CastExpression
	 *     BitwiseORExpression returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns CastExpression
	 *     LogicalANDExpression<In,Yield> returns CastExpression
	 *     LogicalANDExpression<In> returns CastExpression
	 *     LogicalANDExpression<Yield> returns CastExpression
	 *     LogicalANDExpression returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns CastExpression
	 *     LogicalORExpression<In,Yield> returns CastExpression
	 *     LogicalORExpression<In> returns CastExpression
	 *     LogicalORExpression<Yield> returns CastExpression
	 *     LogicalORExpression returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns CastExpression
	 *     ConditionalExpression<In,Yield> returns CastExpression
	 *     ConditionalExpression<In> returns CastExpression
	 *     ConditionalExpression<Yield> returns CastExpression
	 *     ConditionalExpression returns CastExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns CastExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns CastExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns CastExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns CastExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns CastExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns CastExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns CastExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns CastExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns CastExpression
	 *     AssignmentExpression<In,Yield> returns CastExpression
	 *     AssignmentExpression<In> returns CastExpression
	 *     AssignmentExpression<Yield> returns CastExpression
	 *     AssignmentExpression returns CastExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns CastExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns CastExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns CastExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns CastExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns CastExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns CastExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns CastExpression
	 *     Expression<In,Yield> returns CastExpression
	 *     Expression<In> returns CastExpression
	 *     Expression<Yield> returns CastExpression
	 *     Expression returns CastExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns CastExpression
	 *     Expression.CommaExpression_1_0<In> returns CastExpression
	 *     Expression.CommaExpression_1_0<Yield> returns CastExpression
	 *     Expression.CommaExpression_1_0 returns CastExpression
	 *
	 * Constraint:
	 *     (expression=CastExpression_CastExpression_1_0_0_0 targetTypeRef=ArrayTypeExpression)
	 */
	protected void sequence_CastExpression(ISerializationContext context, CastExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.CAST_EXPRESSION__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.CAST_EXPRESSION__EXPRESSION));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.CAST_EXPRESSION__TARGET_TYPE_REF) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.CAST_EXPRESSION__TARGET_TYPE_REF));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getCastExpressionAccess().getCastExpressionExpressionAction_1_0_0_0(), semanticObject.getExpression());
		feeder.accept(grammarAccess.getCastExpressionAccess().getTargetTypeRefArrayTypeExpressionParserRuleCall_1_1_0(), semanticObject.getTargetTypeRef());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     CatchBlock<Yield> returns CatchBlock
	 *     CatchBlock returns CatchBlock
	 *
	 * Constraint:
	 *     (catchVariable=CatchVariable block=Block)
	 */
	protected void sequence_CatchBlock(ISerializationContext context, CatchBlock semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.CATCH_BLOCK__CATCH_VARIABLE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.CATCH_BLOCK__CATCH_VARIABLE));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.ABSTRACT_CATCH_BLOCK__BLOCK) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.ABSTRACT_CATCH_BLOCK__BLOCK));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getCatchBlockAccess().getCatchVariableCatchVariableParserRuleCall_3_0(), semanticObject.getCatchVariable());
		feeder.accept(grammarAccess.getCatchBlockAccess().getBlockBlockParserRuleCall_5_0(), semanticObject.getBlock());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     N4ClassDeclaration<Yield> returns N4ClassDeclaration
	 *     N4ClassDeclaration returns N4ClassDeclaration
	 *
	 * Constraint:
	 *     (
	 *         declaredModifiers+=N4Modifier* 
	 *         typingStrategy=TypingStrategyDefSiteOperator? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *         (
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal* 
	 *             (
	 *                 (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal*
	 *             )* 
	 *             (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)?
	 *         )? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_ClassExtendsClause_ClassImplementsList_Members_N4ClassDeclaration_TypeVariables_VersionDeclaration(ISerializationContext context, N4ClassDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     N4ClassExpression<Yield> returns N4ClassExpression
	 *     N4ClassExpression returns N4ClassExpression
	 *
	 * Constraint:
	 *     (
	 *         name=BindingIdentifier? 
	 *         (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *         (
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *             implementedInterfaceRefs+=ParameterizedTypeRefNominal* 
	 *             (
	 *                 (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)? 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal 
	 *                 implementedInterfaceRefs+=ParameterizedTypeRefNominal*
	 *             )* 
	 *             (superClassRef=ParameterizedTypeRefNominal | superClassExpression=LeftHandSideExpression)?
	 *         )? 
	 *         ownedMembersRaw+=N4MemberDeclaration*
	 *     )
	 */
	protected void sequence_ClassExtendsClause_ClassImplementsList_Members_N4ClassExpression(ISerializationContext context, N4ClassExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExportedVariableDeclarationOrBinding<Yield> returns ExportedVariableDeclaration
	 *     ExportedVariableDeclarationOrBinding returns ExportedVariableDeclaration
	 *     ExportedVariableDeclaration<Yield> returns ExportedVariableDeclaration
	 *     ExportedVariableDeclaration returns ExportedVariableDeclaration
	 *
	 * Constraint:
	 *     (annotations+=Annotation* name=BindingIdentifier declaredTypeRef=TypeRef? expression=AssignmentExpression?)
	 */
	protected void sequence_ColonSepDeclaredTypeRef_ExportedVariableDeclaration_VariableDeclarationImpl(ISerializationContext context, ExportedVariableDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     VariableDeclarationOrBinding<In,Yield,OptionalInit> returns VariableDeclaration
	 *     VariableDeclarationOrBinding<In,Yield> returns VariableDeclaration
	 *     VariableDeclarationOrBinding<In,OptionalInit> returns VariableDeclaration
	 *     VariableDeclarationOrBinding<In> returns VariableDeclaration
	 *     VariableDeclarationOrBinding<Yield,OptionalInit> returns VariableDeclaration
	 *     VariableDeclarationOrBinding<Yield> returns VariableDeclaration
	 *     VariableDeclarationOrBinding<OptionalInit> returns VariableDeclaration
	 *     VariableDeclarationOrBinding returns VariableDeclaration
	 *     VariableDeclaration<In,Yield,AllowType> returns VariableDeclaration
	 *     VariableDeclaration<In,AllowType> returns VariableDeclaration
	 *     VariableDeclaration<Yield,AllowType> returns VariableDeclaration
	 *     VariableDeclaration<AllowType> returns VariableDeclaration
	 *
	 * Constraint:
	 *     (annotations+=Annotation* name=BindingIdentifier declaredTypeRef=TypeRef? expression=AssignmentExpression?)
	 */
	protected void sequence_ColonSepDeclaredTypeRef_VariableDeclaration_VariableDeclarationImpl(ISerializationContext context, VariableDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     FunctionExpression returns FunctionExpression
	 *
	 * Constraint:
	 *     (
	 *         generator?='*'? 
	 *         (typeVars+=TypeVariable typeVars+=TypeVariable*)? 
	 *         name=BindingIdentifier? 
	 *         declaredVersion=VERSION? 
	 *         (fpars+=FormalParameter fpars+=FormalParameter*)? 
	 *         returnTypeRef=TypeRef? 
	 *         body=Block
	 *     )
	 */
	protected void sequence_ColonSepReturnTypeRef_FunctionBody_FunctionExpression_FunctionHeader_FunctionImpl_StrictFormalParameters_TypeVariables_VersionDeclaration(ISerializationContext context, FunctionExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     N4CallableConstructorDeclaration<Yield> returns N4MethodDeclaration
	 *     N4CallableConstructorDeclaration returns N4MethodDeclaration
	 *
	 * Constraint:
	 *     ((fpars+=FormalParameter fpars+=FormalParameter*)? returnTypeRef=TypeRef? body=Block?)
	 */
	protected void sequence_ColonSepReturnTypeRef_MethodParamsReturnAndBody_StrictFormalParameters(ISerializationContext context, N4MethodDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     JSXElementNameExpression returns ParameterizedPropertyAccessExpression
	 *     JSXElementNameExpression.ParameterizedPropertyAccessExpression_1_0 returns ParameterizedPropertyAccessExpression
	 *
	 * Constraint:
	 *     (
	 *         target=JSXElementNameExpression_ParameterizedPropertyAccessExpression_1_0 
	 *         (typeArgs+=TypeRef typeArgs+=TypeRef*)? 
	 *         property=[IdentifiableElement|IdentifierName]
	 *     )
	 */
	protected void sequence_ConcreteTypeArguments_JSXElementNameExpression_ParameterizedPropertyAccessExpressionTail(ISerializationContext context, ParameterizedPropertyAccessExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     LeftHandSideExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     PostfixExpression.PostfixExpression_1_0_0 returns ParameterizedPropertyAccessExpression
	 *     CastExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     CastExpression.CastExpression_1_0_0_0 returns ParameterizedPropertyAccessExpression
	 *     UnaryExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     UnaryExpression returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0 returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ShiftExpression.ShiftExpression_1_0_0 returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression<In> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     RelationalExpression.RelationalExpression_1_0_0 returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression<In> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression<In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression<In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression<In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression<In> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression<In> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression<In> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns ParameterizedPropertyAccessExpression
	 *     AssignmentExpression<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     AssignmentExpression<In> returns ParameterizedPropertyAccessExpression
	 *     AssignmentExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     AssignmentExpression returns ParameterizedPropertyAccessExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns ParameterizedPropertyAccessExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns ParameterizedPropertyAccessExpression
	 *     Expression<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     Expression<In> returns ParameterizedPropertyAccessExpression
	 *     Expression<Yield> returns ParameterizedPropertyAccessExpression
	 *     Expression returns ParameterizedPropertyAccessExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns ParameterizedPropertyAccessExpression
	 *     Expression.CommaExpression_1_0<In> returns ParameterizedPropertyAccessExpression
	 *     Expression.CommaExpression_1_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     Expression.CommaExpression_1_0 returns ParameterizedPropertyAccessExpression
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             target=LeftHandSideExpression_ParameterizedPropertyAccessExpression_1_2_2_0 | 
	 *             target=MemberExpression_ParameterizedPropertyAccessExpression_1_3_3_1_0 | 
	 *             target=MemberExpression_ParameterizedPropertyAccessExpression_2_1_1_0
	 *         ) 
	 *         (typeArgs+=TypeRef typeArgs+=TypeRef*)? 
	 *         property=[IdentifiableElement|IdentifierName]
	 *     )
	 */
	protected void sequence_ConcreteTypeArguments_LeftHandSideExpression_MemberExpression_ParameterizedPropertyAccessExpressionTail(ISerializationContext context, ParameterizedPropertyAccessExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<PostfixExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_2_0_0 returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<PostfixExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.IndexedAccessExpression_1_2_1_0 returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<PostfixExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedPropertyAccessExpression_1_2_2_0 returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<PostfixExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.TaggedTemplateString_1_2_3_0_0 returns ParameterizedPropertyAccessExpression
	 *
	 * Constraint:
	 *     (
	 *         target=LeftHandSideExpression_ParameterizedPropertyAccessExpression_1_2_2_0 
	 *         (typeArgs+=TypeRef typeArgs+=TypeRef*)? 
	 *         property=[IdentifiableElement|IdentifierName]
	 *     )
	 */
	protected void sequence_ConcreteTypeArguments_LeftHandSideExpression_ParameterizedPropertyAccessExpressionTail_IndexedAccessExpression_1_2_1_0_ParameterizedCallExpression_1_2_0_0_ParameterizedPropertyAccessExpression_1_2_2_0_TaggedTemplateString_1_2_3_0_0(ISerializationContext context, ParameterizedPropertyAccessExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LeftHandSideExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<PostfixExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_1_3_3_0_0 returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LeftHandSideExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<PostfixExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_1_3_3_1_0 returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LeftHandSideExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<PostfixExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_1_3_3_2_0 returns ParameterizedPropertyAccessExpression
	 *
	 * Constraint:
	 *     (
	 *         target=MemberExpression_ParameterizedPropertyAccessExpression_1_3_3_1_0 
	 *         (typeArgs+=TypeRef typeArgs+=TypeRef*)? 
	 *         property=[IdentifiableElement|IdentifierName]
	 *     )
	 */
	protected void sequence_ConcreteTypeArguments_MemberExpression_ParameterizedPropertyAccessExpressionTail_IndexedAccessExpression_1_3_3_0_0_ParameterizedPropertyAccessExpression_1_3_3_1_0_TaggedTemplateString_1_3_3_2_0(ISerializationContext context, ParameterizedPropertyAccessExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LeftHandSideExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<PostfixExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0 returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LeftHandSideExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<PostfixExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0 returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LeftHandSideExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<PostfixExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression.TaggedTemplateString_2_1_2_0 returns ParameterizedPropertyAccessExpression
	 *
	 * Constraint:
	 *     (
	 *         target=MemberExpression_ParameterizedPropertyAccessExpression_2_1_1_0 
	 *         (typeArgs+=TypeRef typeArgs+=TypeRef*)? 
	 *         property=[IdentifiableElement|IdentifierName]
	 *     )
	 */
	protected void sequence_ConcreteTypeArguments_MemberExpression_ParameterizedPropertyAccessExpressionTail_IndexedAccessExpression_2_1_0_0_ParameterizedPropertyAccessExpression_2_1_1_0_TaggedTemplateString_2_1_2_0(ISerializationContext context, ParameterizedPropertyAccessExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<PostfixExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<CastExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<UnaryExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<MultiplicativeExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AdditiveExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ShiftExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In,Expression.Yield> returns ParameterizedPropertyAccessExpression
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0 returns ParameterizedPropertyAccessExpression
	 *     MemberExpression<Yield> returns ParameterizedPropertyAccessExpression
	 *     MemberExpression returns ParameterizedPropertyAccessExpression
	 *
	 * Constraint:
	 *     (
	 *         (target=MemberExpression_ParameterizedPropertyAccessExpression_1_3_3_1_0 | target=MemberExpression_ParameterizedPropertyAccessExpression_2_1_1_0) 
	 *         (typeArgs+=TypeRef typeArgs+=TypeRef*)? 
	 *         property=[IdentifiableElement|IdentifierName]
	 *     )
	 */
	protected void sequence_ConcreteTypeArguments_MemberExpression_ParameterizedPropertyAccessExpressionTail(ISerializationContext context, ParameterizedPropertyAccessExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ConditionalExpression<In,Yield> returns ConditionalExpression
	 *     ConditionalExpression<In> returns ConditionalExpression
	 *     ConditionalExpression<Yield> returns ConditionalExpression
	 *     ConditionalExpression returns ConditionalExpression
	 *     AssignmentExpression<In,Yield> returns ConditionalExpression
	 *     AssignmentExpression<In> returns ConditionalExpression
	 *     AssignmentExpression<Yield> returns ConditionalExpression
	 *     AssignmentExpression returns ConditionalExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns ConditionalExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns ConditionalExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns ConditionalExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns ConditionalExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns ConditionalExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns ConditionalExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns ConditionalExpression
	 *     Expression<In,Yield> returns ConditionalExpression
	 *     Expression<In> returns ConditionalExpression
	 *     Expression<Yield> returns ConditionalExpression
	 *     Expression returns ConditionalExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns ConditionalExpression
	 *     Expression.CommaExpression_1_0<In> returns ConditionalExpression
	 *     Expression.CommaExpression_1_0<Yield> returns ConditionalExpression
	 *     Expression.CommaExpression_1_0 returns ConditionalExpression
	 *
	 * Constraint:
	 *     (expression=ConditionalExpression_ConditionalExpression_1_0_0_0 trueExpression=AssignmentExpression falseExpression=AssignmentExpression)
	 */
	protected void sequence_ConditionalExpression(ISerializationContext context, ConditionalExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.CONDITIONAL_EXPRESSION__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.CONDITIONAL_EXPRESSION__EXPRESSION));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.CONDITIONAL_EXPRESSION__TRUE_EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.CONDITIONAL_EXPRESSION__TRUE_EXPRESSION));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.CONDITIONAL_EXPRESSION__FALSE_EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.CONDITIONAL_EXPRESSION__FALSE_EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getConditionalExpressionAccess().getConditionalExpressionExpressionAction_1_0_0_0(), semanticObject.getExpression());
		feeder.accept(grammarAccess.getConditionalExpressionAccess().getTrueExpressionAssignmentExpressionParserRuleCall_1_1_0(), semanticObject.getTrueExpression());
		feeder.accept(grammarAccess.getConditionalExpressionAccess().getFalseExpressionAssignmentExpressionParserRuleCall_1_3_0(), semanticObject.getFalseExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns ContinueStatement
	 *     RootStatement<Yield> returns ContinueStatement
	 *     RootStatement returns ContinueStatement
	 *     Statement<Yield> returns ContinueStatement
	 *     Statement returns ContinueStatement
	 *     ContinueStatement<Yield> returns ContinueStatement
	 *     ContinueStatement returns ContinueStatement
	 *
	 * Constraint:
	 *     label=[LabelledStatement|BindingIdentifier]?
	 */
	protected void sequence_ContinueStatement(ISerializationContext context, ContinueStatement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns DebuggerStatement
	 *     RootStatement<Yield> returns DebuggerStatement
	 *     RootStatement returns DebuggerStatement
	 *     Statement<Yield> returns DebuggerStatement
	 *     Statement returns DebuggerStatement
	 *     DebuggerStatement returns DebuggerStatement
	 *
	 * Constraint:
	 *     {DebuggerStatement}
	 */
	protected void sequence_DebuggerStatement(ISerializationContext context, DebuggerStatement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     DefaultClause<Yield> returns DefaultClause
	 *     DefaultClause returns DefaultClause
	 *
	 * Constraint:
	 *     statements+=Statement*
	 */
	protected void sequence_DefaultClause(ISerializationContext context, DefaultClause semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     DefaultImportSpecifier returns DefaultImportSpecifier
	 *
	 * Constraint:
	 *     importedElement=[TExportableElement|BindingIdentifier]
	 */
	protected void sequence_DefaultImportSpecifier(ISerializationContext context, DefaultImportSpecifier semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.NAMED_IMPORT_SPECIFIER__IMPORTED_ELEMENT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.NAMED_IMPORT_SPECIFIER__IMPORTED_ELEMENT));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDefaultImportSpecifierAccess().getImportedElementTExportableElementBindingIdentifierParserRuleCall_0_1(), semanticObject.eGet(N4JSPackage.Literals.NAMED_IMPORT_SPECIFIER__IMPORTED_ELEMENT, false));
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns DoStatement
	 *     RootStatement<Yield> returns DoStatement
	 *     RootStatement returns DoStatement
	 *     Statement<Yield> returns DoStatement
	 *     Statement returns DoStatement
	 *     IterationStatement<Yield> returns DoStatement
	 *     IterationStatement returns DoStatement
	 *     DoStatement<Yield> returns DoStatement
	 *     DoStatement returns DoStatement
	 *
	 * Constraint:
	 *     (statement=Statement expression=Expression)
	 */
	protected void sequence_DoStatement(ISerializationContext context, DoStatement semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.ITERATION_STATEMENT__STATEMENT) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.ITERATION_STATEMENT__STATEMENT));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.ITERATION_STATEMENT__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.ITERATION_STATEMENT__EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDoStatementAccess().getStatementStatementParserRuleCall_1_0(), semanticObject.getStatement());
		feeder.accept(grammarAccess.getDoStatementAccess().getExpressionExpressionParserRuleCall_4_0(), semanticObject.getExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     PrimaryExpression<Yield> returns DoubleLiteral
	 *     PrimaryExpression returns DoubleLiteral
	 *     LeftHandSideExpression<Yield> returns DoubleLiteral
	 *     LeftHandSideExpression returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<PostfixExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<CastExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<UnaryExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<MultiplicativeExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AdditiveExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ShiftExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In,RelationalExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In,EqualityExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0 returns DoubleLiteral
	 *     MemberExpression<Yield> returns DoubleLiteral
	 *     MemberExpression returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LeftHandSideExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<PostfixExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<CastExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<UnaryExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<MultiplicativeExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AdditiveExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ShiftExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0 returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LeftHandSideExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<PostfixExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<CastExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<UnaryExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<MultiplicativeExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AdditiveExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ShiftExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In,RelationalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In,EqualityExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0 returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LeftHandSideExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<PostfixExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<CastExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<UnaryExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<MultiplicativeExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AdditiveExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ShiftExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In,RelationalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In,EqualityExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0 returns DoubleLiteral
	 *     PostfixExpression<Yield> returns DoubleLiteral
	 *     PostfixExpression returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<CastExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<UnaryExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<MultiplicativeExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AdditiveExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ShiftExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0 returns DoubleLiteral
	 *     CastExpression<Yield> returns DoubleLiteral
	 *     CastExpression returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<UnaryExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<MultiplicativeExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AdditiveExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ShiftExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     CastExpression.CastExpression_1_0_0_0 returns DoubleLiteral
	 *     UnaryExpression<Yield> returns DoubleLiteral
	 *     UnaryExpression returns DoubleLiteral
	 *     MultiplicativeExpression<Yield> returns DoubleLiteral
	 *     MultiplicativeExpression returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AdditiveExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ShiftExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     MultiplicativeExpression.MultiplicativeExpression_1_0_0_0 returns DoubleLiteral
	 *     AdditiveExpression<Yield> returns DoubleLiteral
	 *     AdditiveExpression returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ShiftExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<RelationalExpression.In,RelationalExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<EqualityExpression.In,EqualityExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     AdditiveExpression.AdditiveExpression_1_0_0_0 returns DoubleLiteral
	 *     ShiftExpression<Yield> returns DoubleLiteral
	 *     ShiftExpression returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     ShiftExpression.ShiftExpression_1_0_0 returns DoubleLiteral
	 *     RelationalExpression<In,Yield> returns DoubleLiteral
	 *     RelationalExpression<In> returns DoubleLiteral
	 *     RelationalExpression<Yield> returns DoubleLiteral
	 *     RelationalExpression returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<In,Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<In> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     RelationalExpression.RelationalExpression_1_0_0 returns DoubleLiteral
	 *     EqualityExpression<In,Yield> returns DoubleLiteral
	 *     EqualityExpression<In> returns DoubleLiteral
	 *     EqualityExpression<Yield> returns DoubleLiteral
	 *     EqualityExpression returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns DoubleLiteral
	 *     BitwiseANDExpression<In,Yield> returns DoubleLiteral
	 *     BitwiseANDExpression<In> returns DoubleLiteral
	 *     BitwiseANDExpression<Yield> returns DoubleLiteral
	 *     BitwiseANDExpression returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns DoubleLiteral
	 *     BitwiseXORExpression<In,Yield> returns DoubleLiteral
	 *     BitwiseXORExpression<In> returns DoubleLiteral
	 *     BitwiseXORExpression<Yield> returns DoubleLiteral
	 *     BitwiseXORExpression returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns DoubleLiteral
	 *     BitwiseORExpression<In,Yield> returns DoubleLiteral
	 *     BitwiseORExpression<In> returns DoubleLiteral
	 *     BitwiseORExpression<Yield> returns DoubleLiteral
	 *     BitwiseORExpression returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns DoubleLiteral
	 *     LogicalANDExpression<In,Yield> returns DoubleLiteral
	 *     LogicalANDExpression<In> returns DoubleLiteral
	 *     LogicalANDExpression<Yield> returns DoubleLiteral
	 *     LogicalANDExpression returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns DoubleLiteral
	 *     LogicalORExpression<In,Yield> returns DoubleLiteral
	 *     LogicalORExpression<In> returns DoubleLiteral
	 *     LogicalORExpression<Yield> returns DoubleLiteral
	 *     LogicalORExpression returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns DoubleLiteral
	 *     ConditionalExpression<In,Yield> returns DoubleLiteral
	 *     ConditionalExpression<In> returns DoubleLiteral
	 *     ConditionalExpression<Yield> returns DoubleLiteral
	 *     ConditionalExpression returns DoubleLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns DoubleLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns DoubleLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns DoubleLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns DoubleLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns DoubleLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns DoubleLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns DoubleLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns DoubleLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns DoubleLiteral
	 *     AssignmentExpression<In,Yield> returns DoubleLiteral
	 *     AssignmentExpression<In> returns DoubleLiteral
	 *     AssignmentExpression<Yield> returns DoubleLiteral
	 *     AssignmentExpression returns DoubleLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns DoubleLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns DoubleLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns DoubleLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns DoubleLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns DoubleLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns DoubleLiteral
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns DoubleLiteral
	 *     Expression<In,Yield> returns DoubleLiteral
	 *     Expression<In> returns DoubleLiteral
	 *     Expression<Yield> returns DoubleLiteral
	 *     Expression returns DoubleLiteral
	 *     Expression.CommaExpression_1_0<In,Yield> returns DoubleLiteral
	 *     Expression.CommaExpression_1_0<In> returns DoubleLiteral
	 *     Expression.CommaExpression_1_0<Yield> returns DoubleLiteral
	 *     Expression.CommaExpression_1_0 returns DoubleLiteral
	 *     Literal returns DoubleLiteral
	 *     NumericLiteral returns DoubleLiteral
	 *     DoubleLiteral returns DoubleLiteral
	 *
	 * Constraint:
	 *     value=DOUBLE
	 */
	protected void sequence_DoubleLiteral(ISerializationContext context, DoubleLiteral semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.NUMERIC_LITERAL__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.NUMERIC_LITERAL__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDoubleLiteralAccess().getValueDOUBLETerminalRuleCall_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Elision returns BindingElement
	 *
	 * Constraint:
	 *     {BindingElement}
	 */
	protected void sequence_Elision(ISerializationContext context, BindingElement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns EmptyStatement
	 *     RootStatement<Yield> returns EmptyStatement
	 *     RootStatement returns EmptyStatement
	 *     Statement<Yield> returns EmptyStatement
	 *     Statement returns EmptyStatement
	 *     EmptyStatement returns EmptyStatement
	 *
	 * Constraint:
	 *     {EmptyStatement}
	 */
	protected void sequence_EmptyStatement(ISerializationContext context, EmptyStatement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     EqualityExpression<In,Yield> returns EqualityExpression
	 *     EqualityExpression<In> returns EqualityExpression
	 *     EqualityExpression<Yield> returns EqualityExpression
	 *     EqualityExpression returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In,Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<In> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0<Expression.In,Expression.Yield> returns EqualityExpression
	 *     EqualityExpression.EqualityExpression_1_0_0_0 returns EqualityExpression
	 *     BitwiseANDExpression<In,Yield> returns EqualityExpression
	 *     BitwiseANDExpression<In> returns EqualityExpression
	 *     BitwiseANDExpression<Yield> returns EqualityExpression
	 *     BitwiseANDExpression returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<In> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns EqualityExpression
	 *     BitwiseANDExpression.BinaryBitwiseExpression_1_0_0_0 returns EqualityExpression
	 *     BitwiseXORExpression<In,Yield> returns EqualityExpression
	 *     BitwiseXORExpression<In> returns EqualityExpression
	 *     BitwiseXORExpression<Yield> returns EqualityExpression
	 *     BitwiseXORExpression returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns EqualityExpression
	 *     BitwiseXORExpression.BinaryBitwiseExpression_1_0_0_0 returns EqualityExpression
	 *     BitwiseORExpression<In,Yield> returns EqualityExpression
	 *     BitwiseORExpression<In> returns EqualityExpression
	 *     BitwiseORExpression<Yield> returns EqualityExpression
	 *     BitwiseORExpression returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In,Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<In> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0<Expression.In,Expression.Yield> returns EqualityExpression
	 *     BitwiseORExpression.BinaryBitwiseExpression_1_0_0_0 returns EqualityExpression
	 *     LogicalANDExpression<In,Yield> returns EqualityExpression
	 *     LogicalANDExpression<In> returns EqualityExpression
	 *     LogicalANDExpression<Yield> returns EqualityExpression
	 *     LogicalANDExpression returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<In> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.Yield> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns EqualityExpression
	 *     LogicalANDExpression.BinaryLogicalExpression_1_0_0_0 returns EqualityExpression
	 *     LogicalORExpression<In,Yield> returns EqualityExpression
	 *     LogicalORExpression<In> returns EqualityExpression
	 *     LogicalORExpression<Yield> returns EqualityExpression
	 *     LogicalORExpression returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In,Yield> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<In> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Yield> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.Yield> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.Yield> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.Yield> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0<Expression.In,Expression.Yield> returns EqualityExpression
	 *     LogicalORExpression.BinaryLogicalExpression_1_0_0_0 returns EqualityExpression
	 *     ConditionalExpression<In,Yield> returns EqualityExpression
	 *     ConditionalExpression<In> returns EqualityExpression
	 *     ConditionalExpression<Yield> returns EqualityExpression
	 *     ConditionalExpression returns EqualityExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In,Yield> returns EqualityExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<In> returns EqualityExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Yield> returns EqualityExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In> returns EqualityExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.Yield> returns EqualityExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns EqualityExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In> returns EqualityExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.Yield> returns EqualityExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0<Expression.In,Expression.Yield> returns EqualityExpression
	 *     ConditionalExpression.ConditionalExpression_1_0_0_0 returns EqualityExpression
	 *     AssignmentExpression<In,Yield> returns EqualityExpression
	 *     AssignmentExpression<In> returns EqualityExpression
	 *     AssignmentExpression<Yield> returns EqualityExpression
	 *     AssignmentExpression returns EqualityExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In,Yield> returns EqualityExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<In> returns EqualityExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Yield> returns EqualityExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In> returns EqualityExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.Yield> returns EqualityExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0<Expression.In,Expression.Yield> returns EqualityExpression
	 *     AssignmentExpression.AssignmentExpression_4_1_0_0_0 returns EqualityExpression
	 *     Expression<In,Yield> returns EqualityExpression
	 *     Expression<In> returns EqualityExpression
	 *     Expression<Yield> returns EqualityExpression
	 *     Expression returns EqualityExpression
	 *     Expression.CommaExpression_1_0<In,Yield> returns EqualityExpression
	 *     Expression.CommaExpression_1_0<In> returns EqualityExpression
	 *     Expression.CommaExpression_1_0<Yield> returns EqualityExpression
	 *     Expression.CommaExpression_1_0 returns EqualityExpression
	 *
	 * Constraint:
	 *     (lhs=EqualityExpression_EqualityExpression_1_0_0_0 op=EqualityOperator rhs=RelationalExpression)
	 */
	protected void sequence_EqualityExpression(ISerializationContext context, EqualityExpression semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.EQUALITY_EXPRESSION__LHS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.EQUALITY_EXPRESSION__LHS));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.EQUALITY_EXPRESSION__OP) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.EQUALITY_EXPRESSION__OP));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.EQUALITY_EXPRESSION__RHS) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.EQUALITY_EXPRESSION__RHS));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEqualityExpressionAccess().getEqualityExpressionLhsAction_1_0_0_0(), semanticObject.getLhs());
		feeder.accept(grammarAccess.getEqualityExpressionAccess().getOpEqualityOperatorEnumRuleCall_1_0_0_1_0(), semanticObject.getOp());
		feeder.accept(grammarAccess.getEqualityExpressionAccess().getRhsRelationalExpressionParserRuleCall_1_1_0(), semanticObject.getRhs());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ExportDeclaration returns ExportDeclaration
	 *
	 * Constraint:
	 *     (
	 *         (wildcardExport?='*'? reexportedFrom=[TModule|ModuleSpecifier]?) | 
	 *         exportedElement=ExportableElement | 
	 *         (defaultExport?='default' (exportedElement=ExportableElement | defaultExportedExpression=AssignmentExpression)) | 
	 *         (namedExports+=ExportSpecifier namedExports+=ExportSpecifier* reexportedFrom=[TModule|ModuleSpecifier]?)
	 *     )?
	 */
	protected void sequence_ExportClause_ExportDeclaration_ExportDeclarationImpl_ExportFromClause(ISerializationContext context, ExportDeclaration semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExportSpecifier returns ExportSpecifier
	 *
	 * Constraint:
	 *     (element=IdentifierRef alias=IdentifierName?)
	 */
	protected void sequence_ExportSpecifier(ISerializationContext context, ExportSpecifier semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExportedVariableDeclarationOrBinding<Yield> returns ExportedVariableBinding
	 *     ExportedVariableDeclarationOrBinding returns ExportedVariableBinding
	 *     ExportedVariableBinding<Yield> returns ExportedVariableBinding
	 *     ExportedVariableBinding returns ExportedVariableBinding
	 *
	 * Constraint:
	 *     (pattern=BindingPattern expression=AssignmentExpression)
	 */
	protected void sequence_ExportedVariableBinding(ISerializationContext context, ExportedVariableBinding semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.VARIABLE_BINDING__PATTERN) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.VARIABLE_BINDING__PATTERN));
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.VARIABLE_BINDING__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.VARIABLE_BINDING__EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getExportedVariableBindingAccess().getPatternBindingPatternParserRuleCall_0_0(), semanticObject.getPattern());
		feeder.accept(grammarAccess.getExportedVariableBindingAccess().getExpressionAssignmentExpressionParserRuleCall_2_0(), semanticObject.getExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ExportedVariableStatement returns ExportedVariableStatement
	 *
	 * Constraint:
	 *     (
	 *         declaredModifiers+=N4Modifier* 
	 *         varStmtKeyword=VariableStatementKeyword 
	 *         varDeclsOrBindings+=ExportedVariableDeclarationOrBinding 
	 *         varDeclsOrBindings+=ExportedVariableDeclarationOrBinding*
	 *     )
	 */
	protected void sequence_ExportedVariableStatement(ISerializationContext context, ExportedVariableStatement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<PrimaryExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<LeftHandSideExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<MemberExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<PostfixExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<CastExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<UnaryExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<MultiplicativeExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<AdditiveExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<ShiftExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<RelationalExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<RelationalExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<EqualityExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<EqualityExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<BitwiseANDExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<BitwiseANDExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<BitwiseXORExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<BitwiseXORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<BitwiseORExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<BitwiseORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<LogicalANDExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<LogicalANDExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<LogicalORExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<LogicalORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<ConditionalExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<ConditionalExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<AssignmentExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<AssignmentExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<Expression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<Expression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0<Expression.In,Expression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.N4ClassExpression_1_0_0 returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<PrimaryExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<LeftHandSideExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<MemberExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<PostfixExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<CastExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<UnaryExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<MultiplicativeExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<AdditiveExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<ShiftExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<RelationalExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<RelationalExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<RelationalExpression.In,RelationalExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<EqualityExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<EqualityExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<EqualityExpression.In,EqualityExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<BitwiseANDExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<BitwiseANDExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<BitwiseXORExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<BitwiseXORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<BitwiseORExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<BitwiseORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<LogicalANDExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<LogicalANDExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<LogicalORExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<LogicalORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<ConditionalExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<ConditionalExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<AssignmentExpression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<AssignmentExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<Expression.In> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<Expression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0<Expression.In,Expression.Yield> returns ExpressionAnnotationList
	 *     AnnotatedExpression.FunctionExpression_1_1_0 returns ExpressionAnnotationList
	 *     ExpressionAnnotationList returns ExpressionAnnotationList
	 *
	 * Constraint:
	 *     annotations+=Annotation+
	 */
	protected void sequence_ExpressionAnnotationList(ISerializationContext context, ExpressionAnnotationList semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ExpressionDisguisedAsBlock<In> returns Block
	 *     ExpressionDisguisedAsBlock returns Block
	 *
	 * Constraint:
	 *     statements+=AssignmentExpressionStatement
	 */
	protected void sequence_ExpressionDisguisedAsBlock(ISerializationContext context, Block semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns ExpressionStatement
	 *     RootStatement<Yield> returns ExpressionStatement
	 *     RootStatement returns ExpressionStatement
	 *     Statement<Yield> returns ExpressionStatement
	 *     Statement returns ExpressionStatement
	 *     ExpressionStatement<Yield> returns ExpressionStatement
	 *     ExpressionStatement returns ExpressionStatement
	 *
	 * Constraint:
	 *     expression=Expression
	 */
	protected void sequence_ExpressionStatement(ISerializationContext context, ExpressionStatement semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.EXPRESSION_STATEMENT__EXPRESSION) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.EXPRESSION_STATEMENT__EXPRESSION));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getExpressionStatementAccess().getExpressionExpressionParserRuleCall_0_0(), semanticObject.getExpression());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     Expression<In,Yield> returns CommaExpression
	 *     Expression<In> returns CommaExpression
	 *     Expression<Yield> returns CommaExpression
	 *     Expression returns CommaExpression
	 *
	 * Constraint:
	 *     (exprs+=Expression_CommaExpression_1_0 exprs+=AssignmentExpression exprs+=AssignmentExpression*)
	 */
	protected void sequence_Expression(ISerializationContext context, CommaExpression semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     FinallyBlock<Yield> returns FinallyBlock
	 *     FinallyBlock returns FinallyBlock
	 *
	 * Constraint:
	 *     block=Block
	 */
	protected void sequence_FinallyBlock(ISerializationContext context, FinallyBlock semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, N4JSPackage.Literals.ABSTRACT_CATCH_BLOCK__BLOCK) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, N4JSPackage.Literals.ABSTRACT_CATCH_BLOCK__BLOCK));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getFinallyBlockAccess().getBlockBlockParserRuleCall_2_0(), semanticObject.getBlock());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     ScriptElement returns ForStatement
	 *     RootStatement<Yield> returns ForStatement
	 *     RootStatement returns ForStatement
	 *     Statement<Yield> returns ForStatement
	 *     Statement returns ForStatement
	 *     IterationStatement<Yield> returns ForStatement
	 *     IterationStatement returns ForStatement
	 *     ForStatement<Yield> returns ForStatement
	 *     ForStatement returns ForStatement
	 *
	 * Constraint:
	 *     (
	 *         (
	 *             (initExpr=LetIdentifierRef forIn?='in' expression=Expression) | 
	 *             (
	 *                 varStmtKeyword=VariableStatementKeyword 
	 *                 (
	 *                     (varDeclsOrBindings+=BindingIdentifierAsVariableDeclaration (forIn?='in' | forOf?='of') expression=AssignmentExpression?) | 
	 *                     (
	 *                         varDeclsOrBindings+=VariableDeclarationOrBinding 
	 *                         (
	 *                             (varDeclsOrBindings+=VariableDeclarationOrBinding* expression=Expression? updateExpr=Expression?) | 
	 *                             (forIn?='in' expression=Expression?) | 
	 *                             (forOf?='of' expression=AssignmentExpression?)
	 *                         )
	 *                     )
	 *                 )
	 *             ) | 
	 *             (
	 *                 initExpr=Expression 
	 *                 ((expression=Expression? updateExpr=Expression?) | (forIn?='in' expression=Expression?) | (forOf?='of' expression=AssignmentExpression?))
	 *             ) | 
	 *             (expression=Expression? updateExpr=Expression?)
	 *         ) 
	 *         statement=Statement
	 *     )
	 */
	protected void sequence_ForStatement(ISerializationContext context, ForStatement semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     PrimaryExpression<Yield> returns HexIntLiteral
	 *     PrimaryExpression returns HexIntLiteral
	 *     LeftHandSideExpression<Yield> returns HexIntLiteral
	 *     LeftHandSideExpression returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<PostfixExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<CastExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<UnaryExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<MultiplicativeExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AdditiveExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ShiftExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<RelationalExpression.In,RelationalExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<EqualityExpression.In,EqualityExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0<Expression.In,Expression.Yield> returns HexIntLiteral
	 *     LeftHandSideExpression.ParameterizedCallExpression_1_0 returns HexIntLiteral
	 *     MemberExpression<Yield> returns HexIntLiteral
	 *     MemberExpression returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LeftHandSideExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<PostfixExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<CastExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<UnaryExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<MultiplicativeExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AdditiveExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ShiftExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<LogicalORExpression.In,LogicalORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<ConditionalExpression.In,ConditionalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<AssignmentExpression.In,AssignmentExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0<Expression.In,Expression.Yield> returns HexIntLiteral
	 *     MemberExpression.IndexedAccessExpression_2_1_0_0 returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LeftHandSideExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<PostfixExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<CastExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<UnaryExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<MultiplicativeExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AdditiveExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ShiftExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<RelationalExpression.In,RelationalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<EqualityExpression.In,EqualityExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<LogicalORExpression.In,LogicalORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<ConditionalExpression.In,ConditionalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<AssignmentExpression.In,AssignmentExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0<Expression.In,Expression.Yield> returns HexIntLiteral
	 *     MemberExpression.ParameterizedPropertyAccessExpression_2_1_1_0 returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LeftHandSideExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<PostfixExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<CastExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<UnaryExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<MultiplicativeExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AdditiveExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ShiftExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<RelationalExpression.In,RelationalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<EqualityExpression.In,EqualityExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseANDExpression.In,BitwiseANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseXORExpression.In,BitwiseXORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<BitwiseORExpression.In,BitwiseORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalANDExpression.In,LogicalANDExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<LogicalORExpression.In,LogicalORExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<ConditionalExpression.In,ConditionalExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<AssignmentExpression.In,AssignmentExpression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0<Expression.In,Expression.Yield> returns HexIntLiteral
	 *     MemberExpression.TaggedTemplateString_2_1_2_0 returns HexIntLiteral
	 *     PostfixExpression<Yield> returns HexIntLiteral
	 *     PostfixExpression returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<Yield> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<CastExpression.Yield> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<UnaryExpression.Yield> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<MultiplicativeExpression.Yield> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<AdditiveExpression.Yield> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<ShiftExpression.Yield> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.Yield> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<RelationalExpression.In,RelationalExpression.Yield> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.Yield> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<EqualityExpression.In,EqualityExpression.Yield> returns HexIntLiteral
	 *     PostfixExpression.PostfixExpression_1_0_0<BitwiseANDExpression.In> r