/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.validation.validators;

import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Helper class extracted from N4JSAllMemberValidator
 */
@SuppressWarnings("all")
public class FindClassifierInHierarchyUtils {
  public static Iterable<ParameterizedTypeRef> findSuperTypesWithMember(final N4ClassifierDefinition classifier, final TMember member) {
    final Function1<ParameterizedTypeRef, Boolean> _function = (ParameterizedTypeRef typeRef) -> {
      Type _declaredType = null;
      if (typeRef!=null) {
        _declaredType=typeRef.getDeclaredType();
      }
      final Type declType = _declaredType;
      boolean _xifexpression = false;
      if ((declType instanceof ContainerType<?>)) {
        _xifexpression = ((ContainerType<?>)declType).getOwnedMembers().contains(member);
      } else {
        _xifexpression = false;
      }
      return Boolean.valueOf(_xifexpression);
    };
    return IterableExtensions.<ParameterizedTypeRef>filter(classifier.getSuperClassifierRefs(), _function);
  }
}
