/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.n4JS.VariableStatementKeyword;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

/**
 * Validations that implement warnings unrelated to the N4JS language. They hint towards limitations and problems in
 * third-party tools that are commonly used together with N4JS (e.g. Babel).
 */
@SuppressWarnings("all")
public class ThirdPartyValidator extends AbstractN4JSDeclarativeValidator {
  /**
   * NEEEDED
   * 
   * when removed check methods will be called twice once by N4JSValidator, and once by
   * AbstractDeclarativeN4JSValidator
   */
  @Override
  public void register(final EValidatorRegistrar registrar) {
  }
  
  /**
   * Adds warning for <a href="https://github.com/babel/babel/issues/6302">Babel issue #6302</a>.
   * <p>
   * This can be removed once the corresponding test file compiles without errors in Babel:<br>
   * {@code /org.eclipse.n4js.spec.tests/xpect-tests/Others/ThirdParty_Babel_LetConstInFunctionExpression.n4js.xt}.
   */
  @Check
  public void checkLetConstInFunctionExpression(final FunctionExpression funExpr) {
    final String funName = funExpr.getName();
    if ((funName != null)) {
      EList<Statement> _statements = funExpr.getBody().getStatements();
      for (final Statement stmnt : _statements) {
        if ((stmnt instanceof VariableStatement)) {
          if (((((VariableStatement)stmnt).getVarStmtKeyword() == VariableStatementKeyword.LET) || (((VariableStatement)stmnt).getVarStmtKeyword() == VariableStatementKeyword.CONST))) {
            EList<VariableDeclaration> _varDecl = ((VariableStatement)stmnt).getVarDecl();
            for (final VariableDeclaration varDecl : _varDecl) {
              String _name = varDecl.getName();
              boolean _equals = Objects.equal(_name, funName);
              if (_equals) {
                this.addIssue(IssueCodes.getMessageForTHIRD_PARTY_BABEL_LET_CONST_IN_FUN_EXPR(), varDecl, TypesPackage.eINSTANCE.getIdentifiableElement_Name(), 
                  IssueCodes.THIRD_PARTY_BABEL_LET_CONST_IN_FUN_EXPR);
              }
            }
          }
        }
      }
    }
  }
}
