/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ts.ui.contentassist;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.ui.contentassist.AbstractTypeExpressionsProposalProvider;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.util.ReflectExtensions;

/**
 * see http://www.eclipse.org/Xtext/documentation.html#contentAssist on how to customize content assistant
 */
@SuppressWarnings("all")
public class TypeExpressionsProposalProvider extends AbstractTypeExpressionsProposalProvider {
  public static class LogErrorHandler<RT extends Object> implements PolymorphicDispatcher.ErrorHandler<RT> {
    private final Logger logger;
    
    public LogErrorHandler(final Logger logger) {
      this.logger = logger;
    }
    
    @Override
    public RT handle(final Object[] params, final Throwable throwable) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Error in polymorphic dispatcher : ");
      String _message = throwable.getMessage();
      _builder.append(_message);
      this.logger.error(_builder, throwable);
      return null;
    }
  }
  
  private static final Logger log = Logger.getLogger(TypeExpressionsProposalProvider.class);
  
  private final ReflectExtensions reflector = new ReflectExtensions();
  
  @Override
  protected void invokeMethod(final String methodName, final ICompletionProposalAcceptor acceptor, final Object... params) {
    final Map<String, PolymorphicDispatcher<Void>> dispatchers = this.getDispatchersMap();
    PolymorphicDispatcher<Void> dispatcher = dispatchers.get(methodName);
    if ((dispatcher == null)) {
      PolymorphicDispatcher.ErrorHandler<Void> errorHandler = new TypeExpressionsProposalProvider.LogErrorHandler<Void>(TypeExpressionsProposalProvider.log);
      int _length = params.length;
      int _plus = (_length + 1);
      int _length_1 = params.length;
      int _plus_1 = (_length_1 + 1);
      List<TypeExpressionsProposalProvider> _singletonList = Collections.<TypeExpressionsProposalProvider>singletonList(this);
      dispatcher = new PolymorphicDispatcher<Void>(methodName, _plus, _plus_1, _singletonList, errorHandler) {
        @Override
        public Class<?> getDefaultClass(final int paramIndex) {
          if ((paramIndex == 0)) {
            return EObject.class;
          }
          return super.getDefaultClass(paramIndex);
        }
      };
      dispatchers.put(methodName, dispatcher);
    }
    int _length_2 = params.length;
    int _plus_2 = (_length_2 + 1);
    Object[] paramAsArray = new Object[_plus_2];
    System.arraycopy(params, 0, paramAsArray, 0, params.length);
    {
      final Object[] _wrVal_paramAsArray = paramAsArray;
      final int _wrIndx_paramAsArray = params.length;
      _wrVal_paramAsArray[_wrIndx_paramAsArray] = acceptor;
    }
    boolean _announceProcessing = this.announceProcessing(Lists.<Object>asList(methodName, paramAsArray));
    if (_announceProcessing) {
      dispatcher.invoke(paramAsArray);
    }
  }
  
  private Map<String, PolymorphicDispatcher<Void>> getDispatchersMap() {
    try {
      return this.reflector.<Map<String, PolymorphicDispatcher<Void>>>get(this, "dispatchers");
    } catch (final Throwable _t) {
      if (_t instanceof NoSuchFieldException || _t instanceof IllegalAccessException) {
        final ReflectiveOperationException exc = (ReflectiveOperationException)_t;
        throw new RuntimeException(exc);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
