/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.xpect.methods;

import com.google.inject.Inject;
import junit.framework.AssertionFailedError;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4idl.N4IDLGlobals;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.xtext.lib.util.XtextOffsetAdapter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

/**
 * Provides X!PECT methods for testing the static linking of 'migrate' calls
 * in N4IDL migrations.
 */
@XpectImport(N4JSOffsetAdapter.class)
@SuppressWarnings("all")
public class MigrateScopeXpectMethod {
  @Inject
  private IScopeProvider scopeProvider;
  
  /**
   * Tests the target migration name of the 'migrate' call at the given offset.
   */
  @ParameterParser(syntax = "(\'at\' arg1=OFFSET)?")
  @Xpect
  public void migrateScope(@StringExpectation final IStringExpectation expectation, final XtextOffsetAdapter.ICrossEReferenceAndEObject arg1) {
    if ((expectation == null)) {
      throw new IllegalStateException("No expectation specified, add \'--> <migration name>\'");
    }
    final IScope scope = this.scopeProvider.getScope(arg1.getEObject(), arg1.getCrossEReference());
    final IEObjectDescription description = scope.getSingleElement(QualifiedName.create(N4IDLGlobals.MIGRATION_CALL_IDENTIFIER));
    final EObject migration = description.getEObjectOrProxy();
    if ((!(migration instanceof TMigration))) {
      throw new AssertionFailedError(("The statically linked function of the migrate calls is not a migration:" + migration));
    }
    expectation.assertEquals(String.format("\"%s\"", ((TMigration) migration).getName()));
  }
}
