/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods;

import com.google.common.base.Joiner;
import java.util.ArrayDeque;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.xtext.lib.tests.LinkingTest;
import org.eclipse.xpect.xtext.lib.util.XtextOffsetAdapter;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.resource.XtextResource;
import org.junit.Assert;

public class LinkingXpectMethod
extends LinkingTest {
    @Xpect
    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    public void linkedPathname(@StringExpectation IStringExpectation expectation, XtextOffsetAdapter.ICrossEReferenceAndEObject arg1) {
        Resource targetResource;
        EObject targetObject = (EObject)arg1.getEObject().eGet((EStructuralFeature)arg1.getCrossEReference());
        if (targetObject == null) {
            Assert.fail((String)"Reference is null");
            return;
        }
        if (targetObject.eIsProxy()) {
            Assert.fail((String)("Reference is a Proxy: " + ((InternalEObject)targetObject).eProxyURI()));
        }
        if ((targetResource = targetObject.eResource()) instanceof TypeResource) {
            targetResource = arg1.getEObject().eResource();
        }
        if (!(targetResource instanceof XtextResource)) {
            Assert.fail((String)"Referenced EObject is not in an XtextResource.");
        }
        ArrayDeque<String> segments = new ArrayDeque<String>();
        do {
            EStructuralFeature nameFeature;
            if ((nameFeature = targetObject.eClass().getEStructuralFeature("name")) != null) {
                Object obj = targetObject.eGet(nameFeature);
                if (!(obj instanceof String)) continue;
                segments.push((String)obj);
                continue;
            }
            if (!(targetObject instanceof NamedElement)) continue;
            segments.push(((NamedElement)targetObject).getName());
        } while ((targetObject = targetObject.eContainer()) != null);
        String pathname = Joiner.on((char)'/').join(segments);
        expectation.assertEquals((Object)pathname);
    }
}

