/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.n4JS;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.N4ClassExpression;
import org.eclipse.n4js.n4JS.N4EnumLiteral;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.PropertyNameOwner;

/**
 * Static utility methods for retrieving features of AST elements.
 */
@SuppressWarnings("all")
public class N4JSFeatureUtils {
  /**
   * Returns attribute feature actually holding the name or null, if no such attribute exists.
   */
  public static EStructuralFeature attributeOfNameFeature(final NamedElement namedElement) {
    EStructuralFeature _switchResult = null;
    boolean _matched = false;
    if (namedElement instanceof Annotation) {
      _matched=true;
      _switchResult = N4JSPackage.Literals.ANNOTATION__NAME;
    }
    if (!_matched) {
      if (namedElement instanceof FunctionDeclaration) {
        _matched=true;
        _switchResult = N4JSPackage.Literals.FUNCTION_DECLARATION__NAME;
      }
    }
    if (!_matched) {
      if (namedElement instanceof FunctionExpression) {
        _matched=true;
        _switchResult = N4JSPackage.Literals.FUNCTION_EXPRESSION__NAME;
      }
    }
    if (!_matched) {
      if (namedElement instanceof LabelledStatement) {
        _matched=true;
        _switchResult = N4JSPackage.Literals.LABELLED_STATEMENT__NAME;
      }
    }
    if (!_matched) {
      if (namedElement instanceof N4TypeDeclaration) {
        _matched=true;
        _switchResult = N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME;
      }
    }
    if (!_matched) {
      if (namedElement instanceof N4ClassExpression) {
        _matched=true;
        _switchResult = N4JSPackage.Literals.N4_CLASS_EXPRESSION__NAME;
      }
    }
    if (!_matched) {
      if (namedElement instanceof N4EnumLiteral) {
        _matched=true;
        _switchResult = N4JSPackage.Literals.N4_ENUM_LITERAL__NAME;
      }
    }
    if (!_matched) {
      if (namedElement instanceof PropertyNameOwner) {
        _matched=true;
        _switchResult = N4JSPackage.Literals.PROPERTY_NAME_OWNER__DECLARED_NAME;
      }
    }
    if (!_matched) {
      _switchResult = null;
    }
    return _switchResult;
  }
}
