/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.chrome;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.n4js.runner.IExecutor;
import org.eclipse.n4js.runner.IRunner;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.chrome.ChromeRunnerRunOptions;
import org.eclipse.n4js.runner.chrome.NodeEngineCommandBuilder;
import org.eclipse.n4js.runner.extension.IRunnerDescriptor;
import org.eclipse.n4js.runner.extension.RunnerDescriptorImpl;
import org.eclipse.n4js.runner.extension.RuntimeEnvironment;

public class ChromeRunner
implements IRunner {
    private static final String NODE_PATH_SEP = File.pathSeparator;
    private static final Logger LOGGER = Logger.getLogger(ChromeRunner.class);
    public static final String ID = "org.eclipse.n4js.runner.chrome.CHROME";
    public static final IRunnerDescriptor DESCRIPTOR = new RunnerDescriptorImpl("org.eclipse.n4js.runner.chrome.CHROME", "Chrome Runner", RuntimeEnvironment.CHROME, (IRunner)new ChromeRunner());

    public RunConfiguration createConfiguration() {
        return new RunConfiguration();
    }

    public void prepareConfiguration(RunConfiguration config) {
    }

    public Process run(RunConfiguration runConfig, IExecutor executor) {
        Process process = null;
        String[] cmds = new String[]{};
        try {
            ChromeRunnerRunOptions runOptions = new ChromeRunnerRunOptions();
            runOptions.setCoreProjectPaths(runConfig.getCoreProjectPaths().keySet().stream().map(Object::toString).collect(Collectors.joining(NODE_PATH_SEP)));
            runOptions.setExecutionData(runConfig.getExecutionDataAsJSON());
            ArrayList paths = new ArrayList();
            NodeEngineCommandBuilder cb = new NodeEngineCommandBuilder();
            cmds = cb.createCmds(runOptions);
            File workingDirectory = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
            paths.addAll(runConfig.getCoreProjectPaths().keySet());
            String nodePaths = paths.stream().map(Object::toString).collect(Collectors.joining(NODE_PATH_SEP));
            LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
            env.put("NODE_PATH", nodePaths);
            File chromedriver = this.getChromedriverBinary(true);
            String newPATH = String.valueOf(System.getenv("PATH")) + File.pathSeparator + chromedriver.getAbsoluteFile().getParent();
            env.put("PATH", newPATH);
            process = executor.exec(cmds, workingDirectory, env);
        }
        catch (IOException | RuntimeException | ExecutionException e) {
            LOGGER.error((Object)e);
        }
        return process;
    }

    private File getChromedriverBinary(boolean alwaysCopyToTemp) {
        return null;
    }
}

