/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.analysis;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.analysis.PositiveAnalyser;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class ExceptionAnalyser
extends PositiveAnalyser {
    @Inject
    private N4JSTypeSystem typeSystem;
    @Inject
    private IResourceValidator validator;

    public ExceptionAnalyser() {
        super(Logger.getLogger(ExceptionAnalyser.class), null);
    }

    @Override
    protected List<Resource.Diagnostic> getScriptErrors(Script script) {
        EcoreUtil.resolveAll((Resource)script.eResource());
        List<Resource.Diagnostic> diagnostics = super.getScriptErrors(script);
        UnmodifiableIterator typableASTNodes = Iterators.filter((Iterator)EcoreUtil2.eAll((EObject)script), TypableElement.class);
        ArrayList result = Lists.newArrayList((Iterable)Iterables.filter(diagnostics, ExceptionDiagnostic.class));
        while (typableASTNodes.hasNext()) {
            TypableElement typableASTNode = (TypableElement)typableASTNodes.next();
            RuleEnvironment ruleEnvironment = RuleEnvironmentExtensions.newRuleEnvironment((EObject)typableASTNode);
            try {
                this.typeSystem.type(ruleEnvironment, typableASTNode);
            }
            catch (Throwable cause) {
                if (cause instanceof Exception) {
                    result.add(new ExceptionDiagnostic((Exception)cause));
                    continue;
                }
                throw new RuntimeException(cause);
            }
        }
        this.validator.validate(script.eResource(), CheckMode.ALL, CancelIndicator.NullImpl);
        return result;
    }
}

