/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ts.validation;

import org.eclipse.n4js.ts.validation.AbstractTypesValidator;

/**
 * Custom validation rules.
 * @see http://www.eclipse.org/Xtext/documentation.html#validation
 * @see <a name="N4JSSpec">[N4JSSpec]</a> N4JS Specification / NumberFour AG. Berlin, 2013 <a href="https://github.com/NumberFour/specs/">[GitHub]</a>
 */
@SuppressWarnings("all")
public class TypesValidator extends AbstractTypesValidator {
  public static final String TYPES_ANY_IN_UNIONTYPE = "TYPES_ANY_IN_UNIONTYPE";
  
  public static final String TYPES_VOID_IN_UNIONTYPE = "TYPES_VOID_IN_UNIONTYPE";
  
  public static final String TYPES_VOID_IN_FPAR = "TYPES_VOID_IN_FPAR";
  
  public static final String TYPES_DYNAMIC_RETURNTYPE = "TYPES_DYNAMIC_RETURNTYPE";
}
