/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.scoping.builtin;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ts.scoping.builtin.ExecutionEnvironmentDescriptor;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;

public abstract class EnumerableScope
extends AbstractScope {
    private Map<QualifiedName, IEObjectDescription> elements;
    private final ExecutionEnvironmentDescriptor descriptor;

    protected EnumerableScope(ExecutionEnvironmentDescriptor descriptor) {
        super(IScope.NULLSCOPE, false);
        this.descriptor = descriptor;
    }

    protected final Map<QualifiedName, IEObjectDescription> createElements() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        this.descriptor.processResources(this.getFileNames(), r -> this.buildMap((Resource)r, result));
        return result;
    }

    protected abstract void buildMap(Resource var1, Map<QualifiedName, IEObjectDescription> var2);

    protected abstract String[] getFileNames();

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        if (this.elements == null) {
            this.elements = this.createElements();
        }
        return this.elements.values();
    }

    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        if (this.elements == null) {
            this.elements = this.createElements();
        }
        IEObjectDescription result = null;
        result = this.isIgnoreCase() ? this.elements.get(name.toLowerCase()) : this.elements.get(name);
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(result);
    }

    protected boolean isShadowed(IEObjectDescription fromParent) {
        if (this.elements == null) {
            this.elements = this.createElements();
        }
        if (this.isIgnoreCase()) {
            boolean result = this.elements.containsKey(fromParent.getName().toLowerCase());
            return result;
        }
        boolean result = this.elements.containsKey(fromParent.getName());
        return result;
    }

    @SafeVarargs
    protected final List<ParameterizedTypeRef> toTypeReferences(Type ... types) {
        return Collections.unmodifiableList(Arrays.stream(types).map(type -> TypeUtils.createTypeRef(type, new TypeArgument[0])).collect(Collectors.toList()));
    }

    protected <T extends EObject> T getEObjectOrProxy(QualifiedName qn) {
        IEObjectDescription description = this.getSingleElement(qn);
        if (description == null) {
            throw new IllegalStateException(qn + " is not contained in this scope");
        }
        EObject result = description.getEObjectOrProxy();
        return (T)result;
    }
}

