/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public final class SuperTypesList<E>
implements Collection<E> {
    TreeSet<E> set;
    List<E> list;

    public static <T> SuperTypesList<T> newSuperTypesList(Comparator<T> comparator) {
        return new SuperTypesList<T>(comparator);
    }

    public SuperTypesList(Comparator<E> comparator) {
        this.set = new TreeSet<E>(comparator);
        this.list = new ArrayList();
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        if (this.set.add(e)) {
            try {
                this.list.add(e);
                return true;
            }
            catch (RuntimeException ex) {
                this.set.remove(e);
                throw ex;
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.set.remove(o)) {
            try {
                this.list.remove(o);
                return true;
            }
            catch (RuntimeException ex) {
                this.set.add(o);
                throw ex;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == null) {
            return false;
        }
        boolean changed = false;
        for (E e : c) {
            changed |= this.add(e);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.set.removeAll(c)) {
            this.list.removeAll(c);
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.set.retainAll(c)) {
            this.list.retainAll(c);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.list.clear();
    }
}

