/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.utils;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.n4js.ui.N4JSEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.IssueModificationContext;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;

/**
 * Some utility methods for {@link Issue}s.
 * Note that there is also an Xtext utility class for this purpose, called {@link IssueUtil}.
 */
@SuppressWarnings("all")
public class IssueUtilN4 {
  @Inject
  private IssueModificationContext.Factory modificationContextFactory;
  
  @Inject
  private Injector tempInjector;
  
  private IURIEditorOpener getEditorOpener() {
    IURIEditorOpener _xifexpression = null;
    boolean _isWorkbenchRunning = PlatformUI.isWorkbenchRunning();
    if (_isWorkbenchRunning) {
      _xifexpression = this.tempInjector.<IURIEditorOpener>getInstance(IURIEditorOpener.class);
    } else {
      _xifexpression = null;
    }
    return _xifexpression;
  }
  
  public IModificationContext getContext(final Issue issue) {
    return this.modificationContextFactory.createModificationContext(issue);
  }
  
  public IXtextDocument getDocument(final Issue issue) {
    XtextEditor _editor = null;
    if (issue!=null) {
      _editor=this.<XtextEditor>getEditor(issue, XtextEditor.class);
    }
    IXtextDocument _document = null;
    if (_editor!=null) {
      _document=_editor.getDocument();
    }
    return _document;
  }
  
  public ISourceViewer getViewer(final Issue issue) {
    N4JSEditor _editor = null;
    if (issue!=null) {
      _editor=this.<N4JSEditor>getEditor(issue, N4JSEditor.class);
    }
    ISourceViewer _sourceViewer2 = null;
    if (_editor!=null) {
      _sourceViewer2=_editor.getSourceViewer2();
    }
    return _sourceViewer2;
  }
  
  /**
   * Returns the semantic element for the given issue.
   * If the editor contents above the issue's offset have changed, the result is undefined.
   */
  public EObject getElement(final IXtextDocument document, final Issue issue) {
    EObject _readOnly = null;
    if (document!=null) {
      final IUnitOfWork<EObject, XtextResource> _function = (XtextResource resource) -> {
        return resource.getEObject(issue.getUriToProblem().fragment());
      };
      _readOnly=document.<EObject>readOnly(_function);
    }
    return _readOnly;
  }
  
  private <T extends IEditorPart> T getEditor(final Issue issue, final Class<T> expectedType) {
    URI _uriToProblem = null;
    if (issue!=null) {
      _uriToProblem=issue.getUriToProblem();
    }
    URI _trimFragment = null;
    if (_uriToProblem!=null) {
      _trimFragment=_uriToProblem.trimFragment();
    }
    final URI uriToEditor = _trimFragment;
    if ((uriToEditor != null)) {
      IURIEditorOpener _editorOpener = this.getEditorOpener();
      IEditorPart _open = null;
      if (_editorOpener!=null) {
        _open=_editorOpener.open(uriToEditor, false);
      }
      final IEditorPart editor = _open;
      if (((editor != null) && expectedType.isAssignableFrom(editor.getClass()))) {
        return ((T) editor);
      }
    }
    return null;
  }
}
