/**
 * Copyright (c) 2016 NumberFour AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   NumberFour AG - Initial API and implementation
 */
package org.eclipse.n4js.ui.wizard.components;

import java.util.regex.Pattern;
import org.eclipse.n4js.naming.N4JSQualifiedNameConverter;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Utility class to handle the {@link N4JSQualifiedNameConverter#DELIMITER delimiter} separated specifiers.
 * <p>
 * TODO rename & clean up this class and, if possible, use an injected IQualifiedNameConverter instead
 */
@SuppressWarnings("all")
public class DotPathUtils {
  /**
   * Returns all {@link N4JSQualifiedNameConverter#DELIMITER delimiter} separated segments but the last one.
   * 
   * @param delimiterSeparatedString
   *            A delimiter separated string
   * @return The front segments
   */
  public static String frontDotSegments(final String delimiterSeparatedString) {
    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(delimiterSeparatedString);
    if (_isNullOrEmpty) {
      return "";
    }
    final String lastSegment = DotPathUtils.lastDotSegment(delimiterSeparatedString);
    int _length = lastSegment.length();
    int _length_1 = delimiterSeparatedString.length();
    boolean _equals = (_length == _length_1);
    if (_equals) {
      return "";
    }
    int _length_2 = delimiterSeparatedString.length();
    int _minus = (_length_2 - 1);
    int _length_3 = lastSegment.length();
    int _minus_1 = (_minus - _length_3);
    return delimiterSeparatedString.substring(0, _minus_1);
  }
  
  /**
   * Returns the last {@link N4JSQualifiedNameConverter#DELIMITER delimiter} separated segment.
   * 
   * <p>Note: Returns an empty string if no dot is found in the string.</p>
   * 
   * @param delimiterSeparatedString
   *            A delimiter separated string
   * @return The last segment
   */
  public static String lastDotSegment(final String delimiterSeparatedString) {
    final String[] segments = delimiterSeparatedString.split(Pattern.quote(N4JSQualifiedNameConverter.DELIMITER));
    int _length = segments.length;
    boolean _greaterThan = (_length > 0);
    if (_greaterThan) {
      return IterableExtensions.<String>last(((Iterable<String>)Conversions.doWrapArray(segments)));
    }
    return "";
  }
}
