/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.common;

import com.google.common.collect.Lists;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xpect.runner.XpectTestFiles;
import org.eclipse.xpect.runner.XpectURIProvider;
import org.eclipse.xtext.util.UriExtensions;

@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@XpectURIProvider(value=LspCompatibleXpectTestFileCollector.class)
public @interface LspCompatibleXpectTestFiles {
    public String baseDir() default "";

    public String[] fileExtensions() default {"xt"};

    public String[] files() default {};

    public XpectTestFiles.FileRoot relativeTo() default XpectTestFiles.FileRoot.PROJECT;

    public static class LspCompatibleXpectTestFileCollector
    extends XpectTestFiles.XpectTestFileCollector {
        private final UriExtensions uriExtensions = new UriExtensions();

        private static XpectTestFiles asXpectTestFiles(final LspCompatibleXpectTestFiles ctx) {
            return new XpectTestFiles(){

                public Class<? extends Annotation> annotationType() {
                    return XpectTestFiles.class;
                }

                public String baseDir() {
                    return ctx.baseDir();
                }

                public String[] fileExtensions() {
                    return ctx.fileExtensions();
                }

                public String[] files() {
                    return ctx.files();
                }

                public XpectTestFiles.FileRoot relativeTo() {
                    return ctx.relativeTo();
                }
            };
        }

        public LspCompatibleXpectTestFileCollector(Class<?> owner, LspCompatibleXpectTestFiles ctx) {
            super(owner, LspCompatibleXpectTestFileCollector.asXpectTestFiles(ctx));
        }

        protected URI createURI(File file) {
            throw new UnsupportedOperationException("Never called by super impl");
        }

        public URI deresolveToProject(URI uri) {
            return uri.deresolve(this.uriExtensions.withEmptyAuthority(this.getBundle().getRootURI()));
        }

        public Collection<URI> getAllURIs() {
            ArrayList result = Lists.newArrayList((Iterable)super.getAllURIs());
            int i = 0;
            while (i < result.size()) {
                result.set(i, this.uriExtensions.withEmptyAuthority((URI)result.get(i)));
                ++i;
            }
            return result;
        }

        protected URI resolvePlatformResourceURI(URI uri) {
            URI result = super.resolvePlatformResourceURI(uri);
            return this.uriExtensions.withEmptyAuthority(result);
        }

        protected URI resolveProjectRelativeURI(URI uri) {
            URI result = super.resolveProjectRelativeURI(uri);
            return this.uriExtensions.withEmptyAuthority(result);
        }

        public URI resolveURI(URI base, String newURI) {
            URI uri = super.resolveURI(base, newURI);
            return this.uriExtensions.withEmptyAuthority(uri);
        }
    }
}

