/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.config;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.n4js.xpect.config.Preference;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.setup.XpectSetupRoot;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.preferences.TypedPreferenceKey;

@XpectSetupRoot
@XpectImport(value={Preference.class})
public class Preferences
implements ITypedPreferenceValues {
    HashMap<String, Preference> prefs = new HashMap();

    public void add(Preference s) {
        this.prefs.put(s.getKey(), s);
    }

    public void setMap(HashMap<String, Preference> map) {
        this.prefs = new HashMap<String, Preference>(map);
    }

    public Set<String> keys() {
        return this.prefs.keySet();
    }

    public String getValue(String key) {
        Preference pref = this.prefs.get(key);
        if (pref == null) {
            return null;
        }
        return pref.getValue();
    }

    public void put(PreferenceKey key, Object value) {
        this.put(key.getId(), value.toString());
    }

    public void put(String key, String value) {
        this.prefs.put(key, new Preference(key, value));
    }

    public <T> void put(TypedPreferenceKey<T> key, T value) {
        this.put(key.getId(), key.toString(value));
    }

    public String getPreference(PreferenceKey key) {
        return this.getValue(key.getId());
    }

    public <T> T getPreference(TypedPreferenceKey<T> key) {
        String valueString = this.getValue(key.getId());
        return (T)key.toValue(valueString != null ? valueString : key.getDefaultValue());
    }
}

