/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xtext.EcoreUtil2;

@XpectImport(value={N4JSOffsetAdapter.class})
public class AccessModifierXpectMethod {
    @ParameterParser(syntax="('at' arg1=OFFSET)?")
    @Xpect
    public void accessModifier(@StringExpectation IStringExpectation expectation, N4JSOffsetAdapter.IEObjectCoveringRegion offset) {
        EObject context = offset.getEObject();
        String actual = this.calculateActual(context);
        expectation.assertEquals((Object)actual);
    }

    private String calculateActual(EObject context) {
        String actual = null;
        if (context instanceof TMember) {
            TMember tMember = (TMember)context;
            actual = tMember.getMemberAccessModifier().getName();
        } else {
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)EcoreUtil2.getContainerOfType((EObject)context, FunctionDeclaration.class);
            if (functionDeclaration != null) {
                actual = functionDeclaration.getDefinedType().getTypeAccessModifier().getName();
            } else {
                VariableStatement variableStatement = (VariableStatement)EcoreUtil2.getContainerOfType((EObject)context, VariableStatement.class);
                if (variableStatement != null) {
                    context = (EObject)variableStatement.getVarDecl().get(0);
                    if (context instanceof ExportedVariableDeclaration) {
                        actual = ((ExportedVariableDeclaration)context).getDefinedVariable().getTypeAccessModifier().getName();
                    } else if (context instanceof VariableDeclaration) {
                        actual = "private";
                    }
                } else if (context instanceof ExportDeclaration) {
                    context = ((ExportDeclaration)context).getExportedElement();
                    actual = this.calculateActual(context);
                } else if (context instanceof ParameterizedPropertyAccessExpression) {
                    ParameterizedPropertyAccessExpression ppae = (ParameterizedPropertyAccessExpression)context;
                    IdentifiableElement ie = ppae.getProperty();
                    actual = this.calculateActual((EObject)ie);
                } else if (context instanceof ParameterizedCallExpression) {
                    ParameterizedCallExpression pce = (ParameterizedCallExpression)context;
                    Expression targetExpr = pce.getTarget();
                    actual = this.calculateActual((EObject)targetExpr);
                } else {
                    N4MemberDeclaration member = (N4MemberDeclaration)EcoreUtil2.getContainerOfType((EObject)context, N4MemberDeclaration.class);
                    N4TypeDeclaration type = (N4TypeDeclaration)EcoreUtil2.getContainerOfType((EObject)context, N4TypeDeclaration.class);
                    actual = type == null && member == null ? "no element with access modifier found" : (type != null && (member == null || EcoreUtil.isAncestor((EObject)member, (EObject)type)) ? type.getDefinedType().getTypeAccessModifier().getName() : member.getDefinedTypeElement().getMemberAccessModifier().getName());
                }
            }
        }
        return actual;
    }
}

