/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.methods.scoping;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.xpect.methods.scoping.EObjectDescriptionToNameWithPositionMapper;
import org.eclipse.n4js.xpect.methods.scoping.IN4JSCommaSeparatedValuesExpectation;
import org.eclipse.n4js.xpect.methods.scoping.ScopeAwareIterable;
import org.eclipse.xpect.XpectArgument;
import org.eclipse.xpect.expectation.ICommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.impl.AbstractExpectation;
import org.eclipse.xpect.expectation.impl.ActualCollection;
import org.eclipse.xpect.expectation.impl.ExpectationCollection;
import org.eclipse.xpect.expectation.impl.TargetSyntaxSupport;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.text.Text;
import org.eclipse.xpect.util.ReflectionUtil;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Pair;
import org.junit.ComparisonFailure;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface N4JSCommaSeparatedValuesExpectation {
    public boolean caseSensitive() default true;

    public Class<? extends Function<Object, String>> itemFormatter() default ActualCollection.ToString.class;

    public int maxItemsPerLine() default -1;

    public int maxLineWidth() default 80;

    public boolean ordered() default false;

    public boolean quoted() default false;

    public boolean whitespaceSensitive() default false;

    @XpectSetupFactory
    public static class N4JSCommaSeparatedValuesExpectationImpl
    extends AbstractExpectation
    implements IN4JSCommaSeparatedValuesExpectation {
        private final N4JSCommaSeparatedValuesExpectation annotation;

        public N4JSCommaSeparatedValuesExpectationImpl(XpectArgument argument, TargetSyntaxSupport syntax) {
            super(argument, syntax);
            this.annotation = (N4JSCommaSeparatedValuesExpectation)argument.getAnnotationOrDefault(N4JSCommaSeparatedValuesExpectation.class);
        }

        public void assertEquals(Iterable<?> actual) {
            this.assertEquals(actual, null);
        }

        public void assertEquals(Iterable<?> actual, Predicate<String> predicate) {
            N4JSExpectationCollection exp = new N4JSExpectationCollection();
            exp.setCaseSensitive(this.annotation.caseSensitive());
            exp.setOrdered(this.annotation.ordered());
            exp.setQuoted(this.annotation.quoted());
            exp.setSeparator(',');
            exp.setWhitespaceSensitive(this.annotation.whitespaceSensitive());
            exp.init(this.getExpectation());
            ActualCollection act = new ActualCollection();
            act.setTargetLiteralSupport(this.getTargetSyntaxLiteral());
            act.setCaseSensitive(this.annotation.caseSensitive());
            act.setOrdered(this.annotation.ordered());
            act.setQuoted(this.annotation.quoted());
            act.setSeparator(',');
            act.setWhitespaceSensitive(this.annotation.whitespaceSensitive());
            if (actual != null && predicate != null) {
                if (exp.isWildcard()) {
                    this.initActualCollection(act, exp.applyPredicate(predicate), this.annotation.itemFormatter());
                } else {
                    this.initActualCollection(act, actual, this.annotation.itemFormatter());
                }
            } else if (predicate != null) {
                this.initActualCollection(act, exp.applyPredicate(predicate), this.annotation.itemFormatter());
            } else if (actual != null) {
                this.initActualCollection(act, actual, this.annotation.itemFormatter());
            } else {
                throw new NullPointerException();
            }
            this.adaptActual(actual, exp, act);
            String nl = new Text(this.getRegion().getDocument()).getNL();
            if (!exp.matches(act)) {
                StringBuilder expString = new StringBuilder();
                StringBuilder actString = new StringBuilder();
                boolean expWrap = false;
                boolean expEmpty = false;
                boolean actWrap = false;
                int lineLength = 0;
                int lineCount = 0;
                for (Pair pair : exp.map(act)) {
                    String expItem = null;
                    String actItem = null;
                    if (pair.getFirst() != null && !((Collection)pair.getFirst()).isEmpty()) {
                        expItem = pair.getSecond() != null ? ((ActualCollection.ActualItem)pair.getSecond()).getEscaped() : ((ExpectationCollection.ExpectationItem)((Collection)pair.getFirst()).iterator().next()).getEscaped();
                    } else if (pair.getSecond() != null) {
                        expItem = this.str(((ActualCollection.ActualItem)pair.getSecond()).getEscaped().length());
                    }
                    if (pair.getSecond() != null) {
                        boolean width;
                        actItem = ((ActualCollection.ActualItem)pair.getSecond()).getEscaped();
                        boolean count = this.annotation.maxItemsPerLine() > 0 && ++lineCount > this.annotation.maxItemsPerLine();
                        boolean bl = width = this.annotation.maxLineWidth() > 0 && (lineLength += actItem.length() + 2) > this.annotation.maxLineWidth();
                        if (count || width) {
                            actWrap = true;
                            expWrap = true;
                        }
                    }
                    if (expItem != null && expString.length() > 0) {
                        if (expWrap) {
                            expString.append(expEmpty ? nl : "," + nl);
                            expWrap = false;
                        } else {
                            expString.append(expEmpty ? "  " : ", ");
                        }
                    }
                    if (actItem != null && actString.length() > 0) {
                        if (actWrap) {
                            actString.append("," + nl);
                            actWrap = false;
                            lineCount = 0;
                            lineLength = 0;
                        } else {
                            actString.append(", ");
                        }
                    }
                    if (expItem != null) {
                        expString.append(expItem);
                        boolean bl = expEmpty = expItem.trim().length() == 0;
                    }
                    if (actItem == null) continue;
                    actString.append(actItem);
                }
                String expDoc = this.replaceInDocument(expString.toString());
                String actDoc = this.replaceInDocument(actString.toString());
                throw new ComparisonFailure("", expDoc, actDoc);
            }
        }

        private void initActualCollection(ActualCollection act, Iterable<?> actual, Class<? extends Function<Object, String>> functionClass) {
            act.setItemFormatter((Function)ReflectionUtil.newInstanceUnchecked(functionClass));
            act.init(actual);
        }

        private void adaptActual(Iterable<?> actual, N4JSExpectationCollection exp, ActualCollection act) {
            if (actual instanceof ScopeAwareIterable) {
                ScopeAwareIterable actualScopeAwareIterable = (ScopeAwareIterable)actual;
                LinkedHashSet actualElementsWithPosition = Sets.newLinkedHashSet((Iterable)actualScopeAwareIterable);
                IScope scope = actualScopeAwareIterable.getScope();
                URI currentURI = actualScopeAwareIterable.getCurrentURI();
                for (ExpectationCollection.ExpectationItem item : exp.getItems()) {
                    String expectedName;
                    IEObjectDescription elementDescr;
                    String expectedNameWithPosition = item.getPure();
                    if (actualElementsWithPosition.contains(expectedNameWithPosition) || (elementDescr = scope.getSingleElement(QualifiedName.create((String)(expectedName = EObjectDescriptionToNameWithPositionMapper.getNameFromNameWithPosition(expectedNameWithPosition))))) == null) continue;
                    actualElementsWithPosition.add(EObjectDescriptionToNameWithPositionMapper.descriptionToNameWithPosition(currentURI, ((ScopeAwareIterable)actual).withLineNumber, elementDescr));
                }
                String[] array = new String[actualElementsWithPosition.size()];
                act.init(actualElementsWithPosition.toArray(array));
            }
        }

        public void assertEquals(Predicate<String> predicate) {
            this.assertEquals(null, predicate);
        }

        public N4JSCommaSeparatedValuesExpectation getAnnotation() {
            return this.annotation;
        }

        protected String str(int length) {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < length) {
                b.append(" ");
                ++i;
            }
            return b.toString();
        }

        @Creates
        public IN4JSCommaSeparatedValuesExpectation create() {
            return this;
        }

        public List<ICommaSeparatedValuesExpectation.Value> getExpectedValues() {
            throw new UnsupportedOperationException();
        }
    }

    public static class N4JSExpectationCollection
    extends ExpectationCollection {
        public Collection<ExpectationCollection.ExpectationItem> getItems() {
            return this.items;
        }
    }
}

