/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xpect.xtext.lib.util.EObjectFormatter;

public class EObjectAlphabeticFormatter
extends EObjectFormatter {
    public String format(EObject object) {
        if (object == null) {
            return "null";
        }
        StringBuilder result = new StringBuilder();
        result.append(object.eClass().getName());
        result.append(" {");
        for (EStructuralFeature feature : this.getAllFeatures(object)) {
            if (!this.shouldFormat(object, feature)) continue;
            result.append(this.indent("\n" + this.format(object, feature)));
        }
        result.append("\n}");
        return result.toString();
    }

    protected List<EStructuralFeature> getAllFeatures(EObject object) {
        ArrayList result = Lists.newArrayList((Iterable)object.eClass().getEAllStructuralFeatures());
        Collections.sort(result, new Comparator<EStructuralFeature>(){

            @Override
            public int compare(EStructuralFeature o1, EStructuralFeature o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return result;
    }

    public EObjectAlphabeticFormatter resolveCrossReferences() {
        return (EObjectAlphabeticFormatter)super.resolveCrossReferences();
    }

    public EObjectAlphabeticFormatter showIndex() {
        return (EObjectAlphabeticFormatter)super.showIndex();
    }
}

