/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.InternalN4JSWorkspace;
import org.eclipse.n4js.internal.LazyProjectDescriptionHandle;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.xtext.util.UriExtensions;

@Singleton
public class FileBasedWorkspace
extends InternalN4JSWorkspace<FileURI> {
    public static final String N4FBPRJ = "n4fbprj:";
    private final Map<FileURI, LazyProjectDescriptionHandle> projectElementHandles = Maps.newConcurrentMap();
    private final Map<N4JSProjectName, FileURI> nameToLocation = Maps.newConcurrentMap();
    private final ProjectDescriptionLoader projectDescriptionLoader;
    private final UriExtensions uriExtensions;

    @Inject
    public FileBasedWorkspace(ProjectDescriptionLoader projectDescriptionLoader, UriExtensions uriExtensions) {
        this.projectDescriptionLoader = projectDescriptionLoader;
        this.uriExtensions = uriExtensions;
    }

    @Override
    public FileURI fromURI(URI unsafe) {
        return this.safeFromURI(unsafe);
    }

    private FileURI safeFromURI(URI uri) {
        return new FileURI(this.uriExtensions.withEmptyAuthority(uri));
    }

    public void registerProject(FileURI location) {
        if (!this.projectElementHandles.containsKey(location)) {
            LazyProjectDescriptionHandle lazyDescriptionHandle = this.createLazyDescriptionHandle(location);
            this.projectElementHandles.put(location, lazyDescriptionHandle);
        }
        this.nameToLocation.putIfAbsent(location.getProjectName(), location);
    }

    @Override
    public FileURI getProjectLocation(N4JSProjectName name) {
        return this.nameToLocation.get(name);
    }

    public void clear() {
        this.projectElementHandles.clear();
    }

    protected LazyProjectDescriptionHandle createLazyDescriptionHandle(FileURI location) {
        return new LazyProjectDescriptionHandle(location, this.projectDescriptionLoader);
    }

    @Override
    public FileURI findProjectWith(FileURI nestedLocation) {
        FileURI key = nestedLocation.trimFragment();
        do {
            LazyProjectDescriptionHandle match;
            if ((match = this.projectElementHandles.get(key)) == null) continue;
            return key;
        } while ((key = (FileURI)key.getParent()) != null);
        return null;
    }

    @Override
    public ProjectDescription getProjectDescription(FileURI location) {
        LazyProjectDescriptionHandle handle = this.projectElementHandles.get(location);
        if (handle == null) {
            return null;
        }
        ProjectDescription description = handle.resolve();
        return description;
    }

    public Iterator<FileURI> getAllProjectLocationsIterator() {
        return this.projectElementHandles.values().stream().map(handle -> handle.getLocation()).iterator();
    }

    @Override
    public Collection<FileURI> getAllProjectLocations() {
        return this.projectElementHandles.values().stream().map(handle -> handle.getLocation()).collect(Collectors.toList());
    }

    @Override
    public FileURI getLocation(ProjectReference projectReference) {
        String projectName = projectReference.getProjectName();
        for (FileURI siblingProject : this.projectElementHandles.keySet()) {
            LazyProjectDescriptionHandle lazyHandle;
            String candidateProjectName = siblingProject.getProjectName().getRawName();
            if (!candidateProjectName.equals(projectName) || (lazyHandle = this.projectElementHandles.get(siblingProject)) == null) continue;
            return lazyHandle.getLocation();
        }
        return null;
    }

    @Override
    public Iterator<? extends FileURI> getFolderIterator(FileURI folderLocation) {
        return Iterators.filter(folderLocation.getAllChildren(), loc -> !loc.isDirectory());
    }

    @Override
    public FileURI findArtifactInFolder(FileURI folder, String relativePath) {
        FileURI result = (FileURI)folder.appendPath(relativePath);
        if (result != null && result.exists()) {
            return result;
        }
        return null;
    }

    public static URI uriFrom(String handle) {
        if (handle.startsWith(N4FBPRJ)) {
            return URI.createURI((String)handle.substring(N4FBPRJ.length()));
        }
        return null;
    }

    public static String handleFrom(URI uri) {
        return N4FBPRJ + uri.toString();
    }
}

