/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.imports;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.ISelectable;
import org.eclipse.xtext.resource.impl.AliasedEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.ImportNormalizer;
import org.eclipse.xtext.scoping.impl.ImportScope;

class NonResolvingImportScope
extends ImportScope {
    private List<ImportNormalizer> myNormalizers;
    private final EClass myType;

    public NonResolvingImportScope(List<ImportNormalizer> namespaceResolvers, IScope parent, ISelectable importFrom, EClass type, boolean ignoreCase) {
        super(namespaceResolvers, parent, importFrom, type, ignoreCase);
        this.myType = type;
    }

    protected List<ImportNormalizer> removeDuplicates(List<ImportNormalizer> namespaceResolvers) {
        List result;
        this.myNormalizers = result = super.removeDuplicates(namespaceResolvers);
        return result;
    }

    protected Iterable<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        ArrayList result = Lists.newArrayList();
        QualifiedName resolvedQualifiedName = null;
        ISelectable importFrom = this.getImportFrom();
        for (ImportNormalizer normalizer : this.myNormalizers) {
            QualifiedName resolvedName = normalizer.resolve(name);
            if (resolvedName == null) continue;
            Iterable resolvedElements = importFrom.getExportedObjects(this.myType, resolvedName, this.isIgnoreCase());
            for (IEObjectDescription resolvedElement : resolvedElements) {
                if (resolvedQualifiedName == null) {
                    resolvedQualifiedName = resolvedName;
                } else if (!resolvedQualifiedName.equals((Object)resolvedName) && ((IEObjectDescription)result.get(0)).getEObjectURI().equals(resolvedElement.getEObjectURI())) {
                    return Collections.emptyList();
                }
                QualifiedName alias = normalizer.deresolve(resolvedElement.getName());
                if (alias == null) {
                    throw new IllegalStateException("Couldn't deresolve " + resolvedElement.getName() + " with import " + normalizer);
                }
                AliasedEObjectDescription aliasedEObjectDescription = new AliasedEObjectDescription(alias, resolvedElement);
                result.add(aliasedEObjectDescription);
            }
        }
        return result;
    }
}

