/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.NodeModulesDiscoveryHelper;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;

public class ProjectDiscoveryHelper {
    @Inject
    NodeModulesDiscoveryHelper nodeModulesDiscoveryHelper;
    @Inject
    ProjectDescriptionLoader projectDescriptionLoader;

    public LinkedHashSet<Path> collectAllProjectDirs(Path ... workspaceRoots) {
        LinkedHashSet<Path> allProjectDirs = new LinkedHashSet<Path>();
        Path[] pathArray = workspaceRoots;
        int n = workspaceRoots.length;
        int n2 = 0;
        while (n2 < n) {
            Path workspaceRoot = pathArray[n2];
            NodeModulesDiscoveryHelper.NodeModulesFolder nodeModulesFolder = this.nodeModulesDiscoveryHelper.getNodeModulesFolder(workspaceRoot);
            if (nodeModulesFolder == null) {
                LinkedHashSet<Path> standAloneProjects = this.collectProjects(workspaceRoot);
                allProjectDirs.addAll(standAloneProjects);
            } else if (nodeModulesFolder.isYarnWorkspace) {
                Path yarnProjectDir = nodeModulesFolder.nodeModulesFolder.getParentFile().toPath();
                allProjectDirs.addAll(this.collectYarnWorkspaceProjects(yarnProjectDir));
            } else {
                allProjectDirs.add(workspaceRoot);
            }
            ++n2;
        }
        List<Path> nodeModulesFolders = this.nodeModulesDiscoveryHelper.findNodeModulesFolders(allProjectDirs);
        for (Path nmFolder : nodeModulesFolders) {
            LinkedHashSet<Path> dependencies = this.collectProjects(nmFolder);
            allProjectDirs.addAll(dependencies);
        }
        return allProjectDirs;
    }

    private LinkedHashSet<Path> collectYarnWorkspaceProjects(Path yarnProjectRoot) {
        LinkedHashSet<Path> allProjectDirs = new LinkedHashSet<Path>();
        FileURI uri = new FileURI(yarnProjectRoot.toFile());
        List<String> workspaces = this.projectDescriptionLoader.loadWorkspacesFromProjectDescriptionAtLocation(uri);
        for (String workspace : workspaces) {
            Path workspacePath = yarnProjectRoot.resolve(workspace);
            this.collectProjects(workspacePath);
        }
        return allProjectDirs;
    }

    private LinkedHashSet<Path> collectProjects(Path root) {
        final LinkedHashSet<Path> allProjectDirs = new LinkedHashSet<Path>();
        if (!root.toFile().isDirectory()) {
            return allProjectDirs;
        }
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (dir.endsWith("node_modules")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    File pckJson = dir.resolve("package.json").toFile();
                    if (pckJson.isFile()) {
                        if (ProjectDiscoveryHelper.this.nodeModulesDiscoveryHelper.isYarnWorkspaceRoot(dir.toFile())) {
                            allProjectDirs.addAll(ProjectDiscoveryHelper.this.collectYarnWorkspaceProjects(dir));
                        } else {
                            allProjectDirs.add(dir);
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.preVisitDirectory(dir, attrs);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return allProjectDirs;
    }
}

