/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.n4js.ide.xtext.server.IOrderInfo;
import org.eclipse.n4js.ide.xtext.server.XBuildManager;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ProjectDescription;

public class ProjectBuildOrderInfo
implements IOrderInfo<ProjectDescription> {
    @Inject
    protected XWorkspaceManager workspaceManager;
    protected final Multimap<String, ProjectDescription> inversedDependencies = HashMultimap.create();
    protected final List<ProjectDescription> sortedProjects = new ArrayList<ProjectDescription>();

    public ProjectBuildOrderIterator getIterator() {
        return new ProjectBuildOrderIterator();
    }

    public ProjectBuildOrderIterator getIterator(Collection<ProjectDescription> projectDescriptions) {
        ProjectBuildOrderIterator iterator = this.getIterator();
        iterator.visit((Collection)projectDescriptions);
        return iterator;
    }

    @Inject
    protected void init() {
        LinkedHashSet<String> orderedProjectNames = new LinkedHashSet<String>();
        for (XProjectManager pm : this.workspaceManager.getProjectManagers()) {
            ProjectDescription pd = pm.getProjectDescription();
            for (String dependencyName : pd.getDependencies()) {
                this.inversedDependencies.put((Object)dependencyName, (Object)pd);
            }
            this.computeOrder(pd, orderedProjectNames, new LinkedHashSet<String>());
        }
        for (String projectName : orderedProjectNames) {
            XProjectManager pm = this.workspaceManager.getProjectManager(projectName);
            if (pm == null) continue;
            this.sortedProjects.add(pm.getProjectDescription());
        }
    }

    protected void computeOrder(ProjectDescription pd, LinkedHashSet<String> orderedProjects, LinkedHashSet<String> projectStack) {
        String pdName = pd.getName();
        if (projectStack.contains(pdName)) {
            for (String cyclicPD : projectStack) {
                this.reportDependencyCycle(cyclicPD);
            }
        } else {
            projectStack.add(pdName);
            for (String depName : pd.getDependencies()) {
                XProjectManager pm = this.workspaceManager.getProjectManager(depName);
                if (pm == null) continue;
                ProjectDescription depPd = pm.getProjectDescription();
                this.computeOrder(depPd, orderedProjects, projectStack);
            }
            orderedProjects.add(pdName);
            projectStack.remove(pdName);
        }
    }

    protected void reportDependencyCycle(String projectName) {
        XProjectManager pm = this.workspaceManager.getProjectManager(projectName);
        if (pm != null) {
            String msg = "Project has cyclic dependencies";
            pm.reportProjectIssue(msg, XBuildManager.CYCLIC_PROJECT_DEPENDENCIES, Severity.ERROR);
        }
    }

    public class ProjectBuildOrderIterator
    implements IOrderInfo.IOrderIterator<ProjectDescription> {
        protected final Set<String> visitProjectNames = new HashSet<String>();
        protected final Iterator<ProjectDescription> iteratorDelegate;

        ProjectBuildOrderIterator() {
            this.iteratorDelegate = Iterables.filter(ProjectBuildOrderInfo.this.sortedProjects, input -> this.visitProjectNames.contains(input.getName())).iterator();
        }

        public ProjectBuildOrderIterator visit(Collection<ProjectDescription> projectDescriptions) {
            for (ProjectDescription prj : projectDescriptions) {
                this.visitProjectNames.add(prj.getName());
            }
            return this;
        }

        public ProjectBuildOrderIterator visitAffected(List<IResourceDescription.Delta> changes) {
            this.visit(this.getAffectedProjects(changes));
            return this;
        }

        public ProjectBuildOrderIterator visitAll() {
            this.visit(ProjectBuildOrderInfo.this.sortedProjects);
            return this;
        }

        protected Set<ProjectDescription> getAffectedProjects(List<IResourceDescription.Delta> changes) {
            HashSet<String> changedProjectsNames = new HashSet<String>();
            for (IResourceDescription.Delta change : changes) {
                XProjectManager projectManager = ProjectBuildOrderInfo.this.workspaceManager.getProjectManager(change.getUri());
                ProjectDescription pd = projectManager.getProjectDescription();
                changedProjectsNames.add(pd.getName());
            }
            HashSet<ProjectDescription> affectedProjects = new HashSet<ProjectDescription>();
            for (String changedProjectName : changedProjectsNames) {
                affectedProjects.addAll(ProjectBuildOrderInfo.this.inversedDependencies.get((Object)changedProjectName));
            }
            return affectedProjects;
        }

        @Override
        public boolean hasNext() {
            return this.iteratorDelegate.hasNext();
        }

        @Override
        public ProjectDescription next() {
            return this.iteratorDelegate.next();
        }
    }

    public static class Provider
    implements com.google.inject.Provider<IOrderInfo<ProjectDescription>> {
        @Inject
        protected Injector injector;

        public ProjectBuildOrderInfo get() {
            return (ProjectBuildOrderInfo)this.injector.getInstance(ProjectBuildOrderInfo.class);
        }
    }
}

