/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.eclipse.n4js.ide.xtext.server.DocumentResourceProvider;
import org.eclipse.n4js.ide.xtext.server.XBuildManager;
import org.eclipse.n4js.ide.xtext.server.XDocument;
import org.eclipse.n4js.ide.xtext.server.XIProjectDescriptionFactory;
import org.eclipse.n4js.ide.xtext.server.XIWorkspaceConfigFactory;
import org.eclipse.n4js.ide.xtext.server.XProjectManager;
import org.eclipse.n4js.xtext.workspace.WorkspaceChanges;
import org.eclipse.n4js.xtext.workspace.XIWorkspaceConfig;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.resource.IExternalContentSupport;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.impl.ChunkedResourceDescriptions;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.IWorkspaceConfig;

@Singleton
public class XWorkspaceManager
implements DocumentResourceProvider {
    private static final Logger LOG = Logger.getLogger(XWorkspaceManager.class);
    @Inject
    private XIWorkspaceConfigFactory workspaceConfigFactory;
    @Inject
    private Provider<XProjectManager> projectManagerProvider;
    @Inject
    private XIProjectDescriptionFactory projectDescriptionFactory;
    @Inject
    private UriExtensions uriExtensions;
    @Inject
    private XBuildManager buildManager;
    private final Map<String, XProjectManager> projectName2ProjectManager = new HashMap<String, XProjectManager>();
    private IWorkspaceConfig workspaceConfig;
    private final List<ILanguageServerAccess.IBuildListener> buildListeners = new ArrayList<ILanguageServerAccess.IBuildListener>();
    private final Map<String, ResourceDescriptionsData> fullIndex = new ConcurrentHashMap<String, ResourceDescriptionsData>();
    private final Map<URI, XDocument> openDocuments = new ConcurrentHashMap<URI, XDocument>();
    private final IExternalContentSupport.IExternalContentProvider openedDocumentsContentProvider = new IExternalContentSupport.IExternalContentProvider(){

        public IExternalContentSupport.IExternalContentProvider getActualContentProvider() {
            return this;
        }

        public String getContent(URI uri) {
            XDocument document = XWorkspaceManager.this.openDocuments.get(uri);
            if (document != null) {
                return document.getContents();
            }
            return null;
        }

        public boolean hasContent(URI uri) {
            return XWorkspaceManager.this.isDocumentOpen(uri);
        }
    };

    public void addBuildListener(ILanguageServerAccess.IBuildListener listener) {
        this.buildListeners.add(listener);
    }

    public void removeBuildListener(ILanguageServerAccess.IBuildListener listener) {
        this.buildListeners.remove(listener);
    }

    public void reinitialize() {
        this.initialize(this.getBaseDir());
    }

    public boolean isDirty() {
        for (XDocument doc : this.openDocuments.values()) {
            if (!doc.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void initialize(URI newBaseDir) {
        this.refreshWorkspaceConfig(newBaseDir);
    }

    public void refreshWorkspaceConfig(URI newBaseDir) {
        XIWorkspaceConfig newWorkspaceConfig = this.workspaceConfigFactory.createWorkspaceConfig(newBaseDir);
        this.setWorkspaceConfig((IWorkspaceConfig)newWorkspaceConfig);
    }

    protected synchronized void setWorkspaceConfig(IWorkspaceConfig workspaceConfig) {
        if (this.workspaceConfig != null && workspaceConfig != null && this.workspaceConfig == workspaceConfig) {
            return;
        }
        ArrayList<XProjectManager> pmCopy = new ArrayList<XProjectManager>(this.getProjectManagers());
        for (XProjectManager projectManager : pmCopy) {
            this.removeProject(projectManager);
        }
        this.projectName2ProjectManager.clear();
        this.fullIndex.clear();
        this.workspaceConfig = workspaceConfig;
        for (IProjectConfig projectConfig : this.getWorkspaceConfig().getProjects()) {
            this.addProject(projectConfig);
        }
    }

    public synchronized void addProject(IProjectConfig projectConfig) {
        XProjectManager projectManager = (XProjectManager)this.projectManagerProvider.get();
        ProjectDescription projectDescription = this.projectDescriptionFactory.getProjectDescription(projectConfig);
        projectManager.initialize(projectDescription, projectConfig, this.openedDocumentsContentProvider, (Provider<Map<String, ResourceDescriptionsData>>)((Provider)() -> this.fullIndex));
        this.projectName2ProjectManager.put(projectDescription.getName(), projectManager);
    }

    protected synchronized void removeProject(XProjectManager projectManager) {
        this.removeProject(projectManager.getProjectConfig());
    }

    public synchronized void removeProject(IProjectConfig projectConfig) {
        String projectName = projectConfig.getName();
        XProjectManager projectManager = this.getProjectManager(projectName);
        XtextResourceSet resourceSet = projectManager.getResourceSet();
        boolean wasDeliver = resourceSet.eDeliver();
        try {
            resourceSet.eSetDeliver(false);
            resourceSet.getResources().clear();
        }
        finally {
            resourceSet.eSetDeliver(wasDeliver);
        }
        this.projectName2ProjectManager.remove(projectName);
        this.fullIndex.remove(projectName);
    }

    public IWorkspaceConfig getWorkspaceConfig() throws ResponseErrorException {
        if (this.workspaceConfig == null) {
            ResponseError error = new ResponseError(ResponseErrorCode.serverNotInitialized, "Workspace has not been initialized yet.", null);
            throw new ResponseErrorException(error);
        }
        return this.workspaceConfig;
    }

    public URI getBaseDir() {
        if (this.workspaceConfig == null) {
            return null;
        }
        return ((XIWorkspaceConfig)this.workspaceConfig).getPath();
    }

    protected void afterBuild(List<IResourceDescription.Delta> deltas) {
        for (ILanguageServerAccess.IBuildListener listener : this.buildListeners) {
            listener.afterBuild(deltas);
        }
    }

    public XBuildManager.XBuildable didOpen(URI uri, Integer version, String contents) {
        this.openDocuments.put(uri, new XDocument(version, contents));
        WorkspaceChanges workspaceChanges = WorkspaceChanges.NO_CHANGES;
        return this.getIncrementalDirtyBuildable(workspaceChanges);
    }

    public XBuildManager.XBuildable didChangeFiles(List<URI> dirtyFiles, List<URI> deletedFiles) {
        WorkspaceChanges workspaceChanges = WorkspaceChanges.createUrisRemovedAndChanged(deletedFiles, dirtyFiles);
        return this.tryIncrementalGenerateBuildable(workspaceChanges);
    }

    public void doInitialBuild(CancelIndicator cancelIndicator) {
        ArrayList<ProjectDescription> newProjects = new ArrayList<ProjectDescription>();
        for (IProjectConfig projectConfig : this.getWorkspaceConfig().getProjects()) {
            ProjectDescription projectDescription = this.projectDescriptionFactory.getProjectDescription(projectConfig);
            newProjects.add(projectDescription);
        }
        List<IResourceDescription.Delta> deltas = this.buildManager.doInitialBuild(newProjects, cancelIndicator);
        this.afterBuild(deltas);
    }

    protected XBuildManager.XBuildable tryIncrementalGenerateBuildable(WorkspaceChanges workspaceChanges) {
        if (this.isDirty()) {
            return this.getIncrementalDirtyBuildable(workspaceChanges);
        }
        return this.getIncrementalGenerateBuildable(workspaceChanges);
    }

    protected XBuildManager.XBuildable getIncrementalDirtyBuildable(WorkspaceChanges workspaceChanges) {
        XBuildManager.XBuildable buildable = this.buildManager.getIncrementalDirtyBuildable(workspaceChanges);
        return cancelIndicator -> {
            List<IResourceDescription.Delta> deltas = buildable.build(cancelIndicator);
            this.afterBuild(deltas);
            return deltas;
        };
    }

    protected XBuildManager.XBuildable getIncrementalGenerateBuildable(WorkspaceChanges workspaceChanges) {
        XBuildManager.XBuildable buildable = this.buildManager.getIncrementalGenerateBuildable(workspaceChanges);
        return cancelIndicator -> {
            List<IResourceDescription.Delta> deltas = buildable.build(cancelIndicator);
            this.afterBuild(deltas);
            LOG.info((Object)"Output files generated.");
            return deltas;
        };
    }

    public XBuildManager.XBuildable didChangeTextDocumentContent(URI uri, Integer version, Iterable<TextDocumentContentChangeEvent> changes) {
        XDocument contents = this.openDocuments.get(uri);
        if (contents == null) {
            LOG.error((Object)("The document " + uri + " has not been opened."));
            return XBuildManager.XBuildable.NO_BUILD;
        }
        this.openDocuments.put(uri, (XDocument)contents.applyTextDocumentChanges(changes));
        WorkspaceChanges workspaceChanges = WorkspaceChanges.createUrisChanged((List)ImmutableList.of((Object)uri));
        return this.getIncrementalDirtyBuildable(workspaceChanges);
    }

    public XBuildManager.XBuildable didSave(URI uri) {
        XDocument document = this.openDocuments.computeIfPresent(uri, (any, doc) -> {
            if (doc.isDirty()) {
                return doc.save();
            }
            return doc;
        });
        if (document == null) {
            LOG.error((Object)("The document " + uri + " has not been opened."));
            return XBuildManager.XBuildable.NO_BUILD;
        }
        WorkspaceChanges notifiedChanges = WorkspaceChanges.createUrisChanged((List)ImmutableList.of((Object)uri));
        WorkspaceChanges workspaceChanges = ((XIWorkspaceConfig)this.getWorkspaceConfig()).update(uri, projectName -> this.projectName2ProjectManager.get(projectName).getProjectDescription());
        workspaceChanges.merge(notifiedChanges);
        return this.tryIncrementalGenerateBuildable(workspaceChanges);
    }

    public XBuildManager.XBuildable didClose(URI uri) {
        this.openDocuments.remove(uri);
        if (this.exists(uri)) {
            WorkspaceChanges workspaceChanges = WorkspaceChanges.createUrisChanged((List)ImmutableList.of((Object)uri));
            return this.tryIncrementalGenerateBuildable(workspaceChanges);
        }
        WorkspaceChanges workspaceChanges = WorkspaceChanges.createUrisRemoved((List)ImmutableList.of((Object)uri));
        return this.tryIncrementalGenerateBuildable(workspaceChanges);
    }

    public XBuildManager.XBuildable closeAll() {
        ImmutableList closed = ImmutableList.copyOf(this.openDocuments.keySet());
        this.openDocuments.clear();
        WorkspaceChanges workspaceChanges = WorkspaceChanges.createUrisChanged((List)closed);
        return this.tryIncrementalGenerateBuildable(workspaceChanges);
    }

    public boolean isDocumentOpen(URI uri) {
        return this.openDocuments.containsKey(uri);
    }

    public URI getProjectBaseDir(URI uri) {
        IProjectConfig projectConfig = this.getProjectConfig(uri);
        if (projectConfig != null) {
            return projectConfig.getPath();
        }
        return null;
    }

    public XProjectManager getProjectManager(URI uri) {
        IProjectConfig projectConfig = this.getProjectConfig(uri);
        String name = null;
        if (projectConfig != null) {
            name = projectConfig.getName();
        }
        return this.getProjectManager(name);
    }

    public IProjectConfig getProjectConfig(URI uri) {
        return this.getWorkspaceConfig().findProjectContaining(uri);
    }

    public Collection<XProjectManager> getProjectManagers() {
        return Collections.unmodifiableCollection(this.projectName2ProjectManager.values());
    }

    public XProjectManager getProjectManager(String projectName) {
        return this.projectName2ProjectManager.get(projectName);
    }

    public void clean(CancelIndicator cancelIndicator) {
        this.buildManager.doClean(cancelIndicator);
    }

    public IResourceDescriptions getIndex() {
        return new ChunkedResourceDescriptions(this.fullIndex);
    }

    protected boolean exists(URI uri) {
        XtextResourceSet rs;
        XProjectManager projectManager = this.getProjectManager(uri);
        if (projectManager != null && (rs = projectManager.getResourceSet()) != null) {
            return rs.getURIConverter().exists(uri, null);
        }
        return false;
    }

    @Override
    public XtextResource getResource(URI uri) {
        URI resourceURI = uri.trimFragment();
        XProjectManager projectMnr = this.getProjectManager(resourceURI);
        if (projectMnr != null) {
            XtextResource resource = (XtextResource)projectMnr.getResource(resourceURI);
            return resource;
        }
        return null;
    }

    @Override
    public XDocument getDocument(URI uri) {
        XDocument doc = this.openDocuments.get(uri);
        if (doc != null) {
            return doc;
        }
        XtextResource resource = this.getResource(uri);
        if (resource == null) {
            return null;
        }
        return this.getDocument(resource);
    }

    @Override
    public XDocument getDocument(XtextResource resource) {
        if (resource == null) {
            return null;
        }
        XDocument doc = this.openDocuments.get(resource.getURI());
        if (doc != null) {
            return doc;
        }
        String text = resource.getParseResult().getRootNode().getText();
        return new XDocument(1, text);
    }

    public URI makeWorkspaceRelative(URI uri) {
        URI withEmptyAuthority = this.uriExtensions.withEmptyAuthority(uri);
        URI relativeUri = withEmptyAuthority.deresolve(this.getBaseDir());
        return relativeUri;
    }
}

