/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server.build;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ide.xtext.server.build.XBuildContext;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.IResourceServiceProviderExtension;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.persistence.SourceLevelURIsAdapter;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class XClusteringStorageAwareResourceLoader {
    private final XBuildContext context;

    public XClusteringStorageAwareResourceLoader(XBuildContext context) {
        this.context = context;
    }

    public <T> List<T> executeClustered(Iterable<URI> uris, Functions.Function1<? super Resource, ? extends T> operation) {
        int loadedURIsCount = 0;
        HashSet<URI> sourceLevelURIs = new HashSet<URI>();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        ArrayList result = new ArrayList();
        for (URI uri : uris) {
            XtextResourceSet resourceSet = this.context.getResourceSet();
            if (!this.context.getClusteringPolicy().continueProcessing((ResourceSet)resourceSet, uri, loadedURIsCount)) {
                result.addAll(ListExtensions.map(resources, arg_0 -> operation.apply(arg_0)));
                this.clearResourceSet();
                resources.clear();
                loadedURIsCount = 0;
            }
            ++loadedURIsCount;
            if (this.isSource(uri)) {
                sourceLevelURIs.add(uri);
                Resource existingResource = resourceSet.getResource(uri, false);
                if (existingResource instanceof StorageAwareResource && ((StorageAwareResource)existingResource).isLoadedFromStorage()) {
                    existingResource.unload();
                }
                SourceLevelURIsAdapter.setSourceLevelUrisWithoutCopy((ResourceSet)resourceSet, sourceLevelURIs);
            }
            resources.add(resourceSet.getResource(uri, true));
        }
        result.addAll(ListExtensions.map(resources, arg_0 -> operation.apply(arg_0)));
        return result;
    }

    protected boolean isSource(URI uri) {
        IResourceServiceProvider provider = this.context.getResourceServiceProvider(uri);
        return provider instanceof IResourceServiceProviderExtension && ((IResourceServiceProviderExtension)provider).isSource(uri);
    }

    protected void clearResourceSet() {
        XtextResourceSet resourceSet = this.context.getResourceSet();
        boolean wasDeliver = resourceSet.eDeliver();
        try {
            resourceSet.eSetDeliver(false);
            resourceSet.getResources().clear();
        }
        finally {
            resourceSet.eSetDeliver(wasDeliver);
        }
    }
}

