/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.config;

import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.ControlDecorationProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;

public class RenderErrorHandling
extends AbstractEditErrorHandler {
    protected IStyle defaultErrorStyle = new Style();
    protected Color originalFgColor;
    protected Color originalBgColor;
    protected Font originalFont;
    protected IStyle errorStyle;
    protected final ControlDecorationProvider decorationProvider;
    private boolean errorStylingActive;

    public RenderErrorHandling() {
        this((ControlDecorationProvider)null);
    }

    public RenderErrorHandling(ControlDecorationProvider decorationProvider) {
        this(null, decorationProvider);
    }

    public RenderErrorHandling(IEditErrorHandler underlyingErrorHandler, ControlDecorationProvider decorationProvider) {
        super(underlyingErrorHandler);
        this.defaultErrorStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, GUIHelper.COLOR_RED);
        this.errorStylingActive = false;
        this.decorationProvider = decorationProvider;
        this.errorStyle = this.defaultErrorStyle;
    }

    @Override
    public void removeError(ICellEditor cellEditor) {
        super.removeError(cellEditor);
        if (this.errorStylingActive) {
            Control editorControl = cellEditor.getEditorControl();
            editorControl.setBackground(this.originalBgColor);
            editorControl.setForeground(this.originalFgColor);
            editorControl.setFont(this.originalFont);
            this.originalBgColor = null;
            this.originalFgColor = null;
            this.originalFont = null;
            if (this.decorationProvider != null) {
                this.decorationProvider.hideDecoration();
            }
            this.errorStylingActive = false;
        }
    }

    @Override
    public void displayError(ICellEditor cellEditor, Exception e) {
        super.displayError(cellEditor, e);
        if (!this.errorStylingActive) {
            Control editorControl = cellEditor.getEditorControl();
            this.originalBgColor = editorControl.getBackground();
            this.originalFgColor = editorControl.getForeground();
            this.originalFont = editorControl.getFont();
            editorControl.setBackground(this.errorStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
            editorControl.setForeground(this.errorStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
            editorControl.setFont(this.errorStyle.getAttributeValue(CellStyleAttributes.FONT));
            if (this.decorationProvider != null) {
                this.decorationProvider.showDecoration();
            }
            this.errorStylingActive = true;
        }
    }

    public void setErrorStyle(IStyle errorStyle) {
        this.errorStyle = errorStyle != null ? errorStyle : this.defaultErrorStyle;
    }
}

