/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.event.FilterAppliedEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.nebula.widgets.nattable.util.PersistenceUtils;

public class FilterRowDataProvider<T>
implements IDataProvider,
IPersistable {
    private static final Log log = LogFactory.getLog(FilterRowDataProvider.class);
    public static final String PIPE_REPLACEMENT = "\u00b0~\u00b0";
    public static final String FILTER_COLLECTION_PREFIX = "\u00b0coll(";
    private final IFilterStrategy<T> filterStrategy;
    private final ILayer columnHeaderLayer;
    private final IDataProvider columnHeaderDataProvider;
    private final IConfigRegistry configRegistry;
    private Map<Integer, Object> filterIndexToObjectMap = new HashMap<Integer, Object>();

    public FilterRowDataProvider(IFilterStrategy<T> filterStrategy, ILayer columnHeaderLayer, IDataProvider columnHeaderDataProvider, IConfigRegistry configRegistry) {
        this.filterStrategy = filterStrategy;
        this.columnHeaderLayer = columnHeaderLayer;
        this.columnHeaderDataProvider = columnHeaderDataProvider;
        this.configRegistry = configRegistry;
    }

    public Map<Integer, Object> getFilterIndexToObjectMap() {
        return this.filterIndexToObjectMap;
    }

    public void setFilterIndexToObjectMap(Map<Integer, Object> filterIndexToObjectMap) {
        this.filterIndexToObjectMap = filterIndexToObjectMap;
    }

    @Override
    public int getColumnCount() {
        return this.columnHeaderDataProvider.getColumnCount();
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        return this.filterIndexToObjectMap.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        columnIndex = this.columnHeaderLayer.getColumnIndexByPosition(columnIndex);
        if (ObjectUtils.isNotNull(newValue)) {
            this.filterIndexToObjectMap.put(columnIndex, newValue);
        } else {
            this.filterIndexToObjectMap.remove(columnIndex);
        }
        this.filterStrategy.applyFilter(this.filterIndexToObjectMap);
        this.columnHeaderLayer.fireLayerEvent(new FilterAppliedEvent(this.columnHeaderLayer));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        HashMap<Integer, String> filterTextByIndex = new HashMap<Integer, String>();
        for (Integer columnIndex : this.filterIndexToObjectMap.keySet()) {
            IDisplayConverter converter = this.configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "NORMAL", "FILTER_COLUMN_" + columnIndex);
            String filterText = this.getFilterStringRepresentation(this.filterIndexToObjectMap.get(columnIndex), converter);
            filterText = filterText.replace("|", PIPE_REPLACEMENT);
            filterTextByIndex.put(columnIndex, filterText);
        }
        String string = PersistenceUtils.mapAsString(filterTextByIndex);
        if (!ObjectUtils.isEmpty(string)) {
            properties.put(String.valueOf(prefix) + ".filterTokens", string);
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.filterIndexToObjectMap.clear();
        try {
            Object property = properties.get(String.valueOf(prefix) + ".filterTokens");
            Map<Integer, String> filterTextByIndex = PersistenceUtils.parseString(property);
            for (Integer columnIndex : filterTextByIndex.keySet()) {
                IDisplayConverter converter = this.configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "NORMAL", "FILTER_COLUMN_" + columnIndex);
                String filterText = filterTextByIndex.get(columnIndex);
                filterText = filterText.replace(PIPE_REPLACEMENT, "|");
                this.filterIndexToObjectMap.put(columnIndex, this.getFilterFromString(filterText, converter));
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while restoring filter row text!", (Throwable)e);
        }
        this.filterStrategy.applyFilter(this.filterIndexToObjectMap);
    }

    private String getFilterStringRepresentation(Object filterValue, IDisplayConverter converter) {
        if (filterValue instanceof Collection) {
            String collectionSpec = FILTER_COLLECTION_PREFIX + filterValue.getClass().getName() + ")";
            StringBuilder builder = new StringBuilder(collectionSpec);
            builder.append("[");
            Collection filterCollection = (Collection)filterValue;
            Iterator iterator = filterCollection.iterator();
            while (iterator.hasNext()) {
                Object filterObject = iterator.next();
                builder.append(converter.canonicalToDisplayValue(filterObject));
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            builder.append("]");
            return builder.toString();
        }
        return (String)converter.canonicalToDisplayValue(filterValue);
    }

    private Object getFilterFromString(String filterText, IDisplayConverter converter) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (filterText.startsWith(FILTER_COLLECTION_PREFIX)) {
            String[] filterSplit;
            int indexEndCollSpec = filterText.indexOf(")");
            String collectionSpec = filterText.substring(filterText.indexOf("(") + 1, indexEndCollSpec);
            Collection filterCollection = (Collection)Class.forName(collectionSpec).newInstance();
            filterText = filterText.substring(indexEndCollSpec + 2, filterText.length() - 1);
            String[] stringArray = filterSplit = filterText.split(",");
            int n = filterSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String filterString = stringArray[n2];
                filterCollection.add(converter.displayToCanonicalValue(filterString));
                ++n2;
            }
            return filterCollection;
        }
        return converter.displayToCanonicalValue(filterText);
    }

    public void clearAllFilters() {
        this.filterIndexToObjectMap.clear();
        this.filterStrategy.applyFilter(this.filterIndexToObjectMap);
    }
}

