/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.freeze;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.freeze.event.FreezeEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.AbstractIndexLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;

public class FreezeLayer
extends AbstractIndexLayerTransform {
    public static final String PERSISTENCE_TOP_LEFT_POSITION = ".freezeTopLeftPosition";
    public static final String PERSISTENCE_BOTTOM_RIGHT_POSITION = ".freezeBottomRightPosition";
    private PositionCoordinate topLeftPosition = new PositionCoordinate(this, -1, -1);
    private PositionCoordinate bottomRightPosition = new PositionCoordinate(this, -1, -1);

    public FreezeLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
        this.registerEventHandler(new FreezeEventHandler(this));
    }

    public boolean isFrozen() {
        return this.getColumnCount() > 0 || this.getRowCount() > 0;
    }

    public PositionCoordinate getTopLeftPosition() {
        return this.topLeftPosition;
    }

    public void setTopLeftPosition(int leftColumnPosition, int topRowPosition) {
        this.topLeftPosition = new PositionCoordinate(this, leftColumnPosition, topRowPosition);
    }

    public PositionCoordinate getBottomRightPosition() {
        return this.bottomRightPosition;
    }

    public void setBottomRightPosition(int rightColumnPosition, int bottomRowPosition) {
        this.bottomRightPosition = new PositionCoordinate(this, rightColumnPosition, bottomRowPosition);
    }

    @Override
    public int getColumnCount() {
        if (this.topLeftPosition.columnPosition >= 0 && this.bottomRightPosition.columnPosition >= 0) {
            return this.bottomRightPosition.columnPosition - this.topLeftPosition.columnPosition + 1;
        }
        return 0;
    }

    @Override
    public int getPreferredColumnCount() {
        return this.getColumnCount();
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        if (this.topLeftPosition.columnPosition >= 0) {
            return this.topLeftPosition.columnPosition + localColumnPosition;
        }
        return -1;
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (sourceUnderlyingLayer != this.getUnderlyingLayer()) {
            return -1;
        }
        if (underlyingColumnPosition >= this.topLeftPosition.columnPosition && underlyingColumnPosition <= this.bottomRightPosition.columnPosition) {
            return underlyingColumnPosition - this.topLeftPosition.columnPosition;
        }
        return -1;
    }

    @Override
    public int getWidth() {
        int width = 0;
        int columnPosition = 0;
        while (columnPosition < this.getColumnCount()) {
            width += this.getColumnWidthByPosition(columnPosition);
            ++columnPosition;
        }
        return width;
    }

    @Override
    public int getPreferredWidth() {
        return this.getWidth();
    }

    @Override
    public int getColumnPositionByX(int x) {
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        int xOffset = underlyingLayer.getStartXOfColumnPosition(this.topLeftPosition.columnPosition);
        return this.underlyingToLocalColumnPosition(underlyingLayer, underlyingLayer.getColumnPositionByX(xOffset + x));
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        if (columnPosition < 0 || columnPosition >= this.getColumnCount()) {
            return -1;
        }
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        int underlyingColumnPosition = LayerUtil.convertColumnPosition(this, columnPosition, underlyingLayer);
        if (underlyingColumnPosition < 0) {
            return -1;
        }
        return underlyingLayer.getStartXOfColumnPosition(underlyingColumnPosition) - underlyingLayer.getStartXOfColumnPosition(this.topLeftPosition.columnPosition);
    }

    @Override
    public int getRowCount() {
        if (this.topLeftPosition.rowPosition >= 0 && this.bottomRightPosition.rowPosition >= 0) {
            int frozenRowCount = this.bottomRightPosition.rowPosition - this.topLeftPosition.rowPosition + 1;
            int underlyingRowCount = this.getUnderlyingLayer().getRowCount();
            return frozenRowCount <= underlyingRowCount ? frozenRowCount : 0;
        }
        return 0;
    }

    @Override
    public int getPreferredRowCount() {
        return this.getRowCount();
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        if (this.topLeftPosition.rowPosition >= 0) {
            return this.topLeftPosition.rowPosition + localRowPosition;
        }
        return -1;
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        if (sourceUnderlyingLayer != this.getUnderlyingLayer()) {
            return -1;
        }
        if (underlyingRowPosition >= this.topLeftPosition.rowPosition && underlyingRowPosition <= this.bottomRightPosition.rowPosition) {
            return underlyingRowPosition - this.topLeftPosition.rowPosition;
        }
        return -1;
    }

    @Override
    public int getHeight() {
        int height = 0;
        int rowPosition = 0;
        while (rowPosition < this.getRowCount()) {
            height += this.getRowHeightByPosition(rowPosition);
            ++rowPosition;
        }
        return height;
    }

    @Override
    public int getPreferredHeight() {
        return this.getHeight();
    }

    @Override
    public int getRowPositionByY(int y) {
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        int yOffset = underlyingLayer.getStartYOfRowPosition(this.topLeftPosition.rowPosition);
        return this.underlyingToLocalRowPosition(underlyingLayer, underlyingLayer.getRowPositionByY(yOffset + y));
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        if (rowPosition < 0 || rowPosition >= this.getRowCount()) {
            return -1;
        }
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        int underlyingRowPosition = LayerUtil.convertRowPosition(this, rowPosition, underlyingLayer);
        if (underlyingRowPosition < 0) {
            return -1;
        }
        return underlyingLayer.getStartYOfRowPosition(underlyingRowPosition) - underlyingLayer.getStartYOfRowPosition(this.topLeftPosition.rowPosition);
    }
}

