/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.swt.graphics.Rectangle;

public abstract class ColumnVisualChangeEvent
implements IVisualChangeEvent {
    private ILayer layer;
    private Collection<Range> columnPositionRanges;

    public ColumnVisualChangeEvent(ILayer layer, Range ... columnPositionRanges) {
        this(layer, Arrays.asList(columnPositionRanges));
    }

    public ColumnVisualChangeEvent(ILayer layer, Collection<Range> columnPositionRanges) {
        this.layer = layer;
        this.columnPositionRanges = columnPositionRanges;
    }

    protected ColumnVisualChangeEvent(ColumnVisualChangeEvent event) {
        this.layer = event.layer;
        this.columnPositionRanges = event.columnPositionRanges;
    }

    @Override
    public ILayer getLayer() {
        return this.layer;
    }

    public Collection<Range> getColumnPositionRanges() {
        return this.columnPositionRanges;
    }

    protected void setColumnPositionRanges(Collection<Range> columnPositionRanges) {
        this.columnPositionRanges = columnPositionRanges;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        this.columnPositionRanges = localLayer.underlyingToLocalColumnPositions(this.layer, this.columnPositionRanges);
        this.layer = localLayer;
        return this.columnPositionRanges != null && this.columnPositionRanges.size() > 0;
    }

    @Override
    public Collection<Rectangle> getChangedPositionRectangles() {
        ArrayList<Rectangle> changedPositionRectangles = new ArrayList<Rectangle>();
        int rowCount = this.layer.getRowCount();
        for (Range range : this.columnPositionRanges) {
            changedPositionRectangles.add(new Rectangle(range.start, 0, range.end - range.start, rowCount));
        }
        return changedPositionRectangles;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

